// AlphaScriptHost.h
// (c) 2003-2006 exeal

#ifndef ALPHA_SCRIPT_HOST_H_
#define ALPHA_SCRIPT_HOST_H_

#include <activscp.h>	// IActiveScriptSite, IActiveScriptSiteWindow
#include <ocidl.h>		// IConnectionPoint, ...
#include "../Armaiti/UnknownImpl.hpp"
#include <string>
#include <map>
#include <stdexcept>
#ifdef IMPLEMENT_DEBUGGER_HOST
#include <activdbg.h>	// IActiveScriptSiteDebug
#endif /* IMPLEMENT_DEBUGGER_HOST */

// IInternetHostSecurityManager::GetSecurityId 3̌^̖
#if(_MSC_VER < 1300)	// -VC6
#define IIHSMGSI_3RD_PARAM_TYPE	DWORD
#else					// VC7-
#define IIHSMGSI_3RD_PARAM_TYPE	DWORD_PTR
#endif

namespace Alpha {

/// XNvgzXg̃ZLeBx
enum ScriptSiteSecurityLevel {
	SSSL_ALLOW,		///< 
	SSSL_QUERYUSER,	///< [Uɖ₢킹
	SSSL_DISALLOW,	///< 
};


/**
 *	@brief	XNvgzXg
 *
 *	̃XNvgzXg Alpha ̂߂ɍ쐬A
 *	̃AvP[Vɑgݍ߂悤ɂĂB
 *	[UC^[tFCX͓{ꂩp̂ꂩŁA
 *	[Ǔꎯʎq玩IɌ肳 (Iɒm肽ꍇ
 *	IActiveScriptSite::GetLCID gƂ悢)
 *
 *	<del>fobK̃zXgƂĂĂ邪A܂SłȂ</del>
 *
 *	zQƂ邽߂ɁA̎ɂ̓NCAg͈ȉ̂悤ɃGW
 *	IActiveScript::Close 𖾎IɌĂяoȂ΂ȂȂ:
 *
 *	@code
 *	extern Alpha::AlphaScriptHost* host;
 *	IActiveScript* engine;	// engine's Close invocation start...
 *	host->getScriptEngine(engine);
 *	engine->Close();
 *	engine->Release();		// ...end
 *	host->Release();		// <- and we also release the host object
 *	@endcode
 *
 *	AlphaScriptHost ̃fXgN^ Close ĂяosA
 *	GW̎QƂ폜ȂƃfXgN^͉ivɌĂяoȂB
 *	AlphaScriptHost::closeEngine ͏̃R[h2sڂ5sڂ܂łȗ
 *
 *	@code
 *	extern Alpha::AlphaScriptHost* host;
 *	host->closeEngine();
 *	host->Release();
 *	@endcode
 */
class AlphaScriptHost :
		virtual public IActiveScriptSite,
		virtual public IActiveScriptSiteWindow,
#ifdef IMPLEMENT_INTERRUPT_POLL
		virtual public IActiveScriptSiteInterruptPoll,
#endif /* IMPLEMENT_INTERRUPT_POLL */
#ifdef IMPLEMENT_DEBUGGER_HOST
		virtual public IActiveScriptSiteDebug,
#endif /* IMPLEMENT_DEBUGGER_HOST */
		virtual public IServiceProvider,
		virtual public IInternetHostSecurityManager {
public:
	// RXgN^
public:
	AlphaScriptHost(HWND window, IActiveScript& scriptEngine);
	virtual ~AlphaScriptHost();

	// \bh
public:
	void			addTopLevelObject(const OLECHAR* objectName, IDispatch& object, DWORD itemTraits);
	void			allowErrorReport(bool allow) throw();
	static HRESULT	callFunction(IDispatch& function, LCID lcid = LOCALE_USER_DEFAULT,
						DISPPARAMS* params = 0, VARIANT* result = 0, EXCEPINFO* exception = 0);
#ifdef __IDispatchEx_INTERFACE_DEFINED__
	static HRESULT	callFunction(IDispatchEx& function, IDispatch& thisArg, LCID lcid = LOCALE_USER_DEFAULT,
						DISPPARAMS* params = 0, VARIANT* result = 0, EXCEPINFO* exception = 0);
#endif /* __IDispatchEx_INTERFACE_DEFINED__ */
	HRESULT			closeEngine() throw();
	HRESULT			connectObject(IDispatch& object, const OLECHAR* prefix);
	HRESULT			disconnectObject(IDispatch& object);
	static void		findScriptEngine(const wchar_t* fileName, CLSID& clsid);
	void			getScriptEngine(IActiveScript*& scriptEngine) const throw();
	const WCHAR*	getScriptFileName() const throw();
	unsigned long	getTimeout() const throw();
	bool			isInteractive() const throw();
	bool			loadConstants(ITypeLib& typeLib, GUID guid = GUID_NULL);
	void			releaseTopLevelObjects();
	void			setInteractiveMode(bool interactive) throw();
	void			setScriptFileName(const WCHAR* scriptPath) throw();
	void			setSecurityLevel(bool forSafeObject, ScriptSiteSecurityLevel securityLevel);
	void			setTimeout(unsigned long milliseconds);
	void			sleep(unsigned long milliseconds);
private:
	void	disconnectAllObjects();
	HRESULT	invokeScriptGlobalProcedure(const OLECHAR* name, LCID lcid, DISPPARAMS* params);

public:
	// IUnknown \bh
	IMPLEMENT_UNKNOWN_MULTI_THREADED()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IActiveScriptSite)
		IMPLEMENTS_INTERFACE(IActiveScriptSiteWindow)
#ifdef IMPLEMENT_INTERRUPT_POLL
		IMPLEMENTS_INTERFACE(IActiveScriptSiteInterruptPoll)
#endif /* IMPLEMENT_INTERRUPT_POLL */
#ifdef IMPLEMENT_DEBUGGER_HOST
		IMPLEMENTS_INTERFACE(IActiveScriptSiteDebug)
#endif /* IMPLEMENT_DEBUGGER_HOST */
		IMPLEMENTS_INTERFACE(IServiceProvider)
		IMPLEMENTS_INTERFACE(IInternetHostSecurityManager)
	END_INTERFACE_TABLE()

	// IActiveScriptSite \bh
	STDMETHODIMP	GetLCID(LCID* plcid);
	STDMETHODIMP	GetItemInfo(LPCOLESTR pstrName,
						DWORD dwReturnMask, IUnknown** ppiunkItem, ITypeInfo** ppti);
	STDMETHODIMP	GetDocVersionString(BSTR* pbstrVersion);
	STDMETHODIMP	OnScriptTerminate(const VARIANT* pvarResult, const EXCEPINFO* pexcepinfo);
	STDMETHODIMP	OnStateChange(SCRIPTSTATE ssScriptState);
	STDMETHODIMP	OnScriptError(IActiveScriptError* pscripterror);
	STDMETHODIMP	OnEnterScript();
	STDMETHODIMP	OnLeaveScript();

	// IActiveScriptSiteWindow \bh
	STDMETHODIMP	GetWindow(HWND* phwnd);
	STDMETHODIMP	EnableModeless(BOOL fEnable);

#ifdef IMPLEMENT_DEBUGGER_HOST
	// IActiveScriptSiteDebug \bh
	STDMETHODIMP	GetDocumentContextFromPosition(DWORD dwSourceContext,
						ULONG uCharacterOffset, ULONG uNumChars, IDebugDocumentContext** ppsc);
	STDMETHODIMP	GetApplication(IDebugApplication** ppda);
	STDMETHODIMP	GetRootApplicationNode(IDebugApplicationNode** ppdanRoot);
	STDMETHODIMP	OnScriptErrorDebug(IActiveScriptErrorDebug* pErrorDebug,
						BOOL* pfEnterDebugger, BOOL* pfCallOnScriptErrorWhenContinuing);
#endif /* IMPLEMENT_DEBUGGER_HOST */

#ifdef IMPLEMENT_INTERRUPT_POLL
	// IActiveScriptSiteInterruptPoll \bh
	STDMETHODIMP	QueryContinue();
#endif /* IMPLEMENT_INTERRUPT_POLL */

	// IServiceProvider \bh
	STDMETHODIMP	QueryService(REFGUID guidService, REFIID riid, void** ppvObject);

	// IInternetHostSecurityManager \bh
	STDMETHODIMP	GetSecurityId(BYTE* pbSecurityId, DWORD* pcbSecurityId, IIHSMGSI_3RD_PARAM_TYPE dwReserved);
	STDMETHODIMP	ProcessUrlAction(DWORD dwAction, BYTE* pPolicy, DWORD cbPolicy,
						BYTE* pContext, DWORD cbContext, DWORD dwFlags, DWORD dwReserved);
	STDMETHODIMP	QueryCustomPolicy(REFGUID guidKey, BYTE** ppPolicy, DWORD* pcbPolicy,
						BYTE *pContext, DWORD cbContext, DWORD dwReserved);

private:
	/// AlphaScriptHost::connectObject AAlphaScriptHost::disconnectObject
	/// ̂ɎgAhzbNȃCxgVNIuWFNg
	class AdhocEventSink : virtual public IDispatch {
		// RXgN^
	public:
		AdhocEventSink(IActiveScript& scriptEngine, const IID& eventIID, const std::wstring& prefix);
		~AdhocEventSink();

		// \bh
	public:
		HRESULT	connect(IConnectionPoint& connectionPoint);
		HRESULT	disconnect();

		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		STDMETHODIMP	QueryInterface(REFIID riid, void** ppvObject);

		// IDispatch C^[tFCX
		STDMETHODIMP	GetTypeInfoCount(UINT* pcTypeInfo);
		STDMETHODIMP	GetTypeInfo(UINT iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo);
		STDMETHODIMP	GetIDsOfNames(REFIID riid,
							OLECHAR** rgszNames, unsigned int cNames, LCID lcid, DISPID* rgDispId);
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// f[^o
	private:
		IActiveScript&					scriptEngine_;
		IConnectionPointContainer*		connectionPointContainer_;	// ڑ|Cg (̃Rei)
		const IID						eventIID_;		// G~[gC^[tFCX IID
		const std::wstring				prefix_;		// Cxgnh̐ړ
		DWORD							cookie_;		// Advise Ɏ擾NbL[
		std::map<std::wstring, DISPID>	events_;
		std::map<DISPID, std::wstring>	handlers_;
	};

	/// 񋓂̑Ȏ
	class EnumImpl : virtual public IDispatch {
		// RXgN^
	public:
		EnumImpl() {}

		// \bh
	public:
		void	addProperty(const OLECHAR* name, long value);

		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	GetTypeInfoCount(UINT* pcTypeInfo);
		STDMETHODIMP	GetTypeInfo(UINT iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo);
		STDMETHODIMP	GetIDsOfNames(REFIID riid, LPOLESTR* rgszNames, UINT cNames, LCID lcid, DISPID* rgDispId);
		STDMETHODIMP	Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
							DISPPARAMS *pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, UINT* puArgErr);

		// f[^o
	private:
		typedef std::map<std::wstring, DISPID> NameToIDTable;
		typedef std::map<DISPID, long> IDToValueTable;
		NameToIDTable nameTable_;
		IDToValueTable idTable_;
	};

	typedef std::map<std::wstring, IDispatch*> MemberTable;
	typedef std::map<IDispatch*, AdhocEventSink*> EventSinkTable;

	// f[^o
public:
	static const wchar_t*		NAME;
	static const unsigned short	MAJOR_VERSION;
	static const unsigned short	MINOR_VERSION;
	static const unsigned short	BUILD_VERSION;
private:
	HWND					ownerWindow_;		// zXgEBhE
	MemberTable				topLevelObjects_;	// gbvxIuWFNg
	IActiveScript&			scriptEngine_;		// XNvgGW
	EventSinkTable			eventSinks_;		// CxgVN
	ScriptSiteSecurityLevel	securityLevelForSafeObject_;
	ScriptSiteSecurityLevel	securityLevelForUnsafeObject_;
	mutable bool			isErrorReported_;		// isErrorReportedAtLastParse Q
	bool					allowedErrorReport_;	// allowErrorReport Q
	wchar_t					scriptFileName_[MAX_PATH];
	bool					enteredScript_;
	bool					interactive_;	// Θb[h
	unsigned long			timeout_;		// ^CAEg (~b)
};



// AlphaScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

/// XNvgG[Ƀ_CAOoǂݒ肷
inline void AlphaScriptHost::allowErrorReport(bool allow) throw() {allowedErrorReport_ = allow;}

/// XNvgGW IActiveScript::Close \bhĂяo
inline HRESULT AlphaScriptHost::closeEngine() throw() {return scriptEngine_.Close();}

/// SẴCxgIuWFNgؒf
inline void AlphaScriptHost::disconnectAllObjects() {
	for(EventSinkTable::iterator it = eventSinks_.begin(); it != eventSinks_.end(); ++it)
		disconnectObject(*it->first);
}

#ifdef IMPLEMENT_DEBUGGER_HOST
/// @see IActiveScriptSiteDebug::GetApplication
inline STDMETHODIMP CAlphaScriptHost::GetApplication(IDebugApplication** ppda) {
	VERIFY_POINTER(ppda);
	if(debugApplication_ == 0)
		return E_UNEXPECTED;
	debugApplication_->QueryInterface(IID_IDebugApplication, reinterpret_cast<void**>(ppda));
	return S_OK;
}

/// @see IActiveScriptSiteDebug::GetDocumentContextFromPosition
inline STDMETHODIMP CAlphaScriptHost::GetDocumentContextFromPosition(
		DWORD dwSourceContext, ULONG uCharacterOffset, ULONG uNumChars, IDebugDocumentContext** ppsc) {return E_NOTIMPL;}
#endif /* IMPLEMENT_DEBUGGER_HOST */

/// @see IActiveScriptSite::GetDocVersionString
inline STDMETHODIMP AlphaScriptHost::GetDocVersionString(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);
	*pbstrVersion = 0;
	return E_NOTIMPL;
}

/// @see IActiveScriptSite::GetLCID
inline STDMETHODIMP AlphaScriptHost::GetLCID(LCID* plcid) {
	VERIFY_POINTER(plcid);
	*plcid = MAKELCID((PRIMARYLANGID(::GetUserDefaultLangID()) == LANG_JAPANESE) ? 0x0411 : 0x0409, SORT_DEFAULT);
	return S_OK;
}

#ifdef IMPLEMENT_DEBUGGER_HOST
/// @see IActiveScriptSiteDebug::GetRootApplicationNode
inline STDMETHODIMP AlphaScriptHost::GetRootApplicationNode(IDebugApplicationNode** ppdanRoot) {
	VERIFY_POINTER(ppdanRoot);
	*ppdanRoot = 0;
	return E_NOTIMPL;
}
#endif /* IMPLEMENT_DEBUGGER_HOST */

/// XNvgGWԂ
inline void AlphaScriptHost::getScriptEngine(IActiveScript*& scriptEngine) const throw() {(scriptEngine = &scriptEngine_)->AddRef();}

/// XNvgt@CԂ
inline const WCHAR* AlphaScriptHost::getScriptFileName() const throw() {return scriptFileName_;}

/// @see IInternetHostSecurityManager::GetSecurityId
inline STDMETHODIMP AlphaScriptHost::GetSecurityId(
		BYTE* pbSecurityId, DWORD* pcbSecurityId, IIHSMGSI_3RD_PARAM_TYPE dwReserved) {
	pbSecurityId = 0;
	pcbSecurityId = 0;
	if(dwReserved != 0)
		return E_INVALIDARG;
	return E_NOTIMPL;
}

/// ^CAEgԂ
inline unsigned long AlphaScriptHost::getTimeout() const throw() {return timeout_;}

/// @see IActiveScriptSiteWindow::GetWindow
inline STDMETHODIMP AlphaScriptHost::GetWindow(HWND* phwnd) {
	VERIFY_POINTER(phwnd);
	*phwnd = ownerWindow_;
	return S_OK;
}

/// Θb[hԂ
inline bool AlphaScriptHost::isInteractive() const {return interactive_;}

/// @see IActiveScriptSite::OnLeaveScript
inline STDMETHODIMP AlphaScriptHost::OnLeaveScript() {
	enteredScript_ = false;
	return S_OK;
}

#ifdef IMPLEMENT_DEBUGGER_HOST
/// @see IActiveScriptSiteDebug::OnScriptErrorDebug
template<typename MatchCase, class RefCountPolicy>
inline STDMETHODIMP AlphaScriptHost<MatchCase, RefCountPolicy>::OnScriptErrorDebug(
		IActiveScriptErrorDebug* pErrorDebug, BOOL* pfEnterDebugger, BOOL* pfCallOnScriptErrorWhenContinuing) {
	::MessageBoxW(0, L"G[!", L"w", 0);
	return S_OK;
}
#endif /* IMPLEMENT_DEBUGGER_HOST */

/// @see IActiveScriptSite::OnScriptTerminate
inline STDMETHODIMP AlphaScriptHost::OnScriptTerminate(const VARIANT* pvarResult, const EXCEPINFO* pexcepinfo) {return S_OK;}

/// @see IActiveScriptSite::OnStateChange
inline STDMETHODIMP AlphaScriptHost::OnStateChange(SCRIPTSTATE ssScriptState) {return S_OK;}

#ifdef IMPLEMENT_INTERRUPT_POLL
/// @see IActiveScriptSiteInterruptPoll::QueryContinue
inline STDMETHODIMP AlphaScriptHost::QueryContinue() {return S_OK;}
#endif /* IMPLEMENT_INTERRUPT_POLL */

/// @see IServiceProvider::QueryService
inline STDMETHODIMP AlphaScriptHost::QueryService(REFGUID guidService, REFIID riid, void** ppvObject) {
	VERIFY_POINTER(ppvObject);

	if(guidService == SID_SInternetHostSecurityManager)
		return QueryInterface(riid, ppvObject);
	*ppvObject = 0;
	return E_NOINTERFACE /* SVC_E_UNKNOWNSERVICE */;
}

/// Θb[h̐ݒ
inline void AlphaScriptHost::setInteractiveMode(bool interactive) throw() {interactive_ = interactive;}

/// sXNvgpX̐ݒ (qgƂĎgp)
inline void AlphaScriptHost::setScriptFileName(const WCHAR* fileName) throw() {assert(fileName != 0); std::wcscpy(scriptFileName_, fileName);}

/**
 *	^CAEg̐ݒ
 *	@param milliseconds	^CAEg (~b)B0Ɩ
 *	@throw std::logic_error	XNvg̎sɐݒ肵悤ƂƃX[
 */
inline void AlphaScriptHost::setTimeout(unsigned long milliseconds) {
	SCRIPTSTATE	ss;
	scriptEngine_.GetScriptState(&ss);
	if(ss == SCRIPTSTATE_INITIALIZED || ss == SCRIPTSTATE_STARTED || ss == SCRIPTSTATE_CONNECTED)
		throw std::logic_error("Script is already running.");
	timeout_ = milliseconds;
}

} // namespace Alpha

#endif /* ALPHA_SCRIPT_HOST_H_ */

/* [EOF] */