// AlphaView.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "AlphaView.h"
#include "Alpha.h"
#include "CommandManager.h"
#include "Ambient.h"
#include "resource.h"
using Alpha::AlphaView;
using Alpha::AlphaDoc;
using namespace Ascension;


/// RXgN^
AlphaView::AlphaView(AlphaDoc& document) : EditView(document),
		automationTextEditor_(0), automationTextSelection_(0), automationLexer_(0), automationPrefs_(0) {
}

/// Rs[RXgN^
AlphaView::AlphaView(const AlphaView& rhs) : EditView(rhs),
		automationTextEditor_(0), automationTextSelection_(0), automationLexer_(0), automationPrefs_(0) {
}

/// fXgN^
AlphaView::~AlphaView() {
	if(automationTextEditor_ != 0) {
		automationTextEditor_->dispose();
		automationTextEditor_->Release();
	}
	if(automationTextSelection_ != 0) {
		automationTextSelection_->dispose();
		automationTextSelection_->Release();
	}
	if(automationLexer_ != 0) {
		automationLexer_->dispose();
		automationLexer_->Release();
	}
	if(automationPrefs_ != 0) {
		automationPrefs_->dispose();
		automationPrefs_->Release();
	}
}

/// ITextEditor I[g[VIuWFNgԂ
HRESULT AlphaView::getAutomation(ITextEditor*& object) const {
	AlphaView& self = *const_cast<AlphaView*>(this);
	if(self.automationTextEditor_ == 0) {
		if(self.automationTextEditor_ = new Ambient::TextEditor(AlphaApp::getInstance(), self))
			self.automationTextEditor_->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(object = automationTextEditor_)->AddRef();
	return S_OK;
}

/// ITextSelection I[g[VIuWFNgԂ
HRESULT AlphaView::getAutomation(ITextSelection*& object) const {
	AlphaView& self = *const_cast<AlphaView*>(this);
	if(self.automationTextSelection_ == 0) {
		if(self.automationTextSelection_ = new Ambient::TextSelection(self))
			self.automationTextSelection_->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(object = self.automationTextSelection_)->AddRef();
	return S_OK;
}

/// ILexer I[g[VIuWFNgԂ
HRESULT AlphaView::getAutomation(ILexer*& object) const {
	AlphaView& self = *const_cast<AlphaView*>(this);
	if(self.automationLexer_ == 0) {
		if(self.automationLexer_ = new Ambient::Lexer(self.getLexer()))
			self.automationLexer_->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(object = self.automationLexer_)->AddRef();
	return S_OK;
}

/// IEditorPreferences I[g[VIuWFNgԂ
HRESULT AlphaView::getAutomation(IEditorPreferences*& object) const {
	AlphaView& self = *const_cast<AlphaView*>(this);
	if(self.automationPrefs_ == 0) {
		if(self.automationPrefs_ = new Ambient::EditorPreferences(self))
			self.automationPrefs_->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(object = self.automationPrefs_)->AddRef();
	return S_OK;
}

/// ݈ʒu\Ԃ
const wchar_t* AlphaView::getCurrentPositionString() const {
	assertValid();

	static wchar_t format[100] = {0};

	if(format[0] == 0)
		AlphaApp::getInstance().loadString(MSG_CARET_POSITION, format, countof(format));

	static wchar_t buffer[countof(format)];
	AutoZeroCB<SCROLLINFO> si;

	getScrollInfo(SB_VERT, si, SIF_POS | SIF_RANGE);
	swprintf(buffer, format,
		getSelection().getActivePoint().getLineNumber()
			+ getLayoutSetter().getSettings().lineNumberLayout.startLine,
		columnFromChar(getSelection().getActivePoint()) + getLayoutSetter().getSettings().startChar,
		getSelection().getActivePoint().getCharNumber() + getLayoutSetter().getSettings().startChar);
	return buffer;
}

/// @see EditView::inputCharacter
bool AlphaView::inputCharacter(CodePoint cp) {
	/// L[{[h}NɋL^邽߂̃tbN
	assertValid();
	if(!EditView::inputCharacter(cp))
		return false;
	const TemporaryMacro& tm = AlphaApp::getInstance().getCommandManager().getTemporaryMacro();
	if(tm.getState() == TemporaryMacro::DEFINING)
		const_cast<TemporaryMacro&>(tm).pushCommand(CharacterInputCommand(cp));
	return true;
}

/// @see EditView::insertText
bool AlphaView::insertText(const char_t* first, const char_t* last, bool asRectangle) {
	/// L[{[h}NɋL^邽߂̃tbN
	assertValid();
	if(!EditView::insertText(first, last, asRectangle))
		return false;
	const TemporaryMacro& tm = AlphaApp::getInstance().getCommandManager().getTemporaryMacro();
	if(tm.getState() == TemporaryMacro::DEFINING)
		const_cast<TemporaryMacro&>(tm).pushCommand(TextInputCommand(string_t(first, last), asRectangle));
	return true;
}

/// @see EditView::queryInvokableLinkMessage
string_t AlphaView::queryInvokableLinkMessage(const string_t& uri) {
	return AlphaApp::getInstance().loadString(MSG_INVOKABLE_LINK_POPUP, MARGS % uri);
}

/// @see EditView::queryLineColors
void AlphaView::queryLineColors(length_t line, COLORREF& fgColor, COLORREF& bgColor) {
	// ubN}[Ns̔wiFw肷
	bgColor = getBookmarker().isBookmarked(line) ? RGB(0xF0, 0xF6, 0xFF) : -1;
}

/// @see Window::onKeyDown
bool AlphaView::onKeyDown(UINT, UINT) {
	// ̃L[蓖ĂSĖɂ
	return true;
}

/// @see Window::onSetFocus
void AlphaView::onSetFocus(HWND oldWindow) {
	EditView::onSetFocus(oldWindow);
	// obt@}l[WɎANeBuɂȂƂʒm
	AlphaApp::getInstance().getBufferList().setActive(getDocument());
}

/* [EOF] */