// AlphaView.h
// (c) 2003-2006 exeal

#ifndef ALPHA_VIEW_H_
#define ALPHA_VIEW_H_
#include "Ascension\EditView.h"
#include "AlphaDoc.h"


namespace Alpha {
	class ActiveViewListener;
	namespace Ambient {
		class TextEditor;
		class TextSelection;
		class Lexer;
		class EditorPreferences;
	}

	/// Ascension r[ Alpha 
	class AlphaView : public Ascension::EditView {
		// RXgN^
	public:
		AlphaView(AlphaDoc& document);
		AlphaView(const AlphaView& rhs);
		~AlphaView();

		// \bh
	public:
		HRESULT			getAutomation(ITextEditor*& object) const;
		HRESULT			getAutomation(ITextSelection*& object) const;
		HRESULT			getAutomation(ILexer*& object) const;
		HRESULT			getAutomation(IEditorPreferences*& object) const;
		const wchar_t*	getCurrentPositionString() const;
		AlphaDoc&		getDocument() const;
		bool			inputCharacter(Ascension::CodePoint cp);
		bool			insertText(const Ascension::char_t* first, const Ascension::char_t* last, bool asRectangle);
	protected:
		Ascension::string_t	queryInvokableLinkMessage(const Ascension::string_t& uri);
		void				queryLineColors(Ascension::length_t line, COLORREF& fgColor, COLORREF& bgColor);
	protected:
		bool	onKeyDown(UINT ch, UINT flags);
		void	onSetFocus(HWND oldWindow);

		// f[^o
	private:
		Ambient::TextEditor*		automationTextEditor_;
		Ambient::TextSelection*		automationTextSelection_;
		Ambient::Lexer*				automationLexer_;
		Ambient::EditorPreferences*	automationPrefs_;
	};

	/// @see EditView::getDocument
	inline AlphaDoc& AlphaView::getDocument() const {return reinterpret_cast<AlphaDoc&>(Ascension::EditView::getDocument());}
}

#endif /* ALPHA_VIEW_H_ */

/* [EOF] */