// Ambient.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "resource.h"
#include "Ambient.h"
#include "AmbientIdl_i.c"	// IID, LIBID
#include "AlphaScriptHost.h"
#include "AlphaView.h"
#include "CommandManager.h"
#include "Ascension\EditPoint.h"
#include <limits>
#include "../Armaiti/OleTypeWrapper.hpp"
#include "../Armaiti/EnumImpl.hpp"
#include <shlwapi.h>	// PathFindFileName

#pragma warning(disable : 4390)	// u䂪̕܂B...v

using namespace Alpha;
using namespace Alpha::Ambient;
using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Ascension::StandardCommands;
using namespace Manah::Windows::Controls;
using namespace Armaiti;
using namespace Armaiti::OLE;
using namespace std;


// IDispatch::Invoke Ɏg}NA֐A
/////////////////////////////////////////////////////////////////////////////

// IDispatch::Invoke ̈Xg
#define INVOKE_ARGLIST											\
	DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,	\
	DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr

// ̐`FbNAȂ DISP_E_BADPARAMCOUNT ԂƂ
#define VERIFY_ARGUMENTS_COUNT(c)	\
	if(pDispParams->cArgs != (c)) return DISP_E_BADPARAMCOUNT

// ߂ľ^ type ɐݒ肷
// ([Jϐ pVarResult 邱ƂO)
#define COERCE_RETURN(type)	\
	if(pVarResult != 0) pVarResult->vt = type

// iArg Ԗڂ̌^ type ɕϊBϊłȂ΃G[R[hԂƂ
// ([Jϐ pDispParams AwFlags Ahr ApuArgErr Aargs[] 邱ƂO)
#define COERCE_ARGUMENT_AT(iArg, type)																		\
	do {																									\
		if(type == VT_VARIANT) {																			\
			if(pDispParams->rgvarg[iArg].vt == (VT_VARIANT | VT_BYREF))										\
				args[iArg] = *pDispParams->rgvarg[iArg].pvarVal;											\
			else																							\
				args[iArg] = pDispParams->rgvarg[iArg];														\
			hr = (args[iArg].vt != VT_ERROR) ? S_OK : args[iArg].scode;										\
		} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT) && iArg == 0)									\
			hr = ::DispGetParam(pDispParams, DISPID_PROPERTYPUT, type, &args[iArg], puArgErr);				\
		else																								\
			hr = ::DispGetParam(pDispParams, pDispParams->cArgs - iArg - 1, type, &args[iArg], puArgErr);	\
		if(FAILED(hr))																						\
			return hr;																						\
	} while(false)

// Qb^Ăяo̎
#define CALL_GETTER(name, type)	\
	VERIFY_ARGUMENTS_COUNT(0);	\
	pVarResult->vt = type;		\
	return get_##name(&VarTypeDescriminator<type>::value(*pVarResult))
#define CALL_GETTER_1(name, type, type0)							\
	VERIFY_ARGUMENTS_COUNT(1);										\
	COERCE_ARGUMENT_AT(0, type0);									\
	pVarResult->vt = type;											\
	return get_##name(VarTypeDescriminator<type0>::value(args[0]),	\
		&VarTypeDescriminator<type>::value(*pVarResult))
#define CALL_GETTER_ACTX(name, itf)	\
	VERIFY_ARGUMENTS_COUNT(0);		\
	pVarResult->vt = VT_DISPATCH;	\
	return get_##name(reinterpret_cast<itf**>(&pVarResult->pdispVal))
#define CALL_GETTER_ACTX_1(name, type0, itf)						\
	VERIFY_ARGUMENTS_COUNT(1);										\
	COERCE_ARGUMENT_AT(0, type0);									\
	pVarResult->vt = VT_DISPATCH;									\
	return get_##name(VarTypeDescriminator<type0>::value(args[0]),	\
		reinterpret_cast<itf**>(&pVarResult->pdispVal))
#define CALL_GETTER_ENUM(name, type)	\
	pVarResult->vt = VT_I4;			\
	return get_##name(reinterpret_cast<type*>(&pVarResult->lVal))

// vb^Ăяo̎
#define CALL_PUTTER(name, type)		\
	VERIFY_ARGUMENTS_COUNT(1);		\
	COERCE_ARGUMENT_AT(0, type);	\
	return put_##name(VarTypeDescriminator<type>::value(args[0]))
#define CALL_PUTTER_1(name, type, type0)							\
	VERIFY_ARGUMENTS_COUNT(2);										\
	COERCE_ARGUMENT_AT(1, type0);									\
	COERCE_ARGUMENT_AT(0, type);									\
	return put_##name(VarTypeDescriminator<type0>::value(args[1]),	\
		VarTypeDescriminator<type>::value(args[0]))
#define CALL_PUTTER_ACTX(name, itf)		\
	VERIFY_ARGUMENTS_COUNT(1);			\
	COERCE_ARGUMENT_AT(0, VT_DISPATCH);	\
	return put_##name(reinterpret_cast<itf*>(args[0].pdispVal))
#define CALL_PUTTER_ENUM(name, type)	\
	VERIFY_ARGUMENTS_COUNT(1);			\
	COERCE_ARGUMENT_AT(0, VT_I4);		\
	return put_##name(static_cast<type>(args[0].lVal))

// \bhĂяo̎
#define CALL_METHOD_0(name)		\
	VERIFY_ARGUMENTS_COUNT(0);	\
	return name()
#define CALL_METHOD_1(name, type0)	\
	VERIFY_ARGUMENTS_COUNT(1);		\
	COERCE_ARGUMENT_AT(0, type0);	\
	return name(VarTypeDescriminator<type0>::value(args[0]))
#define CALL_METHOD_2(name, type0, type1)	\
	VERIFY_ARGUMENTS_COUNT(2);				\
	COERCE_ARGUMENT_AT(1, type0);			\
	COERCE_ARGUMENT_AT(0, type1);			\
	return name(VarTypeDescriminator<type0>::value(args[1]), VarTypeDescriminator<type1>::value(args[0]))
#define CALL_METHOD_3(name, type0, type1, type2)				\
	VERIFY_ARGUMENTS_COUNT(3);									\
	COERCE_ARGUMENT_AT(2, type0);								\
	COERCE_ARGUMENT_AT(1, type1);								\
	COERCE_ARGUMENT_AT(0, type2);								\
	return name(VarTypeDescriminator<type0>::value(args[2]),	\
		VarTypeDescriminator<type1>::value(args[1]),			\
		VarTypeDescriminator<type2>::value(args[0]))
#define CALL_METHOD_4(name, type0, type1, type2, type3)			\
	VERIFY_ARGUMENTS_COUNT(4);									\
	COERCE_ARGUMENT_AT(3, type0);								\
	COERCE_ARGUMENT_AT(2, type1);								\
	COERCE_ARGUMENT_AT(1, type2);								\
	COERCE_ARGUMENT_AT(0, type3);								\
	return name(VarTypeDescriminator<type0>::value(args[3]),	\
		VarTypeDescriminator<type1>::value(args[2]),			\
		VarTypeDescriminator<type2>::value(args[1]),			\
		VarTypeDescriminator<type3>::value(args[0]))
#define CALL_METHOD_RET_0(name, retType)	\
	VERIFY_ARGUMENTS_COUNT(0);				\
	COERCE_RETURN(retType);					\
	return name((pVarResult != 0) ? &VarTypeDescriminator<retType>::value(*pVarResult) : 0)
#define CALL_METHOD_RET_1(name, retType, type0)					\
	VERIFY_ARGUMENTS_COUNT(1);									\
	COERCE_ARGUMENT_AT(0, type0);								\
	COERCE_RETURN(retType);										\
	return name(VarTypeDescriminator<type0>::value(args[0]),	\
		(pVarResult != 0) ? &VarTypeDescriminator<retType>::value(*pVarResult) : 0)
#define CALL_METHOD_RET_2(name, retType, type0, type1)			\
	VERIFY_ARGUMENTS_COUNT(2);									\
	COERCE_ARGUMENT_AT(1, type0);								\
	COERCE_ARGUMENT_AT(0, type1);								\
	COERCE_RETURN(retType);										\
	return name(VarTypeDescriminator<type0>::value(args[1]),	\
		VarTypeDescriminator<type1>::value(args[0]),			\
		(pVarResult != 0) ? &VarTypeDescriminator<retType>::value(*pVarResult) : 0)

// S}[N
#define SAFE_MARK	\
	IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>(INTERFACESAFE_FOR_UNTRUSTED_CALLER)

// 댯}[N
#define UNSAFE_MARK	\
	IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>(0)

// ȂȂ
#define VERIFY_SAFETY()													\
	if(toBoolean(enabledSafety_ & INTERFACESAFE_FOR_UNTRUSTED_CALLER))	\
		return E_ACCESSDENIED

// 񂾎IuWFNgwĂȂ𒲂ׂ
#define CHECK_IF_DISPOSED()	if(isDisposed()) return E_UNEXPECTED;

// _Xbhx̃G[ pExcepInfo ɃZbgA
// DISP_E_EXCEPTION ԂB
// (ʎq pException Ahr Lł邱ƂO)
#define RETURN_WITH_EXCEPTION()										\
	do {															\
		IErrorInfo*	pErrorInfo = 0;									\
		assert(SUCCEEDED(::GetErrorInfo(0, &pErrorInfo)));			\
		pExcepInfo->wCode = 0;										\
		pExcepInfo->scode = hr;										\
		pErrorInfo->GetSource(&pExcepInfo->bstrSource);				\
		pErrorInfo->GetDescription(&pExcepInfo->bstrDescription);	\
		pErrorInfo->GetHelpFile(&pExcepInfo->bstrHelpFile);			\
		pErrorInfo->GetHelpContext(&pExcepInfo->dwHelpContext);		\
		pExcepInfo->pvReserved = 0;									\
		pExcepInfo->pfnDeferredFillIn = 0;							\
		::SetErrorInfo(0, pErrorInfo);								\
		pErrorInfo->Release();										\
		return DISP_E_EXCEPTION;									\
	} while(false)

// TextPoint ̊̃\bhɎgp
#define GENERATE_CHARPOS_FROM_TEXTPOINT()			\
	ComPtr<ITextPoint> textPoint;					\
	long line, column;								\
	var = other;									\
	if(FAILED(var.pdispVal->QueryInterface(			\
			IID_ITextPoint,							\
			reinterpret_cast<void**>(&textPoint))))	\
		return DISP_E_TYPEMISMATCH;					\
	textPoint->get_Line(&line);						\
	textPoint->get_Char(&column);					\
	CharPos pos = CharPos(line, column);

namespace {
#if 0
	// Cӂ̃\bhĂяo GUI XbhɈϏ
	template<class Class, class Result = void>
	struct GuiThreadDelegator0 : virtual public Alpha::ICallable {
		GuiThreadDelegator0(Class& object, Result(Class::*method)()) : object_(object), method_(method) {}
		void Call() {(object_.*method_)();}
		Class& object_;
		Result(Class::*method_)();
	};
	template<class Class, class Argument, class Result = void>
	struct GuiThreadDelegator1 : virtual public Alpha::ICallable {
		GuiThreadDelegator1(Class& object, Result(Class::*method)(Argument&), Argument& argument)
				: object_(object), method_(method), argument_(argument) {}
		void Call() {(object_.*method_)(argument_);}
		Class& object_;
		Result(Class::*method_)(Argument&);
		Argument& argument_;
	};
#endif /* 0 */
	// 󔒂ŋ؂ăXgɂ
	template <class T> inline void splitBySpace(const wchar_t* text, T& dest) {
		assert(text != 0);
		const wchar_t* space;
		const wchar_t* last = text;
		while(true) {
			space = wcschr(last, L' ');
			if(space != 0) {
				dest.push_back(wstring(last, space - last));
				last = space + 1;
			} else {
				dest.push_back(wstring(last));
				break;
			}
		}
	}
	// K\Ȃ
	const HRESULT SCRIPT_E_BADREGEXP = 0x800A1399;
	// EditorPreferences::CheckInputSequence vpeB̎ɎgꃊXg
	const pair<const wchar_t*, InputSequenceCheckLanguage> ISCLanguages[] = {
		make_pair(L"ainu", ISCL_AINU),
		make_pair(L"thai", ISCL_THAI),
		make_pair(L"vietnamese", ISCL_VIETNAMESE),
	};
} // namespace `anonymous'


// Application class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Ambient::Application::Application(Alpha::AlphaApp& app, const vector<wstring>* arguments /* = 0 */) : SAFE_MARK, app_(app) {
}

/// fXgN^
Ambient::Application::~Application() {
}

/// @see IApplication::ClearOutput
STDMETHODIMP Ambient::Application::ClearOutput() {
//	app_->outputWindow.clear(OTT_GENERAL, false);
	return S_OK;
}

/// @see IApplication::get_Abbreviations
STDMETHODIMP Ambient::Application::get_Abbreviations(IAbbreviations** abbreviations) {
	VERIFY_POINTER(abbreviations);
	if(0 == (*abbreviations = new Ambient::Abbreviations))
		return E_OUTOFMEMORY;
	(*abbreviations)->AddRef();
	return S_OK;
}

/// @see IApplication::get_Active
STDMETHODIMP Ambient::Application::get_Active(VARIANT_BOOL* active) {
	VERIFY_POINTER(active);
	*active = toVariantBoolean(app_.getMainWindow() == Window::getActiveWindow());
	return S_OK;
}

/// @see IApplication::get_ActiveBuffer
STDMETHODIMP Ambient::Application::get_ActiveBuffer(IBuffer** activeBuffer) {
	VERIFY_POINTER(activeBuffer);
	return app_.getBufferList().getActive().getAutomation(app_.getBufferList(), *activeBuffer);
}

/// @see IApplication::get_Buffers
STDMETHODIMP Ambient::Application::get_Buffers(IBuffers** buffers) {
	VERIFY_POINTER(buffers);
	return app_.getBufferList().getAutomation(*buffers);
}

/// @see IApplication::get_Configurations
STDMETHODIMP Ambient::Application::get_Configurations(IConfigurations** configurations) {
	VERIFY_POINTER(configurations);
	if(0 == (*configurations = new Configurations(app_)))
		return E_OUTOFMEMORY;
	(*configurations)->AddRef();
	return S_OK;
}

/// @see IApplication::get_CurrentDirectory
STDMETHODIMP Ambient::Application::get_CurrentDirectory(BSTR* directory) {
	VERIFY_POINTER(directory);
	OLECHAR path[MAX_PATH];
	::GetCurrentDirectoryW(MAX_PATH, path);
	return (*directory = ::SysAllocString(path)) ? S_OK : E_OUTOFMEMORY;
}

/// @see IApplication::get_EditorPanes
STDMETHODIMP Ambient::Application::get_EditorPanes(IEditorPanes** panes) {
	VERIFY_POINTER(panes);
	if(*panes = new EditorPanes(app_.getBufferList().getEditorWindow())) {
		(*panes)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see IApplication::get_FullName
STDMETHODIMP Ambient::Application::get_FullName(BSTR* fullName) {
	VERIFY_POINTER(fullName);
	WCHAR fileName[MAX_PATH];
	::GetModuleFileName(0, fileName, MAX_PATH);
	return ((*fullName = ::SysAllocString(fileName)) != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IApplication::get_Height
STDMETHODIMP Ambient::Application::get_Height(long* height) {
	VERIFY_POINTER(height);
	RECT rect;
	app_.getMainWindow().getWindowRect(rect);
	*height = rect.bottom - rect.top;
	return S_OK;
}

/// @see IApplication::get_Interactive
STDMETHODIMP Ambient::Application::get_Interactive(VARIANT_BOOL* interactive) {
	VERIFY_POINTER(interactive);
	*interactive = VARIANT_TRUE;
	return S_OK;
}

/// @see IApplication::get_Left
STDMETHODIMP Ambient::Application::get_Left(long* left) {
	VERIFY_POINTER(left);
	RECT rect;
	app_.getMainWindow().getWindowRect(rect);
	*left = rect.left;
	return S_OK;
}

/// @see IApplication::get_Name
STDMETHODIMP Ambient::Application::get_Name(BSTR* name) {
	VERIFY_POINTER(name);
	*name = ::SysAllocString(IDS_APPNAME OLESTR(" ") IDS_APPVERSION OLESTR(" ") IDS_APPVERSIONINFO);
	return (*name != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IApplication::get_Top
STDMETHODIMP Ambient::Application::get_Top(long* top) {
	VERIFY_POINTER(top);
	RECT rect;
	app_.getMainWindow().getWindowRect(rect);
	*top = rect.top;
	return S_OK;
}

/// @see IApplication::get_Version
STDMETHODIMP Ambient::Application::get_Version(BSTR* versionString) {
	VERIFY_POINTER(versionString);
	return ((*versionString = ::SysAllocString(IDS_APPVERSION)) != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IApplication::get_Visible
STDMETHODIMP Ambient::Application::get_Visible(VARIANT_BOOL* visible) {
	VERIFY_POINTER(visible);
	*visible = toVariantBoolean(app_.getMainWindow().isWindowVisible());
	return S_OK;
}

/// @see IApplication::get_Width
STDMETHODIMP Ambient::Application::get_Width(long* width) {
	VERIFY_POINTER(width);
	RECT rect;
	app_.getMainWindow().getWindowRect(rect);
	*width = rect.right - rect.left;
	return S_OK;
}

/// @see IApplication::get_WindowState
STDMETHODIMP Ambient::Application::get_WindowState(WindowState* windowState) {
	VERIFY_POINTER(windowState);
	if(app_.getMainWindow().isIconic())			*windowState = Minimized;
	else if(app_.getMainWindow().isZoomed())	*windowState = Maximized;
	else										*windowState = Normal;
	return S_OK;
}

/// @see IApplication::GetCommandById
STDMETHODIMP Ambient::Application::GetCommandById(long commandID, ICommand** command) {
	if(command != 0) {
		if(0 == (*command = new Ambient::Command(app_, static_cast<CommandID>(commandID))))
			return E_OUTOFMEMORY;
		(*command)->AddRef();
	}
	return S_OK;
}

/// @see IDispatch::Invoke
STDMETHODIMP Ambient::Application::Invoke(INVOKE_ARGLIST) {
	return IDispatchImpl<IApplication,
		PathTypeLibTypeInfoHolder<AmbientTypeLibPath, &IID_IApplication>
	>::Invoke(dispidMember, riid, lcid, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT hr = DISP_E_MEMBERNOTFOUND;
	ComVariant args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ABBREVIATIONS:		CALL_GETTER_ACTX(Abbreviations, IAbbreviations);
		case DISPID_APPLICATION_ACTIVE:				CALL_GETTER(Active, VT_BOOL);
		case DISPID_APPLICATION_ACTIVEBUFFER:		CALL_GETTER_ACTX(ActiveBuffer, IBuffer);
		case DISPID_APPLICATION_BUFFERS: {
			IBuffers* buffers;
			pVarResult->vt = VT_DISPATCH;
			hr = get_Buffers(&buffers);
			if(SUCCEEDED(hr) && pDispParams->cArgs != 0) {	// "Ambient.Buffers(i)" ̂悤ȏꍇ
				hr = buffers->Invoke(DISPID_VALUE, IID_NULL,
						LOCALE_USER_DEFAULT, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
				buffers->Release();
				return hr;
			} else {	// "Ambient.Buffers" ̂悤ȏꍇ
				pVarResult->pdispVal = buffers;
				return hr;
			}
		}
		case DISPID_APPLICATION_CONFIGURATIONS:		CALL_GETTER_ACTX(Configurations, IConfigurations);
		case DISPID_APPLICATION_CURRENTDIRECTORY:	CALL_GETTER(CurrentDirectory, VT_BSTR);
		case DISPID_APPLICATION_EDITORPANES:	CALL_GETTER_ACTX(EditorPanes, IEditorPanes);
		case DISPID_APPLICATION_FULLNAME:		CALL_GETTER(FullName, VT_BSTR);
		case DISPID_APPLICATION_HEIGHT:			CALL_GETTER(Height, VT_I4);
		case DISPID_APPLICATION_INTERACTIVE:	CALL_GETTER(Interactive, VT_BOOL);
		case DISPID_APPLICATION_LEFT:			CALL_GETTER(Left, VT_I4);
		case DISPID_APPLICATION_NAME:			CALL_GETTER(Name, VT_BSTR);
		case DISPID_APPLICATION_TOP:			CALL_GETTER(Top, VT_I4);
		case DISPID_APPLICATION_VERSION:		CALL_GETTER(Version, VT_BSTR);
		case DISPID_APPLICATION_VISIBLE:		CALL_GETTER(Visible, VT_BOOL);
		case DISPID_APPLICATION_WIDTH:			CALL_GETTER(Width, VT_I4);
		case DISPID_APPLICATION_WINDOWSTATE:	CALL_GETTER_ENUM(WindowState, WindowState);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ACTIVE:				CALL_PUTTER(Active, VT_BOOL);
		case DISPID_APPLICATION_CURRENTDIRECTORY:	CALL_PUTTER(CurrentDirectory, VT_BSTR);
		case DISPID_APPLICATION_HEIGHT:				CALL_PUTTER(Height, VT_I4);
		case DISPID_APPLICATION_INTERACTIVE:		CALL_PUTTER(Interactive, VT_BOOL);
		case DISPID_APPLICATION_LEFT:				CALL_PUTTER(Left, VT_I4);
		case DISPID_APPLICATION_TOP:				CALL_PUTTER(Top, VT_I4);
		case DISPID_APPLICATION_VISIBLE:			CALL_PUTTER(Visible, VT_BOOL);
		case DISPID_APPLICATION_WIDTH:				CALL_PUTTER(Width, VT_I4);
		case DISPID_APPLICATION_WINDOWSTATE:		CALL_PUTTER_ENUM(WindowState, WindowState);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF) {	// Zb^
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_APPLICATION_CLEAROUTPUT:	CALL_METHOD_0(ClearOutput);
		case DISPID_APPLICATION_GETCOMMANDBYID:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			COERCE_RETURN(VT_DISPATCH);
			return GetCommandById(args[0].lVal,
				(pVarResult != 0) ? reinterpret_cast<ICommand**>(&pVarResult->pdispVal) : 0);
		case DISPID_APPLICATION_QUIT:
			if(pDispParams->cArgs == 1) {
				CALL_METHOD_1(Quit, VT_I2);
			} else if(pDispParams->cArgs == 0)
				return Quit();
			else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_APPLICATION_WRITETOOUTPUT:		CALL_METHOD_2(WriteToOutput, VT_BSTR, VT_BOOL);
		case DISPID_APPLICATION_WRITELINETOOUTPUT:	CALL_METHOD_2(WriteLineToOutput, VT_BSTR, VT_BOOL);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

void Ambient::Application::callHook(DISPID hookID, const DISPPARAMS* arguments) {
/*	if(hook_ == 0)
		return;

	ComPtr<IDispatchEx>	px;
	DISPPARAMS			params = {0, 0, 0, 0};
	EXCEPINFO			exception;
	HRESULT				hr;

	if(S_OK == hook_->QueryInterface(IID_IDispatchEx, reinterpret_cast<void**>(&px))) {
		VARIANTARG	arg;
		DISPID		id = DISPID_THIS;

		params.cArgs = params.cNamedArgs = 1;
		arg.vt = VT_DISPATCH;
		hr = QueryInterface(IID_IDispatch, reinterpret_cast<void**>(&arg.pdispVal));
		params.rgdispidNamedArgs = &id;
		hr = px->InvokeEx(DISPID_VALUE, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, 0, &exception, 0);
	} else {
		unsigned int argErr;
		hr = hook_->Invoke(DISPID_VALUE, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, 0, &exception, &argErr);
	}*/
}

/// @see IApplication::put_Active
STDMETHODIMP Ambient::Application::put_Active(VARIANT_BOOL active) {
	if(active)
		app_.getMainWindow().setActiveWindow();
	else
		::SetActiveWindow(::GetDesktopWindow());
	return S_OK;
}

/// @see IApplication::put_CurrentDirectory
STDMETHODIMP Ambient::Application::put_CurrentDirectory(BSTR directory) {
	::SetCurrentDirectoryW((directory != 0) ? directory : L"");
	return S_OK;
}

/// @see IApplication::put_Height
STDMETHODIMP Ambient::Application::put_Height(long height) {
	RECT rect;
	app_.getMainWindow().getWindowRect(rect);
	app_.getMainWindow().setWindowPos(0, 0, 0, rect.right - rect.left, height, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

/// @see IApplication::put_Interactive
STDMETHODIMP Ambient::Application::put_Interactive(VARIANT_BOOL interactive) {
	return S_OK;
}

/// @see IApplication::put_Left
STDMETHODIMP Ambient::Application::put_Left(long left) {
	RECT rect;
	app_.getMainWindow().getWindowRect(rect);
	app_.getMainWindow().setWindowPos(0, left, rect.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

/// @see IApplication::put_Top
STDMETHODIMP Ambient::Application::put_Top(long top) {
	RECT rect;
	app_.getMainWindow().getWindowRect(rect);
	app_.getMainWindow().setWindowPos(0, rect.left, top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

/// @see IApplication::put_Visible
STDMETHODIMP Ambient::Application::put_Visible(VARIANT_BOOL visible) {
	app_.getMainWindow().showWindow(visible ? SW_SHOW : SW_HIDE);
	return S_OK;
}

/// @see IApplication::put_Width
STDMETHODIMP Ambient::Application::put_Width(long width) {
	RECT rect;
	app_.getMainWindow().getWindowRect(rect);
	app_.getMainWindow().setWindowPos(0, 0, 0, width, rect.bottom - rect.top, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

/// @see IApplication::put_WindowState
STDMETHODIMP Ambient::Application::put_WindowState(WindowState windowState) {
	switch(windowState) {
	case Minimized:
		app_.getMainWindow().showWindow(SW_MINIMIZE);
		break;
	case Maximized:
		app_.getMainWindow().showWindow(SW_MAXIMIZE);
		break;
	case Normal:
		app_.getMainWindow().showWindow(SW_RESTORE);
		break;
	default:
		return E_INVALIDARG;
		break;
	}
	return S_OK;
}

/// @see IApplication::Quit
STDMETHODIMP Ambient::Application::Quit(short errorCode) {
	app_.getMainWindow().sendMessage(WM_CLOSE);
	return S_OK;
}

/// @see IApplication::WriteToOutput
STDMETHODIMP Ambient::Application::WriteToOutput(BSTR output, VARIANT_BOOL activate) {
//	app_.outputWindow_.write(OTT_GENERAL, output, toBoolean(activate));
	return S_OK;
}

/// @see IApplication::WriteLineToOutput
STDMETHODIMP Ambient::Application::WriteLineToOutput(BSTR output, VARIANT_BOOL activate) {
//	app_.outputWindow_.writeLine(OTT_GENERAL, output, toBoolean(activate));
	return S_OK;
}


// Buffers class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Buffers::Buffers(BufferList& impl) : UNSAFE_MARK, impl_(impl) {
}

/// @see IBuffers::AddNew
STDMETHODIMP Buffers::AddNew(IBuffer** newBuffer) {
	impl_.addNew();
	if(newBuffer != 0)
		impl_.getActive().getAutomation(impl_, *newBuffer);
	return S_OK;
}

/// @see IBuffers::CloseAll
STDMETHODIMP Buffers::CloseAll() {
	impl_.closeAll(true);
	return S_OK;
}

/// @see IBuffers::get__NewEnum
STDMETHODIMP Buffers::get__NewEnum(IUnknown** enumerator) {
	VERIFY_POINTER(enumerator);
	const size_t bufferCount = impl_.getCount();
	VARIANT* const automationBuffers = new VARIANT[bufferCount];

	try {
		for(size_t i = 0; i < bufferCount; ++i) {
			::VariantInit(&automationBuffers[i]);
			automationBuffers[i].vt = VT_DISPATCH;
			impl_.getAt(i).getAutomation(impl_, *reinterpret_cast<IBuffer**>(&automationBuffers[i].pdispVal));
		}
	} catch(out_of_range& /* e */) {
		for(size_t i = 0; i < bufferCount; ++i)
			::VariantClear(&automationBuffers[i]);
		delete[] automationBuffers;
		*enumerator = 0;
		return E_FAIL;
	}
	*enumerator = new IEnumVARIANTImpl(automationBuffers, automationBuffers + bufferCount);
	if(*enumerator != 0)
		(*enumerator)->AddRef();
	for(size_t i = 0; i < bufferCount; ++i)
		::VariantClear(&automationBuffers[i]);
	delete[] automationBuffers;

	return (*enumerator != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IBuffers::get_Count
STDMETHODIMP Buffers::get_Count(long* count) {
	VERIFY_POINTER(count);
	*count = static_cast<long>(impl_.getCount());
	return S_OK;
}

/// @see IBuffers::Item
STDMETHODIMP Buffers::Item(long index, IBuffer** buffer) {
	VERIFY_POINTER(buffer);
	try {
		impl_.getAt(index).getAutomation(impl_, *buffer);
	} catch(out_of_range& /* e */) {
		*buffer = 0;
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see IBuffers::Open
STDMETHODIMP Buffers::Open(BSTR pathName, FileShareMode shareMode, long codePage, VARIANT_BOOL addToMRU, IBuffer** newBuffer) {
	VERIFY_SAFETY();
	if(pathName == 0)
		return E_INVALIDARG;
	ComCriticalSection<> cs;
	cs.lock();
	if(newBuffer != 0)
		*newBuffer = 0;
	if(impl_.open(pathName, (codePage != 0) ? codePage : ::GetACP(), false, toBoolean(addToMRU)) == BufferList::OPENRESULT_SUCCEEDED) {
		if(newBuffer != 0)
			impl_.getActive().getAutomation(impl_, *newBuffer);
	}
	cs.unlock();
	return S_OK;
}

/// @see IBuffers::SaveAll
STDMETHODIMP Buffers::SaveAll() {
	VERIFY_SAFETY();
	impl_.saveAll();
	return S_OK;
}


// EditorPanes class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
EditorPanes::EditorPanes(EditorWindow& impl) : impl_(impl) {
}

/// @see IEditorPanes::ActivateNext
STDMETHODIMP EditorPanes::ActivateNext() {
//	AlphaApp::getInstance().callFunctionOnGuiThread(
//		GuiThreadDelegator0<EditorWindow>(impl_, EditorWindow::ActivateNextPane));
	impl_.activateNextPane();
	return S_OK;
}

/// @see IEditorPanes::ActivatePrev
STDMETHODIMP EditorPanes::ActivatePrev() {
//	AlphaApp::getInstance().callFunctionOnGuiThread(
//		GuiThreadDelegator0<EditorWindow>(impl_, EditorWindow::ActivatePreviousPane));
	impl_.activatePreviousPane();
	return S_OK;
}

/// @see IEditorPanes::get__NewEnum
STDMETHODIMP EditorPanes::get__NewEnum(IUnknown** enumerator) {
	VERIFY_POINTER(enumerator);

	size_t c = 0;
	for(EditorWindow::Iterator it = impl_.enumeratePanes(); !it.isEnd(); it.next())
		++c;
	VARIANT* panes = new VARIANT[c];
	VARIANT* pane = panes;
	for(EditorWindow::Iterator it = impl_.enumeratePanes(); !it.isEnd(); it.next(), ++pane) {
		IEditorPane* p;
		it.get().getAutomation(p);
		::VariantInit(pane);
		pane->vt = VT_DISPATCH;
		pane->pdispVal = p;
	}
	*enumerator = new IEnumVARIANTImpl(panes, panes + c);
	for(size_t i = 0; i < c; ++i)
		::VariantClear(panes + i);
	delete[] panes;
	if(*enumerator != 0) {
		(*enumerator)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see IEditorPanes::get_ActivePane
STDMETHODIMP EditorPanes::get_ActivePane(IEditorPane** activePane) {
	VERIFY_POINTER(activePane);
	return impl_.getActivePane().getAutomation(*activePane);
}

/// @see IEditorPanes::get_Count
STDMETHODIMP EditorPanes::get_Count(long* count) {
	VERIFY_POINTER(count);
	*count = 0;
	for(EditorWindow::Iterator it = impl_.enumeratePanes(); !it.isEnd(); it.next())
		++(*count);
	return S_OK;
}

/// @see IEditorPanes::UnsplitAll
STDMETHODIMP EditorPanes::UnsplitAll() {
//	AlphaApp::getInstance().callFunctionOnGuiThread(
//		GuiThreadDelegator0<EditorWindow>(impl_, EditorWindow::RemoveInactivePanes));
	impl_.removeInactivePanes();
	return S_OK;
}

// EditorPane class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Ambient::EditorPane::EditorPane(EditorWindow& parent, Alpha::EditorPane& pane) : parent_(parent), pane_(pane) {
}

/// @see IEditorPane::Activate
STDMETHODIMP Ambient::EditorPane::Activate() {
	CHECK_IF_DISPOSED();
//	AlphaApp::getInstance().callFunctionOnGuiThread(
//		GuiThreadDelegator0<AlphaView, Window>(pane_.getVisibleView(), AlphaView::setFocus));
//	AlphaApp::getInstance().callFunctionOnGuiThread(
//		GuiThreadDelegator1<EditorWindow, Alpha::EditorPane>(parent_, EditorWindow::setDefaultActivePane, pane_));
	pane_.getVisibleView().setFocus();
	parent_.setDefaultActivePane(pane_);
	return S_OK;
}
/// @see IEditorPane::Close
STDMETHODIMP Ambient::EditorPane::Close() {
	CHECK_IF_DISPOSED();
/*	struct X : virtual public Alpha::ICallable {
		X(EditorWindow& panes, Alpha::EditorPane& pane) : panes_(panes), pane_(pane) {}
		void call() {panes_.unsplit(pane_);}
		EditorWindow& panes_;
		Alpha::EditorPane& pane_;
	} delegator(parent_, pane_);
	AlphaApp::getInstance().getMainWindow().sendMessage(
		MYWM_CALLOVERTHREAD, 0, reinterpret_cast<LPARAM>(static_cast<Alpha::ICallable*>(&delegator)));
*/	parent_.unsplit(pane_);
	return S_OK;
}

/// @see IEditorPane::get_Active
STDMETHODIMP Ambient::EditorPane::get_Active(VARIANT_BOOL* active) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(active);
	*active = &parent_.getActivePane() == &pane_;
	return S_OK;
}

/// @see IEditorPane::get_Buffer
STDMETHODIMP Ambient::EditorPane::get_Buffer(IBuffer** buffer) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(buffer);
	pane_.getVisibleBuffer().getAutomation(AlphaApp::getInstance().getBufferList(), *buffer);
	return S_OK;
}

/// @see IEditorPane::get_Editor
STDMETHODIMP Ambient::EditorPane::get_Editor(ITextEditor** editor) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(editor);
	return pane_.getVisibleView().getAutomation(*editor);
}

/// @see IEditorPane::get_Height
STDMETHODIMP Ambient::EditorPane::get_Height(long* height) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(height);
	RECT rect;
	pane_.getVisibleView().getWindowRect(rect);
	*height = rect.bottom - rect.top;
	return S_OK;
}

/// @see IEditorPane::get_Width
STDMETHODIMP Ambient::EditorPane::get_Width(long* width) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(width);
	RECT rect;
	pane_.getVisibleView().getWindowRect(rect);
	*width = rect.right - rect.left;
	return S_OK;
}

/// @see IEditorPane::put_Buffer
STDMETHODIMP Ambient::EditorPane::put_Buffer(IBuffer* buffer) {
	CHECK_IF_DISPOSED();
	if(buffer == 0)
		return E_INVALIDARG;

	BufferList& buffers = AlphaApp::getInstance().getBufferList();
	for(size_t i = 0; i < buffers.getCount(); ++i) {
		IBuffer* p;
		buffers.getAt(i).getAutomation(AlphaApp::getInstance().getBufferList(), p);
		if(p == buffer) {
			pane_.showBuffer(buffers.getAt(i));
			p->Release();
			continue;
		}
		p->Release();
	}
	return S_OK;
}

/// @see IEditorPane::put_Height
STDMETHODIMP Ambient::EditorPane::put_Height(long height) {
	CHECK_IF_DISPOSED();
	return E_NOTIMPL;
}

/// @see IEditorPane::put_Width
STDMETHODIMP Ambient::EditorPane::put_Width(long width) {
	CHECK_IF_DISPOSED();
	return E_NOTIMPL;
}

/// @see IEditorPane::Split
STDMETHODIMP Ambient::EditorPane::Split(VARIANT_BOOL ns) {
	CHECK_IF_DISPOSED();
/*	struct X : virtual public Alpha::ICallable {
		X(EditorWindow& panes, Alpha::EditorPane& pane, bool ns) : panes_(panes), pane_(pane), ns_(ns) {}
		void call() {
			Alpha::EditorPane* p = new Alpha::EditorPane(pane_);
			if(ns_)	panes_.splitNS(pane_, *p);
			else	panes_.splitWE(pane_, *p);
		}
		EditorWindow& panes_;
		Alpha::EditorPane& pane_;
		bool ns_;
	} delegator(parent_, pane_, toBoolean(bNs));
	AlphaApp::getInstance().getMainWindow().sendMessage(
		MYWM_CALLOVERTHREAD, 0, reinterpret_cast<LPARAM>(static_cast<Alpha::ICallable*>(&delegator)));
*/	Alpha::EditorPane* p = new Alpha::EditorPane(pane_);
	if(toBoolean(ns))	parent_.splitNS(pane_, *p);
	else				parent_.splitWE(pane_, *p);
	return S_OK;
}


// Buffer class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Buffer::Buffer(BufferList& parent, AlphaDoc& impl) : UNSAFE_MARK, parent_(parent), impl_(impl) {
}

/// @see IBuffer::Activate
STDMETHODIMP Buffer::Activate() {
	parent_.getEditorWindow().getActivePane().showBuffer(impl_);
	return S_OK;
}

/// @see IBuffer::Close
STDMETHODIMP Buffer::Close() {
	parent_.close(parent_.find(impl_), false);
	return S_OK;
}

/// @see IBuffer::get_Active
STDMETHODIMP Buffer::get_Active(VARIANT_BOOL* active) {
	VERIFY_POINTER(active);
	*active = toVariantBoolean(&parent_.getActive() == &impl_);
	return S_OK;
}

/// @see IBuffer::get_CodePage
STDMETHODIMP Buffer::get_CodePage(long* codePage) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(codePage);
	*codePage = impl_.getCodePage();
	return S_OK;
}

/// @see IBuffer::get_Editor
STDMETHODIMP Buffer::get_Editor(ITextEditor** editor) {
	VERIFY_POINTER(editor);
	return parent_.getActiveView().getAutomation(*editor);
}

/// @see IBuffer::get_EndPoint
STDMETHODIMP Buffer::get_EndPoint(ITextPoint** endPoint) {
	VERIFY_POINTER(endPoint);

	auto_ptr<VisualPoint> temp(impl_.createEditPoint());
	temp->moveToEndOfDocument();
	if(*endPoint = new TextPoint(*temp, false)) {
		temp.release();
		(*endPoint)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see IBuffer::get_FileName
STDMETHODIMP Buffer::get_FileName(BSTR* fileName) {
	VERIFY_POINTER(fileName);
	return ((*fileName = ::SysAllocString(impl_.getFileName())) != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IBuffer::get_FilePath
STDMETHODIMP Buffer::get_FilePath(BSTR* filePath) {
	VERIFY_POINTER(filePath);
	*filePath = ::SysAllocString((impl_.getPathName() != 0) ? impl_.getPathName() : OLESTR(""));
	return (*filePath != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IBuffer::get_Line
STDMETHODIMP Buffer::get_Line(long index, BSTR* line) {
	VERIFY_POINTER(line);
	try {
		*line = ::SysAllocString(impl_.getLine(index).c_str());
	} catch(out_of_range&) {
		*line = 0;
		return E_INVALIDARG;
	}
	return (*line != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IBuffer::get_LineBreak
STDMETHODIMP Buffer::get_LineBreak(::LineBreak* lineBreak) {
	VERIFY_POINTER(lineBreak);
	*lineBreak = static_cast<::LineBreak>(impl_.getLineBreak());
	return S_OK;
}

/// @see IBuffer::get_LineCount
STDMETHODIMP Buffer::get_LineCount(long* count) {
	VERIFY_POINTER(count);
	*count = static_cast<long>(impl_.getLineCount());
	return S_OK;
}

/// @see IBuffer::get_Modified
STDMETHODIMP Buffer::get_Modified(VARIANT_BOOL* modified) {
	VERIFY_POINTER(modified);
	*modified = impl_.isModified();
	return S_OK;
}

/// @see IBuffer::get_ReadOnly
STDMETHODIMP Buffer::get_ReadOnly(VARIANT_BOOL* readOnly) {
	VERIFY_POINTER(readOnly);
	*readOnly = impl_.isReadOnly();
	return S_OK;
}

/// @see IBuffer::get_StartPoint
STDMETHODIMP Buffer::get_StartPoint(ITextPoint** startPoint) {
	VERIFY_POINTER(startPoint);
	auto_ptr<VisualPoint> temp(impl_.createEditPoint());
	if(*startPoint = new TextPoint(*temp, false)) {
		temp.release();
		(*startPoint)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see IBuffer::IsNarrowed
STDMETHODIMP Buffer::IsNarrowed(VARIANT_BOOL* narrowed) {
	if(narrowed != 0)
		*narrowed = toVariantBoolean(impl_.isNarrowed());
	return S_OK;
}

/// @see IBuffer::Narrow
STDMETHODIMP Buffer::Narrow(long startLine, long startChar, long endLine, long endChar) {
	impl_.narrow(Ascension::TextRange(CharPos(startLine, startChar), CharPos(endLine, endChar)));
	return S_OK;
}

/// @see IBuffer::put_CodePage
STDMETHODIMP Buffer::put_CodePage(long codePage) {
	try {
		impl_.setCodePage(codePage);
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see IBuffer::put_LineBreak
STDMETHODIMP Buffer::put_LineBreak(::LineBreak lineBreak) {
	try {
		impl_.setLineBreak(static_cast<Ascension::LineBreak>(lineBreak));
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see IBuffer::put_Modified
STDMETHODIMP Buffer::put_Modified(VARIANT_BOOL modified) {
	impl_.setModified(toBoolean(modified));
	return S_OK;
}

/// @see IBuffer::put_ReadOnly
STDMETHODIMP Buffer::put_ReadOnly(VARIANT_BOOL readOnly) {
	impl_.setReadOnly(toBoolean(readOnly));
	return S_OK;
}

/// @see IBuffer::Save
STDMETHODIMP Buffer::Save(BSTR fileName, ::LineBreak lineBreak /* = Auto */, long codePage /* = 0 */) {
	VERIFY_SAFETY();
	if(fileName == 0)
		return E_INVALIDARG;
	return (EditDoc::FIR_OK == impl_.save(fileName, 0,
		static_cast<Ascension::LineBreak>(lineBreak), codePage, 0)) ? S_OK : S_FALSE;
}

/// @see IBuffer::Widen
STDMETHODIMP Buffer::Widen() {
	impl_.widen();
	return S_OK;
}


// TextEditor class implementation
/////////////////////////////////////////////////////////////////////////////

#define GENERATE_NATIVE_SEARCH_OPTIONS()																			\
	TextSearcher::Options nativeOptions;																			\
	if(options != 0) {																								\
		options->get_CaseSensitivity(																				\
			reinterpret_cast<CaseFoldingType*>(&nativeOptions.caseSensitivity));									\
		FoldingType ft;																								\
		options->get_FoldingOption(&ft);																			\
		for(int f = FoldingOptions::FOLDING_START; f < FoldingOptions::FOLDING_END; ++f)							\
			nativeOptions.foldings[f] = toBoolean(ft & (1 << (f - FoldingOptions::FOLDING_START)));					\
		MultigraphExpansionType met;																				\
		options->get_MultigraphExpansionOption(&met);																\
		for(int f = FoldingOptions::MULTIGRAPH_EXPANSION_START; f < FoldingOptions::MULTIGRAPH_EXPANSION_END; ++f)	\
			nativeOptions.foldings[f] = toBoolean(met & (1 << (f - FoldingOptions::MULTIGRAPH_EXPANSION_START)));	\
/*		ProvisionalFoldingType pft;																					\
		options->get_ProvisionalFoldingOption(&pft);																\
		for(int f = FoldingOptions::PROVISIONAL_FOLDING_START; f < FoldingOptions::PROVISIONAL_FOLDING_END; ++f)	\
			options.foldings[f] = toBoolean(pft & (1 << (f - FoldingOptions::PROVISIONAL_FOLDING_START)));			\
*/		CharacterSkipType cst;																						\
		options->get_CharacterSkipOption(&cst);																		\
		for(int f = FoldingOptions::CHARACTER_SKIP_START; f < FoldingOptions::CHARACTER_SKIP_END; ++f)				\
			nativeOptions.foldings[f] = toBoolean(cst & (1 << (f - FoldingOptions::CHARACTER_SKIP_START)));			\
		options->get_SearchType(reinterpret_cast<::SearchType*>(&nativeOptions.type));								\
		options->get_WholeWord(reinterpret_cast<VARIANT_BOOL*>(&nativeOptions.wholeWord));							\
	}

/// RXgN^
TextEditor::TextEditor(AlphaApp& app, AlphaView& view) : SAFE_MARK, app_(app), view_(view) {
}

/// @see ITextEditor::BackSpace
STDMETHODIMP TextEditor::BackSpace() {
	DeletionCommand(view_, DeletionCommand::PREVIOUS_CHARACTER).execute();
	return S_OK;
}

/// @see ITextEditor::BeginEditCollection
STDMETHODIMP TextEditor::BeginEditCollection() {
	view_.getDocument().beginEditCollection();
	return S_OK;
}

/// @see ITextEditor::BookmarkAll
STDMETHODIMP TextEditor::BookmarkAll(BSTR pattern, ISearchOptions* options /* = 0 */, long* count /* = 0 */) {
	GENERATE_NATIVE_SEARCH_OPTIONS();
	view_.getTextSearcher().setOptions(nativeOptions);
	view_.getTextSearcher().setSearchText(pattern);
	const ulong	c = FindAllCommand(view_, FindAllCommand::BOOKMARK, false).execute();
	if(count != 0)
		*count = static_cast<long>(c);
	return S_OK;
}

/// @see ITextEditor::ClearAllBookmarks
STDMETHODIMP TextEditor::ClearAllBookmarks() {
	BookmarkCommand(view_, BookmarkCommand::CLEAR_ALL).execute();
	return S_OK;
}

/// @see ITextEditor::ClearUndoBuffer
STDMETHODIMP TextEditor::ClearUndoBuffer() {
	view_.getDocument().clearUndoBuffer();
	return S_OK;
}

/// @see ITextEditor::CreateEditPoint
STDMETHODIMP TextEditor::CreateEditPoint(ITextPoint* sourcePoint, IEditPoint** newPoint) {
	if(newPoint != 0) {
		if(sourcePoint == 0)
			return E_INVALIDARG;

		auto_ptr<VisualPoint> temp(view_.getDocument().createEditPoint());
		if(*newPoint = new TextPoint(*temp, true)) {
			long line, column;
			temp.release();
			(*newPoint)->AddRef();
			sourcePoint->get_Line(&line);
			sourcePoint->get_Char(&column);
			(*newPoint)->MoveTo(line, column);
		} else
			return E_OUTOFMEMORY;

	}
	return S_OK;
}

/// @see ITextEditor::CreateSearchOptions
STDMETHODIMP TextEditor::CreateSearchOptions(ISearchOptions** options) {
	if(options == 0)
		return S_OK;
	else if(*options = new SearchOptions) {
		(*options)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see ITextEditor::Delete
STDMETHODIMP TextEditor::Delete() {
	DeletionCommand(view_, DeletionCommand::NEXT_CHARACTER).execute();
	return S_OK;
}

/// @see ITextEditor::EndEditCollection
STDMETHODIMP TextEditor::EndEditCollection() {
	view_.getDocument().endEditCollection();
	return S_OK;
}

/// @see ITextEditor::FindNext
STDMETHODIMP TextEditor::FindNext(BSTR pattern, ISearchOptions* options /* = 0 */, VARIANT_BOOL* found /* = 0 */) {
	if(isEmptyBSTR(pattern))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	view_.getTextSearcher().setOptions(nativeOptions);
	view_.getTextSearcher().setSearchText(pattern);

	FindNextCommand command(view_, false, true);
	const bool f = command.execute() == 0;
	if(!f) {
		if(command.getLastResult().isBadRegexError()) {
			ComException e(SCRIPT_E_BADREGEXP, IID_ITextEditor, OLESTR("Ambient.TextEditor.FindNext"));
			e.throwLogicalThreadError();
			return e.getSCode();
		} else if(command.getLastResult().getCode() != SearchError::MIGEMO_ERROR)
			return E_OUTOFMEMORY;
		else
			return E_FAIL;
	}
	if(found != 0)
		*found = toVariantBoolean(f);
	return S_OK;
}

/// @see ITextEditor::FindPrev
STDMETHODIMP TextEditor::FindPrev(BSTR pattern, ISearchOptions* options /* = 0 */, VARIANT_BOOL* found /* = 0 */) {
	if(isEmptyBSTR(pattern))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	view_.getTextSearcher().setOptions(nativeOptions);
	view_.getTextSearcher().setSearchText(pattern);

	FindNextCommand command(view_, false, false);
	const bool f = command.execute() == 0;
	if(!f) {
		if(command.getLastResult().isBadRegexError()) {
			ComException e(SCRIPT_E_BADREGEXP, IID_ITextEditor, OLESTR("Ambient.TextEditor.FindPrev"));
			e.throwLogicalThreadError();
			return e.getSCode();
		} else if(command.getLastResult().getCode() != SearchError::MIGEMO_ERROR)
			return E_OUTOFMEMORY;
		else
			return E_FAIL;
	}
	if(found != 0)
		*found = toVariantBoolean(f);
	return S_OK;
}

/// @see ITextEditor::Freeze
STDMETHODIMP TextEditor::Freeze() {
	view_.freeze();
	return S_OK;
}

/// @see ITextEditor::get_Buffer
STDMETHODIMP TextEditor::get_Buffer(IBuffer** buffer) {
	return view_.getDocument().getAutomation(app_.getBufferList(), *buffer);
}

/// @see ITextEditor::get_ClipboardRing
STDMETHODIMP TextEditor::get_ClipboardRing(IClipboardRing** clipboardRing) {
	VERIFY_POINTER(clipboardRing);
	if(0 == (*clipboardRing = new Ambient::ClipboardRing(EditView::getClipboardRing())))
		return E_OUTOFMEMORY;
	(*clipboardRing)->AddRef();
	return S_OK;
}

/// @see ITextEditor::get_CollectingEdit
STDMETHODIMP TextEditor::get_CollectingEdit(VARIANT_BOOL* collecting) {
	VERIFY_POINTER(collecting);
	*collecting = toVariantBoolean(view_.getDocument().isCollectingEdit());
	return S_OK;
}

/// @see ITextEditor::get_Lexer
STDMETHODIMP TextEditor::get_Lexer(ILexer** lexer) {
	return view_.getAutomation(*lexer);
}

/// @see ITextEditor::get_OvertypeMode
STDMETHODIMP TextEditor::get_OvertypeMode(VARIANT_BOOL* overtypeMode) {
	VERIFY_POINTER(overtypeMode);
	*overtypeMode = toVariantBoolean(view_.isOvertypeMode());
	return S_OK;
}

/// @see ITextEditor::get_Preferences
STDMETHODIMP TextEditor::get_Preferences(IEditorPreferences** preferences) {
	return view_.getAutomation(*preferences);
}

/// @see ITextEditor::get_Selection
STDMETHODIMP TextEditor::get_Selection(ITextSelection** selection) {
	return view_.getAutomation(*selection);
}

/// @see ITextEditor::InputChar
STDMETHODIMP TextEditor::InputChar(VARIANT ch, VARIANT_BOOL* succeeded) {
	bool s = true;

	if(succeeded != 0)
		*succeeded = VARIANT_FALSE;
	if(ch.vt == VT_I4)	// R[h|Cgɂ
		s = toBoolean(StandardCommands::CharacterInputCommand(view_, ch.lVal).execute());
	else if(ch.vt == VT_BSTR) {	// UTF-16 ɂ
		if(ch.bstrVal == 0)
			return E_INVALIDARG;
		if(const UINT len = ::SysStringLen(ch.bstrVal)) {
			size_t	i = 0;
			for(; i < len; ++i) {
				const CodePoint cp = UTF16Surrogates::decode(ch.bstrVal + i, len - i);

				if(!BoundaryDetector::isGraphemeExtend(cp)) {
					if(i != 0)
						break;
				} else if(i == 0) {
					i += (cp < 0x010000) ? 1 : 2;
					break;
				}
				if(cp > 0xFFFF)
					++i;
			}
			for(size_t j = 0; j < i; ++j) {
				if(!toBoolean(StandardCommands::CharacterInputCommand(view_, ch.bstrVal[j]).execute()))
					break;
			}
		} else
			return E_INVALIDARG;
	} else
		return E_INVALIDARG;
	if(succeeded != 0 && s)
		*succeeded = toVariantBoolean(s);
	return S_OK;
}

/// @see ITextEditor::NewLine
STDMETHODIMP TextEditor::NewLine() {
	LineBreakCommand(view_, false).execute();
	return S_OK;
}

/// @see ITextEditor::Paste
STDMETHODIMP TextEditor::Paste() {
	ClipboardCommand(view_, ClipboardCommand::PASTE, false).execute();
	return S_OK;
}

/// @see ITextEditor::PasteFromClipboardRing
STDMETHODIMP TextEditor::PasteFromClipboardRing() {
	ClipboardCommand(view_, ClipboardCommand::PASTE, true).execute();
	return S_OK;
}

/// @see ITextEditor::put_OvertypeMode
STDMETHODIMP TextEditor::put_OvertypeMode(VARIANT_BOOL overtypeMode) {
	view_.setOvertypeMode(toBoolean(overtypeMode));
	return S_OK;
}

/// @see ITextEditor::Redo
STDMETHODIMP TextEditor::Redo() {
	UndoCommand(view_, false).execute();
	return S_OK;
}

/// @see ITextEditor::ReplaceAll
STDMETHODIMP TextEditor::ReplaceAll(BSTR findWhat, BSTR replaceWith /* = 0 */, ISearchOptions* options /* = 0 */, long* count) {
	if(isEmptyBSTR(findWhat))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	view_.getTextSearcher().setOptions(nativeOptions);
	view_.getTextSearcher().setSearchText(findWhat);
	view_.getTextSearcher().setReplaceText(SAFE_BSTR(replaceWith));
	const ulong	c = FindAllCommand(view_, FindAllCommand::REPLACE, false).execute();
	if(count != 0)
		*count = static_cast<long>(c);
	return S_OK;
}

/// @see ITextEditor::ReplaceAndNext
STDMETHODIMP TextEditor::ReplaceAndNext(BSTR findWhat,
		BSTR replaceWith /* = 0 */, ISearchOptions* options /* = 0 */, VARIANT_BOOL* found /* = 0 */) {
	if(isEmptyBSTR(findWhat))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	view_.getTextSearcher().setOptions(nativeOptions);
	view_.getTextSearcher().setSearchText(findWhat);
	view_.getTextSearcher().setReplaceText(SAFE_BSTR(replaceWith));
	const bool f = FindNextCommand(view_, true, true).execute() == 0;
	if(found != 0)
		*found = toVariantBoolean(f);
	return S_OK;
}

/// @see ITextEditor::ReplaceAndPrev
STDMETHODIMP TextEditor::ReplaceAndPrev(BSTR findWhat,
		BSTR replaceWith /* = 0 */, ISearchOptions* options /* = 0 */, VARIANT_BOOL* found /* = 0 */) {
	if(isEmptyBSTR(findWhat))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	view_.getTextSearcher().setOptions(nativeOptions);
	view_.getTextSearcher().setSearchText(findWhat);
	view_.getTextSearcher().setReplaceText(SAFE_BSTR(replaceWith));
	const bool f = FindNextCommand(view_, true, false).execute() == 0;
	if(found != 0)
		*found = toVariantBoolean(f);
	return S_OK;
}

/// @see ITextEditor::Undo
STDMETHODIMP TextEditor::Undo() {
	view_.getDocument().undo();
	return S_OK;
}

/// @see ITextEditor::Unfreeze
STDMETHODIMP TextEditor::Unfreeze() {
	view_.unfreeze();
	return S_OK;
}


// TextSelection class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
TextSelection::TextSelection(AlphaView& view) : SAFE_MARK, view_(view) {
}

/// @see ITextSelection::Cancel
STDMETHODIMP TextSelection::Cancel() {
	CancelCommand(view_).execute();
	return S_OK;
}

/// @see ITextSelection::CharNext
STDMETHODIMP TextSelection::CharNext(VARIANT_BOOL extend /* = VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return CharPrev(extend, -offset);
	CaretMovementCommand(view_, CaretMovementCommand::NEXT_CHARACTER, toBoolean(extend), offset).execute();
	return S_OK;
}

/// @see ITextSelection::CharPrev
STDMETHODIMP TextSelection::CharPrev(VARIANT_BOOL extend /* = VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return CharNext(extend, -offset);
	CaretMovementCommand(view_, CaretMovementCommand::PREVIOUS_CHARACTER, toBoolean(extend), offset).execute();
	return S_OK;
}

/// @see ITextSelection::Convert
STDMETHODIMP TextSelection::Convert(ConvertType type) {
	return E_NOTIMPL;
}

/// @see ITextSelection::Copy
STDMETHODIMP TextSelection::Copy(VARIANT_BOOL alsoSendToClipboardRing /* = VARIANT_TRUE */) {
	ClipboardCommand(view_, ClipboardCommand::COPY, toBoolean(alsoSendToClipboardRing)).execute();
	return S_OK;
}

/// @see ITextSelection::Cut
STDMETHODIMP TextSelection::Cut(VARIANT_BOOL alsoSendToClipboardRing /* = VARIANT_TRUE */) {
	ClipboardCommand(view_, ClipboardCommand::CUT, toBoolean(alsoSendToClipboardRing)).execute();
	return S_OK;
}

/// @see ITextSelection::get_ActiveEndGreater
STDMETHODIMP TextSelection::get_ActiveEndGreater(VARIANT_BOOL* activeEndGreater) {
	VERIFY_POINTER(activeEndGreater);
	*activeEndGreater = toVariantBoolean(view_.getSelection().getAnchorPoint() < view_.getSelection().getActivePoint());
	return S_OK;
}

/// @see ITextSelection::get_ActivePoint
STDMETHODIMP TextSelection::get_ActivePoint(ITextPoint** activePoint) {
	VERIFY_POINTER(activePoint);

	auto_ptr<VisualPoint> temp(view_.getDocument().createEditPoint());
	temp->moveTo(view_.getSelection().getActivePoint());
	if(*activePoint = new TextPoint(*temp, false)) {
		temp.release();
		(*activePoint)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see ITextSelection::get_AnchorPoint
STDMETHODIMP TextSelection::get_AnchorPoint(ITextPoint** anchorPoint) {
	VERIFY_POINTER(anchorPoint);

	auto_ptr<VisualPoint> temp(view_.getDocument().createEditPoint());
	temp->moveTo(view_.getSelection().getAnchorPoint());
	if(*anchorPoint = new TextPoint(*temp, false)) {
		temp.release();
		(*anchorPoint)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see ITextSelection::get_BottomPoint
STDMETHODIMP TextSelection::get_BottomPoint(ITextPoint** bottomPoint) {
	VERIFY_POINTER(bottomPoint);

	auto_ptr<VisualPoint> temp(view_.getDocument().createEditPoint());
	temp->moveTo(view_.getSelection().getEndPoint());
	if(*bottomPoint = new TextPoint(*temp, false)) {
		temp.release();
		(*bottomPoint)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see ITextSelection::get_Empty
STDMETHODIMP TextSelection::get_Empty(VARIANT_BOOL* empty) {
	VERIFY_POINTER(empty);
	*empty = toVariantBoolean(view_.getSelection().isEmpty());
	return S_OK;
}

/// @see ITextSelection::get_Text
STDMETHODIMP TextSelection::get_Text(BSTR* text) {
	VERIFY_POINTER(text);
	*text = ::SysAllocString(view_.getSelection().getText().c_str());
	return (*text != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see ITextSelection::get_TextRanges
STDMETHODIMP TextSelection::get_TextRanges(ITextRanges** ranges) {
	VERIFY_POINTER(ranges);
	*ranges = 0;
	return E_NOTIMPL;
}

/// @see ITextSelection::get_TopPoint
STDMETHODIMP TextSelection::get_TopPoint(ITextPoint** topPoint) {
	VERIFY_POINTER(topPoint);

	auto_ptr<VisualPoint> temp(view_.getDocument().createEditPoint());
	temp->moveTo(view_.getSelection().getStartPoint());
	if(*topPoint = new TextPoint(*temp, false)) {
		temp.release();
		(*topPoint)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see ITextSelection::Indent
STDMETHODIMP TextSelection::Indent() {
	IndentationCommand(view_, true, true, 1).execute();
	return S_OK;
}

/// @see ITextSelection::LineDown
STDMETHODIMP TextSelection::LineDown(VARIANT_BOOL extend /* VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return LineUp(extend, -offset);
	CaretMovementCommand(view_, CaretMovementCommand::NEXT_LINE, toBoolean(extend), offset).execute();
	return S_OK;
}

/// @see ITextSelection::LineUp
STDMETHODIMP TextSelection::LineUp(VARIANT_BOOL extend /* VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return LineDown(extend, -offset);
	CaretMovementCommand(view_, CaretMovementCommand::PREVIOUS_LINE, toBoolean(extend), offset).execute();
	return S_OK;
}

/// @see ITextSelection::MoveTo
STDMETHODIMP TextSelection::MoveTo(long line, long column, VARIANT_BOOL extend /* = VARIANT_FALSE */) {
	if(toBoolean(extend))
		view_.getSelection().getActivePoint().moveTo(CharPos(line, column));
	else
		view_.getSelection().moveTo(CharPos(line, column), false);
	return S_OK;
}

/// @see ITextSelection::MoveToEndOfDocument
STDMETHODIMP TextSelection::MoveToEndOfDocument(VARIANT_BOOL extend /* = VARIANT_FALSE */) {
	CaretMovementCommand(view_, CaretMovementCommand::END_OF_DOCUMENT, toBoolean(extend)).execute();
	return S_OK;
}

/// @see ITextSelection::MoveToEndOfLine
STDMETHODIMP TextSelection::MoveToEndOfLine(VARIANT_BOOL extend /* = VARIANT_FALSE */) {
	CaretMovementCommand(view_, CaretMovementCommand::END_OF_LINE, toBoolean(extend)).execute();
	return S_OK;
}

/// @see ITextSelection::MoveToFirstCharOfLine
STDMETHODIMP TextSelection::MoveToFirstCharOfLine(VARIANT_BOOL extend /* VARIANT_FALSE */) {
	CaretMovementCommand(view_, CaretMovementCommand::FIRST_CHAR_OF_LINE, toBoolean(extend)).execute();
	return S_OK;
}

/// @see ITextSelection::MoveToLastCharOfLine
STDMETHODIMP TextSelection::MoveToLastCharOfLine(VARIANT_BOOL extend /* VARIANT_FALSE */) {
	CaretMovementCommand(view_, CaretMovementCommand::LAST_CHAR_OF_LINE, toBoolean(extend)).execute();
	return S_OK;
}

/// @see ITextSelection::MoveToMatchBracket
STDMETHODIMP TextSelection::MoveToMatchBracket(VARIANT_BOOL extend /* = VARIANT_FALSE */) {
	CaretMovementCommand(view_, CaretMovementCommand::MATCH_BRACKET, toBoolean(extend)).execute();
	return S_OK;
}

/// @see ITextSelection::MoveToNextBookmark
STDMETHODIMP TextSelection::MoveToNextBookmark(VARIANT_BOOL extend /* = VARIANT_FALSE */) {
	CaretMovementCommand(view_, CaretMovementCommand::NEXT_BOOKMARK, toBoolean(extend)).execute();
	return S_OK;
}

/// @see ITextSelection::MoveToPreviousBookmark
STDMETHODIMP TextSelection::MoveToPreviousBookmark(VARIANT_BOOL extend /* = VARIANT_FALSE */) {
	CaretMovementCommand(view_, CaretMovementCommand::PREVIOUS_BOOKMARK, toBoolean(extend)).execute();
	return S_OK;
}

/// @see ITextSelection::MoveToStartOfDocument
STDMETHODIMP TextSelection::MoveToStartOfDocument(VARIANT_BOOL extend /* = VARIANT_FALSE */) {
	CaretMovementCommand(view_, CaretMovementCommand::START_OF_DOCUMENT, toBoolean(extend)).execute();
	return S_OK;
}

/// @see ITextSelection::MoveToStartOfLine
STDMETHODIMP TextSelection::MoveToStartOfLine(
		VARIANT_BOOL bToFirstText /* = VARIANT_FALSE */, VARIANT_BOOL extend /* = VARIANT_FALSE */) {
	CaretMovementCommand(view_, CaretMovementCommand::START_OF_LINE, toBoolean(extend)).execute();
	return S_OK;
}

/// @see ITextSelection::PageDown
STDMETHODIMP TextSelection::PageDown(VARIANT_BOOL extend /* VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return PageUp(extend, offset);
	CaretMovementCommand(view_, CaretMovementCommand::NEXT_PAGE, toBoolean(extend), offset).execute();
	return S_OK;
}

/// @see ITextSelection::PageUp
STDMETHODIMP TextSelection::PageUp(VARIANT_BOOL extend /* VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return PageDown(extend, offset);
	CaretMovementCommand(view_, CaretMovementCommand::PREVIOUS_PAGE, toBoolean(extend), offset).execute();
	return S_OK;
}

/// @see ITextSelection::Paste
STDMETHODIMP TextSelection::Paste() {
	ClipboardCommand(view_, ClipboardCommand::PASTE, false).execute();
	return S_OK;
}

/// @see ITextSelection::PasteFromClipboardRing
STDMETHODIMP TextSelection::PasteFromClipboardRing() {
	ClipboardCommand(view_, ClipboardCommand::PASTE, true).execute();
	return S_OK;
}

/// @see ITextSelection::Replace
STDMETHODIMP TextSelection::Replace(BSTR text) {
	view_.getSelection().replace(SAFE_BSTR(text));
	return S_OK;
}

/// @see ITextSelection::SelectAll
STDMETHODIMP TextSelection::SelectAll() {
	SelectionCreationCommand(view_, SelectionCreationCommand::ALL).execute();
	return S_OK;
}

/// @see ITextSelection::SelectLine
STDMETHODIMP TextSelection::SelectLine(long line) {
	view_.getSelection().select(CharPos(line, 0), CharPos(line, -1), false, true);
	return S_OK;
}

/// @see ITextSelection::SetBookmark
STDMETHODIMP TextSelection::SetBookmark(VARIANT_BOOL set /* = VARIANT_TRUE */) {
	view_.getBookmarker().setBookmark(view_.getSelection().getActivePoint().getLineNumber(), toBoolean(set));
	return S_OK;
}

/// @see ITextSelection::SwapAnchor
STDMETHODIMP TextSelection::SwapAnchor() {
	Selection& selection = view_.getSelection();
	selection.select(selection.getActivePoint(), selection.getAnchorPoint(), selection.isRectangle(), true);
	return S_OK;
}

/// @see ITextSelection::Tabify
STDMETHODIMP TextSelection::Tabify() {
	TabifyCommand(view_, true).execute();
	return S_OK;
}

/// @see ITextSelection::Unindent
STDMETHODIMP TextSelection::Unindent() {
	IndentationCommand(view_, false, true, 1).execute();
	return S_OK;
}

/// @see ITextSelection::Untabify
STDMETHODIMP TextSelection::Untabify() {
	TabifyCommand(view_, false).execute();
	return S_OK;
}

/// @see ITextSelection::WordEndNext
STDMETHODIMP TextSelection::WordEndNext(VARIANT_BOOL extend /* = VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return WordEndPrev(extend, -offset);
	CaretMovementCommand(view_, CaretMovementCommand::NEXT_WORDEND, toBoolean(extend), offset).execute();
	return S_OK;
}

/// @see ITextSelection::WordEndPrev
STDMETHODIMP TextSelection::WordEndPrev(VARIANT_BOOL extend /* = VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return WordEndNext(extend, -offset);
	CaretMovementCommand(view_, CaretMovementCommand::PREVIOUS_WORDEND, toBoolean(extend), offset).execute();
	return S_OK;
}

/// @see ITextSelection::WordNext
STDMETHODIMP TextSelection::WordNext(VARIANT_BOOL extend /* = VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return WordPrev(extend, -offset);
	CaretMovementCommand(view_, CaretMovementCommand::NEXT_WORD, toBoolean(extend), offset).execute();
	return S_OK;
}

/// @see ITextSelection::WordPrev
STDMETHODIMP TextSelection::WordPrev(VARIANT_BOOL extend /* = VARIANT_FALSE */, long offset /* = 1 */) {
	if(offset < 0)
		return WordNext(extend, -offset);
	CaretMovementCommand(view_, CaretMovementCommand::PREVIOUS_WORD, toBoolean(extend), offset).execute();
	return S_OK;
}


// TextPoint class implementation
/////////////////////////////////////////////////////////////////////////////

#define VERIFY_IMPL()				\
	if(impl_.isDocumentDisposed())	\
		return E_UNEXPECTED

/**
 *	RXgN^
 *	@param impl			ɂȂҏW_B̕ҏW_̓fXgN^Ŕj󂷂
 *	@param editPoint	IEditPoint ̏ꍇ trueBITextPoint ̏ꍇ false
 */
TextPoint::TextPoint(VisualPoint& impl, bool editPoint) : SAFE_MARK, impl_(impl), isEditPoint_(editPoint) {
}

/// fXgN^
TextPoint::~TextPoint() {
	delete &impl_;
}

/// @see ITextPoint::Center
STDMETHODIMP TextPoint::Center(VARIANT other, VARIANT_BOOL* inEditorRect) {
	VERIFY_IMPL();

	VARIANT	var;
	HRESULT	hr;

	::VariantInit(&var);
	if(other.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		*inEditorRect = impl_.center(getTargetView(), CharPos(line, column));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &other, 0, VT_I4))) {
		if(inEditorRect != 0)
			*inEditorRect = impl_.center(getTargetView(), var.lVal);
	} else
		return hr;
	return S_OK;
}

/// @see ITextPoint::CharNext
STDMETHODIMP TextPoint::CharNext(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.charNext(offset);
	return S_OK;
}

/// @see ITextPoint::CharRight
STDMETHODIMP TextPoint::CharPrev(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.charPrev(offset);
	return S_OK;
}

/// @see IEditPoint::Convert
STDMETHODIMP TextPoint::Convert(ConvertType type, VARIANT other) {
	VERIFY_IMPL();

	ComVariant var;
	HRESULT hr;

	if(other.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		impl_.convert(CharPos(line, column), static_cast<RangeConvertType>(type));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &other, 0, VT_I4)))
		impl_.convert(var.lVal, static_cast<RangeConvertType>(type));
	else
		return hr;
	return S_OK;
}

/// @see ITextPoint::Copy
STDMETHODIMP TextPoint::Copy(VARIANT other) {
	VERIFY_IMPL();

	ComVariant var;
	HRESULT hr;

	if(other.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		impl_.copy(CharPos(line, column));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &other, 0, VT_I4)))
		impl_.copy(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see ITextPoint::CreateEditPoint
STDMETHODIMP TextPoint::CreateEditPoint(IEditPoint** newEditPoint) {
	VERIFY_IMPL();
	if(newEditPoint != 0) {
		*newEditPoint = new TextPoint(*impl_.getDocument()->createEditPoint().release(), true);
		(*newEditPoint)->AddRef();
		(*newEditPoint)->MoveTo(static_cast<long>(impl_.getLineNumber()), static_cast<long>(impl_.getCharNumber()));
	}
	return S_OK;
}

/// @see IEditPoint::Cut
STDMETHODIMP TextPoint::Cut(VARIANT other) {
	VERIFY_IMPL();

	ComVariant var;
	HRESULT hr;

	::VariantInit(&var);
	if(other.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		impl_.cut(CharPos(line, column));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &other, 0, VT_I4)))
		impl_.cut(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see IEditPoint::Delete
STDMETHODIMP TextPoint::Delete(VARIANT other) {
	VERIFY_IMPL();

	ComVariant var;
	HRESULT hr;

	::VariantInit(&var);
	if(other.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		impl_.erase(CharPos(line, column));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &other, 0, VT_I4)))
		impl_.erase(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see IEditPoint:DestructiveInsert
STDMETHODIMP TextPoint::DestructiveInsert(BSTR text) {
	VERIFY_IMPL();
	impl_.destructiveInsert(text);
	return S_OK;
}

/// @see ITextPoint::EqualTo
STDMETHODIMP TextPoint::EqualTo(ITextPoint* other, VARIANT_BOOL* equal) {
	VERIFY_IMPL();
	if(other == 0)
		return E_INVALIDARG;
	if(equal != 0) {
		long line, column;
		other->get_Line(&line);
		other->get_Char(&column);
		*equal = toVariantBoolean(
			impl_.getLineNumber() == line && impl_.getCharNumber() == column);
	}
	return S_OK;
}

/// @see ITextPoint::get_AbsoluteCharOffset
STDMETHODIMP TextPoint::get_AbsoluteCharOffset(long* offset) {
	VERIFY_IMPL();
	VERIFY_POINTER(offset);
	*offset = static_cast<long>(impl_.getAbsoluteCharOffset());
	return S_OK;
}

/// @see ITextPoint::get_AtEndOfDocument
STDMETHODIMP TextPoint::get_AtEndOfDocument(VARIANT_BOOL* at) {
	VERIFY_IMPL();
	VERIFY_POINTER(at);
	*at = toVariantBoolean(impl_.isEndOfDocument());
	return S_OK;
}

/// @see ITextPoint::get_AtEndOfLine
STDMETHODIMP TextPoint::get_AtEndOfLine(VARIANT_BOOL* at) {
	VERIFY_IMPL();
	VERIFY_POINTER(at);
	*at = toVariantBoolean(impl_.isEndOfLine());
	return S_OK;
}

/// @see ITextPoint::get_AtFirstCharOfLine
STDMETHODIMP TextPoint::get_AtFirstCharOfLine(VARIANT_BOOL* at) {
	VERIFY_IMPL();
	VERIFY_POINTER(at);
	*at = toVariantBoolean(impl_.isFirstCharOfLine());
	return S_OK;
}

/// @see ITextPoint::get_AtLastCharOfLine
STDMETHODIMP TextPoint::get_AtLastCharOfLine(VARIANT_BOOL* at) {
	VERIFY_IMPL();
	VERIFY_POINTER(at);
	*at = toVariantBoolean(impl_.isLastCharOfLine());
	return S_OK;
}

/// @see ITextPoint::get_AtStartOfDocument
STDMETHODIMP TextPoint::get_AtStartOfDocument(VARIANT_BOOL* at) {
	VERIFY_IMPL();
	VERIFY_POINTER(at);
	*at = toVariantBoolean(impl_.isStartOfDocument());
	return S_OK;
}

/// @see ITextPoint::get_AtStartOfLine
STDMETHODIMP TextPoint::get_AtStartOfLine(VARIANT_BOOL* at) {
	VERIFY_IMPL();
	VERIFY_POINTER(at);
	*at = toVariantBoolean(impl_.isStartOfLine());
	return S_OK;
}

/// @see ITextPoint::get_Char
STDMETHODIMP TextPoint::get_Char(long* column) {
	VERIFY_IMPL();
	VERIFY_POINTER(column);
	*column = static_cast<long>(impl_.getCharNumber());
	return S_OK;
}

/// @see IEditPoint::get_CharCountConvention
STDMETHODIMP TextPoint::get_CharCountConvention(CharCountConvention* convention) {
	VERIFY_IMPL();
	VERIFY_POINTER(convention);
	*convention = static_cast<CharCountConvention>(impl_.getCharacterCountingConvention());
	return S_OK;
}

/// @see ITextPoint::get_Column
STDMETHODIMP TextPoint::get_Column(long* column) {
	VERIFY_IMPL();
	VERIFY_POINTER(column);
	*column = static_cast<long>(impl_.getColumnNumber());
	return S_OK;
}

/// @see ITextPoint::get_Line
STDMETHODIMP TextPoint::get_Line(long* line) {
	VERIFY_IMPL();
	VERIFY_POINTER(line);
	*line = static_cast<long>(impl_.getLineNumber());
	return S_OK;
}

/// @see ITextPoint::get_LineLength
STDMETHODIMP TextPoint::get_LineLength(long* length) {
	VERIFY_IMPL();
	VERIFY_POINTER(length);
	*length = static_cast<long>(impl_.getLineLength());
	return S_OK;
}

/// @see IEditPoint::get_RestrictionExclusive
STDMETHODIMP TextPoint::get_RestrictionExclusive(VARIANT_BOOL* exclusive) {
	VERIFY_IMPL();
	VERIFY_POINTER(exclusive);
	*exclusive = toVariantBoolean(impl_.isExcludedFromRestriction());
	return S_OK;
}

/// @see IEditPoint::put_CharCountConvention
STDMETHODIMP TextPoint::put_CharCountConvention(CharCountConvention convention) {
	VERIFY_IMPL();
	impl_.setCharacterCountingConvention(static_cast<EditPoint::CharacterCountingConvention>(convention));
	return S_OK;
}

/// @see IEditPoint::put_RestrictionExclusive
STDMETHODIMP TextPoint::put_RestrictionExclusive(VARIANT_BOOL exclusive) {
	VERIFY_IMPL();
	impl_.excludeFromRestriction(toBoolean(exclusive));
	return S_OK;
}

/// Ώۂ̃r[Ԃ (肠)
EditView& TextPoint::getTargetView() const {
	const EditDoc& buffer = *impl_.getDocument();
	const size_t c = buffer.getCount();
	for(size_t i = 0; i < c; ++i) {
		if(buffer.getView(i).hasFocus())
			return buffer.getView(i);
	}
	return buffer.getView(0);
}

/// @see IEditPoint::GetText
STDMETHODIMP TextPoint::GetText(VARIANT other, BSTR* text) {
	VERIFY_IMPL();
	if(text != 0) {
		ComVariant var;
		HRESULT hr;

		::VariantInit(&var);
		if(other.vt == VT_DISPATCH) {
			GENERATE_CHARPOS_FROM_TEXTPOINT();
			*text = ::SysAllocString(impl_.getText(CharPos(line, column)).c_str());
		} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &other, 0, VT_I4)))
			*text = ::SysAllocString(impl_.getText(var.lVal).c_str());
		else {
			*text = 0;
			return hr;
		}
	}
	return (*text != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see ITextPoint::GreaterThan
STDMETHODIMP TextPoint::GreaterThan(ITextPoint* other, VARIANT_BOOL* greater) {
	VERIFY_IMPL();
	if(other == 0)
		return E_INVALIDARG;
	if(greater != 0) {
		ulong line, column;
		other->get_Line(reinterpret_cast<long*>(&line));
		if(impl_.getLineNumber() > line)
			*greater = VARIANT_TRUE;
		else if(impl_.getLineNumber() < line)
			*greater = VARIANT_FALSE;
		else {
			other->get_Char(reinterpret_cast<long*>(&column));
			*greater = toVariantBoolean(impl_.getCharNumber() > column);
		}
	}
	return S_OK;
}

/// @see IEditPoint::Indent
STDMETHODIMP TextPoint::Indent(VARIANT other, short level /* = 1 */) {
	VERIFY_IMPL();

	ComVariant var;
	if(other.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		impl_.tabIndent(CharPos(line, column), false, level);
	} else
		return DISP_E_TYPEMISMATCH;
	return S_OK;
}

/// @see IEditPoint::Insert
STDMETHODIMP TextPoint::Insert(BSTR text) {
	VERIFY_IMPL();
	impl_.insert(text);
	return S_OK;
}

/// @see ITextPoint::Invoke
STDMETHODIMP TextPoint::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT hr = DISP_E_MEMBERNOTFOUND;
	ComVariant args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTPOINT_ABSOLUTECHAROFFSET:	CALL_GETTER(AbsoluteCharOffset, VT_I4);
		case DISPID_TEXTPOINT_ATENDOFDOCUMENT:		CALL_GETTER(AtEndOfDocument, VT_BOOL);
		case DISPID_TEXTPOINT_ATENDOFLINE:			CALL_GETTER(AtEndOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_ATFIRSTCHAROFLINE:	CALL_GETTER(AtFirstCharOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_ATLASTCHAROFLINE:		CALL_GETTER(AtLastCharOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_ATSTARTOFDOCUMENT:	CALL_GETTER(AtStartOfDocument, VT_BOOL);
		case DISPID_TEXTPOINT_ATSTARTOFLINE:		CALL_GETTER(AtStartOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_CHAR:					CALL_GETTER(Char, VT_I4);
		case DISPID_TEXTPOINT_COLUMN:				CALL_GETTER(Column, VT_I4);
		case DISPID_TEXTPOINT_LINE:					CALL_GETTER(Line, VT_I4);
		case DISPID_TEXTPOINT_LINELENGTH:			CALL_GETTER(LineLength, VT_I4);
		default:
			if(isEditPoint_ && dispidMember == DISPID_EDITPOINT_CHARCOUNTCONVENTION) {
				CALL_GETTER_ENUM(CharCountConvention, CharCountConvention);
			} else if(isEditPoint_ && dispidMember == DISPID_EDITPOINT_RESTRICTIONEXCLUSIVE) {
				CALL_GETTER(RestrictionExclusive, VT_BOOL);
			}
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		if(isEditPoint_ && dispidMember == DISPID_EDITPOINT_CHARCOUNTCONVENTION) {
			CALL_PUTTER_ENUM(CharCountConvention, CharCountConvention);
		} else if(isEditPoint_ && dispidMember == DISPID_EDITPOINT_RESTRICTIONEXCLUSIVE) {
				CALL_PUTTER(RestrictionExclusive, VT_BOOL);
			}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTPOINT_CENTER:	CALL_METHOD_RET_1(Center, VT_BOOL, VT_VARIANT);
		case DISPID_TEXTPOINT_CREATEEDITPOINT:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_DISPATCH);
			return CreateEditPoint((pVarResult != 0) ?
				reinterpret_cast<IEditPoint**>(&pVarResult->pdispVal) : 0);
		case DISPID_TEXTPOINT_EQUALTO:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return EqualTo(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_GREATERTHAN:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return GreaterThan(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_LESSTHAN:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return LessThan(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_REVEAL:	CALL_METHOD_RET_1(Reveal, VT_BOOL, VT_VARIANT);
		default:
			if(isEditPoint_) {
				switch(dispidMember) {
				case DISPID_EDITPOINT_CHARNEXT:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(CharNext);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(CharNext, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_CHARPREV:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(CharPrev);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(CharPrev, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_CONVERT:
					VERIFY_ARGUMENTS_COUNT(2);
					COERCE_ARGUMENT_AT(1, VT_I2);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Convert(static_cast<ConvertType>(args[1].iVal), args[0]);
				case DISPID_EDITPOINT_COPY:						CALL_METHOD_1(Copy, VT_VARIANT);
				case DISPID_EDITPOINT_CUT:						CALL_METHOD_1(Cut, VT_VARIANT);
				case DISPID_EDITPOINT_DELETE:					CALL_METHOD_1(Delete, VT_VARIANT);
				case DISPID_EDITPOINT_DESTRUCTIVEINSERT:		CALL_METHOD_1(DestructiveInsert, VT_BSTR);
				case DISPID_EDITPOINT_GETTEXT:					CALL_METHOD_RET_1(GetText, VT_BSTR, VT_VARIANT);
				case DISPID_EDITPOINT_INDENT:
					if(pDispParams->cArgs == 1) {				CALL_METHOD_1(Indent, VT_VARIANT);}
					else if(pDispParams->cArgs == 2) {			CALL_METHOD_2(Indent, VT_VARIANT, VT_I2);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_INSERT:					CALL_METHOD_1(Insert, VT_BSTR);
				case DISPID_EDITPOINT_LINEDOWN:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(LineDown);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(LineDown, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_LINEUP:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(LineUp);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(LineUp, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_MOVETO:					CALL_METHOD_2(MoveTo, VT_I4, VT_I4);
				case DISPID_EDITPOINT_MOVETOABSOLUTEOFFSET:		CALL_METHOD_1(MoveToAbsoluteOffset, VT_I4);
				case DISPID_EDITPOINT_MOVETOENDOFDOCUMENT:		CALL_METHOD_0(MoveToEndOfDocument);
				case DISPID_EDITPOINT_MOVETOENDOFLINE:			CALL_METHOD_0(MoveToEndOfLine);
				case DISPID_EDITPOINT_MOVETOFIRSTCHAROFLINE:	CALL_METHOD_0(MoveToFirstCharOfLine);
				case DISPID_EDITPOINT_MOVETOLASTCHAROFLINE:		CALL_METHOD_0(MoveToLastCharOfLine);
				case DISPID_EDITPOINT_MOVETONEXTBOOKMARK:		CALL_METHOD_0(MoveToNextBookmark);
				case DISPID_EDITPOINT_MOVETOPREVIOUSBOOKMARK:	CALL_METHOD_0(MoveToPreviousBookmark);
				case DISPID_EDITPOINT_MOVETOSTARTOFDOCUMENT:	CALL_METHOD_0(MoveToStartOfDocument);
				case DISPID_EDITPOINT_MOVETOSTARTOFLINE:		CALL_METHOD_0(MoveToStartOfLine);
				case DISPID_EDITPOINT_NEWLINE:					CALL_METHOD_0(NewLine);
				case DISPID_EDITPOINT_PAGEDOWN:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(PageDown);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(PageDown, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_PAGEUP:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(PageUp);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(PageUp, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_PASTE:
					if(pDispParams->cArgs == 0) {
						args[0] = 0;
						return Paste(args[0]);
					} else if(pDispParams->cArgs == 1) {		CALL_METHOD_1(Paste, VT_VARIANT);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_REPLACE:					CALL_METHOD_2(Replace, VT_BSTR, VT_VARIANT);
				case DISPID_EDITPOINT_SETBOOKMARK:
					if(pDispParams->cArgs == 0)	{			CALL_METHOD_0(SetBookmark);}
					else if(pDispParams->cArgs == 1)	{	CALL_METHOD_1(SetBookmark, VT_BOOL);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_TRANSPOSECHARS:			CALL_METHOD_0(TransposeChars);
				case DISPID_EDITPOINT_TRANSPOSELINES:			CALL_METHOD_0(TransposeLines);
				case DISPID_EDITPOINT_TRANSPOSEPARAGRAPHS:		CALL_METHOD_0(TransposeParagraphs);
				case DISPID_EDITPOINT_TRANSPOSEWORDS:			CALL_METHOD_0(TransposeWords);
				case DISPID_EDITPOINT_UNINDENT:
					if(pDispParams->cArgs == 1) {				CALL_METHOD_1(Unindent, VT_VARIANT);}
					else if(pDispParams->cArgs == 2) {			CALL_METHOD_2(Unindent, VT_VARIANT, VT_I2);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDENDNEXT:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(WordEndNext);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(WordEndNext, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDENDPREV:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(WordEndPrev);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(WordEndPrev, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDNEXT:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(WordNext);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(WordNext, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDPREV:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(WordEndPrev);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(WordEndPrev, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				}
			}
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

/// @see IObjectIdentity::IsEqualObject
STDMETHODIMP TextPoint::IsEqualObject(IUnknown* other) {
	if(other == 0)
		return E_INVALIDARG;
	ComPtr<ITextPoint> rhs;
	if(FAILED(other->QueryInterface(IID_ITextPoint, reinterpret_cast<void**>(&rhs))))
		return S_FALSE;

	VARIANT_BOOL b;
	EqualTo(rhs, &b);
	return toBoolean(b) ? S_OK : S_FALSE;
}

/// @see ITextPoint::LessThan
STDMETHODIMP TextPoint::LessThan(ITextPoint* other, VARIANT_BOOL* less) {
	VERIFY_IMPL();
	if(other == 0)
		return E_INVALIDARG;
	if(less != 0) {
		ulong line, column;
		other->get_Line(reinterpret_cast<long*>(&line));
		if(impl_.getLineNumber() < line)
			*less = VARIANT_TRUE;
		else if(impl_.getLineNumber() > line)
			*less = VARIANT_FALSE;
		else {
			other->get_Char(reinterpret_cast<long*>(&column));
			*less = toVariantBoolean(impl_.getCharNumber() < column);
		}
	}
	return S_OK;
}

/// @see ITextPoint::LineDown
STDMETHODIMP TextPoint::LineDown(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.lineDown(offset);
	return S_OK;
}

/// @see ITextPoint::LineUp
STDMETHODIMP TextPoint::LineUp(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.lineUp(offset);
	return S_OK;
}

/// @see ITextPoint::MoveTo
STDMETHODIMP TextPoint::MoveTo(long line, long column) {
	VERIFY_IMPL();
	impl_.moveTo(CharPos(line, column));
	return S_OK;
}

/// @see ITextPoint::MoveToAbsoluteOffset
STDMETHODIMP TextPoint::MoveToAbsoluteOffset(long offset) {
	VERIFY_IMPL();
	impl_.moveToAbsoluteCharOffset(offset);
	return S_OK;
}

/// @see ITextPoint::MoveToEndOfDocument
STDMETHODIMP TextPoint::MoveToEndOfDocument() {
	VERIFY_IMPL();
	impl_.moveToEndOfDocument();
	return S_OK;
}

/// @see ITextPoint::MoveToEndOfLine
STDMETHODIMP TextPoint::MoveToEndOfLine() {
	VERIFY_IMPL();
	impl_.moveToEndOfLine();
	return S_OK;
}

/// @see ITextPoint::MoveToFirstCharOfLine
STDMETHODIMP TextPoint::MoveToFirstCharOfLine() {
	VERIFY_IMPL();
	impl_.moveToFirstCharOfLine();
	return S_OK;
}

/// @see ITextPoint::MoveToLastCharOfLine
STDMETHODIMP TextPoint::MoveToLastCharOfLine() {
	VERIFY_IMPL();
	impl_.moveToLastCharOfLine();
	return S_OK;
}

/// @see ITextPoint::MoveToNextBookmark
STDMETHODIMP TextPoint::MoveToNextBookmark() {
	VERIFY_IMPL();
	impl_.moveToNextBookmark();
	return S_OK;
}

/// @see ITextPoint::MoveToPreviousBookmark
STDMETHODIMP TextPoint::MoveToPreviousBookmark() {
	VERIFY_IMPL();
	impl_.moveToPrevBookmark();
	return S_OK;
}

/// @see ITextPoint::MoveToStartOfDocument
STDMETHODIMP TextPoint::MoveToStartOfDocument() {
	VERIFY_IMPL();
	impl_.moveToStartOfDocument();
	return S_OK;
}

/// @see ITextPoint::MoveToStartOfLine
STDMETHODIMP TextPoint::MoveToStartOfLine() {
	VERIFY_IMPL();
	impl_.moveToStartOfLine();
	return S_OK;
}

/// @see IEditPoint::NewLine
STDMETHODIMP TextPoint::NewLine() {
	VERIFY_IMPL();
	impl_.newLine();
	return S_OK;
}

/// @see ITextPoint::PageDown
STDMETHODIMP TextPoint::PageDown(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.pageDown(offset);
	return S_OK;
}

/// @see ITextPoint::PageUp
STDMETHODIMP TextPoint::PageUp(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.pageUp(offset);
	return S_OK;
}

/// @see IEditPoint::Paste
STDMETHODIMP TextPoint::Paste(VARIANT other) {
	VERIFY_IMPL();

	ComVariant var;
	HRESULT hr;

	if(other.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		impl_.paste(CharPos(line, column));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &other, 0, VT_I4)))
		impl_.EditPoint::paste(var.lVal);	// B[
	else
		return hr;
	return S_OK;
}

/// @see IEditPoint::Replace
STDMETHODIMP TextPoint::Replace(BSTR text, VARIANT other) {
	VERIFY_IMPL();

	HRESULT hr;
	impl_.getDocument()->beginEditCollection();
	if(FAILED(hr = Delete(other)) || FAILED(hr = Insert(text))) {
		impl_.getDocument()->endEditCollection();
		return hr;
	}
	impl_.getDocument()->endEditCollection();
	return S_OK;
}

/// @see ITextPoint::Reveal
STDMETHODIMP TextPoint::Reveal(VARIANT other, VARIANT_BOOL* inEditorRect) {
	VERIFY_IMPL();

	VARIANT var;
	HRESULT hr;

	::VariantInit(&var);
	if(other.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		*inEditorRect = impl_.reveal(getTargetView(), CharPos(line, column));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &other, 0, VT_I4))) {
		if(inEditorRect != 0)
			*inEditorRect = impl_.reveal(getTargetView(), var.lVal);
	} else
		return hr;
	return S_OK;
}

/// @see IEditPoint::SetBookmark
STDMETHODIMP TextPoint::SetBookmark(VARIANT_BOOL set /* = VARIANT_TRUE */) {
	VERIFY_IMPL();
	impl_.getDocument()->getView(0).getBookmarker().setBookmark(impl_.getLineNumber(), toBoolean(set));
	return S_OK;
}

/// @see IEditPoint::TransposeChars
STDMETHODIMP TextPoint::TransposeChars() {
	VERIFY_IMPL();
	impl_.transposeChars();
	return S_OK;
}

/// @see IEditPoint::TransposeLines
STDMETHODIMP TextPoint::TransposeLines() {
	VERIFY_IMPL();
	impl_.transposeLines();
	return S_OK;
}

/// @see IEditPoint::TransposeParagraphs
STDMETHODIMP TextPoint::TransposeParagraphs() {
	VERIFY_IMPL();
//	impl_.transposeParagraphs();
//	return S_OK;
	return E_NOTIMPL;
}

/// @see IEditPoint::TransposeWords
STDMETHODIMP TextPoint::TransposeWords() {
	VERIFY_IMPL();
	impl_.transposeWords();
	return S_OK;
}

/// @see IEditPoint::Unindent
STDMETHODIMP TextPoint::Unindent(VARIANT other, short level /* = 1 */) {
	VERIFY_IMPL();

	VARIANT var;
	if(other.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		impl_.tabIndent(CharPos(line, column), false, -level);
	} else
		return DISP_E_TYPEMISMATCH;
	return S_OK;
}

/// @see ITextPoint::WordEndNext
STDMETHODIMP TextPoint::WordEndNext(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.wordEndNext(offset);
	return S_OK;
}

/// @see ITextPoint::WordEndPrev
STDMETHODIMP TextPoint::WordEndPrev(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.wordEndPrev(offset);
	return S_OK;
}

/// @see ITextPoint::WordNext
STDMETHODIMP TextPoint::WordNext(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.wordNext(offset);
	return S_OK;
}

/// @see ITextPoint::WordPrev
STDMETHODIMP TextPoint::WordPrev(long offset /* = 1 */) {
	VERIFY_IMPL();
	impl_.wordPrev(offset);
	return S_OK;
}

#undef VERIFY_IMPL


// TextRange class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Ambient::TextRange::TextRange(EditPoint& pos1, EditPoint& pos2) : SAFE_MARK, pos1_(pos1), pos2_(pos2) {
}

/// @see ITextRange::get_EndPoint
STDMETHODIMP Ambient::TextRange::get_EndPoint(ITextPoint** endPoint) {
	VERIFY_POINTER(endPoint);
//	*endPoint = new TextPoint(app_, impl_.getEndPoint());
//	(*endPoint)->AddRef();
	return E_NOTIMPL;
}

/// @see ITextRange::get_StartPoint
STDMETHODIMP Ambient::TextRange::get_StartPoint(ITextPoint** startPoint) {
	VERIFY_POINTER(startPoint);
//	*startPoint = new TextPoint(app_, impl_.getStartPoint());
//	(*startPoint)->AddRef();
	return E_NOTIMPL;
}

/// @see IObjectIdentity::IsEqualObject
STDMETHODIMP Ambient::TextRange::IsEqualObject(IUnknown* other) {
	if(other == 0)
		return E_INVALIDARG;
	ComPtr<ITextRange> rhs;
	if(FAILED(other->QueryInterface(IID_ITextRange, reinterpret_cast<void**>(&rhs))))
		return S_FALSE;

	ComPtr<ITextPoint> startPoint, endPoint;
	VARIANT_BOOL b;
	rhs->get_StartPoint(&startPoint);
	rhs->get_EndPoint(&endPoint);
	startPoint->EqualTo(endPoint, &b);
	return toBoolean(b) ? S_OK : S_FALSE;
}


// Lexer class implementation
/////////////////////////////////////////////////////////////////////////////

namespace {
	Token::Type getTokenTypeByName(BSTR name) {
		static map<wstring, Ascension::Token::Type> ids;

		if(ids.empty()) {
			ids[L"whiteSpace"]			= Token::WHITESPACE;
			ids[L"tab"]					= Token::TAB;
			ids[L"keyword"]				= Token::KEYWORD;
			ids[L"annotation"]			= Token::ANNOTATION;
			ids[L"operator"]			= Token::OPERATOR;
			ids[L"identifier"]			= Token::IDENTIFIER;
			ids[L"numeral"]				= Token::NUMERAL;
			ids[L"number"]				= Token::NUMBER;
			ids[L"singleQuotation"]		= Token::SINGLE_QUOTATION;
			ids[L"doubleQuotation"]		= Token::DOUBLE_QUOTATION;
			ids[L"otherQuotation"]		= Token::OTHER_QUOTATION;
			ids[L"asciiControl"]		= Token::ASCII_CONTROL;
			ids[L"unicodeControl"]		= Token::UNICODE_CONTROL;
			ids[L"unspecified"]			= Token::UNSPECIFIED;
/*			ids[L"normal"]				= ETT_NORMAL;
			ids[L"selection"]			= ETT_SELECTION;
			ids[L"inactiveSelection"]	= ETT_INACTIVE_SELECTION;
			ids[L"indicatorMargin"]		= ETT_INDICATOR_MARGIN;
			ids[L"lineNumber"]			= ETT_LINENUMBER;
			ids[L"emphaticLineNumber"]	= ETT_EMPHATIC_LINENUMBER;
			ids[L"matchBrackets"]		= ETT_MATCH_BRACKETS;
			ids[L"endOfLine"]			= ETT_END_OF_LINE;
			ids[L"endOfFile"]			= ETT_END_OF_FILE;
			ids[L"link"]				= ETT_LINK;
			ids[L"restriction"]			= ETT_RESTRICTION;
			ids[L"matchText"]			= ETT_MATCHTEXT;
*/		}
		if(name == 0)
			return static_cast<Ascension::Token::Type>(-1);
		map<wstring, Ascension::Token::Type>::const_iterator it = ids.find(name);
		return (it != ids.end()) ? it->second : static_cast<Ascension::Token::Type>(-1);
	}
}

/// RXgN^
Ambient::Lexer::Lexer(Ascension::Lexer& impl) : SAFE_MARK, impl_(impl) {
}

/// @see ILexer::AddKeywords
STDMETHODIMP Ambient::Lexer::AddKeywords(BSTR keywords, long* identifier) {
	if(identifier != 0)
		*identifier = 0;
	if(isEmptyBSTR(keywords))
		return E_INVALIDARG;

	set<string_t> s;
	wchar_t* current = keywords;
	wchar_t* next;

	while(*current != 0) {
		if(*current == L' ') {
			++current;
			continue;
		}
		next = wcschr(current, L' ');
		if(next != 0) {
			s.insert(string_t(current, next - current));
			current = next + 1;
		} else {
			s.insert(string_t(current));
			break;
		}
	}
	if(identifier != 0)
		*identifier = impl_.addKeywords(s);
	else
		impl_.addKeywords(s);
	return S_OK;
}

/// @see ILexer::AddMultilineAnnotation
STDMETHODIMP Ambient::Lexer::AddMultilineAnnotation(BSTR startDelimiter,
		BSTR endDelimiter, ::AnnotationConstraint constraint, long* identifier) {
	if(identifier != 0)
		*identifier = 0;
	if(isEmptyBSTR(startDelimiter) || isEmptyBSTR(endDelimiter))
		return E_INVALIDARG;

	if(identifier != 0)
		*identifier = impl_.addMultilineAnnotation(startDelimiter, endDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
	else
		impl_.addMultilineAnnotation(startDelimiter, endDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
	return S_OK;
}

/// @see ILexer::AddSinglelineAnnotation
STDMETHODIMP Ambient::Lexer::AddSinglelineAnnotation(BSTR startDelimiter,
		BSTR endDelimiter, ::AnnotationConstraint constraint, long* identifier) {
	if(identifier != 0)
		*identifier = 0;
	if(isEmptyBSTR(startDelimiter))
		return E_INVALIDARG;

	if(isEmptyBSTR(endDelimiter)) {
		if(identifier != 0)
			*identifier = impl_.addSinglelineAnnotation(startDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
		else
			impl_.addSinglelineAnnotation(startDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
	} else {
		if(identifier != 0)
			*identifier = impl_.addSinglelineAnnotation(startDelimiter, endDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
		else
			impl_.addSinglelineAnnotation(startDelimiter, endDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
	}
	return S_OK;
}

/// @see ILexer::get_BackSolidusEscapeEnabled
STDMETHODIMP Ambient::Lexer::get_BackSolidusEscapeEnabled(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(impl_.isBackSolidusEscapeEnabled());
	return S_OK;
}

/// @see ILexer::get_CaseSensitive
STDMETHODIMP Ambient::Lexer::get_CaseSensitive(VARIANT_BOOL* caseSensitive) {
	VERIFY_POINTER(caseSensitive);
	*caseSensitive = toVariantBoolean(impl_.isCaseSensitive());
	return S_OK;
}

/// @see ILexer::get_Freezed
STDMETHODIMP Ambient::Lexer::get_Freezed(VARIANT_BOOL* freezed) {
	VERIFY_POINTER(freezed);
	*freezed = toVariantBoolean(impl_.isFreezed());
	return S_OK;
}

/// @see ILexer::get_NumberFormat
STDMETHODIMP Ambient::Lexer::get_NumberFormat(::NumberFormat* numberFormat) {
	VERIFY_POINTER(numberFormat);
	*numberFormat = static_cast<::NumberFormat>(impl_.getNumberFormat());
	return S_OK;
}

/// @see ILexer::get_TokenEnabled
STDMETHODIMP Ambient::Lexer::get_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	const Ascension::Token::Type type = getTokenTypeByName(bstrTokenName);
	if(type == -1)
		return E_INVALIDARG;
	*enabled = toVariantBoolean(impl_.isTokenEnabled(type));
	return S_OK;
}

/// @see ILexer::get_UnicodeAlphabetsEnabled
STDMETHODIMP Ambient::Lexer::get_UnicodeAlphabetsEnabled(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(impl_.isUnicodeAlphabetsEnabled());
	return S_OK;
}

/// @see ILexer::get_UnicodeWhiteSpacesEnabled
STDMETHODIMP Ambient::Lexer::get_UnicodeWhiteSpacesEnabled(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(impl_.isUnicodeWhiteSpacesEnabled());
	return S_OK;
}

/// @see ILexer::put_BackSolidusEscapeEnabled
STDMETHODIMP Ambient::Lexer::put_BackSolidusEscapeEnabled(VARIANT_BOOL enabled) {
	impl_.enableBackSolidusEscape(toBoolean(enabled));
	return S_OK;
}

/// @see ILexer::put_CaseSensitive
STDMETHODIMP Ambient::Lexer::put_CaseSensitive(VARIANT_BOOL caseSensitive) {
	impl_.ignoreCase(!toBoolean(caseSensitive));
	return S_OK;
}

/// @see ILexer::put_Freezed
STDMETHODIMP Ambient::Lexer::put_Freezed(VARIANT_BOOL freeze) {
	if(toBoolean(freeze))
		impl_.freeze();
	else
		impl_.unfreeze();
	return S_OK;
}

/// @see ILexer::put_NumberFormat
STDMETHODIMP Ambient::Lexer::put_NumberFormat(::NumberFormat numberFormat) {
	try {
		if(numberFormat != LegacyAlpha)
			return E_NOTIMPL;
		impl_.setNumberFormat(static_cast<Ascension::NumberFormat>(numberFormat));
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see ILexer::put_TokenEnabled
STDMETHODIMP Ambient::Lexer::put_TokenEnabled(BSTR tokenName, VARIANT_BOOL enabled) {
	const Ascension::Token::Type type = getTokenTypeByName(tokenName);
	if(type == -1)
		return E_INVALIDARG;
	impl_.enableToken(type, toBoolean(enabled));
	return S_OK;
}

/// @see ILexer::put_UnicodeAlphabetsEnabled
STDMETHODIMP Ambient::Lexer::put_UnicodeAlphabetsEnabled(VARIANT_BOOL enabled) {
	impl_.enableUnicodeAlphabets(toBoolean(enabled));
	return S_OK;
}

/// @see ILexer::put_UnicodeWhiteSpacesEnabled
STDMETHODIMP Ambient::Lexer::put_UnicodeWhiteSpacesEnabled(VARIANT_BOOL enabled) {
	impl_.enableUnicodeWhiteSpaces(toBoolean(enabled));
	return S_OK;
}

/// @see ILexer::RemoveAll
STDMETHODIMP Ambient::Lexer::RemoveAll() {
	impl_.removeAll();
	return S_OK;
}

/// @see ILexer::RemoveIdentifiedToken
STDMETHODIMP Ambient::Lexer::RemoveIdentifiedToken(long identifier) {
	try {
		impl_.removeIdentifiedToken(static_cast<Token::Cookie>(identifier));
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see ILexer::SetAdditionalAlphabets
STDMETHODIMP Ambient::Lexer::SetAdditionalAlphabets(BSTR alphabets) {
	if(alphabets != 0)
		impl_.setAdditionalAlphabets(alphabets, alphabets + ::SysStringLen(alphabets));
	else
		impl_.setAdditionalAlphabets(L"", 0);
	return S_OK;
}

/// @see ILexer::SetBrackets
STDMETHODIMP Ambient::Lexer::SetBrackets(BSTR openers) {
	try {
		impl_.setBrackets((openers != 0) ? openers : L"");
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see ILexer::SetOperators
STDMETHODIMP Ambient::Lexer::SetOperators(BSTR operators) {
	set<string_t> ops;

	if(operators != 0) {
		wchar_t* current = operators;
		wchar_t* next;

		while(true) {
			next = wcschr(current, L' ');
			if(next != 0) {
				ops.insert(string_t(current, next - current));
				current = next + 1;
			} else {
				ops.insert(string_t(current));
				break;
			}
		}
	}
	impl_.setOperators(ops);
	return S_OK;
}


// EditorPreferences class implementation
/////////////////////////////////////////////////////////////////////////////

#define GET_DISPLAY_OPTION(lhs, id)								\
	VERIFY_POINTER(lhs);										\
	*lhs = toVariantBoolean(view_.getOptions().appearance[id]);	\
	return S_OK
#define PUT_DISPLAY_OPTION(id, rhs)					\
	EditView::Options options = view_.getOptions();	\
	if(options.appearance[id] != toBoolean(rhs)) {	\
		options.appearance[id] = toBoolean(rhs);	\
		view_.setOptions(options);					\
	}												\
	return S_OK
#define GET_LAYOUT_SETTING(memberName) view_.getLayoutSetter().getSettings().memberName
#define PUT_LAYOUT_SETTING(memberName, newValue)					\
	LayoutSettings layout = view_.getLayoutSetter().getSettings();	\
	if(layout.memberName != newValue) {								\
		layout.memberName = newValue;								\
		view_.getLayoutSetter().setSettings(layout);				\
	}																\
	return S_OK

/**
 *	RXgN^
 *	@param view	r[
 */
EditorPreferences::EditorPreferences(EditView& view) : SAFE_MARK, view_(view) {
}

/// @see IEditorPreferences::get_CharSpan
STDMETHODIMP EditorPreferences::get_CharSpan(short* charSpan) {
	VERIFY_POINTER(charSpan);
	*charSpan = GET_LAYOUT_SETTING(charSpan);
	return S_OK;
}

/// @see IEditorPreferences::get_CheckInputSequence
STDMETHODIMP EditorPreferences::get_CheckInputSequence(BSTR language, VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	const InputSequenceCheckLanguage langs = view_.getOptions().sequenceCheckingLanguages;
	for(size_t i = 0; i < countof(ISCLanguages); ++i) {
		if(wcscmp(ISCLanguages[i].first, language) == 0) {
			*enabled = toVariantBoolean(langs & ISCLanguages[i].second);
			return S_OK;
		}
	}
	return E_INVALIDARG;
}

/// @see IEditorPreferences::get_CloseBoldChars
STDMETHODIMP EditorPreferences::get_CloseBoldChars(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(GET_LAYOUT_SETTING(closeBoldCharacters));
	return S_OK;
}

/// @see IEditorPreferences::get_EndOfFileLabel
STDMETHODIMP EditorPreferences::get_EndOfFileLabel(BSTR* endOfFileLabel) {
	VERIFY_POINTER(endOfFileLabel);
	return toBoolean(*endOfFileLabel =
		::SysAllocString(GET_LAYOUT_SETTING(substitutionGlyphs.endOfFile.c_str()))) ? S_OK : E_OUTOFMEMORY;
}

/// @see IEditorPreferences::get_GeneralWhiteSpaceSubstitutionChar
STDMETHODIMP EditorPreferences::get_GeneralWhiteSpaceSubstitutionChar(long* glyph) {
	VERIFY_POINTER(glyph);
	*glyph = GET_LAYOUT_SETTING(substitutionGlyphs.generalWhiteSpace);
	return S_OK;
}

/// @see IEditorPreferences::get_HorizontalTabSubstitutionChar
STDMETHODIMP EditorPreferences::get_HorizontalTabSubstitutionChar(long* glyph) {
	VERIFY_POINTER(glyph);
	*glyph = GET_LAYOUT_SETTING(substitutionGlyphs.horizontalTab);
	return S_OK;
}

/// @see IEditorPreferences::get_IdeographicSpaceSubstitutionChar
STDMETHODIMP EditorPreferences::get_IdeographicSpaceSubstitutionChar(long* glyph) {
	VERIFY_POINTER(glyph);
	*glyph = GET_LAYOUT_SETTING(substitutionGlyphs.ideographicSpace);
	return S_OK;
}

/// @see IEditorPreferences::get_LeadMargin
STDMETHODIMP EditorPreferences::get_LeadMargin(short* leadMargin) {
	VERIFY_POINTER(leadMargin);
	*leadMargin = static_cast<short>(GET_LAYOUT_SETTING(leadMargin));
	return S_OK;
}

/// @see IEditorPreferences::get_LexicalParsingEnabled
STDMETHODIMP EditorPreferences::get_LexicalParsingEnabled(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(view_.getLayoutSetter().isLexicalParsingEnabled());
	return S_OK;
}

/// @see IEditorPreferences::get_LineBreakSubstitutionChar
STDMETHODIMP EditorPreferences::get_LineBreakSubstitutionChar(::LineBreak lineBreak, long* glyph) {
	VERIFY_POINTER(glyph);
	const LayoutSettings& layout = view_.getLayoutSetter().getSettings();
	switch(lineBreak) {
	case ::Lf:		*glyph = layout.substitutionGlyphs.unixEOL;				break;
	case ::Cr:		*glyph = layout.substitutionGlyphs.macintoshEOL;		break;
	case ::Crlf:	*glyph = layout.substitutionGlyphs.windowsEOL;			break;
	case ::Nel:		*glyph = layout.substitutionGlyphs.ebcdicEOL;			break;
	case ::Ls:		*glyph = layout.substitutionGlyphs.lineSeparator;		break;
	case ::Ps:		*glyph = layout.substitutionGlyphs.paragraphSeparator;	break;
	default:		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see IEditorPreferences::get_LineNumberBorderStyle
STDMETHODIMP EditorPreferences::get_LineNumberBorderStyle(::BorderType* style) {
	VERIFY_POINTER(style);
	switch(view_.getLayoutSetter().getSettings().lineNumberLayout.borderStyle) {
	case LineNumberLayout::LNBS_NONE:			*style = NoBorder;		break;
	case LineNumberLayout::LNBS_SOLID:			*style = BorderSolid;	break;
	case LineNumberLayout::LNBS_DASHED:
	case LineNumberLayout::LNBS_DASHED_ROUNDED:	*style = BorderDashed;	break;
	case LineNumberLayout::LNBS_DOTTED:			*style = BorderDotted;	break;
	}
	return S_OK;
}

/// @see IEditorPreferences::get_LineNumberBorderWidth
STDMETHODIMP EditorPreferences::get_LineNumberBorderWidth(short* width) {
	VERIFY_POINTER(width);
	*width = static_cast<short>(GET_LAYOUT_SETTING(lineNumberLayout.borderWidth));
	return S_OK;
}

/// @see IEditorPreferences::get_LineSpan
STDMETHODIMP EditorPreferences::get_LineSpan(short* lineSpan) {
	VERIFY_POINTER(lineSpan);
	*lineSpan = static_cast<short>(GET_LAYOUT_SETTING(lineSpan));
	return S_OK;
}

/// @see IEditorPreferences::get_MatchBracketScanLines
STDMETHODIMP EditorPreferences::get_MatchBracketScanLines(long* lines) {
	VERIFY_POINTER(lines);
	*lines = static_cast<long>(view_.getOptions().recognizingLineCount);
	return S_OK;
}

/// @see IEditorPreferences::get_PerformBidirection
STDMETHODIMP EditorPreferences::get_PerformBidirection(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = !toVariantBoolean(GET_LAYOUT_SETTING(performBidirection));
	return S_OK;
}

/// @see IEditorPreferences::get_ResetDirectionByTokens
STDMETHODIMP EditorPreferences::get_ResetDirectionByTokens(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
//	*enabled = toVariantBoolean(GET_LAYOUT_SETTING(resetRunLevelByToken));
//	return S_OK;
	return E_NOTIMPL;
}

/// @see IEditorPreferences::get_RightToLeftReading
STDMETHODIMP EditorPreferences::get_RightToLeftReading(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(GET_LAYOUT_SETTING(rightToLeftReading));
	return S_OK;
}

/// @see IEditorPreferences::get_SelectEndOfLine
STDMETHODIMP EditorPreferences::get_SelectEndOfLine(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, SHOW_SELECTION_ON_BREAK);
}

/// @see IEditorPreferences::get_ShowBidirectionalFormatters
STDMETHODIMP EditorPreferences::get_ShowBidirectionalFormatters(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, SHOW_UNICODE_CONTROLS);
}

/// @see IEditorPreferences::get_ShowCurrentUnderline
STDMETHODIMP EditorPreferences::get_ShowCurrentUnderline(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, SHOW_CURRENT_UNDERLINE);
}

/// @see IEditorPreferences::get_ShowEndOfFile
STDMETHODIMP EditorPreferences::get_ShowEndOfFile(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, SHOW_END_OF_FILE);
}

/// @see IEditorPreferences::get_ShowEndOfLine
STDMETHODIMP EditorPreferences::get_ShowEndOfLine(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, SHOW_BREAK_ARROWS);
}

/// @see IEditorPreferences::get_ShowHandOnLink
STDMETHODIMP EditorPreferences::get_ShowHandOnLink(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, SHOW_HAND_ON_LINK);
}

/// @see IEditorPreferences::get_ShowHintOnLink
STDMETHODIMP EditorPreferences::get_ShowHintOnLink(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, SHOW_HINT_ON_LINK);
}

/// @see IEditorPreferences::get_ShowIndicatorMargin
STDMETHODIMP EditorPreferences::get_ShowIndicatorMargin(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(GET_LAYOUT_SETTING(lineNumberLayout.showIndicatorMargin));
	return S_OK;
}

/// @see IEditorPreferences::get_ShowLineNumber
STDMETHODIMP EditorPreferences::get_ShowLineNumber(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(GET_LAYOUT_SETTING(lineNumberLayout.showLineNumbers));
	return S_OK;
}

/// @see IEditorPreferences::get_ShowWhiteSpaceAlternative
STDMETHODIMP EditorPreferences::get_ShowWhiteSpaceAlternative(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, SHOW_WHITESPACE_ALTERNATIVE);
}

/// @see IEditorPreferences::get_StartCharNumber
STDMETHODIMP EditorPreferences::get_StartCharNumber(long* startCharNumber) {
	VERIFY_POINTER(startCharNumber);
	*startCharNumber = static_cast<long>(GET_LAYOUT_SETTING(startChar));
	return S_OK;
}

/// @see IEditorPreferences::get_StartLineNumber
STDMETHODIMP EditorPreferences::get_StartLineNumber(long* startLineNumber) {
	VERIFY_POINTER(startLineNumber);
	*startLineNumber = static_cast<long>(GET_LAYOUT_SETTING(lineNumberLayout.startLine));
	return S_OK;
}

/// @see IEditorPreferences::get_TabWidth
STDMETHODIMP EditorPreferences::get_TabWidth(short* width) {
	VERIFY_POINTER(width);
	*width = static_cast<short>(GET_LAYOUT_SETTING(tabWidth));
	return S_OK;
}

/// @see IEditorPreferences::get_ThinCaret
STDMETHODIMP EditorPreferences::get_ThinCaret(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, THIN_CARET);
}

/// @see IEditorPreferences::get_TokenDecoration
STDMETHODIMP EditorPreferences::get_TokenDecoration(BSTR tokenTypeName, ITokenDecoration** tokenDecoration) {
	VERIFY_POINTER(tokenDecoration);
	if(tokenTypeName == 0)
		return E_INVALIDARG;
	if(wcscmp(tokenTypeName, L"whiteSpace") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::WHITESPACE);
	else if(wcscmp(tokenTypeName, L"tab") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::TAB);
	else if(wcscmp(tokenTypeName, L"operator") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::OPERATOR);
	else if(wcscmp(tokenTypeName, L"identifier") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::IDENTIFIER);
	else if(wcscmp(tokenTypeName, L"numeral") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::NUMERAL);
	else if(wcscmp(tokenTypeName, L"number") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::NUMBER);
	else if(wcscmp(tokenTypeName, L"singleQuotation") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::SINGLE_QUOTATION);
	else if(wcscmp(tokenTypeName, L"doubleQuotation") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::DOUBLE_QUOTATION);
	else if(wcscmp(tokenTypeName, L"otherQuotation") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::OTHER_QUOTATION);
	else if(wcscmp(tokenTypeName, L"asciiControl") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::ASCII_CONTROL);
	else if(wcscmp(tokenTypeName, L"unicodeControl") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::UNICODE_CONTROL);
	else if(wcscmp(tokenTypeName, L"unspecified") == 0)
		*tokenDecoration = new TokenDecoration(view_, Token::UNSPECIFIED);
	else if(wcscmp(tokenTypeName, L"normal") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_NORMAL);
	else if(wcscmp(tokenTypeName, L"selection") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_SELECTION);
	else if(wcscmp(tokenTypeName, L"inactiveSelection") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_INACTIVE_SELECTION);
	else if(wcscmp(tokenTypeName, L"indicatorMargin") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_INDICATOR_MARGIN);
	else if(wcscmp(tokenTypeName, L"lineNumber") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_LINENUMBER);
	else if(wcscmp(tokenTypeName, L"emphaticLineNumber") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_EMPHATIC_LINENUMBER);
	else if(wcscmp(tokenTypeName, L"matchBrackets") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_MATCH_BRACKETS);
	else if(wcscmp(tokenTypeName, L"endOfLine") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_END_OF_LINE);
	else if(wcscmp(tokenTypeName, L"endOfFile") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_END_OF_FILE);
	else if(wcscmp(tokenTypeName, L"link") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_LINK);
	else if(wcscmp(tokenTypeName, L"matchText") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_MATCHTEXT);
	else if(wcscmp(tokenTypeName, L"restriction") == 0)
		*tokenDecoration = new TokenDecoration(view_, ETT_RESTRICTION);
	else {	// L[[hƃRgɂ̓NbL[lKv
		if(::SysStringLen(tokenTypeName) >= 9 && wcsncmp(tokenTypeName, L"keyword_", 8) == 0)
			*tokenDecoration = new TokenDecoration(view_,
				Token::KEYWORD, static_cast<Token::Cookie>(wcstol(tokenTypeName + 8, 0, 10)));
		else if(::SysStringLen(tokenTypeName) >= 12 && wcsncmp(tokenTypeName, L"annotation_", 11) == 0)
			*tokenDecoration = new TokenDecoration(view_,
				Token::ANNOTATION, static_cast<Token::Cookie>(wcstol(tokenTypeName + 11, 0, 10)));
		else {
			*tokenDecoration = 0;
			return E_INVALIDARG;
		}

	}
	(*tokenDecoration)->AddRef();

	return S_OK;
}

/// @see IEditorPreferences::get_TopMargin
STDMETHODIMP EditorPreferences::get_TopMargin(short* topMargin) {
	VERIFY_POINTER(topMargin);
	*topMargin = static_cast<short>(GET_LAYOUT_SETTING(topMargin));
	return S_OK;
}

/// @see IEditorPreferences::get_UseEditorFontForCompletion
STDMETHODIMP EditorPreferences::get_UseEditorFontForCompletion(VARIANT_BOOL* enabled) {
	GET_DISPLAY_OPTION(enabled, USE_EDITOR_FONT_FOR_COMPLETION);
}

/// @see IEditorPreferences::get_WrapMode
STDMETHODIMP EditorPreferences::get_WrapMode(::WrapMode* wrapMode) {
	VERIFY_POINTER(wrapMode);
	*wrapMode = static_cast<::WrapMode>(GET_LAYOUT_SETTING(wrapMode));
	return S_OK;
}

/// @see IEditorPreferences::get_WrapWidth
STDMETHODIMP EditorPreferences::get_WrapWidth(short* wrapWidth) {
	VERIFY_POINTER(wrapWidth);
	return E_NOTIMPL;
//	*wrapWidth = GET_LAYOUT_SETTING(wrapWidth);
//	return S_OK;
}

/// @see IEditorPreferences::put_CharSpan
STDMETHODIMP EditorPreferences::put_CharSpan(short charSpan) {
	if(charSpan < 0)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(charSpan, charSpan);
}

/// @see IEditorPreferences::put_CheckInputSequence
STDMETHODIMP EditorPreferences::put_CheckInputSequence(BSTR language, VARIANT_BOOL enabled) {
	EditView::Options options = view_.getOptions();
	for(size_t i = 0; i < countof(ISCLanguages); ++i) {
		if(wcscmp(ISCLanguages[i].first, language) == 0) {
			options.sequenceCheckingLanguages |= ISCLanguages[i].second;
			view_.setOptions(options);
			return S_OK;
		}
	}
	return E_INVALIDARG;
}

/// @see IEditorPreferences::put_CloseBoldChars
STDMETHODIMP EditorPreferences::put_CloseBoldChars(VARIANT_BOOL enabled) {
	PUT_LAYOUT_SETTING(closeBoldCharacters, toBoolean(enabled));
}

/// @see IEditorPreferences::put_EndOfFileLabel
STDMETHODIMP EditorPreferences::put_EndOfFileLabel(BSTR endOfFileLabel) {
	LayoutSettings settings = view_.getLayoutSetter().getSettings();
	settings.substitutionGlyphs.endOfFile = SAFE_BSTR(endOfFileLabel);
	view_.getLayoutSetter().setSettings(settings);
	return S_OK;
}

/// @see IEditorPreferences::put_GeneralWhiteSpaceSubstitutionChar
STDMETHODIMP EditorPreferences::put_GeneralWhiteSpaceSubstitutionChar(long glyph) {
	if(glyph < 0 || glyph > 0xFFFF)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(substitutionGlyphs.generalWhiteSpace, static_cast<char_t>(glyph));
}

/// @see IEditorPreferences::put_HorizontalTabSubstitutionChar
STDMETHODIMP EditorPreferences::put_HorizontalTabSubstitutionChar(long glyph) {
	if(glyph < 0 || glyph > 0xFFFF)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(substitutionGlyphs.horizontalTab, static_cast<char_t>(glyph));
}

/// @see IEditorPreferences::put_IdeographicSpaceSubstitutionChar
STDMETHODIMP EditorPreferences::put_IdeographicSpaceSubstitutionChar(long glyph) {
	if(glyph < 0 || glyph > 0xFFFF)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(substitutionGlyphs.ideographicSpace, static_cast<char_t>(glyph));
}

/// @see IEditorPreferences::put_LeadMargin
STDMETHODIMP EditorPreferences::put_LeadMargin(short leadMargin) {
	if(leadMargin < 0)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(leadMargin, leadMargin);
}

/// @see IEditorPreferences::put_LexicalParsingEnabled
STDMETHODIMP EditorPreferences::put_LexicalParsingEnabled(VARIANT_BOOL enabled) {
	view_.getLayoutSetter().enableLexicalParsing(toBoolean(enabled));
	return S_OK;
}

/// @see IEditorPreferences::put_LineBreakSubstitutionChar
STDMETHODIMP EditorPreferences::put_LineBreakSubstitutionChar(::LineBreak lineBreak, long glyph) {
	if(glyph < 0 || glyph > 0xFFFF)
		return E_INVALIDARG;

	LayoutSettings layout = view_.getLayoutSetter().getSettings();
	switch(lineBreak) {
	case ::Lf:		layout.substitutionGlyphs.unixEOL = static_cast<char_t>(glyph);				break;
	case ::Cr:		layout.substitutionGlyphs.macintoshEOL = static_cast<char_t>(glyph);		break;
	case ::Crlf:	layout.substitutionGlyphs.windowsEOL = static_cast<char_t>(glyph);			break;
	case ::Nel:		layout.substitutionGlyphs.ebcdicEOL = static_cast<char_t>(glyph);			break;
	case ::Ls:		layout.substitutionGlyphs.lineSeparator = static_cast<char_t>(glyph);		break;
	case ::Ps:		layout.substitutionGlyphs.paragraphSeparator = static_cast<char_t>(glyph);	break;
	default:		return E_INVALIDARG;
	}
	view_.getLayoutSetter().setSettings(layout);
	return S_OK;
}

/// @see IEditorPreferences::put_LineNumberBorderStyle
STDMETHODIMP EditorPreferences::put_LineNumberBorderStyle(::BorderType style) {
	LayoutSettings layout = view_.getLayoutSetter().getSettings();
	switch(style) {
		case NoBorder:		layout.lineNumberLayout.borderStyle = LineNumberLayout::LNBS_NONE;		break;
		case BorderSolid:	layout.lineNumberLayout.borderStyle = LineNumberLayout::LNBS_SOLID;		break;
		case BorderDashed:	layout.lineNumberLayout.borderStyle = LineNumberLayout::LNBS_DASHED;	break;
		case BorderDotted:	layout.lineNumberLayout.borderStyle = LineNumberLayout::LNBS_DOTTED;	break;
		default:			return E_INVALIDARG;
	}
	view_.getLayoutSetter().setSettings(layout);
	return S_OK;
}

/// @see IEditorPreferences::put_LineNumberBorderWidth
STDMETHODIMP EditorPreferences::put_LineNumberBorderWidth(short width) {
	if(width < 0)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(lineNumberLayout.borderWidth, width);
}

/// @see IEditorPreferences::put_LineSpan
STDMETHODIMP EditorPreferences::put_LineSpan(short lineSpan) {
	if(lineSpan < 0)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(lineSpan, lineSpan);
}

/// @see IEditorPreferences::put_MatchBracketScanLines
STDMETHODIMP EditorPreferences::put_MatchBracketScanLines(long lines) {
	if(lines < 0)
		return E_INVALIDARG;

	EditView::Options options = view_.getOptions();
	if(options.recognizingLineCount != lines) {
		options.recognizingLineCount = lines;
		view_.setOptions(options);
	}
	return S_OK;
}

/// @see IEditorPreferences::put_PerformBidirection
STDMETHODIMP EditorPreferences::put_PerformBidirection(VARIANT_BOOL enabled) {
	PUT_LAYOUT_SETTING(performBidirection, toBoolean(enabled));
}

/// @see IEditorPreferences::put_ResetDirectionByTokens
STDMETHODIMP EditorPreferences::put_ResetDirectionByTokens(VARIANT_BOOL enabled) {
	return E_NOTIMPL;
//	PUT_DISPLAY_OPTION(RESET_DIRECTION_BY_TOKEN, enabled);
}

/// @see IEditorPreferences::put_RightToLeftReading
STDMETHODIMP EditorPreferences::put_RightToLeftReading(VARIANT_BOOL enabled) {
	return E_NOTIMPL;
//	PUT_LAYOUT_OPTION(rightToLeftReading, enabled);
}

/// @see IEditorPreferences::put_SelectEndOfLine
STDMETHODIMP EditorPreferences::put_SelectEndOfLine(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(SHOW_SELECTION_ON_BREAK, enabled);
}

/// @see IEditorPreferences::put_ShowBidirectionalFormatters
STDMETHODIMP EditorPreferences::put_ShowBidirectionalFormatters(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(SHOW_UNICODE_CONTROLS, enabled);
}

/// @see IEditorPreferences::put_ShowCurrentUnderline
STDMETHODIMP EditorPreferences::put_ShowCurrentUnderline(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(SHOW_CURRENT_UNDERLINE, enabled);
}

/// @see IEditorPreferences::put_ShowEndOfFile
STDMETHODIMP EditorPreferences::put_ShowEndOfFile(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(SHOW_END_OF_FILE, enabled);
}

/// @see IEditorPreferences::put_ShowEndOfLine
STDMETHODIMP EditorPreferences::put_ShowEndOfLine(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(SHOW_BREAK_ARROWS, enabled);
}

/// @see IEditorPreferences::put_ShowHandOnLink
STDMETHODIMP EditorPreferences::put_ShowHandOnLink(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(SHOW_HAND_ON_LINK, enabled);
}

/// @see IEditorPreferences::put_ShowHintOnLink
STDMETHODIMP EditorPreferences::put_ShowHintOnLink(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(SHOW_HINT_ON_LINK, enabled);
}

/// @see IEditorPreferences::put_ShowIndicatorMargin
STDMETHODIMP EditorPreferences::put_ShowIndicatorMargin(VARIANT_BOOL enabled) {
	PUT_LAYOUT_SETTING(lineNumberLayout.showIndicatorMargin, toBoolean(enabled));
}

/// @see IEditorPreferences::put_ShowLineNumber
STDMETHODIMP EditorPreferences::put_ShowLineNumber(VARIANT_BOOL enabled) {
	PUT_LAYOUT_SETTING(lineNumberLayout.showLineNumbers, toBoolean(enabled));
}

/// @see IEditorPreferences::put_ShowWhiteSpaceAlternative
STDMETHODIMP EditorPreferences::put_ShowWhiteSpaceAlternative(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(SHOW_WHITESPACE_ALTERNATIVE, enabled);
}

/// @see IEditorPreferences::put_StartCharNumber
STDMETHODIMP EditorPreferences::put_StartCharNumber(long startCharNumber) {
	if(startCharNumber < 0)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(startChar, startCharNumber);
}

/// @see IEditorPreferences::put_StartLineNumber
STDMETHODIMP EditorPreferences::put_StartLineNumber(long startLineNumber) {
	if(startLineNumber < 0)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(lineNumberLayout.startLine, startLineNumber);
}

/// @see IEditorPreferences::put_TabWidth
STDMETHODIMP EditorPreferences::put_TabWidth(short tabWidth) {
	if(tabWidth < 0)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(tabWidth, tabWidth);
}

/// @see IEditorPreferences::put_ThinCaret
STDMETHODIMP EditorPreferences::put_ThinCaret(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(THIN_CARET, enabled);
}

/// @see IEditorPreferences::put_TopMargin
STDMETHODIMP EditorPreferences::put_TopMargin(short topMargin) {
	if(topMargin < 0)
		return E_INVALIDARG;
	PUT_LAYOUT_SETTING(topMargin, topMargin);
}

/// @see IEditorPreferences::put_UseEditorFontForCompletion
STDMETHODIMP EditorPreferences::put_UseEditorFontForCompletion(VARIANT_BOOL enabled) {
	PUT_DISPLAY_OPTION(USE_EDITOR_FONT_FOR_COMPLETION, enabled);
}

/// @see IEditorPreferences::put_WrapMode
STDMETHODIMP EditorPreferences::put_WrapMode(::WrapMode wrapMode) {
//	view_.setWrapMode(static_cast<Ascension::WrapMode>(wrapMode));
//	return S_OK;
	return E_NOTIMPL;
}

/// @see IEditorPreferences::put_WrapWidth
STDMETHODIMP EditorPreferences::put_WrapWidth(short wrapWidth) {
//	view_.setWrapWidth(wrapWidth);
//	return S_OK;
	return E_NOTIMPL;
}

/// @see IEditorPreferences::Reset
STDMETHODIMP EditorPreferences::Reset() {
	view_.setOptions(EditView::Options());
	view_.getLayoutSetter().resetConfigurations();
	return S_OK;
}

#undef GET_DISPLAY_OPTION
#undef PUT_DISPLAY_OPTION
#undef GET_LAYOUT_SETTING
#undef PUT_LAYOUT_SETTING


// TokenDecoration class implementation
/////////////////////////////////////////////////////////////////////////////

namespace {	// Win32 API ƃXNvgnŐF̕\
	inline long winRGBToScriptRGB(COLORREF color) {
		return (color == -1) ? -1 : (GetBValue(color) | (GetGValue(color) << 8) | (GetRValue(color) << 16));
	}
	inline COLORREF scriptRGBToWinRGB(long color) {
		return (color == -1) ? -1 : RGB((color & 0xFF0000) >> 16, (color & 0x00FF00) >> 8, color & 0x0000FF);
	}
}

// CEditView::GetTextFoundation ͗O𓊂̂łňꊇ
#define GET_TF()																	\
	TextFoundation tf;																\
	try {																			\
		tf = view_.getLayoutSetter().getTokenFoundation(tokenType_, tokenCookie_);	\
	} catch(invalid_argument&) {													\
		return E_UNEXPECTED;														\
	}

/**
 *	RXgN^
 *	@param view			r[
 *	@param tokenType	g[N̎
 *	@param tokenCookie	g[ÑNbL[l
 */
TokenDecoration::TokenDecoration(EditView& view, int tokenType, Token::Cookie tokenCookie)
		: SAFE_MARK, view_(view), tokenType_(tokenType), tokenCookie_(tokenCookie) {
}

/// @see ITokenDecoration::get_BackgroundColor
STDMETHODIMP TokenDecoration::get_BackgroundColor(long* color) {
	VERIFY_POINTER(color);
	GET_TF();
	*color = winRGBToScriptRGB(tf.bgColor);
	return S_OK;
}

/// @see ITokenDecoration::get_BoldFont
STDMETHODIMP TokenDecoration::get_BoldFont(VARIANT_BOOL* bold) {
	VERIFY_POINTER(bold);
	GET_TF();
	*bold = toVariantBoolean(tf.bold);
	return S_OK;
}

/// @see ITokenDecoration::get_BorderColor
STDMETHODIMP TokenDecoration::get_BorderColor(long* color) {
	VERIFY_POINTER(color);
	GET_TF();
	*color = tf.borderColor;
	return S_OK;
}

/// @see ITokenDecoration::get_BorderStyle
STDMETHODIMP TokenDecoration::get_BorderStyle(::BorderType* borderType) {
	VERIFY_POINTER(borderType);
	GET_TF();
	*borderType = static_cast<::BorderType>(tf.border);
	return S_OK;
}

/// @see ITokenDecoration::get_Color
STDMETHODIMP TokenDecoration::get_Color(long* color) {
	VERIFY_POINTER(color);
	GET_TF();
	*color = winRGBToScriptRGB(tf.fgColor);
	return S_OK;
}

/// @see ITokenDecoration::get_ItalicFont
STDMETHODIMP TokenDecoration::get_ItalicFont(VARIANT_BOOL* italic) {
	VERIFY_POINTER(italic);
	GET_TF();
	*italic = toVariantBoolean(tf.italic);
	return S_OK;
}

/// @see ITokenDecoration::put_BackgroundColor
STDMETHODIMP TokenDecoration::put_BackgroundColor(long color) {
	GET_TF();
	const COLORREF winColor = toBoolean(color & 0x80000000) ? color : scriptRGBToWinRGB(color);
	if(winColor != tf.bgColor) {
		tf.bgColor = winColor;
		view_.getLayoutSetter().setTokenFoundation(tokenType_, tokenCookie_, tf);
	}
	return S_OK;
}

/// @see ITokenDecoration::put_BoldFont
STDMETHODIMP TokenDecoration::put_BoldFont(VARIANT_BOOL bold) {
	GET_TF();
	if(tf.bold != toBoolean(bold)) {
		tf.bold = toBoolean(bold);
		view_.getLayoutSetter().setTokenFoundation(tokenType_, tokenCookie_, tf);
	}
	return S_OK;
}

/// @see ITokenDecoration::put_BorderColor
STDMETHODIMP TokenDecoration::put_BorderColor(long color) {
	GET_TF();
	const COLORREF winColor = toBoolean(color & 0x80000000) ? color : scriptRGBToWinRGB(color);
	if(winColor != tf.borderColor) {
		tf.borderColor = winColor;
		view_.getLayoutSetter().setTokenFoundation(tokenType_, tokenCookie_, tf);
	}
	return S_OK;
}

/// @see ITokenDecoration::put_BorderStyle
STDMETHODIMP TokenDecoration::put_BorderStyle(::BorderType borderType) {
	GET_TF();
	if(tf.border != static_cast<Ascension::BorderType>(borderType)) {
		tf.border = static_cast<Ascension::BorderType>(borderType);
		view_.getLayoutSetter().setTokenFoundation(tokenType_, tokenCookie_, tf);
	}
	return S_OK;
}

/// @see ITokenDecoration::put_Color
STDMETHODIMP TokenDecoration::put_Color(long color) {
	GET_TF();
	const COLORREF winColor = toBoolean(color & 0x80000000) ? color : scriptRGBToWinRGB(color);
	if(winColor != tf.fgColor) {
		tf.fgColor = winColor;
		view_.getLayoutSetter().setTokenFoundation(tokenType_, tokenCookie_, tf);
	}
	return S_OK;
}

/// @see ITokenDecoration::put_ItalicFont
STDMETHODIMP TokenDecoration::put_ItalicFont(VARIANT_BOOL italic) {
	GET_TF();
	if(tf.italic != toBoolean(italic)) {
		tf.italic = toBoolean(italic);
		view_.getLayoutSetter().setTokenFoundation(tokenType_, tokenCookie_, tf);
	}
	return S_OK;
}

#undef GET_TF


// SearchOptions class implementation
/////////////////////////////////////////////////////////////////////////////

/// @see ISearchOptions::get_CaseSensitivity
STDMETHODIMP SearchOptions::get_CaseSensitivity(CaseFoldingType* options) {
	VERIFY_POINTER(options);
	*options = static_cast<CaseFoldingType>(options_.caseSensitivity);
	return S_OK;
}

/// @see ISearchOptions::get_CharacterSkipOption
STDMETHODIMP SearchOptions::get_CharacterSkipOption(CharacterSkipType* options) {
	VERIFY_POINTER(options);
	*options = static_cast<CharacterSkipType>(0);
	for(int f = FoldingOptions::CHARACTER_SKIP_START; f < FoldingOptions::CHARACTER_SKIP_END; ++f) {
		if(options_.foldings.test(f))
			*options = static_cast<CharacterSkipType>(*options | (1 << (f - FoldingOptions::CHARACTER_SKIP_START)));
	}
	return S_OK;
}

/// @see ISearchOptions::get_FoldingOption
STDMETHODIMP SearchOptions::get_FoldingOption(FoldingType* options) {
	VERIFY_POINTER(options);
	*options = static_cast<FoldingType>(0);
	for(int f = FoldingOptions::FOLDING_START; f < FoldingOptions::FOLDING_END; ++f) {
		if(options_.foldings.test(f))
			*options = static_cast<FoldingType>(*options | (1 << (f - FoldingOptions::FOLDING_START)));
	}
	return S_OK;
}

/// @see ISearchOptions::get_MultigraphExpansionOption
STDMETHODIMP SearchOptions::get_MultigraphExpansionOption(MultigraphExpansionType* options) {
	VERIFY_POINTER(options);
	*options = static_cast<MultigraphExpansionType>(0);
	for(int f = FoldingOptions::MULTIGRAPH_EXPANSION_START; f < FoldingOptions::MULTIGRAPH_EXPANSION_END; ++f) {
		if(options_.foldings.test(f))
			*options = static_cast<MultigraphExpansionType>(*options | (1 << (f - FoldingOptions::MULTIGRAPH_EXPANSION_START)));
	}
	return S_OK;
}

/// @see ISearchOptions::get_OnlyIdentifier
STDMETHODIMP SearchOptions::get_OnlyIdentifiers(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
//	*enabled = toVariantBoolean(options_.onlyIdentifiers);
//	return S_OK;
	return E_NOTIMPL;
}

/// @see ISearchOptions::get_SearchType
STDMETHODIMP SearchOptions::get_SearchType(::SearchType* type) {
	VERIFY_POINTER(type);
	switch(options_.type) {
	case TextSearcher::LITERAL:				*type = Literal;	break;
	case TextSearcher::REGULAR_EXPRESSION:	*type = Regexp;		break;
	case TextSearcher::WILD_CARD:			*type = Wildcard;	break;
	case TextSearcher::MIGEMO:				*type = Migemo;		break;
	default:								assert(false);
	}
	return S_OK;
}

/// @see ISearchOptions::get_WholeWord
STDMETHODIMP SearchOptions::get_WholeWord(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(options_.wholeWord);
	return S_OK;
}

/// @see ISearchOptions::put_CaseSensitivity
STDMETHODIMP SearchOptions::put_CaseSensitivity(CaseFoldingType caseSensitivity) {
	switch(caseSensitivity) {
	case MatchCase:				options_.caseSensitivity = TextSearcher::CASE_SENSITIVE;	break;
	case IgnoreAsciiAlphabets:	options_.caseSensitivity = TextSearcher::CASE_FOLD_ASCII;	break;
	case UnicodeSimple:			options_.caseSensitivity = TextSearcher::CASE_FOLD_SIMPLE;	break;
	case UnicodeFull:			options_.caseSensitivity = TextSearcher::CASE_FOLD_FULL;	break;
	default:					return E_INVALIDARG;
	}
	return S_OK;
}

/// @see ISearchOptions::put_CharacterSkipOption
STDMETHODIMP SearchOptions::put_CharacterSkipOption(CharacterSkipType options) {
	for(int f = FoldingOptions::CHARACTER_SKIP_START; f < FoldingOptions::CHARACTER_SKIP_END; ++f)
		options_.foldings[f] = toBoolean(options & (1 << (f - FoldingOptions::CHARACTER_SKIP_START)));
	return S_OK;
}

/// @see ISearchOptions::put_FoldingOption
STDMETHODIMP SearchOptions::put_FoldingOption(FoldingType options) {
	for(int f = FoldingOptions::FOLDING_START; f < FoldingOptions::FOLDING_END; ++f)
		options_.foldings[f] = toBoolean(options & (1 << (f - FoldingOptions::FOLDING_START)));
	return S_OK;
}

/// @see ISearchOptions::put_MultigraphExpansionOption
STDMETHODIMP SearchOptions::put_MultigraphExpansionOption(MultigraphExpansionType options) {
	for(int f = FoldingOptions::MULTIGRAPH_EXPANSION_START; f < FoldingOptions::MULTIGRAPH_EXPANSION_END; ++f)
		options_.foldings[f] = toBoolean(options & (1 << (f - FoldingOptions::MULTIGRAPH_EXPANSION_START)));
	return S_OK;
}

/// @see ISearchOptions::put_OnlyIdentifiers
STDMETHODIMP SearchOptions::put_OnlyIdentifiers(VARIANT_BOOL enabled) {
//	options_.onlyIdentifier = toBoolean(enabled);
	return E_NOTIMPL;
}

/// @see ISearchOptions::put_SearchType
STDMETHODIMP SearchOptions::put_SearchType(::SearchType type) {
	switch(type) {
	case Literal:	options_.type = TextSearcher::LITERAL;				break;
	case Regexp:	options_.type = TextSearcher::REGULAR_EXPRESSION;	break;
	case Wildcard:	return E_NOTIMPL;
	case Migemo:	options_.type = TextSearcher::MIGEMO;				break;
	default:		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see ISearchOptions::put_WholeWord
STDMETHODIMP SearchOptions::put_WholeWord(VARIANT_BOOL enabled) {
	options_.wholeWord = toBoolean(enabled);
	return S_OK;
}


// Configurations class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Configurations::Configurations(AlphaApp& app) : SAFE_MARK, app_(app) {
}

/// @see IConfigurations::AddDocumentType
STDMETHODIMP Configurations::AddDocumentType(BSTR name, BSTR fileSpec,
		BSTR command /* = 0 */, VARIANT_BOOL hiddenType /* = VARIANT_FALSE */) {
	if(name == 0 || fileSpec == 0 || ::SysStringLen(fileSpec) >= MAX_PATH)
		return E_INVALIDARG;

	DocumentType type;

	type.name = name;
	wcscpy(type.fileSpec, fileSpec);
	type.command = SAFE_BSTR(command);
	type.hidden = toBoolean(hiddenType);
	app_.getBufferList().getDocumentTypeManager().add(type);
	return S_OK;
}

/// @see IConfigurations::Apply
STDMETHODIMP Configurations::Apply() {
	app_.loadKeyBinds(L"");
	return S_OK;
}

/// @see IConfigurations::get__NewEnum
STDMETHODIMP Configurations::get__NewEnum(IUnknown** enumerator) {
	VERIFY_POINTER(enumerator);
	*enumerator = 0;
	return E_NOTIMPL;
}

/// @see IConfigurations::get_KeyboardScheme
STDMETHODIMP Configurations::get_KeyboardSchemes(BSTR scopeName, IKeyboardScheme** keyboardScheme) {
	VERIFY_POINTER(keyboardScheme);
	*keyboardScheme = 0;
	if(scopeName == 0)
		return E_INVALIDARG;
	else if(wcscmp(scopeName, L"basic") != 0)	// ̂Ƃ1
		return E_INVALIDARG;

	if(0 == (*keyboardScheme = new KeyboardScheme(app_.getKeyboardMap())))
		return E_OUTOFMEMORY;
	(*keyboardScheme)->AddRef();
	return S_OK;
}

/// @see IConfigurations::get_Property
STDMETHODIMP Configurations::get_Property(BSTR name, BSTR* value) {
	VERIFY_POINTER(value);
	if(name == 0)
		return E_INVALIDARG;
	*value = 0;
	return E_NOTIMPL;
}

/// @see IConfigurations::put_Property
STDMETHODIMP Configurations::put_Property(BSTR name, BSTR value) {
	if(name == 0)
		return E_INVALIDARG;
	modifiedProperties_[name] = SAFE_BSTR(value);
	return S_OK;
}

/// @see IConfigurations::RemoveAllDocumentTypes
STDMETHODIMP Configurations::RemoveAllDocumentTypes() {
	app_.getBufferList().getDocumentTypeManager().removeAll();
	return S_OK;
}


// KeyboardScheme class implementation
/////////////////////////////////////////////////////////////////////////////

map<wstring, VirtualKey> KeyboardScheme::keyValues_;

/// RXgN^
KeyboardScheme::KeyboardScheme(KeyboardMap& impl) : SAFE_MARK, impl_(impl) {
}

/// @see IKeyboardScheme::Assign
STDMETHODIMP KeyboardScheme::Assign(BSTR keyCombination, VARIANT command, VARIANT_BOOL* overridden) {
	KeyCombination keys1, keys2;

	if(!parseKeyCombinationString(keyCombination, keys1, keys2))
		return E_INVALIDARG;
	if(command.vt != VT_I4 && command.vt != VT_DISPATCH)
		return E_INVALIDARG;

	Alpha::KeyAssignableCommand* newCommand = (command.vt == VT_I4) ?
		new BuiltInCommand(static_cast<CommandID>(command.lVal))
		: static_cast<Alpha::KeyAssignableCommand*>(new ScriptletCommand(*command.pdispVal));
	const bool overwritten = (keys2.key == VK_NULL) ?
		impl_.assign(*newCommand, keys1) : impl_.assign(*newCommand, keys1, keys2);

	if(overridden != 0)
		*overridden = toVariantBoolean(overwritten);
	delete newCommand;
	return S_OK;
}

/// @see IKeyboardScheme::get_Name
STDMETHODIMP KeyboardScheme::get_Name(BSTR* name) {
	VERIFY_POINTER(name);
	*name = ::SysAllocString(schemeName_.c_str());
	return (*name != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IKeyboardScheme::Load
STDMETHODIMP KeyboardScheme::Load(BSTR schemeName) {
	if(schemeName == 0)
		return E_INVALIDARG;

	WCHAR path[MAX_PATH];

	::GetModuleFileName(0, path, MAX_PATH);
	wcscpy(::PathFindFileNameW(path), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
	if(wcslen(path) + ::SysStringLen(schemeName) + 4 >= MAX_PATH)
		return E_INVALIDARG;
	wcscat(path, schemeName);
	wcscat(path, L".akm");
	if(impl_.load(path)) {
		schemeName_ = schemeName;
		return S_OK;
	}
	return E_FAIL;
}

/// L[gݍ킹\͂
bool KeyboardScheme::parseKeyCombinationString(
		const BSTR keyCombination, KeyCombination& firstKeys, KeyCombination& secondKeys) {
	if(keyCombination == 0 || ::SysStringLen(keyCombination) > 100)
		return false;

	if(keyValues_.empty()) {
		wchar_t buffer[4] = {0, 0, 0, 0};
		keyValues_[L"bs"] = keyValues_[L"backspace"] = VK_BACK;
		keyValues_[L"tab"] = VK_TAB;
		keyValues_[L"del"] = keyValues_[L"delete"] = VK_DELETE;
		keyValues_[L"enter"] = VK_RETURN;
		keyValues_[L"esc"] = keyValues_[L"escape"] = VK_ESCAPE;
		keyValues_[L"sp"] = keyValues_[L"space"] = VK_SPACE;
		keyValues_[L"pgup"] = keyValues_[L"pageup"] = VK_PRIOR;
		keyValues_[L"pgdn"] = keyValues_[L"pagedown"] = VK_NEXT;
		keyValues_[L"end"] = VK_END;
		keyValues_[L"home"] = VK_HOME;
		keyValues_[L"left"] = VK_LEFT;
		keyValues_[L"up"] = VK_UP;
		keyValues_[L"right"] = VK_RIGHT;
		keyValues_[L"down"] = VK_DOWN;
		keyValues_[L"ins"] = keyValues_[L"insert"] = VK_INSERT;
		for(size_t i = 0; i < 10; ++i) {
			buffer[0] = L'0' + static_cast<wchar_t>(i);
			keyValues_[buffer] = static_cast<VirtualKey>('0' + i);
		}
		for(size_t i = 0; i < 26; ++i) {
			buffer[0] = L'a' + static_cast<wchar_t>(i);
			keyValues_[buffer] = static_cast<VirtualKey>('A' + i);
		}
		buffer[0] = L'f';
		for(size_t i = 0; i < 10; ++i) {
			buffer[1] = L'0' + static_cast<wchar_t>(i) + 1;
			keyValues_[buffer] = static_cast<VirtualKey>(VK_F1 + i);
		}
		buffer[1] = L'1';
		for(size_t i = 0; i < 10; ++i) {
			buffer[2] = L'0' + static_cast<wchar_t>(i);
			keyValues_[buffer] = static_cast<VirtualKey>(VK_F10 + i);
		}
		buffer[1] = L'2';
		for(size_t i = 0; i < 4; ++i) {
			buffer[2] = L'0' + static_cast<wchar_t>(i);
			keyValues_[buffer] = static_cast<VirtualKey>(VK_F20 + i);
		}
		keyValues_[L":"] = VK_OEM_1;
		keyValues_[L";"] = VK_OEM_PLUS;
		keyValues_[L","] = VK_OEM_COMMA;
		keyValues_[L"-"] = VK_OEM_MINUS;
		keyValues_[L"."] = VK_OEM_PERIOD;
		keyValues_[L"/"] = VK_OEM_2;
		keyValues_[L"@"] = VK_OEM_3;
		keyValues_[L"["] = VK_OEM_4;
		keyValues_[L"\\"] = VK_OEM_5;
		keyValues_[L"]"] = VK_OEM_6;
		keyValues_[L"^"] = VK_OEM_7;
	}

	wchar_t keys[120];	// wcsncmp ĝő߂...
	KeyModifier modifiers = 0;
	wchar_t* p = keys;

	firstKeys.key = secondKeys.key = VK_NULL;
	wcscpy(keys, keyCombination);
	::CharLowerBuffW(keys, static_cast<DWORD>(wcslen(keys)));

	// ͂ŏCL[ƃCL[o
	while(*p != 0) {
		if(wcsncmp(p, L"c-", 2) == 0)			{modifiers |= KM_CTRL; p += 2;}
		else if(wcsncmp(p, L"ctrl+", 5) == 0)	{modifiers |= KM_CTRL; p += 5;}
		else if(wcsncmp(p, L"s-", 2) == 0)		{modifiers |= KM_SHIFT; p += 2;}
		else if(wcsncmp(p, L"shift+", 6) == 0)	{modifiers |= KM_SHIFT; p += 6;}
		else if(wcsncmp(p, L"m-", 2) == 0)		{modifiers |= KM_ALT; p += 2;}
		else if(wcsncmp(p, L"alt+", 4) == 0)	{modifiers |= KM_ALT; p += 4;}
		else {	// CL[
			wchar_t* sp = wcschr(p, L' ');
			if(sp == p)
				return false;	// 擪ɋ󔒂
			if(sp != 0) {
				if(firstKeys.key != VK_NULL)
					return false;	// 󔒂2ȏ゠
				*sp = 0;
			}
			map<wstring, VirtualKey>::const_iterator it = keyValues_.find(p);
			if(it == keyValues_.end())
				return false;	// CL[Ȃ
			if(firstKeys.key == VK_NULL) {
				firstKeys.key = it->second;
				firstKeys.modifiers = modifiers;
			} else {
				secondKeys.key = it->second;
				secondKeys.modifiers = modifiers;
			}
			if(sp != 0) {
				p = sp + 1;
				modifiers = 0;
			} else
				break;
		}
	}
	return firstKeys.key != VK_NULL;	// CL[1
}

/// @see IKeyboardScheme::Save
STDMETHODIMP KeyboardScheme::Save(BSTR schemeName) {
	if(schemeName == 0)
		return E_INVALIDARG;

	wchar_t path[MAX_PATH];
	::GetModuleFileName(0, path, MAX_PATH);
	wcscpy(::PathFindFileNameW(path), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
	if(wcslen(path) + ::SysStringLen(schemeName) + 4 >= MAX_PATH)
		return E_INVALIDARG;
	wcscat(path, schemeName);
	wcscat(path, L".akm");
	if(impl_.save(path)) {
		schemeName_ = schemeName;
		return S_OK;
	}
	return E_FAIL;
}

/// @see IKeyboardScheme::Unassign
STDMETHODIMP KeyboardScheme::Unassign(BSTR keyCombination) {
	KeyCombination keys1, keys2;
	if(!parseKeyCombinationString(keyCombination, keys1, keys2))
		return E_INVALIDARG;
	if(keys2.key == VK_NULL)
		impl_.unassign(keys1);
	else
		impl_.unassign(keys1, keys2);
	return S_OK;
}


// Command class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param app	AvP[VIuWFNg
 *	@param id	R}hʎq
 */
Ambient::Command::Command(AlphaApp& app, CommandID id) : SAFE_MARK, app_(app), id_(id) {
}

/// @see ICommand::Execute
STDMETHODIMP Ambient::Command::Execute() {
	const_cast<CommandManager&>(app_.getCommandManager()).executeCommand(id_, false);	// Y
	return S_OK;
}

/// @see ICommand::get_Checked
STDMETHODIMP Ambient::Command::get_Checked(VARIANT_BOOL* checked) {
	VERIFY_POINTER(checked);
	*checked = toVariantBoolean(app_.getCommandManager().isChecked(id_));
	return S_OK;
}

/// @see ICommand::get_Description
STDMETHODIMP Ambient::Command::get_Description(BSTR* description) {
	VERIFY_POINTER(description);
	*description = ::SysAllocString(app_.getCommandManager().getDescription(id_).c_str());
	return (*description != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see ICommand::get_Enabled
STDMETHODIMP Ambient::Command::get_Enabled(VARIANT_BOOL* enabled) {
	VERIFY_POINTER(enabled);
	*enabled = toVariantBoolean(app_.getCommandManager().isEnabled(id_, false));
	return S_OK;
}

/// @see ICommand::get_Id
STDMETHODIMP Ambient::Command::get_Id(long* identifier) {
	VERIFY_POINTER(identifier);
	*identifier = id_;
	return S_OK;
}

/// @see ICommand::get_KeyCombination
STDMETHODIMP Ambient::Command::get_KeyCombination(BSTR* keys) {
	VERIFY_POINTER(keys);
	*keys = ::SysAllocString(app_.getKeyboardMap().getKeyString(id_, false).c_str());
	return (*keys != 0) ? S_OK  : E_OUTOFMEMORY;
}

/// @see ICommand::get_Name
STDMETHODIMP Ambient::Command::get_Name(BSTR* name) {
	VERIFY_POINTER(name);
	*name = ::SysAllocString(app_.getCommandManager().getName(id_).c_str());
	return (*name != 0) ? S_OK  : E_OUTOFMEMORY;
}

/// @see IObjectIdentity::IsEqualObject
STDMETHODIMP Ambient::Command::IsEqualObject(IUnknown* other) {
	if(other == 0)
		return E_INVALIDARG;
	ComPtr<ICommand> rhs;
	if(FAILED(other->QueryInterface(IID_ICommand, reinterpret_cast<void**>(&rhs))))
		return S_FALSE;
	return (reinterpret_cast<Ambient::Command*>(static_cast<ICommand*>(rhs))->id_ == id_) ? S_OK : S_FALSE;
}


// ClipboardRing class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Ambient::ClipboardRing::ClipboardRing(Ascension::ClipboardRing& impl) : SAFE_MARK, impl_(impl) {
}

/// @see IClipboardRing::Add
STDMETHODIMP Ambient::ClipboardRing::Add(BSTR text) {
	if(text == 0)
		return E_INVALIDARG;
	impl_.add(text, false);
	return S_OK;
}

/// @see IClipboardRing::Delete
STDMETHODIMP Ambient::ClipboardRing::Delete(short index) {
	if(index < 0 || index > numeric_limits<unsigned char>::max())
		return E_INVALIDARG;
	try {
		impl_.remove(static_cast<unsigned char>(index));
	} catch(...) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see IClipboardRing::DeleteAll
STDMETHODIMP Ambient::ClipboardRing::DeleteAll() {
	impl_.removeAll();
	return S_OK;
}

/// @see IClipboardRing::get_Count
STDMETHODIMP Ambient::ClipboardRing::get_Count(short* count) {
	VERIFY_POINTER(count);
	*count = static_cast<short>(impl_.getCount());
	return S_OK;
}

/// @see IClipboardRing::get_Text
STDMETHODIMP Ambient::ClipboardRing::get_Text(short index, BSTR* text) {
	VERIFY_POINTER(text);
	if(index < 0 || index > numeric_limits<unsigned char>::max())
		return E_INVALIDARG;

	wstring	s;
	bool b;

	try {
		impl_.getText(static_cast<unsigned char>(index), s, b);
	} catch(...) {
		return E_INVALIDARG;
	}
	*text = ::SysAllocString(s.c_str());
	return (*text != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IObjectIdentity::IsEqualObject
STDMETHODIMP Ambient::ClipboardRing::IsEqualObject(IUnknown* other) {
	if(other == 0)
		return E_INVALIDARG;
	ComPtr<IClipboardRing> dummy;
	return SUCCEEDED(other->QueryInterface(IID_IClipboardRing, reinterpret_cast<void**>(&dummy))) ? S_OK : S_FALSE;
}

/// @see IClipboardRing::LimitCount
STDMETHODIMP Ambient::ClipboardRing::LimitCount(short limit) {
	if(limit < 0 || limit > numeric_limits<uchar>::max())
		return E_INVALIDARG;
	impl_.limitCount(static_cast<uchar>(limit));
	return S_OK;
}


// Abbreviations class implementation
/////////////////////////////////////////////////////////////////////////////

/// @see IAbbreviations::Expand
STDMETHODIMP Ambient::Abbreviations::Expand(BSTR abbreviation, BSTR* expanded) {
	VERIFY_POINTER(expanded);
	*expanded = 0;
	if(abbreviation == 0 || *abbreviation == 0)
		return E_INVALIDARG;
	const string_t s = EditView::getAbbreviations().expand(abbreviation);
	*expanded = ::SysAllocString(s.c_str());
	return (*expanded != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IAbbreviations::get__NewEnum
STDMETHODIMP Ambient::Abbreviations::get__NewEnum(IUnknown** enumerator) {
	VERIFY_POINTER(enumerator);

	set<string_t> abbreviations;

	EditView::getAbbreviations().getList(abbreviations);

	VARIANT* const array = new VARIANT[abbreviations.size()];

	set<string_t>::const_iterator it = abbreviations.begin();
	for(size_t i = 0; i < abbreviations.size(); ++i, ++it) {
		::VariantInit(&array[i]);
		array[i].vt = VT_BSTR;
		array[i].bstrVal = ::SysAllocString(it->c_str());
	}
	*enumerator = new IEnumVARIANTImpl(array, array + abbreviations.size());
	if(*enumerator != 0)
		(*enumerator)->AddRef();

	for(size_t i = 0; i < abbreviations.size(); ++i)
		::VariantClear(&array[i]);
	delete[] array;

	return (*enumerator != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IObjectIdentity::IsEqualObject
STDMETHODIMP Ambient::Abbreviations::IsEqualObject(IUnknown* other) {
	if(other == 0)
		return E_INVALIDARG;
	ComPtr<IAbbreviations> dummy;
	return SUCCEEDED(other->QueryInterface(IID_IAbbreviations, reinterpret_cast<void**>(&dummy))) ? S_OK : S_FALSE;
}

/// @see IAbbreviations::Register
STDMETHODIMP Ambient::Abbreviations::Register(BSTR abbreviation, BSTR expanded) {
	if(abbreviation == 0 || expanded == 0)
		return E_INVALIDARG;
	try {
		EditView::getAbbreviations().insert(abbreviation, expanded);
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see IAutomationAbbreviations::Revoke
STDMETHODIMP Ambient::Abbreviations::Revoke(BSTR abbreviation) {
	if(abbreviation == 0 || *abbreviation == 0)
		return E_INVALIDARG;
	EditView::getAbbreviations().remove(abbreviation);
	return S_OK;
}

/// @see IAutomationAbbreviations::RevokeAll
STDMETHODIMP Ambient::Abbreviations::RevokeAll() {
	EditView::getAbbreviations().removeAll();
	return S_OK;
}


// ScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
ScriptHost::ScriptHost(AlphaScriptHost& impl) : SAFE_MARK, impl_(&impl) {
	impl_->AddRef();
}

/// fXgN^
ScriptHost::~ScriptHost() {
	impl_->Release();
}

/// @see IScriptHost::ConnectObject
STDMETHODIMP ScriptHost::ConnectObject(IDispatch* sourceObject, BSTR prefix) {
	VERIFY_POINTER(sourceObject);
	if(prefix == 0)
		return E_INVALIDARG;

	try {
		HRESULT	hr;
		if(FAILED(hr = impl_->connectObject(*sourceObject, prefix)))
			throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.ConnectObject"));
	} catch(ComException& e) {
		e.throwLogicalThreadError();
		return e.getSCode();
	}
	return S_OK;
}

/// @see IScriptHost::CreateObject
STDMETHODIMP ScriptHost::CreateObject(BSTR progID, BSTR prefix, IDispatch** newObject) {
	if(newObject == 0)
		return S_OK;
	*newObject = 0;
	if(progID == 0)
		return E_INVALIDARG;

	CLSID clsid;
	HRESULT hr;

	try {
		if(FAILED(hr = ::CLSIDFromProgID(progID, &clsid)))
			throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.CreateObject"));
		if(URLPOLICY_ALLOW != verifyCreationObject(clsid)) {
			hr = 0x800A01AD;
			throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.CreateObject"));
		}
		if(FAILED(hr = ::CoCreateInstance(clsid, 0, CLSCTX_ALL, IID_IDispatch, reinterpret_cast<void**>(newObject))))
			throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.CreateObject"));
	} catch(ComException& e) {
		*newObject = 0;
		e.throwLogicalThreadError();
		return hr;
	}
	if(URLPOLICY_ALLOW != verifyRunningObject(**newObject, clsid)) {
		(*newObject)->Release();
		*newObject = 0;
		return 0x800A01AD;
	}
	return (prefix == 0) ? S_OK : ConnectObject(*newObject, prefix);
}

/// @see IScriptHost::DisconnectObject
STDMETHODIMP ScriptHost::DisconnectObject(IDispatch* sourceObject) {
	VERIFY_POINTER(sourceObject);

	try {
		const HRESULT hr = impl_->disconnectObject(*sourceObject);
		if(FAILED(hr))
			throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.DisconnectObject"));
	} catch(ComException& e) {
		e.throwLogicalThreadError();
		return e.getSCode();
	}
	return S_OK;
}

/// @see IScriptHost::Echo
STDMETHODIMP ScriptHost::Echo(SAFEARRAY/*<VARIANT>*/* arguments) {
	if(arguments == 0 && ::SafeArrayGetDim(arguments) != 1)
		return E_INVALIDARG;
	if(!impl_->isInteractive())
		return S_OK;

	wostringstream ss;
	long argumentCount;
	VARIANTARG* args;
	VARIANTARG arg;

	::SafeArrayGetUBound(arguments, 1, &argumentCount);
	++argumentCount;
	::SafeArrayAccessData(arguments, reinterpret_cast<void**>(&args));
	for(long i = 0; i < argumentCount; ++i) {
		::VariantInit(&arg);
		if(FAILED(::VariantChangeType(&arg, &args[i], 0, VT_BSTR)))
			return DISP_E_TYPEMISMATCH;
		ss << SAFE_BSTR(arg.bstrVal);
		::VariantClear(&arg);
		if(i != argumentCount - 1)
			ss << L" ";
	}
	::SafeArrayUnaccessData(arguments);

	HWND window;
	impl_->GetWindow(&window);
	::MessageBoxW(window, ss.str().c_str(), AlphaScriptHost::NAME, MB_OK);
	return S_OK;
}

/// @see IScriptHost::get_Arguments
STDMETHODIMP ScriptHost::get_Arguments(IArguments** arguments) {
	VERIFY_POINTER(arguments);

	vector<wstring> args;
	if(0 == (*arguments = new Arguments(args)))
		return E_OUTOFMEMORY;
	(*arguments)->AddRef();
	return S_OK;
}

/// @see IScriptHost::get_BuildVersion
STDMETHODIMP ScriptHost::get_BuildVersion(short* buildVersion) {
	VERIFY_POINTER(buildVersion);
	*buildVersion = AlphaScriptHost::BUILD_VERSION;
	return S_OK;
}

/// @see IScriptHost::get_FullName
STDMETHODIMP ScriptHost::get_FullName(BSTR* fullName) {
	VERIFY_POINTER(fullName);
	wchar_t pathName[MAX_PATH];
	::GetModuleFileNameW(0, pathName, MAX_PATH);
	*fullName = ::SysAllocString(pathName);
	return (*fullName != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IScriptHost::get_Interactive
STDMETHODIMP ScriptHost::get_Interactive(VARIANT_BOOL* interactive) {
	VERIFY_POINTER(interactive);
	*interactive = toVariantBoolean(impl_->isInteractive());
	return S_OK;
}

/// @see IScriptHost::get_Name
STDMETHODIMP ScriptHost::get_Name(BSTR* name) {
	VERIFY_POINTER(name);

	wchar_t pathName[MAX_PATH];
	::GetModuleFileNameW(0, pathName, MAX_PATH);
	*name = ::SysAllocString(::PathFindFileNameW(pathName));
	return (*name != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IScriptHost::get_Path
STDMETHODIMP ScriptHost::get_Path(BSTR* path) {
	VERIFY_POINTER(path);
	wchar_t pathName[MAX_PATH];
	::GetModuleFileNameW(0, pathName, MAX_PATH);
	*path = ::SysAllocStringLen(pathName, static_cast<UINT>(pathName - ::PathFindFileNameW(pathName)) - 1);
	return (*path != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IScriptHost::get_ScriptFullName
STDMETHODIMP ScriptHost::get_ScriptFullName(BSTR* scriptFullName) {
	VERIFY_POINTER(scriptFullName);
	*scriptFullName = ::SysAllocString(impl_->getScriptFileName());
	return (*scriptFullName != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IScriptHost::get_ScriptName
STDMETHODIMP ScriptHost::get_ScriptName(BSTR* scriptName) {
	VERIFY_POINTER(scriptName);
	*scriptName = ::SysAllocString(::PathFindFileNameW(impl_->getScriptFileName()));
	return (*scriptName != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IScriptHost::get_StdErr
STDMETHODIMP ScriptHost::get_StdErr(IDispatch** stdErr) {
	VERIFY_POINTER(stdErr);
	*stdErr = 0;
	return E_NOTIMPL;
}

/// @see IScriptHost::get_StdIn
STDMETHODIMP ScriptHost::get_StdIn(IDispatch** stdIn) {
	VERIFY_POINTER(stdIn);
	*stdIn = 0;
	return E_NOTIMPL;
}

/// @see IScriptHost::get_StdOut
STDMETHODIMP ScriptHost::get_StdOut(IDispatch** stdOut) {
	VERIFY_POINTER(stdOut);
	*stdOut = 0;
	return E_NOTIMPL;
}

/// @see IScriptHost::get_Timeout
STDMETHODIMP ScriptHost::get_Timeout(long* milliseconds) {
	VERIFY_POINTER(milliseconds);
	*milliseconds = static_cast<long>(impl_->getTimeout());
	return S_OK;
}

/// @see IScriptHost::get_Version
STDMETHODIMP ScriptHost::get_Version(BSTR* versionString) {
	VERIFY_POINTER(versionString);

	wchar_t version[10];
	swprintf(version, L"%u.%u", AlphaScriptHost::MAJOR_VERSION, AlphaScriptHost::MINOR_VERSION);
	*versionString = ::SysAllocString(version);
	return (*versionString != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IScriptHost::GetObject
STDMETHODIMP ScriptHost::GetObject(BSTR pathName, BSTR progID, BSTR prefix, IDispatch** newObject) {
	if(newObject == 0)
		return S_OK;

	HRESULT hr = S_OK;
	CLSID clsid = CLSID_NULL;

	*newObject = 0;
	try {
		if(progID != 0) {
			if(FAILED(hr = ::CLSIDFromProgID(progID, &clsid)))
				throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		}
		if(URLPOLICY_ALLOW != verifyCreationObject(clsid)) {
			hr = 0x800A01AD;
			throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		}
	} catch(ComException& e) {
		e.throwLogicalThreadError();
		return hr;
	}

	try {
		if(progID == 0) {
			if(FAILED(hr = ::CoGetObject(pathName, 0, IID_IDispatch, reinterpret_cast<void**>(newObject))))
				throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		} else {	// GetInstanceFromFile g
			MULTI_QI mq = {&IID_IDispatch, 0, 0};

			if(FAILED(hr = ::CoGetInstanceFromFile(0, &clsid, 0, CLSCTX_ALL, STGM_READWRITE, pathName, 1, &mq)))
				throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
			hr = mq.pItf->QueryInterface(IID_IDispatch, reinterpret_cast<void**>(newObject));
		}
		if(URLPOLICY_ALLOW != verifyRunningObject(**newObject, clsid)) {
			hr = 0x800A01AD;
			throw ComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		}
	} catch(ComException& e) {
		*newObject = 0;
		e.throwLogicalThreadError();
		return hr;
	}
	return hr;
}

/// @see IScriptHost::put_Interactive
STDMETHODIMP ScriptHost::put_Interactive(VARIANT_BOOL interactive) {
	impl_->setInteractiveMode(toBoolean(interactive));
	return S_OK;
}

/// @see IScriptHost::LoadConstants
STDMETHODIMP ScriptHost::LoadConstants(IDispatch* sourceObject) {
	if(sourceObject == 0)
		return E_INVALIDARG;

	UINT c;
	sourceObject->GetTypeInfoCount(&c);
	if(c != 0) {
		ComPtr<ITypeInfo> typeInfo;
		if(SUCCEEDED(sourceObject->GetTypeInfo(0, LOCALE_USER_DEFAULT, &typeInfo))) {
			ComPtr<ITypeLib> typeLib;
			UINT i;
			if(SUCCEEDED(typeInfo->GetContainingTypeLib(&typeLib, &i)))
				return impl_->loadConstants(*typeLib) ? S_OK : E_INVALIDARG;
		}
	}
	return E_INVALIDARG;
}

/// @see IScriptHost::Quit
STDMETHODIMP ScriptHost::Quit(short exitCode /* = 0 */) {
	IActiveScript* scriptEngine;
	AutoZero<EXCEPINFO> exception;
	impl_->getScriptEngine(scriptEngine);
	const HRESULT hr = scriptEngine->InterruptScriptThread(SCRIPTTHREADID_ALL, &exception, 0);
	scriptEngine->Release();
	return hr;
}

/// @see IScriptHost::Sleep
STDMETHODIMP ScriptHost::Sleep(long milliseconds) {
	if(milliseconds < 0)
		return E_INVALIDARG;
	impl_->sleep(static_cast<unsigned long>(milliseconds));
	return S_OK;
}

/**
 *	ActiveX IuWFNg̍쐬\zXgɖ₢킹
 *	@param clsid	쐬悤ƂĂIuWFNg CLSID
 *	@return			|V[
 */
DWORD ScriptHost::verifyCreationObject(CLSID& clsid) {
	IActiveScript* scriptEngine;
	ComPtr<IObjectSafety> objectSafety;
	DWORD supportedOpts, enabledOpts;

	impl_->getScriptEngine(scriptEngine);
	if(FAILED(scriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&objectSafety))))
		return URLPOLICY_DISALLOW;
	scriptEngine->Release();
	if(FAILED(objectSafety->GetInterfaceSafetyOptions(IID_IActiveScript, &supportedOpts, &enabledOpts)))
		return URLPOLICY_DISALLOW;
	if(toBoolean(enabledOpts & INTERFACE_USES_SECURITY_MANAGER)) {
		ComPtr<IServiceProvider> serviceProvider;
		ComPtr<IInternetHostSecurityManager> securityManager;

		if(FAILED(impl_->QueryInterface(IID_IServiceProvider, reinterpret_cast<void**>(&serviceProvider))))
			return URLPOLICY_DISALLOW;
		if(FAILED(serviceProvider->QueryService(SID_SInternetHostSecurityManager,
				IID_IInternetHostSecurityManager, reinterpret_cast<void**>(&securityManager))))
			return URLPOLICY_DISALLOW;

		DWORD policy;
		if(FAILED(securityManager->ProcessUrlAction(URLACTION_ACTIVEX_RUN,
				reinterpret_cast<BYTE*>(&policy), sizeof(DWORD),
				reinterpret_cast<BYTE*>(&clsid), sizeof(CLSID), 0, 0)))
			return URLPOLICY_DISALLOW;
		return policy;
	} else
		return toBoolean(enabledOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER) ? URLPOLICY_DISALLOW : URLPOLICY_ALLOW;
}

/**
 *	ActiveX IuWFNg̍쐬\zXgɖ₢킹
 *	@param object	IuWFNg
 *	@param clsid	IuWFNg CLSID
 *	@return			|V[
 */
DWORD ScriptHost::verifyRunningObject(IUnknown& object, CLSID& clsid) {
/*	ComPtr<IActiveScriptSite>	pScriptHost;
	ComPtr<IObjectSafety>		pObjectSafety;
	DWORD						dwSupportedOpts, dwEnabledOpts;

	if(FAILED(m_pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pObjectSafety))))
		return URLPOLICY_DISALLOW;
	if(FAILED(pObjectSafety->GetInterfaceSafetyOptions(IID_IActiveScript, &dwSupportedOpts, &dwEnabledOpts)))
		return URLPOLICY_DISALLOW;
	if(toBoolean(dwEnabledOpts & INTERFACE_USES_SECURITY_MANAGER)) {
		CComPtr<IServiceProvider>				pServiceProvider;
		CComPtr<IInternetHostSecurityManager>	pSecurityManager;

		if(FAILED(m_pScriptEngine->GetScriptSite(IID_IActiveScriptSite, reinterpret_cast<void**>(&pScriptHost))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pScriptHost->QueryInterface(IID_IServiceProvider, reinterpret_cast<void**>(&pServiceProvider))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pServiceProvider->QueryService(SID_SInternetHostSecurityManager,
				IID_IInternetHostSecurityManager, reinterpret_cast<void**>(&pSecurityManager))))
			return URLPOLICY_DISALLOW;

		DWORD			dwPolicy, cbPolicy;
		DWORD*			pdwPolicy;
		CONFIRMSAFETY	cs = {clsid, pUnk, 0};

		cs.pUnk->AddRef();
		if(FAILED(pSecurityManager->QueryCustomPolicy(GUID_CUSTOM_CONFIRMOBJECTSAFETY,
				reinterpret_cast<BYTE**>(&pdwPolicy), &cbPolicy,
				reinterpret_cast<BYTE*>(&cs), sizeof(CONFIRMSAFETY), 0)))
			return URLPOLICY_DISALLOW;
		dwPolicy = URLPOLICY_DISALLOW;
		if (pdwPolicy != 0) {
			if (sizeof(DWORD) <= cbPolicy)
			dwPolicy = *pdwPolicy;
			::CoTaskMemFree(pdwPolicy);
		}
		return dwPolicy;
	} else*/
		return /*toBoolean(dwEnabledOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER) ? URLPOLICY_DISALLOW :*/ URLPOLICY_ALLOW;
}


// Arguments class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Arguments::Arguments(const vector<wstring>& args) : SAFE_MARK, arguments_(args) {
}

/// @see IArguments::Count
STDMETHODIMP Arguments::Count(long* count) {
	if(count != 0)
		*count = static_cast<long>(arguments_.size());
	return S_OK;
}

/// @see IArguments::get__NewEnum
STDMETHODIMP Arguments::get__NewEnum(IUnknown** enumerator) {
	VERIFY_POINTER(enumerator);
	*enumerator = 0;
	return E_NOTIMPL;
}

/// @see IArguments::get_Item
STDMETHODIMP Arguments::get_Item(long index, BSTR* argument) {
	VERIFY_POINTER(argument);

	if(index < 0 || index >= static_cast<long>(arguments_.size()))
		return 0x800A0009;
	*argument = ::SysAllocString(arguments_[index].c_str());
	return (*argument != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see IArguments::get_Length
STDMETHODIMP Arguments::get_Length(long* count) {
	VERIFY_POINTER(count);
	*count = static_cast<long>(arguments_.size());
	return S_OK;
}

/// @see IArguments::get_Named
STDMETHODIMP Arguments::get_Named(IDispatch** named) {
	VERIFY_POINTER(named);
	*named = 0;
	return E_NOTIMPL;
}

/// @see IArguments::get_Unamed
STDMETHODIMP Arguments::get_Unnamed(IDispatch** unnamed) {
	VERIFY_POINTER(unnamed);
	*unnamed = 0;
	return E_NOTIMPL;
}

/// @see IArguments::ShowUsage
STDMETHODIMP Arguments::ShowUsage() {
	return E_NOTIMPL;
}


#undef INVOKE_ARGLIST
#undef VERIFY_ARGUMENTS_COUNT
#undef COERCE_ARGUMENT_AT
#undef SAFE_MARK
#undef UNSAFE_MARK
#undef CHECK_IF_DISPOSED

#pragma warning(default : 4390)

/* [EOF] */