// Ambient.h
// (c) 2003-2006 exeal

#ifndef AMBIENT_H_
#define AMBIENT_H_

#include <objbase.h>	// interface
#include "AmbientIdl.h"	// generated from AmbientIdl.idl
#include "Alpha.h"
#include "KeyboardMap.h"
#include "../Armaiti/DispatchImpl.hpp"
//#include <dispex.h>

#pragma warning(disable : 4250)	// u2 ȏ̃oOĂ܂B...v

#ifndef __dispex_h__
DEFINE_GUID(IID_IObjectIdentity, 0xCA04B7E6, 0x0D21, 0x11D1, 0x8C, 0xC5, 0x00, 0xC0, 0x4F, 0xC2, 0xB0, 0x85);
interface IObjectIdentity : public IUnknown {	// IID is CA04B7E6-0D21-11d1-8CC5-00C04FC2B085
public:
	virtual HRESULT STDMETHODCALLTYPE IsEqualObject(/* [in] */ IUnknown* other) = 0;
};
#endif /* !__dispex_h__ */

interface IActiveScript;


namespace Ascension {
	class ClipboardRing;
}

namespace Alpha {

class AlphaApp;
class AlphaDoc;
class AlphaView;
class AlphaScriptHost;
class EnumImpl;


namespace Ambient {
	class EditorPane;

	/// ^CvCũpXێ
	class AmbientTypeLibPath {
	public:
		static const OLECHAR* getPath() throw() {return OLESTR("Alpha.tlb");}
	};

#define AmbientObjectBase(Interface)													\
	public Armaiti::OLE::IDispatchImpl<Interface,										\
		Armaiti::OLE::PathTypeLibTypeInfoHolder<AmbientTypeLibPath, &IID_##Interface>	\
	>,																					\
	public Armaiti::IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>

	/// bpIuWFNg̎IɎǗł
	template<class Implementation>
	class Disposable {
	public:
		Disposable() : disposed_(false) {}
	protected:
		bool isDisposed() const throw() {return disposed_;}
	private:
		void dispose() {disposed_ = true;}
	private:
		bool disposed_;
		friend Implementation;
	};

#define AmbientObjectBaseSupportError(Interface)	\
	AmbientObjectBase(Interface),					\
	public Armaiti::ISupportErrorInfoImpl<&IID_##Interface>

#define AmbientObjectBaseSupportIdentity(Interface)	\
	AmbientObjectBase(Interface), virtual public IObjectIdentity


	/// IApplication ̎
	class Application : AmbientObjectBaseSupportError(IApplication)/*,
			public Armaiti::OLE::IProvideClassInfo2Impl<&CLSID_Application, &IID_IApplication, &LIBID_Alpha>*/ {
	public:
		// RXgN^
		~Application();
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IApplication)
//			IMPLEMENTS_INTERFACE(IDispatchEx)
			IMPLEMENTS_INTERFACE(IDispatch)
			IMPLEMENTS_INTERFACE(ISupportErrorInfo)
//			IMPLEMENTS_INTERFACE(IProvideClassInfo2)
		END_INTERFACE_TABLE()
		// IDispatch
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);
		// IApplication
		STDMETHODIMP	get_Abbreviations(IAbbreviations** abbreviations);
		STDMETHODIMP	get_Active(VARIANT_BOOL* active);
		STDMETHODIMP	put_Active(VARIANT_BOOL active);
		STDMETHODIMP	get_ActiveBuffer(IBuffer** activeBuffer);
		STDMETHODIMP	get_Buffers(IBuffers** buffers);
		STDMETHODIMP	get_Configurations(IConfigurations** configurations);
		STDMETHODIMP	get_CurrentDirectory(BSTR* directory);
		STDMETHODIMP	put_CurrentDirectory(BSTR directory);
		STDMETHODIMP	get_EditorPanes(IEditorPanes** panes);
		STDMETHODIMP	get_FullName(BSTR* fullName);
		STDMETHODIMP	get_Height(long* height);
		STDMETHODIMP	put_Height(long height);
		STDMETHODIMP	get_Interactive(VARIANT_BOOL* interactive);
		STDMETHODIMP	put_Interactive(VARIANT_BOOL interactive);
		STDMETHODIMP	get_Left(long* left);
		STDMETHODIMP	put_Left(long left);
		STDMETHODIMP	get_Name(BSTR* name);
		STDMETHODIMP	get_Top(long* top);
		STDMETHODIMP	put_Top(long top);
		STDMETHODIMP	get_Version(BSTR* versionString);
		STDMETHODIMP	get_Visible(VARIANT_BOOL* visible);
		STDMETHODIMP	put_Visible(VARIANT_BOOL visible);
		STDMETHODIMP	get_Width(long* width);
		STDMETHODIMP	put_Width(long width);
		STDMETHODIMP	get_WindowState(WindowState* windowState);
		STDMETHODIMP	put_WindowState(WindowState windowState);
		STDMETHODIMP	ClearOutput();
		STDMETHODIMP	GetCommandById(long commandID, ICommand** command);
		STDMETHODIMP	Quit(short errorCode = 0);
		STDMETHODIMP	WriteToOutput(BSTR output, VARIANT_BOOL activate);
		STDMETHODIMP	WriteLineToOutput(BSTR output, VARIANT_BOOL activate);
	private:
		Application(AlphaApp& app, const std::vector<std::wstring>* arguments = 0);
		void	callHook(DISPID hookID, const DISPPARAMS* arguments);
	private:
		AlphaApp& app_;
		friend class AlphaDoc;
		friend class AlphaView;
		friend class AlphaApp;
	};


	/// IBuffers ̎
	class Buffers : AmbientObjectBase(IBuffers) {
	public:
		// RXgN^
		Buffers(BufferList& impl);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IBuffers)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IBuffers
		STDMETHODIMP	get__NewEnum(IUnknown** enumerator);
		STDMETHODIMP	get_Count(long* count);
		STDMETHODIMP	AddNew(IBuffer** newBuffer);
		STDMETHODIMP	CloseAll();
		STDMETHODIMP	Item(long index, IBuffer** buffer);
		STDMETHODIMP	Open(BSTR pathName, FileShareMode shareMode, long codePage, VARIANT_BOOL addToMRU, IBuffer** newBuffer);
		STDMETHODIMP	SaveAll();
	private:
		BufferList& impl_;
	};


	/// IBuffer ̎
	class Buffer : AmbientObjectBase(IBuffer), public Disposable<AlphaDoc> {
	public:
		// RXgN^
		Buffer(BufferList& parent, AlphaDoc& impl);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IBuffer)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IBuffer
		STDMETHODIMP	get_Active(VARIANT_BOOL* active);
		STDMETHODIMP	get_CodePage(long* codePage);
		STDMETHODIMP	put_CodePage(long codePage);
		STDMETHODIMP	get_Editor(ITextEditor** editor);
		STDMETHODIMP	get_EndPoint(ITextPoint** endPoint);
		STDMETHODIMP	get_FileName(BSTR* fileName);
		STDMETHODIMP	get_FilePath(BSTR* filePath);
		STDMETHODIMP	get_Line(long index, BSTR* line);
		STDMETHODIMP	get_LineBreak(LineBreak* lineBreak);
		STDMETHODIMP	put_LineBreak(LineBreak lineBreak);
		STDMETHODIMP	get_LineCount(long* count);
		STDMETHODIMP	get_Modified(VARIANT_BOOL* modified);
		STDMETHODIMP	put_Modified(VARIANT_BOOL modified);
		STDMETHODIMP	get_ReadOnly(VARIANT_BOOL* readOnly);
		STDMETHODIMP	put_ReadOnly(VARIANT_BOOL readOnly);
		STDMETHODIMP	get_StartPoint(ITextPoint** startPoint);
		STDMETHODIMP	Activate();
		STDMETHODIMP	Close();
		STDMETHODIMP	IsNarrowed(VARIANT_BOOL* narrowed);
		STDMETHODIMP	Narrow(long startLine, long startChar, long endLine, long endChar);
		STDMETHODIMP	Save(BSTR fileName, LineBreak lineBreak = Auto, long codePage = 0);
		STDMETHODIMP	Widen();
	private:
		friend class EditorPane;
		BufferList& parent_;
		AlphaDoc& impl_;
	};


	/// IEditorPanes ̎
	class EditorPanes : AmbientObjectBase(IEditorPanes) {
	public:
		// RXgN^
		EditorPanes(EditorWindow& impl);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEditorPanes)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IEditorPanes
		STDMETHODIMP	get__NewEnum(IUnknown** enumerator);
		STDMETHODIMP	get_ActivePane(IEditorPane** activePane);
		STDMETHODIMP	get_Count(long* count);
		STDMETHODIMP	ActivateNext();
		STDMETHODIMP	ActivatePrev();
		STDMETHODIMP	Item(long index, IEditorPane** pane);
		STDMETHODIMP	UnsplitAll();
	private:
		EditorWindow& impl_;
	};


	/// IEditorPane ̎
	class EditorPane : AmbientObjectBase(IEditorPane), public Disposable<Alpha::EditorPane> {
	public:
		// RXgN^
		EditorPane(EditorWindow& parent, Alpha::EditorPane& pane);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEditorPane)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IEditorPane
		STDMETHODIMP	get_Active(VARIANT_BOOL* active);
		STDMETHODIMP	get_Buffer(IBuffer** buffer);
		STDMETHODIMP	put_Buffer(IBuffer* buffer);
		STDMETHODIMP	get_Editor(ITextEditor** editor);
		STDMETHODIMP	get_Height(long* height);
		STDMETHODIMP	put_Height(long height);
		STDMETHODIMP	get_Width(long* width);
		STDMETHODIMP	put_Width(long width);
		STDMETHODIMP	Activate();
		STDMETHODIMP	Close();
		STDMETHODIMP	Split(VARIANT_BOOL ns);
	private:
		friend class Alpha::EditorPane;
		EditorWindow& parent_;
		Alpha::EditorPane& pane_;
	};


	/// ITextEditor ̎
	class TextEditor : AmbientObjectBase(ITextEditor), public Disposable<AlphaView> {
	public:
		// RXgN^
		TextEditor(AlphaApp& app, AlphaView& view);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ITextEditor)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// ITextEditor
		STDMETHODIMP	get_Buffer(IBuffer** buffer);
		STDMETHODIMP	get_ClipboardRing(IClipboardRing** clipboardRing);
		STDMETHODIMP	get_CollectingEdit(VARIANT_BOOL* collecting);
		STDMETHODIMP	get_Lexer(ILexer** lexer);
		STDMETHODIMP	get_OvertypeMode(VARIANT_BOOL* overtypeMode);
		STDMETHODIMP	put_OvertypeMode(VARIANT_BOOL overtypeMode);
		STDMETHODIMP	get_Preferences(IEditorPreferences** preferences);
		STDMETHODIMP	get_Selection(ITextSelection** selection);
		STDMETHODIMP	BackSpace();
		STDMETHODIMP	BeginEditCollection();
		STDMETHODIMP	BookmarkAll(BSTR pattern, ISearchOptions* options = 0, long* count = 0);
		STDMETHODIMP	ClearAllBookmarks();
		STDMETHODIMP	ClearUndoBuffer();
		STDMETHODIMP	CreateEditPoint(ITextPoint* sourcePoint, IEditPoint** newPoint);
		STDMETHODIMP	CreateSearchOptions(ISearchOptions** options);
		STDMETHODIMP	Delete();
		STDMETHODIMP	EndEditCollection();
		STDMETHODIMP	FindNext(BSTR pattern, ISearchOptions* options = 0, VARIANT_BOOL* found = 0);
		STDMETHODIMP	FindPrev(BSTR pattern, ISearchOptions* options = 0, VARIANT_BOOL* found = 0);
		STDMETHODIMP	Freeze();
		STDMETHODIMP	InputChar(VARIANT ch, VARIANT_BOOL* succeeded);
		STDMETHODIMP	NewLine();
		STDMETHODIMP	Paste();
		STDMETHODIMP	PasteFromClipboardRing();
		STDMETHODIMP	Redo();
		STDMETHODIMP	ReplaceAll(BSTR findWhat, BSTR replaceWith = 0, ISearchOptions* options = 0, long* count = 0);
		STDMETHODIMP	ReplaceAndNext(BSTR findWhat, BSTR replaceWith = 0, ISearchOptions* options = 0, VARIANT_BOOL* found = 0);
		STDMETHODIMP	ReplaceAndPrev(BSTR findWhat, BSTR replaceWith = 0, ISearchOptions* options = 0, VARIANT_BOOL* found = 0);
		STDMETHODIMP	Undo();
		STDMETHODIMP	Unfreeze();
	private:
		friend class AlphaView;
		AlphaApp& app_;
		AlphaView& view_;
	};


	/// ITextSelection ̎
	class TextSelection : AmbientObjectBase(ITextSelection), public Disposable<AlphaView> {
	public:
		// RXgN^
		TextSelection(AlphaView& view);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ITextSelection)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// ITextSelection
		STDMETHODIMP	get_ActiveEndGreater(VARIANT_BOOL* activeEndGreater);
		STDMETHODIMP	get_ActivePoint(ITextPoint** activePoint);
		STDMETHODIMP	get_AnchorPoint(ITextPoint** anchorPoint);
		STDMETHODIMP	get_BottomPoint(ITextPoint** bottomPoint);
		STDMETHODIMP	get_Empty(VARIANT_BOOL* empty);
		STDMETHODIMP	get_Text(BSTR* text);
		STDMETHODIMP	get_TextRanges(ITextRanges** ranges);
		STDMETHODIMP	get_TopPoint(ITextPoint** topPoint);
		STDMETHODIMP	Cancel();
		STDMETHODIMP	CharNext(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
		STDMETHODIMP	CharPrev(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
		STDMETHODIMP	Convert(ConvertType type);
		STDMETHODIMP	Copy(VARIANT_BOOL alsoSendToClipboardRing = VARIANT_TRUE);
		STDMETHODIMP	Cut(VARIANT_BOOL alsoSendToClipboardRing = VARIANT_TRUE);
		STDMETHODIMP	Indent();
		STDMETHODIMP	LineDown(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
		STDMETHODIMP	LineUp(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
		STDMETHODIMP	MoveTo(long line, long column, VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	MoveToEndOfDocument(VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	MoveToEndOfLine(VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	MoveToFirstCharOfLine(VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	MoveToLastCharOfLine(VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	MoveToMatchBracket(VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	MoveToNextBookmark(VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	MoveToPreviousBookmark(VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	MoveToStartOfDocument(VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	MoveToStartOfLine(VARIANT_BOOL toFirstText = VARIANT_FALSE, VARIANT_BOOL extend = VARIANT_FALSE);
		STDMETHODIMP	PageDown(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
		STDMETHODIMP	PageUp(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
		STDMETHODIMP	Paste();
		STDMETHODIMP	PasteFromClipboardRing();
		STDMETHODIMP	Replace(BSTR text);
		STDMETHODIMP	SelectAll();
		STDMETHODIMP	SelectLine(long line);
		STDMETHODIMP	SetBookmark(VARIANT_BOOL set = VARIANT_TRUE);
		STDMETHODIMP	SwapAnchor();
		STDMETHODIMP	Tabify();
		STDMETHODIMP	Unindent();
		STDMETHODIMP	Untabify();
		STDMETHODIMP	WordEndNext(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
		STDMETHODIMP	WordEndPrev(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
		STDMETHODIMP	WordNext(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
		STDMETHODIMP	WordPrev(VARIANT_BOOL extend = VARIANT_FALSE, long offset = 1);
	private:
		friend class AlphaView;
		AlphaView& view_;
	};


	/// ITextPoint  IEditPoint ̎
	class TextPoint : AmbientObjectBaseSupportIdentity(IEditPoint) {
	public:
		// RXgN^
		TextPoint(Ascension::VisualPoint& impl, bool editPoint);
		~TextPoint();
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEditPoint)
			IMPLEMENTS_INTERFACE(ITextPoint)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IObjectIdentity
		STDMETHODIMP	IsEqualObject(IUnknown* punk);
		// IDispatch
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);
		// ITextPoint
		STDMETHODIMP	get_AbsoluteCharOffset(long* pnAbsoluteCharOffset);
		STDMETHODIMP	get_AtEndOfDocument(VARIANT_BOOL* pbAtEndOfDocument);
		STDMETHODIMP	get_AtEndOfLine(VARIANT_BOOL* pbAtEndOfLine);
		STDMETHODIMP	get_AtFirstCharOfLine(VARIANT_BOOL* pbAtFirstCharOfLine);
		STDMETHODIMP	get_AtLastCharOfLine(VARIANT_BOOL* pbAtLastCharOfLine);
		STDMETHODIMP	get_AtStartOfDocument(VARIANT_BOOL* pbAtStartOfDocument);
		STDMETHODIMP	get_AtStartOfLine(VARIANT_BOOL* pbAtStartOfLine);
		STDMETHODIMP	get_Char(long* pnChar);
		STDMETHODIMP	get_Column(long* pnColumn);
		STDMETHODIMP	get_Line(long* pnLine);
		STDMETHODIMP	get_LineLength(long* pnLineLength);
		STDMETHODIMP	Center(VARIANT other, VARIANT_BOOL* pbInEditorRect);
		STDMETHODIMP	CreateEditPoint(IEditPoint** ppEditPoint);
		STDMETHODIMP	EqualTo(ITextPoint* pTextPoint, VARIANT_BOOL* pbEqual);
		STDMETHODIMP	GreaterThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbGreater);
		STDMETHODIMP	LessThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbLess);
		STDMETHODIMP	Reveal(VARIANT other, VARIANT_BOOL* pbInEditorRect);
		// IEditPoint
		STDMETHODIMP	get_CharCountConvention(CharCountConvention* convention);
		STDMETHODIMP	put_CharCountConvention(CharCountConvention convention);
		STDMETHODIMP	get_RestrictionExclusive(VARIANT_BOOL* exclusive);
		STDMETHODIMP	put_RestrictionExclusive(VARIANT_BOOL exclusive);
		STDMETHODIMP	CharNext(long offset = 1);
		STDMETHODIMP	CharPrev(long offset = 1);
		STDMETHODIMP	Convert(ConvertType type, VARIANT other);
		STDMETHODIMP	Copy(VARIANT other);
		STDMETHODIMP	Cut(VARIANT other);
		STDMETHODIMP	Delete(VARIANT other);
		STDMETHODIMP	DestructiveInsert(BSTR text);
		STDMETHODIMP	GetText(VARIANT other, BSTR* text);
		STDMETHODIMP	Indent(VARIANT other, short level = 1);
		STDMETHODIMP	Insert(BSTR text);
		STDMETHODIMP	LineDown(long offset = 1);
		STDMETHODIMP	LineUp(long offset = 1);
		STDMETHODIMP	MoveTo(long line, long column);
		STDMETHODIMP	MoveToAbsoluteOffset(long offset);
		STDMETHODIMP	MoveToEndOfDocument();
		STDMETHODIMP	MoveToEndOfLine();
		STDMETHODIMP	MoveToFirstCharOfLine();
		STDMETHODIMP	MoveToLastCharOfLine();
		STDMETHODIMP	MoveToNextBookmark();
		STDMETHODIMP	MoveToPreviousBookmark();
		STDMETHODIMP	MoveToStartOfDocument();
		STDMETHODIMP	MoveToStartOfLine();
		STDMETHODIMP	NewLine();
		STDMETHODIMP	PageDown(long offset = 1);
		STDMETHODIMP	PageUp(long offset = 1);
		STDMETHODIMP	Paste(VARIANT other);
		STDMETHODIMP	Replace(BSTR text, VARIANT other);
		STDMETHODIMP	SetBookmark(VARIANT_BOOL set = VARIANT_TRUE);
		STDMETHODIMP	TransposeChars();
		STDMETHODIMP	TransposeLines();
		STDMETHODIMP	TransposeParagraphs();
		STDMETHODIMP	TransposeWords();
		STDMETHODIMP	Unindent(VARIANT other, short level = 1);
		STDMETHODIMP	WordEndNext(long offset = 1);
		STDMETHODIMP	WordEndPrev(long offset = 1);
		STDMETHODIMP	WordNext(long offset = 1);
		STDMETHODIMP	WordPrev(long offset = 1);
	private:
		Ascension::EditView&	getTargetView() const;
	private:
		Ascension::VisualPoint& impl_;
		const bool isEditPoint_;
	};


	/// ITextRange ̎
	class TextRange : AmbientObjectBaseSupportIdentity(ITextRange) {
	public:
		// RXgN^
		TextRange(Ascension::EditPoint& pos1, Ascension::EditPoint& pos2);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ITextRange)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IObjectIdentity
		STDMETHODIMP	IsEqualObject(IUnknown* other);
		// ITextRange
		STDMETHODIMP	get_EndPoint(ITextPoint** endPoint);
		STDMETHODIMP	get_StartPoint(ITextPoint **startPoint);
	private:
		Ascension::EditPoint& pos1_;
		Ascension::EditPoint& pos2_;
	};


	/// ILexer ̎
	class Lexer : AmbientObjectBase(ILexer), public Disposable<AlphaView> {
	public:
		// RXgN^
		Lexer(Ascension::Lexer& impl);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ILexer)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// ILexer
		STDMETHODIMP	get_BackSolidusEscapeEnabled(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_BackSolidusEscapeEnabled(VARIANT_BOOL enabled);
		STDMETHODIMP	get_CaseSensitive(VARIANT_BOOL* caseSensitive);
		STDMETHODIMP	put_CaseSensitive(VARIANT_BOOL caseSensitive);
		STDMETHODIMP	get_Freezed(VARIANT_BOOL* freezed);
		STDMETHODIMP	put_Freezed(VARIANT_BOOL freeze);
		STDMETHODIMP	get_NumberFormat(NumberFormat* numberFormat);
		STDMETHODIMP	put_NumberFormat(NumberFormat numberFormat);
		STDMETHODIMP	get_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL* enabled);
		STDMETHODIMP	put_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL enabled);
		STDMETHODIMP	get_UnicodeAlphabetsEnabled(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_UnicodeAlphabetsEnabled(VARIANT_BOOL enabled);
		STDMETHODIMP	get_UnicodeWhiteSpacesEnabled(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_UnicodeWhiteSpacesEnabled(VARIANT_BOOL enabled);
		STDMETHODIMP	AddKeywords(BSTR keywords, long* identifier);
		STDMETHODIMP	AddMultilineAnnotation(BSTR startDelimiter, BSTR endDelimiter, AnnotationConstraint constraint, long* identifier);
		STDMETHODIMP	AddSinglelineAnnotation(BSTR startDelimiter, BSTR endDelimiter, AnnotationConstraint constraint, long* identifier);
		STDMETHODIMP	RemoveAll();
		STDMETHODIMP	RemoveIdentifiedToken(long identifier);
		STDMETHODIMP	SetAdditionalAlphabets(BSTR alphabets);
		STDMETHODIMP	SetBrackets(BSTR openers);
		STDMETHODIMP	SetOperators(BSTR operators);
	private:
		friend class AlphaView;
		Ascension::Lexer& impl_;
	};


	/// IEditorPreferences ̎
	class EditorPreferences : AmbientObjectBase(IEditorPreferences), public Disposable<AlphaView> {
	public:
		// RXgN^
		EditorPreferences(Ascension::EditView& view);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEditorPreferences)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IEditorPreferences
		STDMETHODIMP	get_CharSpan(short* charSpan);
		STDMETHODIMP	put_CharSpan(short charSpan);
		STDMETHODIMP	get_CheckInputSequence(BSTR language, VARIANT_BOOL* enabled);
		STDMETHODIMP	put_CheckInputSequence(BSTR language, VARIANT_BOOL enabled);
		STDMETHODIMP	get_CloseBoldChars(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_CloseBoldChars(VARIANT_BOOL enabled);
		STDMETHODIMP	get_EndOfFileLabel(BSTR* endOfFileLabel);
		STDMETHODIMP	put_EndOfFileLabel(BSTR endOfFileLabel);
		STDMETHODIMP	get_GeneralWhiteSpaceSubstitutionChar(long* glyph);
		STDMETHODIMP	put_GeneralWhiteSpaceSubstitutionChar(long glyph);
		STDMETHODIMP	get_HorizontalTabSubstitutionChar(long* glyph);
		STDMETHODIMP	put_HorizontalTabSubstitutionChar(long glyph);
		STDMETHODIMP	get_IdeographicSpaceSubstitutionChar(long* glyph);
		STDMETHODIMP	put_IdeographicSpaceSubstitutionChar(long glyph);
		STDMETHODIMP	get_LeadMargin(short* leadMargin);
		STDMETHODIMP	put_LeadMargin(short leadMargin);
		STDMETHODIMP	get_LexicalParsingEnabled(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_LexicalParsingEnabled(VARIANT_BOOL enabled);
		STDMETHODIMP	get_LineBreakSubstitutionChar(::LineBreak lineBreak, long* glyph);
		STDMETHODIMP	put_LineBreakSubstitutionChar(::LineBreak lineBreak, long glyph);
		STDMETHODIMP	get_LineNumberBorderStyle(BorderType* style);
		STDMETHODIMP	put_LineNumberBorderStyle(BorderType style);
		STDMETHODIMP	get_LineNumberBorderWidth(short* width);
		STDMETHODIMP	put_LineNumberBorderWidth(short width);
		STDMETHODIMP	get_LineSpan(short* lineSpan);
		STDMETHODIMP	put_LineSpan(short lineSpan);
		STDMETHODIMP	get_MatchBracketScanLines(long* lines);
		STDMETHODIMP	put_MatchBracketScanLines(long lines);
		STDMETHODIMP	get_PerformBidirection(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_PerformBidirection(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ResetDirectionByTokens(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ResetDirectionByTokens(VARIANT_BOOL enabled);
		STDMETHODIMP	get_RightToLeftReading(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_RightToLeftReading(VARIANT_BOOL enabled);
		STDMETHODIMP	get_SelectEndOfLine(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_SelectEndOfLine(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ShowBidirectionalFormatters(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ShowBidirectionalFormatters(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ShowCurrentUnderline(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ShowCurrentUnderline(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ShowEndOfFile(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ShowEndOfFile(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ShowEndOfLine(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ShowEndOfLine(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ShowHandOnLink(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ShowHandOnLink(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ShowHintOnLink(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ShowHintOnLink(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ShowIndicatorMargin(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ShowIndicatorMargin(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ShowLineNumber(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ShowLineNumber(VARIANT_BOOL enabled);
		STDMETHODIMP	get_ShowWhiteSpaceAlternative(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ShowWhiteSpaceAlternative(VARIANT_BOOL enabled);
		STDMETHODIMP	get_StartCharNumber(long* startCharNumber);
		STDMETHODIMP	put_StartCharNumber(long startCharNumber);
		STDMETHODIMP	get_StartLineNumber(long* startLineNumber);
		STDMETHODIMP	put_StartLineNumber(long startLineNumber);
		STDMETHODIMP	get_TabWidth(short* tabWidth);
		STDMETHODIMP	put_TabWidth(short tabWidth);
		STDMETHODIMP	get_ThinCaret(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_ThinCaret(VARIANT_BOOL enabled);
		STDMETHODIMP	get_TokenDecoration(BSTR tokenTypeName, ITokenDecoration** tokenDecoration);
		STDMETHODIMP	get_TopMargin(short* topMargin);
		STDMETHODIMP	put_TopMargin(short topMargin);
		STDMETHODIMP	get_UseEditorFontForCompletion(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_UseEditorFontForCompletion(VARIANT_BOOL enabled);
		STDMETHODIMP	get_WrapMode(WrapMode* wrapMode);
		STDMETHODIMP	put_WrapMode(WrapMode wrapMode);
		STDMETHODIMP	get_WrapWidth(short* wrapWidth);
		STDMETHODIMP	put_WrapWidth(short wrapWidth);
		STDMETHODIMP	Reset();
	private:
		friend class AlphaView;
		Ascension::EditView& view_;
	};


	/// ITokenDecoration ̎
	class TokenDecoration : AmbientObjectBase(ITokenDecoration) {
	public:
		// RXgN^
		TokenDecoration(Ascension::EditView& view, int tokenType, Ascension::Token::Cookie tokenCookie = Ascension::Token::NULL_COOKIE);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ITokenDecoration)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// ITokenDecoration
		STDMETHODIMP	get_Color(long* color);
		STDMETHODIMP	put_Color(long color);
		STDMETHODIMP	get_BackgroundColor(long* color);
		STDMETHODIMP	put_BackgroundColor(long color);
		STDMETHODIMP	get_BoldFont(VARIANT_BOOL* bold);
		STDMETHODIMP	put_BoldFont(VARIANT_BOOL bold);
		STDMETHODIMP	get_ItalicFont(VARIANT_BOOL* italic);
		STDMETHODIMP	put_ItalicFont(VARIANT_BOOL italic);
		STDMETHODIMP	get_BorderStyle(BorderType* borderType);
		STDMETHODIMP	put_BorderStyle(BorderType borderType);
		STDMETHODIMP	get_BorderColor(long* color);
		STDMETHODIMP	put_BorderColor(long color);
	private:
		Ascension::EditView& view_;
		int tokenType_;
		Ascension::Token::Cookie tokenCookie_;
	};


	/// ISearchOptions ̎
	class SearchOptions : AmbientObjectBase(ISearchOptions) {
	public:
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ISearchOptions)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// ISearchOptions
		STDMETHODIMP	get_CaseSensitivity(CaseFoldingType* sensitivity);
		STDMETHODIMP	put_CaseSensitivity(CaseFoldingType sensitivity);
		STDMETHODIMP	get_CharacterSkipOption(CharacterSkipType* options);
		STDMETHODIMP	put_CharacterSkipOption(CharacterSkipType options);
		STDMETHODIMP	get_FoldingOption(FoldingType* options);
		STDMETHODIMP	put_FoldingOption(FoldingType options);
		STDMETHODIMP	get_MultigraphExpansionOption(MultigraphExpansionType* options);
		STDMETHODIMP	put_MultigraphExpansionOption(MultigraphExpansionType options);
		STDMETHODIMP	get_OnlyIdentifiers(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_OnlyIdentifiers(VARIANT_BOOL enabled);
		STDMETHODIMP	get_SearchType(SearchType* type);
		STDMETHODIMP	put_SearchType(SearchType type);
		STDMETHODIMP	get_WholeWord(VARIANT_BOOL* enabled);
		STDMETHODIMP	put_WholeWord(VARIANT_BOOL enabled);
	private:
		Ascension::TextSearcher::Options options_;
	};


	/// IConfigurations ̎
	class Configurations : AmbientObjectBase(IConfigurations) {
	public:
		// RXgN^
		Configurations(AlphaApp& app);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IConfigurations)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IConfigurations
		STDMETHODIMP	get__NewEnum(IUnknown** enumerator);
		STDMETHODIMP	get_KeyboardSchemes(BSTR scopeName, IKeyboardScheme** keyboardScheme);
		STDMETHODIMP	get_Property(BSTR name, BSTR* value);
		STDMETHODIMP	put_Property(BSTR name, BSTR value);
		STDMETHODIMP	AddDocumentType(BSTR name, BSTR fileSpec, BSTR command = 0, VARIANT_BOOL hiddenType = VARIANT_FALSE);
		STDMETHODIMP	Apply();
		STDMETHODIMP	RemoveAllDocumentTypes();
	private:
		AlphaApp& app_;
		std::map<std::wstring, std::wstring> modifiedProperties_;	// ύXꂽvpeB
	};


	/// IKeyboardScheme ̎
	class KeyboardScheme : AmbientObjectBase(IKeyboardScheme) {
	public:
		// RXgN^
		KeyboardScheme(KeyboardMap& impl);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IKeyboardScheme)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IKeyboardScheme
		STDMETHODIMP	get_Name(BSTR* name);
		STDMETHODIMP	Assign(BSTR keyCombination, VARIANT command, VARIANT_BOOL* overridden);
		STDMETHODIMP	Load(BSTR schemeName);
		STDMETHODIMP	Save(BSTR schemeName);
		STDMETHODIMP	Unassign(BSTR keyCombination);
	private:
		static bool	parseKeyCombinationString(const BSTR keyCombination, KeyCombination& firstKeys, KeyCombination& secondKeys);
	private:
		KeyboardMap& impl_;
		std::wstring schemeName_;
		static std::map<std::wstring, VirtualKey> keyValues_;
		friend class Configurations;
	};


	/// ICommand ̎
	class Command : AmbientObjectBaseSupportIdentity(ICommand) {
	public:
		// RXgN^
		Command(AlphaApp& app, CommandID id);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ICommand)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IObjectIdentity
		STDMETHODIMP	IsEqualObject(IUnknown* other);
		// ICommand
		STDMETHODIMP	get_Checked(VARIANT_BOOL* checked);
		STDMETHODIMP	get_Description(BSTR* description);
		STDMETHODIMP	get_Enabled(VARIANT_BOOL* enabled);
		STDMETHODIMP	get_Id(long* identifier);
		STDMETHODIMP	get_KeyCombination(BSTR* keys);
		STDMETHODIMP	get_Name(BSTR* name);
		STDMETHODIMP	Execute();
	private:
		AlphaApp& app_;
		const CommandID id_;
	};


	/// IClipboardRing ̎
	class ClipboardRing : AmbientObjectBaseSupportIdentity(IClipboardRing) {
	public:
		// RXgN^
		ClipboardRing(Ascension::ClipboardRing& impl);
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IClipboardRing)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IObjectIdentity
		STDMETHODIMP	IsEqualObject(IUnknown* other);
		// IClipboardRing
		STDMETHODIMP	get_Count(short* count);
		STDMETHODIMP	get_Text(short index, BSTR* text);
		STDMETHODIMP	Add(BSTR text);
		STDMETHODIMP	Delete(short index);
		STDMETHODIMP	DeleteAll();
		STDMETHODIMP	LimitCount(short limit);
	private:
		Ascension::ClipboardRing& impl_;
	};


	/// IAbbreviations ̎
	class Abbreviations : AmbientObjectBaseSupportIdentity(IAbbreviations) {
	public:
		// RXgN^
		Abbreviations() :
			Armaiti::IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>(INTERFACESAFE_FOR_UNTRUSTED_CALLER) {}
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IAbbreviations)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IObjectIdentity
		STDMETHODIMP	IsEqualObject(IUnknown* other);
		// IAbbreviations
		STDMETHODIMP	get__NewEnum(IUnknown** enumerator);
		STDMETHODIMP	Expand(BSTR abbreviation, BSTR* expanded);
		STDMETHODIMP	Register(BSTR abbreviation, BSTR expanded);
		STDMETHODIMP	Revoke(BSTR abbreviation);
		STDMETHODIMP	RevokeAll();
	};


	/// IScriptHost ̎
	class ScriptHost : AmbientObjectBaseSupportError(IScriptHost) {
	public:
		// RXgN^
		ScriptHost(AlphaScriptHost& impl);
		~ScriptHost();
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IScriptHost)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IScriptHost
		STDMETHODIMP	ConnectObject(IDispatch* sourceObject, BSTR prefix);
		STDMETHODIMP	CreateObject(BSTR progID, BSTR prefix, IDispatch** newObject);
		STDMETHODIMP	DisconnectObject(IDispatch* sourceObject);
		STDMETHODIMP	Echo(SAFEARRAY/*<VARIANT>*/* arguments);
		STDMETHODIMP	get_Arguments(IArguments** arguments);
		STDMETHODIMP	get_BuildVersion(short* buildVersion);
		STDMETHODIMP	get_FullName(BSTR* fullName);
		STDMETHODIMP	get_Interactive(VARIANT_BOOL* interactive);
		STDMETHODIMP	get_Name(BSTR* name);
		STDMETHODIMP	get_Path(BSTR* path);
		STDMETHODIMP	get_ScriptFullName(BSTR* scriptFullName);
		STDMETHODIMP	get_ScriptName(BSTR* scriptName);
		STDMETHODIMP	get_StdErr(IDispatch** stdErr);
		STDMETHODIMP	get_StdIn(IDispatch** stdIn);
		STDMETHODIMP	get_StdOut(IDispatch** stdOut);
		STDMETHODIMP	get_Timeout(long* timeout);
		STDMETHODIMP	get_Version(BSTR* versionString);
		STDMETHODIMP	put_Interactive(VARIANT_BOOL interactive);
		STDMETHODIMP	GetObject(BSTR pathName, BSTR progID, BSTR prefix, IDispatch** newObject);
		STDMETHODIMP	LoadConstants(IDispatch* sourceObject);
		STDMETHODIMP	Sleep(long milliseconds);
		STDMETHODIMP	Quit(short exitCode = 0);
	private:
		DWORD	verifyCreationObject(CLSID& clsid);
		DWORD	verifyRunningObject(IUnknown& object, CLSID& clsid);
	private:
		AlphaScriptHost* impl_;
	};


	/// IArguments ̎
	class Arguments : AmbientObjectBase(IArguments) {
	public:
		// RXgN^
		Arguments(const std::vector<std::wstring>& args);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IArguments)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// IArguments
		STDMETHODIMP	get__NewEnum(IUnknown** enumerator);
		STDMETHODIMP	get_Item(long index, BSTR* argument);
		STDMETHODIMP	get_Length(long* count);
		STDMETHODIMP	get_Named(IDispatch** named);
		STDMETHODIMP	get_Unnamed(IDispatch** unnamed);
		STDMETHODIMP	Count(long* count);
		STDMETHODIMP	ShowUsage();
	private:
		std::vector<std::wstring> arguments_;
	};


	/// INamedArguments ̎
	class NamedArguments : AmbientObjectBase(INamedArguments) {
	public:
		// RXgN^
		NamedArguments(const std::map<std::wstring, std::wstring>& namedArguments);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(INamedArguments)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// INamedArguments
		STDMETHODIMP	get__NewEnum(IUnknown** enumerator);
		STDMETHODIMP	get_Item(BSTR name, BSTR *argument);
		STDMETHODIMP	get_Length(long* count);
		STDMETHODIMP	Count(long* count);
		STDMETHODIMP	Exists(BSTR name, VARIANT_BOOL* exists);
	private:
		std::map<std::wstring, std::wstring> namedArguments_;
	};


	/// IUnnamedArguments ̎
	class UnnamedArguments : AmbientObjectBase(IUnnamedArguments) {
	public:
		// RXgN^
		UnnamedArguments(const std::vector<std::wstring>& unnamedArguments);
		// IUnknown
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IUnnamedArguments)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()
		// INamedArguments
		STDMETHODIMP	get__NewEnum(IUnknown** enumerator);
		STDMETHODIMP	get_Item(long index, BSTR* argument);
		STDMETHODIMP	get_Length(long* count);
		STDMETHODIMP	Count(long* count);
	private:
		std::vector<std::wstring> unnamedArguments_;
	};

} /* namespace Ambient */
} /* namespace Alpha */

#pragma warning(default : 4250)
#endif /* AMBIENT_H_ */

/* [EOF] */