// AscensionCommon.h
// (c) 2004-2006 exeal

#ifndef ASCENSION_COMMON_H_
#define ASCENSION_COMMON_H_

/// ǐՒ Unicode ̃o[W
#define ASCENSION_UNICODE_VERSION	0x0410	// 4.1.0

#include "Config.h"
#include <string>
#include <sstream>
#include "../../Manah/Memory.hpp"

#ifdef _DEBUG
#include "../../Manah/Timer.hpp"
using Manah::Windows::dout;
using Manah::Windows::Timer;
template<class T> void alert(const T& t) {
	std::wostringstream	ss;
	ss << t;
	::MessageBoxW(0, ss.str().c_str(), L"alert", MB_OK);
}
#endif /* _DEBUG */

namespace Ascension {

	/// Ascension::Private OԂ Ascension ̃NCAgڐڐGȂ̂`
	namespace Private {
		/// ^ signed ɂ邾
		template<class T> class ToSigned {
		private:
			template<class U> struct X;
			template<> struct X<unsigned char> {typedef char Result;};
			template<> struct X<unsigned short> {typedef short Result;};
			template<> struct X<unsigned int> {typedef int Result;};
			template<> struct X<unsigned long> {typedef long Result;};
			template<> struct X<unsigned __int64> {typedef __int64 Result;};
		public:
			typedef typename X<T>::Result Result;
		};
	} // namespace Private

	// ^`BWin32 API  wchar_t ł͂Ȃ WCHAR gƂB
	// Ƃ͂ۂɂ wcs*** ĝ WCHAR == wchar_t łȂƍ̂
	// (X OLECHAR == wchar_t łȂƂ܂)
	typedef WCHAR											char_t;				///< ^
	typedef std::basic_string<char_t>						string_t;			///< ^ (ۂ @c std::wstring)
	typedef string_t::size_type								length_t;			///< ̒Aʒu\
	typedef Private::ToSigned<length_t>::Result				signed_length_t;	///< length_t ̕t
	typedef std::basic_stringstream<string_t::value_type>	stringstream_t;		///< Xg[^ (ۂ @c std::wstringstream)
	typedef std::basic_istringstream<string_t::value_type>	istringstream_t;	///< ̓Xg[^ (ۂ @c std::wistringstream)
	typedef std::basic_ostringstream<string_t::value_type>	ostringstream_t;	///< o̓Xg[^ (ۂ @c std::wostringstream)

	// O錾
	class EditDoc;
	class EditView;

	/// sƕʒui[
	/// @see SynchronizablePoint, EditPoint, VisualPoint, Caret
	class CharPos : public Manah::UseMemoryPool<CharPos> {
	public:
		length_t line_;	///< s
		length_t char_;	///< ʒu
		static const CharPos INVALID_POSITION;	///< AsȈʒu
	public:
		/// RXgN^
		explicit CharPos(length_t lineNumber = 0, length_t charNumber = 0) throw() : line_(lineNumber), char_(charNumber) {}
	};

	// CharPos ̔rZq
	inline bool operator ==(const CharPos& lhs, const CharPos& rhs) throw()
	{return lhs.line_ == rhs.line_ && lhs.char_ == rhs.char_;}
	inline bool operator !=(const CharPos& lhs, const CharPos& rhs) throw()
	{return lhs.line_ != rhs.line_ || lhs.char_ != rhs.char_;}
	inline bool operator <(const CharPos& lhs, const CharPos& rhs) throw()
	{return lhs.line_ < rhs.line_ || (lhs.line_ == rhs.line_ && lhs.char_ < rhs.char_);}
	inline bool operator <=(const CharPos& lhs, const CharPos& rhs) throw()
	{return lhs < rhs || lhs == rhs;}
	inline bool operator >(const CharPos& lhs, const CharPos& rhs) throw()
	{return lhs.line_ > rhs.line_ || (lhs.line_ == rhs.line_ && lhs.char_ > rhs.char_);}
	inline bool operator >=(const CharPos& lhs, const CharPos& rhs) throw()
	{return lhs > rhs || lhs == rhs;}

	/// 2_ō\͈
	class TextRange : public Manah::UseMemoryPool<TextRange> {
	public:
		CharPos	pos1_, pos2_;	///< 2_
	public:
		/// RXgN^
		TextRange() throw() {}
		/// RXgN^
		TextRange(const CharPos& pos1, const CharPos& pos2) throw() : pos1_(pos1), pos2_(pos2) {}
		/// Zq
		bool operator ==(const TextRange& rhs) const throw() {
			return (pos1_ == rhs.pos1_ && pos2_ == rhs.pos2_) || (pos1_ == rhs.pos2_ && pos2_ == rhs.pos1_);}
		/// 񓙉Zq
		bool operator !=(const TextRange& rhs) const throw() {return !(*this == rhs);}
		/// Ԃ
		CharPos& getTop() const throw() {return const_cast<CharPos&>(std::min(pos1_, pos2_));}
		/// 傫Ԃ
		CharPos& getBottom() const throw() {return const_cast<CharPos&>(std::max(pos1_, pos2_));}
		/// ͈͂
		bool isEmpty() const throw() {return pos1_ == pos2_;}
	};

	/**
	 *	@brief  UI Ԃ
	 *
	 *	Win2000 ȍ~ (Me ) łgȂ @c GetUserDefaultUILanguage API ̃bp
	 */
	LANGID getUserDefaultUILanguage() throw();
	
	namespace Private {
		/// Nbv{[h
		class Clipboard : public Manah::Noncopyable {
		public:
			class Text : public Manah::Unassignable {
			public:
				Text(HGLOBAL handle, const char_t* text) throw() : handle_(handle), text_(text) {}
				Text(const Text& rhs) throw() : handle_(rhs.handle_), text_(rhs.text_) {const_cast<Text&>(rhs).handle_ = 0;}
				~Text() throw() {if(handle_ != 0) ::GlobalUnlock(handle_);}
				const char_t* getData() const throw() {return text_;}
				length_t getRawSize() const throw() {return (handle_ != 0) ? ::GlobalSize(handle_) : 0;}
				operator bool() const throw() {return handle_ != 0 && text_ != 0;}
			private:
				HGLOBAL handle_;
				const char_t* const text_;
			};
			Clipboard(HWND window) throw() : opened_(toBoolean(::OpenClipboard(window))) {}
			~Clipboard() throw() {if(opened_) ::CloseClipboard();}
			bool isOpen() const throw() {return opened_;}
			Text read() throw();
			void write(const char_t* first, const char_t* last, bool asRectangle = false) throw();
			void write(const string_t& s, bool asRectangle = false) throw() {write(s.data(), s.data() + s.length(), asRectangle);}
		private:
			bool opened_;
		};

		/// () ̐ΒlԂ
		template<class T> inline std::size_t dif(T i0, T i1) {return (i0 > i1) ? i0 - i1 : i1 - i0;}
	} // namespace Private

} // namespace Ascension

#endif /* ASCENSION_COMMON_H_ */

/* [EOF] */