// CompletionWindow.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "CompletionWindow.h"
#include "EditView.h"	// EditView
#include "EditPoint.h"

using namespace Ascension;
using namespace std;

namespace {
	const length_t COMPLETION_MAX_TRACKBACK_CCH = 100;
}


/// RXgN^
CompletionWindow::CompletionWindow(EditView& view) :
	view_(view), defaultFont_(0), running_(false), contextEnd_(*view.getDocument().createEditPoint().release()) {}

/// fXgN^
CompletionWindow::~CompletionWindow() {
	delete &contextEnd_;
}

/// ⊮𒆎~
void CompletionWindow::abort() {
	assertValid();
	if(isRunning()) {
		running_ = false;
		contextEnd_.synchronizeWithDocumentUpdate(false);
		showWindow(SW_HIDE);
	}
}

/// ⊮ (SɈv₪ꍇ͒~)
void CompletionWindow::complete() {
	assertValid();

	const int sel = getCurSel();

	if(sel != LB_ERR) {
		EditDoc&		document = view_.getDocument();
		Selection&		selection = view_.getSelection();
		const length_t	len = getTextLen(sel);
		char_t*			text = new char_t[len + 1];

		if(!selection.isEmpty())
			selection.moveTo(selection.getActivePoint(), false);

		const string_t precWord = view_.getPrecedingWord(COMPLETION_MAX_TRACKBACK_CCH);

		getText(sel, text);
		view_.freeze();
		document.beginEditCollection();
		document.deleteText(CharPos(
			selection.getActivePoint().getLineNumber(), selection.getActivePoint().getCharNumber() - precWord.length()),
			selection.getActivePoint());
		selection.moveTo(document.insertText(selection.getActivePoint(), text, text + len), true);
		document.endEditCollection();
		view_.unfreeze();

		delete[] text;
	}
	abort();
}

/**
 *	EBhE쐬
 *	@return	
 */
bool CompletionWindow::create() {
	assertValid();

	using namespace Manah::Windows::Controls;

	if(ListBox::create(view_, DefaultWindowRect(), 0, 0,
			WS_CHILD | WS_TABSTOP | WS_VSCROLL | LBS_NOINTEGRALHEIGHT | LBS_NOTIFY | LBS_SORT,
			WS_EX_CLIENTEDGE | WS_EX_NOPARENTNOTIFY | WS_EX_TOOLWINDOW)
			&& subclassWindow()) {
		updateDefaultFont();
		setWindowPos(HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);

#if 0
		// etĂ݂肷...
#ifndef CS_DROPSHADOW
		const ULONG_PTR CS_DROPSHADOW = 0x00020000;
#endif /* !CS_DROPSHADOW */
		const ULONG_PTR styleBits = ::GetClassLongPtrW(getHandle(), GCL_STYLE);
		::SetClassLongPtrW(getHandle(), GCL_STYLE, styleBits | CS_DROPSHADOW);
#endif
		return true;
	}
	return false;
}

/// @see ListBox::dispatchEvent
LRESULT CompletionWindow::dispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_DESTROY:
		::DeleteObject(defaultFont_);
		break;
	case WM_KILLFOCUS:
		abort();
		break;
	case WM_LBUTTONDBLCLK:	// _uNbNł⊮
		complete();
		return true;
	case WM_LBUTTONDOWN: {	// ŎȂȂ̂
			POINT		pt = {LOWORD(lParam), HIWORD(lParam)};
			bool		outside;
			const int	sel = itemFromPoint(pt, outside);
			if(!outside)
				setCurSel(sel);
		}
		return true;
	case WM_SETTINGCHANGE:
		updateDefaultFont();
		break;
	case WM_SHOWWINDOW:
		if(!wParam)
			resetContent();
		break;
	}

	return ListBox::dispatchEvent(message, wParam, lParam);
}

/**
 *	tHg̐ݒ
 *	@param font	tHgBnull Ɗ̃tHg
 */
void CompletionWindow::setFont(const HFONT font) {
	assertValidAsWindow();
	ListBox::setFont((font != 0) ? font : defaultFont_);
}

/**
 *	@brief	⊮Jn
 *
 *	̃\bh̓EBhE̕\ʒu߂sȂ
 *	@param candidateWords	⃊Xg
 */
void CompletionWindow::start(const set<string_t>& candidateWords) {
	assertValidAsWindow();

//	const bool rightToLeft = toBoolean(view_.getStyleEx() & WS_EX_RTLREADING);
	const bool rightToLeft = view_.isTextDirectionRightToLeft();

	resetContent();
	modifyStyleEx(rightToLeft ? WS_EX_LTRREADING : WS_EX_RTLREADING, rightToLeft ? WS_EX_RTLREADING : WS_EX_LTRREADING);
	for(set<string_t>::const_iterator it = candidateWords.begin(); it != candidateWords.end(); ++it) {
		if(!it->empty())
			addString(it->c_str());
	}

	Selection&			selection = view_.getSelection();
	const VisualPoint&	caret = selection.getActivePoint();
	const string_t&		line = view_.getDocument().getLine(caret.getLineNumber());

	selection.moveTo(caret, true);
	contextStart_.line_ = caret.getLineNumber();
	contextStart_.char_ = caret.getCharNumber() - view_.getPrecedingWord(COMPLETION_MAX_TRACKBACK_CCH).length();
	contextEnd_.moveTo(caret);
	if(view_.getLexer().isIdentifierContinueCodePoint(contextEnd_.getCodePoint()))
		contextEnd_.wordEndNext();
	contextEnd_.synchronizeWithDocumentUpdate(true);
	running_ = true;
}

/// tHg̍XV
void CompletionWindow::updateDefaultFont() {
	AutoZeroCB<NONCLIENTMETRICSW> ncm;
	::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, &ncm, 0);
	HFONT newFont = ::CreateFontIndirectW(&ncm.lfStatusFont);
	if(defaultFont_ != 0 && isWindow() && getFont() == defaultFont_) {
		HFONT oldFont = getFont();
		ListBox::setFont(newFont);
		::DeleteObject(oldFont);
	} else
		ListBox::setFont(newFont);
	defaultFont_ = newFont;
}

/**
 *	r[̏󋵂ɍ킹ăXg̑IXV
 *	@return					₪ɍiꂽꍇ true
 *	@throw std::logic_error	⊮łȂꍇX[
 */
bool CompletionWindow::updateListCursel() {
	assertValidAsWindow();

	if(!isRunning())
		throw std::logic_error("Completion is not running.");

	const string_t precWord = view_.getPrecedingWord(COMPLETION_MAX_TRACKBACK_CCH);

	if(!precWord.empty()) {
		const int found = findString(-1, precWord.c_str());
		setCurSel((found != LB_ERR) ? found : -1);
		if(found != LB_ERR) {
			if(found != 0)	// ̂܂܂Ə񂾂IڂsɂȂ݂
				setCurSel(found - 1);
			setCurSel(found);
			if(found != getCount() - 1) {
				const size_t comparisonLength = min<size_t>(precWord.length(), getTextLen(found + 1));
				wchar_t* prevWord = CharacterFolder::foldCase(precWord.data(), precWord.data() + comparisonLength);
				wchar_t* nextCand = new wchar_t[getTextLen(found + 1) + 1];

				getText(found + 1, nextCand);
				CharacterFolder::foldCase(nextCand, nextCand + comparisonLength);
				const bool unique = wcsncmp(prevWord, nextCand, comparisonLength) != 0;

				delete[] prevWord;
				delete[] nextCand;
				return unique;
			}
		}
	} else
		setCurSel(-1);
	return false;
}

/* [EOF] */