// CompletionWindow.h
// (c) 2003-2006 exeal

#ifndef COMPLETION_WINDOW_H_
#define COMPLETION_WINDOW_H_
#include "AscensionCommon.h"
#include "EditPoint.h"
#include "../../Manah/StandardControls.hpp"	// ListBox
#include <set>


namespace Ascension {
	class EditView;
	class SynchronizablePoint;

	/// ͕⊮EBhE
	class CompletionWindow : public Manah::Windows::Controls::ListBox {
		// RXgN^
	public:
		CompletionWindow(EditView& view);
		virtual ~CompletionWindow();

		// \bh
	public:
		void		abort();
		void		complete();
		bool		create();
		TextRange	getContextRange() const;
		bool		isRunning() const;
		void		setFont(const HFONT hFont);
		void		start(const std::set<string_t>& candidateWords);
		bool		updateListCursel();

		// bZ[Wnh
	protected:
		virtual LRESULT	dispatchEvent(UINT message, WPARAM wParam, LPARAM lParam);

	private:
		void	updateDefaultFont();

		// f[^o
	protected:
		EditView& view_;
	private:
		HFONT			defaultFont_;
		bool			running_;
		CharPos			contextStart_;	// ⊮JnʒȗO̒P擪
		VisualPoint&	contextEnd_;	// ⊮Jnʒǔ̒PI[
	};


	/// ⊮͈͂Ԃ (Lbg͈̔͂Oƕ⊮͒~)
	/// @throw std::logic_error	͕⊮łȂ΃X[
	inline TextRange CompletionWindow::getContextRange() const {
		assertValid();
		if(!isRunning())
			throw std::logic_error("Completion is not running.");
		return TextRange(contextStart_, contextEnd_);
	}

	/// ⊮ł邩Ԃ
	inline bool CompletionWindow::isRunning() const {assertValid(); return running_;}

} // namespace Ascension

#endif /* COMPLETION_WINDOW_H_ */

/* [EOF] */