// EditDoc.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "EditDoc.h"
#include <shellapi.h>	// PathFileExists
#include <shlwapi.h>	// SHFileOperation
#include <MAPI.h>		// MAPISendMail
#include "../../Manah/WaitCursor.hpp"
#include "../../Armaiti/ComBasic.hpp"
#include <algorithm>

using namespace Ascension;
using namespace Ascension::Encodings;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Windows::IO;
using namespace Armaiti;
using namespace std;


namespace {
	class InsertOperation;
	class DeleteOperation;
}

namespace Ascension { namespace Private {
	/**
	 *	炩̕ҏW
	 *	@see DeleteOperation, InsertOperation
	 */
	class IOperation {
	public:
		/// fXgN^
		virtual ~IOperation() {}
		/// 삪s\Ԃ
		virtual bool canExecute(EditDoc& document) const = 0;
		///  @a postOperation Ɍł邩Ԃ (㑱̑͑})
		virtual bool isConcatenatable(InsertOperation& postOperation, const EditDoc& document) const = 0;
		///  @a postOperation Ɍł邩Ԃ (㑱͍̑폜)
		virtual bool isConcatenatable(DeleteOperation& postOperation, const EditDoc& document) const = 0;
		/// s
		virtual CharPos execute(EditDoc& document) = 0;
	};
} } // namespace Ascension::Private

namespace {
	/// 1̑}
	class InsertOperation : virtual public Private::IOperation, public SelfAssertable, public UseMemoryPool<InsertOperation> {
		// RXgN^
	public:
		InsertOperation(const CharPos& pos, const string_t& strText);

		// \bh
	public:
		bool	canExecute(EditDoc& document) const throw();
		bool	isConcatenatable(InsertOperation& postOperation, const EditDoc& document) const throw();
		bool	isConcatenatable(DeleteOperation& postOperation, const EditDoc& document) const throw();
		CharPos	execute(EditDoc& document);

		// f[^o
	private:
		CharPos position_;	// }ʒu
		string_t text_;		// }
	};

	/// 1̍폜
	class DeleteOperation : virtual public Private::IOperation, public SelfAssertable, public UseMemoryPool<DeleteOperation> {
	public:
		DeleteOperation(const TextRange& range) throw();
		bool	canExecute(EditDoc& document) const throw();
		bool	isConcatenatable(InsertOperation& postOperation, const EditDoc& document) const throw();
		bool	isConcatenatable(DeleteOperation& postOperation, const EditDoc& document) const throw();
		CharPos	execute(EditDoc& document);
	private:
		TextRange range_;
	};

	///
	class UnconvertableCharCallback : virtual public IUnconvertableCharCallback {
	public:
		UnconvertableCharCallback(IUnconvertableCharCallback* impl) : callback_(impl), calledOnce_(false) {
			assert(impl != 0);
		}
		bool onFoundUnconvertableCharacter() {
			calledOnce_ = true;
			return callback_->onFoundUnconvertableCharacter();
		}
		bool isCalledOnce() const throw() {
			return calledOnce_;
		}
	private:
		IUnconvertableCharCallback*	callback_;
		bool						calledOnce_;
	};

	// EditDoc::length_ offp
#ifdef _DEBUG
	length_t calculateDocumentLength(const EditDoc& document) {
		length_t		c = 0;
		const length_t	lineCount = document.getLineCount();
		for(length_t i = 0; i < lineCount; ++i)
			c += document.getLineLength(i);
		return c;
	}
#endif /* _DEBUG */
} // namespace @0

namespace Ascension { namespace Private {
	/// ܂Ƃ߂ăAhD/hD\ȈȂ
	class OperationUnit : public SelfAssertable, public UseMemoryPool<OperationUnit> {
		// RXgN^
	public:
		virtual ~OperationUnit();

		// \bh
	public:
		bool		execute(EditDoc& document, CharPos& resultPosition);
		IOperation&	pop();
		void		push(InsertOperation& operation, const EditDoc& document);
		void		push(DeleteOperation& operation, const EditDoc& document);
		IOperation&	top() const;

		// f[^o
	private:
		stack<IOperation*> operations_;	// ̒PʂɊ܂܂Ȃ
	};
} } // namespace Ascension::Private


// InsertOperation class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline InsertOperation::InsertOperation(const CharPos& pos, const string_t& text) : position_(pos), text_(text) {
}

/// }삪s\
inline bool InsertOperation::canExecute(EditDoc& document) const throw() {
	assertValid();
	return !document.isNarrowed()
		|| (position_ >= document.getStartPoint() && position_ <= document.getEndPoint());
}

/// }̍Đ
inline CharPos InsertOperation::execute(EditDoc& document) {
	assertValid();
	return document.insertText(position_, text_);
}

/// 폜͏ɌłȂ
inline bool InsertOperation::isConcatenatable(InsertOperation& postOperation, const EditDoc& document) const throw() {
	assertValid();
	return false;
}

/// 폜͏ɌłȂ
inline bool InsertOperation::isConcatenatable(DeleteOperation& postOperation, const EditDoc& document) const throw() {
	assertValid();
	return false;
}


// DeleteOperation class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline DeleteOperation::DeleteOperation(const TextRange& range) throw() : range_(range) {
}

/// 폜삪s\
inline bool DeleteOperation::canExecute(EditDoc& document) const throw() {
	assertValid();
	return !document.isNarrowed() || (range_.getTop() >= document.getStartPoint() && range_.getBottom() <= document.getEndPoint());
}

/// 폜̍Đ
inline CharPos DeleteOperation::execute(EditDoc& document) {
	assertValid();
	return document.deleteText(range_);
}

/// ̑w肳ꂽPʂɌ
inline bool DeleteOperation::isConcatenatable(InsertOperation& postOperation, const EditDoc& document) const throw() {
	assertValid();
	return false;
}

/// ̑w肳ꂽPʂɌ
inline bool DeleteOperation::isConcatenatable(DeleteOperation& postOperation, const EditDoc& document) const throw() {
	assertValid();

	const CharPos& bottom = range_.getBottom();
	if(bottom.char_ == 0 || bottom != postOperation.range_.getTop())
		return false;
	else {
/*		const EditView*	view = reinterpret_cast<EditView*>(*document.getFirstViewPosition());
		const Lexer*	view->getLexer();
		const string_t&	line = document.getLine(bottom.line_);
		const CodePoint	cp = (bottom.char_ == 1
				|| !Utf16Surrogates::isLowSurrogate(line[bottom.char_])
				|| !Utf16Surrogates::isLowSurrogate(line[bottom.char_ - 1])) ? line[bottom.char_]
				: Utf16Surrogates::decode(line.c_str() + bottom.char_ - 1, 2);
		const CodePoint cp = Utf16Surrogates::decode(line.c_str() + bottom.char_, line.length() - bottom.char_);
*/
		// Ō̑Pʂ̍Ō̑Ɍ (폜͈͂g)
		const_cast<DeleteOperation*>(this)->range_.getBottom() = postOperation.range_.getBottom();
		return true;
	}
}


// OperationUnit class implementation
/////////////////////////////////////////////////////////////////////////////

/// fXgN^
inline Private::OperationUnit::~OperationUnit() {
	while(!operations_.empty()) {
		delete operations_.top();
		operations_.pop();
	}
}

/**
 *	@brief Pʂ̎sB\bhďoケ̃IuWFNg͖ɂȂ
 *
 *	SsłƂÃ\bh true ԂAIuWFNg͖ɂȂB
 *	i[COȂǂŎsłȂ삪ƁȂ܂łsA
 *	̃IuWFNg͎słȂc̑ێB
 *	ł̑삪s\ɂȂōēx\bhĂяoƎc̑삪s
 *	@param document			ΏۃhLg
 *	@param resultPosition	[out] IɃLbguׂʒu
 *	@return					SĂ̑słƂ true
 */
inline bool Private::OperationUnit::execute(EditDoc& document, CharPos& resultPosition) {
	assertValid();

	resultPosition.line_ = resultPosition.char_ = -1;
	while(!operations_.empty()) {	// SĂ̑s
		if(!operations_.top()->canExecute(document))
			return false;
		resultPosition = operations_.top()->execute(document);
		delete operations_.top();
		operations_.pop();
	}
	return true;
}

/// 1̑|bv
inline Private::IOperation& Private::OperationUnit::pop() {
	assertValid();
	Private::IOperation* p = operations_.top();
	operations_.pop();
	return *p;
}

/// 1̑vbV
inline void Private::OperationUnit::push(InsertOperation& operation, const EditDoc& document) {
	assertValid();
	operations_.push(&operation);
}

/// 1̑vbV (@a operation ͂̃\bhj󂷂\̂Ōďo̓ANZX֎~)
inline void Private::OperationUnit::push(DeleteOperation& operation, const EditDoc& document) {
	assertValid();

	// Ȏ폜ł΁A͈͂g傷邱Ƃ1ɂ܂Ƃ߂悤Ƃ
	if(!operations_.empty() && operations_.top()->isConcatenatable(operation, document)) {
		delete &operation;
		return;
	}
	operations_.push(&operation);
}

/// 擪̑擾
inline Private::IOperation& Private::OperationUnit::top() const {
	assertValid();
	return *operations_.top();
}


// EditDoc::UndoManager class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline EditDoc::UndoManager::UndoManager(EditDoc& document)
		: document_(document), virtualOperation_(false), virtualUnit_(0), lastUnit_(0), savedOperation_(0) {
}

/// fXgN^
inline EditDoc::UndoManager::~UndoManager() {
	clear();
}

/// AhD/hDX^bNɂ
inline void EditDoc::UndoManager::clear() {
	lastUnit_ = 0;
	savedOperation_ = 0;
	while(!undoStack_.empty()) {
		delete undoStack_.top();
		undoStack_.pop();
	}
	while(!redoStack_.empty()) {
		delete redoStack_.top();
		redoStack_.pop();
	}
}

/// hD\ȉ񐔂Ԃ
size_t EditDoc::UndoManager::getRedoBufferLength() const throw() {
	return redoStack_.size();
}

/// AhD\ȉ񐔂Ԃ
size_t EditDoc::UndoManager::getUndoBufferLength() const throw() {
	return undoStack_.size();
}

/// Oۑ瑀삪ǉA폜ꂽԂ
inline bool EditDoc::UndoManager::isModifiedSinceLastSave() const throw() {
	if(undoStack_.empty())
		return savedOperation_ != 0;
	return savedOperation_ != &undoStack_.top()->top();
}

/// ۑꂽƂʒm
inline void EditDoc::UndoManager::onSave() throw() {
	savedOperation_ = !undoStack_.empty() ? &undoStack_.top()->top() : 0;
}

/**
 *	1̑AhDX^bNɒǉ
 *	@param operation	ǉ鑀
 *	@param concatPrev	Ȏƌ邩ǂ
 */
template<class Operation>
inline void EditDoc::UndoManager::pushUndoBuffer(Operation& operation, bool concatPrev) {
	// hDX^bNɂ
	if(!virtualOperation_) {
		while(!redoStack_.empty()) {
			delete redoStack_.top();
			redoStack_.pop();
		}
	}

	if(virtualOperation_) {	// z쎞̓X^bNւ̒ǉx
		if(virtualUnit_ == 0)	// 
			virtualUnit_ = new Private::OperationUnit();
		virtualUnit_->push(operation, document_);
	} else if(concatPrev && lastUnit_ != 0)	// Ō̑PʂɌ
		lastUnit_->push(operation, document_);
	else {
		Private::OperationUnit* newUnit = new Private::OperationUnit();
		newUnit->push(operation, document_);
		undoStack_.push(newUnit);
		lastUnit_ = newUnit;
	}
}

/// hD1s
inline bool EditDoc::UndoManager::redo(CharPos& resultPosition) {
	if(redoStack_.empty())
		return false;

	Private::OperationUnit* unit = redoStack_.top();
	virtualOperation_ = true;			// zJn
	const bool succeeded = unit->execute(document_, resultPosition);
	if(succeeded)
		redoStack_.pop();
	if(virtualUnit_ != 0)
		undoStack_.push(virtualUnit_);	// zPʂAhDX^bNֈڂ
	virtualUnit_ = lastUnit_ = 0;
	virtualOperation_ = false;			// zI
	if(succeeded)
		delete unit;
	return succeeded;
}

/// AhD1s
inline bool EditDoc::UndoManager::undo(CharPos& resultPosition) {
	if(undoStack_.empty())
		return false;

	Private::OperationUnit* unit = undoStack_.top();
	virtualOperation_ = true;			// zJn
	const bool succeeded = unit->execute(document_, resultPosition);
	if(succeeded)
		undoStack_.pop();
	if(virtualUnit_ != 0)
		redoStack_.push(virtualUnit_);	// zPʂhDX^bNֈڂ
	virtualUnit_ = lastUnit_ = 0;
	virtualOperation_ = false;			// zI
	if(succeeded)
		delete unit;
	return succeeded;
}


// EditDoc class implementation
/////////////////////////////////////////////////////////////////////////////

const char_t	EditDoc::BREAK_CHARS[5] = {0x000A, 0x000D, 0x0085, 0x2028, 0x2029};
CodePage		EditDoc::defaultCodePage_ = ::GetACP();
LineBreak		EditDoc::defaultLineBreak_ = LB_CRLF;
map<UINT_PTR, EditDoc*> EditDoc::documents_;

/// RXgN^
EditDoc::EditDoc() : ignoreViews_(false), readOnly_(false),
		fileOpenMode_(FOM_DENY_NONE), codePage_(defaultCodePage_), lineBreak_(defaultLineBreak_), length_(0),
		groupingState_(UGS_NONE), onceUndoBufferCleared_(false), recordingOperations_(true), virtualOperating_(false),
		accessibleArea_(0) {
	undoManager_.reset(new UndoManager(*this));
	resetContent();
	timerID_ = ::SetTimer(0, 0, 1000, EditDoc::timerProc);
	EditDoc::documents_[timerID_] = this;
}

/// fXgN^
EditDoc::~EditDoc() {
	file_.close();
	for(set<SynchronizablePoint*>::iterator it = points_.begin(); it != points_.end(); ++it)
		(*it)->onDisposed();
	if(accessibleArea_ != 0) {
		delete accessibleArea_->second;
		delete accessibleArea_;
	}
	::KillTimer(0, timerID_);
	EditDoc::documents_.erase(timerID_);
}

/// t@C̍ŏIXV`FbN
void EditDoc::checkTimeStamp() {
	assertValid();

	static bool	checking = false;

	if(getPathName() == 0 || checking)
		return;
	checking = true;

	HANDLE				find;
	WIN32_FIND_DATAW	wfd;

	find = ::FindFirstFileW(getPathName(), &wfd);
	if(find == INVALID_HANDLE_VALUE) {
		return;
		checking = false;
	}
	if(::CompareFileTime(&lastWriteTime_, &wfd.ftLastWriteTime) == -1) {
		lastWriteTime_ = wfd.ftLastWriteTime;
		for(set<IStatusListener*>::iterator it = listeners_.begin(); it != listeners_.end(); ++it)
			(*it)->onDocumentOverwrittenByOtherProcess(*this);
		// ʒmɃt@CXV邩Ȃ̂ŁA1xŐṼf[^
		::FindClose(find);
		find = ::FindFirstFileW(getPathName(), &wfd);
		lastWriteTime_ = wfd.ftLastWriteTime;
	}
	::FindClose(find);
	checking = false;
}

/**
 *	݊JĂt@CRs[
 *	@param destination	Rs[̃pX
 *	@return				
 */
EditDoc::FileOperationResult EditDoc::copyFile(const wchar_t* destination) {
	assertValid();
	assert(destination != 0);

	if(getPathName() == 0)
		return FOR_HAS_NO_INSTANCE;
	else if(toBoolean(::PathFileExistsW(destination)))
		return FOR_ALREADY_EXISTS;

	FileOperationResult	result = FOR_OK;
	FileBase::OpenMode	openMode;
	FileBase::ShareMode	shareMode;

	switch(static_cast<int>(fileOpenMode_)) {
		case FOM_DENY_WRITE:
			openMode = FileBase::READ_ONLY;
			shareMode = FileBase::DENY_WRITE;
			break;
		case FOM_DENY_READ:
			openMode = FileBase::READ_WRITE;
			shareMode = FileBase::DENY_READ;
			break;
		case FOM_DENY_NONE:
		case FOM_AS_READONLY:
			openMode = FileBase::READ_ONLY;
			shareMode = FileBase::DENY_NONE;
			break;
	}

	file_.close();
	if(!toBoolean(::CopyFileW(getPathName(), destination, true)))
		result = FOR_UNKNOWN_ERROR;

	// t@CJ
	if(readOnly_) {
		if(file_.open(getPathName(), FileBase::READ_ONLY, FileBase::DENY_NONE, FileBase::NO_TRUNCATE))
			fileOpenMode_ = FOM_AS_READONLY;
		else
			return FOR_CANNOT_REOPEN;
	} else if(!file_.open(getPathName(), openMode, shareMode, FileBase::NO_TRUNCATE)) {
		if(file_.open(getPathName(), FileBase::READ_ONLY, FileBase::DENY_NONE, FileBase::NO_TRUNCATE)) {
			fileOpenMode_ = FOM_AS_READONLY;
			if(!readOnly_) {
				result = FOR_REOPENED_AS_READONLY;
				setReadOnly(true);
			}
		} else
			return FOR_CANNOT_REOPEN;
	}
	return result;
}

/**
 *	̕ҏW_𕡐
 *	@param point	ҏW_
 *	@return			ҏW_BĂяo폜
 *	@see			VisualPoint, EditDoc::createEditPoint, EditDoc::copySynchronizablePoint
 */
auto_ptr<VisualPoint> EditDoc::copyEditPoint(const VisualPoint& point) {
	VisualPoint* clone = new VisualPoint(point);
	points_.insert(clone);
	return auto_ptr<VisualPoint>(clone);
}

/**
 *	̓_𕡐
 *	@param point	铯_
 *	@return			_BĂяo폜
 *	@see			SynchronizablePoint, EditDoc::copyEditPoint, EditDoc::createSynchronizablePoint
 */
auto_ptr<SynchronizablePoint> EditDoc::copySynchronizablePoint(const SynchronizablePoint& point) {
	SynchronizablePoint* clone = new SynchronizablePoint(point);
	points_.insert(clone);
	return auto_ptr<SynchronizablePoint>(clone);
}

/**
 *	Lbg쐬
 *	@param eventListener	Lbg̃CxgXiBnull ł悢
 *	@param anchorPoint		΂ƂȂAJ[|Cg
 *	@return					LbgBĂяo폜
 *	@see					Caret
 */
auto_ptr<Caret> EditDoc::createCaret(VisualPoint& anchorPoint, Caret::IEventListener* eventListener /* = 0 */) {
	Caret* newPoint = new Caret(*this, anchorPoint, eventListener);
	newPoint->releaser_ = &releaseEditPoint;
	points_.insert(newPoint);
	return auto_ptr<Caret>(newPoint);
}

/**
 *	ҏW_쐬
 *	@param eventListener	ҏW_̃CxgXiBnull ł悢
 *	@return					ҏW_BĂяo폜
 *	@see					VisualPoint, EditDoc::copyEditPoint, createSynchronizablePoint
 */
auto_ptr<VisualPoint> EditDoc::createEditPoint(EditPoint::IEventListener* eventListener /* = 0 */) {
	VisualPoint* newPoint = new VisualPoint(*this, eventListener);
	newPoint->releaser_ = &releaseEditPoint;
	points_.insert(newPoint);
	return auto_ptr<VisualPoint>(newPoint);
}

/**
 *	_쐬
 *	@return	_BĂяo폜
 *	@see	SynchronizablePoint, EditDoc::copySynchronizablePoint, EditDoc::createEditPoint
 */
auto_ptr<SynchronizablePoint> EditDoc::createSynchronizablePoint() {
	SynchronizablePoint* newPoint = new SynchronizablePoint(*this);
	newPoint->releaser_ = &releaseEditPoint;
	points_.insert(newPoint);
	return auto_ptr<SynchronizablePoint>(newPoint);
}

/**
 *	݊JĂt@CݔɈړ
 *
 *	̃\bhsƃt@C͕
 *	@return	
 */
EditDoc::FileOperationResult EditDoc::deleteFile() {
	assertValid();

	if(getPathName() == 0)
		return FOR_HAS_NO_INSTANCE;
	else if(readOnly_)
		return FOR_FILE_IS_READONLY;

	FileOperationResult	result = FOR_OK;
	FileBase::ShareMode	shareMode;
	wchar_t				path[MAX_PATH];
	SHFILEOPSTRUCTW		shfos = {::GetDesktopWindow(), FO_DELETE, path, 0, FOF_ALLOWUNDO, 0, 0, 0};

	switch(static_cast<int>(fileOpenMode_)) {
		case FOM_DENY_WRITE:	shareMode = FileBase::DENY_WRITE;	break;
		case FOM_DENY_READ:		shareMode = FileBase::DENY_READ;	break;
		case FOM_DENY_NONE:
		case FOM_AS_READONLY:	shareMode = FileBase::DENY_NONE;	break;
	}

	wcscpy(path, getPathName());
	*(path + wcslen(path) + 1) = 0;

	file_.close();
	::SHFileOperationW(&shfos);
	if(toBoolean(::PathFileExistsW(path))) {	// s (SHFileExistsW ̖߂l͂ǂMpł)
		if(shfos.fAnyOperationsAborted)
			result = FOR_ABORTED;

		// t@CJ
		if(!file_.open(getPathName(), FileBase::READ_WRITE, shareMode, FileBase::NO_TRUNCATE)) {
			if(file_.open(getPathName(), FileBase::READ_ONLY, FileBase::DENY_NONE, FileBase::NO_TRUNCATE)) {
				fileOpenMode_ = FOM_AS_READONLY;
				if(!readOnly_) {
					result = FOR_REOPENED_AS_READONLY;
					setReadOnly(true);
				}
			} else
				result = FOR_CANNOT_REOPEN;
		}
	}

	return result;
}

/**
 *	@brief hLgeLXg̎w͈͂폜
 *
 *	̃\bhĂяoƍXVtOZbgB
 *	폜͈͂ANZXs\̈ƏdȂĂ΁Aʗ̈̃eLXg͍폜ȂB
 *	폜͈͂SɃANZXs\̈Ɋ܂܂Ăꍇ́A
 *	eLXg̍폜͈؍sꂸAXVtOωȂ
 *
 *	̃\bhĂяoƃr[ @c onUpdate ĂяoÅTv DocumentUpdate::DELETE_OPERATION ɂȂ
 *	@param range	폜͈
 *	@return			IɃLbguʒu
 *	@throw ReadOnlyDocumentException	ǂݎp̂ƂX[
 */
CharPos EditDoc::deleteText(const TextRange& range) {
	assertValid();

	if(readOnly_)
		throw ReadOnlyDocumentException();
	else if(isNarrowed()) {
		if(range.getBottom() <= getStartPoint())
			return range.getBottom();
		else if(range.getTop() >= getEndPoint())
			return range.getTop();
	}

	const CharPos begin = isNarrowed() ? max(range.getTop(), getStartPoint()) : range.getTop();
	const CharPos end = isNarrowed() ? min(range.getBottom(), getEndPoint()) : range.getBottom();

	string_t deletedString;	// 폜 (sɂȂƂ݂͌̉s})

	if(begin.line_ == end.line_) {	// Ώۂ1sȓ
		const Line&	lineInfo = getLineInfo(end.line_);
		string_t&	line = const_cast<string_t&>(getLine(end.line_));

		++const_cast<Line&>(lineInfo).operationHistory_;
		deletedString = line.substr(begin.char_, end.char_ - begin.char_);
		line.erase(begin.char_, end.char_ - begin.char_);
		length_ -= end.char_ - begin.char_;
	} else {							// Ώۂs
		Line* line = lines_[begin.line_];
		string_t tail;
		deletedString = line->text_.substr(begin.char_);
		length_ -= deletedString.length();
		line->text_.erase(begin.char_);

		// 폜镔ۑ폜
		Line& firstLine = *lines_[begin.line_];
		LineBreak lastLineBreak;
		deletedString += EditDoc::getLineBreakString(lines_[begin.line_]->lineBreak_);
		for(length_t i = begin.line_ + 1; i < end.line_ + 1; ++i) {
			line = lines_[i];
			deletedString += ((i != end.line_) ? line->text_ : line->text_.substr(0, end.char_));
			if(i != end.line_)
				deletedString += getLineBreakString(line->lineBreak_);
			if(i == end.line_) {	// 폜Is
				tail = line->text_.substr(end.char_);
				lastLineBreak = line->lineBreak_;
			}
			length_ -= line->text_.length();
		}
		lines_.erase(begin.line_ + 1, end.line_ - begin.line_);

		// 폜̑Oq
		firstLine.lineBreak_ = lastLineBreak;
		++firstLine.operationHistory_;
		if(!tail.empty()) {
			firstLine.text_ += tail;
			length_ += tail.length();
		}
	}

	InsertOperation* newOperation = new InsertOperation(begin, deletedString);
	if(recordingOperations_) {
		undoManager_->pushUndoBuffer(*newOperation, groupingState_ == UGS_WAIT_FOR_CONTINUE_EDIT);
		if(groupingState_ == UGS_WAIT_FOR_FIRST_EDIT)
			groupingState_ = UGS_WAIT_FOR_CONTINUE_EDIT;
	}

	if(!ignoreViews_) {
		// Ō̍XVXV
		DocumentUpdate update(DocumentUpdate::DELETE_OPERATION);
		update.first = update.result = begin;
		update.last = end;
		updateAllViews(update);
		for(set<SynchronizablePoint*>::iterator it = points_.begin(); it != points_.end(); ++it) {
			if((*it)->isSynchronousWithDocumentUpdate())
				(*it)->onUpdateDocument(update);
		}
	}
	setModified();

	return begin;
}

/// @see Document::doResetContent
void EditDoc::doResetContent() {
	assertValid();
	file_.close();
	for(set<SynchronizablePoint*>::iterator it = points_.begin(); it != points_.end(); ++it)
		(*it)->moveTo(0, 0);
	widen();

	lines_.clear();
	lines_.insert(lines_.begin(), new Line);
	length_ = 0;
	setReadOnly(false);
	setCodePage(EditDoc::defaultCodePage_);
	setLineBreak(EditDoc::defaultLineBreak_);
	setPathName(0);
	setModified(false);
	clearUndoBuffer();
	groupingState_ = UGS_NONE;
	onceUndoBufferCleared_ = false;
}

/**
 *	@brief Ss (hLgS) 擾
 *
 *	o͓e̓i[CỎe󂯂Ȃ
 *	@param os o̓Xg[
 *	@param policy s̏o̓|V[
 */
void EditDoc::getAllLines(basic_ostream<char_t>& os, LineBreakRetrievePolicy policy /* LBRP_PHYSICAL_DATA */) const {
	assertValid();
	const length_t lineCount = getLineCount();
	for(length_t i = 0; i < lineCount; ++i) {
		const Line& line = *lines_[i];
		os << line.text_;
		if(i < lineCount - 1 && policy != LBRP_SKIP) {
			switch(policy) {
			case LBRP_LINE_FEED:
				os << L"\n"; break;
			case LBRP_CRLF:
				os << L"\r\n"; break;
			case LBRP_PHYSICAL_DATA:
				os << EditDoc::getLineBreakString(line.lineBreak_); break;
			case LBRP_DOCUMENT_DEFAULT:
				os << EditDoc::getLineBreakString(EditDoc::getLineBreak()); break;
			}
		}
	}
}

/**
 *	ws牽ڂԂ
 *	@param line		ׂs
 *	@param policy	s̐
 *	@throw std::out_of_range	@a line ȂꍇX[
 */
length_t EditDoc::getLineIndex(length_t line, LineBreakRetrievePolicy policy) const {
	assertValid();

	if(line >= lines_.getSize())
		throw out_of_range("Specified line not found.");

	length_t offset = 0;
	for(length_t i = 0; i < line; ++i) {
		const Line& ln = *lines_[i];
		offset += ln.text_.length();
		switch(policy) {
		case LBRP_LINE_FEED:		offset += 1; break;
		case LBRP_CRLF:				offset += 2; break;
		case LBRP_PHYSICAL_DATA:	offset += getLineBreakLength(ln.lineBreak_); break;
		case LBRP_DOCUMENT_DEFAULT:	offset += getLineBreakLength(getLineBreak()); break;
		}
	}
	return offset;
}

/**
 *	@brief wʒuɕ}
 *
 *	ڍׂ2o[WQ
 *	@param pos			}ʒu
 *	@param first, last	}镶̊JnƏI
 *	@return				ɃLbguʒu
 *	@throw ReadOnlyDocumentException	ǂݎp̂ƂX[
 *	@throw std::invalid_argument		@a first A@a last ̂ꂩ null ̂ƂX[
 */
CharPos EditDoc::insertText(const CharPos& pos, const char_t* first, const char_t* last) {
	assertValid();

	if(readOnly_)
		throw ReadOnlyDocumentException();
	else if(first == 0 || last == 0 || first > last)
		throw invalid_argument("Argument begin or end is invalid.");
	else if(isNarrowed() && (pos < getStartPoint() || pos > getEndPoint()))
		return pos;
	else if(first == last)
		return pos;

	CharPos resultPosition(pos.line_, 0);
	const char_t* breakPoint = find_first_of(first, last, EditDoc::BREAK_CHARS, endof(EditDoc::BREAK_CHARS));

	if(breakPoint == last) {	// ͂ɉsꍇ
		Line& line = const_cast<Line&>(getLineInfo(pos.line_));
		line.text_.insert(pos.char_, first, static_cast<string_t::size_type>(last - first));
		length_ += static_cast<length_t>(last - first);
		++line.operationHistory_;
		resultPosition.char_ = pos.char_ + (last - first);
	} else {	// ͂s̏ꍇ
		length_t line = pos.line_;
		Line& firstLine = *lines_[line];
		const char_t* lastBreak;
		const LineBreak firstLineBreak = firstLine.lineBreak_;	// 擪s̉s (}AԌɕt)

		// Ō̉sʒuTAresultPosition ̕ʒu肷
		for(lastBreak = last - 1; ; --lastBreak) {
			if(binary_search(EditDoc::BREAK_CHARS, endof(EditDoc::BREAK_CHARS), *lastBreak))
				break;
		}
		resultPosition.char_ = static_cast<length_t>((last - first) - (lastBreak - first) - 1);
		if(*lastBreak == L'\n' && lastBreak != breakPoint && *(lastBreak - 1) == L'\r')
			--lastBreak;

		// 擪s̒u
		const string_t firstLineRest = firstLine.text_.substr(pos.char_, firstLine.text_.length() - pos.char_);
		length_ += breakPoint - first - firstLineRest.length();
		firstLine.text_.replace(pos.char_, firstLineRest.length(), first, static_cast<string_t::size_type>(breakPoint - first));
		firstLine.lineBreak_ = eatLineBreak(breakPoint, last);
		breakPoint += (firstLine.lineBreak_ != LB_CRLF) ? 1 : 2;
		++firstLine.operationHistory_;
		++line;
		++resultPosition.line_;

		// sƂɍsɋ؂Ă
		while(true) {
			if(breakPoint <= lastBreak) {
				const char_t* const nextBreak =
					find_first_of(breakPoint, last, EditDoc::BREAK_CHARS, endof(EditDoc::BREAK_CHARS));
				assert(nextBreak != last);
				const LineBreak lineBreak = eatLineBreak(nextBreak, last);

				length_ += nextBreak - breakPoint;
				lines_.insert(line, new Line(string_t(breakPoint, nextBreak), lineBreak, true));
				++line;
				++resultPosition.line_;
				breakPoint = nextBreak + ((lineBreak != LB_CRLF) ? 1 : 2);
			} else {	// ŏIs
				length_ += last - breakPoint + firstLineRest.length();
				lines_.insert(line, new Line(string_t(breakPoint, last) + firstLineRest, firstLineBreak, true));
				break;
			}
		}
	}

	DeleteOperation* const newOperation = new DeleteOperation(TextRange(pos, resultPosition));
	if(recordingOperations_) {
		undoManager_->pushUndoBuffer(*newOperation, groupingState_ == UGS_WAIT_FOR_CONTINUE_EDIT);
		if(groupingState_ == UGS_WAIT_FOR_FIRST_EDIT)
			groupingState_ = UGS_WAIT_FOR_CONTINUE_EDIT;
	}

	setModified();
	if(!ignoreViews_) {
		// Ō̍XVXV
		DocumentUpdate update(DocumentUpdate::INSERT_OPERATION);
		update.first = pos;
		update.result = update.last = resultPosition;
		updateAllViews(update);
		for(set<SynchronizablePoint*>::iterator it = points_.begin(); it != points_.end(); ++it) {
			if((*it)->isSynchronousWithDocumentUpdate())
				(*it)->onUpdateDocument(update);
		}
	}
	assert(length_ == calculateDocumentLength(*this));	// length_ o̐ff

	return resultPosition;
}

/**
 *	@brief t@ChLgǂݍ
 *
 *	̃\bh̓V[gJbgȂ
 *	@param fileName		t@C
 *	@param fileOpenMode	r[hȂ
 *	@param codePage		R[hy[W (ȗƎ)
 *	@param callback		R[obNBnull ł悢
 *	@return				ہBEditDoc::FileIOResult Q
 */
EditDoc::FileIOResult EditDoc::load(const wstring& fileName,
		FileOpenMode fileOpenMode, CodePage codePage, IFileIOListener* callback /* = 0 */) {
//	Timer tm(L"load");	// 2.86s / 1MB
	assertValid();

	if(!toBoolean(::PathFileExists(fileName.c_str())))
		return FIR_READ_NOT_EXIST;

	EncoderFactory& encoderFactory = EncoderFactory::getInstance();

	if(!encoderFactory.isValidCodePage(codePage))
		return FIR_INVALID_CODEPAGE;

	WaitCursor wc;
	FileIOResult result = FIR_OK;

	resetContent();
	fileOpenMode_ = fileOpenMode;
	if(fileOpenMode == FOM_AS_READONLY || toBoolean(::GetFileAttributesW(fileName.c_str()) & FILE_ATTRIBUTE_READONLY)) {
		// ǂݎpŊJ
		if(!file_.open(fileName.c_str(), FileBase::READ_ONLY, FileBase::DENY_NONE))
			return FIR_UNKNOWN_ERROR;
		setReadOnly(true);
		if(fileOpenMode != FOM_AS_READONLY)
			result = FIR_READ_READONLY;
	} else if(!file_.open(fileName.c_str(), FileBase::READ_WRITE, FileBase::DENY_NONE)) {
		if(!file_.open(fileName.c_str(), FileBase::READ_ONLY, FileBase::DENY_NONE))
			return FIR_UNKNOWN_ERROR;
		result = FIR_READ_USED_BY_OTHER_PROCESS;
		setReadOnly(true);
	}

	// t@C傫玸s
	if(file_.getLength() > numeric_limits<ulong>::max()) {
		file_.close();
		return FIR_READ_HUGE_FILE;
	}

	const ulong fileSize = static_cast<ulong>(file_.getLength());
	DWORD readBytes;	// ۂɓǂݎf[^

	file_.getFileTime(0, 0, &lastWriteTime_);
	uchar* const nativeBuffer =
		static_cast<uchar*>(::HeapAlloc(::GetProcessHeap(), HEAP_NO_SERIALIZE, static_cast<SIZE_T>(fileSize)));
	if(nativeBuffer == 0) {
		file_.close();
		return FIR_OUT_OF_MEMORY;
	}

	if(fileSize != 0) {
		// Cɓǂݍ
		if(!file_.read(nativeBuffer, fileSize, &readBytes)) {
			::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, nativeBuffer);
			file_.close();
			return FIR_UNKNOWN_ERROR;
		}
	} else
		readBytes = 0;
	file_.close();

	char_t* firstBreak = 0;	// ŏɌꂽs
	CharPos last(0, 0);	// ɕǉʒu

	// ǂݍ񂾃obt@Ŝ𕶎R[hϊ
	if(readBytes != 0) {
		codePage = encoderFactory.detectCodePage(nativeBuffer, min(readBytes, 4UL * 1024), codePage);

		auto_ptr<Encoder> encoder = encoderFactory.createEncoder(codePage);
		assert(encoder.get() != 0);

		size_t destLength = encoder->getMaxUCSCharLength() * readBytes;
		const uchar* bom;
		size_t bomLength;

		switch(codePage) {
		case CP_UTF8:				bom = Encodings::UTF8_BOM; bomLength = 3; break;
		case CPEX_UNICODE_UTF16LE:	bom = Encodings::UTF16LE_BOM; bomLength = 2; break;
		case CPEX_UNICODE_UTF16BE:	bom = Encodings::UTF16BE_BOM; bomLength = 2; break;
		case CPEX_UNICODE_UTF32LE:	bom = Encodings::UTF32LE_BOM; bomLength = 4; break;
		case CPEX_UNICODE_UTF32BE:	bom = Encodings::UTF32BE_BOM; bomLength = 4; break;
		default:					bom = 0; bomLength = 0; break;
		}

		char_t* const ucsBuffer =
			static_cast<char_t*>(::HeapAlloc(::GetProcessHeap(), HEAP_NO_SERIALIZE, (destLength + 1) * sizeof(char_t)));
		if(ucsBuffer == 0) {
			::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, nativeBuffer);
			return FIR_OUT_OF_MEMORY;
		}

		if(bomLength != 0 && readBytes >= bomLength && memcmp(nativeBuffer, bom, bomLength) == 0)
			destLength = encoder->toUnicode(ucsBuffer, destLength, nativeBuffer + bomLength, readBytes - bomLength, callback);
		else
			destLength = encoder->toUnicode(ucsBuffer, destLength, nativeBuffer, readBytes, callback);

		if(destLength == 0) {	// ϊłȂ߁ANCAg𒆎~邱ƂɌ߂
			::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, nativeBuffer);
			::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, ucsBuffer);
			return FIR_ABORTED_FOR_UNCONVERTABLE;
		}

		ucsBuffer[destLength] = 0;
		setPathName(fileName.c_str());

		// sƂɋ؂AXgɒǉĂ
		length_t nextBreak, lastBreak = 0;
		LineBreak lineBreak;
		lines_.clear();
		lineBreak_ = LB_AUTO;
		while(true) {
			for(size_t i = lastBreak; ; ++i) {	// sT
				if(i == destLength) {
					nextBreak = -1;
					break;
				} else if(binary_search(EditDoc::BREAK_CHARS, endof(EditDoc::BREAK_CHARS) - 1, ucsBuffer[i])) {
					nextBreak = i;
					break;
				}
			}
			if(nextBreak != -1) {
				// s̔
				switch(ucsBuffer[nextBreak]) {
				case L'\n':	lineBreak = LB_LF;	break;
				case L'\r':
					lineBreak = (nextBreak + 1 < destLength && ucsBuffer[nextBreak + 1] == L'\n') ? LB_CRLF : LB_CR;
					break;
				case 0x0085:	lineBreak = LB_NEL;	break;
				case L'\x2028':	lineBreak = LB_LS;	break;
				case L'\x2029':	lineBreak = LB_PS;	break;
				}
				lines_.insert(lines_.getSize(), new Line(string_t(ucsBuffer + lastBreak, nextBreak - lastBreak), lineBreak));
				length_ += nextBreak - lastBreak;
				lastBreak = nextBreak + ((lineBreak != LB_CRLF) ? 1 : 2);
				if(lineBreak_ == LB_AUTO)	// ŏɌꂽs̉sƂ
					setLineBreak(lineBreak);
			} else {	// ŏIs
				lines_.insert(lines_.getSize(), new Line(string_t(ucsBuffer + lastBreak, destLength - lastBreak)));
				length_ += destLength - lastBreak;
				break;
			}
		}
		::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, ucsBuffer);
	} else {	// ̃t@C
		codePage = ::GetACP();
		setPathName(fileName.c_str());
	}

	if(lineBreak_ == LB_AUTO)
		setLineBreak(EditDoc::defaultLineBreak_);

	::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, nativeBuffer);

	// t@C̃bN
	if(fileOpenMode == FOM_DENY_NONE || fileOpenMode == FOM_AS_READONLY) {
		if(!file_.open(fileName.c_str(), FileBase::READ_ONLY, FileBase::DENY_NONE))
			result = FIR_LOCK_DENIED;
	} else if(fileOpenMode == FOM_DENY_WRITE) {
		if(!file_.open(fileName.c_str(), FileBase::READ_ONLY, FileBase::DENY_WRITE))
			result = FIR_LOCK_DENIED;
	} else	/* if(fom == FOM_DENY_READ) */ {
		if(!file_.open(fileName.c_str(), FileBase::READ_WRITE, FileBase::EXCLUSIVE))
			result = FIR_LOCK_DENIED;
	}

	setCodePage(codePage);
	clearUndoBuffer();
	setModified(false);
	groupingState_ = UGS_NONE;
	onceUndoBufferCleared_ = false;

	DocumentUpdate update(DocumentUpdate::INSERT_OPERATION);
	update.last = getEndPoint();
	updateAllViews(update);

	return result;
}

/**
 *	݂̊JĂt@Cw肵@ŃbNBǂݎp͖
 *	@param fom	r[hBFOM_DENYWRITE AFOM_DENYREAD ̂ݗL
 *	@return		bNɐ true
 *	@see		EditDoc::unlockFile
 */
bool EditDoc::lockFile(FileOpenMode fom) {
	assertValid();

	if(fom != FOM_DENY_WRITE && fom != FOM_DENY_READ)
		return false;
	if(getPathName() == 0 || readOnly_)
		return false;

	file_.close();
	if(file_.open(getPathName(), FileBase::READ_WRITE,
			((fom == FOM_DENY_WRITE) ? FileBase::DENY_WRITE : FileBase::DENY_READ))) {
		fileOpenMode_ = fom;
		return true;
	} else
		return false;
}

/**
 *	݊JĂt@Cړ
 *	@param destination	Rs[̃pX
 *	@return				
 */
EditDoc::FileOperationResult EditDoc::moveFile(const wchar_t* destination) {
	assertValid();
	assert(destination != 0);

	if(getPathName() == 0)
		return FOR_HAS_NO_INSTANCE;
	else if(toBoolean(::PathFileExistsW(destination)))
		return FOR_ALREADY_EXISTS;
	else if(readOnly_)
		return FOR_FILE_IS_READONLY;

	FileOperationResult	result = FOR_OK;
	FileBase::OpenMode	openMode;
	FileBase::ShareMode	shareMode;

	switch(static_cast<int>(fileOpenMode_)) {
		case FOM_DENY_WRITE:
			openMode = FileBase::READ_ONLY;
			shareMode = FileBase::DENY_WRITE;
			break;
		case FOM_DENY_READ:
			openMode = FileBase::READ_WRITE;
			shareMode = FileBase::DENY_READ;
			break;
		case FOM_DENY_NONE:
		case FOM_AS_READONLY:
			openMode = FileBase::READ_ONLY;
			shareMode = FileBase::DENY_NONE;
			break;
	}

	file_.close();
	if(!toBoolean(::MoveFileW(getPathName(), destination)))
		result = FOR_UNKNOWN_ERROR;
	else
		setPathName(destination);

	// bN悤Ƃ
	if(!file_.open(getPathName(), openMode, shareMode, FileBase::NO_TRUNCATE)) {
		if(file_.open(getPathName(), FileBase::READ_ONLY, FileBase::DENY_NONE, FileBase::NO_TRUNCATE)) {
			fileOpenMode_ = FOM_AS_READONLY;
			if(!readOnly_) {
				result = FOR_REOPENED_AS_READONLY;
				setReadOnly(true);
			}
		} else
			return FOR_CANNOT_REOPEN;
	}
	return result;
}

/**
 *	i[CO̎s
 *	@param range	ANZX\̈
 *	@see			EditDoc::isNarrowed, EditDoc::widen
 */
void EditDoc::narrow(const TextRange& range) {
	assertValid();
	if(accessibleArea_ == 0)
		accessibleArea_ = new pair<CharPos, SynchronizablePoint*>;
	accessibleArea_->first = range.getTop();
	accessibleArea_->second = createSynchronizablePoint().release();
	accessibleArea_->second->moveTo(range.getBottom());
	accessibleArea_->second->synchronizeWithDocumentUpdate(true);
	for(set<SynchronizablePoint*>::iterator it = points_.begin(); it != points_.end(); ++it) {
		if((*it)->isExcludedFromRestriction())
			(*it)->normalize();
	}
	updateAllViews(DocumentUpdate(DocumentUpdate::CHANGED_NARROWING));
	for(std::set<IStatusListener*>::iterator it = listeners_.begin(); it != listeners_.end(); ++it)
		(*it)->onDocumentChangedAccessibleRegion(*this);
}

/**
 *	@brief AhDAhD̂߂ɕҏWL^邩ǂݒ肷
 *
 *	ł͋L^ԂɂȂĂBݒύXƋL^̓e͔j
 *	@param record	L^ꍇ true
 *	@see			EditDoc::isRecordingOperations, EditDoc::undo, EditDoc::redo
 */
void EditDoc::recordOperations(bool record) {
	assertValid();
	if(!(recordingOperations_ = record))
		clearUndoBuffer();
}

/**
 *	hD̎s
 *	@return								SɃhDłȂꍇ false Ԃ
 *	@throw ReadOnlyDocumentException	ǂݎp̂ƂX[
 *	@see								EditDoc::undo
 */
bool EditDoc::redo() {
	assertValid();
	if(readOnly_)
		throw ReadOnlyDocumentException();
	else if(getUndoHistoryLength(true) == 0)
		return false;

	beginEditCollection();
	DocumentUpdate update(DocumentUpdate::BEGIN_UNDO_OPERATION);
	updateAllViews(update);
	update.summary = DocumentUpdate::END_UNDO_OPERATION;
	const bool succeeded = undoManager_->redo(update.result);
	endEditCollection();
	updateAllViews(update);

	if(!undoManager_->isModifiedSinceLastSave())
		setModified(false);
	return succeeded;
}

/// hLg쐬_j
void EditDoc::releaseEditPoint(EditDoc& document, SynchronizablePoint& point) {
	document.points_.erase(&point);
}

/**
 *	hLg̕ۑ
 *	@param fileName		t@C̃pX
 *	@param options		IvV
 *	@param lineBreak	ꂷsR[hBLB_AUTO w肷ƓꂵȂ
 *	@param codePage		R[hy[WBCPEX_AUTODETECT w肷ƌ݂̃R[hy[Wgp
 *	@param callback		R[obNBnull ł悢
 *	@return				݌ʁB FIR_OK
 */
EditDoc::FileIOResult EditDoc::save(const basic_string<WCHAR>& fileName,
		SaveDocumentOption options, LineBreak lineBreak, CodePage codePage, IFileIOListener* callback /* = 0 */) {
	assertValid();

	// ㏑̏ꍇAt@CǂݎpׂĂ
	if(toBoolean(::PathFileExistsW(fileName.c_str()))) {
		const DWORD attributes = ::GetFileAttributes(fileName.c_str());
		if(attributes == -1)
			return FIR_UNKNOWN_ERROR;	// [
		else if(toBoolean(attributes & FILE_ATTRIBUTE_READONLY))
			return FIR_WRITE_READONLY;
	}

	EncoderFactory& encoderFactory = EncoderFactory::getInstance();

	if(!encoderFactory.isValidCodePage(codePage)				// R[hy[WCXg[Ă邩
			|| encoderFactory.isCodePageForReadOnly(codePage))	// ǂݎp̃R[hy[W
		return FIR_INVALID_CODEPAGE;
	if(encoderFactory.isCodePageForAutoDetection(codePage))	// ݂̃R[hy[Wg
		codePage = codePage_;

	// Unicode R[hy[WłgȂsR[h
	if((lineBreak == LB_NEL || lineBreak == LB_LS || lineBreak == LB_PS)
			&& codePage != CPEX_UNICODE_UTF5 && codePage != CP_UTF7 && codePage != CP_UTF8
			&& codePage != CPEX_UNICODE_UTF16LE && codePage != CPEX_UNICODE_UTF16BE
			&& codePage != CPEX_UNICODE_UTF32LE && codePage != CPEX_UNICODE_UTF32BE)
		return FIR_WRITE_INVALID_LINEBREAK;

	WaitCursor wc;
	FileIOResult result = FIR_OK;

	// fobOo[W͏ɃobNAbv (㏑̏ꍇ̂)
#ifdef _DEBUG
	options |= SDO_CREATE_BACKUP;
#endif /* _DEBUG */
	if(toBoolean(options & SDO_CREATE_BACKUP) && toBoolean(::PathFileExistsW(fileName.c_str()))) {
		wchar_t	backupPath[MAX_PATH + 1];
		SHFILEOPSTRUCTW	shfos = {
			0, FO_DELETE, backupPath, 0, FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_SILENT, false, 0
		};
		wcscpy(backupPath, fileName.c_str());
		wcscat(backupPath, L".bak");
		backupPath[wcslen(backupPath) + 1] = 0;
		::CopyFileW(fileName.c_str(), backupPath, false);
		::SHFileOperationW(&shfos);	// ݔɎĂ
	}

	// iR[obN
	IFileIOProgressListener* progressEvent = (callback != 0) ? callback->queryProgressCallback() : 0;
	const length_t intervalLineCount = (progressEvent != 0) ? progressEvent->queryIntervalLineCount() : 0;

	// 1sϊăobt@ɏ݁AňxɃt@Cɏ
	auto_ptr<Encoder>			encoder = encoderFactory.createEncoder(codePage);
	UnconvertableCharCallback*	internalCallback = (callback != 0) ? new UnconvertableCharCallback(callback) : 0;
	const length_t				lineCount = getLineCount();	// s
	const size_t				nativeBufferBytes = (getDocumentLength<LBRP_CRLF>()) * encoder->getMaxNativeCharLength() + 4;
	uchar* const				nativeBuffer = static_cast<uchar*>(::HeapAlloc(::GetProcessHeap(), HEAP_NO_SERIALIZE, nativeBufferBytes));
	size_t						offset = 0;	// oCgP

	if(nativeBuffer == 0) {
		delete internalCallback;
		return FIR_OUT_OF_MEMORY;
	}

	// BOM
	if(toBoolean(options & SDO_WRITE_BOM)) {
		size_t signatureSize;
		switch(codePage) {
		case CP_UTF8:
			signatureSize = countof(Encodings::UTF8_BOM) - 1;
			memcpy(nativeBuffer, Encodings::UTF8_BOM, signatureSize);
			break;
		case CPEX_UNICODE_UTF16LE:
			signatureSize = countof(Encodings::UTF16LE_BOM) - 1;
			memcpy(nativeBuffer, Encodings::UTF16LE_BOM, signatureSize);
			break;
		case CPEX_UNICODE_UTF16BE:
			signatureSize = countof(Encodings::UTF16BE_BOM) - 1;
			memcpy(nativeBuffer, Encodings::UTF16BE_BOM, signatureSize);
			break;
		case CPEX_UNICODE_UTF32LE:
			signatureSize = countof(Encodings::UTF32LE_BOM) - 1;
			memcpy(nativeBuffer, Encodings::UTF32LE_BOM, signatureSize);
			break;
		case CPEX_UNICODE_UTF32BE:
			signatureSize = countof(Encodings::UTF32BE_BOM) - 1;
			memcpy(nativeBuffer, Encodings::UTF32BE_BOM, signatureSize);
			break;
		}
		offset += sizeof(uchar) * signatureSize;
	}

	for(length_t i = 0; i < lineCount; ++i) {
		const Line& line = *lines_[i];
		if(i == lineCount - 1) {	// ŏIs
			if(line.text_.empty())
				break;
		}
		size_t convertedBytes;

		if(!line.text_.empty()) {
			convertedBytes = encoder->fromUnicode(nativeBuffer + offset, nativeBufferBytes - offset,
							line.text_.data(), line.text_.length(),
							(internalCallback != 0 && !internalCallback->isCalledOnce()) ? internalCallback : 0);
			if(convertedBytes == 0)
				goto CLIENT_ABORTED;
			offset += convertedBytes;
		}
		if(i != lineCount - 1) {
			const string_t breakString = getLineBreakString((lineBreak != LB_AUTO) ? lineBreak : line.lineBreak_);
			convertedBytes = encoder->fromUnicode(nativeBuffer + offset,
				nativeBufferBytes - offset, breakString.data(), breakString.length(),
				(internalCallback != 0 && !internalCallback->isCalledOnce()) ? internalCallback : 0);
			if(convertedBytes == 0)
				goto CLIENT_ABORTED;
			offset += convertedBytes;
		}
		continue;
CLIENT_ABORTED:
		::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, nativeBuffer);
		delete internalCallback;
		return FIR_ABORTED_FOR_UNCONVERTABLE;
	}

	// Vt@CJ
	if(file_.isOpened())
		file_.close();
	if(!file_.open(fileName.c_str(), FileBase::READ_WRITE, FileBase::DENY_WRITE, FileBase::CREATE)) {
		// ߂Ȃꍇ͈ȑÕt@CJȂ
		file_.open(getPathName(), readOnly_ ?
			FileBase::READ_ONLY : FileBase::READ_WRITE, FileBase::DENY_WRITE, FileBase::CREATE | FileBase::NO_TRUNCATE);
		return FIR_UNKNOWN_ERROR;
	}
	file_.write(nativeBuffer, static_cast<DWORD>(offset));
	file_.close();
	::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, nativeBuffer);
	delete internalCallback;

	// t@C̃bN
	if(fileOpenMode_ == FOM_DENY_WRITE || fileOpenMode_ == FOM_DENY_READ) {
		if(!lockFile(fileOpenMode_))
			result = FIR_LOCK_DENIED;
	}

	if(lineBreak != LB_AUTO) {
		setLineBreak(lineBreak);	// sR[ȟ
		for(length_t i = 0; i < lines_.getSize(); ++i) {
			Line& line = *lines_[i];
			line.operationHistory_ = 0;		// 엚
			line.lineBreak_ = lineBreak;	// sR[h㏑
		}
	} else {
		for(length_t i = 0; i < lines_.getSize(); ++i)
			lines_[i]->operationHistory_ = 0;
	}
	undoManager_->onSave();
	setModified(false);
	setReadOnly(false);
	setCodePage(codePage);
	setPathName(fileName.c_str());

	// ŏIXV̍XV
	WIN32_FIND_DATAW wfd;
	HANDLE find = ::FindFirstFileW(getPathName(), &wfd);
	if(find != INVALID_HANDLE_VALUE) {
		lastWriteTime_ = wfd.ftLastWriteTime;
		::FindClose(find);
	}

	// r[ɒʒm
	updateAllViews(DocumentUpdate(DocumentUpdate::SAVED));

	return result;
}

/**
 *	݂̃t@C[֑M
 *	@param asAttachment	Ytt@CƂđM邩ǂBYtt@Cɂꍇ
 *						݂̕ύX͔fȂB{ƂđMꍇ݂͌̃hLggp
 *	@param showDialog	[UI_CAO\邩ǂ
 *	@return				
 */
bool EditDoc::sendFile(bool asAttachment, bool showDialog /* = true */) {
	assertValid();

	if(asAttachment && getPathName() == 0)
		return false;

	WaitCursor wc;
	HMODULE dll = ::LoadLibraryW(L"MAPI32.DLL");
	if(dll == 0)
		return false;

	MAPISENDMAIL* MAPISendMailPtr = reinterpret_cast<MAPISENDMAIL*>(::GetProcAddress(dll, "MAPISendMail"));
	if(MAPISendMailPtr == 0) {
		::FreeLibrary(dll);
		return false;
	}

	AutoZero<::MapiMessage> message;
	ulong error;

	message.flFlags = MAPI_RECEIPT_REQUESTED;

	if(asAttachment) {	// Ytt@CɂƂ
		AutoZero<::MapiFileDesc> fileDesc;
		const int cb = ::WideCharToMultiByte(CP_ACP, 0,
							getPathName(), static_cast<int>(wcslen(getPathName())), 0, 0, 0, 0);
		char* const filePath = new char[cb + 1];

		::WideCharToMultiByte(CP_ACP, 0, getPathName(), static_cast<int>(wcslen(getPathName())), filePath, cb, 0, 0);
		filePath[cb] = 0;
		message.nFileCount = 1;
		message.lpFiles = &fileDesc;

		fileDesc.lpszPathName = filePath;
		fileDesc.nPosition = static_cast<ulong>(-1);
		error = MAPISendMailPtr(0, 0, &message, MAPI_LOGON_UI | (showDialog ? MAPI_DIALOG : 0), 0);
		delete[] filePath;
	} else {	// {ƂđMƂ
		wchar_t* const content = new wchar_t[length_ + 1];

		for(length_t i = 0, offset = 0; ; ++i) {
			const Line& line = *lines_[i];
			wcsncpy(content + offset, line.text_.data(), line.text_.length());
			offset += line.text_.length();
			if(i != lines_.getSize() - 1) {
				wcscpy(content + offset, getLineBreakString(line.lineBreak_).c_str());
				offset += getLineBreakString(line.lineBreak_).length();
			} else
				break;
		}
		content[length_] = 0;

		// [Ũ}`oCgɕϊ
		const int contentSize = ::WideCharToMultiByte(CP_ACP, 0, content, static_cast<int>(length_), 0, 0, 0, 0);
		char* const	nativeContent = new char[contentSize + 1];
		::WideCharToMultiByte(CP_ACP, 0, content, static_cast<int>(length_), nativeContent, contentSize, 0, 0);
		nativeContent[contentSize] = 0;
		message.lpszNoteText = nativeContent;
		delete[] content;
		error = MAPISendMailPtr(0, 0, &message, MAPI_LOGON_UI | (showDialog ? MAPI_DIALOG : 0), 0);
		delete[] nativeContent;
	}

	::FreeLibrary(dll);
	return error == SUCCESS_SUCCESS || error == MAPI_USER_ABORT || error == MAPI_E_LOGIN_FAILURE;
}

/**
 *	̃R[hy[WƉsR[h̐ݒ
 *	@param cp					R[hy[W
 *	@param lineBreak			sR[h
 *	throw std::invalid_argument	R[hy[WAsR[hȂƂX[
 */
void EditDoc::setDefaultCode(CodePage cp, LineBreak lineBreak) {
	cp = translateSpecialCodePage(cp);
	if(!EncoderFactory::getInstance().isValidCodePage(cp)
			|| EncoderFactory::getInstance().isCodePageForAutoDetection(cp))
		throw invalid_argument("Specified code page is not available.");
	switch(lineBreak) {
	case LB_LF:		case LB_CR:		case LB_CRLF:
	case LB_NEL:	case LB_LS:		case LB_PS:
		break;
	default:
		throw invalid_argument("Specified line break type is invalid.");
	}
	defaultCodePage_ = cp;
	defaultLineBreak_ = lineBreak;
}

/// ::SetTimer ̃R[obN֐B1000~bƂɌĂяoA
/// t@CvZXŕύXĂȂĎ
void CALLBACK EditDoc::timerProc(HWND window, UINT msg, UINT_PTR eventID, DWORD time) {
	map<UINT_PTR, EditDoc*>::iterator it = EditDoc::documents_.find(eventID);
	if(it != EditDoc::documents_.end())
		it->second->checkTimeStamp();
}

/**
 *	@brief	AhD̎s
 *
 *	ΏۂANZXs\ł΃hD͍sȂ
 *	@return								AhDłȂꍇ false Ԃ
 *	@throw ReadOnlyDocumentException	ǂݎp̂ƂX[
 *	@see								EditDoc::redo
 */
bool EditDoc::undo() {
	assertValid();
	if(readOnly_)
		throw ReadOnlyDocumentException();
	else if(getUndoHistoryLength(false) == 0)
		return false;

	beginEditCollection();
	DocumentUpdate update(DocumentUpdate::BEGIN_UNDO_OPERATION);
	updateAllViews(update);
	update.summary = DocumentUpdate::END_UNDO_OPERATION;
	const bool succeeded = undoManager_->undo(update.result);
	endEditCollection();
	updateAllViews(update);

	if(!undoManager_->isModifiedSinceLastSave())
		setModified(false);
	return succeeded;
}

/// i[CO
/// @see EditDoc::isNarrowed, EditDoc::narrow
void EditDoc::widen() {
	if(accessibleArea_ != 0) {
		delete accessibleArea_->second;
		delete accessibleArea_;
		accessibleArea_ = 0;
		updateAllViews(DocumentUpdate(DocumentUpdate::CHANGED_NARROWING));
		for(std::set<IStatusListener*>::iterator it = listeners_.begin(); it != listeners_.end(); ++it)
			(*it)->onDocumentChangedAccessibleRegion(*this);
	}
}

/* [EOF] */