// EditDoc.h
// (c) 2003-2006 exeal

#ifndef EDIT_DOC_H_
#define EDIT_DOC_H_

#include <stack>
#include <list>
#include <map>
#include <set>
#include "EditPoint.h"
#include "Encodings\Encoder.h"
#include "../../Manah/DocumentView.hpp"
#include "../../Manah/File.hpp"


namespace Ascension {

namespace Private {
	class IOperation;
	class OperationUnit;
}

/// sR[h
enum LineBreak {
	LB_AUTO,	///< ϊAw薳Ȃ
	LB_LF,		///< sBUnix W (Lf, U+000A)
	LB_CR,		///< BÂ Macintosh W (Cr, U+000D)
	LB_CRLF,	///< +sBWindows W (CrLf, U+000D U+000A)
	LB_NEL,		///< Vs (U+0085)
	LB_LS,		///< s؂ (U+2028)
	LB_PS		///< i؂ (U+2029)
};

/// r[ւ̒ʒmɎg EditDoc ̍XV
struct DocumentUpdate {
	enum Summary {
		INSERT_OPERATION,		///< }
		DELETE_OPERATION,		///< 폜
		BEGIN_UNDO_OPERATION,	///< AhD/hD̊Jn
		END_UNDO_OPERATION,		///< AhD/hD̏I (ۂɃAhDsȂꍇ @c result  CharPos::INVALID_POSITION)
		BEGIN_EDIT_COLLECTION,	///< EditDoc::beginEditCollection Ăяoꂽ (@c summary ȊÕo͖)
		END_EDIT_COLLECTION,	///< EditDoc::endEditCollection Ăяoꂽ (@c summary ȊÕo͖)
		SAVED,					///< hLgۑ (@c summary ȊÕo͖)
		CHANGED_NARROWING		///< i[CȌԂω (@c summary ȊÕo͖)
	} summary;	///< Tv
	CharPos first;	///< ΏۊJnʒu
	CharPos last;	///< ΏۏIʒu (@a first &lt;= @a last)
	CharPos result;	///< I̐Lbgʒu

	/// RXgN^
	/// @param updateSummary	XV̊Tv
	DocumentUpdate(Summary updateSummary) : summary(updateSummary) {}
};

/// hLgǂݎp̂ƂҏW悤ƂƃX[
class ReadOnlyDocumentException : public std::logic_error {
public:
	/// RXgN^
	ReadOnlyDocumentException() : std::logic_error("Document is readonly. Any edit process is denied.") {}
};


/**
 *	@brief Ascension eLXgGfB^̃hLg
 *
 *	SĂ̍s̓eA엚AR[hy[WAsR[hȂǂB
 *	t@Cs
 *
 *	<h3>AhDO[v̊TO</h3>
 *
 *	Ascension GfB^ɂ́Ȃ܂Ƃ߂ăAhD/hDł悤
 *	AhDO[vƂTOB^CsOɂA͂̈ꊇ
 *	쑤̎dłBEditView AEditPoint ͂Ƃɂ̑Ă邽߁A
 *	̃NXgăhLgҏWꍇA[U̓^CsOɂꊇ
 *	̂߂̃R[hKv͖
 *
 *	̑AhDO[vƂɂ͈Ȃ̑O
 *	EditDoc::beginEditCollection 1xĂяoBđ삪I
 *	EditDoc::endEditCollection Ăяo
 *
 *	@see EditView, SynchronizablePoint, EditPoint
 */
class EditDoc : public Manah::FileBoundDocument<DocumentUpdate> {
	// ^
public:
	/// EditDoc::load AEditDoc::save ŕԂl
	enum FileIOResult {
		FIR_OK							= 0x00,	///< t@C͐Ƀ[h/Z[uꂽ
		FIR_ACCESS_DENIED				= 0x01,	///< t@C̓ǂݎ/݂ۂꂽ
		FIR_LOCK_DENIED					= 0x02,	///< t@C̃bNۂꂽ
		FIR_INVALID_CODEPAGE			= 0x03,	///< w肳ꂽR[hy[WȂ
		FIR_ABORTED_FOR_UNCONVERTABLE	= 0x04,	///< ϊłȂ߁AĂяo𒆎~
		FIR_OUT_OF_MEMORY				= 0x05,	///< ŝ߁AǂݏɎs
		FIR_UNKNOWN_ERROR				= 0x06,	///< s̃G[
		FIR_READ_READONLY				= 0x11,	///< t@CǂݎpĂ߂ɁAǂݎp[hŊJ
		FIR_READ_USED_BY_OTHER_PROCESS	= 0x12,	///< ̃vZXt@CgĂ̂ŁAǂݎp[hŊJ
		FIR_READ_HUGE_FILE				= 0x13,	///< ǂݍރt@C傫
		FIR_READ_NOT_EXIST				= 0x14,	///< w肳ꂽt@C݂Ȃ
		FIR_WRITE_FULL_DISK				= 0x21,	///< L}̂ɏނ߂̗̈悪
		FIR_WRITE_READONLY				= 0x22,	///< ǂݎp[hA܂͓ǂݎp̃t@CɏƂ
		FIR_WRITE_INVALID_LINEBREAK		= 0x23,	///< R[hy[W Unicode x[XłȂꍇ Unicode ̉sR[hŕۑ悤Ƃ
	};

	/// EditDoc::copyFile AEditDoc::deleteFile AEditDoc::moveFile ŕԂl
	enum FileOperationResult {
		FOR_OK,						///< t@C͐ɏI
		FOR_ABORTED,				///< [U𒆒f (ݔֈړ ̂ݗL)
		FOR_FILE_IS_READONLY,		///< ǂݎp[hŊJĂ̂ŏłȂ
		FOR_ALREADY_EXISTS,			///< Rs[Aړɓ̃t@C݂
		FOR_REOPENED_AS_READONLY,	///< t@CJƂɓǂݎpŊJ
		FOR_CANNOT_REOPEN,			///< t@CĴɎs
		FOR_HAS_NO_INSTANCE,		///< \bhsɃt@CJĂȂ
		FOR_UNKNOWN_ERROR,			///< m̃G[ (G[bZ[W @c GetLastError 擾\)
	};

	/// t@C̃I[v[h
	enum FileOpenMode {
		FOM_DENY_NONE,	///< bNȂ
		FOM_DENY_WRITE,	///< ̏ݖړĨt@CI[v
		FOM_DENY_READ,	///< ̓ǂݍݖړĨt@CI[v
		FOM_AS_READONLY	///< ǂݎpƂĊJ (bN͖)
	};

	/// EditDoc::save ŎgۑIvV
	typedef uchar	SaveDocumentOption;
	static const SaveDocumentOption
		SDO_WRITE_BOM		= 0x01,	///< UTF-8A16A32 ŕۑƂ BOM 
		SDO_CREATE_BACKUP	= 0x02;	///< ۑÕt@C̃obNAbvݔɍ쐬

	/// hLg̏ԕω󂯎郊Xi
	/// @see EditDoc::addStatusListener, EditDoc::removeStatusListener
	class IStatusListener {
	public:
		/// fXgN^
		virtual ~IStatusListener() {}
		/// i[CO̐ݒ/ɂANZX\̈悪ω
		virtual void onDocumentChangedAccessibleRegion(EditDoc& document) = 0;
		/// R[hy[WAsR[hύXꂽ
		virtual void onDocumentChangedFormat(EditDoc& document) = 0;
		/// ǂݎpω
		virtual void onDocumentChangedReadOnlyState(EditDoc& document) = 0;
		/// t@COvZXŕύXꂽ
		virtual void onDocumentOverwrittenByOtherProcess(EditDoc& document) = 0;
	};

	/// obt@̕ύX󂯎郊Xi (T|[g)
	/// @see EditDoc::addBufferListener, EditDoc::removeBufferListener
	class IBufferListener {
	public:
		/// fXgN^
		virtual ~IBufferListener() {}
		/// eLXg폜ꂽ
		virtual void onDeleteText(const TextRange& range) = 0;
		/// eLXg}ꂽ
		virtual void onInsertText(const CharPos& at, const string_t& text) = 0;
	};

	/// hLg̕ۑAǂݍ݂̐i󂯎 (T|[g)
	class IFileIOProgressListener {
	public:
		enum ProcessType {};
		/**
		 *	i̒ʒm
		 *	@param type				e (f[^ʂ̒`͏eɂ)
		 *	@param processedAmount	ɏf[^
		 *	@param totalAmount		ׂSf[^
		 */
		virtual void onProgress(ProcessType type, ULONGLONG processedAmount, ULONGLONG totalAmount) = 0;
		/// iʒmԊusŕԂ
		virtual length_t queryIntervalLineCount() const = 0;
		/// j
		virtual void release() = 0;
	protected:
		/// fXgN^
		virtual ~IFileIOProgressListener() {}
	};

	/// EditDoc::load AEditDoc::save ŎgR[obN
	class IFileIOListener : virtual public Encodings::IUnconvertableCharCallback {
	public:
		/// fXgN^
		virtual ~IFileIOListener() {}
		/// ̐i󂯎 IFileIOProgressCallback CX^XԂBnull ԂĂ悢
		virtual IFileIOProgressListener* queryProgressCallback() = 0;
	};

	/// s̓e
	class Line : public Manah::UseMemoryPool<Line> {
	private:
		/// RXgN^
		explicit Line() : lineBreak_(LB_AUTO), operationHistory_(0) {}
		/// RXgN^
		explicit Line(string_t& text, LineBreak lineBreak = LB_AUTO, bool modified = false)
			: text_(text), lineBreak_(lineBreak), operationHistory_(modified ? 1 : 0) {}
	public:
		/// s̃eLXgԂ
		const string_t& getLine() const throw() {return text_;}
		/// sI[Ԃ
		LineBreak getLineBreak() const throw() {return lineBreak_;}
		/// ̍sύXĂ邩
		bool isModified() const throw() {return operationHistory_ != 0;}
	private:
		string_t	text_;				// s
		LineBreak	lineBreak_;			// s̎
		ulong		operationHistory_;	// AhDJE^ (0ŕύX̏)
		friend class EditDoc;
	};
	typedef Manah::GapBuffer<Line*,
		Manah::GapBuffer_DeletePointer<Line*> >	LineList;	///< s̃Xg
//	typedef LineList::ConstIterator	LineIterator;			///< s̔q
	typedef void(EditDoc::*EditPointReleaser)(const EditPoint& point);


	/**
	 *	Lg̕𑖍郉_ANZXCe[^
	 *	@param lineBreakPolicy sǂ̂悤Ɉ
	 *	@see LineBreakRetrievePolicy, UTF16ToUTF32Iterator, UTF32ToUTF16Iterator
	 */
	template<LineBreakRetrievePolicy lineBreakPolicy>
	/* final */ class CharacterIterator : public std::iterator<std::random_access_iterator_tag, char_t> {
	public:
		CharacterIterator() throw();
		CharacterIterator(const EditDoc& document, const CharPos& pos);
		CharacterIterator(const CharacterIterator& rhs) throw();
		CharacterIterator& operator =(const CharacterIterator& rhs) throw();
		char_t operator *() const throw();
		CharacterIterator& operator ++() throw();
		const CharacterIterator operator ++(int) throw();
		CharacterIterator& operator --() throw();
		const CharacterIterator operator --(int) throw();
		bool operator ==(const CharacterIterator& rhs) const throw();
		bool operator !=(const CharacterIterator& rhs) const throw();
		CharacterIterator& operator +=(difference_type rhs) throw();
		const CharacterIterator operator +(difference_type rhs) const throw();
		CharacterIterator& operator -=(difference_type rhs) throw();
		const CharacterIterator operator -(difference_type rhs) const throw();
		difference_type operator -(const CharacterIterator& rhs) const throw();
		CharacterIterator operator [](difference_type index) const throw();
		bool operator <(const CharacterIterator& rhs) const throw();
		bool operator <=(const CharacterIterator& rhs) const throw();
		bool operator >(const CharacterIterator& rhs) const throw();
		bool operator >=(const CharacterIterator& rhs) const throw();
		const CharPos& getPosition() const throw();
	private:
		length_t getLineBreakLength(length_t line) const throw();
	private:
		const EditDoc* document_;
		CharPos pos_;
	};

	// RXgN^
public:
	EditDoc();
	virtual ~EditDoc();

	// \bh
public:
	// Xi
//	void	addBufferListener(IBufferListener& listener);
	void	addStatusListener(IStatusListener& listener);
//	void	removeBufferListener(IBufferListener& listener);
	void	removeStatusListener(IStatusListener& listener);

	// r[ (񉼑z֐̃I[o[Ch)
	EditView&	getView(std::size_t index) const;

	// R[hAsR[h
	Encodings::CodePage	getCodePage() const throw();
	LineBreak			getLineBreak() const throw();
	static length_t		getLineBreakLength(LineBreak lineBreak);
	static string_t		getLineBreakString(LineBreak lineBreak);
	void				setCodePage(Encodings::CodePage cp);
	static void			setDefaultCode(Encodings::CodePage cp, LineBreak lineBreak);
	void				setLineBreak(LineBreak lineBreak);

	// 
	FileOpenMode	getShareMode() const throw();
	std::size_t		getUndoHistoryLength(bool redo = false) const throw();
	bool			isReadOnly() const throw();
	void			setReadOnly(bool readOnly = true);

	// hLgANZX
	void			clearUndoBuffer();
	void			getAllLines(std::basic_ostream<char_t>& os, LineBreakRetrievePolicy policy = LBRP_PHYSICAL_DATA) const;
	template<LineBreakRetrievePolicy policy>
	length_t		getDocumentLength() const;
	CharPos			getEndPoint() const throw();
	const string_t&	getLine(length_t index) const;
	length_t		getLineCount() const throw();
	length_t		getLineIndex(length_t line, LineBreakRetrievePolicy policy) const;
	const Line&		getLineInfo(length_t line) const;
//	LineIterator	getLineIterator(length_t line) const;
	length_t		getLineLength(length_t line) const;
	CharPos			getStartPoint() const throw();

	// ҏW
	void	beginEditCollection();
	CharPos	deleteText(const TextRange& range);
	CharPos	deleteText(const CharPos& pos1, const CharPos& pos2);
	void	endEditCollection();
	CharPos	insertText(const CharPos& pos, const string_t& text);
	CharPos	insertText(const CharPos& pos, const char_t* first, const char_t* last);
	bool	isCollectingEdit() const throw();
	bool	isRecordingOperation() const throw();
	void	recordOperations(bool record);
	bool	redo();
	bool	undo();

	// i[CO
	bool	isNarrowed() const throw();
	void	narrow(const TextRange& range);
	void	widen();

	// ҏW_
	std::auto_ptr<VisualPoint>			copyEditPoint(const VisualPoint& point);
	std::auto_ptr<SynchronizablePoint>	copySynchronizablePoint(const SynchronizablePoint& point);
	std::auto_ptr<Caret>				createCaret(VisualPoint& anchorPoint, Caret::IEventListener* eventListener = 0);
	std::auto_ptr<VisualPoint>			createEditPoint(EditPoint::IEventListener* eventListener = 0);
	std::auto_ptr<SynchronizablePoint>	createSynchronizablePoint();

	// t@C <-> hLg
	FileIOResult	load(const std::basic_string<WCHAR>& fileName,
						FileOpenMode openMode, Encodings::CodePage codePage, IFileIOListener* callback = 0);
	FileIOResult	save(const std::basic_string<WCHAR>& fileName, SaveDocumentOption options,
						LineBreak lineBreak, Encodings::CodePage codePage, IFileIOListener* callback = 0);

	// ɊJĂt@Cɑ΂鏈
	FileOperationResult	copyFile(const WCHAR* destination);
	FileOperationResult	deleteFile();
	bool				lockFile(FileOpenMode fileOpenMode);
	FileOperationResult	moveFile(const WCHAR* destination);
	bool				sendFile(bool asAttachment, bool showDialog = true);

	// [eBeB
protected:
	static LineBreak	eatLineBreak(const char_t* text, const char_t* last);
private:
	void						checkTimeStamp();
	void						initialize();
	static void					releaseEditPoint(EditDoc& document, SynchronizablePoint& point);
	static void CALLBACK		timerProc(HWND window, UINT msg, UINT_PTR eventID, DWORD time);
	static Encodings::CodePage	translateSpecialCodePage(Encodings::CodePage cp);

	// I[o[Ch
	virtual void	doResetContent();

	// f[^o
public:
	static const char_t	BREAK_CHARS[5];	// s̏W
private:
	/// AhDAhDǗ
	class UndoManager {
		// RXgN^
	public:
		UndoManager(EditDoc& document);
		virtual ~UndoManager();

		// \bh
	public:
		void		clear();
		std::size_t	getRedoBufferLength() const throw();
		std::size_t	getUndoBufferLength() const throw();
		bool		isModifiedSinceLastSave() const throw();
		void		onSave() throw();
		template<class Operation>
		void		pushUndoBuffer(Operation& operation, bool concatPrev);
		bool		redo(CharPos& resultPosition);
		bool		undo(CharPos& resultPosition);

		// f[^o
	private:
		EditDoc&							document_;			// ΏۃhLg
		std::stack<Private::OperationUnit*>	undoStack_;			// AhDX^bN
		std::stack<Private::OperationUnit*>	redoStack_;			// hDX^bN
		bool								virtualOperation_;	// ẑƂ^
		Private::OperationUnit*				virtualUnit_;		// zǉ鑀P
		Private::OperationUnit*				lastUnit_;			// ŌɒǉꂽP
		Private::IOperation*				savedOperation_;	// ۑɖɂȂĂ
	};

	/// AhDO[v̏
	enum UndoGroupingState {
		UGS_NONE,					///< O[sO͍sĂȂ
		UGS_WAIT_FOR_FIRST_EDIT,	///< O[sOJnҏW1xsĂȂ
		UGS_WAIT_FOR_CONTINUE_EDIT	///< O[sOJn1xȏҏWsꂽ
	};

	// f[^o
	bool							ignoreViews_;	// onUpdate ĂяoKvƂ true (t@CǂݍݓrȂ)
	bool							readOnly_;		// ǂݎp[h (ǂݍݎɐݒ肳s)
	FileOpenMode					fileOpenMode_;	// t@C̋L[h (FOM_ASREADONLY ͖Ӗ)
	Encodings::CodePage				codePage_;		// R[hy[W
	LineBreak						lineBreak_;		// sR[h (L[{[h͂ɂsɎgp)
	LineList						lines_;			// s
	length_t						length_;		// hLgŜ̒ (UTF-16 PʁBs͊܂܂Ȃ)
	std::set<SynchronizablePoint*>	points_;		// 쐬ҏW_
	Manah::Windows::IO::File<true>	file_;			// ݊JĂt@C
	std::auto_ptr<UndoManager>		undoManager_;	// AhD/hD̊Ǘ
	UndoGroupingState				groupingState_;	// AhDO[v̎W
	bool							onceUndoBufferCleared_;	// 1xȏAhDobt@NA
	bool							recordingOperations_;	// AhD/hD̂߂ɑL^Ă邩

	bool							virtualOperating_;	// AhD/hDɂ deleteText AinsertText
														// \bhĂяôƂ true B
														// true ̊Ԃ͗\bhŃhDX^bNNAȂ

	std::pair<CharPos, SynchronizablePoint*>*	accessibleArea_;	// ANZX\̈ (i[COĂȂƂ null)

	std::set<IStatusListener*>			listeners_;		// CxgXi
	FILETIME							lastWriteTime_;	// t@C̍ŏIXV
	UINT_PTR							timerID_;		// ^C} ID
	static std::map<UINT_PTR, EditDoc*>	documents_;		// ^C} ID -> hLg̃}bv

	static Encodings::CodePage	defaultCodePage_;	// ̃R[hy[W
	static LineBreak			defaultLineBreak_;	// ̉sR[h
};


/**
 *	ԕω󂯎郊Xi̒ǉ
 *	@param listener VXi
 */
inline void EditDoc::addStatusListener(IStatusListener& listener) {assertValid(); listeners_.insert(&listener);}

/// AhDO[v̎WJnB
/// ݎWł΁AxIAVWJn
inline void EditDoc::beginEditCollection() {
	assertValid();
	if(groupingState_ != UGS_NONE)
		endEditCollection();
	groupingState_ = UGS_WAIT_FOR_FIRST_EDIT;
	updateAllViews(DocumentUpdate(DocumentUpdate::BEGIN_EDIT_COLLECTION));
}

/// AhD/hDX^bNɂė
inline void EditDoc::clearUndoBuffer() {
	assertValid();
	undoManager_->clear();
	onceUndoBufferCleared_ = true;
}

/// @see EditDoc::deleteText
inline CharPos EditDoc::deleteText(const CharPos& pos1, const CharPos& pos2) {assertValid(); return deleteText(TextRange(pos1, pos2));}

/// @see s𔻒肷
inline LineBreak EditDoc::eatLineBreak(const char_t* first, const char_t* last) {
	assert(first != 0 && last != 0 && first <= last);
	switch(*first) {
	case L'\n':		return LB_LF;
	case L'\r':		return (last - first > 1 && first[1] == L'\n') ? LB_CRLF : LB_CR;
	case 0x0085:	return LB_NEL;
	case L'\x2028':	return LB_LS;
	case L'\x2029':	return LB_PS;
	default:		return LB_AUTO;
	}
}

/// AhDO[v̎WI
inline void EditDoc::endEditCollection() {
	assertValid();
	if(groupingState_ != UGS_NONE) {
		groupingState_ = UGS_NONE;
		updateAllViews(DocumentUpdate(DocumentUpdate::END_EDIT_COLLECTION));
	}
}

/// ݎgpĂR[hy[W擾
inline Encodings::CodePage EditDoc::getCodePage() const throw() {assertValid(); return codePage_;}

/// hLg̕ҏW̕Ԃ
template<> inline length_t EditDoc::getDocumentLength<LBRP_LINE_FEED>() const throw() {return length_ + getLineCount() - 1;}

template<> inline length_t EditDoc::getDocumentLength<LBRP_CRLF>() const throw() {return length_ + getLineCount() * 2 - 1;}

template<> inline length_t EditDoc::getDocumentLength<LBRP_PHYSICAL_DATA>() const throw() {
	length_t len = length_;
	const length_t lineCount = getLineCount();
	for(length_t i = 0; i < lineCount; ++i)
		len += getLineBreakLength(lines_[i]->lineBreak_);
	return len;
}

template<> inline length_t EditDoc::getDocumentLength<LBRP_DOCUMENT_DEFAULT>() const throw() {
	return (getLineBreak() == LB_CRLF) ? getDocumentLength<LBRP_CRLF>() : getDocumentLength<LBRP_LINE_FEED>();}

template<> inline length_t EditDoc::getDocumentLength<LBRP_SKIP>() const throw() {return length_;}

/// ANZX\̈̏I[Ԃ
inline CharPos EditDoc::getEndPoint() const throw() {
	assertValid();
	return (accessibleArea_ != 0) ? *accessibleArea_->second
		: CharPos(lines_.getSize() - 1, getLineLength(lines_.getSize() - 1));
}

/**
 *	w肵s̃eLXg擾
 *	@throw std::out_of_range @a line sȂƂX[
 */
inline const string_t& EditDoc::getLine(length_t line) const {assertValid(); return getLineInfo(line).text_;}

/// ݎgpĂsR[h擾
inline LineBreak EditDoc::getLineBreak() const throw() {assertValid(); return lineBreak_;}

/// s̒Ԃ
inline length_t EditDoc::getLineBreakLength(LineBreak lineBreak) {
	switch(lineBreak) {
	case LB_CRLF:
		return 2;
	case LB_LF: case LB_CR: case LB_NEL: case LB_LS: case LB_PS:
		return 1;
	default:
		throw std::invalid_argument("Unknown line break specified.");
	}
}

/// sR[h̉sԂ
inline string_t EditDoc::getLineBreakString(LineBreak lineBreak) {
	switch(lineBreak) {
	case LB_AUTO:	return L"";
	case LB_LF:		return L"\n";
	case LB_CR:		return L"\r";
	case LB_CRLF:	return L"\r\n";
	case LB_NEL:	return string_t(1, 0x0085);	// VC6
	case LB_LS:		return L"\x2028";
	case LB_PS:		return L"\x2029";
	default:		throw std::invalid_argument("Unknown line break specified.");
	}
}

/// s擾
inline length_t EditDoc::getLineCount() const throw() {assertValid(); return lines_.getSize();}

/// sꊇĎ擾
/// @throw std::out_of_range @a line sȂƂX[
inline const EditDoc::Line& EditDoc::getLineInfo(length_t line) const {
	assertValid();
	if(line >= lines_.getSize())
		throw std::out_of_range("Specified line is not exist.");
	return *lines_[line];
}
/*
/// sCe[^̎擾
/// @throw std::out_of_range @a line sȂƂX[
inline EditDoc::LineIterator EditDoc::getLineIterator(length_t line) const {
	assertValid();
	if(line >= lines_.getSize())
		throw std::out_of_range("Specified line is not exist.");
	return lines_.begin() + line;
}
*/
/// w肵s̒擾 (s͊܂܂Ȃ)
/// @throw std::out_of_range @a line sȂƂX[
inline length_t EditDoc::getLineLength(length_t line) const {assertValid(); return getLine(line).length();}

/// t@C̔r[h擾
inline EditDoc::FileOpenMode EditDoc::getShareMode() const throw() {assertValid(); return fileOpenMode_;}

/// ANZX\̈̐擪Ԃ
inline CharPos EditDoc::getStartPoint() const throw() {
	assertValid(); return (accessibleArea_ != 0) ? accessibleArea_->first : CharPos(0, 0);}

/// AhDAhD\ȉ񐔂擾
inline std::size_t EditDoc::getUndoHistoryLength(bool redo /* = false */) const throw() {
	assertValid(); return redo ? undoManager_->getRedoBufferLength() : undoManager_->getUndoBufferLength();}

/// @see Document::getView
inline EditView& EditDoc::getView(std::size_t index) const {return reinterpret_cast<EditView&>(Manah::Document<DocumentUpdate>::getView(index));}

/**
 *	@brief wʒuɃeLXg}
 *
 *	̃\bhĂяoƍXVtOZbgB
 *	}ʒuANZXs\̈ł΁AeLXg̑}͍sꂸAXVtOωȂ
 *
 *	̃\bhĂяoƃr[ onUpdate ĂяoÅTv DocumentUpdate::INSERT_OPERATION ɂȂ
 *	@param pos	}ʒu
 *	@param text	}镶
 *	@return		ɃLbguʒu
 *	@throw ReadOnlyDocumentException	ǂݎp̂ƂX[
 */
inline CharPos EditDoc::insertText(const CharPos& pos, const string_t& text) {
	assertValid();
	return insertText(pos, text.data(), text.data() + text.length());
}

/// AhDO[v̎WԂ
/// @see EditDoc::beginEditCollection, EditDoc::endEditCollection
inline bool EditDoc::isCollectingEdit() const throw() {assertValid(); return groupingState_ != UGS_NONE;}

/// i[COĂ邩Ԃ
/// @see EditDoc::narrow, EditDoc::widen
inline bool EditDoc::isNarrowed() const throw() {assertValid(); return accessibleArea_ != 0;}

/// ǂݎp[hǂԂ
/// @see ReadOnlyDocumentException, EditDoc::setReadOnly
inline bool EditDoc::isReadOnly() const throw() {assertValid(); return readOnly_;}

/// AhDAhD̂߂ɕҏWL^Ă邩Ԃ
/// @see EditDoc::recordOperations, EditDoc::getUndoHistoryLength
inline bool EditDoc::isRecordingOperation() const throw() {assertValid(); return recordingOperations_;}

/**
 *	ԕω󂯎郊Xi̍폜
 *	@param listener 폜郊Xi
 */
inline void EditDoc::removeStatusListener(IStatusListener& listener) {assertValid(); listeners_.erase(&listener);}

/**
 *	R[hy[W̐ݒ
 *	@param cp						Vݒ肷R[hy[Wԍ
 *	@throw std::invalid_argument	R[hy[WpłȂƂX[
 */
inline void EditDoc::setCodePage(Encodings::CodePage cp) {
	assertValid();
	cp = translateSpecialCodePage(cp);
	if(cp != codePage_) {
		if(!Encodings::EncoderFactory::getInstance().isValidCodePage(cp)
				|| Encodings::EncoderFactory::getInstance().isCodePageForAutoDetection(cp))
			throw std::invalid_argument("Specified code page is not available.");
		codePage_ = cp;
		for(std::set<IStatusListener*>::iterator it = listeners_.begin(); it != listeners_.end(); ++it)
			(*it)->onDocumentChangedFormat(*this);
	}
}

/**
 *	sR[h̐ݒ
 *	@param lineBreak				Vݒ肷sR[h
 *	@throw std::invalid_argument	sR[hȂƂX[
 */
inline void EditDoc::setLineBreak(LineBreak lineBreak) {
	assertValid();
	switch(lineBreak) {
	case LB_LF:		case LB_CR:
	case LB_CRLF:	case LB_NEL:
	case LB_LS:		case LB_PS:
		if(lineBreak != lineBreak_) {
			lineBreak_ = lineBreak;
			for(std::set<IStatusListener*>::iterator it = listeners_.begin(); it != listeners_.end(); ++it)
				(*it)->onDocumentChangedFormat(*this);
		}
		break;
	default:
		throw std::invalid_argument("Unknown line break specified.");
	}
}

/// ǂݎp[h̐ݒ
/// @see ReadOnlyDocumentException, EditDoc::isReadOnly
inline void EditDoc::setReadOnly(bool readOnly /* = true */) {
	assertValid();
	if(readOnly != readOnly_) {
		readOnly_ = readOnly;
		for(std::set<IStatusListener*>::iterator it = listeners_.begin(); it != listeners_.end(); ++it)
			(*it)->onDocumentChangedReadOnlyState(*this);
	}
}

///  Win32 R[hy[WR[hy[Wɕϊ
inline Encodings::CodePage EditDoc::translateSpecialCodePage(Encodings::CodePage cp) {
	if(cp == CP_ACP)
		return ::GetACP();
	else if(cp == CP_OEMCP)
		return ::GetOEMCP();
	else if(cp == CP_MACCP) {
		wchar_t	wsz[7];
		::GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_IDEFAULTMACCODEPAGE, wsz, 6);
		return (std::wcscmp(wsz, L"2") != 0) ? std::wcstoul(wsz, 0, 10) : 0;
	} else if(cp == CP_THREAD_ACP) {
		wchar_t	wsz[7];
		::GetLocaleInfoW(::GetThreadLocale(), LOCALE_IDEFAULTANSICODEPAGE, wsz, 6);
		return (std::wcscmp(wsz, L"3") != 0) ? std::wcstoul(wsz, 0, 10) : 0;
	}
	return cp;
}


/// RXgN^
template<LineBreakRetrievePolicy lineBreakPolicy>
inline EditDoc::CharacterIterator<lineBreakPolicy>::CharacterIterator() throw() : document_(0) {}

/// RXgN^
template<LineBreakRetrievePolicy lineBreakPolicy>
inline EditDoc::CharacterIterator<lineBreakPolicy>::CharacterIterator(const EditDoc& document, const CharPos& pos) throw()
: document_(&document), pos_(pos) {}

/// Rs[RXgN^
template<LineBreakRetrievePolicy lineBreakPolicy>
inline EditDoc::CharacterIterator<lineBreakPolicy>::CharacterIterator(const EditDoc::CharacterIterator<lineBreakPolicy>& rhs) throw()
: document_(rhs.document_), pos_(rhs.pos_) {}

/// Zq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline EditDoc::CharacterIterator<lineBreakPolicy>& EditDoc::CharacterIterator<lineBreakPolicy>::operator =(const CharacterIterator& rhs) throw()
{document_ = rhs.document_; pos_ = rhs.pos_; return *this;}

/// tQƉZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline char_t EditDoc::CharacterIterator<lineBreakPolicy>::operator *() const throw()
{return (pos_.char_ < document_->getLineLength(pos_.line_)) ? document_->getLine(pos_.line_)[pos_.char_] : L'\n';}

/// OuCNgZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline EditDoc::CharacterIterator<lineBreakPolicy>& EditDoc::CharacterIterator<lineBreakPolicy>::operator ++() throw() {
	if(pos_.char_ < document_->getLineLength(pos_.line_)) ++pos_.char_;
	else if(pos_.line_ < document_->getLineCount() - 1) {++pos_.line_; pos_.char_ = 0;}
	return *this;
}

/// uCNgZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline const EditDoc::CharacterIterator<lineBreakPolicy> EditDoc::CharacterIterator<lineBreakPolicy>::operator ++(int) throw()
{CharacterIterator temp(*this); ++*this; return temp;}

/// OufNgZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline EditDoc::CharacterIterator<lineBreakPolicy>& EditDoc::CharacterIterator<lineBreakPolicy>::operator --() throw() {
	if(pos_.char_ != 0) --pos_.char_;
	else if(pos_.line_ > 0) pos_.char_ = document_->getLineLength(--pos_.line_);
	return *this;
}

/// ufNgZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline const EditDoc::CharacterIterator<lineBreakPolicy> EditDoc::CharacterIterator<lineBreakPolicy>::operator --(int) throw()
{CharacterIterator temp(*this); --*this; return temp;}

/// Zq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline bool EditDoc::CharacterIterator<lineBreakPolicy>::operator ==(const EditDoc::CharacterIterator<lineBreakPolicy>& rhs) const throw()
{return pos_ == rhs.pos_;}

/// 񓙉Zq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline bool EditDoc::CharacterIterator<lineBreakPolicy>::operator !=(const EditDoc::CharacterIterator<lineBreakPolicy>& rhs) const throw()
{return !(*this == rhs);}

/// ZZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline EditDoc::CharacterIterator<lineBreakPolicy>& EditDoc::CharacterIterator<lineBreakPolicy>::operator +=(difference_type rhs) throw() {
	while(rhs > 0) {
		if(pos_.char_ + rhs <= document_.getLineLength(pos_.line_)) {pos_.char_ += rhs; return *this;}
		else if(pos_.line_ == document.getLineCount() - 1) {pos_.char_ = document_.getLineLength(pos_.line_); return *this;}
		else {rhs -= document_.getLineLength(pos_.line_) - pos_.char_ + 1; ++pos_.line_; pos_.char_ = 0;}
	}
	return *this;
}

/// ZZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline const EditDoc::CharacterIterator<lineBreakPolicy> EditDoc::CharacterIterator<lineBreakPolicy>::operator +(difference_type rhs) const throw()
{CharacterIterator temp(*this); return temp += rhs;}

/// ZZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline EditDoc::CharacterIterator<lineBreakPolicy>& EditDoc::CharacterIterator<lineBreakPolicy>::operator -=(difference_type rhs) throw() {
	while(rhs > 0) {
		if(rhs <= pos_.char_) {pos_.char_ -= rhs; return *this;}
		else if(pos_.line_ == 0) {pos_.char_ = 0; return *this;}
		else {rhs -= pos_.char_ + 1; pos_.char_ = document_.getLineLength(--pos_.line_);}
		return *this;
	}
}

/// ZZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline const EditDoc::CharacterIterator<lineBreakPolicy>
EditDoc::CharacterIterator<lineBreakPolicy>::operator -(difference_type rhs) const throw()
{CharacterIterator temp(*this); return temp -= rhs;}

/// ZZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline typename EditDoc::CharacterIterator<lineBreakPolicy>::difference_type
EditDoc::CharacterIterator<lineBreakPolicy>::operator -(const EditDoc::CharacterIterator<lineBreakPolicy>& rhs) const throw() {
	if(pos_.line_ == rhs.pos_.line_)
		return pos_.char_ - rhs.pos_.char_;
	difference_type result = 0;
	if(*this > rhs) {
		for(length_t line = rhs.pos_.line_ + 1; line < pos_.line_; ++line)
			result += document_.getLineLength(line) + getLineBreakLength(line);
		result += document_.getLineLength(rhs.pos_.line_) - rhs.pos_.char_ + pos_.char_;
	} else {
		for(length_t line = pos_.line_ + 1; line < rhs.pos_.line_; ++line)
			result += document_.getLineLength(line) + getLineBreakLength(line);
		result += document_.getLineLength(pos_.line_) - pos_.char_ + rhs.pos_.char_;
	}
	return result;
}

/// YZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline EditDoc::CharacterIterator<lineBreakPolicy> EditDoc::CharacterIterator<lineBreakPolicy>::operator [](difference_type index) const throw()
{return *(*this + index);}

/// rZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline bool EditDoc::CharacterIterator<lineBreakPolicy>::operator <(const EditDoc::CharacterIterator<lineBreakPolicy>& rhs) const throw()
{return pos_ < rhs.pos_;}

/// rZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline bool EditDoc::CharacterIterator<lineBreakPolicy>::operator <=(const EditDoc::CharacterIterator<lineBreakPolicy>& rhs) const throw()
{return *this < rhs || *this == rhs;}

/// rZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline bool EditDoc::CharacterIterator<lineBreakPolicy>::operator >(const EditDoc::CharacterIterator<lineBreakPolicy>& rhs) const throw()
{return !(*this <= rhs);}

/// rZq
template<LineBreakRetrievePolicy lineBreakPolicy>
inline bool EditDoc::CharacterIterator<lineBreakPolicy>::operator >=(const EditDoc::CharacterIterator<lineBreakPolicy>& rhs) const throw()
{return !(*this < rhs);}

template<> inline length_t EditDoc::CharacterIterator<LBRP_LINE_FEED>::getLineBreakLength(length_t) const throw() {return 1;}

template<> inline length_t EditDoc::CharacterIterator<LBRP_CRLF>::getLineBreakLength(length_t) const throw() {return 2;}

template<> inline length_t EditDoc::CharacterIterator<LBRP_PHYSICAL_DATA>::getLineBreakLength(length_t line) const throw() {
	return EditDoc::getLineBreakLength(document_->getLineInfo(line).getLineBreak());}

template<> inline length_t EditDoc::CharacterIterator<LBRP_DOCUMENT_DEFAULT>::getLineBreakLength(length_t) const throw() {
	return EditDoc::getLineBreakLength(document_->getLineBreak());}

template<> inline length_t EditDoc::CharacterIterator<LBRP_SKIP>::getLineBreakLength(length_t) const throw() {return 0;}

/// ʒuԂ
template<LineBreakRetrievePolicy lineBreakPolicy>
inline const CharPos& EditDoc::CharacterIterator<lineBreakPolicy>::getPosition() const throw() {return pos_;}

} // namespace Ascension

#endif /* EDIT_DOC_H_ */

/* [EOF] */