// EditPoint.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "EditPoint.h"
#include "EditView.h"
#include "../../Manah/Utility.hpp"

using namespace Ascension;
using namespace Manah;
using namespace Manah::Windows;
using namespace std;


const CharPos CharPos::INVALID_POSITION(-1, -1);


// SynchronizablePoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	@brief _ֈړ
 *
 *	hNX͂̃\bhI[o[Chē_̈ړtbNł
 *	@param pos	ړ
 *	@param forDocumentSynchronization	hLg̍XVɂ_̈ړł true
 */
void SynchronizablePoint::doMoveTo(const CharPos& pos, bool forDocumentSynchronization) {
	assertValid();
	VERIFY_DOCUMENT();
	if(position_ != pos) {
		position_ = pos;
		normalize();
	}
}

/**
 *	_Ɉړ
 *	@param pos ړ
 */
void SynchronizablePoint::moveTo(const CharPos& pos) {
	assertValid();
	VERIFY_DOCUMENT();
	doMoveTo(pos, false);
}

/**
 *	@brief ʒuɈړ
 *
 *	̃\bh͓_̈ړCxgXiɒʒm<strong>Ȃ</strong>
 */
void SynchronizablePoint::normalize() const {
	assertValid();
	VERIFY_DOCUMENT();
	CharPos& position = const_cast<SynchronizablePoint*>(this)->position_;
	position.line_ = min(position.line_, document_->getLineCount() - 1);
	position.char_ = min(position.char_, document_->getLineLength(position.line_));
	if(document_->isNarrowed() && excludedFromRestriction_) {
		position = max(position_, document_->getStartPoint());
		position = min(position_, document_->getEndPoint());
	}
}

/**
 *	hLgύXꂽƂɌĂяo
 *	@param update XVe
 */
void SynchronizablePoint::onUpdateDocument(const DocumentUpdate& update) {
	assertValid();
	if(document_ == 0 || ignoreDocumentUpdate_)
		return;

//	normalize();
	CharPos newPosition = position_;

	// hLg̕ύXɍ킹Ĉʒu𒲐
	if(update.summary == DocumentUpdate::INSERT_OPERATION) {	// }̏ꍇ
		if(position_ < update.first)	// ݈ʒu
			return;
		else if(position_ == update.first && gravity_ == BACKWARD) // ݈ʒu + backward gravity
			return;
		else if(position_.line_ > update.first.line_)	// ݍsO
			newPosition.line_ += update.result.line_ - update.first.line_;
		else {	// ݍsƓs
			newPosition.line_ += update.result.line_ - update.first.line_;
			newPosition.char_ += update.result.char_ - update.first.char_;
		}
	} else if(update.summary == DocumentUpdate::DELETE_OPERATION) {	// 폜̏ꍇ
		if(position_ < update.last)	// ݈ʒu
			return;
		else if(position_.line_ > update.last.line_)	// ݍsO
			newPosition.line_ -= update.last.line_ - update.first.line_;
		else if(position_ >= update.first && position_ <= update.last) {	// ͈͓
			newPosition.line_ = update.first.line_;
			newPosition.char_ = update.first.char_;
		} else {	// I_ݍsƓs
			if(position_.line_ == update.first.line_)	// ͈͂1s
				newPosition.char_ -= update.last.char_ - update.first.char_;
			else {	// ͈͂s
				newPosition.line_ -= update.last.line_ - update.first.line_;
				newPosition.char_ -= update.last.char_ - update.first.char_;
			}
		}
	} else
		return;
	doMoveTo(newPosition, true);
}


// EditPoint class implementation
/////////////////////////////////////////////////////////////////////////////

#define VERIFY_VIEW()					\
	VERIFY_DOCUMENT();					\
	if(getDocument()->getCount() == 0)	\
		throw LayoutNotPreparedException()
#define PREPARE_X()																	\
	if(getView().getLayoutSetter().getSettings().rightAlign == lastX_.fromLeftEnd_)	\
		updateLastX();																\
	const int x = lastX_.fromLeftEnd_ ? lastX_.distance_ :							\
		getView().sharedData_->layoutManager.getLine(newLine).getWidth() - lastX_.distance_

/**
 *	̕Ɉړ
 *	@param offset ړ邩
 */
void EditPoint::charNext(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_DOCUMENT();
	normalize();
	moveTo(getNextCharPos(*this, offset));
}

/**
 *	O̕Ɉړ
 *	@param offset ړ邩
 */
void EditPoint::charPrev(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_DOCUMENT();
	normalize();
	moveTo(getPrevCharPos(*this, offset));
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param length	1̈ʒu܂ł̕ (ł悢)
 *	@param type		ϊ̎
 */
void EditPoint::convert(signed_length_t length, RangeConvertType type) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly() || length == 0)
		return;
	convert((length > 0) ? getNextCharPos(*this, length) : getPrevCharPos(*this, -length), type);
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param pos	1̈ʒu
 *	@param type	ϊ̎ށBw͕s
 */
void EditPoint::convert(const CharPos& pos, RangeConvertType type) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly() || pos == getPosition())
		return;

	// TODO: 
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param length Rs[镶 (ł悢)
 */
void EditPoint::copy(signed_length_t length) {
	assertValid();
	VERIFY_DOCUMENT();
	const string_t text = getText(length);	
	Private::Clipboard(getDocument()->getView(0)).write(text.data(), text.data() + text.length());
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param pos 1̈ʒu
 */
void EditPoint::copy(const CharPos& pos) {
	assertValid();
	VERIFY_DOCUMENT();
	const string_t text = getText(pos);
	Private::Clipboard(getDocument()->getView(0)).write(text.data(), text.data() + text.length());
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param length 폜镶 (ł悢)
 */
void EditPoint::cut(signed_length_t length) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly())
		return;
	const string_t text = getText(length);
	Private::Clipboard(getDocument()->getView(0)).write(text.data(), text.data() + text.length());
	erase(length);
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param pos 1̈ʒu
 */
void EditPoint::cut(const CharPos& pos) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly())
		return;
	const string_t text = getText(pos);
	Private::Clipboard(getDocument()->getView(0)).write(text.data(), text.data() + text.length());
	erase(pos);
}

/**
 *	_̈ʒũeLXg폜ĕ}B݈ʒu͓͕i߂
 *	@param text }eLXg
 */
void EditPoint::destructiveInsert(const string_t& text) {
	assertValid();
	destructiveInsert(text.data(), text.data() + text.length());
}

/**
 *	_̈ʒũeLXg폜ĕ}B݈ʒu͓͕i߂
 *	@param first, last }eLXg
 */
void EditPoint::destructiveInsert(const char_t* first, const char_t* last) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly())
		return;

	EditPoint pos(*this);
	EditDoc& document = *getDocument();

	pos.charNext();
	document.beginEditCollection();
	ignoreDocumentUpdate(true);
	document.deleteText(TextRange(*this, pos));
	moveTo(document.insertText(*this, first, last));
	ignoreDocumentUpdate(false);
	document.endEditCollection();
}

/// @see SynchronizablePoint::doMoveTo
void EditPoint::doMoveTo(const CharPos& pos, bool forDocumentSynchronization) {
	assertValid();
	VERIFY_DOCUMENT();
	if(pos != getPosition()) {
		const CharPos oldPosition = getPosition();
		SynchronizablePoint::doMoveTo(pos, forDocumentSynchronization);
		if(eventListener_ != 0)
			eventListener_->onEditPointMoved(*this, oldPosition);
	}
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param length	1̈ʒu܂ł̕ (ł悢)
 *	@param ccc		̌vZ@BCCC_DEFAULT w肷ƌ݂̐ݒ肪gp
 */
void EditPoint::erase(signed_length_t length /* = 1 */, EditPoint::CharacterCountingConvention ccc /* = CCC_DEFAULT */) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly() || length == 0)
		return;
	erase((length > 0) ? getNextCharPos(*this, length) : getPrevCharPos(*this, -length, CCC_UTF16));
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param pos 1̈ʒu
 */
void EditPoint::erase(const CharPos& pos) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly() || pos == getPosition())
		return;
	ignoreDocumentUpdate(true);
	moveTo(getDocument()->deleteText(TextRange(*this, pos)));
	ignoreDocumentUpdate(false);
}

/// hLg̐擪 (i[COĂꍇ̓ANZX\̈̐擪)
/// ̕Ԃ (UTF-16 PʁAs1)
length_t EditPoint::getAbsoluteCharOffset() const {
	assertValid();
	VERIFY_DOCUMENT();

	const EditDoc& document = *getDocument();
	length_t offset = 0;
	const CharPos start = document.getStartPoint();

	normalize();
	for(length_t line = start.line_; ; ++line) {
		if(line == getLineNumber()) {
			offset += getCharNumber();
			break;
		} else {
			offset += document.getLineLength(line) + 1;	// +1 ͉s
			if(line == start.line_)
				offset -= start.char_;
		}
	}
	return offset;
}

/// ݈ʒũR[h|CgԂBs̏ꍇ͎ۂ̉sR[hɊ֌W 0x000A A
/// ̖̏ꍇ 0xFFFFFFFF Ԃ
CodePoint EditPoint::getCodePoint() const {
	assertValid();
	VERIFY_DOCUMENT();

	const string_t& line = getDocument()->getLine(getLineNumber());
	if(getCharNumber() == line.length())
		return (getLineNumber() == getDocument()->getLineCount() - 1) ? 0xFFFFFFFF : 0x000A;
	return UTF16Surrogates::decode(line.data() + getCharNumber(), line.length() - getCharNumber());
}

/// _s̒Ԃ (UTF-16 P)
length_t EditPoint::getLineLength() const {
	assertValid();
	VERIFY_DOCUMENT();
	normalize();
	return getDocument()->getLineLength(getLineNumber());
}

/**
 *	^ꂽʒuw蕶i񂾈ʒuԂ
 *	@param pt		ʒu
 *	@param length	
 *	@param ccc		vZ@Bȗ @a pt ̐ݒl
 */
CharPos EditPoint::getNextCharPos(const EditPoint& pt,
		length_t length, EditPoint::CharacterCountingConvention ccc /* = CCC_DEFAULT */) {
	const EditDoc&	document = *pt.getDocument();
	const length_t	lineCount = document.getLineCount();
	string_t		line = document.getLine(pt.getLineNumber());
	const char_t* 	p = line.data();
	CharPos			pos = pt;

	if(ccc == CCC_DEFAULT)
		ccc = pt.charCountConvention_;
	while(length-- > 0) {
		if(pos.char_ == line.length()) {	// sȂ̂Ŏ̍sɈړ
			if(pos.line_ == lineCount - 1)	// ŏIsłΈړȂ
				return pos;
			line = document.getLine(++pos.line_);
			p = line.data();
			pos.char_ = 0;
		} else if(ccc == CCC_UTF16)
			++pos.char_;
		else {
			CodePoint cp = UTF16Surrogates::decode(p + pos.char_, line.length() - pos.char_);
			pos.char_ += (cp > 0xFFFF) ? 2 : 1;
			while(ccc == CCC_CLUSTER && pos.char_ < line.length()) {
				cp = UTF16Surrogates::decode(p + pos.char_, line.length() - pos.char_);
				if(!BoundaryDetector::isGraphemeExtend(cp))
					break;
				pos.char_ += (cp > 0xFFFF) ? 2 : 1;
			}
		}
	}
	return pos;
}

/**
 *	^ꂽʒuw蕶߂ʒuԂ
 *	@param pt		ʒu
 *	@param length	
 *	@param ccc		vZ@Bȗ @a pt ̐ݒl
 */
CharPos EditPoint::getPrevCharPos(const EditPoint& pt,
		length_t length, EditPoint::CharacterCountingConvention ccc /* = CCC_DEFAULT */) {
	const EditDoc&	document = *pt.getDocument();
	string_t		line = document.getLine(pt.getLineNumber());
	const char_t*	p = line.data();
	CharPos			pos = pt;

	if(ccc == CCC_DEFAULT)
		ccc = pt.charCountConvention_;
	while(length-- > 0) {
		if(pos.char_ == 0) {	// sȂ̂őO̍sɈړ
			if(pos.line_ == 0)	// 擪słΈړȂ
				return pos;
			line = document.getLine(--pos.line_);
			p = line.data();
			pos.char_ = line.length();
		} else if(ccc == CCC_UTF16 || pos.char_ == 0)
			--pos.char_;
		else {
			CodePoint cp;
			if(UTF16Surrogates::isHighSurrogate(p[pos.char_ - 2])
					&& UTF16Surrogates::isLowSurrogate(p[pos.char_ - 1]))
				cp = UTF16Surrogates::decode(p + pos.char_ - 2, 2);
			else
				cp = p[pos.char_ - 1];
			pos.char_ -= (cp > 0xFFFF) ? 2 : 1;
			while(ccc == CCC_CLUSTER
					&& pos.char_ != 0
					&& BoundaryDetector::isGraphemeExtend(cp)) {
				if(pos.char_ != 1
						&& UTF16Surrogates::isHighSurrogate(p[pos.char_ - 2])
						&& UTF16Surrogates::isLowSurrogate(p[pos.char_ - 1])) {
					cp = UTF16Surrogates::decode(p + pos.char_ - 2, 2);
					pos.char_ -= 2;
				} else {
					cp = p[pos.char_ - 1];
					--pos.char_;
				}
			}
		}
	}
	return pos;
}

/**
 *	͈͓̃eLXgԂ
 *	@param length			1̈ʒu܂ł̕ (ł悢)
 *	@param lineBreakPolicy	s̈ (@a length ̐ɂ͉eȂ̂Œ)
 */
string_t EditPoint::getText(signed_length_t length, LineBreakRetrievePolicy lineBreakPolicy /* = LBRP_PHYSICAL_DATA */) const {
	assertValid();
	VERIFY_DOCUMENT();

	normalize();
	if(length == 0)
		return L"";
	return getText((length > 0) ? getNextCharPos(*this, length) : getPrevCharPos(*this, -length), lineBreakPolicy);
}

/**
 *	͈͓̃eLXgԂ
 *	@param pos				1̈ʒu
 *	@param lineBreakPolicy	s̈
 */
string_t EditPoint::getText(const CharPos& pos, LineBreakRetrievePolicy lineBreakPolicy /* = LBRP_PHYSICAL_DATA */) const {
	assertValid();
	VERIFY_DOCUMENT();

	CharPos position = pos;
	const EditDoc& document = *getDocument();
	
	position.line_ = min(pos.line_, document.getLineCount() - 1);
	normalize();
	if(pos == getPosition())
		return L"";

	const CharPos& start = min(getPosition(), position);
	const CharPos& end = max(getPosition(), position);

	if(start.line_ == end.line_)	// 1s̏ꍇ
		return document.getLine(end.line_).substr(start.char_, end.char_ - start.char_);
	else {	// s̏ꍇ
		ostringstream_t text;
		length_t line = start.line_;
		const string_t* eol = 0;

		switch(lineBreakPolicy) {
		case LBRP_LINE_FEED:
			eol = new string_t(L"\n"); break;
		case LBRP_CRLF:
			eol = new string_t(L"\r\n"); break;
		case LBRP_DOCUMENT_DEFAULT:
			eol = new string_t(document.getLineBreakString(document.getLineBreak())); break;
		case LBRP_SKIP:
			eol = new string_t(L""); break;
		}
		while(true) {
			const EditDoc::Line& s = document.getLineInfo(line);
			if(line == start.line_)	// 擪s
				text << s.getLine().substr(start.char_);
			else if(line == end.line_) {	// ŏIs
				text << s.getLine().substr(0, end.char_);
				break;
			} else
				text << s.getLine();
			if(lineBreakPolicy == LBRP_PHYSICAL_DATA)
				text << EditDoc::getLineBreakString(s.getLineBreak());
			else
				text << *eol;
			++line;
		}
		delete[] eol;
		return text.str();
	}
}

/**
 *	_̈ʒuɕ}B݈ʒu͓͕i߂
 *	@param text }eLXg
 */
void EditPoint::insert(const string_t& text) {
	assertValid();
	insert(text.data(), text.data() + text.length());
}

/**
 *	_̈ʒuɕ}B݈ʒu͓͕i߂
 *	@param first, last }eLXg
 */
void EditPoint::insert(const char_t* first, const char_t* last) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly())
		return;
	ignoreDocumentUpdate(true);
	moveTo(getDocument()->insertText(*this, first, last));
	ignoreDocumentUpdate(false);
}

/// ݈ʒuhLg̏I[ł邩ǂԂ
bool EditPoint::isEndOfDocument() const {
	assertValid();
	VERIFY_DOCUMENT();
	normalize();
	return isExcludedFromRestriction() ?
		getPosition() == getDocument()->getEndPoint()
		: getLineNumber() == getDocument()->getLineCount() - 1
			&& getCharNumber() == getDocument()->getLineLength(getLineNumber());
}

/// ݈ʒusł邩ǂԂ
bool EditPoint::isEndOfLine() const {
	assertValid();
	VERIFY_DOCUMENT();
	normalize();
	const CharPos end = getDocument()->getEndPoint();
	normalize();
	if(isExcludedFromRestriction())
		return (end.line_ == getLineNumber()) ?
			getCharNumber() == end.char_ : getCharNumber() == getDocument()->getLineLength(getLineNumber());
	else
		return getCharNumber() == getDocument()->getLineLength(getLineNumber());
}

/// ݈ʒuhLg̐擪ł邩ǂԂ
bool EditPoint::isStartOfDocument() const {
	assertValid();
	VERIFY_DOCUMENT();
	normalize();
	return isExcludedFromRestriction() ? getPosition() == getDocument()->getStartPoint() : getPosition() == CharPos(0, 0);
}

/// ݈ʒusł邩ǂԂ
bool EditPoint::isStartOfLine() const {
	assertValid();
	VERIFY_DOCUMENT();
	const CharPos start = getDocument()->getStartPoint();
	normalize();
	if(isExcludedFromRestriction())
		return (start.line_ == getLineNumber()) ? start.char_ == getCharNumber() : getCharNumber() == 0;
	else
		return getCharNumber() == 0;
}

/**
 *	hLg擪̕Ŏw肵ʒuɈړ
 *	@param offset hLg擪̕
 */
void EditPoint::moveToAbsoluteCharOffset(length_t offset) {
	assertValid();
	VERIFY_DOCUMENT();

	const EditDoc& document = *getDocument();
	length_t readCount = 0;
	const CharPos start = document.getStartPoint();
	const CharPos end = document.getEndPoint();

	if(document.getLineLength(start.line_) + 1 - start.char_ >= offset) {
		moveTo(CharPos(start.line_, start.char_ + offset));
		return;
	}
	readCount += document.getLineLength(start.line_) + 1 - start.char_;
	for(length_t line = start.line_ + 1; line <= end.line_; ++line) {
		const length_t lineLength = document.getLineLength(line) + 1;	// +1 ͉s
		if(readCount + lineLength >= offset) {
			moveTo(CharPos(line, readCount + lineLength - offset));
			return;
		}
		readCount += lineLength;
	}
	moveTo(CharPos(end.line_, document.getLineLength(end.line_)));
}

/// hLg̏I[Ɉړ
void EditPoint::moveToEndOfDocument() {
	const length_t lineCount = getDocument()->getLineCount();
	moveTo(CharPos(lineCount - 1, getDocument()->getLineLength(lineCount - 1)));
}

/// sɈړ
void EditPoint::moveToEndOfLine() {
	moveTo(CharPos(min(getLineNumber(), getDocument()->getLineCount() - 1), getDocument()->getLineLength(getLineNumber())));
}

/// hLg̐擪Ɉړ
void EditPoint::moveToStartOfDocument() {
	moveTo(CharPos(0, 0));
}

/// sɈړ
void EditPoint::moveToStartOfLine() {
	moveTo(CharPos(min(getLineNumber(), getDocument()->getLineCount() - 1), 0));
}

/// s
void EditPoint::newLine() {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly())
		return;
	insert(EditDoc::getLineBreakString(getDocument()->getLineBreak()));
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param length 1̈ʒu܂ł̕ (ł悢)
 */
void EditPoint::paste(signed_length_t length /* = 0 */) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly() || length == 0) {
		paste(getPosition());
		return;
	}
	paste((length > 0) ? getNextCharPos(*this, length) : getPrevCharPos(*this, -length, CCC_UTF16));
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param pos 1̈ʒu
 */
void EditPoint::paste(const CharPos& pos) {
	assertValid();
	VERIFY_DOCUMENT();

	if(getDocument()->isReadOnly())
		return;
	else if(const UINT availableClipFormat = EditView::canPaste()) {
		if(pos != getPosition())
			erase(pos);
		Private::Clipboard clipboard(getDocument()->getView(0));
		if(Private::Clipboard::Text text = clipboard.read()) {
			const char_t* const data = text.getData();
			insert(data, data + wcslen(data));
		}
	}
}


// VisualPoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	w͈͂r[̒ɂȂ悤ɃXN[BɉȂ牽Ȃ
 *	@param view						Ώۃr[
 *	@param length					͈͂\̓_܂ł̕
 *	@return							͈͂r[ɔ[܂ꍇ true Ԃ
 *	@throw std::invalid_argument	@a view 쐬hLgɊ܂܂ĂȂ΃X[
 */
bool VisualPoint::center(EditView& view, signed_length_t length /* = 0 */) {
	assertValid();
	VERIFY_DOCUMENT();
	if(&view.getDocument() != getDocument())
		throw invalid_argument("Specified view does not belong to the document created this point.");
	return center(view, (length >= 0) ? getNextCharPos(*this, length) : getPrevCharPos(*this, -length));
}

/**
 *	w͈͂r[̒ɂȂ悤ɃXN[BɉȂ牽Ȃ
 *	@param view	Ώۃr[
 *	@param pos	͈͂\̓_
 *	@return		͈͂r[ɔ[܂ꍇ true Ԃ (ɂ true)
 *	@throw std::invalid_argument	@a view 쐬hLgɊ܂܂ĂȂ΃X[
 */
bool VisualPoint::center(EditView& view, const CharPos& pos) {
	assertValid();
	VERIFY_DOCUMENT();
	if(&view.getDocument() != getDocument())
		throw invalid_argument("Specified view does not belong to the document created this point.");

	view.sendMessage(WM_HSCROLL, MAKEWPARAM(SB_LEFT, 0));
	view.sendMessage(WM_VSCROLL, MAKEWPARAM(SB_SETPOS,
		view.displayCharFromLogicalChar(getPosition()).line_ - view.getVisibleLineCount() / 2));

	return true;
}

/**
 *	̕Ɉړ
 *	@param offset ړ邩
 */
void VisualPoint::charLeft(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	moveTo(!getView().getLayoutSetter().getSettings().rightToLeftReading ?
		getPrevCharPos(*this, offset) : getNextCharPos(*this, offset));
}

/**
 *	E̕Ɉړ
 *	@param offset ړ邩
 */
void VisualPoint::charRight(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	moveTo(!getView().getLayoutSetter().getSettings().rightToLeftReading ?
		getNextCharPos(*this, offset) : getPrevCharPos(*this, offset));
}

/// @see EditPoint::DoMoveTo
void VisualPoint::doMoveTo(const CharPos& pos, bool forDocumentSynchronization) {
	assertValid();
	VERIFY_VIEW();
	EditPoint::doMoveTo(pos, forDocumentSynchronization);
	if(lastX_.dontUpdateNext_)	lastX_.dontUpdateNext_ = false;
	else						updateLastX();
}

/// \̗ԍ (ԍ) Ԃ
length_t VisualPoint::getColumnNumber() const {
	assertValid();
	VERIFY_VIEW();
	return getView().columnFromChar(getPosition());
}

/// Ώۂ̃r[𓾂
const EditView& VisualPoint::getView() const {
	assert(getDocument() != 0 && getDocument()->getCount() != 0);
	return getDocument()->getView(0);	// [...
}

/**
 *	͈͓̃eLXgCfg
 *	@param pos			1̈ʒu
 *	@param character	CfgɎg
 *	@param box			`Cfg (Cfgx̂Ƃ͖)
 *	@param level		Cfgx
 *	@return				̌ @a pos ړƂ悢ʒu
 */
CharPos VisualPoint::doIndent(const CharPos& pos, char_t character, bool box, long level) {
	assertValid();
	VERIFY_VIEW();

	EditDoc& document = *getDocument();

	if(document.isReadOnly() || level == 0)
		return pos;

	const string_t	indent = string_t(abs(level), character);
	const TextRange	range(*this, pos);

	if(range.getTop().line_ == range.getBottom().line_) {	// I1sȓ -> Pȕ}
		document.deleteText(range);
		document.insertText(range.getTop(), indent);
		return getPosition();
	}

	const CharPos	oldPosition = getPosition();
	const Lexer&	lexer = getView().getLexer();
	CharPos			otherResult = pos;
	length_t		line = range.getTop().line_;

	ignoreDocumentUpdate(true);

	// ŏ̍s (t) Cfg
	if(level > 0) {
		document.insertText(CharPos(line, box ? range.getTop().char_ : 0), indent);
		if(line == otherResult.line_ && otherResult.char_ != 0)
			otherResult.char_ += level;
		if(line == getLineNumber() && getCharNumber() != 0)
			moveTo(getLineNumber(), getCharNumber() + level);
	} else {
		const char_t* const p = document.getLine(line).data();
		const length_t indentLength = lexer.eatWhiteSpaces(p, p + document.getLineLength(line), true) - p;
		if(indentLength > 0) {
			const length_t deleteLength = min<length_t>(-level, indentLength);
			document.deleteText(CharPos(line, 0), CharPos(line, deleteLength));
			if(line == otherResult.line_ && otherResult.char_ != 0)
				otherResult.char_ -= deleteLength;
			if(line == getLineNumber() && getCharNumber() != 0)
				moveTo(getLineNumber(), getCharNumber() - deleteLength);
		}
	}

	// ÎSĂ̍s (t) Cfg
	if(level > 0) {
		for(++line; line <= range.getBottom().line_; ++line) {
			if(document.getLineLength(line) != 0 && (line != range.getBottom().line_ || range.getBottom().char_ > 0)) {
				length_t insertPosition = 0;
				if(box)
					getView().getSelection().getRangeOnLine(line, &insertPosition, 0);
				document.insertText(CharPos(line, insertPosition), indent);
				if(line == otherResult.line_ && otherResult.char_ != 0)
					otherResult.char_ += level;
				if(line == getLineNumber() && getCharNumber() != 0)
					moveTo(getLineNumber(), getCharNumber() + level);
			}
		}
	} else {
		for(++line; line <= range.getBottom().line_; ++line) {
			const char_t* const p = document.getLine(line).data();
			const length_t indentLength = lexer.eatWhiteSpaces(p, p + document.getLineLength(line), true) - p;
			if(indentLength > 0) {
				const length_t deleteLength = min<length_t>(-level, indentLength);
				document.deleteText(CharPos(line, 0), CharPos(line, deleteLength));
				if(line == otherResult.line_ && otherResult.char_ != 0)
					otherResult.char_ -= deleteLength;
				if(line == getLineNumber() && getCharNumber() != 0)
					moveTo(getLineNumber(), getCharNumber() - deleteLength);
			}
		}
	}

	ignoreDocumentUpdate(false);
	if(eventListener_ != 0)
		eventListener_->onEditPointMoved(*this, oldPosition);
	return otherResult;
}

/**
 *	_̈ʒuɕ`}B݈ʒu͓͕i߂
 *	@param text }eLXg
 */
void VisualPoint::insertBox(const string_t& text) {
	assertValid();
	insertBox(text.data(), text.data() + text.length());
}

/**
 *	_̈ʒuɕ`}B݈ʒu͓͕i߂
 *	@param first, last }eLXg
 */
void VisualPoint::insertBox(const char_t* first, const char_t* last) {
	assertValid();
	VERIFY_VIEW();

	EditDoc& document = *getDocument();

	if(document.isReadOnly() || first == last)
		return;

	const length_t lineCount = document.getLineCount();
	const string_t breakString = EditDoc::getLineBreakString(document.getLineBreak());
	list<const char_t*>	lines;

	// sʒũXg
	lines.push_back(first);
	for(const char_t* p = first; p != last; ) {
		p = find_first_of(p, last, EditDoc::BREAK_CHARS, endof(EditDoc::BREAK_CHARS));
		p += (*p == L'\r' && p < last - 1 && *(p + 1) == L'\n') ? 2 : 1;
		lines.push_back(p);
	}

	length_t i = getLineNumber();	// }s
	string_t line;					// }sƂȂ镔
	const int xFirstLineInsert =	// }擪s̑}ʒu (s[̈ʒu)
		getView().sharedData_->layoutManager.getLine(i).getCaretPosition(getCharNumber());
	for(list<const char_t*>::const_iterator it = lines.begin(); it != lines.end(); ++it, ++i) {
		if(*it == lines.back())	// ŏIs
			line.assign(*it, last);
		else {
			++it;
			length_t lineLength = *it - first - ((*(*it - 1) == L'\n' && *(*it - 2) == L'\r') ? 2 : 1);
			lineLength -= *(--it) - first;
			line.assign(*it, lineLength);
		}
		if(i >= lineCount - 1 && *it != lines.back())	// }ʒuɍs݂Ȃꍇ͍쐬
			line += breakString;

		if(!line.empty())
			moveTo(document.insertText(CharPos(i,
				getView().mapAbsoluteXToCharacter(i, xFirstLineInsert,
					!getView().sharedData_->options.behavior[BooleanOptions::ACCEPT_CARET_ON_EXTENDER_BY_MOUSE])),
					getView().calculateSpacesReachingVirtualPoint(i, xFirstLineInsert) + line));
	}
}

/// ݈ʒus̍ŏ̕ł邩Ԃ
bool VisualPoint::isFirstCharOfLine() const {
	assertValid();
	VERIFY_VIEW();
	normalize();
	const CharPos start = isExcludedFromRestriction() ? getDocument()->getStartPoint() : CharPos(0, 0);
	const length_t offset = (start.line_ == getLineNumber()) ? start.char_ : 0;
	const string_t& line = getDocument()->getLine(getLineNumber());
	return line.data() + getCharNumber() - offset
		== getView().getLexer().eatWhiteSpaces(line.data() + offset, line.data() + line.length(), true);
}

/// ݈ʒus̍Ō̕ł邩Ԃ
bool VisualPoint::isLastCharOfLine() const {
	assertValid();
	VERIFY_VIEW();
	normalize();
	const CharPos end = isExcludedFromRestriction() ?
		getDocument()->getEndPoint()
		: CharPos(getDocument()->getLineCount() - 1, getDocument()->getLineLength(getDocument()->getLineCount() - 1));
	const string_t& line = getDocument()->getLine(getLineNumber());
	const length_t lineLength = (end.line_ == getLineNumber()) ? end.char_ : line.length();
	return line.data() + lineLength - getCharNumber()
		== getView().getLexer().eatWhiteSpaces(line.data() + getCharNumber(), line.data() + lineLength, true);
}

/**
 *	̍sɈړ
 *	@param offset ړs
 */
void VisualPoint::lineDown(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	const length_t newLine = min(getLineNumber() + offset,
		isExcludedFromRestriction() ? getDocument()->getEndPoint().line_ : getDocument()->getLineCount() - 1);
	if(newLine != getLineNumber()) {
		PREPARE_X();
		lastX_.dontUpdateNext_ = true;
		moveTo(CharPos(newLine, getView().mapAbsoluteXToCharacter(newLine, x, getCharacterCountingConvention() != CCC_UTF16)));
	}
}

/**
 *	O̍sɈړ
 *	@param offset ړs
 */
void VisualPoint::lineUp(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	const length_t topLine = isExcludedFromRestriction() ? getDocument()->getStartPoint().line_ : 0;
	const length_t newLine = (getLineNumber() > offset) ? max(getLineNumber() - offset, topLine) : 0;
	if(newLine != getLineNumber()) {
		PREPARE_X();
		lastX_.dontUpdateNext_ = true;
		moveTo(CharPos(newLine, getView().mapAbsoluteXToCharacter(newLine, x, getCharacterCountingConvention() != CCC_UTF16)));
	}
}

/// s̍ŏ̕Ɉړ
void VisualPoint::moveToFirstCharOfLine() {
	assertValid();
	VERIFY_VIEW();
	const length_t line = min(getLineNumber(),
		isExcludedFromRestriction() ? getDocument()->getEndPoint().line_ : getDocument()->getLineCount() - 1);
	const char_t* const p = getDocument()->getLine(line).data();
	moveTo(CharPos(line, getView().getLexer().eatWhiteSpaces(p, p + getDocument()->getLineLength(line), true) - p));
}

/// s̍Ō̕Ɉړ
void VisualPoint::moveToLastCharOfLine() {
	assertValid();
	VERIFY_VIEW();
	const length_t line = min(getLineNumber(),
		isExcludedFromRestriction() ? getDocument()->getEndPoint().line_ : getDocument()->getLineCount() - 1);
	const length_t lineLength = getDocument()->getLineLength(line);
	const char_t* const p = getDocument()->getLine(line).data();

	for(length_t spaceLength = 0; spaceLength < lineLength; ++spaceLength) {
		if(getView().getLexer().isWhiteSpace(p[lineLength - spaceLength - 1], true)) {
			moveTo(CharPos(line, lineLength - spaceLength));
			return;
		}
	}
	moveTo(CharPos(line, lineLength));
}

/**
 *	̃ubN}[Ns̍sɈړ
 *	@return ubN}[NȂꍇ false
 */
bool VisualPoint::moveToNextBookmark() {
	assertValid();
	VERIFY_VIEW();

	const Bookmarker& bookmarks = getView().getBookmarker();
	length_t line;
	const length_t endLine = getDocument()->getEndPoint().line_;

	// T
	for(line = getLineNumber() + 1; line <= endLine; ++line) {
		if(bookmarks.isBookmarked(line)) {
			moveTo(CharPos(line, 0));
			return true;
		}
	}

	// Ȃΐ܂Ԃ
	for(line = getDocument()->getStartPoint().line_; line < getLineNumber(); ++line) {
		if(bookmarks.isBookmarked(line)) {
			moveTo(CharPos(line, 0));
			return true;
		}
	}

	return false;
}

/**
 *	ÕubN}[Ns̍sɈړ
 *	@return ubN}[NȂꍇ @c false
 */
bool VisualPoint::moveToPrevBookmark() {
	assertValid();
	VERIFY_VIEW();

	const Bookmarker& bookmarks = getView().getBookmarker();
	length_t line = getLineNumber();
	const length_t startLine = getDocument()->getStartPoint().line_;

	// T
	while(line-- != startLine) {
		if(bookmarks.isBookmarked(line)) {
			moveTo(CharPos(line, 0));
			return true;
		}
	}

	// Ȃΐ܂Ԃ
	for(line = getDocument()->getEndPoint().line_; line > getLineNumber(); --line) {
		if(bookmarks.isBookmarked(line)) {
			moveTo(CharPos(line, 0));
			return true;
		}
	}

	return false;
}

/// sBݒɂăX}[gCfgAubNCfgs
void VisualPoint::newLine() {
	assertValid();
	VERIFY_VIEW();

	if(getDocument()->isReadOnly())
		return;

	string_t breakString = EditDoc::getLineBreakString(getDocument()->getLineBreak());
	bool doneSmartIndent = false;	// X}[gCfg

//	if(getView().sharedData_->options.autoIndentType == AIT_SMART)
//		doneSmartIndent = smartIndent(L'\n');
	if(!doneSmartIndent && getView().sharedData_->options.autoIndentType == AIT_BLOCK) {	// I[gCfg
		const string_t& currentLine = getDocument()->getLine(getLineNumber());
		const length_t len = getView().getLexer().eatWhiteSpaces(
			currentLine.data(), currentLine.data() + getCharNumber(), true) - currentLine.data();
		breakString += currentLine.substr(0, len);
	}
	if(!doneSmartIndent)
		insert(breakString);
}

/**
 *	̃y[WɈړ
 *	@param offset ړy[W
 */
void VisualPoint::pageDown(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	lineDown((getView().getVisibleLineCount() - 1) * offset);
}

/**
 *	Õy[WɈړ
 *	@param offset ړy[W
 */
void VisualPoint::pageUp(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	lineUp((getView().getVisibleLineCount() - 1)* offset);
}

/// @see EditPoint::Paste
void VisualPoint::paste(const CharPos& pos) {
	assertValid();
	VERIFY_VIEW();

	if(getDocument()->isReadOnly())
		return;
	else if(const UINT availableClipFormat = EditView::canPaste()) {
		if(pos != getPosition())
			erase(pos);

		Private::Clipboard clipboard(getView());
		if(Private::Clipboard::Text text = clipboard.read()) {
			const char_t* const data = text.getData();
			if(availableClipFormat == ::RegisterClipboardFormatW(ASCENSION_RECTANGLE_TEXT_CLIP_FORMAT))
				insertBox(data, data + wcslen(data));
			else
				insert(data, data + wcslen(data));
		}
	}
}

/**
 *	w͈͂ɂȂ悤Ƀr[XN[
 *	@param view		Ώۃr[
 *	@param length	͈͂\̓_܂ł̕
 *	@return			͈͂r[ɔ[܂ꍇ true Ԃ (ɂ true)
 */
bool VisualPoint::reveal(EditView& view, signed_length_t length /* = 0 */) {
	assertValid();
	VERIFY_DOCUMENT();
	return reveal(view, (length >= 0) ? getNextCharPos(*this, length) : getPrevCharPos(*this, -length));
}

/**
 *	_ɂȂ悤Ƀr[XN[
 *	@param view	Ώۃr[
 *	@param pos	͈͂\̓_
 *	@return		͈͂r[ɔ[܂ꍇ true Ԃ (ɂ true)
 */
bool VisualPoint::reveal(EditView& view, const CharPos& pos) {
	assertValid();
	VERIFY_DOCUMENT();
	if(&view.getDocument() != getDocument())
		throw invalid_argument("Specified view does not belong to the document created this point.");

	const LineLayoutManager& layout = view.sharedData_->layoutManager;
	const CharPos displayPosition = view.displayCharFromLogicalChar(getPosition());
	const length_t visibleLineCount = view.getVisibleLineCount();
	const length_t visibleCharCount = view.getVisibleCharCount();

	// 
	if(displayPosition.line_ < view.scrollInfo_.position.y * view.getScrollRatio(false))	// ʂ
		view.onVScroll(SB_SETPOS,
			static_cast<UINT>(displayPosition.line_ * view.getScrollRatio(false)), 0);
	else if(displayPosition.line_ - view.scrollInfo_.position.y * view.getScrollRatio(false) > visibleLineCount - 1)	// ʂ艺
		view.onVScroll(SB_SETPOS,
			static_cast<UINT>((displayPosition.line_ - visibleLineCount + 1) * view.getScrollRatio(false)), 0);

	// 
	if(layout.getSettings().wrapMode == WPM_NONE) {
		const LineLayout& line = layout.getLine(getLineNumber());
		const ulong x = !layout.getSettings().rightAlign ?	// Œs̍[̋
			line.getCaretPosition(getCharNumber())
			: layout.getLongestLineWidth() - line.getWidth() + line.getCaretPosition(getCharNumber());
		const ulong scrollOffset = view.getScrollPos(SB_HORZ) * view.getScrollRatio(true) * layout.getAverageCharacterWidth();

		if(x <= scrollOffset)	// ʂ荶
			view.onHScroll(SB_SETPOS, x / layout.getAverageCharacterWidth() - visibleCharCount / 4, 0);
		else if(x > (view.getScrollPos(SB_HORZ) * view.getScrollRatio(true)
				+ visibleCharCount) * layout.getAverageCharacterWidth())	// ʂE
			view.onHScroll(SB_SETPOS, x / layout.getAverageCharacterWidth() - visibleCharCount * 3 / 4, 0);
	} else {
		// ...
	}

	return true;
}

/**
 *	͈͓̃eLXgXy[XCfg
 *	@param pos		1̈ʒu
 *	@param box		`Cfg (CfgxłΖ)
 *	@param level	Cfgx
 *	@return			Cfg @a pos ړׂʒu
 */
CharPos VisualPoint::spaceIndent(const CharPos& pos, bool box, long level /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	return doIndent(pos, L' ', box, level);
}

/**
 *	͈͓̃eLXg^uCfg
 *	@param pos		1̈ʒu
 *	@param box		`Cfg (CfgxłΖ)
 *	@param level	Cfgx
 *	@return			Cfg @a pos ړׂʒu
 */
CharPos VisualPoint::tabIndent(const CharPos& pos, bool box, long level /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	return doIndent(pos, L'\t', box, level);
}

/**
 *	@brief O̕ւ
 *
 *	̃\bh͕NX^PʂŃeLXgւB
 *	݈ʒuNX^̐擪łȂΏ͎sB
 *	ւΏۂݍsɖꍇ͎s
 *
 *	@return ւȂꍇ false
 */
bool VisualPoint::transposeChars() {
	assertValid();
	VERIFY_VIEW();

#define IS_RESTRICTION(position)	(position < top || position > bottom)

	if(getDocument()->isReadOnly())
		return false;

	// As transposing characters in string "ab":
	//
	//  a b -- transposing clusters 'a' and 'b'. result is "ba"
	// ^ ^ ^
	// | | next-cluster (named pos[2])
	// | middle-cluster (named pos[1]; usually current-position)
	// previous-cluster (named pos[0])

	CharPos pos[3];
	const CharPos top = getDocument()->getStartPoint();
	const CharPos bottom = getDocument()->getEndPoint();

	if(BoundaryDetector::isGraphemeExtend(getCodePoint()))	// NX^̐擪łȂ
		return false;
	else if(IS_RESTRICTION(getPosition()))	// ANZXs\̈
		return false;

	const DocumentBoundaryDetector& boundary = getView().getBoundaryDetector();
	if(getCharNumber() == 0 || getPosition() == top) {
		pos[0] = getPosition();
		pos[1] = boundary.searchGraphemeBase(pos[0], true);
		if(pos[1].line_ != pos[0].line_ || pos[1] == pos[0] || IS_RESTRICTION(pos[1]))
			return false;
		pos[2] = boundary.searchGraphemeBase(pos[1], true);
		if(pos[2].line_ != pos[1].line_ || pos[2] == pos[1] || IS_RESTRICTION(pos[2]))
			return false;
	} else if(getCharNumber() == getDocument()->getLineLength(getLineNumber()) || getPosition() == bottom) {
		pos[2] = getPosition();
		pos[1] = boundary.searchGraphemeBase(pos[2], false);
		if(pos[1].line_ != pos[2].line_ || pos[1] == pos[2] || IS_RESTRICTION(pos[1]))
			return false;
		pos[0] = boundary.searchGraphemeBase(pos[1], false);
		if(pos[0].line_ != pos[1].line_ || pos[0] == pos[1] || IS_RESTRICTION(pos[0]))
			return false;
	} else {
		pos[1] = getPosition();
		pos[2] = boundary.searchGraphemeBase(pos[1], true);
		if(pos[2].line_ != pos[1].line_ || pos[2] == pos[1] || IS_RESTRICTION(pos[2]))
			return false;
		pos[0] = boundary.searchGraphemeBase(pos[1], false);
		if(pos[0].line_ != pos[1].line_ || pos[0] == pos[1] || IS_RESTRICTION(pos[0]))
			return false;
	}

	moveTo(getLineNumber(), pos[1].char_);
	string_t str = getText(pos[2]);
	moveTo(getLineNumber(), pos[0].char_);
	str += getText(pos[1]);
	erase(pos[2]);
	insert(str);

	return true;

#undef IS_POSITION
}

/**
 *	ݍsƑO̍s (ݍs擪s̏ꍇ͎̍s) ւBsR[h͌Ȃ
 *	@return ւȂꍇ false
 */
bool VisualPoint::transposeLines() {
	assertValid();
	VERIFY_VIEW();

	if(getDocument()->isReadOnly())
		return false;

	const CharPos top = getDocument()->getStartPoint();
	const CharPos bottom = getDocument()->getEndPoint();

	if(top.line_ == bottom.line_)	// 1s
		return false;

	if(getLineNumber() == top.line_)
		moveTo(getLineNumber() + 1, getCharNumber());

	const string_t str1 = (getLineNumber() - 1 == top.line_) ?
		getDocument()->getLine(getLineNumber() - 1).substr(top.char_) : getDocument()->getLine(getLineNumber() - 1);
	const string_t str2 = (getLineNumber() == bottom.line_) ?
		getDocument()->getLine(getLineNumber()).substr(0, bottom.char_) : getDocument()->getLine(getLineNumber());

	// 2sƂɂ
	if(!str2.empty()) {
		moveToStartOfLine();
		erase(static_cast<signed_length_t>(str2.length()), CCC_UTF16);
	}
	if(!str1.empty()) {
		moveTo(getLineNumber() - 1, (getLineNumber() == top.line_) ? top.char_ : 0);
		erase(static_cast<signed_length_t>(str1.length()), CCC_UTF16);
		moveTo(getLineNumber() + 1, getCharNumber());
	}

	// sɏ
	if(!str1.empty()) {
		moveToStartOfLine();
		insert(str1);
	}
	moveTo(getLineNumber() - 1, getCharNumber());
	if(!str2.empty()) {
		moveTo(getLineNumber(), (getLineNumber() == top.line_) ? top.char_ : 0);
		insert(str2);
	}
	moveTo(CharPos(getLineNumber() + 2, 0));

	return true;
}

/**
 *	O̒Pւ
 *	@return ւȂꍇ false
 */
bool VisualPoint::transposeWords() {
	assertValid();
	VERIFY_VIEW();

	if(getDocument()->isReadOnly())
		return false;

	// As transposing words in string "(\w+)[^\w*](\w+)":
	//
	//  abc += xyz -- transposing words "abc" and "xyz". result is "xyz+=abc"
	// ^   ^  ^   ^
	// |   |  |   2nd-word-end (named pos[3])
	// |   |  2nd-word-start (named pos[2])
	// |   1st-word-end (named pos[1])
	// 1st-word-start (named pos[0])

	const DocumentBoundaryDetector& boundary = *getView().boundaryDetector_;
	const CharPos top = getDocument()->getStartPoint();
	const CharPos bottom = getDocument()->getEndPoint();
	CharPos pos[4];

	// ܂O̒P (1st-word-*) T
	pos[0] = boundary.searchWordBoundary(getPosition(), false,
		static_cast<BoundaryDetector::SearchPart>(BoundaryDetector::WORD_START | BoundaryDetector::RESTRICTION_EFFECTIVE));
	pos[1] = boundary.searchWordBoundary(pos[0], true,
		static_cast<BoundaryDetector::SearchPart>(BoundaryDetector::WORD_END | BoundaryDetector::RESTRICTION_EFFECTIVE));
	if(pos[1] == pos[0])	// Pꂪ
		return false;

	// Ɍ̒P (2nd-word-*) T
	pos[2] = boundary.searchWordBoundary(getPosition(), true,
		static_cast<BoundaryDetector::SearchPart>(BoundaryDetector::WORD_START | BoundaryDetector::RESTRICTION_EFFECTIVE));
	if(pos[2] == getPosition())
		return false;
	pos[3] = boundary.searchWordBoundary(pos[2], true,
		static_cast<BoundaryDetector::SearchPart>(BoundaryDetector::WORD_END | BoundaryDetector::RESTRICTION_EFFECTIVE));
	if(pos[2] == pos[3])	// Pꂪ
		return false;

	// u
	moveTo(pos[2]);
	string_t str = getText(pos[3]);
	moveTo(pos[1]);
	str += getText(pos[2]);
	moveTo(pos[0]);
	str += getText(pos[1]);
	erase(pos[3]);
	insert(str);

	return true;
}

/// lastX_ ݈ʒuɍXV
inline void VisualPoint::updateLastX() {
	assertValid();
	if(!isDocumentDisposed()) {
		const LineLayoutManager& layout = getView().sharedData_->layoutManager;
		const LineLayout& line = layout.getLine(getLineNumber());
		lastX_.fromLeftEnd_ = !layout.getSettings().rightAlign;
		lastX_.distance_ = lastX_.fromLeftEnd_ ?
			line.getCaretPosition(getCharNumber()) : line.getWidth() - line.getCaretPosition(getCharNumber());
	}
}

/**
 *	̒P̖Ɉړ
 *	@param offset	ړPꐔ
 */
void VisualPoint::wordEndLeft(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	CharPos pos = getPosition();
	while(offset-- != 0)
		pos = getView().boundaryDetector_->searchWordBoundary(pos,
			getView().getLayoutSetter().getSettings().rightToLeftReading, BoundaryDetector::END);
	moveTo(pos);
}

/**
 *	̒P̖Ɉړ
 *	@param offset ړPꐔ
 */
void VisualPoint::wordEndNext(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	CharPos pos = getPosition();
	while(offset-- != 0)
		pos = getView().boundaryDetector_->searchWordBoundary(pos, true, BoundaryDetector::END);
	moveTo(pos);
}

/**
 *	O̒P̖Ɉړ
 *	@param offset ړPꐔ
 */
void VisualPoint::wordEndPrev(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	CharPos pos = getPosition();
	while(offset-- != 0)
		pos = getView().boundaryDetector_->searchWordBoundary(pos, false, BoundaryDetector::END);
	moveTo(pos);
}

/**
 *	E̒P̖Ɉړ
 *	@param offset ړPꐔ
 */
void VisualPoint::wordEndRight(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	CharPos pos = getPosition();
	while(offset-- != 0)
		pos = getView().boundaryDetector_->searchWordBoundary(pos,
		!getView().getLayoutSetter().getSettings().rightToLeftReading, BoundaryDetector::END);
	moveTo(pos);
}

/**
 *	̒P̐擪Ɉړ
 *	@param offset ړPꐔ
 */
void VisualPoint::wordLeft(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	CharPos pos = getPosition();
	while(offset-- != 0)
		pos = getView().boundaryDetector_->searchWordBoundary(pos,
		getView().getLayoutSetter().getSettings().rightToLeftReading, BoundaryDetector::START);
	moveTo(pos);
}

/**
 *	̒P̐擪Ɉړ
 *	@param offset ړPꐔ
 */
void VisualPoint::wordNext(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	CharPos pos = getPosition();
	while(offset-- != 0)
		pos = getView().boundaryDetector_->searchWordBoundary(pos, true, BoundaryDetector::START);
	moveTo(pos);
}

/**
 *	O̒P̐擪Ɉړ
 *	@param offset ړPꐔ
 */
void VisualPoint::wordPrev(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	CharPos pos = getPosition();
	while(offset-- != 0)
		pos = getView().boundaryDetector_->searchWordBoundary(pos, false, BoundaryDetector::START);
	moveTo(pos);
}

/**
 *	E̒P̐擪Ɉړ
 *	@param offset ړPꐔ
 */
void VisualPoint::wordRight(length_t offset /* = 1 */) {
	assertValid();
	VERIFY_VIEW();
	normalize();
	CharPos pos = getPosition();
	while(offset-- != 0)
		pos = getView().boundaryDetector_->searchWordBoundary(pos,
			!getView().getLayoutSetter().getSettings().rightToLeftReading, BoundaryDetector::START);
	moveTo(pos);
}


// Caret class implementation
/////////////////////////////////////////////////////////////////////////////

/// @see VisualPoint::doMoveTo
void Caret::doMoveTo(const CharPos& pos, bool forDocumentSynchronization) {
	const TextRange oldRange(anchorPoint_, *this);

	if(synchronizeAnchor_) {	// AJ[ꏏɓ
		synchronizeAnchor_ = false;
		anchorPoint_.moveTo(pos);
	}
	VisualPoint::doMoveTo(pos, forDocumentSynchronization);
	if((oldRange.pos1_ != pos || oldRange.pos2_ != pos) && caretListener_ != 0)
		caretListener_->onCaretMoved(*this, anchorPoint_, oldRange, forDocumentSynchronization);
}


#undef VERIFY_VIEW
#undef PREPARE_X

/* [EOF] */