// EditPoint.h
// (c) 2003-2006 exeal

#ifndef EDIT_POINT_H_
#define EDIT_POINT_H_
#include "UnicodeUtils.h"

#define VERIFY_DOCUMENT()		\
	if(isDocumentDisposed())	\
		throw DisposedDocumentException()


namespace Ascension {
	class CharPos;
	struct DocumentUpdate;
	class EditView;

	/**
	 *	@brief sɊւ|V[
	 *
	 *	𐔂A񋓂Ƃɉsǂ̂悤Ɉ`B
	 *	Ⴆ΃hLgŜ̒vZ EditDoc::getAllLines
	 *	\bh͉sR[h𕶎Ɋ肷邪A̒lgƂŌvZ@ς邱ƂłB
	 *	܂A̃\bh͓K؂ȃ|V[I邱ƂŌオ
	 *	@see EditDoc::getAllLines, EditDoc::getDocumentLength, EditDoc::getLineIndex, EditDoc::CharacterIterator,
	 *	EditPoint::getText, Selection::getText
	 */
	enum LineBreakRetrievePolicy {
		LBRP_LINE_FEED,			///< SẲs LF (U+000D) őւ
		LBRP_CRLF,				///< SẲs CRLF (U+000D+000A) őւ
		LBRP_PHYSICAL_DATA,		///< sɐݒ肳Ăۂ̉sg
		LBRP_DOCUMENT_DEFAULT,	///< hLg̊̉sg
		LBRP_SKIP,				///< s𖳎
	};

	/// ͈͂̃eLXgϊ`
	/// @see EditPoint::convert
	enum RangeConvertType {
		RCT_UPPERCASE_SIMPLE,		///< 啶ɕϊ (P)
		RCT_LOWERCASE_SIMPLE,		///< ɕϊ (P)
		RCT_CAPITALIZE_SIMPLE,		///< Ls^CY (P)
		RCT_UPPERCASE_FULL,			///< 啶ɕϊ (S)
		RCT_LOWERCASE_FULL,			///< ɕϊ (S)
		RCT_CAPITALIZE_FULL,		///< Ls^CY (S)
		RCT_HIRAGANA,				///< ɕϊ
		RCT_KATAKANA,				///< Љɕϊ
		RCT_SIMPLIFIED_CHINESE,		///< ȑ̎ɕϊ
		RCT_TRADITIONAL_CHINESE,	///< ɑ̎ɕϊ
		RCT_FULLWIDTH,				///< Spɕϊ
		RCT_HALFWIDTH,				///< pɕϊ
		RCT_TABIFY,					///< 󔒕^uɕϊ
		RCT_UNTABIFY,				///< ^u󔒕ɕϊ
		RCT_ARABICDIGIT,			///< ArAɕϊ
		RCT_REMOVE_NONSPACE,		///< ꏊƂȂ폜
		RCT_REMOVE_ARABICKASHIDA,	///< ArÃJV_폜
		RCT_COMPOSE,				///< Ɍ
		RCT_DECOMPOSE,				///< 𕪉
	};

	/// 쐬̃hLgɖ EditPoint IuWFNgLłȂƂ\O
	class DisposedDocumentException : public std::runtime_error {
	public:
		DisposedDocumentException() :
			std::runtime_error("Target document is already inavailable. This object is no longer able to be used anyway.") {}
	};

	/// CAEg񂪕Kvȃ\bhĂяoACAEgێr[1Ƃ\O
	class LayoutNotPreparedException : public std::runtime_error {
	public:
		/// RXgN^
		LayoutNotPreparedException() :
			std::runtime_error("Though specified command needs layout information, that cannot obtain.") {}
	};


	/**
	 *	@brief hLg̕ʒu\AhLg̕ύXɒǏ]Ĉړu_v
	 *
	 *	RXgN^ARs[RXgN^͔JłB쐬ɂ
	 *	EditDoc::createSynchronizablePoint \bhARs[ɂ
	 *	EditDoc::copySynchronizablePoint \bhgBjɂ͌JfXgN^ (@c delete) g
	 *
	 *	̃NXhNX̂قƂǂ̃\bh́AΏۃhLgɑ݂Ȃꍇ
	 *	DisposedDocumentException OX[BSynchronizablePoint::isDocumentDisposed
	 *	\bhgƃhLg݂Ă邩ׂ邱Ƃł
	 *
	 *	hLgZbg (EditDoc::resetContent) ƁAIɃhLg̐擪Ɉړ
	 *
	 *	@see CharPos, EditPoint, VisualPoint, Caret
	 */
	class SynchronizablePoint : public Manah::SelfAssertable,
			public Manah::Unassignable/*, public Manah::UseMemoryPool<SynchronizablePoint>*/ {
	public:
		/// _̈ʒuɃeLXg}ꂽƂ̓_̈ړ
		enum Gravity {
			BACKWARD = 0,	///< }ꂽeLXg̐[ (ړȂ)
			FORWARD = 1		///< }ꂽeLXg̏I[
		};

		// RXgN^
	protected:
		SynchronizablePoint(EditDoc& document);
		SynchronizablePoint(const SynchronizablePoint& rhs);
	public:
		virtual ~SynchronizablePoint();

		// Zq
	public:
		operator CharPos() throw();
		operator const CharPos() const throw();
	protected:
		SynchronizablePoint& operator =(const CharPos& rhs) throw();

		// \bh
	public:
		void			excludeFromRestriction(bool exclude);
		EditDoc*		getDocument() const throw();
		Gravity			getGravity() const throw();
		const CharPos&	getPosition() const throw();
		bool			isDocumentDisposed() const throw();
		bool			isExcludedFromRestriction() const throw();
		bool			isSynchronousWithDocumentUpdate() const;
		void			moveTo(const CharPos& pos);
		void			moveTo(length_t line, length_t column);
		void			setGravity(Gravity g);
		void			synchronizeWithDocumentUpdate(bool sync);
	protected:
		virtual void	doMoveTo(const CharPos& pos, bool byDocumentSynchronization);
		void			ignoreDocumentUpdate(bool ignore) throw();
		virtual void	normalize() const;
		void			onDisposed();
		void			onUpdateDocument(const DocumentUpdate& update);

		// f[^o
	private:
		EditDoc*	document_;
		CharPos		position_;
		bool		sync_;
		Gravity		gravity_;
		bool		ignoreDocumentUpdate_;							// ꎞI onUpdateDocument 𖳎
		bool		excludedFromRestriction_;
		void(*releaser_)(EditDoc& document, SynchronizablePoint&);	// j󎞂ɌĂяo (EditDoc ̕ҏW_쐬\bhŐݒ肳)
		friend class EditDoc;
	};

	inline bool operator ==(const SynchronizablePoint& lhs, const SynchronizablePoint& rhs)
	{return lhs.getPosition() == rhs.getPosition();}
	inline bool operator !=(const SynchronizablePoint& lhs, const SynchronizablePoint& rhs)
	{return lhs.getPosition() != rhs.getPosition();}
	inline bool operator <(const SynchronizablePoint& lhs, const SynchronizablePoint& rhs)
	{return lhs.getPosition() < rhs.getPosition();}
	inline bool operator <=(const SynchronizablePoint& lhs, const SynchronizablePoint& rhs)
	{return lhs.getPosition() <= rhs.getPosition();}
	inline bool operator >(const SynchronizablePoint& lhs, const SynchronizablePoint& rhs)
	{return lhs.getPosition() > rhs.getPosition();}
	inline bool operator >=(const SynchronizablePoint& lhs, const SynchronizablePoint& rhs)
	{return lhs.getPosition() >= rhs.getPosition();}

	/**
	 *	@brief GfB^ŕҏWAړ\ȁu_vB^Lbg
	 *
	 *	EditView ̃NCAg͑I͈͂LbgʒuƂăeLXgҏWł邪A
	 *	̃NXɂCӂ̏ꏊ̕ҏW\ƂȂBNCAǵu_vҏWӏɈړA
	 *	EditView ̑Ǝ@ŕҏWs
	 *
	 *	ҏW_ɂhLg̕ύXsƁAAҏW_͓K؂ȈʒuɈړB
	 *	Ⴆ n ̕}ƌ݈ʒu n i߂
	 *
	 *	ҏW_͑̕ҏWł̈ʒuύXBeNX SynchronizablePoint 
	 *
	 *	܂A̕ҏWɂ̂܂߂AҏW_̂ړɂ2̋KKpB
	 *	1ڂ̓obt@̗_IȈʒuɂ̂ŁA݂Ȃ񂩂ŏIցA
	 *	폜ꂽsŏIsւ̈ړIɍs (I EditPoint::normalize
	 *	gĂ)B2ڂ͕ɂ̂ŁATQ[gyÅԂ炢ꂩ̃TQ[g̑OցA
	 *	extender ̑O炻̕NX^̑Oւ̈ړsB
	 *	҂̋ EditPoint::setCharacterCountingConvention Őł
	 *
	 *	PʁAPPʂŕҏW_̈ړs\bĥAO @c Left y @c Right
	 *	ŏIĂ̂́A_ł͂ȂAo̕w肷B
	 *	̓Iɂ̓r[̃eLXgEł @c xxxxLeft  @c xxxxPrev ɁAE獶ł
	 *	@c xxxxLeft  @c xxxxNext Ƀ}bvB王o̕x[Xɂ\bh́A
	 *	L[{[hȂǂ̃[UC^[tFCXړsƂlĒ񋟂Ă
	 *
	 *	EditPoint ɂhLg̃Z}eBNXɂĂ
	 *	EditView::onUpdate ̉
	 *
	 *	RXgN^ARs[RXgN^͔JłB쐬ɂ EditDoc::createEditPoint \bhA
	 *	Rs[ɂ EditDoc::copyEditPoint \bhgBjɂ͌JfXgN^ (@c delete) g
	 *
	 *	SẴ\bh̓hLg̃AhDO[v\bhĂяos<strong>Ȃ</strong>B
	 *	āA1܂Ƃ߂ɂꍇ̓NCAg EditDoc::beginEditCollection ĂяoȂ΂ȂȂ
	 *
	 *	@see EditView, EditDoc, Selection, DisposedDocumentException
	 */
	class EditPoint : public SynchronizablePoint {
	public:
		/// ̐BsȈʒu̎C̋ (EditPoint Q)
		enum CharacterCountingConvention {
			CCC_UTF16,		///< UTF-16 P
			CCC_UTF32,		///< UTF-32 PʁBTQ[gyA1Ƃ݂Ȃ
			CCC_CLUSTER,	///< NX^PʁBTQ[gyAA1Ƃ݂Ȃ
//			CCC_GLYPH,		///< OtP
			CCC_DEFAULT,	///<  (EditPoint::erase \bhł̂ݎgp)
		};

		/// Cxgnh
		class IEventListener {
		public:
			/// fXgN^
			virtual ~IEventListener() {}
			/// _j󂳂ꂽ
			virtual void onEditPointDestroyed() = 0;
			/**
			 *	_ړ
			 *	@param self			̓_
			 *	@param oldPosition	ړÖʒu
			 */
			virtual void onEditPointMoved(const EditPoint& self, const CharPos& oldPosition) = 0;
		};

		// RXgN^
	protected:
		EditPoint(EditDoc& document, IEventListener* eventListener = 0);
		EditPoint(const EditPoint& rhs);
	public:
		virtual ~EditPoint();

		// \bh
	public:
		/*  */
		length_t					getAbsoluteCharOffset() const;
		CharacterCountingConvention	getCharacterCountingConvention() const;
		length_t					getCharNumber() const;
		CodePoint					getCodePoint() const;
		length_t					getLineLength() const;
		length_t					getLineNumber() const;
		string_t					getText(signed_length_t length, LineBreakRetrievePolicy lineBreakPolicy = LBRP_PHYSICAL_DATA) const;
		string_t					getText(const CharPos& pos, LineBreakRetrievePolicy lineBreakPolicy = LBRP_PHYSICAL_DATA) const;
		bool						isEndOfDocument() const;
		bool						isEndOfLine() const;
		bool						isStartOfDocument() const;
		bool						isStartOfLine() const;
		void						setCharacterCountingConvention(CharacterCountingConvention convention);

		/*  : ړ */
		void	charNext(length_t offset = 1);
		void	charPrev(length_t offset = 1);
		void	moveToAbsoluteCharOffset(length_t offset);
		void	moveToEndOfDocument();
		void	moveToEndOfLine();
		void	moveToStartOfDocument();
		void	moveToStartOfLine();

		/*  (ҏW) */
		void			convert(signed_length_t length, RangeConvertType type);
		void			convert(const CharPos& pos, RangeConvertType type);
		void			copy(signed_length_t length);
		void			copy(const CharPos& pos);
		void			cut(signed_length_t length);
		void			cut(const CharPos& pos);
		void			destructiveInsert(const string_t& text);
		void			destructiveInsert(const char_t* first, const char_t* last);
		void			erase(signed_length_t length = 1, CharacterCountingConvention ccc = CCC_DEFAULT);
		void			erase(const CharPos& pos);
		void			insert(const string_t& text);
		void			insert(const char_t* first, const char_t* last);
		virtual void	newLine();
		void			paste(signed_length_t length = 0);
		virtual void	paste(const CharPos& pos);
	protected:
		virtual void	doMoveTo(const CharPos& pos, bool forDocumentSynchronization);
		static CharPos	getNextCharPos(const EditPoint& pt, length_t length, CharacterCountingConvention ccc = CCC_DEFAULT);
		static CharPos	getPrevCharPos(const EditPoint& pt, length_t length, CharacterCountingConvention ccc = CCC_DEFAULT);

		// f[^o
	protected:
		IEventListener* eventListener_;	// CxgXi
	private:
		CharacterCountingConvention charCountConvention_;	// ̌vZ@ (^`Q)
	};


	/**
	 *	ҏW_̑̂Ãr[ɑ΂čp̂ACAEgQƂ鑀`
	 *	@see EditPoint, LayoutNotPreparedException
	 */
	class VisualPoint : public EditPoint {
		// RXgN^
	protected:
		VisualPoint(EditDoc& document, EditPoint::IEventListener* eventListener = 0);
		VisualPoint(const VisualPoint& rhs);
	public:
		virtual ~VisualPoint();

		// \bh
	public:
		/*  */
		length_t	getColumnNumber() const;
		bool		isFirstCharOfLine() const;
		bool		isLastCharOfLine() const;

		/*  : ړ */
		void	charLeft(length_t offset = 1);
		void	charRight(length_t offset = 1);
		void	lineDown(length_t offset = 1);
		void	lineUp(length_t offset = 1);
		void	moveToFirstCharOfLine();
		void	moveToLastCharOfLine();
		bool	moveToNextBookmark();
		bool	moveToPrevBookmark();
		void	pageDown(length_t offset = 1);
		void	pageUp(length_t offset = 1);
		void	wordEndLeft(length_t offset = 1);
		void	wordEndNext(length_t offset = 1);
		void	wordEndPrev(length_t offset = 1);
		void	wordEndRight(length_t offset = 1);
		void	wordNext(length_t offset = 1);
		void	wordPrev(length_t offset = 1);
		void	wordLeft(length_t offset = 1);
		void	wordRight(length_t offset = 1);

		/*  : r[̃XN[ */
		bool	center(EditView& view, signed_length_t length = 0);
		bool	center(EditView& view, const CharPos& pos);
		bool	reveal(EditView& view, signed_length_t length = 0);
		bool	reveal(EditView& view, const CharPos& pos);

		/*  : ҏW */
		void	insertBox(const string_t& text);
		void	insertBox(const char_t* first, const char_t* last);
		void	newLine();
		void	paste(const CharPos& pos);
		CharPos	spaceIndent(const CharPos& pos, bool box, long level = 1);
		CharPos	tabIndent(const CharPos& pos, bool box, long level = 1);
		bool	transposeChars();
		bool	transposeLines();
//		bool	transposeParagraphs();
//		bool	transposeSentences();
		bool	transposeWords();

	protected:
		virtual void			doMoveTo(const CharPos& pos, bool forDocumentSynchronization);
		virtual const EditView&	getView() const;
	private:
		CharPos	doIndent(const CharPos& pos, char_t character, bool box, long level);
		void	updateLastX();

		// f[^o
	private:
		struct {
			bool	fromLeftEnd_;	// [̋̏ꍇ true
			ulong	distance_;		// 
			bool	dontUpdateNext_;
		} lastX_;					// _́As\̈[̋BLineDown ALineUp ňړƂɕێĂ
		friend class EditDoc;
	};


	/**
	 *	@brief Lbg
	 *
	 *	̃NXł EditPoint::IEventListener ͎gȂ
	 *	(Caret::IEventListener ̒`)
	 */
	/* final */ class Caret : public VisualPoint, public Manah::Noncopyable {
	public:
		/// CxgXi
		/// @see EditPoint::IEventListener
		class IEventListener {
		public:
			/// fXgN^
			virtual ~IEventListener() {}
			/**
			 *	_ړ
			 *	@param self					Lbg
			 *	@param anchor				AJ[|Cg
			 *	@param oldRange				ړO͈̔ (@c pos1 AJ[A@c pos2 Lbg)
			 *	@param bForDocumentUpdate	hLg̍XVɂړ̏ꍇ true
			 */
			virtual void onCaretMoved(const Caret& self,
				const VisualPoint& anchor, const TextRange& oldRange, bool forDocumentUpdate) = 0;
		};

		// RXgN^
	protected:
		Caret(EditDoc& document, VisualPoint& anchorPoint, IEventListener* eventListener = 0);

		// \bh
	public:
		Caret&	synchronizeAnchor();
	protected:
		void	doMoveTo(const CharPos& pos, bool forDocumentSynchronization);

		// f[^o
	private:
		VisualPoint&	anchorPoint_;
		IEventListener*	caretListener_;
		bool			synchronizeAnchor_;
		friend EditDoc;
	};


	/// RXgN^
	inline SynchronizablePoint::SynchronizablePoint(EditDoc& document) :
			document_(&document), sync_(false), gravity_(FORWARD),
			ignoreDocumentUpdate_(false), excludedFromRestriction_(false), releaser_(0) {}

	/// Rs[RXgN^
	inline SynchronizablePoint::SynchronizablePoint(const SynchronizablePoint& rhs) :
			document_(rhs.document_), position_(rhs.position_), sync_(rhs.sync_), gravity_(rhs.gravity_),
			ignoreDocumentUpdate_(false), excludedFromRestriction_(rhs.excludedFromRestriction_), releaser_(rhs.releaser_) {
		// Jɂ邽߂ɎŒ`Ă...
	}

	/// fXgN^
	inline SynchronizablePoint::~SynchronizablePoint() {if(document_ != 0) (*releaser_)(*document_, *this);}

	/// ֐̂߂̕ϊZq
	inline SynchronizablePoint::operator Ascension::CharPos() throw() {return position_;}

	/// ֐̂߂̕ϊZq
	inline SynchronizablePoint::operator const Ascension::CharPos() const throw() {return position_;}

	/// @a rhs ̈ʒuɈړJZqBʏ move \bhgp
	inline SynchronizablePoint& SynchronizablePoint::operator =(const CharPos& rhs) throw() {position_ = rhs;}

	/// i[CÕANZXs\̈ւ̐N֎~邩ݒ肷
	inline void SynchronizablePoint::excludeFromRestriction(bool exclude) {
		assertValid();
		VERIFY_DOCUMENT();
		if(excludedFromRestriction_ = exclude)
			normalize();
	}

	/// 쐬hLgԂ
	inline EditDoc* SynchronizablePoint::getDocument() const throw() {assertValid(); return document_;}

	/// OreBԂ
	inline SynchronizablePoint::Gravity SynchronizablePoint::getGravity() const throw() {assertValid(); return gravity_;}

	/// ʒuԂ
	inline const CharPos& SynchronizablePoint::getPosition() const throw() {assertValid(); return position_;}

	/// onUpdateDocument ĂяoꎞIɖ
	inline void SynchronizablePoint::ignoreDocumentUpdate(bool ignore) throw() {assertValid(); ignoreDocumentUpdate_ = ignore;}

	/// 쐬hLgłɔjĂ true Ԃ
	inline bool SynchronizablePoint::isDocumentDisposed() const throw() {assertValid(); return document_ == 0;}

	/// ANZXs\̈ɐNłȂꍇ true Ԃ
	inline bool SynchronizablePoint::isExcludedFromRestriction() const throw() {assertValid(); return excludedFromRestriction_;}

	/// hLg̍XVɓĈړꍇ true Ԃ
	inline bool SynchronizablePoint::isSynchronousWithDocumentUpdate() const {assertValid(); VERIFY_DOCUMENT(); return sync_;}

	/// _ֈړ
	inline void SynchronizablePoint::moveTo(length_t line, length_t column) {moveTo(CharPos(line, column));}

	/// 쐬hLgꂽƂɌĂяo
	inline void SynchronizablePoint::onDisposed() {assertValid(); document_ = 0;}

	/// OreB̐ݒ
	inline void SynchronizablePoint::setGravity(Gravity g) {assertValid(); VERIFY_DOCUMENT(); gravity_ = g;}

	/// hLg̍XVɓĈړ邩ݒ肷
	inline void SynchronizablePoint::synchronizeWithDocumentUpdate(bool sync) {assertValid(); VERIFY_DOCUMENT(); sync_ = sync;}

	/// RXgN^
	inline EditPoint::EditPoint(EditDoc& document, IEventListener* eventListener /* = 0 */)
		: SynchronizablePoint(document), eventListener_(eventListener), charCountConvention_(CCC_CLUSTER) {}

	/// Rs[RXgN^
	inline EditPoint::EditPoint(const EditPoint& rhs) :
			SynchronizablePoint(rhs), eventListener_(rhs.eventListener_), charCountConvention_(rhs.charCountConvention_) {
		// Jɂ邽߂ɎŒ`Ă...
	}

	/// fXgN^
	inline EditPoint::~EditPoint() {if(eventListener_ != 0) eventListener_->onEditPointDestroyed();}

	/// vZ@Ԃ
	inline EditPoint::CharacterCountingConvention EditPoint::getCharacterCountingConvention() const {
		assertValid(); VERIFY_DOCUMENT(); return charCountConvention_;}

	/// ԍԂ (UTF-16 P)
	inline length_t EditPoint::getCharNumber() const {assertValid(); VERIFY_DOCUMENT(); return getPosition().char_;}

	/// sԍԂ
	inline length_t EditPoint::getLineNumber() const {assertValid(); VERIFY_DOCUMENT(); return getPosition().line_;}

	/// vZ@̐ݒ
	inline void EditPoint::setCharacterCountingConvention(EditPoint::CharacterCountingConvention convention) {
		assertValid(); VERIFY_DOCUMENT(); assert(convention != CCC_DEFAULT); charCountConvention_ = convention;}

	/// RXgN^
	inline VisualPoint::VisualPoint(EditDoc& document, IEventListener* eventListener /* = 0 */)
		: EditPoint(document, eventListener) {lastX_.dontUpdateNext_ = false;}

	/// Rs[RXgN^
	inline VisualPoint::VisualPoint(const VisualPoint& rhs) : EditPoint(rhs), lastX_(rhs.lastX_) {}

	/// fXgN^
	inline VisualPoint::~VisualPoint() {}

	/// RXgN^
	inline Caret::Caret(EditDoc& document, VisualPoint& anchorPoint, IEventListener* eventListener /* = 0 */) :
		VisualPoint(document, 0), anchorPoint_(anchorPoint), caretListener_(eventListener), synchronizeAnchor_(false) {}

	/// ̈ړ1񂾂AJ[Ǐ]A֐̂߂ɎgԂ
	inline Caret& Caret::synchronizeAnchor() {assertValid(); synchronizeAnchor_ = true; return *this;}
} /* namespace Ascension */

#endif /* EDIT_POINT_H_ */

/* [EOF] */