// EditView.h
// (c) 2003-2006 exeal

#ifndef EDIT_VIEW_H_
#define EDIT_VIEW_H_

#include "EditDoc.h"
#include "../../Manah/DC.hpp"	// Manah::Windows::GDI::CDC
#include "../../Manah/Menu.hpp"
#include "../../Armaiti/TextDataObject.hpp"
#include "EditPoint.h"
#include "LineLayout.h"
#include "TextSearcher.h"
#include "CompletionWindow.h"
#include <set>
#include <algorithm>
#include <bitset>

#ifndef ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER
#include <dimm.h>
#endif /* !ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER */

#ifndef ASCENSION_NO_TEXT_SERVICES_FRAMEWORK
#include <Textstor.h>
#endif /* !ASCENSION_NO_TEXT_SERVICES_FRAMEWORK */

#ifndef ASCENSION_NO_ACTIVE_ACCESSIBILITY
#include <Oleacc.h>
#include <MSAAtext.h>
#endif /* !ASCENSION_NO_ACTIVE_ACCESSIBILITY */

#ifndef ASCENSION_NO_TEXT_OBJECT_MODEL
#include <tom.h>
#endif /* !ASCENSION_NO_TEXT_OBJECT_MODEL */


#define SB_SETPOS	20	// XN[ʒuύX邽߂ onHScroll AonVScroll ĂяoƂɎgR[h

// Ɏg}N (ĂԂ)
#define BEGIN_OPERATION_SEQUENCE()			\
	getDocument().beginEditCollection();	\
	freeze()
#define END_OPERATION_SEQUENCE()			\
	getDocument().endEditCollection();		\
	unfreeze()
#define FOR_EACH_LISTENERS()						\
	for(set<IEditViewEventListener*>::iterator it =	\
		sharedData_->eventListeners.begin(); it != sharedData_->eventListeners.end(); ++it)
#define FOR_EACH_CONST_LISTENERS()							\
	for(set<IEditViewEventListener*>::const_iterator it =	\
		sharedData_->eventListeners.begin(); it != sharedData_->eventListeners.end(); ++it)
#define FOR_EACH_CLONES()	\
	for(CloneIterator it(*this); !it.isEnd(); it.next())


namespace Ascension {

class EditView;
class EditController;
class LineLayoutInfo;
class LineLayoutManager;
class EditPoint;
class VisibleEditPoint;
class KeywordManager;


// Miscellaneous
/////////////////////////////////////////////////////////////////////////////

/// 2lIvV
namespace BooleanOptions {
	/// \̃IvV
	/// @see EditView::Options::appearance
	enum {
		BEEP_ON_SOME_FAILURE,					///< ̑ɎsƂɉ炷
		HIDE_CURSOR_FOR_CHAR_INPUT,				///< ͂n߂J[\\ɂ
		HIGHLIGHT_MATCH_TEXT,					///< Ƀ}b`eLXg\
		HIGHLIGHT_PREVIOUS_AS_MATCH_BRACKET,	///< Lbg̒O̊ʂ\
		LOCALE_SPECIFIC_CARET_SHAPE,			///< ̓P[ɏ]Lbǧ`ς
		SHOW_BREAK_ARROWS,						///< s̖\
		SHOW_CURRENT_UNDERLINE,					///< ݍsɉ\
		SHOW_END_OF_FILE,						///< [EOF] }[N\
		SHOW_HAND_ON_LINK,						///< NeLXgŃnhJ[\\
		SHOW_HINT_ON_LINK,						///< NeLXgŃ|bvAbv\
		SHOW_SELECTION_ON_BREAK,				///< IɑĂs̔wih邩ǂ
		SHOW_UNICODE_CONTROLS,					///< Unicode 䕶\
		SHOW_WHITESPACE_ALTERNATIVE,			///< 󔒗ޕ̑֕\
		THIN_CARET,								///< 1sNZ̃Lbgg (ʏ2sNZ)
		USE_EDITOR_FONT_FOR_COMPLETION,			///< ⊮EBhẼtHgGfB^Ɠɂ
												///< (NAĂ΃VXe UI tHg)
		DISPLAY_BOOLEAN_OPTIONS_COUNT
	};

	/// ̃IvV
	/// @see EditView::Options::behavior
	enum {
		ACCEPT_CARET_ON_EXTENDER_BY_MOUSE,	///< Lbg󂯎Ȃ̑OɃ}EXňړł
		ACCEPT_CONTROL_CHAR_INPUT,			///< 䕶̓͂F߂
		MOVE_CARET_BY_RIGHT_CLICK,			///< ENbNŃLbgړ
		OLE_DRAG_AND_DROP,					///< OLE hbOAhhbvg
		BEHAVIOR_BOOLEAN_OPTIONS_COUNT
	};
}

/// ̓V[PX`FbN
typedef ushort	InputSequenceCheckLanguage;
const InputSequenceCheckLanguage
	ISCL_AINU		= 1,				///< ACk
	ISCL_HINDI		= ISCL_AINU << 1,	///< qfB[
	ISCL_KHMER		= ISCL_HINDI << 1,	///< J{WA
	ISCL_LAO		= ISCL_KHMER << 1,	///< I
	ISCL_TAMIL		= ISCL_LAO << 1,	///< ^~
	ISCL_THAI		= ISCL_TAMIL << 1,	///< ^C
	ISCL_VIETNAMESE	= ISCL_THAI << 1,	///< xgi
	ISCL_ALL		= 0xFFFF;			///< SĂ̌

/// Cfg̎
enum AutoIndentType {
	AIT_NONE,	///< Ȃ
	AIT_BLOCK,	///< O̍sɈv
	AIT_SMART	///< `̃X}[gCfg
};

/// GfB^EBhẼqbgeXg
enum HitTestResult {
	HTR_INDICATORMARGIN,	///< CWP[^}[W
	HTR_LINENUMBERS,		///< sԍ
	HTR_LEADMARGIN,			///< s]
	HTR_TOPMARGIN,			///< ]
	HTR_TEXT,				///< eLXg\`
	HTR_OUTOFVIEW			///< NCAg̈O
};

/// ɓ͂镶̕ϊ
enum NextCharVariation {
	NCV_NONE,			///< ϊ
	NCV_GRAVE,			///< ANZg
	NCV_ACUTE,			///< sANZg
	NCV_CIRCUMFLEX,		///< Ȑ܃ANZg
	NCV_TILDE,			///< @
	NCV_MACRON,			///< 
	NCV_BREVE,			///< Z
	NCV_DIAERESIS,		///< EEg
	NCV_CARON,			///< L
	NCV_CEDILLA,		///< ZfB[
	NCV_SUPERSCRIPT,	///< t
	NCV_SUBSCRIPT		///< t
};

/// ҏWP
struct EditOperation {
	/// ҏW̎
	enum Type {
		NONE,		///< 
		TYPING,		///< ^CsO
		DELETION,	///< 폜
		REPLACE,	///< ㏑
		PASTE		///< \t
	} type_;	// ̎
	CharPos pos_;	// sʃLbgړʒu

	void set(Type type, const CharPos& pos) {
		type_ = type;
		pos_ = pos;
	}
};


/// EditView CX^X̃Cxgnh
class IEditViewEventListener {
public:
	/// sCxg
	/// @see IEditViewEventListener::onLineOperationEvent
	enum LineOperationEvent {
		LOE_CREATED,	///< s쐬ꂽ
		LOE_DELETED,	///< s폜ꂽ
		LOE_MODIFIED	///< sύXꂽ
	};
	/// fXgN^
	virtual ~IEditViewEventListener() {}
	/**
	 *	LbgO̒PꂪZkƂēWJ\ȏԂɂȂ
	 *	@param ready	WJ\ȏԂɂȂƂ trueBWJ\ȏԂ甲Ƃ false
	 *	@param abbrev	ZkB@a ready  false ̂Ƃ͋󕶎
	 *	@see			EditView::getPrecedingWord AEditView::expandAbbreviation
	 */
	virtual void onChangedAbbreviationExpansionReadyState(bool ready, const string_t& abbrev) = 0;
	/// }/㏑[hύXꂽ
	virtual void onChangedOvertypeMode() = 0;
	/// ҏWs\[ĥ EditorCommand::execute ۂꂽ
	virtual void onDeniedGUICommand() = 0;
	/**
	 *	URI NƂɌĂяo
	 *	@param uri URI
	 */
	virtual void onInvokeURILink(const char_t* uri) = 0;
	/**
	 *	s쐬A폜AύXꂽ
	 *	@param event	Cxg̎
	 *	@param line		擪s (_s)
	 *	@param length	Ώۍs
	 */
	virtual void onLineOperationEvent(LineOperationEvent event, length_t line, length_t length) = 0;
	/**
	 *	t@CǂݍŁÃx̍s͂sOɌĂяoB
	 *	IuWFNg͂̃\bhĂяoAǂݍ񂾃t@C݂Ƃďi߂̂ŁA
	 *	̃nhŊJꂽt@CÃt@CJ肵Ă͂ȂB
	 *	͑OɎ͊ɋKACAEg}l[Wɋ\^̂Ɏgp
	 */
	virtual void onLoadFile() = 0;
	/**
	 *	Ίʂr[̊OŌ
	 *	@param pos Ίʂ̈ʒuBȂꍇLbgʂ痣ꂽꍇ CharPos::INVALID_POSITION
	 */
	virtual void onMatchBracketFoundOutOfView(const CharPos& pos) = 0;
	/**
	 *	Lbgړ (`擀͌ĂяoȂBɌĂяo)
	 *	@param pos ړ̃Lbgʒu
	 */
	virtual void onMoveCaret(const CharPos& pos) = 0;
};


/// IEditViewEventListener ̋
class EditViewEventAdapter : virtual public IEditViewEventListener {
public:
	virtual ~EditViewEventAdapter() {}
	virtual void onChangedAbbreviationExpansionReadyState(bool ready, const string_t& abbrev) {}
	virtual void onChangedOvertypeMode() {}
	virtual void onDeniedGUICommand() {}
	virtual void onInvokeURILink(const char_t* uri) {}
	virtual void onLineOperationEvent(IEditViewEventListener::LineOperationEvent event, length_t line, length_t length) {}
	virtual void onLoadFile() {}
	virtual void onMatchBracketFoundOutOfView(length_t line) {}
	virtual void onMoveCaret(const CharPos& pos) {}
};


/// Nbv{[hO
class ClipboardRing : public Manah::SelfAssertable {
	// ^`
public:
	typedef std::size_t SizeType;
	/// Nbv{[hÕCxgXi
	class IEventListener {
	public:
		/// fXgN^
		virtual ~IEventListener() {}
		/// Oω
		virtual void onClipboardRingChanged() = 0;
		/// Oɒǉ悤ƂeLXg傫ߋۂꂽ
		virtual void onClipboardRingDeniedAdding() = 0;
	};

	// RXgN^
public:
	ClipboardRing();

	// \bh
public:
	void		add(const string_t& text, bool box);
	void		addEventListener(IEventListener& eventListener);
	SizeType	getActiveItem() const throw();
	SizeType	getCount() const throw();
	void		getText(SizeType index, string_t& text, bool& box) const;
	void		limitCount(SizeType limit);
	void		remove(SizeType index);
	void		removeAll();
	void		removeEventListener(IEventListener& eventListener);
	void		setActiveItem(SizeType index);

	// f[^o
private:
	struct ClipText {
		string_t text;	// eLXg
		bool box;		// `f[^
	};
	std::list<ClipText>			datas_;
	SizeType					limitCount_;
	ulong						maxBytes_;
	SizeType					activeItem_;
	std::set<IEventListener*>	eventListeners_;
};


/// XN[̊Jn_ɕ\ۂEBhE
class AutoScrollOriginMark :
		public Manah::Windows::Controls::Layered<Manah::Windows::Controls::CustomControl<AutoScrollOriginMark> > {
	DEFINE_WINDOW_CLASS() {
		name = L"AutoScrollOriginMark";
		style = CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW;
		bgColor = COLOR_WINDOW;
		cursor = IDC_IBEAM;
	}

	// \bh
public:
	bool	create(const EditView& view);

	// bZ[Wnh
protected:
	void	onPaint(Manah::Windows::GDI::PaintDC& dc);

	// f[^o
private:
	static const long WINDOW_WIDTH;
};

/// Zk̊Ǘ
class Abbreviations {
	// RXgN^
private:
	Abbreviations();

	// \bh
public:
	string_t	expand(const string_t& abbreviation) const;
	void		getList(std::set<string_t>& abbreviations) const;
	void		insert(const string_t& abbreviation, const string_t& expanded);
	void		remove(const string_t& abbreviation);
	void		removeAll();

	// f[^o
private:
	std::map<string_t, string_t> abbreviations_;
	length_t maxAbbreviationLength_;	// ԒZk̕
	friend class EditView;
};


/**
 *	GfB^R}h̊蒊ۃNX
 *	@see Ascension::StandardCommands
 */
class EditorCommand {
public:
	/// RXgN^
	EditorCommand(EditView& view) throw() : view_(&view) {}
	/// fXgN^
	virtual ~EditorCommand() throw() {}
	/// R}hsAR}hˑ̒lԂ
	virtual ulong execute() = 0;
	/// R}h^[QbgύX
	void retarget(EditView& view) throw() {view_ = &view;}
protected:
	/// ⊮EBhEԂ
	CompletionWindow& getCompletionWindow() const;
	/// R}h^[QbgԂ
	EditView& getTarget() const throw() {return *view_;}
private:
	EditView* view_;
};


namespace Private {
	template<class T> class EditorCommandBase : public EditorCommand {
	public:
		EditorCommandBase(EditView& view, T param) : EditorCommand(view), param_(param) {}
		virtual ~EditorCommandBase() {}
	protected:
		T param_;
	};
} // namespace `anonymous'


/// GfB^̕WR}h̎
namespace StandardCommands {
	/// ubN}[N
	class BookmarkCommand : public EditorCommand {
	public:
		enum Type {
			CLEAR_ALL,			///< Sč폜
			TOGGLE_CURRENT_LINE	///< ݍs̃ubN}[ÑgO
		};
		BookmarkCommand(EditView& view, Type type) : EditorCommand(view), type_(type) {}
		ulong execute();
	private:
		Type type_;
	};
	/// ỈACN^̒~
	class CancelCommand : public EditorCommand {
	public:
		CancelCommand(EditView& view) : EditorCommand(view) {}
		ulong execute();
	};
	/// Lbg̈ړ
	class CaretMovementCommand : public EditorCommand {
	public:
		enum Type {
			NEXT_CHARACTER,		///< ̕
			PREVIOUS_CHARACTER,	///< O̕
			LEFT_CHARACTER,		///< ̕
			RIGHT_CHARACTER,	///< E̕
			NEXT_WORD,		///< ̒P̐擪
			PREVIOUS_WORD,	///< O̒P̐擪
			LEFT_WORD,		///< ̒P̐擪
			RIGHT_WORD,		///< E̒P̐擪
			NEXT_WORDEND,		///< ̒P̏I[
			PREVIOUS_WORDEND,	///< O̒P̏I[
			LEFT_WORDEND,		///< ̒P̏I[
			RIGHT_WORDEND,		///< E̒P̏I[
			NEXT_LINE,		///< ̍s
			PREVIOUS_LINE,	///< O̍s
			NEXT_PAGE,		///< ̃y[W
			PREVIOUS_PAGE,	///< Õy[W
			START_OF_LINE,			///< s
			END_OF_LINE,			///< s
			FIRST_CHAR_OF_LINE,		///< s̍ŏ̕
			LAST_CHAR_OF_LINE,		///< s̍Ō̕
			START_OR_FIRST_OF_LINE,	///< ݈ʒuɂAss̍ŏ̕
			END_OR_LAST_OF_LINE,	///< ݈ʒuɂAss̍Ō̕
			START_OF_DOCUMENT,	///< hLg̐擪
			END_OF_DOCUMENT,	///< hLg̏I[
			NEXT_BOOKMARK,		///< ̃ubN}[N (ړʂ͏1)
			PREVIOUS_BOOKMARK,	///< ÕubN}[N (ړʂ͏1)
			MATCH_BRACKET,		///< Ί
		};
		CaretMovementCommand(EditView& view, Type type, bool extend = false, length_t offset = 1)
				: EditorCommand(view), type_(type), extend_(extend), offset_(offset) {}
		ulong execute();
	private:
		Type		type_;
		bool		extend_;
		length_t	offset_;
	};
	/// ƃR[h|Cg̕ϊ
	class CharacterCodePointConversionCommand : public Private::EditorCommandBase<bool> {
	public:
		CharacterCodePointConversionCommand(EditView& view, bool charToCp) : Private::EditorCommandBase<bool>(view, charToCp) {}
		ulong execute();
	};
	/// 1̓
	class CharacterInputCommand : public Private::EditorCommandBase<CodePoint> {
	public:
		CharacterInputCommand(EditView& view, CodePoint cp) : Private::EditorCommandBase<CodePoint>(view, cp) {}
		ulong execute();
	};
	/// אڍs̓ʒu̕
	class CharacterInputFromNextLineCommand : Private::EditorCommandBase<bool> {
	public:
		CharacterInputFromNextLineCommand(EditView& view, bool fromNextLine) : Private::EditorCommandBase<bool>(view, fromNextLine) {}
		ulong execute();
	};
	/// Nbv{[h֘ÃR}h
	class ClipboardCommand : public EditorCommand {
	public:
		enum Type {
			COPY,	///< Rs[
			CUT,	///< ؂
			PASTE	///< \t
		};
		ClipboardCommand(EditView& view, Type type, bool performClipboardRing)
			: EditorCommand(view), type_(type), performClipboardRing_(performClipboardRing) {}
		ulong execute();
	private:
		Type type_;
		bool performClipboardRing_;
	};
	/// eLXg̍폜
	class DeletionCommand : public EditorCommand {
	public:
		enum Type {
			NEXT_CHARACTER,		/// 1BCN^̏ꍇAJn̏ԂɃZbg
			PREVIOUS_CHARACTER,	/// O1BCN^̏ꍇAŌ̕ύXɖ߂
			NEXT_WORD,			/// ̒P̐擪܂
			PREVIOUS_WORD,		/// O̒P̐擪܂
			WHOLE_LINE			/// sS
		};
		DeletionCommand(EditView& view, Type type) : EditorCommand(view), type_(type) {}
		ulong execute();
	private:
		Type type_;
	};
	/// S
	class FindAllCommand : public EditorCommand {
	public:
		enum Type {
			BOOKMARK,	///< ubN}[Nݒ
			REPLACE		///< u
		};
		FindAllCommand(EditView& view, Type type, bool onlySelection) : EditorCommand(view), type_(type), onlySelection_(onlySelection) {}
		ulong execute();
		const SearchResult& getLastResult() const throw() {return lastResult_;}
	private:
		Type type_;
		bool onlySelection_;
		SearchResult lastResult_;
	};
	/// 
	class FindNextCommand : public EditorCommand {
	public:
		FindNextCommand(EditView& view, bool replace, bool forward) : EditorCommand(view), replace_(replace), forward_(forward) {}
		ulong execute();
		const SearchResult& getLastResult() const throw() {return lastResult_;}
	private:
		bool replace_, forward_;
		SearchResult lastResult_;
	};
	/// CN^
	class IncrementalSearchCommand : public EditorCommand {
	public:
		IncrementalSearchCommand(EditView& view,
			TextSearcher::Type type, bool forward, IncrementalSearcher::IEventListener* eventListener = 0)
			: EditorCommand(view), type_(type), forward_(forward), eventListener_(eventListener) {}
		ulong execute();
		const SearchResult& getLastResult() const throw() {return lastResult_;}
	private:
		TextSearcher::Type type_;
		bool forward_;
		IncrementalSearcher::IEventListener* eventListener_;		
		SearchResult lastResult_;
	};
	/// Cfg
	class IndentationCommand : public EditorCommand {
	public:
		IndentationCommand(EditView& view, bool indent, bool tabIndent, ushort level)
			: EditorCommand(view), indent_(indent), tabIndent_(tabIndent), level_(level) {}
		ulong execute();
	private:
		bool indent_;
		bool tabIndent_;
		ushort level_;
	};
	/// ͏Ԃ̃gO
	class InputStatusToggleCommand : public EditorCommand {
	public:
		enum Type {
			IME_STATUS,		///< IME
			OVERTYPE_MODE,	///< }/㏑[h
			SOFT_KEYBOARD	///< \tgL[{[h
		};
		InputStatusToggleCommand(EditView& view, Type type) : EditorCommand(view), type_(type) {}
		ulong execute();
	private:
		Type type_;
	};
	/// s
	class LineBreakCommand : public Private::EditorCommandBase<bool> {
	public:
		LineBreakCommand(EditView& view, bool previousLine) : Private::EditorCommandBase<bool>(view, previousLine) {}
		ulong execute();
	};
	/// ͕̓ω郂[h̐ݒ
	class NextInputVariationCommand : public Private::EditorCommandBase<NextCharVariation> {
	public:
		NextInputVariationCommand(EditView& view, NextCharVariation variation) : Private::EditorCommandBase<NextCharVariation>(view, variation) {}
		ulong execute();
	};
	/// ⊮EBhEJ
	class OpenCompletionWindowCommand : public EditorCommand {
	public:
		OpenCompletionWindowCommand(EditView& view) : EditorCommand(view) {}
		ulong execute();
	};
	/// ĕϊ
	class ReconversionCommand : public EditorCommand {
	public:
		ReconversionCommand(EditView& view) : EditorCommand(view) {}
		ulong execute();
	};
	/// IgA`IJn
	class RowSelectionExtensionCommand : public EditorCommand {
	public:
		enum Type {
			NEXT_CHARACTER,		///< ̕
			PREVIOUS_CHARACTER,	///< O̕
			LEFT_CHARACTER,		///< ̕
			RIGHT_CHARACTER,	///< E̕
			NEXT_WORD,		///< ̒P̐擪
			PREVIOUS_WORD,	///< O̒P̐擪
			LEFT_WORD,		///< ̒P̐擪
			RIGHT_WORD,		///< E̒P̐擪
			NEXT_WORDEND,		///< ̒P̏I[
			PREVIOUS_WORDEND,	///< O̒P̏I[
			LEFT_WORDEND,		///< ̒P̏I[
			RIGHT_WORDEND,		///< E̒P̏I[
			NEXT_LINE,		///< ̍s
			PREVIOUS_LINE,	///< O̍s
			START_OF_LINE,			///< s
			END_OF_LINE,			///< s
			FIRST_CHAR_OF_LINE,		///< s̍ŏ̕
			LAST_CHAR_OF_LINE,		///< s̍Ō̕
			START_OR_FIRST_OF_LINE,	///< ݈ʒuɂAss̍ŏ̕
			END_OR_LAST_OF_LINE,	///< ݈ʒuɂAss̍Ō̕
		};
		RowSelectionExtensionCommand(EditView& view, Type type) : EditorCommand(view), type_(type) {}
		ulong execute();
	private:
		Type type_;
	};
	/// I̍쐬
	class SelectionCreationCommand : public EditorCommand {
	public:
		enum Type {
			ALL,			///< SeLXg
			CURRENT_WORD	///< ݂̒P
		};
		SelectionCreationCommand(EditView& view, Type type) : EditorCommand(view), type_(type) {}
		ulong execute();
	private:
		Type type_;
	};
	/// ^uƋ󔒂̕ϊ
	class TabifyCommand : public Private::EditorCommandBase<bool> {
	public:
		TabifyCommand(EditView& view, bool tabify) : Private::EditorCommandBase<bool>(view, tabify) {}
		ulong execute();
	};
	/// eLXg̓
	class TextInputCommand : public Private::EditorCommandBase<string_t> {
	public:
		TextInputCommand(EditView& view, const string_t& text) : Private::EditorCommandBase<string_t>(view, text) {}
		ulong execute();
	};
	/// eLXg̓ւ
	class TranspositionCommand : public EditorCommand {
	public:
		enum Type {
			CHARACTERS,	///< 
			LINES,		///< s
			WORDS,		///< P
//			SENTENCES,	///< 
//			PARAGRAPHS	///< i
		};
		TranspositionCommand(EditView& view, Type type) : EditorCommand(view), type_(type) {}
		ulong execute();
	private:
		Type type_;
	};
	/// ɖ߂/蒼
	class UndoCommand : public Private::EditorCommandBase<bool> {
	public:
		UndoCommand(EditView& view, bool undo) : Private::EditorCommandBase<bool>(view, undo) {}
		ulong execute();
	};
} // namespace StandardCommands


/// I
class Selection {
public:
	/// fXgN^
	virtual ~Selection() {}
	/**
	 *	I͈͂̃eLXgNbv{[hɃRs[
	 *	@param alsoSendToClipboardRing Nbv{[hOɂRs[ꍇ true
	 */
	virtual void copy(bool alsoSendToClipboardRing) = 0;
	/**
	 *	I͈͂̃eLXg폜Nbv{[hɃRs[
	 *	@param alsoSendToClipboardRing Nbv{[hOɂRs[ꍇ true
	 */
	virtual void cut(bool alsoSendToClipboardRing) = 0;
	/// I͈͂̃eLXg폜
	virtual void erase() = 0;
	/// ANeBu|Cg (Lbg) Ԃ
	virtual Caret& getActivePoint() const = 0;
	/// AJ[|Cg (}[N) Ԃ
	virtual VisualPoint& getAnchorPoint() const = 0;
	/// 2_̂hLg̏I[ɋ߂Ԃ
	const VisualPoint& getEndPoint() const {return std::max(static_cast<const VisualPoint&>(getActivePoint()), getAnchorPoint());}
	/// ͈͂Ԃ
	virtual TextRange getRange() const {return TextRange(getAnchorPoint(), getActivePoint());}
	/**
	 *	݂̑Iwŝǂ͈̔͂܂ł邩Ԃ
	 *	@param line					ׂs
	 *	@param startChar, endChar	[out] JnʒuƏIʒuB
	 *								JnʒuwsOɂꍇ 0BIʒuwsɂꍇ -1
	 */
	virtual void getRangeOnLine(length_t line, length_t* startChar, length_t* endChar) const = 0;
	/// 2_̂hLg̐擪ɋ߂Ԃ
	const VisualPoint& getStartPoint() const {return std::min(static_cast<const VisualPoint&>(getActivePoint()), getAnchorPoint());}
	/**
	 *	IeLXgԂ
	 *	@param lineBreakPolicy s̈B`Ȉꍇ̓hLg̊̉sg
	 *	@return eLXg
	 */
	virtual string_t getText(LineBreakRetrievePolicy lineBreakPolicy = LBRP_PHYSICAL_DATA) const = 0;
	/// I󂩂Ԃ
	virtual bool isEmpty() const = 0;
	/// NCAgWI͈͏ォǂ
	virtual bool isPointOver(const POINT& pt) const = 0;
	/// I`Ԃ
	virtual bool isRectangle() const = 0;
	/**
	 *	2_𓯂ʒuɈړ
	 *	@param pos		ʒu
	 *	@param reveal	IɂȂ悤Ƀr[XN[
	 */
	void moveTo(const CharPos& pos, bool reveal) {select(pos, pos, false, reveal);}
	/**
	 *	Nbv{[heLXg\t
	 *	@param fromClipboardRing	Nbv{[hOgꍇ true
	 */
	virtual void paste(bool fromClipboardRing) = 0;
	/**
	 *	weLXgŒu
	 *	@param first, last			ueLXg
	 *	@param rectangleInsertion	`}
	 */
	virtual void replace(const char_t* first, const char_t* last, bool rectangleInsertion = false) = 0;
	/**
	 *	weLXgŒu
	 *	@param text					ueLXg
	 *	@param rectangleInsertion	`}
	 */
	void replace(const string_t& text, bool rectangleInsertion = false) {replace(text.data(), text.data() + text.length(), rectangleInsertion);}
	/**
	 *	͈͂I
	 *	@param range		͈
	 *	@param rectangle	`I
	 *	@param reveal		IɂȂ悤Ƀr[XN[
	 */
	void select(const TextRange& range, bool rectangle, bool reveal) {select(range.pos1_, range.pos2_, rectangle, reveal);}
	/**
	 *	͈͂I
	 *	@param anchorPosition	AJ[|Cg (}[N)
	 *	@param activePosition	ANeBu|Cg (Lbg)
	 *	@param rectangle		`I
	 *	@param reveal			IɂȂ悤Ƀr[XN[
	 */
	virtual void select(const CharPos& anchorPosition, const CharPos& activePosition, bool rectangle, bool reveal) = 0;
};

/**
 *	@brief Ascension eLXgGfB^̃r[
 *
 *	<h3>KvpA</h3>
 *
 *	<ul>
 *		<li>OLE hbOAhhbvgpꍇ́A
 *	gݍ݃AvP[VXbh @c OleInitialize ĂяoĂKv</li>
 *		<li>c[`bvgꍇ @c InitCommonControlsEx ĂяoĂKv</li>
 *		<li>̓\yуC^[tFCX͑S Unicode gp邽߁A
 *	 Windows NT n݂̂ƂȂ</li>
 *		<li>̃NX͌_ł̓XbhZ[tł<strong>Ȃ</strong></li>
 *		<li> Unicode ̒`ɂ͏]ĂȂ</li>
 *	</ul>
 *
 *	<h3>oeLXg֘ÃEBhEX^C</h3>
 *
 *	eLXgE񂹂ŕ\邽߂ @c WS_EX_RIGHT AE獶ɕ\邽߂ @c WS_EX_RTLREADING
 *	͂B̐ݒɂ͑ LayoutSettings ̊YogpȂ΂ȂȂ
 *
 *	܂ @c WS_EX_LAYOUTRTL gpłȂB̃X^Cݒ肵ꍇ͖̓`ł
 *
 *	XN[o[ɕ\ɂ̓NCAg @c WS_EX_LEFTSCROLLBAR ݒ肵Ȃ΂ȂȂ
 *
 *	̐ݒꊇĕύXꍇ EditView::setTextDirection gƂł
 *
 *	[ (CWP[^}[Wƍsԍ) ̈ʒu̓eLXg񂹂ł΍[A
 *	E񂹂łΉE[ɂȂ
 *
 *	<h3>Rs[RXgN^ɂ镡ɂ (To deriver)</h3>
 *
 *	EditView ̑cNX͑SăRs[RXgN^ĂA
 *	̃NXłRs[RXgN^găr[𕡐邱Ƃo (
 *	cNXƓlAEBhE͍쐬Ȃ)Bf[^oɑ
 *	̃NX͈ꕔ̃o𕡐ƕŋL
 *
 *	Lf[^oɂ̓CAEg֘A̐ݒ肪ʂɊ܂܂ĂB
 *	̓Rs[ԂňقȂ郌CAEgݒłȂƂƂӖĂ
 *
 *	͋Lf[^o<strong>L</strong>B
 *	LȂr[폜ĂLf[^͔jȂA
 *	Lr[폜ƁAL͂̃r[畡ꂽ̃r[ɈڂB
 *	čŌɎcr[폜ꂽƂALf[^͔j󂳂B
 *	̂߃Rs[RXgN^ł͕̃r[A
 *	̃r[IWĩr[LB܂A
 *	r[͎j󂳂ꂽƂɃIWiɒʒmāAN[Xg玩菜
 *
 *	܂ALێr[͎ɑ΂ݒ̍XV𑼂̃r[ɒʒmƂڂB
 *	NCAgtHgsԊuAAvP[V`sƂݒ̕ύXr[ɑ΂čsƁA
 *	Lr[ɏ`dALr[ƑSĂ̕ɐݒ肪f̂ŁA
 *	NCAg͂֘ASẴr[ݒ肷Kv͖
 *
 *	<strong>Rs[RXgN^ɂĕꂽr[́A
 *	ɂŏqׂ悤ȕÅ֌W</strong>ƂƂɒӂȂ΂ȂȂB
 *	̊֌W EditView::isCloneOf \bhŒׂ邱Ƃł
 *
 *	<h3>`̓Ɖ</h3>
 *
 *	܂Ƃ܂sۂɑSĂ̒iKŕ`sĂƓ삪xȂ̂ŁA
 *	EditView ͕`̓s߂ EditView::freeze \bhA
 *	邽߂ EditView::unfreeze \bh2pӂĂB
 *	AEditView::invalidateLine AEditView::invalidateLines
 *	͑ɂ͍ĕ`s킸A`̕KvȍsL^ĂA
 *	ƂɈxɕ`sB̂ EditView ̂قƂǂ̑
 *	Window::invalidateRect 𒼐ڌĂяôł͂ȂAL2̃\bhōĕ`s
 *
 *	֐̂߂ɓƂ̉s\bh͎̕A
 *	/s (J EditView::doUnfreeze g)
 *
 *	hLg (EditDoc::resetContent ĂԂ) JEg 0 ɖ߂
 *
 *	@see EditDoc
 */
class EditView :
		public Manah::View<EditDoc, DocumentUpdate>,
		public Manah::Windows::Controls::CustomControl<EditView>,
		virtual public Ascension::LineLayoutManager::IEventListener,
#ifndef ASCENSION_NO_TEXT_SERVICES_FRAMEWORK
		virtual public ITextStoreACP,
#endif /* !ASCENSION_NO_TEXT_SERVICES_FRAMEWORK */
		virtual public IDropSource, virtual public IDropTarget {
	typedef Manah::Windows::Controls::CustomControl<EditView> BaseControl;
	DEFINE_WINDOW_CLASS() {
		name = L"AscensionView";
		style = CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW | CS_DBLCLKS;
		bgColor = COLOR_WINDOW;
		cursor = IDC_IBEAM;
	}

public:
	/**
	 *	@brief IvV
	 *
	 *	ݒ/擾̂߂̃\bhƃ\bĥŁA
	 *	ׂȂ̂͂ɏW߂
	 *
	 *	@see EditView::getOptions AEditView::setOptions
	 */
	struct Options {
		AutoIndentType	autoIndentType;					///< Cfg̎
		length_t		recognizingLineCount;			///< X}[gCfgΊʌōls
		InputSequenceCheckLanguage	sequenceCheckingLanguages;	///< ̓V[PX`FbNLɂ錾
		std::bitset<BooleanOptions::DISPLAY_BOOLEAN_OPTIONS_COUNT>	appearance;	///< O̐ݒ
		std::bitset<BooleanOptions::BEHAVIOR_BOOLEAN_OPTIONS_COUNT>	behavior;	///< ̐ݒ

		/// RXgN^
		Options() : autoIndentType(AIT_BLOCK), recognizingLineCount(100), sequenceCheckingLanguages(ISCL_ALL) {
			using namespace BooleanOptions;
			appearance.set(BEEP_ON_SOME_FAILURE);
			appearance.set(HIDE_CURSOR_FOR_CHAR_INPUT);
			appearance.set(HIGHLIGHT_PREVIOUS_AS_MATCH_BRACKET);
			appearance.set(LOCALE_SPECIFIC_CARET_SHAPE);
			appearance.set(SHOW_HINT_ON_LINK);
			appearance.set(USE_EDITOR_FONT_FOR_COMPLETION);
			behavior.set(OLE_DRAG_AND_DROP);
		}
	};

	// RXgN^
public:
	EditView(EditDoc& document);
	EditView(const EditView& rhs);
protected:
	virtual ~EditView();

	// \bh
public:
	// 쐬
	virtual bool	create(HWND parent, const RECT& rect, DWORD style, DWORD exStyle);

	// CxgXi
	void	addEventListener(IEditViewEventListener& eventListener);
	void	removeEventListener(IEditViewEventListener& eventListener);

	// ̎擾
	static UINT			canPaste();
	Encodings::CodePage	getClipboardNativeCodePage() const throw();
	LayoutSetter&		getLayoutSetter() const throw();
	Lexer&				getLexer() const throw();
	NextCharVariation	getNextCharacterVariation() const;
	const Options&		getOptions() const throw();
	ulong				getScrollRatio(bool horizontal) const throw();
	bool				isCloneOf(const EditView& rhs) const throw();
	bool				isGUIEditable() const throw();
	bool				isOvertypeMode() const throw();
	bool				isTextDirectionRightToLeft() const throw();

	// ̐ݒ
	void	setClipboardNativeCodePage(Encodings::CodePage cp);
	void	setGUIEditability(bool editable) throw();
	void	setNextCharacterVariation(NextCharVariation variation);
	void	setOptions(const Options& options);
	void	setOvertypeMode(bool overtype = true);
	void	setTextDirection(bool rightToLeft);

	// {
	virtual bool	inputCharacter(CodePoint cp);
	virtual bool	insertText(const char_t* first, const char_t* last, bool asRectangle);
	bool			insertText(const string_t& text, bool asRectangle);

	// 
	const DocumentBoundaryDetector&	getBoundaryDetector() const throw();
	static IncrementalSearcher&		getIncrementalSearcher() throw();
	static TextSearcher&			getTextSearcher() throw();
	void							highlightMatchTexts(bool highlight = true);

	// XN[
	void	beginAutoScroll();
	bool	endAutoScroll();

	// ⊮EBhE
	void	closeCompletionWindow();
	void	openCompletionWindow();

#ifndef ASCENSION_NO_MIGEMO
	// Migemo
	static const WCHAR*	getMigemoPath(bool runtime) throw();
	static void			setMigemoPath(const WCHAR* pathName, bool runtime);
#endif /* !ASCENSION_NO_MIGEMO */

	// I
	Selection&	getSelection() const throw();

	// Nbv{[hO
	static ClipboardRing&	getClipboardRing() throw();

	// ݈ʒuӂ̃eLXg
	bool		getNearestWordFromCaret(CharPos* startPos, CharPos* endPos, string_t* word) const;
	bool		getNearestWordFromCursor(CharPos* startPos, CharPos* endPos, string_t* word) const;
	string_t	getPrecedingWord(length_t maxLength) const;

	// Zk
	bool					expandPrecedingWordAsAbbreviation();
	static Abbreviations&	getAbbreviations() throw();

	// ubN}[N
	Bookmarker&	getBookmarker() const throw();

#ifndef ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER
	// Global IME
	void	enableActiveInputMethod(bool enable = true) throw();
	bool	isActiveInputMethodEnabled() const throw();
#endif /* !ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER */

	// [UC^[tFCX
	void	beep();
	bool	checkGUIEditability();
#ifndef ASCENSION_NO_ACTIVE_ACCESSIBILITY
	HRESULT	getAccessibleObject(IAccessible*& acc) const throw();
#endif /* !ASCENSION_NO_ACTIVE_ACCESSIBILITY */
	void	hideToolTip();
	void	showToolTip(const string_t& text, ulong timeToWait = -1, ulong timeRemainsVisible = -1);

	// `̓A
	void	freeze();
	bool	isFreezed() const throw();
	void	unfreeze();

	// }EX̋/s
	void	enableMouseOperation(bool enable);

	// [eBeB
	CharPos			charFromPos(const POINT& pt, bool ignoreExtenders, bool* truncated = 0) const;
	length_t		columnFromChar(const CharPos& pos) const;
	CharPos			displayCharFromLogicalChar(const CharPos& logical) const;
	length_t		displayLineFromLogicalLine(length_t line) const;
	bool			findMatchBracket(const CharPos& pos, CharPos& foundPosition, bool requireBody) const;
	length_t		getDisplayLineCount() const;
	void			getDisplayLineOffsetIndex(length_t displayLine, length_t& logicalLine, length_t& offset) const;
	length_t		getVisibleLineCount() const throw();
	length_t		getVisibleCharCount() const throw();
	HitTestResult	hitTest(const POINT& pt) const;
	bool			isOverInvokableLink(const POINT& pt, char_t*& text) const;
	CharPos			logicalCharFromDisplayChar(const CharPos& displayPosition) const;
	POINT			posFromChar(const CharPos& pos) const;

	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN_NO_REF_COUNT()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IDropSource)
		IMPLEMENTS_INTERFACE(IDropTarget)
#ifndef ASCENSION_NO_TEXT_SERVICES_FRAMEWORK
		IMPLEMENTS_INTERFACE(ITextStoreACP)
#endif /* !ASCENSION_NO_TEXT_SERVICES_FRAMEWORK */
//		IMPLEMENTS_INTERFACE(IDispatch)
//		IMPLEMENTS_INTERFACE(IViewObjectEx)
//		IMPLEMENTS_INTERFACE(IViewObject2)
//		IMPLEMENTS_INTERFACE(IViewObject)
//		IMPLEMENTS_INTERFACE(IOleInPlaceObjectWindowless)
//		IMPLEMENTS_INTERFACE(IOleInPlaceObject)
//		IMPLEMENTS_INTERFACE(IOleWindow, IOleInPlaceObjectWindowless)
//		IMPLEMENTS_INTERFACE(IOleInPlaceActiveObject)
//		IMPLEMENTS_INTERFACE(IOleControl)
//		IMPLEMENTS_INTERFACE(IOleObject)
//		IMPLEMENTS_INTERFACE(IPersistStreamInit)
//		IMPLEMENTS_INTERFACE(ISupportErrorInfo)
	END_INTERFACE_TABLE()

	// LineLayoutManager::IEventListener C^[tFCX
	void	onChangedBookmark(length_t line);
	void	onChangedLayout();
	void	onChangedMaximumWidthLine();
	void	onChangedTextAlignment();
	void	onChangedTextDirection();
	void	onChangedVerticalRulerWidth();
	void	onClearedAllBookmarks();
	Manah::Windows::GDI::ClientDC	onQueryDeviceContext();

	// IDropSource C^[tFCX
	STDMETHODIMP	QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState);
	STDMETHODIMP	GiveFeedback(DWORD dwEffect);

	// IDropTarget C^[tFCX
	STDMETHODIMP	DragEnter(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);
	STDMETHODIMP	DragOver(DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);
	STDMETHODIMP	DragLeave();
	STDMETHODIMP	Drop(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);

#ifndef ASCENSION_NO_TEXT_SERVICES_FRAMEWORK
	// ITextStoreACP C^[tFCX
	STDMETHODIMP	AdviseSink(REFIID riid, IUnknown* punk, DWORD dwMask);
	STDMETHODIMP	UnadviseSink(IUnknown* punk);
	STDMETHODIMP	RequestLock(DWORD dwLockFlags, HRESULT* phrSession);
	STDMETHODIMP	GetStatus(TS_STATUS* pdcs);
	STDMETHODIMP	QueryInsert(LONG acpTestStart, LONG acpTestEnd, ULONG cch, LONG* pacpResultStart, LONG* pacpResultEnd);
	STDMETHODIMP	GetSelection(ULONG ulIndex, ULONG ulCount, TS_SELECTION_ACP* pSelection, ULONG* pcFetched);
	STDMETHODIMP	SetSelection(ULONG ulCount, const TS_SELECTION_ACP* pSelection);
	STDMETHODIMP	GetText(LONG acpStart, LONG acpEnd,
						WCHAR* pchPlain, ULONG cchPlainReq, ULONG* pcchPlainRet,
						TS_RUNINFO* prgRunInfo, ULONG cRunInfoReq, ULONG* pcRunInfoRet, LONG* pacpNext);
	STDMETHODIMP	SetText(DWORD dwFlags, LONG acpStart, LONG acpEnd, const WCHAR* pchText, ULONG cch, TS_TEXTCHANGE* pChange);
	STDMETHODIMP	GetFormattedText(LONG acpStart, LONG acpEnd, IDataObject** ppDataObject);
	STDMETHODIMP	GetEmbedded(LONG acpPos, REFGUID rguidService, REFIID riid, IUnknown** ppunk);
	STDMETHODIMP	QueryInsertEmbedded(const GUID* pguidService, const FORMATETC* pFormatEtc, BOOL* pfInsertable);
	STDMETHODIMP	InsertEmbedded(DWORD dwFlags, LONG acpStart, LONG acpEnd, IDataObject* pDataObject, TS_TEXTCHANGE* pChange);
	STDMETHODIMP	InsertTextAtSelection(DWORD dwFlags,
						const WCHAR* pchText, ULONG cch, LONG* pacpStart, LONG* pacpEnd, TS_TEXTCHANGE* pChange);
	STDMETHODIMP	InsertEmbeddedAtSelection(DWORD dwFlags,
						IDataObject* pDataObject, LONG* pacpStart, LONG* pacpEnd, TS_TEXTCHANGE* pChange);
	STDMETHODIMP	RequestSupportedAttrs(DWORD dwFlags, ULONG cFilterAttrs, const TS_ATTRID* paFilterAttrs);
	STDMETHODIMP	RequestAttrsAtPosition(LONG acpPos, ULONG cFilterAttrs, const TS_ATTRID* paFilterAttrs, DWORD dwFlags);
	STDMETHODIMP	RequestAttrsTransitioningAtPosition(LONG acpPos, ULONG cFilterAttrs, const TS_ATTRID* paFilterAttrs, DWORD dwFlags);
	STDMETHODIMP	FindNextAttrTransition(LONG acpStart, LONG acpHalt,
						ULONG cFilterAttrs, const TS_ATTRID* paFilterAttrs, DWORD dwFlags,
						LONG* pacpNext, BOOL* pfFound, LONG* plFoundOffset);
	STDMETHODIMP	RetrieveRequestedAttrs(ULONG ulCount, TS_ATTRVAL* paAttrVals, ULONG* pcFetched);
	STDMETHODIMP	GetEndACP(LONG* pacp);
	STDMETHODIMP	GetActiveView(TsViewCookie* pvcView);
	STDMETHODIMP	GetACPFromPoint(TsViewCookie vcView, const POINT* ptScreen, DWORD dwFlags, LONG* pacp);
	STDMETHODIMP	GetTextExt(TsViewCookie vcView, LONG acpStart, LONG acpEnd, RECT* prc, BOOL* pfClipped);
	STDMETHODIMP	GetScreenExt(TsViewCookie vcView, RECT* prc);
	STDMETHODIMP	GetWnd(TsViewCookie vcView, HWND* phwnd);
#endif /* !ASCENSION_NO_TEXT_SERVICES_FRAMEWORK */
				
	// J[eBeB (`)
protected:
	virtual void		drawBorder(Manah::Windows::GDI::PaintDC& dc,
							int left, int top, int right, int bottom, BorderType type, COLORREF color);
	virtual int			drawEOFMarker(Manah::Windows::GDI::PaintDC& dc, int x, int y);
	virtual length_t	drawLine(Manah::Windows::GDI::PaintDC& dc, length_t line, int y, bool caretLine);
	virtual int			drawLineTerminator(Manah::Windows::GDI::PaintDC& dc,
							int x, int y, LineBreak lineBreak, bool restricted, COLORREF bgColor, bool mirrored);
	virtual void		drawVerticalRuler(Manah::Windows::GDI::PaintDC& dc, length_t startLine, length_t endLine);
	void				invalidateLine(length_t line);
	void				invalidateLines(length_t startLine, length_t endLine);
private:
	void				doUnfreeze();
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	void				updateMemoryDeviceContext();
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	// J[eBeB (ʒuvZ)
protected:
	string_t				calculateSpacesReachingVirtualPoint(length_t line, ulong virtualX) const;
	static const char_t*	makeCaretPosValid(const char_t* first, const char_t* last, const char_t* caret, bool backward);
private:
	length_t	mapAbsoluteXToCharacter(length_t line, int x, bool ignoreExtenders, bool* truncated = 0) const;
	int			mapAbsoluteXToClientX(int x, int lineWidth) const;
	int			mapClientXToAbsoluteX(int x, int lineWidth) const;

	// J[eBeB (XN[ʒuvZ)
private:
	long	mapInternalXToScrollBoxX(long x) const;
	long	mapScrollBoxXToInternalX(long x) const;

	// J[eBeB (I͈͂ƃLbg)
protected:
	void			checkMatchBrackets();
	virtual void	recreateCaret();
private:
	void	onSelectionChanged(const TextRange& oldRange, bool wasRectangle, bool reveal, bool forDocumentUpdate);

	// J[eBeB (̑)
protected:
	bool			charIsInCommentOrQuotation(const CharPos& pos) const;
	static char_t	convertCharacter(char_t ch, NextCharVariation ncv);
	bool			getNearestWord(const CharPos& pos, length_t* startChar, length_t* endChar, string_t* word) const;
	void			initializeWindow(bool copyConstructing);
	virtual void	updateCaretPosition();
	virtual void	updateGDIObjects();
	void			updateIMECompositionWindowPosition();
	void			updateScrollInfo(bool horizontal, bool vertical);

	// I[o[Ch\ȕ`惁\bhB̎͋
protected:
	virtual void		drawIndicatorMargin(length_t line, Manah::Windows::GDI::DC& dc, const RECT& rect);
	virtual string_t	queryInvokableLinkMessage(const string_t& uri);
	virtual void		queryLineColors(length_t line, COLORREF& fgColor, COLORREF& bgColor);

protected:
	virtual OVERRIDE_DISPATCH_EVENT(EditView);

	// AbstractView<DocumentUpdate> C^[tFCX
protected:
	void	onAddedToDocument();
	void	onResetDocument();
	void	onUpdate(const DocumentUpdate& update);

	// bZ[Wnh
protected:
	virtual void	onCaptureChanged(HWND newWindow);						// WM_CAPTURECHANGED
	void			onChar(UINT ch, UINT flags);							// WM_CHAR
	virtual bool	onCommand(WORD id, WORD notifyCode, HWND control);		// WM_COMMAND
	virtual bool	onContextMenu(HWND window, const POINT& pt);			// WM_CONTEXTMENU
	virtual void	onDestroy();											// WM_DESTROY
	virtual void	onHScroll(UINT sbCode, UINT pos, HWND scrollBar);		// WM_HSCROLL
	virtual bool	onIMEComposition(WPARAM wParam, LPARAM lParam);			// WM_IME_COMPOSITION
	virtual void	onIMEEndComposition();									// WM_IME_ENDCOMPOSITION
	virtual LRESULT	onIMERequest(WPARAM command, LPARAM lParam);			// WM_IME_REQUEST
	virtual void	onIMEStartComposition();								// WM_IME_STARTCOMPOSITION
	virtual bool	onKeyDown(UINT ch, UINT flags);							// WM_KEYDOWN
	virtual void	onKillFocus(HWND newWindow);							// WM_KILLFOCUS
	virtual void	onLButtonDblClk(UINT flags, const POINT& pt);			// WM_LBUTTONDBLCLK
	virtual void	onLButtonDown(UINT flags, const POINT& pt);				// WM_LBUTTONDOWN
	virtual void	onLButtonUp(UINT flags, const POINT& pt);				// WM_LBUTTONUP
	virtual void	onMouseMove(UINT flags, const POINT& pt);				// WM_MOUSEMOVE
	virtual bool	onMouseWheel(UINT flags, short zDelta, const POINT& pt);// WM_MOUSEWHEEL
	virtual bool	onNotify(int id, LPNMHDR nmhdr);						// WM_NOTIFY
	virtual void	onPaint(Manah::Windows::GDI::PaintDC& dc);				// WM_PAINT
	virtual void	onRButtonDown(UINT flags, const POINT& pt);				// WM_RBUTTONDOWN
	virtual bool	onSetCursor(HWND window, UINT hitTest, UINT message);	// WM_SETCURSOR
	virtual void	onSetFocus(HWND oldWindow);								// WM_SETFOCUS
	virtual void	onSize(UINT type, int cx, int cy);						// WM_SIZE
	virtual bool	onSysChar(UINT ch, UINT flags);							// WM_SYSCHAR
	virtual void	onSysColorChange();										// WM_SYSCOLORCHANGE
	virtual	bool	onSysKeyDown(UINT ch, UINT flags);						// WM_SYSKEYDOWN
	virtual	bool	onSysKeyUp(UINT ch, UINT flags);						// WM_SYSKEYUP
	virtual void	onTimer(UINT eventId);									// WM_TIMER
	virtual void	onUniChar(UINT ch, UINT flags);							// WM_UNICHAR
	virtual void	onVScroll(UINT sbCode, UINT pos, HWND scrollBar);		// WM_VSCROLL

	// NX
private:
	class CloneIterator {
	public:
		CloneIterator(EditView& view) : original_(view.originalView_),
				it_(view.originalView_->clones_->begin()), isHead_(true) {}
		EditView& get() const {assert(!isEnd()); return isHead_ ? *original_ : **it_;}
		bool isEnd() const {return !isHead_ && it_ == original_->clones_->end();}
		void next() {
			if(isHead_)									isHead_ = false;
			else if(it_ != original_->clones_->end())	++it_;
		}
		EditView& operator *() const {return get();}
		EditView* operator ->() {return &get();}
	private:
		EditView*						original_;
		std::set<EditView*>::iterator	it_;
		bool							isHead_;
	};
	class Selection : public Ascension::Selection, public Manah::Noncopyable, virtual public Caret::IEventListener {
	public:
		Selection(EditView& view) : view_(view), ignoreActiveMovement_(false), type_(LINEAR) {
			anchorPoint_ = view.getDocument().createEditPoint().release();
			anchorPoint_->synchronizeWithDocumentUpdate(true);
			anchorPoint_->excludeFromRestriction(true);
			activePoint_ = view.getDocument().createCaret(*anchorPoint_, this).release();
			activePoint_->synchronizeWithDocumentUpdate(true);
			activePoint_->excludeFromRestriction(true);
		}
		~Selection() {delete anchorPoint_; delete activePoint_;}
	public:
		void beginLineSelection();
		void beginWordSelection();
		void copy(bool alsoSendToClipboardRing);
		void cut(bool alsoSendToClipboardRing);
		void erase();
		Caret& getActivePoint() const {return *const_cast<Selection*>(this)->activePoint_;}
		VisualPoint& getAnchorPoint() const {return *const_cast<Selection*>(this)->anchorPoint_;}
		length_t getLineSelectionOriginalLine() const;
		void getWordSelectionOriginalWord(TextRange& word) const;
		void getRangeOnLine(length_t line, length_t* start, length_t* end) const;
		string_t getText(LineBreakRetrievePolicy lineBreakPolicy) const;
		bool isEmpty() const {return static_cast<CharPos>(*anchorPoint_) == *activePoint_;}
		bool isPastingFromClipboardRing() const {return toBoolean(type_ & PASTING_FROM_CLIPBOARD_RING);}
		bool isPointOver(const POINT& pt) const;
		bool isRectangle() const {return toBoolean(type_ & RECTANGLE);}
		void onCaretMoved(const Caret& self, const VisualPoint& anchor, const TextRange& oldRange, bool forDocumentUpdate);
		void paste(bool fromClipboardRing);
		void replace(const char_t* first, const char_t* last, bool rectangleInsertion /* = false */);
		void select(const CharPos& anchorPosition, const CharPos& activePosition, bool rectangle, bool reveal);
		void updateRectangleRegion();
	private:
		EditView&		view_;
		VisualPoint*	anchorPoint_;
		Caret*			activePoint_;
		bool			ignoreActiveMovement_;	// activePoint_ 瑗Ă onEditPointMoved 񖳎
		enum Type {LINEAR = 0, RECTANGLE = 1, PASTING_FROM_CLIPBOARD_RING = 2}	type_;

		length_t	temporaryAnchorLine_;	// sIAPIA`IJñAJ[|Cg̍sԍB
											// `I͕\sAȊȌꍇ͘_s
		length_t	boxSelectionActiveLine_;// `ĨANeBu|Cg̕\s
		int			boxSelectionAnchorX_;	// `ĨAJ[|Cg x W (Lbgʒu)
		int			boxSelectionActiveX_;	// `ĨANeBu|Cg x W (Lbgʒu)
		length_t	wordSelectionChars_[2];	// PI[hōŏɑIĂP̑O̕ʒu
	};
#ifndef ASCENSION_NO_ACTIVE_ACCESSIBILITY
	class AccessibleProxy;
#endif /* !ASCENSION_NO_ACTIVE_ACCESSIBILITY */

	// 
private:
	/// {^ǂ̂悤ȖړIŉĂ邩\
	enum LeftDownMode {
		LDM_NONE,				// ĂȂ
		LDM_SELECTION_CHARACTER,// I
		LDM_SELECTION_LINE,		// sI
		LDM_SELECTION_WORD,		// PI
		LDM_DRAGANDDROP,		// vZX̃hbOAhhbv
		LDM_DRAGANDDROPSELF,	// vZX̃hbOAhhbv
		LDM_DRAGANDDROPBOXSELF	// vZX̃hbOAhhbv (`)
	};

	/// ^C} ID
	enum {
		TIMERID_EXPANDSELECTION		= 0,	///< }EXhbOőI͈͂ύX
		TIMERID_EXPANDLINESELECTION	= 1,	///< }EXhbOőIsύX
		TIMERID_DRAGSCROLL			= 2,	///< OLE hbO
		TIMERID_CALLTIP				= 3,	///< c[`bv̑҂
		TIMERID_AUTOSCROLL			= 4,	///< XN[
		TIMERID_LINEPARSE			= 5,	///< ss
	};

	/// ReLXgj[Ȃǂ ID
	enum {
		WM_REDO	= WM_APP + 1,			// ɖ߂
		WM_SELECTALL,					// SđI
		ID_SHOWDIRECTIONALFORMATTERS,	// Unicode 䕶̕\
		ID_RTLREADING,					// E獶ɓǂ
		ID_TOGGLEIMESTATUS,				// IME J/
		ID_TOGGLESOFTKEYBOARD,			// \tgL[{[hJ/
		ID_RECONVERT,					// ĕϊ

		ID_INSERT_LRM,		// LRM (Left-to-right mark)
		ID_INSERT_RLM,		// RLM (Right-to-left mark)
		ID_INSERT_ZWJ,		// ZWJ (Zero width joiner)
		ID_INSERT_ZWNJ,		// ZWNJ (Zero width non-joiner)
		ID_INSERT_LRE,		// LRE (Left-to-right embedding)
		ID_INSERT_RLE,		// RLE (Right-to-left embedding)
		ID_INSERT_LRO,		// LRO (Left-to-right override)
		ID_INSERT_RLO,		// RLO (Right-to-left override)
		ID_INSERT_PDF,		// PDF (Pop directional formatting)
		ID_INSERT_WJ,		// WJ (Word Joiner)
		ID_INSERT_NADS,		// NADS (National digit shapes)	<- ȉ6͔񐄏R[h|Cg (Unicode 4.0)
		ID_INSERT_NODS,		// NODS (Nominal digit shapes)
		ID_INSERT_ASS,		// ASS (Activate symmetric swapping)
		ID_INSERT_ISS,		// ISS (Inhibit symmetric swapping)
		ID_INSERT_AAFS,		// AAFS (Activate Arabic form shaping)
		ID_INSERT_IAFS,		// IAFS (Inhibit Arabic form shaping)
		ID_INSERT_RS,		// RS (Record Separator)
		ID_INSERT_US,		// US (Unit Separator)
		ID_INSERT_IAA,		// Interlinear Annotation Anchor
		ID_INSERT_IAS,		// Interlinear Annotation Separator
		ID_INSERT_IAT,		// Interlinear Annotation Terminator

		ID_INSERT_U0020,	// U+0020 (Space)
		ID_INSERT_NBSP,		// NBSP (No-Break Space)
		ID_INSERT_U1680,	// U+1680 (Ogham Space Mark)
		ID_INSERT_MVS,		// MVS (Mongolian Vowel Separator)
		ID_INSERT_U2000,	// U+2000 (En Quad)
		ID_INSERT_U2001,	// U+2001 (Em Quad)
		ID_INSERT_U2002,	// U+2002 (En Space)
		ID_INSERT_U2003,	// U+2003 (Em Space)
		ID_INSERT_U2004,	// U+2004 (Three-Per-Em Space)
		ID_INSERT_U2005,	// U+2005 (Four-Per-Em Space)
		ID_INSERT_U2006,	// U+2006 (Six-Per-Em Space)
		ID_INSERT_U2007,	// U+2007 (Figure Space)
		ID_INSERT_U2008,	// U+2008 (Punctuation Space)
		ID_INSERT_U2009,	// U+2009 (Thin Space)
		ID_INSERT_U200A,	// U+200A (Hair Space)
		ID_INSERT_ZWSP,		// ZWSP (Zero Width Space)
		ID_INSERT_NNBSP,	// NNSBP (Narrwow No-Break Space)
		ID_INSERT_MMSP,		// MMSP (Medium Mathematical Space)
		ID_INSERT_U3000,	// U+3000 (Ideographic Space)
		ID_INSERT_NEL,		// NEL (Next Line)
		ID_INSERT_LS,		// LS (Line Separator)
		ID_INSERT_PS,		// PS (Paragraph Separator)
	};


	// f[^o
private:
	/* 啨 */
	static ClipboardRing				clipboardRing_;			// Nbv{[hO
	static Abbreviations				abbreviations_;			// Zk
	static TextSearcher					textSearcher_;			// eLXg
	static IncrementalSearcher			incrementalSearcher_;	// CN^
	std::auto_ptr<Selection>			selection_;				// I
	HWND								toolTip_;				// c[`bv
	char_t*								tipText_;				// c[`bṽeLXg
	std::auto_ptr<
		DocumentBoundaryDetector>		boundaryDetector_;		// eLXgĚ
	Armaiti::ComPtr<
		Armaiti::OLE::TextDataObject>	dragging_;				// OLE D&D IuWFNg
	std::auto_ptr<CompletionWindow>		completionWindow_;		// ͕⊮EBhE
	std::auto_ptr<AutoScrollOriginMark>	autoScrollOriginMark_;	// NX`Q
#ifndef ASCENSION_NO_ACTIVE_ACCESSIBILITY
	AccessibleProxy*					accessibleProxy_;
#endif /* !ASCENSION_NO_ACTIVE_ACCESSIBILITY */

#ifndef ASCENSION_NO_MIGEMO
	/* C/Migemo */
	static WCHAR	migemoRuntimePath_[MAX_PATH];	// Migemo DLL fBNg
	static WCHAR	migemoDictionaryPath_[MAX_PATH];	// Migemo fBNg
#endif /* !ASCENSION_NO_MIGEMO */

	/* LÂ̊Ǘ (NX̐Q) */
	EditView*				originalView_;	//  (this łΎ)
	std::set<EditView*>*	clones_;		// ̕ (łȂ null)

	/* ̋Lo */
	struct SharedData {
		Manah::Windows::Controls::Menu		contextMenu;		// ReLXgj[
		std::set<IEditViewEventListener*>	eventListeners;		// CxgXi
		LineLayoutManager					layoutManager;		// sCAEg
		Options								options;					// GȃIvV
		Encodings::CodePage					clipboardNativeCodePage;	// Nbv{[h̃R[hy[W
		int									caretWidth;					// ŌɌvZLbg
		bool								highlightMatches;			// ɈveLXg

		struct GDIObjects {
			HPEN	caretLinePen;					// ݍs̉
			HPEN	inactiveCaretLinePen;			// ݍs̉ (ANeBu)
			HPEN	indicatorMarginPen;				// CWP[^}[W̘g`̂Ɏgp
			HPEN	lineNumberPen;					// sԍ̘g`̂Ɏgp
			HPEN	lineTerminatorPen;				// sL`̂Ɏgp
			HPEN	restrictedLineTerminatorPen;	// i[COꂽsL`̂Ɏgp
			HBITMAP	caretBitmap;					// LbgɎgprbg}bv

			GDIObjects() : caretLinePen(0), inactiveCaretLinePen(0),
				indicatorMarginPen(0), lineNumberPen(0),
				lineTerminatorPen(0), restrictedLineTerminatorPen(0), caretBitmap(0) {}
			~GDIObjects() {
				::DeleteObject(caretLinePen);
				::DeleteObject(inactiveCaretLinePen);
				::DeleteObject(indicatorMarginPen);
				::DeleteObject(lineNumberPen);
				::DeleteObject(lineTerminatorPen);
				::DeleteObject(restrictedLineTerminatorPen);
				::DeleteObject(caretBitmap);
			}
		} gdiObjects;

		SharedData(EditView& view) : layoutManager(view.getDocument()), highlightMatches(false) {}
	} * sharedData_;

	/* [h */
	struct ModeState {
		POINT	lastMouseDownPoint;			// ŌɃ}EX{^ʒuBOLE hbOJnɎgp
		bool	overtype;					// ㏑[h
		bool	guiEditable;				// GUI NCAgҏW\
		bool	readyToExpandAbbrev;		// ZkWJł
		bool	cursorHiddenForCharInput;	// [U̓͂Jn̂ŃJ[\\
#ifndef ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER
		bool	activeInputMethodEnabled;	// Global IME g
#endif /* !ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER */

		ModeState() : overtype(false), guiEditable(true), readyToExpandAbbrev(false), cursorHiddenForCharInput(false)
#ifndef ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER
			, activeInputMethodEnabled(true)
#endif /* !ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER */
		{lastMouseDownPoint.x = lastMouseDownPoint.y = -1;}
	} modeState_;

	/* XN[ */
	struct ScrollInfo {
		POINT	position;			// XN[o[̈ʒu (x:Ay:)B
									// ̒l horizontalRatio  verticalRatio 悸
									// \Jnʒu (:ϕPʁA:\sP) B
									// eLXg̕\E񂹂̏ꍇ͐ʒu͉E[0ɂȂ
		ulong	horizontalRatio;	// XN[1r[̉ɑ邩 (ʂ1)
		ulong	verticalRatio;		// XN[1sr[̉sɑ邩 (ʂ1)
		ScrollInfo() throw() : horizontalRatio(1), verticalRatio(1) {position.x = position.y = 0;}
		ulong getX() const throw() {return position.x * horizontalRatio;}
		ulong getY() const throw() {return position.y * verticalRatio;}
	} scrollInfo_;

	/*  */
	struct FreezeInfo {
		ulong				count;					// JE^B0ȊOłΕ`擀
		POINT				scrollPosition;			// ɗv̂XN[ʒuB𓀎
													// ̈ʒuɃXN[Bv (-1, -1)
		struct {bool x, y;} needUpdateScrollInfo;	//  updateScrollInfo Ăяo
													// tOB𓀎ɂ炽߂ČĂтȂ
		std::set<length_t>	invalidLines;			// ɍĕ`vꂽsB
													// invalidateLine(s)  onUpdate Ǘ
		FreezeInfo() throw() : count(0) {
			scrollPosition.x = scrollPosition.y = -1; needUpdateScrollInfo.x = needUpdateScrollInfo.y = false;}
	} freezeInfo_;
	
	/* s`LoX */
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	Manah::Windows::GDI::AutoDC	memDC_;			// foCXReLXg
	HBITMAP						lineBitmap_;	// memDC_ ɌѕtĂ1s`prbg}bv
	HBITMAP						oldLineBitmap_;
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	/*  */
	bool				imeCompositionActivated_;	// IME œ͒
	LeftDownMode		leftDownMode_;				// LeftDownMode `Q
	NextCharVariation	nextCharVariation_;			// NextCharVariation `Q
	EditOperation		lastOperation_;				// OɍsҏW
	ulong				mouseOperationDisabledCount_;
	CharPos		hilightedBracketPositions_[2];	// \Ίʂ̈ʒu (ꍇ CharPos::INVALID_POSITION)
	length_t	firstVisibleLine_;	// ݂̐擪s (_sB\s m_ptScroll.y)B
									// _s<->\sϊ̂߂̃LbV
									// cXN[ (OnVScroll)A܂Ԃ񂪕ωƂ (OnSize,
									// ModifyFontInfo)A\Jn_sO̍sҏWꂽƂ
									// (OnUpdate) XV <- !݂͎gĂȂ!

	/* XN[ */
	struct AutoScroll {
		POINT	indicatorPosition;	// CWP[^̈ʒu (NCAgW)
		bool	scrolling;			// XN[
		AutoScroll() : scrolling(false) {}
	} autoScroll_;

	friend class LineLayoutManager;
	friend class VisualPoint;
	friend class EditorCommand;
	friend class Selection;
};


// CC֐̎
/////////////////////////////////////////////////////////////////////////////

/**
 *	xgXi̓o^
 *	@param eventListener Vo^CxgXi
 */
inline void EditView::addEventListener(IEditViewEventListener& eventListener) {
	assertValid(); sharedData_->eventListeners.insert(&eventListener);}

/**
 *	u\tv삪\擾
 *	@return \t\ȃNbv{[h`Bs̏ꍇ0
 */
inline UINT EditView::canPaste() {
	const UINT boxClipFormat = ::RegisterClipboardFormatW(ASCENSION_RECTANGLE_TEXT_CLIP_FORMAT);

	if(boxClipFormat != 0 && toBoolean(::IsClipboardFormatAvailable(boxClipFormat)))
		return boxClipFormat;
	if(toBoolean(::IsClipboardFormatAvailable(CF_UNICODETEXT)))
		return CF_UNICODETEXT;
	if(toBoolean(::IsClipboardFormatAvailable(CF_TEXT)))
		return CF_TEXT;
	return 0;
}

#ifndef ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER
/**
 *	@brief Global IME Lɂ
 *
 *	̐ݒ肪ʂ̂ Win NT 4.0 ŎsĂꍇłB
 *	̃VXeł͂̐ݒɂ炸A Global IME 𖳎
 */
inline void EditView::enableActiveInputMethod(bool enable /* = true */) throw() {assertValid(); modeState_.activeInputMethodEnabled = enable;}
#endif /* !ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER */

/**
 *	@brief }EX̋/s̐ݒ
 *
 *	r[́u}EX얳JEgvێĂA̒l0łȂ΂}EX삪eB
 *	̃\bhł̃JEg𑝌邱ƂɂA}EX̋/sݒ肷邱Ƃł
 *
 *	JEg̒l𒼐ڒׂ@<strong></strong>
 *
 *	}EXɂXN[o[̑͗}~łȂ
 *
 *	vZXAEBhE OLE hbOAhhbv}~
 *	@param enable JEgꍇ trueAꍇ false
 */
inline void EditView::enableMouseOperation(bool enable) {
	assertValid();
	if(mouseOperationDisabledCount_ != 0 || !enable)
		mouseOperationDisabledCount_ += !enable ? 1 : -1;
}

/// ZkIuWFNgԂ
inline Abbreviations& EditView::getAbbreviations() throw() {return abbreviations_;}

/// ubN}[NIuWFNgԂ
inline Bookmarker& EditView::getBookmarker() const throw() {assertValid(); return const_cast<EditView*>(this)->sharedData_->layoutManager;}

/// EIuWFNgԂ
inline const DocumentBoundaryDetector& EditView::getBoundaryDetector() const throw() {assertValid(); return *boundaryDetector_;}

/// Nbv{[h̃R[hy[WԂ
/// @see EditView::setClipboardNativeCodePage
inline Encodings::CodePage EditView::getClipboardNativeCodePage() const throw() {return sharedData_->clipboardNativeCodePage;}

/// Nbv{[hOԂ
inline ClipboardRing& EditView::getClipboardRing() throw() {return clipboardRing_;}

/// CN^IuWFNgԂ
inline IncrementalSearcher& EditView::getIncrementalSearcher() throw() {return incrementalSearcher_;}

/// CAEgݒ擾
inline LayoutSetter& EditView::getLayoutSetter() const throw() {assertValid(); return const_cast<EditView*>(this)->sharedData_->layoutManager;}

/// ͊Ԃ
inline Lexer& EditView::getLexer() const throw() {assertValid(); return sharedData_->layoutManager.getLexer();}

#ifndef ASCENSION_NO_MIGEMO
/**
 *	C/Migemo DLL At@C̃fBNgԂ
 *	@param runtime	DLL ̏ꍇ trueB̏ꍇ false
 *	@return			fBNgpX
 */
inline const WCHAR* EditView::getMigemoPath(bool runtime) throw() {return runtime ? migemoRuntimePath_ : migemoDictionaryPath_;}
#endif /* !ASCENSION_NO_MIGEMO */

/// GȐݒԂ
inline const EditView::Options& EditView::getOptions() const throw() {assertValid(); return sharedData_->options;}

/**
 *	XN[ʂ̑΂sA̔䗦Ԃ
 *	@param horizontal	XN[o[ɂĒׂꍇ trueBXN[o[̏ꍇ false
 *	@return				䗦
 */
inline ulong EditView::getScrollRatio(bool horizontal) const throw() {
	assertValidAsWindow(); return horizontal ? scrollInfo_.horizontalRatio : scrollInfo_.verticalRatio;}

/// IԂ
inline Selection& EditView::getSelection() const throw() {assertValid(); return *selection_;}

/// eLXgIuWFNgԂ
inline TextSearcher& EditView::getTextSearcher() throw() {return textSearcher_;}

/**
 *	NCAg̈ɕ\ł񐔂擾
 *	@return \\ȗ
 */
inline length_t EditView::getVisibleCharCount() const throw() {
	const LineLayoutManager&	layoutManager = sharedData_->layoutManager;
	const LayoutSettings&		layout = layoutManager.getSettings();
	RECT						rc;
	getClientRect(rc);
	if(rc.right - rc.left == 0)
		return 0;
	else
		return (rc.right - rc.left - layout.leadMargin
			- layoutManager.getVerticalRulerWidth()) / layoutManager.getAverageCharacterWidth();
}

/**
 *	NCAg̈ɕ\łs擾
 *	@return \\ȍs
 */
inline length_t EditView::getVisibleLineCount() const throw() {
	const LineLayoutManager&	layoutManager = sharedData_->layoutManager;
	const LayoutSettings&		layout = layoutManager.getSettings();
	RECT						rc;
	getClientRect(rc);
	return (rc.bottom - rc.left == 0) ? 0 : (rc.bottom - rc.top - layout.topMargin) / layoutManager.getLineHeight();
}

#ifndef ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER
/// Global IME LɂȂĂ邩Ԃ
inline bool EditView::isActiveInputMethodEnabled() const throw() {assertValid(); return modeState_.activeInputMethodEnabled;}
#endif /* !ASCENSION_NO_ACTIVE_INPUT_METHOD_MANAGER */

/// N[
inline bool EditView::isCloneOf(const EditView& rhs) const throw() {assertValid(); return originalView_ == rhs.originalView_;}

/// `擀
inline bool EditView::isFreezed() const throw() {assertValid(); return freezeInfo_.count != 0;}

/// GUI NCAgҏW\Ԃ
/// @see EditView::checkGUIEditability, EditView::setGUIEditability, EditDoc::isReadOnly
inline bool EditView::isGUIEditable() const throw() {assertValid(); return modeState_.guiEditable;}

/// ㏑[hԂ
/// @see EditView::setOvertypeMode
inline bool EditView::isOvertypeMode() const throw() {assertValid(); return modeState_.overtype;}

/// eLXg̕E獶ł true Ԃ
/// @see EditView::setTextDirection
inline bool EditView::isTextDirectionRightToLeft() const throw() {
	assertValid(); return sharedData_->layoutManager.getSettings().rightToLeftReading;}

/// @c scrollInfo_.position.x ŕ\XN[ʒuXN[{bNX̍[̈ʒuɕϊ
inline long EditView::mapInternalXToScrollBoxX(long x) const {
	if(!getLayoutSetter().getSettings().rightAlign)	// 
		return x;
	else {
//		SCROLLINFO si;
//		FILL_ZERO_SIZE(si, SCROLLINFO, cbSize);
//		si.fMask = SIF_PAGE | SIF_RANGE;
//		getScrollInfo(SB_HORZ, si);
//		return si.nMax - si.nMin - si.nPage - x + 1;
		const LineLayoutManager& layoutManager = sharedData_->layoutManager;
		const ulong maxLineWidth = (getLayoutSetter().getSettings().wrapMode == WPM_NONE) ?
			layoutManager.getLongestLineWidth() / layoutManager.getAverageCharacterWidth() : 0;
		return maxLineWidth / scrollInfo_.horizontalRatio - 0 - getVisibleCharCount() - x + 1;
	}
}

/// XN[{bNX̍[̈ʒu @c scrollInfo_.position.x ŕ\XN[ʒuɕϊ
inline long EditView::mapScrollBoxXToInternalX(long x) const {
	// 2̕ϊ֐͎͓Ƃ̂AĂяöӐ}Ղ悤ɕʁX̊֐ɂĂ
	// (gR[hn߂܂ŋCÂȂ orz...)
	return mapInternalXToScrollBoxX(x);
}

/**
 *	CxgXi̍폜
 *	@param eventListener 폜CxgXi
 */
inline void EditView::removeEventListener(IEditViewEventListener& eventListener) {
	assertValid(); sharedData_->eventListeners.erase(&eventListener);}

/**
 *	@brief GUI NCAg̕ҏWF߂邩ݒ肷
 *
 *	GUI NCAg̕ҏWF߂ĂȂꍇ͂̕WR}heԂł
 *	@see EditView::setGUIEditability, EditDoc::setReadOnly
 */
inline void EditView::setGUIEditability(bool guiEditable) throw() {assertValid(); modeState_.guiEditable = guiEditable;}

#ifndef ASCENSION_NO_MIGEMO
/**
 *	C/Migemo DLL AfBNg̐ݒ
 *	@param pathName	fBNgpXBnull ł悢
 *	@param runtime	DLL ̏ꍇ trueB̏ꍇ false
 */
inline void EditView::setMigemoPath(const WCHAR* pathName, bool runtime) {
	if(pathName == 0)
		std::wcscpy(runtime ? migemoRuntimePath_ : migemoDictionaryPath_, L"");
	else if(std::wcslen(pathName) > MAX_PATH - 1)
		return;
	else
		std::wcscpy(runtime ? migemoRuntimePath_ : migemoDictionaryPath_, pathName);
}
#endif /* !ASCENSION_NO_MIGEMO */

} // namespace Ascension

#endif /* EDIT_VIEW_H_ */

/* [EOF] */