// EditViewMessageHandlers.cpp
// (c) 2004-2006 exeal

/**
 *	@file EditViewMessageHandlers.cpp
 *	EditView NX̓AEBhEbZ[WnhW߂
 *	@see EditView::dispatchEvent
 */

#include "StdAfx.h"
#include "EditView.h"
#include "EditPoint.h"
using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Manah::Windows::GDI;
using namespace std;

#ifdef _DEBUG
extern bool DIAGNOSE_INHERENT_DRAWING;	// EditView.cpp
#endif /* _DEBUG */


// Ɏg}N (̃t@CłgȂBɌĂԂ)

#define ABORT_ISEARCH()						\
	if(incrementalSearcher_.isRunning())	\
		incrementalSearcher_.abort()

#define ABORT_ABBR()														\
	if(modeState_.readyToExpandAbbrev) {									\
		modeState_.readyToExpandAbbrev = false;								\
		FOR_EACH_LISTENERS()												\
			(*it)->onChangedAbbreviationExpansionReadyState(false, L"");	\
	}

#define BEGIN_WORDUNIT_SELECTION()												\
	StandardCommands::SelectionCreationCommand(*this,							\
		StandardCommands::SelectionCreationCommand::CURRENT_WORD).execute();	\
	leftDownMode_ = LDM_SELECTION_WORD;											\
	selection_->beginWordSelection();											\
	if(toBoolean(::GetKeyState(VK_MENU) & 0x8000))	/* `I */				\
		selection_->select(selection_->getAnchorPoint(), selection_->getActivePoint(), true, true)

#define GENERATE_SELECTED_REGION()																			\
	CharPos positions[2];																					\
	if(leftDownMode_ == LDM_SELECTION_CHARACTER) {															\
		positions[0] = selection_->getAnchorPoint();														\
		positions[1] = charFromPos(pt, !sharedData_->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);	\
	} else if(leftDownMode_ == LDM_SELECTION_LINE) {														\
		const HitTestResult	htr = hitTest(pt);																\
		CharPos				pos =																			\
			charFromPos(pt, !sharedData_->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);				\
		if(htr == HTR_INDICATORMARGIN || htr == HTR_LINENUMBERS) {											\
			const length_t	lineCount = getDocument().getLineCount();										\
			const length_t	anchorLine = selection_->getLineSelectionOriginalLine();						\
			positions[0].line_ = (pos.line_ >= anchorLine) ? anchorLine : anchorLine + 1;					\
			if(positions[0].line_ > lineCount - 1)															\
				positions[0].char_ = getDocument().getLineLength(--positions[0].line_);						\
			else																							\
				positions[0].char_ = 0;																		\
			positions[1].line_ = (pos.line_ >= anchorLine) ? pos.line_ + 1 : pos.line_;						\
			if(positions[1].line_ > lineCount - 1)															\
				positions[1].char_ = getDocument().getLineLength(--positions[1].line_);						\
			else																							\
				positions[1].char_ = 0;																		\
		} else {	/* ʏ̑I[hɈڍs */														\
			killTimer(TIMERID_EXPANDLINESELECTION);															\
			setTimer(TIMERID_EXPANDSELECTION, 50, 0);														\
			leftDownMode_ = LDM_SELECTION_CHARACTER;														\
			positions[0] = selection_->getAnchorPoint();													\
			positions[1] = pos;																				\
		}																									\
	} else if(leftDownMode_ == LDM_SELECTION_WORD) {														\
		const CharPos pos = charFromPos(pt,																	\
			!sharedData_->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);								\
		TextRange originalWord;																				\
		selection_->getWordSelectionOriginalWord(originalWord);												\
		if(pos.line_ < originalWord.pos1_.line_																\
				|| (pos.line_ == originalWord.pos1_.line_													\
				&& pos.char_ < originalWord.pos1_.char_)) {													\
			positions[0] = CharPos(originalWord.pos1_.line_, originalWord.pos2_.char_);						\
			positions[1] = boundaryDetector_->searchWordBoundary(pos,										\
				false, static_cast<BoundaryDetector::SearchPart>(											\
					BoundaryDetector::AROUND | BoundaryDetector::ONLY_CURRENT_LINE));						\
		} else if(pos.line_ > originalWord.pos1_.line_														\
				|| (pos.line_ == originalWord.pos1_.line_													\
				&& pos.char_ > originalWord.pos2_.char_)) {													\
			positions[0] = CharPos(originalWord.pos1_.line_, originalWord.pos1_.char_);						\
			positions[1] = boundaryDetector_->searchWordBoundary(pos,										\
				true, static_cast<BoundaryDetector::SearchPart>(											\
					BoundaryDetector::AROUND | BoundaryDetector::ONLY_CURRENT_LINE));						\
		} else {																							\
			positions[0] = CharPos(originalWord.pos1_.line_, originalWord.pos1_.char_);						\
			positions[1] = CharPos(originalWord.pos2_.line_, originalWord.pos2_.char_);						\
		}																									\
	} else																									\
		assert(false)

#define RESTORE_HIDDEN_CURSOR()							\
	if(modeState_.cursorHiddenForCharInput) {			\
		modeState_.cursorHiddenForCharInput = false;	\
		::ShowCursor(true);								\
		releaseCapture();								\
	}


#pragma comment(lib, "version.lib")

namespace {
	// Ŏg
	BOOL CALLBACK enumResLangProc(HMODULE, const WCHAR*, const WCHAR* name, WORD langID, LONG_PTR param) {
		if(name == 0)
			return false;
		else if(langID != MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US))
			*reinterpret_cast<LANGID*>(param) = langID;
		return true;
	}
}

LANGID Ascension::getUserDefaultUILanguage() throw() {
	// Ql ( Global Dev)
	// Writing Win32 Multilingual User Interface Applications (http://www.microsoft.com/globaldev/handson/dev/muiapp.mspx)
	// Ask Dr. International Column #9 (http://www.microsoft.com/globaldev/drintl/columns/009/default.mspx#EPD)
	static LANGID id = 0;
	if(id != 0)
		return id;
	MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US);
	::OSVERSIONINFOW version;
	version.dwOSVersionInfoSize = sizeof(::OSVERSIONINFOW);
	::GetVersionEx(&version);
	assert(version.dwPlatformId == VER_PLATFORM_WIN32_NT);

	// 2000/XP/Server 2003 ȍ~̏ꍇ -> kernel32.dll  GetUserDefaultUILanguage ɓ]
	if(version.dwMajorVersion >= 5) {
		if(HMODULE dll = ::LoadLibraryW(L"kernel32.dll")) {
			if(LANGID(WINAPI *function)(void) = reinterpret_cast<LANGID(WINAPI*)(void)>(::GetProcAddress(dll, "GetUserDefaultUILanguage")))
				id = (*function)();
			::FreeLibrary(dll);
		}
	}

	// NT 3.51-4.0 ̏ꍇ -> ntdll.dll ̃o[W̌
	else if(HMODULE dll = ::LoadLibraryW(L"ntdll.dll")) {
		::EnumResourceLanguagesW(dll, RT_VERSION, MAKEINTRESOURCE(1), enumResLangProc, reinterpret_cast<LONG_PTR>(&id));
		::FreeLibrary(dll);
		if(id == MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US)) {	// special cases
			const UINT cp = ::GetACP();
			if(cp == 874)	// Thai
				id = MAKELANGID(LANG_THAI, SUBLANG_DEFAULT);
			else if(cp == 1255)	// Hebrew
				id = MAKELANGID(LANG_HEBREW, SUBLANG_DEFAULT);
			else if(cp == 1256)	// Arabic
				id = MAKELANGID(LANG_ARABIC, SUBLANG_ARABIC_SAUDI_ARABIA);
		}
	}

	return id;	// Ȃ݂ Win 95/98 ł HKCU\Control Panel\Desktop\ResourceLocale ̒lg
}


/// @see Window::onCaptureChanged
void EditView::onCaptureChanged(HWND) {
	leftDownMode_ = LDM_NONE;
	killTimer(TIMERID_EXPANDSELECTION);
	killTimer(TIMERID_EXPANDLINESELECTION);
	killTimer(TIMERID_AUTOSCROLL);
}

/// ̃\bh̓I[o[ChłȂB EditView::onUniChar ĂяôŁA
///  EditView::onUniChar I[o[ChƂ悢
/// @see Window::onChar
void EditView::onChar(UINT ch, UINT flags) {
	onUniChar(ch, flags);
}

/// @see Window::onCommand
bool EditView::onCommand(WORD id, WORD notifyCode, HWND control) {
	using namespace Ascension::StandardCommands;
	switch(id) {
	case WM_UNDO:	// [ɖ߂]
		UndoCommand(*this, true).execute();
		break;
	case WM_REDO:	// [蒼]
		UndoCommand(*this, false).execute();
		break;
	case WM_CUT:	// [؂]
		ClipboardCommand(*this, ClipboardCommand::CUT, true).execute();
		break;
	case WM_COPY:	// [Rs[]
		ClipboardCommand(*this, ClipboardCommand::COPY, true).execute();
		break;
	case WM_PASTE:	// [\t]
		ClipboardCommand(*this, ClipboardCommand::PASTE, false).execute();
		break;
	case WM_CLEAR:	// [폜]
		DeletionCommand(*this, DeletionCommand::NEXT_CHARACTER).execute();
		break;
	case WM_SELECTALL:	// [ׂđI]
		SelectionCreationCommand(*this, SelectionCreationCommand::ALL).execute();
		break;
	case ID_RTLREADING:	// [E獶ɓǂ]
		setTextDirection(!isTextDirectionRightToLeft());
		break;
	case ID_SHOWDIRECTIONALFORMATTERS:	// [Unicode 䕶̕\]
		sharedData_->options.appearance.flip(SHOW_UNICODE_CONTROLS);
		invalidateRect(0, false);
		break;
	case ID_INSERT_LRM:		CharacterInputCommand(*this, 0x200E).execute();	break;
	case ID_INSERT_RLM:		CharacterInputCommand(*this, 0x200F).execute();	break;
	case ID_INSERT_ZWJ:		CharacterInputCommand(*this, 0x200D).execute();	break;
	case ID_INSERT_ZWNJ:	CharacterInputCommand(*this, 0x200C).execute();	break;
	case ID_INSERT_LRE:		CharacterInputCommand(*this, 0x202A).execute();	break;
	case ID_INSERT_RLE:		CharacterInputCommand(*this, 0x202B).execute();	break;
	case ID_INSERT_LRO:		CharacterInputCommand(*this, 0x202D).execute();	break;
	case ID_INSERT_RLO:		CharacterInputCommand(*this, 0x202E).execute();	break;
	case ID_INSERT_PDF:		CharacterInputCommand(*this, 0x202C).execute();	break;
	case ID_INSERT_WJ:		CharacterInputCommand(*this, 0x2060).execute();	break;
	case ID_INSERT_NADS:	CharacterInputCommand(*this, 0x206E).execute();	break;
	case ID_INSERT_NODS:	CharacterInputCommand(*this, 0x206F).execute();	break;
	case ID_INSERT_ASS:		CharacterInputCommand(*this, 0x206B).execute();	break;
	case ID_INSERT_ISS:		CharacterInputCommand(*this, 0x206A).execute();	break;
	case ID_INSERT_AAFS:	CharacterInputCommand(*this, 0x206D).execute();	break;
	case ID_INSERT_IAFS:	CharacterInputCommand(*this, 0x206C).execute();	break;
	case ID_INSERT_RS:		CharacterInputCommand(*this, 0x001E).execute();	break;
	case ID_INSERT_US:		CharacterInputCommand(*this, 0x001F).execute();	break;
	case ID_INSERT_IAA:		CharacterInputCommand(*this, 0xFFF9).execute();	break;
	case ID_INSERT_IAT:		CharacterInputCommand(*this, 0xFFFA).execute();	break;
	case ID_INSERT_IAS:		CharacterInputCommand(*this, 0xFFFB).execute();	break;
	case ID_INSERT_U0020:	CharacterInputCommand(*this, 0x0020).execute();	break;
	case ID_INSERT_NBSP:	CharacterInputCommand(*this, 0x00A0).execute();	break;
	case ID_INSERT_U1680:	CharacterInputCommand(*this, 0x1680).execute();	break;
	case ID_INSERT_MVS:		CharacterInputCommand(*this, 0x180E).execute();	break;
	case ID_INSERT_U2000:	CharacterInputCommand(*this, 0x2000).execute();	break;
	case ID_INSERT_U2001:	CharacterInputCommand(*this, 0x2001).execute();	break;
	case ID_INSERT_U2002:	CharacterInputCommand(*this, 0x2002).execute();	break;
	case ID_INSERT_U2003:	CharacterInputCommand(*this, 0x2003).execute();	break;
	case ID_INSERT_U2004:	CharacterInputCommand(*this, 0x2004).execute();	break;
	case ID_INSERT_U2005:	CharacterInputCommand(*this, 0x2005).execute();	break;
	case ID_INSERT_U2006:	CharacterInputCommand(*this, 0x2006).execute();	break;
	case ID_INSERT_U2007:	CharacterInputCommand(*this, 0x2007).execute();	break;
	case ID_INSERT_U2008:	CharacterInputCommand(*this, 0x2008).execute();	break;
	case ID_INSERT_U2009:	CharacterInputCommand(*this, 0x2009).execute();	break;
	case ID_INSERT_U200A:	CharacterInputCommand(*this, 0x200A).execute();	break;
	case ID_INSERT_ZWSP:	CharacterInputCommand(*this, 0x200B).execute();	break;
	case ID_INSERT_NNBSP:	CharacterInputCommand(*this, 0x202F).execute();	break;
	case ID_INSERT_MMSP:	CharacterInputCommand(*this, 0x205F).execute();	break;
	case ID_INSERT_U3000:	CharacterInputCommand(*this, 0x3000).execute();	break;
	case ID_INSERT_NEL:		CharacterInputCommand(*this, 0x0085).execute();	break;
	case ID_INSERT_LS:		CharacterInputCommand(*this, 0x2028).execute();	break;
	case ID_INSERT_PS:		CharacterInputCommand(*this, 0x2029).execute();	break;
	case ID_TOGGLEIMESTATUS:	// [IME J] / [IME ]
		InputStatusToggleCommand(*this, InputStatusToggleCommand::IME_STATUS).execute();
		break;
	case ID_TOGGLESOFTKEYBOARD:	// [\tgL[{[hJ] / [\tgL[{[h]
		InputStatusToggleCommand(*this, InputStatusToggleCommand::SOFT_KEYBOARD).execute();
		break;
	case ID_RECONVERT:	// [ĕϊ]
		ReconversionCommand(*this).execute();
		break;
	default:
		::SendMessageW(getParent(), WM_COMMAND, MAKEWPARAM(id, notifyCode), reinterpret_cast<LPARAM>(control));
	}

	return BaseControl::onCommand(id, notifyCode, control);
}

/// @see Window::onContextMenu
bool EditView::onContextMenu(HWND window, const POINT& pt) {
	using Manah::Windows::Controls::Menu;

	if(mouseOperationDisabledCount_ != 0)	// }EXƂ͌Ȃ...
		return true;
	closeCompletionWindow();
	ABORT_ISEARCH();

	// L[{[hɂꍇ
	if(pt.x == 65535 && pt.y == 65535) {
		const_cast<POINT&>(pt).x = const_cast<POINT&>(pt).y = 1;	// K...
		clientToScreen(const_cast<POINT&>(pt));
	}

	// XN[o[łΏȂ
	RECT rect;
	getClientRect(rect);
	clientToScreen(rect);
	if(!toBoolean(::PtInRect(&rect, pt)))
		return false;

	const EditDoc&	document = getDocument();
	const bool		hasSelection = !selection_->isEmpty();
	const bool		readOnly = document.isReadOnly();
	Menu::ItemInfo	item;
	Menu&			menu = sharedData_->contextMenu;

	// j[ڂ̏C
	menu.enableMenuItem<Menu::BY_COMMAND>(WM_UNDO, !readOnly && document.getUndoHistoryLength(false) != 0);
	menu.enableMenuItem<Menu::BY_COMMAND>(WM_REDO, !readOnly && document.getUndoHistoryLength(true) != 0);
	menu.enableMenuItem<Menu::BY_COMMAND>(WM_CUT, !readOnly && hasSelection);
	menu.enableMenuItem<Menu::BY_COMMAND>(WM_COPY, hasSelection);
	menu.enableMenuItem<Menu::BY_COMMAND>(WM_PASTE, !readOnly && canPaste());
	menu.enableMenuItem<Menu::BY_COMMAND>(WM_CLEAR, !readOnly && hasSelection);
	menu.enableMenuItem<Menu::BY_COMMAND>(WM_SELECTALL, document.getLineCount() > 1 || document.getLineLength(0) > 0);
	menu.checkMenuItem<Menu::BY_COMMAND>(ID_RTLREADING, getLayoutSetter().getSettings().rightToLeftReading);
	menu.checkMenuItem<Menu::BY_COMMAND>(ID_SHOWDIRECTIONALFORMATTERS, sharedData_->options.appearance[SHOW_UNICODE_CONTROLS]);

	// IME ֘A
	HKL keyboardLayout = ::GetKeyboardLayout(::GetCurrentThreadId());
	if(//toBoolean(::ImmIsIME(keyboardLayout)) &&
			::ImmGetProperty(keyboardLayout, IGP_SENTENCE) != IME_SMODE_NONE) {
		const bool	isJapanese = PRIMARYLANGID(getUserDefaultUILanguage()) == LANG_JAPANESE;
		HIMC	imc = ::ImmGetContext(getHandle());
		WCHAR*	openIme = isJapanese ? L"IME J(&O)" : L"&Open IME";
		WCHAR*	closeIme = isJapanese ? L"IME (&L)" : L"C&lose IME";
		WCHAR*	openSftKbd = isJapanese ? L"\tgL[{[hJ(&E)" : L"Op&en soft keyboard";
		WCHAR*	closeSftKbd = isJapanese ? L"\tgL[{[h(&F)" : L"Close so&ft keyboard";
		WCHAR*	reconvert = isJapanese ? L"ĕϊ(&R)" : L"&Reconvert";

		menu << Menu::SeparatorItem()
			<< Menu::StringItem(ID_TOGGLEIMESTATUS, toBoolean(::ImmGetOpenStatus(imc)) ? closeIme : openIme);

		if(toBoolean(::ImmGetProperty(keyboardLayout, IGP_CONVERSION) & IME_CMODE_SOFTKBD)) {
			DWORD convMode;
			::ImmGetConversionStatus(imc, &convMode, 0);
			menu << Menu::StringItem(ID_TOGGLESOFTKEYBOARD, toBoolean(convMode & IME_CMODE_SOFTKBD) ? closeSftKbd : openSftKbd);
		}

		if(toBoolean(::ImmGetProperty(keyboardLayout, IGP_SETCOMPSTR) & SCS_CAP_COMPSTR))
			menu << Menu::StringItem(ID_RECONVERT, reconvert, (!readOnly && hasSelection) ? MFS_ENABLED : MFS_GRAYED);

		::ImmReleaseContext(getHandle(), imc);
	}
	menu.trackPopupMenu(TPM_LEFTALIGN, pt.x, pt.y, *this);

	// Ƃ
	int c = menu.getItemCount();
	while(c > 13)
		menu.deleteMenuItem<Menu::BY_POSITION>(c--);

	return true;
}

/// @see Window::OnHScroll
void EditView::onHScroll(UINT sbCode, UINT pos, HWND) {
	//  pos ̓XN[o[̍[̈ʒuB
	// ݊AԈĂĈōύX邩 (<- RTL ̘b)
	const int orgPos = mapInternalXToScrollBoxX(scrollInfo_.position.x);
	int newPos = orgPos;
	AutoZeroCB<SCROLLINFO> scroll;
	const length_t visibleCharCount = getVisibleCharCount();
	const LineLayoutManager& layoutManager = sharedData_->layoutManager;
	const LayoutSettings& layout = layoutManager.getSettings();

	scroll.fMask = SIF_PAGE | SIF_RANGE;
	getScrollInfo(SB_HORZ, scroll);

//	closeCompletionWindow();
	if(visibleCharCount > static_cast<ulong>(scroll.nMax - scroll.nMin) * scrollInfo_.horizontalRatio) {
		scrollInfo_.position.x = 0;
		return;
	}

	switch(sbCode) {
	case SB_LINELEFT:	// 1񕪍
		--newPos; break;
	case SB_LINERIGHT:	// 1񕪉E
		++newPos; break;
	case SB_PAGELEFT:	// 1y[W
		newPos -= static_cast<int>(visibleCharCount); break;
	case SB_PAGERIGHT:	// 1y[WE
		newPos += static_cast<int>(visibleCharCount); break;
	case SB_LEFT:		// [
		newPos = scroll.nMin; break;
	case SB_RIGHT:		// E[
		newPos = scroll.nMax; break;
	case SB_THUMBTRACK:	// hbO or zC[
		newPos = getScrollTrackPos(SB_HORZ); break;	// 32rbglg
	case SB_SETPOS:		// IȃXN[	
		newPos = pos; break;
	default:			return;
	}

	// 
	newPos = max<int>(newPos, scroll.nMin);
	newPos = min<int>(newPos, scroll.nMax - scroll.nPage + 1);

	if(isFreezed()) {	// 𓀎ɂ炽߂ăXN[
		freezeInfo_.scrollPosition.x = mapScrollBoxXToInternalX(newPos);
		return;
	}

	if(newPos == orgPos)	// XN[Ȃ
		return;

	// ĕ`Ȃ
	if(Private::dif<long>(newPos, orgPos) < visibleCharCount) {	// XN[ʂ1y[Wȉ
		RECT scrollRect;	// XN[Ώ
		const int dx = (orgPos - newPos) * scrollInfo_.horizontalRatio * layoutManager.getAverageCharacterWidth();

		getClientRect(scrollRect);
		if(!layout.rightAlign)
			scrollRect.left += layoutManager.getVerticalRulerWidth() + layout.leadMargin;
		else
			scrollRect.right -= layoutManager.getVerticalRulerWidth() + layout.leadMargin;

		RECT updateRect = scrollRect;	// 蓮ŌvZXV`

		if(dx > 0) {
			scrollRect.left += dx;
			updateRect.right = updateRect.left + dx;
		} else {
			scrollRect.right -= dx;
			updateRect.left = updateRect.right + dx;
		}
		scrollWindowEx(dx, 0, &scrollRect, &scrollRect, 0, 0, SW_INVALIDATE);
		invalidateRect(&updateRect, false);
	} else
		invalidateRect(0, false);

	hideToolTip();
	setScrollPos(SB_HORZ, newPos);
	scrollInfo_.position.x = mapScrollBoxXToInternalX(newPos);
	updateCaretPosition();
	if(imeCompositionActivated_)
		updateIMECompositionWindowPosition();
//	updateWindow();

	closeCompletionWindow();
}

/// @see WM_IME_COMPOSITION
bool EditView::onIMEComposition(WPARAM wParam, LPARAM lParam) {
	if(lParam == 0 || toBoolean(lParam & GCS_RESULTSTR)) {	// m
		if(HIMC	imc = ::ImmGetContext(getHandle())) {
			const length_t len = ::ImmGetCompositionStringW(imc, GCS_RESULTSTR, 0, 0) / sizeof(WCHAR);

			if(len != 0) {	// LZȂꍇ
				char_t* const text = new char_t[len + 1];
				::ImmGetCompositionStringW(imc, GCS_RESULTSTR, text, static_cast<DWORD>(len * sizeof(WCHAR)));
				text[len] = 0;
				StandardCommands::TextInputCommand(*this, text).execute();
				delete[] text;
			}

			updateIMECompositionWindowPosition();
			::ImmReleaseContext(getHandle(), imc);
		}
		return true;
	}
	return false;
}

/// @see WM_IME_ENDCOMPOSITION
void EditView::onIMEEndComposition() {
	showCaret();
	imeCompositionActivated_ = false;
}

/// @see WM_IME_REQUEST
LRESULT EditView::onIMERequest(WPARAM command, LPARAM lParam) {
	// ĕϊsƂɂ܂̃R}h2ł
	if(command == IMR_RECONVERTSTRING) {
		if(getDocument().isReadOnly())
			beep();
		else if(selection_->isEmpty()) {	// Iꍇ IME ɍĕῗ͈߂Ă炤
			const VisualPoint& caret = selection_->getActivePoint();
			if(RECONVERTSTRING* const prcs = reinterpret_cast<RECONVERTSTRING*>(lParam)) {
				const string_t&	line = getDocument().getLine(caret.getLineNumber());
				prcs->dwStrLen = static_cast<DWORD>(line.length());
				prcs->dwStrOffset = sizeof(RECONVERTSTRING);
				prcs->dwTargetStrOffset = prcs->dwCompStrOffset = static_cast<DWORD>(sizeof(char_t) * caret.getCharNumber());
				prcs->dwTargetStrLen = prcs->dwCompStrLen = 0;
				line.copy(reinterpret_cast<char_t*>(reinterpret_cast<char*>(prcs) + prcs->dwStrOffset), prcs->dwStrLen);
			}
			return sizeof(RECONVERTSTRING) + sizeof(char_t) * getDocument().getLineLength(caret.getLineNumber());
		} else if(!selection_->isRectangle()) {
			const string_t selection = selection_->getText(LBRP_PHYSICAL_DATA);
			if(RECONVERTSTRING* const prcs = reinterpret_cast<RECONVERTSTRING*>(lParam)) {
				prcs->dwStrLen = prcs->dwTargetStrLen = prcs->dwCompStrLen = static_cast<DWORD>(selection.length());
				prcs->dwStrOffset = sizeof(RECONVERTSTRING);
				prcs->dwTargetStrOffset = prcs->dwCompStrOffset = 0;
				selection.copy(reinterpret_cast<char_t*>(reinterpret_cast<char*>(prcs) + prcs->dwStrOffset), prcs->dwStrLen);
			}
			return sizeof(RECONVERTSTRING) + sizeof(char_t) * selection.length();
		}
		return 0L;
	}

	// ĕϊ̒OBRECONVERTSTRING ɍĕϊ͈̔͂ݒ肳Ă
	else if(command == IMR_CONFIRMRECONVERTSTRING) {
		RECONVERTSTRING* const prcs = reinterpret_cast<RECONVERTSTRING*>(lParam);
		const VisualPoint&	caret = selection_->getActivePoint();
		const CharPos		start = getDocument().getStartPoint();
		const CharPos		end = getDocument().getEndPoint();
		if(!selection_->isEmpty()) {
			// ɑIꍇ͑I͈͂ĕϊB
			// I͕sɂȂĂ\
			if(prcs->dwCompStrLen < prcs->dwStrLen)	// ĕῗ͈߂Ă (߂)
				prcs->dwCompStrLen = prcs->dwStrLen;	//  IME xočĕϊ͍sȂB
														// I߂̂݊̓삾...
		} else {
			// Iꍇ IME Ă͈͂ĕϊ (I쐬Ă)B
			// ̏ꍇ͕s̍ĕϊ͔Ȃ (prcs->dwStrXxx ͌ݍsS)
			if(getDocument().isNarrowed() && caret.getLineNumber() == start.line_) {	// i[CO
				if(prcs->dwCompStrOffset / sizeof(char_t) < start.char_) {
					prcs->dwCompStrLen += static_cast<DWORD>(sizeof(char_t) * start.char_ - prcs->dwCompStrOffset);
					prcs->dwTargetStrLen = prcs->dwCompStrOffset;
					prcs->dwCompStrOffset = prcs->dwTargetStrOffset = static_cast<DWORD>(sizeof(char_t) * start.char_);
				} else if(prcs->dwCompStrOffset / sizeof(char_t) > end.char_) {
					prcs->dwCompStrOffset -= prcs->dwCompStrOffset - sizeof(char_t) * end.char_;
					prcs->dwTargetStrOffset = prcs->dwCompStrOffset;
					prcs->dwCompStrLen = prcs->dwTargetStrLen = static_cast<DWORD>(sizeof(char_t) * end.char_ - prcs->dwCompStrOffset);
				}
			}
			selection_->select(
				CharPos(caret.getLineNumber(), prcs->dwCompStrOffset / sizeof(char_t)),
				CharPos(caret.getLineNumber(), prcs->dwCompStrOffset / sizeof(char_t) + prcs->dwCompStrLen),
				false, true);
		}
		return true;
	}

	// ϊEBhËʒu߂KvȂƂɎs
	else if(command == IMR_QUERYCHARPOSITION)
		return false;	// updateIMECompositionWindowPosition ŉƂ...

	return 0L;
}

/// @see WM_IME_STARTCOMPOSITION
void EditView::onIMEStartComposition() {
	HIMC imc = ::ImmGetContext(getHandle());
	LOGFONTW font;

	if(imc != 0) {
		::GetObject(sharedData_->layoutManager.getRegularFont(), sizeof(LOGFONTW), &font);
		::ImmSetCompositionFontW(imc, &font);	// IME ̐ݒɂĂ͔f邾낤
		hideCaret();
		::ImmReleaseContext(getHandle(), imc);
	}
	imeCompositionActivated_ = true;
	updateIMECompositionWindowPosition();
	completionWindow_->showWindow(SW_HIDE);
}

/**
 *	@brief WM_KEYDOWN ̏
 *
 *	̎ Ascension r[̊̃L[蓖Ăɏ]ăR}hs
 *	(EditorCommand::execute Ăяo)B̃L[蓖Ă̓eLXgGfB^ƂēT^IȂ̂A
 *	AvP[VŃJX^}CYꍇ͋ŃI[o[ChƂ悢
 *	(ANZ[^gꍇ͂ɔłȂ̂ł̂܂܂ł悢Ȃ)
 *
 *	<h3>I[o[Chꍇ</h3>
 *
 *	̎ EditorCommand::execute ĂяoăR}hsȊOȂB
 *	L[gݍ킹R}hɊ蓖ĂĂȂꍇ͉Ȃ
 *
 *	<h3>̃L[蓖</h3>
 *
 *	̃L[蓖ĂɂĂ Ascension ̃}jA
 */
bool EditView::onKeyDown(UINT ch, UINT flags) {
	using namespace Ascension::StandardCommands;
	const bool ctrl = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);
	const bool shift = toBoolean(::GetKeyState(VK_SHIFT) & 0x8000);
	const bool repetition = toBoolean(flags & (1 << 30));

	switch(ch) {
	case VK_LEFT:	// []
		if(ctrl)	CaretMovementCommand(*this, CaretMovementCommand::LEFT_WORD, shift).execute();
		else		CaretMovementCommand(*this, CaretMovementCommand::LEFT_CHARACTER, shift, repetition ? 2 : 1).execute();
		return true;
	case VK_RIGHT:	// []
		if(ctrl)	CaretMovementCommand(*this, CaretMovementCommand::RIGHT_WORD, shift).execute();
		else		CaretMovementCommand(*this, CaretMovementCommand::RIGHT_CHARACTER, shift, repetition ? 2 : 1).execute();
		return true;
	case VK_UP:		// []
		if(ctrl && !shift)
			onVScroll(SB_LINEUP, 0, 0);
		else
			CaretMovementCommand(*this, CaretMovementCommand::PREVIOUS_LINE, shift, repetition ? 2 : 1).execute();
		return true;
	case VK_DOWN:	// []
		if(ctrl && !shift)
			onVScroll(SB_LINEDOWN, 0, 0);
		else
			CaretMovementCommand(*this, CaretMovementCommand::NEXT_LINE, shift, repetition ? 2 : 1).execute();
		return true;
	case VK_HOME:	// [Home]
		if(ctrl)
			CaretMovementCommand(*this, CaretMovementCommand::START_OF_DOCUMENT, shift).execute();
		else if(selection_->getStartPoint().isStartOfLine())
			CaretMovementCommand(*this, CaretMovementCommand::FIRST_CHAR_OF_LINE, shift).execute();
		else
			CaretMovementCommand(*this, CaretMovementCommand::START_OF_LINE, shift).execute();
		return true;
	case VK_END:	// [End]
		if(ctrl)	CaretMovementCommand(*this, CaretMovementCommand::END_OF_DOCUMENT, shift).execute();
		else		CaretMovementCommand(*this, CaretMovementCommand::END_OF_LINE, shift).execute();
		return true;
	case VK_NEXT:	// [PageDown]
		if(ctrl)	onVScroll(SB_PAGEDOWN, 0, 0);
		else		CaretMovementCommand(*this, CaretMovementCommand::NEXT_PAGE, shift).execute();
		return true;
	case VK_PRIOR:	// [PageUp]
		if(ctrl)	onVScroll(SB_PAGEUP, 0, 0);
		else		CaretMovementCommand(*this, CaretMovementCommand::PREVIOUS_PAGE, shift).execute();
		return true;
	case VK_RETURN:	// [Enter]
		LineBreakCommand(*this, ctrl);
		return true;
	case VK_DELETE:	// [Delete]
		if(ctrl && !shift)	DeletionCommand(*this, DeletionCommand::NEXT_WORD).execute();
		else if(shift)		ClipboardCommand(*this, ClipboardCommand::CUT, true).execute();
		else				DeletionCommand(*this, DeletionCommand::NEXT_CHARACTER).execute();
		return true;
	case VK_BACK:	// [BackSpace]
		DeletionCommand(*this, ctrl ? DeletionCommand::PREVIOUS_WORD : DeletionCommand::PREVIOUS_CHARACTER).execute();
		return true;
	case VK_INSERT:	// [Insert]
		if(ctrl && !shift)	ClipboardCommand(*this, ClipboardCommand::COPY, true).execute();
		else if(shift)		ClipboardCommand(*this, ClipboardCommand::PASTE, false).execute();
		else				InputStatusToggleCommand(*this, InputStatusToggleCommand::OVERTYPE_MODE).execute();
		return true;
	case VK_ESCAPE:	// [Esc]
		CancelCommand(*this).execute();
		return true;
	case VK_SHIFT:	// [Shift]
		if(ctrl && toBoolean(::GetAsyncKeyState(VK_LSHIFT) & 0x8000) && isTextDirectionRightToLeft()) {
			setTextDirection(false);
			return true;
		} else if(ctrl && toBoolean(::GetAsyncKeyState(VK_RSHIFT) & 0x8000) && !isTextDirectionRightToLeft()) {
			setTextDirection(true);
			return true;
		}
		return false;
	}
	return false;
}

/// @see Window::onKillFocus
void EditView::onKillFocus(HWND newWindow) {
	RESTORE_HIDDEN_CURSOR();
	endAutoScroll();
	if(hilightedBracketPositions_[0].line_ != -1
			&& hilightedBracketPositions_[0].char_ != -1) {	// Ίʂ̒ʒmI
		FOR_EACH_LISTENERS()
			(*it)->onMatchBracketFoundOutOfView(CharPos::INVALID_POSITION);
	}
	if(completionWindow_->isWindow() && newWindow != completionWindow_->getSafeHwnd())
		closeCompletionWindow();
	ABORT_ISEARCH();
	ABORT_ABBR();
	if(imeCompositionActivated_) {	// IME œ͒ł΂߂
		HIMC imc = ::ImmGetContext(getHandle());
		::ImmNotifyIME(imc, NI_COMPOSITIONSTR, CPS_CANCEL, 0);
		::ImmReleaseContext(getHandle(), imc);
	}
	if(newWindow != getHandle()) {
		hideCaret();
		::DestroyCaret();
	}
	invalidateLines(selection_->getStartPoint().getLineNumber(), selection_->getEndPoint().getLineNumber());
	updateWindow();
}

/// _uNbNւ̃R}h蓖Ă̂߂ɂ̃\bhI[o[Chׂł͂Ȃ
/// @see Window::onLButtonBblClk
void EditView::onLButtonDblClk(UINT, const POINT& pt) {
	if(mouseOperationDisabledCount_ == 0) {
		ABORT_ISEARCH();
		const HitTestResult htr = hitTest(pt);
		if(htr == HTR_LEADMARGIN || htr == HTR_TOPMARGIN || htr == HTR_TEXT) {
			BEGIN_WORDUNIT_SELECTION();
			setCapture();
			setTimer(TIMERID_EXPANDSELECTION, 50, 0);
		}
	}
}

/// }EX{^ւ̃R}h蓖Ă̂߂ɂ̃\bhI[o[Chׂł͂Ȃ
/// @see Window::onLButtonDown
void EditView::onLButtonDown(UINT flags, const POINT& pt) {
#define SELECTION_EXPANSION_INTERVAL	100

	if(mouseOperationDisabledCount_ != 0)
		return;
	RESTORE_HIDDEN_CURSOR();
	if(endAutoScroll())
		return;

	bool boxDragging = false;
	char_t* uri = 0;
	const HitTestResult htr = hitTest(pt);

	closeCompletionWindow();
	if(incrementalSearcher_.isRunning())
		incrementalSearcher_.end();

	if(htr == HTR_INDICATORMARGIN || htr == HTR_LINENUMBERS) {	// 1sI
		if(toBoolean(flags & MK_CONTROL))	// SsI
			StandardCommands::SelectionCreationCommand(*this, StandardCommands::SelectionCreationCommand::ALL).execute();
		else {
			const CharPos pos = charFromPos(pt, !sharedData_->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
			leftDownMode_ = LDM_SELECTION_LINE;
			selection_->select(CharPos(pos.line_, 0),
				(pos.line_ != getDocument().getLineCount() - 1) ?
					CharPos(pos.line_ + 1, 0) : CharPos(pos.line_, getDocument().getLineLength(pos.line_)),
				false, true);
			selection_->beginLineSelection();
		}
		setCapture();
		setTimer(TIMERID_EXPANDLINESELECTION, SELECTION_EXPANSION_INTERVAL, 0);
	} else if(sharedData_->options.behavior[OLE_DRAG_AND_DROP]
			&& !selection_->isEmpty()
			&& selection_->isPointOver(pt)) {	// OLE hbOJn?
		::GetCursorPos(&modeState_.lastMouseDownPoint);
		screenToClient(modeState_.lastMouseDownPoint);
		if(selection_->isRectangle())
			boxDragging = true;
	} else if(toBoolean(flags & MK_CONTROL)
			&& !sharedData_->eventListeners.empty()
			&& isOverInvokableLink(pt, uri)) {	// N̋N
		FOR_EACH_LISTENERS()
			(*it)->onInvokeURILink(uri);
		delete[] uri;
	} else if(!toBoolean(flags & MK_SHIFT)
			&& toBoolean(::GetKeyState(VK_MENU) & 0x8000)) {	// `IJn
		leftDownMode_ = LDM_SELECTION_CHARACTER;
		const CharPos pos = charFromPos(pt, !sharedData_->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
		selection_->select(pos, pos, true, true);
		setCapture();
		setTimer(TIMERID_EXPANDSELECTION, SELECTION_EXPANSION_INTERVAL, 0);
	} else {	// ̑B`IJnALbgړ
		leftDownMode_ = LDM_SELECTION_CHARACTER;
		const CharPos pos = charFromPos(pt, !sharedData_->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
		if(toBoolean(flags & MK_CONTROL)) {	// Ctrl -> ݂̒PI
			getSelection().moveTo(pos, true);
			BEGIN_WORDUNIT_SELECTION();
		} else if(toBoolean(flags & MK_SHIFT)) {	// Shift -> J[\ʒu܂őI
			if(toBoolean(::GetKeyState(VK_MENU) & 0x8000)) {	// Shift+Alt -> J[\ʒu܂ŋ`I
				leftDownMode_ = LDM_SELECTION_CHARACTER;
				getSelection().select(selection_->getAnchorPoint(), pos, true, true);
			} else
				getSelection().select(selection_->getAnchorPoint(), pos, false, true);
		} else
			getSelection().moveTo(pos, true);
		setCapture();
		setTimer(TIMERID_EXPANDSELECTION, SELECTION_EXPANSION_INTERVAL, 0);
	}

	if(!selection_->isRectangle() && !boxDragging)
		invalidateLine(selection_->getActivePoint().getLineNumber());
	setFocus();

#undef SELECTION_EXPANSION_INTERVAL
}

/// @see Window::onLButtonUp
void EditView::onLButtonUp(UINT, const POINT& pt) {
	if(mouseOperationDisabledCount_ != 0)
		return;
	const LeftDownMode original = leftDownMode_;

	if(modeState_.lastMouseDownPoint.x != -1) {	// OLE hbOJn -> LZ
		modeState_.lastMouseDownPoint.x = modeState_.lastMouseDownPoint.y = -1;
		getSelection().moveTo(
			charFromPos(pt, !sharedData_->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]), true);
		::SetCursor(::LoadCursor(0, IDC_IBEAM));	// [
	}
	releaseCapture();

	// I͈͊g咆ɉʊOŃ{^𗣂ƃLbgʒu܂ŃXN[ȂƂ̂
	if(original != LDM_NONE)
		selection_->getActivePoint().reveal(*this);
}

/// @see Window::onMouseMove
void EditView::onMouseMove(UINT, const POINT& pt) {
	if(mouseOperationDisabledCount_ != 0)
		return;
	RESTORE_HIDDEN_CURSOR();

	CharPos pos;	// J[\ʒu狁܂sƗ

	if(modeState_.lastMouseDownPoint.x != -1) {	// OLE hbOJn?
		POINT& lastPoint = modeState_.lastMouseDownPoint;
		if(!sharedData_->options.behavior[OLE_DRAG_AND_DROP] || selection_->isEmpty())
			lastPoint.x = lastPoint.y = -1;
		else {
			const int cxDragBox = ::GetSystemMetrics(SM_CXDRAG);
			const int cyDragBox = ::GetSystemMetrics(SM_CYDRAG);
			if((pt.x > lastPoint.x + cxDragBox / 2) || (pt.x < lastPoint.x - cxDragBox / 2)
					|| (pt.y > lastPoint.y + cyDragBox / 2) || (pt.y < lastPoint.y - cyDragBox / 2)) {
				const bool box = selection_->isRectangle();
				const string_t selection = selection_->getText(LBRP_PHYSICAL_DATA);

				if(box) {
					set<CLIPFORMAT>	clipFormats;
					clipFormats.insert(CF_UNICODETEXT);
					clipFormats.insert(::RegisterClipboardFormatW(ASCENSION_RECTANGLE_TEXT_CLIP_FORMAT));
					dragging_->setAvailableFormatSet(clipFormats);
				}
				dragging_->setTextData(selection.c_str());
				leftDownMode_ = box ? LDM_DRAGANDDROPBOXSELF : LDM_DRAGANDDROPSELF;
				setTimer(TIMERID_DRAGSCROLL, box ? 100 : 50, 0);
				dragging_->doDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);
				killTimer(TIMERID_DRAGSCROLL);
				leftDownMode_ = LDM_NONE;	// onLButtonUp ͌Ă΂Ȃ
				lastPoint.x = lastPoint.y = -1;
				if(isWindowVisible())
					setFocus();
			}
		}
		return;
	}

	if(toBoolean(pt.x & 0x8000))	const_cast<POINT&>(pt).x = 0;
	if(toBoolean(pt.y & 0x8000))	const_cast<POINT&>(pt).y = 0;

	const LineLayoutManager&	layoutManager = sharedData_->layoutManager;
	const LayoutSettings&		layout = layoutManager.getSettings();
	if(leftDownMode_ != LDM_NONE) {	// XN[
/*		const long marginWidth = layoutManager.getVerticalRulerWidth() + layout.leadMargin;
		if(pt.y < static_cast<long>(layout.topMargin + layoutManager.getLineHeight() / 2))
			onVScroll(SB_LINEUP, 0, 0);
		else if(pt.y > static_cast<long>(layout.topMargin + layoutManager.getLineHeight() * getVisibleLineCount()))
			onVScroll(SB_LINEDOWN, 0, 0);
		if(!layout.rightAlign) {
			if(pt.x < marginWidth)
				onHScroll(SB_SETPOS, scrollInfo_.position.x - layout.tabWidth, 0);
//			else if(pt.x >)
		} else {
		}
*/	}
	if(leftDownMode_ == LDM_SELECTION_CHARACTER
			|| leftDownMode_ == LDM_SELECTION_LINE
			|| leftDownMode_ == LDM_SELECTION_WORD) {	// I̊g/k
		GENERATE_SELECTED_REGION();
		getSelection().select(positions[0], positions[1], getSelection().isRectangle(), true);
	} else if(leftDownMode_ == LDM_DRAGANDDROP) {	// IehbO
	}
}

/// @see Window::onMouseWheel
bool EditView::onMouseWheel(UINT, short zDelta, const POINT& pt) {
	UINT scrollLineCount;	// XN[s

	if(mouseOperationDisabledCount_ != 0)
		return true;
	RESTORE_HIDDEN_CURSOR();
	
	if(endAutoScroll())
		return true;

	// VXeŐݒ肳Ăʂg
	if(!toBoolean(::SystemParametersInfo(SPI_GETWHEELSCROLLLINES, 0, &scrollLineCount, 0)))
		scrollLineCount = 3;
	zDelta *= scrollLineCount;
	onVScroll(SB_SETPOS, scrollInfo_.position.y - zDelta / WHEEL_DELTA, 0);

	return true;
}

/// @see Window::onNotify
bool EditView::onNotify(int, LPNMHDR nmhdr) {
	// c[`bṽeLXg
	if(nmhdr->hwndFrom == toolTip_ && nmhdr->code == TTN_GETDISPINFO) {
		::SendMessageW(toolTip_, TTM_SETMAXTIPWIDTH, 0, 1000);	// sLɂ
		reinterpret_cast<LPNMTTDISPINFOW>(nmhdr)->lpszText = tipText_;
		return true;
	}
	return false;
}

/// @see Window::onPaint
void EditView::onPaint(PaintDC& dc) {
	if(isFreezed())	// ͖
		return;
	else if(toBoolean(::IsRectEmpty(&dc.getPaintStruct().rcPaint)))	// `̕Kvȗ̈悪łΏI
		return;

	const EditDoc&				document = getDocument();
	const LineLayoutManager&	layoutManager = sharedData_->layoutManager;
	const LayoutSettings&		layout = layoutManager.getSettings();
	RECT						clientRect;

//	Timer tm(L"onPaint");

	const length_t		lineCount = document.getLineCount();		// _s
	const length_t		displayLineCount = getDisplayLineCount();	// \s
	const EditPoint&	startPoint = selection_->getStartPoint();	// IJnʒu
	const EditPoint&	endPoint = selection_->getEndPoint();		// IIʒu
	const RECT&			paintRect = dc.getPaintStruct().rcPaint;	// `̕Kvȋ`
	const ushort	lineHeight = layoutManager.getLineHeight();
	const ushort	verticalRulerWidth = layoutManager.getVerticalRulerWidth();

	// 
	dc.setBkMode(OPAQUE);
	getClientRect(clientRect);

#define CLIENT_Y_TO_DISPLAY_LINE(y)										\
	min<length_t>(														\
		(y - ((y >= static_cast<long>(layout.topMargin)) ?				\
			layout.topMargin : 0)) / lineHeight + scrollInfo_.getY(),	\
		displayLineCount - 1)

	// `Jn\s
	const length_t displayLine = CLIENT_Y_TO_DISPLAY_LINE(paintRect.top);
	assert(displayLine < displayLineCount);

	// [̕`
	if(paintRect.left < static_cast<long>(verticalRulerWidth))
		drawVerticalRuler(dc, displayLine, CLIENT_Y_TO_DISPLAY_LINE(paintRect.bottom - 1));

#undef CLIENT_Y_TO_DISPLAY_LINE

	// O]̕`
	if(layout.leadMargin != 0)
		dc.fillSolidRect(!layout.rightAlign ?
			clientRect.left + verticalRulerWidth : clientRect.right - verticalRulerWidth - layout.leadMargin,
			paintRect.top, layout.leadMargin, paintRect.bottom - paintRect.top,
			layoutManager.getTokenFoundation(ETT_NORMAL, Token::NULL_COOKIE).bgColor);

	// h~̂߂̃NbsO
	if(verticalRulerWidth + layout.leadMargin > 0)
		dc.excludeClipRect(
			!layout.rightAlign ? clientRect.left : clientRect.right - (verticalRulerWidth + layout.leadMargin),
			paintRect.top,
			!layout.rightAlign ? clientRect.left + (verticalRulerWidth + layout.leadMargin) : clientRect.right,
			paintRect.bottom);

	// `JnsŏIs܂͕܂ōs̖{̂`
	length_t line, offset;
	getDisplayLineOffsetIndex(displayLine, line, offset);
	int y = layout.topMargin
		+ static_cast<int>((displayLine - scrollInfo_.getY()) * lineHeight)
		- static_cast<int>(offset * lineHeight);
	if(line < lineCount) {
		const length_t displayCaretLine = selection_->isEmpty() ?	// Lbgs
			displayLineFromLogicalLine(selection_->getActivePoint().getLineNumber()) : -1;

#ifdef _DEBUG
		if(DIAGNOSE_INHERENT_DRAWING)
			dout << L"lines : ";
#endif /* _DEBUG */
		for(; y < static_cast<int>(paintRect.bottom) && line < lineCount; ++line) {
			// _s1s`
			const bool	isCaretLine = sharedData_->options.appearance[SHOW_CURRENT_UNDERLINE]
										&& selection_->isEmpty()
										&& line == displayCaretLine;
			y += static_cast<int>(drawLine(dc, line, y, isCaretLine) * lineHeight);
		}
#ifdef _DEBUG
		if(DIAGNOSE_INHERENT_DRAWING)
			dout << L"\n";
#endif /* _DEBUG */
	}

	// ŏIs
	if(paintRect.bottom > y
			&& y > static_cast<int>(layout.topMargin + lineHeight - 1))
		dc.fillSolidRect(!layout.rightAlign ? clientRect.left + verticalRulerWidth + layout.leadMargin : clientRect.left,
			y, clientRect.right - clientRect.left - (verticalRulerWidth + layout.leadMargin), paintRect.bottom - y,
			layoutManager.getTokenFoundation(ETT_NORMAL, Token::NULL_COOKIE).bgColor);

	// ]̕`
	if(layout.topMargin > 0)
		dc.fillSolidRect(!layout.rightAlign ? clientRect.left + verticalRulerWidth + layout.leadMargin : clientRect.left,
			clientRect.top, clientRect.right - clientRect.left - (verticalRulerWidth + layout.leadMargin), layout.topMargin,
			layoutManager.getTokenFoundation(ETT_NORMAL, Token::NULL_COOKIE).bgColor);
}

/// @see Window::onRButtonDown
void EditView::onRButtonDown(UINT, const POINT& pt) {
	if(mouseOperationDisabledCount_ != 0)
		return;
	RESTORE_HIDDEN_CURSOR();
	if(endAutoScroll())
		return;
	if(sharedData_->options.behavior[MOVE_CARET_BY_RIGHT_CLICK] && !selection_->isPointOver(pt))
		getSelection().moveTo(charFromPos(pt,
			!sharedData_->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]), true);
}

/// @see Window::onSetCursor
bool EditView::onSetCursor(HWND, UINT, UINT) {
	static length_t	detectedUriLineLast = -1;
	POINT			pt;	// J[\ʒu
	bool			cursorChanged = false;

	RESTORE_HIDDEN_CURSOR();

	::GetCursorPos(&pt);
	screenToClient(pt);

	// [ォ
	const HitTestResult htr = hitTest(pt);
	if(htr == HTR_INDICATORMARGIN || htr == HTR_LINENUMBERS) {
		::SetCursor(::LoadCursor(0, IDC_ARROW));
		return true;
	}

	// I͈ (hbO\ǂ)
	if(sharedData_->options.behavior[OLE_DRAG_AND_DROP] && !selection_->isEmpty()) {
		if(selection_->isPointOver(pt)) {
			::SetCursor(::LoadCursor(0, IDC_ARROW));
			cursorChanged = true;
		}
	}

	// Ñ|bvAbvJ[\̌`ɕςꍇ
	if(!autoScroll_.scrolling
			&& (sharedData_->options.appearance[SHOW_HAND_ON_LINK]
			|| sharedData_->options.appearance[SHOW_HINT_ON_LINK])) {
		char_t* uri = 0;
		if(isOverInvokableLink(pt, uri)) {	// URI
			if(sharedData_->options.appearance[SHOW_HINT_ON_LINK]) {	// |bvAbvo
				const length_t cursorDisplayLine = displayLineFromLogicalLine(charFromPos(pt, true).line_);
				if(cursorDisplayLine != detectedUriLineLast) {
					const string_t message = queryInvokableLinkMessage(uri);
					detectedUriLineLast = cursorDisplayLine;
					if(!message.empty())
						showToolTip(message, 1000, 30000);
					delete[] uri;
				}
			}
			if(sharedData_->options.appearance[SHOW_HAND_ON_LINK] && !cursorChanged) {	// J[\ς
				::SetCursor(::LoadCursor(0, IDC_HAND));
				cursorChanged = true;
			}
		} else {
			detectedUriLineLast = -1;
			hideToolTip();
		}
	}

	return cursorChanged;
}

/// @see Window::onSetFocus
void EditView::onSetFocus(HWND oldWindow) {
	BaseControl::onSetFocus(oldWindow);

	// XN[ʒuɖ߂
	setScrollPos(SB_HORZ, mapInternalXToScrollBoxX(scrollInfo_.position.x), false);
	setScrollPos(SB_VERT, scrollInfo_.position.y, true);

	// I͈͂ĕ`
	invalidateLines(selection_->getStartPoint().getLineNumber(), selection_->getEndPoint().getLineNumber());
	updateWindow();

	if(oldWindow != getHandle()) {
		// Lbg𕜊
		recreateCaret();
		updateCaretPosition();
	}
}

/// @see Window::onSize
void EditView::onSize(UINT type, int cx, int cy) {
	closeCompletionWindow();

	if(type == SIZE_MINIMIZED)
		return;

	// c[`bvɒʒm
	AutoZeroCB<TOOLINFOW> ti;
	RECT viewRect;
	getClientRect(viewRect);
	ti.hwnd = getHandle();
	ti.uId = 1;
	ti.rect = viewRect;
	::SendMessageW(toolTip_, TTM_NEWTOOLRECT, 0, reinterpret_cast<LPARAM>(&ti));

	// `prbg}bṽTCYύX
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	updateMemoryDeviceContext();
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	// ܂Ԃ̍XV
	if(getLayoutSetter().getSettings().wrapMode == WPM_WINDOW)
		sharedData_->layoutManager.invalidate(LineLayout::PARSE_STAGE_FULL);

	// 擪s̍XV
	firstVisibleLine_ = logicalCharFromDisplayChar(CharPos(scrollInfo_.position.y, 0)).line_;
	onVScroll(SB_THUMBTRACK, 0, 0);
	onHScroll(SB_THUMBTRACK, 0, 0);

	updateScrollInfo(true, true);

	// E񂹂̏ꍇ͖őSčĕ`
	if(sharedData_->layoutManager.getSettings().rightAlign) {
		invalidateLines(0, -1);
		updateCaretPosition();
	}
}

/// @see Window::onSysChar
bool EditView::onSysChar(UINT, UINT) {
	RESTORE_HIDDEN_CURSOR();
	return false;
}

/// @see Window::onSysColorChange
void EditView::onSysColorChange() {
	if(this == originalView_) {
		sharedData_->layoutManager.updateSystemColors();
		updateGDIObjects();
	}
}

/// @see Window::onSysKeyDown
bool EditView::onSysKeyDown(UINT, UINT) {
	endAutoScroll();
	return false;
}

/// @see Window::onSysKeyUp
bool EditView::onSysKeyUp(UINT, UINT) {
	RESTORE_HIDDEN_CURSOR();
	return false;
}

/// @see Window::onTimer
void EditView::onTimer(UINT eventID) {
	if(eventID == TIMERID_EXPANDSELECTION
			|| eventID == TIMERID_EXPANDLINESELECTION) {	// I𒆂̎XN[
		POINT pt;
		::GetCursorPos(&pt);
		screenToClient(pt);
		const HitTestResult htr = hitTest(pt);
		if(htr != HTR_INDICATORMARGIN && htr != HTR_LINENUMBERS && htr != HTR_OUTOFVIEW)
			return;
		GENERATE_SELECTED_REGION();
		getSelection().select(positions[0], positions[1], selection_->isRectangle(), true);
	} else if(eventID == TIMERID_DRAGSCROLL) {	// hbO̎XN[
		const LineLayoutManager& layoutManager = sharedData_->layoutManager;
		const LayoutSettings& layout = layoutManager.getSettings();
		const long marginWidth = layoutManager.getVerticalRulerWidth() + layout.leadMargin;
		POINT pt;
		RECT rect;

		::GetCursorPos(&pt);
		screenToClient(pt);
		getClientRect(rect);

		if(pt.y >= rect.top &&
				pt.y <= rect.top + static_cast<long>(layout.topMargin + layoutManager.getLineHeight() / 2))
			onVScroll(SB_LINEUP, 0, 0);
		else if(pt.y >= rect.bottom - static_cast<long>(layoutManager.getLineHeight()) && pt.y <= rect.bottom)
			onVScroll(SB_LINEDOWN, 0, 0);
		else if(!layout.rightAlign) {
			if(pt.x >= rect.left && pt.x <= rect.left + marginWidth)
				onHScroll(SB_SETPOS, scrollInfo_.position.x - 3, 0);
			else if(pt.x >= rect.right - static_cast<long>(layoutManager.getAverageCharacterWidth()) && pt.y <= rect.right)
				onHScroll(SB_SETPOS, scrollInfo_.position.x + 3, 0);
		} else {
			int minPos, maxPos;
			getScrollRange(SB_HORZ, &minPos, &maxPos);
			if(pt.x >= rect.left && pt.x <= rect.left + static_cast<long>(layoutManager.getAverageCharacterWidth()))
				onHScroll(SB_SETPOS, maxPos - minPos - scrollInfo_.position.x + 3, 0);
			else if(pt.x >= rect.right - marginWidth && pt.x <= rect.right)
				onHScroll(SB_SETPOS, maxPos - minPos - scrollInfo_.position.x - 3, 0);
		}
	} else if(eventID == TIMERID_LINEPARSE) {	// ͂̍sǂ݂
		// ...
	} else if(eventID == TIMERID_CALLTIP) {	// c[`bv\
		killTimer(TIMERID_CALLTIP);
		::SendMessageW(toolTip_, TTM_UPDATE, 0, 0L);
	} else if(eventID == TIMERID_AUTOSCROLL) {	// XN[
		POINT pt;

		killTimer(TIMERID_AUTOSCROLL);
		::GetCursorPos(&pt);
		screenToClient(pt);

		const long	yScrollDegree =
			(pt.y - autoScroll_.indicatorPosition.y) / static_cast<long>(sharedData_->layoutManager.getLineHeight());
//		const long	xScrollDegree =
//			(pt.x - autoScroll_.indicatorPosition.x) / static_cast<long>(sharedData_->layoutManager.getLineHeight());
//		const long	scrollDegree = max(abs(yScrollDegree), abs(xScrollDegree));

		if(yScrollDegree != 0 /*&& abs(yScrollDegree) >= abs(xScrollDegree)*/)
			onVScroll((yScrollDegree > 0) ? SB_LINEDOWN : SB_LINEUP, 0, 0);
//		else if(xScrollDegree != 0)
//			onHScroll((xScrollDegree > 0) ? SB_RIGHT : SB_LEFT, 0, 0);

		if(yScrollDegree != 0)
			setTimer(TIMERID_AUTOSCROLL, 500 / static_cast<uint>((pow(2, abs(yScrollDegree) / 2))), 0);
		else
			setTimer(TIMERID_AUTOSCROLL, 300, 0);
	}
}

/// @see WM_UNICHAR
void EditView::onUniChar(UINT ch, UINT) {
#ifndef UNICODE_NOCHAR
	const UINT UNICODE_NOCHAR = 0xFFFF;
#endif /* !UNICODE_NOCHAR */
	if(ch != UNICODE_NOCHAR) {
		// GUI [U̓͂JnJ[\
		if(StandardCommands::CharacterInputCommand(*this, ch).execute() != 0
				&& !modeState_.cursorHiddenForCharInput
				&& sharedData_->options.appearance[HIDE_CURSOR_FOR_CHAR_INPUT]
				&& hasFocus()) {
			POINT pt;

			// J[\Xbh̃EBhEɖƑʖ
			::GetCursorPos(&pt);
			if(::GetWindowThreadProcessId(::WindowFromPoint(pt), 0) == getWindowThreadID()) {
				modeState_.cursorHiddenForCharInput = true;
				::ShowCursor(false);
				setCapture();
			}
		}
		if(imeCompositionActivated_)
			updateIMECompositionWindowPosition();
	}
}

/// @see Window::onVScroll
void EditView::onVScroll(UINT sbCode, UINT pos, HWND) {
	int						newPos = scrollInfo_.position.y;
	int						minPos, maxPos;	// őAŏʒu
	const length_t			visibleLineCount = getVisibleLineCount();
	const LayoutSettings&	layout = getLayoutSetter().getSettings();

	getScrollRange(SB_VERT, &minPos, &maxPos);
	if(getDocument().isNarrowed()) {
		if(visibleLineCount + 1 > getDocument().getStartPoint().line_)
			minPos = max(minPos, 0);
		else
			minPos = max<int>(minPos,
				static_cast<int>(getDocument().getStartPoint().line_ - visibleLineCount + 1) / scrollInfo_.verticalRatio);
		maxPos = min<int>(maxPos,
			static_cast<int>(getDocument().getEndPoint().line_ + visibleLineCount - 1) / scrollInfo_.verticalRatio);
	}

//	if(completionWindow_->isRunning())
//		completionWindow_->abort();
	if(visibleLineCount > (maxPos - minPos) * scrollInfo_.verticalRatio) {
		scrollInfo_.position.y = 0;
//		drawVerticalRuler(0, getVisibleLineCount());
		return;
	}

	switch(sbCode) {
	case SB_LINEUP:		// 1s
		--newPos;	break;
	case SB_LINEDOWN:	// 1s
		++newPos;	break;
	case SB_PAGEUP:		// 1y[W
		newPos -= static_cast<int>(getVisibleLineCount()) - 1;	break;
	case SB_PAGEDOWN:	// 1y[W
		newPos += static_cast<int>(getVisibleLineCount()) - 1;	break;
	case SB_TOP:		// [
		newPos = minPos;	break;
	case SB_BOTTOM:		// [
		newPos = maxPos;	break;
	case SB_THUMBTRACK:	// hbO or zC[
		newPos = getScrollTrackPos(SB_VERT);	break;	// 32rbglg
	case SB_SETPOS:		// IȃXN[
		newPos = pos;	break;
	default:
		return;
	}

	if(isFreezed()) {	// 𓀎ɂ炽߂ăXN[
		setScrollPos(SB_VERT, freezeInfo_.scrollPosition.y = newPos, false);
		return;
	}

	// 
	newPos = max<int>(newPos, minPos);
	newPos = min<int>(newPos, maxPos - static_cast<int>(getVisibleLineCount()) + 1);

	if(newPos == scrollInfo_.position.y)	// XN[Ȃ
		return;

	// 擪s̍XV
//	if(newPos - scrollInfo_.position.y == 1)

	// ĕ`Ȃ
	if(Private::dif<long>(newPos, scrollInfo_.position.y) < visibleLineCount - 1) {	// XN[ʂ1y[Wȉ
		RECT scrollRect;	// XN[Ώ
		const int dy = (scrollInfo_.position.y - newPos) * scrollInfo_.verticalRatio * sharedData_->layoutManager.getLineHeight();

		getClientRect(scrollRect);
		RECT updateRect = scrollRect;
		scrollRect.top = layout.topMargin;
		if(dy > 0) {
			updateRect.top += layout.topMargin;
			updateRect.bottom = updateRect.top + dy;
		} else
			updateRect.top = updateRect.bottom + dy;
		scrollWindowEx(0, dy, &scrollRect, &scrollRect, 0, 0, 0);
		invalidateRect(&updateRect, false);
	} else
		invalidateRect(0, false);

	hideToolTip();
	setScrollPos(SB_VERT, newPos);
	scrollInfo_.position.y = newPos;
	updateCaretPosition();
	if(imeCompositionActivated_)
		updateIMECompositionWindowPosition();
	updateWindow();

	closeCompletionWindow();
}

#undef ABORT_ISEARCH
#undef ABORT_ABBR
#undef BEGIN_WORDUNIT_SELECTION
#undef GENERATE_SELECTED_REGION
#undef RESTORE_HIDDEN_CURSOR

/* [EOF] */