// Encoder.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "Encoder.h"
#include <algorithm>

using namespace Ascension::Encodings;
using namespace std;


DEFINE_DETECTOR(CPEX_AUTODETECT_SYSTEMLANG, SystemLang);
DEFINE_DETECTOR(CPEX_AUTODETECT_USERLANG, UserLang);


namespace {
	set<CodePage>* working;

	BOOL CALLBACK enumCodePagesProc(LPWSTR name) {
		const CodePage cp = wcstoul(name, 0, 10);
		if(toBoolean(::IsValidCodePage(cp)))
			working->insert(cp);
		return TRUE;
	}

	void detectCodePage_SystemLang(const uchar*, size_t, CodePage&, size_t&) {
		assert(false);
	}
	void detectCodePage_UserLang(const uchar*, size_t, CodePage&, size_t&) {
		assert(false);
	}
} // namespace `anonymous'


/**
 *	GR[_쐬
 *	@param cp	R[hy[W
 *	@return		GR[_BĂяo폜BR[hy[WȂƂ null Ԃ
 */
auto_ptr<Encoder> EncoderFactory::createEncoder(CodePage cp) {
	EncoderMap::iterator it = registeredEncoders_.find(cp);
	if(it != registeredEncoders_.end())
		return it->second();
	else {
		try {
			return auto_ptr<Encoder>(new WindowsEncoder(cp));
		} catch(invalid_argument&) {
			return auto_ptr<Encoder>(0);
		}
	}
}

/**
 *	
 *	@param src		
 *	@param length	ׂoCg
 *	@param cp		ʂɎgp錾
 */
CodePage EncoderFactory::detectCodePage(const uchar* src, size_t length, CodePage cp) {
	assert(src != 0);

	if(!isCodePageForAutoDetection(cp))
		return cp;

	CodePage result;
	size_t score;

	// ߓIɌIꍇ
	if(cp == CPEX_AUTODETECT_SYSTEMLANG || cp == CPEX_AUTODETECT_USERLANG) {
		const LANGID langID = (cp == CPEX_AUTODETECT_SYSTEMLANG) ? ::GetSystemDefaultLangID() : ::GetUserDefaultLangID();
		switch(PRIMARYLANGID(langID)) {
		case LANG_ARMENIAN:	cp = CPEX_ARMENIAN_AUTODETECT;	break;
		case LANG_JAPANESE:	cp = CPEX_JAPANESE_AUTODETECT;	break;
//		case LANG_KOREAN:	cp = CPEX_KOREAN_AUTODETECT;	break;
		default:			cp = CPEX_UNICODE_AUTODETECT;	break;
		}
	}

	DetectorMap::iterator it = registeredDetectors_.find(cp);

	assert(it != registeredDetectors_.end());
	it->second(src, length, result, score);
	return (score != 0) ? result : ::GetACP();
}

/// p\ȃR[hy[W
void EncoderFactory::enumCodePages(set<CodePage>& codePages) const {
	codePages.clear();
	for(EncoderMap::const_iterator it = registeredEncoders_.begin(); it != registeredEncoders_.end(); ++it)
		codePages.insert(it->first);
	for(DetectorMap::const_iterator it = registeredDetectors_.begin(); it != registeredDetectors_.end(); ++it)
		codePages.insert(it->first);
	working = &codePages;
	::EnumSystemCodePagesW(enumCodePagesProc, CP_INSTALLED);
}

/* [EOF] */