// Lao.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "Encoder.h"

using namespace Ascension::Encodings;
using namespace std;


BEGIN_ENCODER_DEFINITION()
	DEFINE_ENCODER_CLASS(CPEX_LAO_MULELAO, Lao_Mulelao, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_LAO_CP1133, Lao_Cp1133, 1, 1)
END_ENCODER_DEFINITION()

namespace {
	const wchar_t MULELAOtoUCS[] = {
	/* 0xA0 */	0x00A0, 0x0E81, 0x0E82, RP__CH, 0x0E84, RP__CH, RP__CH, 0x0E87,
				0x0E88, RP__CH, 0x0E8A, RP__CH, RP__CH, 0x0E8D, RP__CH, RP__CH,
	/* 0xB0 */	RP__CH, RP__CH, RP__CH, RP__CH, 0x0E94, 0x0E95, 0x0E96, 0x0E97,
				RP__CH, 0x0E99, 0x0E9A, 0x0E9B, 0x0E9C, 0x0E9D, 0x0E9E, 0x0E9F,
	/* 0xC0 */	RP__CH, 0x0EA1, 0x0EA2, 0x0EA3, RP__CH, 0x0EA5, RP__CH, 0x0EA7,
				RP__CH, RP__CH, 0x0EAA, 0x0EAB, RP__CH, 0x0EAD, 0x0EAE, 0x0EAF,
	/* 0xD0 */	0x0EB0, 0x0EB1, 0x0EB2, 0x0EB3, 0x0EB4, 0x0EB5, 0x0EB6, 0x0EB7,
				0x0EB8, 0x0EB9, RP__CH, 0x0EBB, 0x0EBC, 0x0EBD, RP__CH, RP__CH,
	/* 0xE0 */	0x0EC0, 0x0EC1, 0x0EC2, 0x0EC3, 0x0EC4, RP__CH, 0x0EC6, RP__CH,
				0x0EC8, 0x0EC9, 0x0ECA, 0x0ECB, 0x0ECC, 0x0ECD, RP__CH, RP__CH,
	/* 0xF0 */	0x0ED0, 0x0ED1, 0x0ED2, 0x0ED3, 0x0ED4, 0x0ED5, 0x0ED6, 0x0ED7,
				0x0ED8, 0x0ED9, RP__CH, RP__CH, 0x0EDC, 0x0EDD, RP__CH, RP__CH,
	};
	const uchar UCStoMULELAO[] = {
	/* U+0E80 */	N__A, 0xA1, 0xA2, N__A, 0xA4, N__A, N__A, 0xA7,
					0xA8, N__A, 0xAA, N__A, N__A, 0xAD, N__A, N__A,
	/* U+0E90 */	N__A, N__A, N__A, N__A, 0xB4, 0xB5, 0xB6, 0xB7,
					N__A, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
	/* U+0EA0 */	N__A, 0xC1, 0xC2, 0xC3, N__A, 0xC5, N__A, 0xC7,
					N__A, N__A, 0xCA, 0xCB, N__A, 0xCD, 0xCE, 0xCF,
	/* U+0EB0 */	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
					0xD8, 0xD9, N__A, 0xDB, 0xDC, 0xDD, N__A, N__A,
	/* U+0EC0 */	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, N__A, 0xE6, N__A,
					0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, N__A, N__A,
	/* U+0ED0 */	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
					0xF8, 0xF9, N__A, N__A, 0xFC, 0xFD
	};
	const wchar_t CP1133toUCS[] = {
	/* 0xA0 */	0x00A0, 0x0E81, 0x0E82, 0x0E84, 0x0E87, 0x0E88, 0x0EAA, 0x0E8A,
				0x0E8D, 0x0E94, 0x0E95, 0x0E96, 0x0E97, 0x0E99, 0x0E9A, 0x0E9B,
	/* 0xB0 */	0x0E9C, 0x0E9D, 0x0E9E, 0x0E9F, 0x0EA1, 0x0EA2, 0x0EA3, 0x0EA5,
				0x0EA7, 0x0EAB, 0x0EAD, 0x0EAE, RP__CH, RP__CH, RP__CH, 0x0EAF,
	/* 0xC0 */	0x0EB0, 0x0EB2, 0x0EB3, 0x0EB4, 0x0EB5, 0x0EB6, 0x0EB7, 0x0EB8,
				0x0EB9, 0x0EBC, 0x0EB1, 0x0EBB, 0x0EBD, RP__CH, RP__CH, RP__CH,
	/* 0xD0 */	0x0EC0, 0x0EC1, 0x0EC2, 0x0EC3, 0x0EC4, 0x0EC8, 0x0EC9, 0x0ECA,
				0x0ECB, 0x0ECC, 0x0ECD, 0x0EC6, RP__CH, 0x0EDC, 0x0EDD, 0x20AD,
	/* 0xE0 */	RP__CH, RP__CH, RP__CH, RP__CH, RP__CH, RP__CH, RP__CH, RP__CH,
				RP__CH, RP__CH, RP__CH, RP__CH, RP__CH, RP__CH, RP__CH, RP__CH,
	/* 0xF0 */  0x0ED0, 0x0ED1, 0x0ED2, 0x0ED3, 0x0ED4, 0x0ED5, 0x0ED6, 0x0ED7,
				0x0ED8, 0x0ED9, RP__CH, RP__CH, 0x00A2, 0x00AC, 0x00A6, RP__CH,
	};
	const uchar UCStoCP1133_00A0[] = {
	/* U+0EA0 */	0xA0, N__A, 0xFC, N__A, N__A, N__A, 0xFE, N__A,
					N__A, N__A, N__A, N__A, 0xFD
	};
	const uchar UCStoCP1133_0E80[] = {
	/* U+0E80 */	N__A, 0xA1, 0xA2, N__A, 0xA3, N__A, N__A, 0xA4,
					0xA5, N__A, 0xA7, N__A, N__A, 0xA8, N__A, N__A,
	/* U+0E90 */	N__A, N__A, N__A, N__A, 0xA9, 0xAA, 0xAB, 0xAC,
					N__A, 0xAD, 0xAE, 0xAF, 0xB0, 0xB1, 0xB2, 0xB3,
	/* U+0EA0 */	N__A, 0xB4, 0xB5, 0xB6, N__A, 0xB7, N__A, 0xB8,
					N__A, N__A, 0xA6, 0xB9, N__A, 0xBA, 0xBB, 0xBF,
	/* U+0EB0 */	0xC0, 0xCA, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6,
					0xC7, 0xC8, N__A, 0xCB, 0xC9, 0xCC, N__A, N__A,
	/* U+0EC0 */	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, N__A, 0xDB, N__A,
					0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, N__A, N__A,
	/* U+0ED0 */	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
					0xF8, 0xF9, N__A, N__A, 0xDD, 0xDE
	};
}


// I (MuleLao-1) ///////////////////////////////////////////////////////

size_t Encoder_Lao_Mulelao::fromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	const size_t len = min(srcLength, destLength);
	for(size_t i = 0; i < len; ++i) {
		if(src[i] <= 0x00A0)
			dest[i] = BIT8_MASK(src[i]);
		else {
			dest[i] = (src[i] >= 0x0E80 && src[i] < 0x0E80 + countof(UCStoMULELAO)) ? UCStoMULELAO[src[i] - 0x0E80] : N__A;
			if(dest[i] == N__A)
				CONFIRM_ILLEGAL_CHAR(dest[i]);
		}
	}
	return len;
}

size_t Encoder_Lao_Mulelao::toUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	const size_t len = min(srcLength, destLength);
	for(size_t i = 0; i < len; ++i) {
		if(src[i] < 0xA0)
			dest[i] = src[i];
		else {
			dest[i] = MULELAOtoUCS[src[i] - 0xA0];
			if(dest[i] == REPLACEMENT_CHARACTER)
				CONFIRM_ILLEGAL_CHAR(dest[i]);
		}
	}
	return len;
}


// I (ibm-1133) ////////////////////////////////////////////////////////

size_t Encoder_Lao_Cp1133::fromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	const size_t len = min(srcLength, destLength);
	for(size_t i = 0; i < len; ++i) {
		if(src[i] < 0x00A0)
			dest[i] = BIT8_MASK(src[i]);
		else {
			MAP_TABLE_SB_START(0x00A0, UCStoCP1133_00A0);
			MAP_TABLE_SB(0x0E80, UCStoCP1133_0E80);
			else if(src[i] == 0x20AD)
				dest[i] = static_cast<uchar>(0xDF);
			else
				dest[i] = N__A;
			if(dest[i] == N__A)
				CONFIRM_ILLEGAL_CHAR(dest[i]);
		}
	}
	return len;
}

size_t Encoder_Lao_Cp1133::toUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	const size_t len = min(srcLength, destLength);
	for(size_t i = 0; i < len; ++i) {
		if(src[i] < 0xA0)
			dest[i] = src[i];
		else {
			dest[i] = CP1133toUCS[src[i] - 0xA0];
			if(dest[i] == REPLACEMENT_CHARACTER)
				CONFIRM_ILLEGAL_CHAR(dest[i]);
		}
	}
	return len;
}

/* [EOF] */