// LineLayout.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "LineLayout.h"
#include "EditView.h"

using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Manah;
using namespace Manah::Windows::GDI;
using namespace std;
//using LineLayoutManager::BidiClass;


#define FIRE_LAYOUT_EVENT(event)																		\
	for(set<IEventListener*>::iterator it = eventListeners_.begin(); it != eventListeners_.end(); ++it)	\
		(*it)->on##event()
#define PREPARE_DC(dc)	\
	ClientDC dc = eventListeners_.empty() ? ScreenDC() : (*eventListeners_.begin())->onQueryDeviceContext()

#ifdef _DEBUG
#include "../../Manah/Timer.hpp"
using Manah::Windows::Timer;
using Manah::Windows::dout;
#endif /* _DEBUG */


namespace {
	// zfobOo
	template<class T> inline void dumpArray(const T* arr, size_t c) {
		for(size_t i = 0; i < c; ++i)
			Manah::Windows::dout << arr[i] << L",";
		Manah::Windows::dout << L"\n";
	}

	// ASCII 䕶𔻕ʂ֐IuWFNg (Lexer::isAsciiControl )
	struct isAsciiControl {
		operator ()(char_t ch) const {
			return ch < 0x20 || ch == 0x7F;
		}
	};
	// P̃쐬
	inline auto_ptr<LineLayout::Runs> createSimpleRuns() {
		LineLayout::Run** temp = new LineLayout::Run*[1];
		temp[0] = new LineLayout::Run(0, false);
		return auto_ptr<LineLayout::Runs>(new LineLayout::Runs(1, temp));
	}
}


// LineLayout class implementation
/////////////////////////////////////////////////////////////////////////////

const Tokens				LineLayout::NULL_TOKEN_LIST;
const Tokens				LineLayout::SIMPLE_TOKEN_LIST;
auto_ptr<LineLayout::Runs>	LineLayout::simpleRuns_;

/// ێĂg[NXg폜
void LineLayout::deleteTokenList() {
	// Loł΍폜Ȃ
	if(tokens_ != &NULL_TOKEN_LIST && tokens_ != &SIMPLE_TOKEN_LIST)
		delete tokens_;
	tokens_ = 0;
}

/**
 *	w肵͒iK܂Ŋ߂
 *	@param stage ͒iK
 */
void LineLayout::backParseStage(ParseStage stage) {
	if(stage <= PARSE_STAGE_FULL) {
		delete[] runs_;
		runs_ = 0;
		delete[] caretPositions_;
		caretPositions_ = 0;
		delete wrapOffsets_;
		wrapOffsets_ = 0;
		parseStage_ = PARSE_STAGE_TOKENS;
	}
	if(stage <= PARSE_STAGE_TOKENS) {
		deleteTokenList();
		parseStage_ = PARSE_STAGE_MULTILINE_ANNOTATIONS;
	}
}

/// ̃XgԂ
const LineLayout::Runs& LineLayout::getRuns() const {
	if(runs_ != 0)
		return *runs_;
	else if(simpleRuns_.get() == 0)
		simpleRuns_ = createSimpleRuns();
	return *simpleRuns_.get();
}


// LineLayoutManager class implementation
/////////////////////////////////////////////////////////////////////////////

LineLayoutManager::BidirectionalLayoutCalculator LineLayoutManager::bidiCalculator_;

/**
 *	RXgN^
 *	@param document hLg
 */
LineLayoutManager::LineLayoutManager(EditDoc& document)
		: document_(document), lexingEnabled_(true), freezeCount_(0),
		longestLine_(-1), regularFont_(0), boldFont_(0), italicFont_(0), boldItalicFont_(0)
#ifdef SUBSTITUTE_BIDIFORMATTERS
		, bidiFmtSubstFont_(0)
#endif /* SUBSTITUTE_BIDIFORMATTERS */
{
	lexer_.reset(new Lexer(this));
	for(size_t i = 0; i < ETT_COUNT; ++i) {
		if(i != Token::KEYWORD && i != Token::ANNOTATION)
			tokenFoundations_[i].body.foundation = new TextFoundation();
		else
			tokenFoundations_[i].body.cookedFoundations = new CookedTokenMap();
		tokenFoundations_[i].enabled = true;
	}

	// ̃tHg
	const LOGFONTW defaultFont = {
		0, 0, 0, 0, FW_NORMAL, false, false, false,
		ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
		FIXED_PITCH | FF_DONTCARE, L"Terminal"
	};
	setFont(defaultFont);
}

/// fXgN^
LineLayoutManager::~LineLayoutManager() {
	deleteAllLines();
	for(size_t i = 0; i < ETT_COUNT; ++i) {
		if(i != Token::KEYWORD && i != Token::ANNOTATION)
			delete tokenFoundations_[i].body.foundation;
		else
			delete tokenFoundations_[i].body.cookedFoundations;
	}
	::DeleteObject(regularFont_);
	::DeleteObject(boldFont_);
	::DeleteObject(italicFont_);
	::DeleteObject(boldItalicFont_);
#ifdef SUBSTITUTE_BIDIFORMATTERS
	delete bidiFmtSubstFont_;
#endif /* SUBSTITUTE_BIDIFORMATTERS */
}

/// CxgXi̒ǉ
void LineLayoutManager::addEventListener(LineLayoutManager::IEventListener& eventListener) {
	assertValid();
	eventListeners_.insert(&eventListener);
}

/// @see Bookmarker::clearAllBookmarks
void LineLayoutManager::clearAllBookmarks() {
	bool clearedOnce = false;

	Lines::Iterator end = lines_.end();
	for(Lines::Iterator i = lines_.begin(); i != end; ++i) {
		if((*i)->isBookmarked()) {
			(*i)->setBookmark(false);
			clearedOnce = true;
		}
	}
	if(clearedOnce)
		FIRE_LAYOUT_EVENT(ClearedAllBookmarks);
}

/// CAEgׂĔj
void LineLayoutManager::deleteAllLines() {
	assertValid();
	lines_.clear();
	longestLine_ = -1;
}

/**
 *	̍s̃CAEg폜
 *	@param startLine	폜Jns
 *	@param endLine		폜Is (̍s폜)
 *	@throw std::out_of_range	sԍsȂƂX[
 */
void LineLayoutManager::deleteLines(length_t startLine, length_t endLine) {
	assertValid();
	assert(startLine <= endLine);
	if(startLine >= lines_.getSize() || endLine >= lines_.getSize())
		throw out_of_range("Specified lines are not found.");

	lines_.erase(startLine, endLine - startLine + 1);

	if(longestLine_ != -1 && settings_.wrapMode == WPM_NONE) {
		// Œs폜?
		if(longestLine_ >= startLine && longestLine_ <= endLine)
			updateLongestLine();
		// Œs炷
		else if(endLine < longestLine_)
			longestLine_ -= endLine - startLine + 1;
	}

	const length_t lineCount = lines_.getSize();
	if(startLine == lineCount)
		return;

	// 㑱̉e󂯂s`FbN
	length_t line = startLine;
	if(line == 0 && lines_[line]->multilineAnnotationFromPrev_ == Token::NULL_COOKIE)
		return;
	else if(line != 0 && lines_[line - 1]->multilineAnnotationToNext_ == lines_[line]->multilineAnnotationFromPrev_)
		return;
	while(true) {
		parseMultilineCommentContinue(line);
		if(line + 1 == lineCount
				|| (lines_[line]->parseStage_ < LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				|| lines_[line]->multilineAnnotationToNext_ == lines_[line + 1]->multilineAnnotationFromPrev_) {
			break;	// e͂̍sŏI
		}
		++line;
	}
}

/// @see LayoutSettings::enableLexicalParsing
void LineLayoutManager::enableLexicalParsing(bool enable) {
	assertValid();
	if(enable != lexingEnabled_) {
		lexingEnabled_ = enable;
		invalidate(LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS);
	}
}

/*
/// w肵R[h|Cg̑oeLXgԂ
BidiClass LineLayoutManager::getBidiClass(ulong cp) {
	// bidi_class.pl 쐬
#if(ASCENSION_UNICODE_VERSION != 0x0400)
#error This method is based on old version of Unicode.
#endif
#include "Script\LineLayout_BidiClassList_4_0"
#define CHECK_BIDI_CLASS(klass)																	\
	if(binary_search(arr##klass, arr##klass + sizeof(arr##klass) / sizeof(ulong), cp))	\
		return BC_##klass

	switch(cp) {
	case 0x202A:	return BC_LRE;
	case 0x202B:	return BC_RLE;
	case 0x202C:	return BC_PDF;
	case 0x202D:	return BC_LRO;
	case 0x202E:	return BC_RLO;
	}
	CHECK_BIDI_CLASS(R);
	CHECK_BIDI_CLASS(AL);
	CHECK_BIDI_CLASS(EN);
	CHECK_BIDI_CLASS(ES);
	CHECK_BIDI_CLASS(ET);
	CHECK_BIDI_CLASS(AN);
	CHECK_BIDI_CLASS(CS);
	CHECK_BIDI_CLASS(NSM);
	CHECK_BIDI_CLASS(BN);
	CHECK_BIDI_CLASS(B);
	CHECK_BIDI_CLASS(S);
	CHECK_BIDI_CLASS(WS);
	CHECK_BIDI_CLASS(ON);
	return BC_L;
}*/

/// hLǧ݂̍ŏIsԍ10iŉɂȂ邩Ԃ
uint LineLayoutManager::getLineNumberMaxDigit() const {
	assertValid();

	uint n = 1;
	length_t lineCount = document_.getLineCount() + settings_.lineNumberLayout.startLine - 1;

	while(lineCount >= 10) {
		lineCount /= 10;
		++n;
	}
	return n;
}

/// @see Bookmarker::getNextBookmark
length_t LineLayoutManager::getNextBookmark(length_t line) const {
	assertValid();
	if(line != -1 && line >= lines_.getSize())
		throw out_of_range("Specified line is not found.");
	const LineLayout& layout = *lines_[(line != -1) ? line : 0];

	if(line != -1 && !layout.isBookmarked())
		throw invalid_argument("Specified line is not bookmarked.");
	const Lines::ConstIterator end = lines_.end();
	for(Lines::ConstIterator i(lines_.begin() + ++line); i != end; ++i, ++line) {
		if((*i)->isBookmarked())
			return line;
	}
	return -1;
}


/// @see LayoutSettings::getTokenFoundation
TextFoundation LineLayoutManager::getTokenFoundation(int type, Token::Cookie cookie) const {
	assertValid();
	if(type < Token::FIRST || type >= ETT_COUNT)
		throw invalid_argument("Invalid token type.");

	TextFoundation tf;
	if(type != Token::KEYWORD && type != Token::ANNOTATION)
		tf = *tokenFoundations_[type].body.foundation;
	else {
		CookedTokenMap::iterator it = tokenFoundations_[type].body.cookedFoundations->find(cookie);
		if(it == tokenFoundations_[type].body.cookedFoundations->end())
			throw invalid_argument("Invalid cookie value.");
		tf = it->second;
	}

	// OiF̎
	if(tf.fgColor == -1) {
		if(type == ETT_NORMAL)					tf.fgColor = systemColors_.getColor(COLOR_WINDOWTEXT);
		else if(type == ETT_SELECTION)			tf.fgColor = systemColors_.getColor(COLOR_HIGHLIGHTTEXT);
		else if(type == ETT_INACTIVE_SELECTION)	tf.fgColor = systemColors_.getColor(COLOR_INACTIVECAPTIONTEXT);
		else if(type == ETT_INDICATOR_MARGIN)	tf.fgColor = systemColors_.getColor(COLOR_3DSHADOW);
		else if(type == ETT_RESTRICTION)		tf.fgColor = systemColors_.getColor(COLOR_GRAYTEXT);
		else
			tf.fgColor = (tokenFoundations_[ETT_NORMAL].body.foundation->fgColor != -1) ?
				tokenFoundations_[ETT_NORMAL].body.foundation->fgColor : systemColors_.getColor(COLOR_WINDOWTEXT);
	} else if(tf.fgColor > 0x7FFFFFFFUL)
		tf.fgColor = systemColors_.getColor(tf.fgColor - 0x80000000UL);

	// wiF̎
	if(tf.bgColor == -1) {
		if(type == ETT_NORMAL)					tf.bgColor = systemColors_.getColor(COLOR_WINDOW);
		else if(type == ETT_SELECTION)			tf.bgColor = systemColors_.getColor(COLOR_HIGHLIGHT);
		else if(type == ETT_INACTIVE_SELECTION)	tf.bgColor = systemColors_.getColor(COLOR_INACTIVECAPTION);
		else if(type == ETT_INDICATOR_MARGIN)	tf.bgColor = systemColors_.getColor(COLOR_3DFACE);
		else
			tf.bgColor = (tokenFoundations_[ETT_NORMAL].body.foundation->bgColor != -1) ?
				tokenFoundations_[ETT_NORMAL].body.foundation->bgColor : systemColors_.getColor(COLOR_WINDOW);
	} else if(tf.bgColor > 0x7FFFFFFFUL)
		tf.bgColor = systemColors_.getColor(tf.bgColor - 0x80000000UL);

	// /gF̎
	if(tf.borderColor == -1)
		tf.borderColor = (type != ETT_LINK) ? tf.fgColor : tokenFoundations_[ETT_NORMAL].body.foundation->fgColor;
	else if(tf.borderColor > 0x7FFFFFFFUL)
		tf.borderColor = systemColors_.getColor(tf.borderColor - 0x80000000UL);

	return tf;
}

/**
 *	̍sCAEg쐬AXgɒǉ
 *	@param startLine	}Jns
 *	@param endLine		}Is (̍s})
 *	@throw std::out_of_range	sԍsȂƂX[
 */
void LineLayoutManager::insertLines(length_t startLine, length_t endLine) {
	assertValid();
	assert(startLine <= endLine);
	if(startLine >= document_.getLineCount() || endLine >= document_.getLineCount())
		throw out_of_range("Specified lines are no exist.");

//	Timer tm(L"insertLines");

	// s̑}
	LineLayout** newLines = new LineLayout*[endLine - startLine + 1];
	for(size_t i = 0; i < endLine - startLine + 1; ++i)
		newLines[i] = new LineLayout;
	lines_.insert(startLine, newLines, newLines + endLine - startLine + 1);
	delete[] newLines;

	// Œs炷
	if(longestLine_ != -1 && startLine <= longestLine_)
		longestLine_ += endLine - startLine + 1;

	// }s̏XV
	for(length_t i = startLine; i <= endLine; ++i) {
		if(ASCENSION_MINIMUM_LINE_PARSE_STAGE <= LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
			parseMultilineCommentContinue(i);
		else if(ASCENSION_MINIMUM_LINE_PARSE_STAGE == LineLayout::PARSE_STAGE_TOKENS)
			parseTokens(i);
		else if(ASCENSION_MINIMUM_LINE_PARSE_STAGE == LineLayout::PARSE_STAGE_FULL)
			parseCharacterPositions(i);
		else
			assert(false);
	}

	// 㑱̉e󂯂s`FbN
	const length_t lineCount = lines_.getSize();
	for(length_t line = endLine; line + 1 < lineCount; ) {
		if((lines_[line + 1]->parseStage_ < LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				|| (lines_[line]->multilineAnnotationToNext_ == lines_[line + 1]->multilineAnnotationFromPrev_))
			break;	// e͂̍sŏI
		parseMultilineCommentContinue(++line);
	}
}

/**
 *	SĂ̍sɑ΂Ďw肵x̉͂蒼Kv邱Ƃʒm
 *	@param stage ̓x
 */
void LineLayoutManager::invalidate(LineLayout::ParseStage stage) {
	assertValid();
	const Lines::Iterator end = lines_.end();
	for(Lines::Iterator i = lines_.begin(); i != end; ++i) {
		if((*i)->parseStage_ >= stage)
			(*i)->parseStage_ = static_cast<LineLayout::ParseStage>(stage - 1);
	}
}

/**
 *	w肵s̃CAEgXV
 *	@param line		(_) sԍ
 *	@return			esB@a line ܂܂B1ȏ
 *	@throw std::out_of_range	@a line sȂƂX[
 */
length_t LineLayoutManager::modifyLine(length_t line) {
	assertValid();
	if(line >= lines_.getSize())
		throw out_of_range("Specified line is not exist.");

	LineLayout& layout = *lines_[line];
	delete layout.wrapOffsets_;
	layout.wrapOffsets_ = 0;
	layout.parseStage_ = LineLayout::PARSE_STAGE_UNPARSED;

//	if(view_->modeState_.wrapMode == WPM_NONE)
		parseCharacterPositions(line);
/*	else {	// ܂Ԃ̌vZ
		// ܂Ԃƍs̕\ɂ
		const string_t& s = document_.getLine(line);
		ulong cxLine = 0;
		HFONT oldFont = view_->gdiObjects_.memDC_.selectObject(view_->gdiObjects_.normalFont);
		ulong cxWrap;
		uint cxChar;

		layout.wrappedOffsets_ = new WrappedOffsets;
		if(view_->modeState_.wrapMode == WPM_SPECIFIED)
			cxWrap = view_->modeState_.wrapWidth;
		else if(view_->modeState_.wrapMode == WPM_WINDOW) {
			RECT rect;
			view_.getClientRect(&rect);
			cxWrap = rect.right - rect.left
						- view_.layoutInfo.leftTabWidth - view_->layoutInfo.leftMargin;
		}
		for(length_t i = 0; i < s.length(); ++i) {
			if(s[i] == L'\t')
				cxChar = view_->layoutInfo_.tabWidth * view_->getAvgCharWidth()
							- cxLine % (view_->layoutInfo_.tabWidth * view_->getAvgCharWidth());
			else
				cxChar = view_->gdiObjects_.memDC_.getTextExtent(s.data() + i, 1).cx;
			if(cxLine + cxChar > cxWrap) {	// ܂Ԃ
				layout.wrappedOffsets_->push_back(i);
				cxLine = 0;
			}
			cxLine += cxChar;
		}
	}

	view_->gdiObjects_.memDC_.selectObject(oldFont);
*/
	// 㑱s̕sRgɂ
	const length_t originalLine = line;
	while(line + 1 < lines_.getSize()) {
		if((lines_[line + 1]->parseStage_ < LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS)
				|| (lines_[line]->multilineAnnotationToNext_ == lines_[line + 1]->multilineAnnotationFromPrev_)) {
			break;	// e͂̍sŏI
		}
		parseMultilineCommentContinue(++line);
	}
	return line - originalLine + 1;
}

/// @see Bookmarker::isBookmarked
bool LineLayoutManager::isBookmarked(length_t line) const{
	assertValid();
	if(line >= lines_.getSize())
		throw out_of_range("Specified line is not found.");
	return lines_[line]->isBookmarked();
}

/// @see ILexerEventListener::onLexerAddedIdentifiedToken
void LineLayoutManager::onLexerAddedIdentifiedToken(Token::Type type, Token::Cookie cookie) {
	assertValid();
	tokenFoundations_[type].body.cookedFoundations->insert(make_pair(cookie, TextFoundation()));
}

/// @see ILexerEventListener::onLexerChanged
void LineLayoutManager::onLexerChanged() {
	assertValid();
	invalidate(ASCENSION_MINIMUM_LINE_PARSE_STAGE);
	FIRE_LAYOUT_EVENT(ChangedLayout);
}

/// @see ILexerEventListener::onLexerCleared
void LineLayoutManager::onLexerCleared() {
	assertValid();
	tokenFoundations_[Token::KEYWORD].body.cookedFoundations->clear();
	tokenFoundations_[Token::ANNOTATION].body.cookedFoundations->clear();
	invalidate(ASCENSION_MINIMUM_LINE_PARSE_STAGE);
	FIRE_LAYOUT_EVENT(ChangedLayout);
}

/// @see ILexerEventListener::onLexerRemovedIdentifiedToken
void LineLayoutManager::onLexerRemovedIdentifiedToken(Token::Type type, Token::Cookie cookie) {
	assertValid();
	CookedTokenMap::iterator removed = tokenFoundations_[type].body.cookedFoundations->find(cookie);
	tokenFoundations_[type].body.cookedFoundations->erase(removed);
}


/**
 *	@brief ws̉͂sB͍ς݂łΉȂ
 *
 *	LineLayoutManager ̃NCAg getLine gƂŉ͍ς݂̍s擾ł邪A
 *	getLine ȊÕ\bh͍s͂sȂ̂ŁA
 *	̃\bhŗ\߉͂sƂŃI[owbhɘa邱Ƃł
 *	@param line					_s
 *	@throw std::out_of_range	@a line sȂƂX[
 */
void LineLayoutManager::parseLine(length_t line) {
	assertValid();
	if(line >= lines_.getSize())
		throw out_of_range("Specified line is not found.");
	else if(lines_[line]->parseStage_ < LineLayout::PARSE_STAGE_FULL)
		parseCharacterPositions(line);
}

/**
 *	ʒǔvZs
 *	@param line _sԍ
 */
void LineLayoutManager::parseCharacterPositions(length_t line) {
	assertValid();
	assert(line < lines_.getSize());

	LineLayout& layout = *lines_[line];

	// g[N؂oIĂȂ΂Ȃ
	if(layout.parseStage_ < LineLayout::PARSE_STAGE_TOKENS)
		parseTokens(line);

	const length_t lineLength = document_.getLineLength(line);
	int* positions = new int[lineLength + 1];

	delete layout.runs_;
	delete[] layout.caretPositions_;
	layout.caretPositions_ = positions;
	positions[0] = 0;

	if(lineLength == 0) {
		layout.runs_ = 0;
		layout.width_ = 0;
		layout.parseStage_ = LineLayout::PARSE_STAGE_FULL;
		return;
	}

	PREPARE_DC(dc);
	const char_t* const first = document_.getLine(line).data();
	const char_t* const last = first + lineLength;
	HFONT oldFont = dc.selectObject(regularFont_);

	dc.setTextCharacterExtra(settings_.charSpan);

	// 𓾂
	size_t*	runOrders;
	LineLayout::Runs& runs = settings_.performBidirection ?
		*bidiCalculator_.calculate(dc, first, last, settings_.rightToLeftReading, runOrders).release() : *createSimpleRuns().release();
	if(!settings_.performBidirection) {
		runOrders = new size_t[1];
		runOrders[0] = 0;
	}
	layout.runs_ = &runs;
	assert(layout.runs_ != 0);

	// oꏇ̑ʒuvZĂ
	const Tokens& tokens = layout.getTokens();
	int offset = 0;		// s̈ʒu
	HFONT font;			// I𒆂̃tHg
	const char_t* nextCtrl;			// ̐䕶
	const char_t* nextFontChange;	// ̃tHg̕ς
	for(size_t runIndex = 0; runIndex < runs.getCount(); ++runIndex) {
		// ^uA֐䕶ȂẽLbgʒu𓾂B
		// ^u͐p̌vZŁA֐䕶͑փOtɕϊA
		// ̕ƓlɃOt̉ʒuvZB
		// ܂AAC^bN̂Ń_Og[Nł
		// ۂɃtHgIĈʒuvZ
		LineLayout::Run& run = *runs.array_[runOrders[runIndex]];
		const bool lastRun = runOrders[runIndex] == runs.getCount() - 1;
		const char_t* p = first + run.getIndex();	// ݈ʒu
		const char_t* const end =					// ̃̏I[
			!lastRun ? first + runs.getAt(runOrders[runIndex] + 1).getIndex() : last;
		SIZE size;

		size_t tokenIndex = 0;	// ݈ʒu܂ރg[N ( while [v̐擪ŏ)
		assert(tokenIndex < tokens.count);

		nextCtrl = find_if(p, end, isAsciiControl());
		nextFontChange = p;
		run.width_ = 0;
		positions[run.getIndex()] = offset;
		while(p < end) {
			if(p == nextFontChange) {	// tHgύX
				for(; tokenIndex + 1 < tokens.count; ++tokenIndex) {	// ݈ʒu܂ tokenIndex i߂
					if(tokens.array[tokenIndex].getIndex() <= static_cast<size_t>(p - first)
							&& tokens.array[tokenIndex + 1].getIndex() > static_cast<size_t>(p - first))
						break;
				}
				assert(tokenIndex < tokens.count);

				font = getFontForRenderingToken(tokens.array[tokenIndex].getType(), tokens.array[tokenIndex].getCookie());
				dc.selectObject(font);
				nextFontChange = end;
				for(size_t i = tokenIndex + 1;
						i < tokens.count && tokens.array[i].getIndex() < static_cast<size_t>(end - first); ++i) {
					if(getFontForRenderingToken(tokens.array[i].getType(), tokens.array[i].getCookie()) != font) {
						nextFontChange = first + tokens.array[i].getIndex();
						break;
					}
				}
			}

			// ASCII 䕶
			if(p == nextCtrl) {
				if(*p == L'\t')	// ^u
					positions[p - first + 1] = getNextTabStop(offset, true/*!run.isRightToLeft()*/);
				else {	// ̑̐䕶
					char_t glyph[2];
					Lexer::getAsciiControlSubstitutionGlyph(static_cast<uchar>(*p), glyph);
					positions[p - first + 1] = positions[p - first] + dc.getTextExtent(glyph, 2).cx;
				}
				run.width_ += positions[p - first + 1] - positions[p - first];
				offset += positions[p - first + 1] - positions[p - first];
				nextCtrl = find_if(++p, end, isAsciiControl());
			}

			//  ASCII 䕶tHg̕ςڂ܂
			else {
				const length_t len = min(end, min(nextCtrl, nextFontChange)) - p;
				const bool dropLast = !lastRun && p + len == end;
				if(dropLast) {
					const int originalLastPos = positions[p - first + len];
					dc.getTextExtentExPoint(p, static_cast<int>(len), 0, 0, positions + (p - first) + 1, &size);
					positions[nextCtrl - first] = originalLastPos;
				} else
					dc.getTextExtentExPoint(p, static_cast<int>(len), 0, 0, positions + (p - first) + 1, &size);
				if(offset != 0) {
					const char_t* const e = dropLast ? p + len - 1 : p + len;
					for(const char_t* q = p; q < e; ++q)
						positions[q - first + 1] += offset;
				}
				p += len;
				run.width_ += size.cx;
				offset += size.cx;
			}
		}

		// RTL ł΃Lbgʒut]
		if(run.isRightToLeft()) {
			for(length_t i = (!lastRun ? end - 1 : end) - first; i > run.getIndex(); --i)
				positions[i] = (positions[run.getIndex()] + run.width_) - (positions[i] - positions[run.getIndex()]);
			positions[run.getIndex()] += run.width_;
		}
	}

	delete[] runOrders;
	if(layout.runs_->count_ == 1 && !layout.runs_->array_[0]->rtl_) {
		delete layout.runs_;
		layout.runs_ = 0;
	}
	layout.width_ = offset;
	dc.selectObject(oldFont);
	layout.parseStage_ = LineLayout::PARSE_STAGE_FULL;

	// ő\̌vZ
	if(longestLine_ == -1 || layout.width_ > lines_[longestLine_]->width_) {
		longestLine_ = line;
		FIRE_LAYOUT_EVENT(ChangedMaximumWidthLine);
	} else if(line == longestLine_) {
		updateLongestLine();	// [
		FIRE_LAYOUT_EVENT(ChangedMaximumWidthLine);
	}
}

/**
 *	s̐擪A̕sRg
 *	@param line _sԍ
 */
void LineLayoutManager::parseMultilineCommentContinue(length_t line) {
	assertValid();
	assert(line < lines_.getSize());

	LineLayout& layout = *lines_[line];

	if(!lexingEnabled_) {
		layout.multilineAnnotationFromPrev_ = layout.multilineAnnotationToNext_ = 0;
		layout.parseStage_ = LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS;
		return;
	}

	// O̍s̕sRgI󋵂g
	if(line == 0) {	// 擪s
		layout.multilineAnnotationFromPrev_ = Token::NULL_COOKIE;
		layout.parseStage_ = LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS;
	} else {
		// O̍s͂Ȃ΍ċAIɉ͂
		length_t i = line;
		// ܂͂łŏ̍s܂Ŗ߂
		for(; ; --i) {
			if(i == 0) {	// 擪s
				lines_[i]->multilineAnnotationFromPrev_ = Token::NULL_COOKIE;
				break;
			} else if(lines_[i - 1]->parseStage_ >= LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS) {	// ͍ς݂̍sɓ
				lines_[i]->multilineAnnotationFromPrev_ = lines_[i - 1]->multilineAnnotationToNext_;
				break;
			}
		}

		// ͂Ȑ擪s line ܂ł
		while(true) {
			lines_[i]->multilineAnnotationToNext_ =
				lexer_->parseMultilineAnnotation(document_.getLine(i), lines_[i]->multilineAnnotationFromPrev_);
			lines_[i]->parseStage_ = LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS;
			if(i == line)	// ŏɉ͂悤ƂĂsɖ߂Ă
				break;
			++i;
			lines_[i]->multilineAnnotationFromPrev_ = lines_[i - 1]->multilineAnnotationToNext_;
		}
	}
}

/**
 *	g[N؂os
 *	@param line _sԍ
 */
void LineLayoutManager::parseTokens(length_t line) {
	assertValid();
	assert(line < lines_.getSize());

	LineLayout& layout = *lines_[line];
	if(!lexingEnabled_) {
		layout.deleteTokenList();
		if(LineLayout::SIMPLE_TOKEN_LIST.count == 0) {
			const_cast<Tokens&>(LineLayout::SIMPLE_TOKEN_LIST).count = 1;
			const_cast<Tokens&>(LineLayout::SIMPLE_TOKEN_LIST).array = new Token(0, Token::UNSPECIFIED, Token::NULL_COOKIE);
		}
		layout.tokens_ = &LineLayout::SIMPLE_TOKEN_LIST;
		layout.parseStage_ = LineLayout::PARSE_STAGE_TOKENS;
		return;
	}

	// O̍s畡sRgĂ邩ǂĂȂ΂Ȃ
	if(line != 0 && (lines_[line - 1]->parseStage_ < LineLayout::PARSE_STAGE_MULTILINE_ANNOTATIONS))
		parseMultilineCommentContinue(line - 1);
	layout.multilineAnnotationFromPrev_ = (line != 0) ? lines_[line - 1]->multilineAnnotationToNext_ : Token::NULL_COOKIE;

	const string_t& s = document_.getLine(line);

	layout.deleteTokenList();
	if(s.empty()) {
		layout.tokens_ = &LineLayout::NULL_TOKEN_LIST;
		layout.multilineAnnotationToNext_ = layout.multilineAnnotationFromPrev_;
		layout.parseStage_ = LineLayout::PARSE_STAGE_TOKENS;
		return;
	}

	Tokens* tokens = new Tokens;
	list<Token> output;
	Token::Cookie cookie = layout.multilineAnnotationFromPrev_;
	lexer_->parse(s, cookie, output);
	tokens->count = output.size();
	tokens->array = new Token[output.size()];
	copy(output.begin(), output.end(), tokens->array);
	layout.tokens_ = tokens;
	layout.multilineAnnotationToNext_ = cookie;
	layout.parseStage_ = LineLayout::PARSE_STAGE_TOKENS;
}

/// [̕`ɕKvȕvZ
void LineLayoutManager::recalculateVerticalRulerWidth() {
	int newWidth = 0;	// V
	uint maxDigitsCount;

	if(settings_.lineNumberLayout.showLineNumbers) {
		PREPARE_DC(dc);
		HFONT oldFont = dc.selectObject(regularFont_);
		dc.getCharWidth(L'8', L'8', &newWidth);
		dc.selectObject(oldFont);
		maxDigitsCount = getLineNumberMaxDigit();
		newWidth *= (max<uint>(maxDigitsCount, settings_.lineNumberLayout.minimumDigits) + 2);	// Œጅmۂ
		if(settings_.lineNumberLayout.borderStyle != LineNumberLayout::LNBS_NONE)
			newWidth += settings_.lineNumberLayout.borderWidth;
	}
	if(settings_.lineNumberLayout.showIndicatorMargin)
		newWidth += settings_.lineNumberLayout.indicatorMarginWidth;
	if(newWidth != verticalRulerWidth_) {
		verticalRulerWidth_ = newWidth;
		FIRE_LAYOUT_EVENT(ChangedVerticalRulerWidth);
	}
}

/// 
void LineLayoutManager::reconstructAll() {
	assertValid();
	deleteAllLines();
	insertLines(0, document_.getLineCount() - 1);
	recalculateVerticalRulerWidth();
}

/// CxgXi̍폜
void LineLayoutManager::removeEventListener(IEventListener& eventListener) {
	assertValid();
	eventListeners_.erase(&eventListener);
}

/// ݒԂɖ߂
void LineLayoutManager::resetConfigurations() {
	assertValid();

	lexingEnabled_ = true;
	for(int type = 0; type < ETT_COUNT; ++type) {
		tokenFoundations_[type].enabled = true;
		if(type != Token::KEYWORD && type != Token::ANNOTATION)
			tokenFoundations_[type].body.foundation->set();
		else {
			for(CookedTokenMap::iterator it = tokenFoundations_[type].body.cookedFoundations->begin();
					it != tokenFoundations_[type].body.cookedFoundations->end(); ++it)
				it->second.set();
		}
	}
	setSettings(LayoutSettings());
}

/// @see Bookmarker::setBookmark
void LineLayoutManager::setBookmark(length_t line, bool mark /* = true */) {
	if(line >= lines_.getSize())
		throw out_of_range("Specified line is not found.");
	LineLayout& layout = *lines_[line];
	if(layout.isBookmarked() != mark) {
		layout.setBookmark(mark);
		for(set<IEventListener*>::iterator it = eventListeners_.begin(); it != eventListeners_.end(); ++it)
			(*it)->onChangedBookmark(line);
	}
}

/// @see LayoutSettings::setFont
void LineLayoutManager::setFont(const LOGFONTW& font) {
	LOGFONTW lf = font;
	TEXTMETRICW metric;

	::DeleteObject(regularFont_);
	::DeleteObject(boldFont_);
	::DeleteObject(italicFont_);
	::DeleteObject(boldItalicFont_);

	lf.lfItalic = lf.lfStrikeOut = lf.lfUnderline = false;
	lf.lfWeight = FW_NORMAL;
	regularFont_ = ::CreateFontIndirectW(&lf);
	lf.lfWeight = FW_BOLD;
	boldFont_ = ::CreateFontIndirectW(&lf);
	lf.lfItalic = true;
	boldItalicFont_ = ::CreateFontIndirectW(&lf);
	lf.lfWeight = FW_NORMAL;
	italicFont_ = ::CreateFontIndirectW(&lf);

	// tHg̕ۑ
	PREPARE_DC(dc);
	dc.selectObject(regularFont_);
	dc.getTextMetrics(metric);
	lineHeight_ = static_cast<ushort>(metric.tmHeight + 1) + settings_.lineSpan;
	charWidth_ = static_cast<ushort>(metric.tmAveCharWidth);

	// R[h֕\tHg̍XV
	const TextFoundation& foundation = *tokenFoundations_[Token::UNICODE_CONTROL].body.foundation;
	bidiFmtSubst_.update(metric.tmHeight, foundation.bold, foundation.italic);

	recalculateVerticalRulerWidth();
	invalidate(LineLayout::PARSE_STAGE_FULL);
	if(freezeCount_ == 0)
		FIRE_LAYOUT_EVENT(ChangedLayout);
}

/// CAEg̐ݒ
void LineLayoutManager::setSettings(const LayoutSettings& settings) {
	const bool alignmentChanged = settings.rightAlign != settings_.rightAlign;
	const bool directionChanged = settings.rightToLeftReading != settings_.rightToLeftReading;
	if(settings.tabWidth != settings_.tabWidth
			|| settings.charSpan != settings_.charSpan
			|| settings.closeBoldCharacters != settings_.closeBoldCharacters
			|| settings.performBidirection != settings_.performBidirection
			|| alignmentChanged || directionChanged) {
		settings_ = settings;
		invalidate(LineLayout::PARSE_STAGE_FULL);
	} else
		settings_ = settings;
	recalculateVerticalRulerWidth();
	if(alignmentChanged)	FIRE_LAYOUT_EVENT(ChangedTextAlignment);
	if(directionChanged)	FIRE_LAYOUT_EVENT(ChangedTextDirection);
	if(freezeCount_ == 0)	FIRE_LAYOUT_EVENT(ChangedLayout);
}

/**
 *	\̐ݒ
 *	@param type			g[N̎
 *	@param cookie		NbL[l
 *	@param foundation	ݒe
 *	@throw std::invalid_argument	@a type A@a cookie ̂ꂩȂ΃X[
 */
void LineLayoutManager::setTokenFoundation(int type, Token::Cookie cookie, const TextFoundation& foundation) {
	bool needRecalc = false;
	if(type < Token::FIRST || type >= ETT_COUNT)
		throw invalid_argument("Invalid token type.");
	else if(type != Token::KEYWORD && type != Token::ANNOTATION) {
		needRecalc =
			tokenFoundations_[type].body.foundation->bold != foundation.bold
			|| tokenFoundations_[type].body.foundation->italic != foundation.italic;
		*tokenFoundations_[type].body.foundation = foundation;
	} else {
		CookedTokenMap::iterator it = tokenFoundations_[type].body.cookedFoundations->find(cookie);
		if(it == tokenFoundations_[type].body.cookedFoundations->end())
			throw invalid_argument("Invalid cookie value.");
		needRecalc = it->second.bold != foundation.bold || it->second.italic != foundation.italic;
		it->second = foundation;
		if(type == Token::UNICODE_CONTROL) {
			// R[h֕\tHg̍XV
			const TextFoundation& foundation = *tokenFoundations_[Token::UNICODE_CONTROL].body.foundation;
			LOGFONTW font;

			::GetObject(bidiFmtSubst_.getFont(), sizeof(LOGFONTW), &font);
			bidiFmtSubst_.update(font.lfHeight, foundation.bold, foundation.italic);
		}
	}

	if(freezeCount_ == 0) {
		if(needRecalc)
			invalidate(LineLayout::PARSE_STAGE_FULL);
		FIRE_LAYOUT_EVENT(ChangedLayout);
	}
}

/// @see Bookmarker::toggleBookmark
void LineLayoutManager::toggleBookmark(length_t line) {
	if(line >= lines_.getSize())
		throw out_of_range("Specified line is not found.");
	lines_[line]->setBookmark(!lines_[line]->isBookmarked());
	for(set<IEventListener*>::iterator it = eventListeners_.begin(); it != eventListeners_.end(); ++it)
		(*it)->onChangedBookmark(line);
}

/// JEg1炷
void LineLayoutManager::unfreeze() {
	assertValid();
	if(freezeCount_ == 0)
		throw logic_error("Layout is not freezed.");
	if(--freezeCount_ == 0) {
		invalidate(LineLayout::PARSE_STAGE_FULL);
		FIRE_LAYOUT_EVENT(ChangedLayout);
	}
}

/// ő\sT
void LineLayoutManager::updateLongestLine() throw() {
	assertValid();

	int maxWidth = 0;
	const length_t lineCount = lines_.getSize();
	longestLine_ = -1;
	for(length_t line = 0; line < lineCount; ++line) {
		if(lines_[line]->width_ > maxWidth) {
			maxWidth = lines_[line]->width_;
			longestLine_ = line;
		}
	}
}


// LineLayoutManager::BidirectionalFormatterSubstitutionDriver class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
LineLayoutManager::BidirectionalFormatterSubstitutionDriver::BidirectionalFormatterSubstitutionDriver() : font_(0), getGlyphIndicesWPtr_(0) {
	if(gdi32Dll_ = ::LoadLibraryA("GDI32.DLL")) {
		getGlyphIndicesWPtr_ = reinterpret_cast<DWORD(WINAPI*)(
			HDC, const WCHAR*, int, LPWORD, DWORD)>(::GetProcAddress(gdi32Dll_, "GetGlyphIndicesW"));
		if(getGlyphIndicesWPtr_ == 0) {
			::FreeLibrary(gdi32Dll_);
			gdi32Dll_ = 0;
		}
	}
}

/// fXgN^
LineLayoutManager::BidirectionalFormatterSubstitutionDriver::~BidirectionalFormatterSubstitutionDriver() {
	::DeleteObject(font_);
	::FreeLibrary(gdi32Dll_);
}

/// VɊÂătHg쐬
void LineLayoutManager::BidirectionalFormatterSubstitutionDriver::update(int newHeight, bool bold, bool italic) {
	::DeleteObject(font_);
	font_ = ::CreateFontW(newHeight, 0, 0, 0,
		bold ? FW_BOLD : FW_REGULAR, italic, false, false,
		DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_CHARACTER_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, L"Arial");
	fill(glyphCache_, endof(glyphCache_), 0xFFFF);
}


// LineLayoutManager::BidrectionalLayoutCalculator class implementation
/////////////////////////////////////////////////////////////////////////////

#define BIDI_CALCULATOR_DEFAULT_POOL_SIZE 512

/// RXgN^
LineLayoutManager::BidirectionalLayoutCalculator::BidirectionalLayoutCalculator() throw()
		: gdi32Dll_(::LoadLibraryA("GDI32.DLL")), setLayoutPtr_(0), poolSize_(BIDI_CALCULATOR_DEFAULT_POOL_SIZE),
		classPool_(new char[BIDI_CALCULATOR_DEFAULT_POOL_SIZE]), orderPool_(new uint[BIDI_CALCULATOR_DEFAULT_POOL_SIZE]) {
	if(gdi32Dll_ != 0)
		setLayoutPtr_ = reinterpret_cast<DWORD(WINAPI*)(HDC, DWORD)>(::GetProcAddress(gdi32Dll_, "SetLayout"));
}

/// fXgN^
LineLayoutManager::BidirectionalLayoutCalculator::~BidirectionalLayoutCalculator() throw() {
	if(gdi32Dll_ != 0)
		::FreeLibrary(gdi32Dll_);
	delete[] classPool_;
	delete[] orderPool_;
}

/**
 *	ɕ
 *	@param dc			`foCXReLXg
 *	@param first, last	
 *	@param rtl			E獶ɓǂޏꍇ true
 *	@param runOrders	[out] ̓oꏇ
 *	@return				̔z
 */
auto_ptr<LineLayout::Runs> LineLayoutManager::BidirectionalLayoutCalculator::calculate(
		DC& dc, const char_t* first, const char_t* last, bool rtl, size_t*& runOrders) {
	assert(first != 0 && last != 0 && first <= last);

#define IS_GCPCLASS_RTL(c)	toBoolean(c == GCPCLASS_ARABIC || c == GCPCLASS_HEBREW)	// ۂ͓lȂ񂾂
#define SET_RTL(n)			(n) |= 0x80000000
#define IS_RTL(n)			toBoolean((n) & 0x80000000)
#define GET_INDEX(n)		(n & 0x7FFFFFFF)

	list<length_t> delimiters;	// e̐擪̈ʒu (ŏʃrbg͕: true  RTL)

	// NT 4.0 ȑO (Ƃ͌Ȃ) ͂ŏI
	if(!isRTLSupported()) {
		LineLayout::Run** runs = new LineLayout::Run*[1];
		runs[0] = new LineLayout::Run(0, false);
		runOrders = new size_t[1];
		runOrders[0] = 0;
		return auto_ptr<LineLayout::Runs>(new LineLayout::Runs(1, runs));
	}

	// v[̃TCY\?
	if(last - first + 1 > poolSize_) {
		delete[] classPool_;
		delete[] orderPool_;
		poolSize_ = last - first + 1;
		classPool_ = new char[poolSize_];
		orderPool_ = new uint[poolSize_];
	}

	AutoZeroLS<GCP_RESULTSW> gcpr;
	gcpr.lpClass = classPool_;
	gcpr.lpOrder = orderPool_;
	gcpr.nGlyphs = static_cast<int>(last - first);

	// ̏oƕ () 𓾂
	if(rtl)	(*setLayoutPtr_)(dc, true);
	dc.getCharacterPlacement(first, static_cast<int>(last - first),
		0, gcpr, GCP_DIACRITIC | GCP_DISPLAYZWG | GCP_GLYPHSHAPE | GCP_REORDER);
	if(rtl)	(*setLayoutPtr_)(dc, false);

	// \AĂȂʒuŕ = ̐
	delimiters.push_back(0);
	for(length_t i = 1; i < static_cast<length_t>(last - first); ++i) {
		if(Private::dif(gcpr.lpOrder[i], gcpr.lpOrder[i - 1]) > 1)
			delimiters.push_back(i);
	}

	// e̕߂
	for(list<length_t>::iterator it = delimiters.begin(); it != delimiters.end(); ++it) {
		const length_t nextRun = (++it != delimiters.end()) ? *it : last - first;

		--it;
		if(gcpr.lpOrder[*it] == gcpr.lpOrder[nextRun - 1]) {	// x[X1̏ꍇ GCP_RESULTSW::lpClass g
			if(IS_GCPCLASS_RTL(gcpr.lpClass[*it]))
				SET_RTL(*it);
		} else if(gcpr.lpOrder[nextRun - 1] - gcpr.lpOrder[*it] == 1) {	// x[X2̏ꍇ
			// "LEE..REE.." ̏ꍇ "REE..LEE.." ̏ꍇ 00..11.. ƂȂĂ̂
			// ̃͂2ɕȂ΂ȂȂȂ

			if(IS_GCPCLASS_RTL(gcpr.lpClass[*it]))
				SET_RTL(*it);

			length_t i = GET_INDEX(*it) + 1;
			for(; i < nextRun; ++i) {
				if(gcpr.lpOrder[i] != gcpr.lpOrder[i - 1])
					break;
			}
			assert(i != nextRun);
			if(IS_GCPCLASS_RTL(gcpr.lpClass[GET_INDEX(*it)]) != IS_GCPCLASS_RTL(gcpr.lpClass[i])) {
				// "LEE..REE.."  "REE..LEE" Ȃ̂2
				it = delimiters.insert(++it, i);
				if(IS_GCPCLASS_RTL(gcpr.lpClass[i]))
					SET_RTL(*it);
			}
		} else if(gcpr.lpOrder[GET_INDEX(*it)] > gcpr.lpOrder[nextRun - 1])	// P RTL
			SET_RTL(*it);
	}

	// ʂ𐶐
	LineLayout::Run** runs = new LineLayout::Run*[delimiters.size()];
	size_t run = 0;
	for(list<length_t>::const_iterator it = delimiters.begin(); it != delimiters.end(); ++it, ++run)
		runs[run] = new LineLayout::Run(GET_INDEX(*it), IS_RTL(*it));
	LineLayout::Runs* result = new LineLayout::Runs(delimiters.size(), runs);

	// e̓oꏇ𐶐
	if(result->getCount() != 1) {
		OrderComparer::OrderSet* array = new OrderComparer::OrderSet[result->getCount()];
		for(OrderComparer::Order i = 0; i < result->getCount(); ++i) {
			array[i].first = gcpr.lpOrder[result->getAt(i).getIndex()];
			array[i].second = i;
		}
		sort(array, array + result->getCount(), OrderComparer());
		runOrders = new size_t[result->getCount()];
		for(size_t i = 0; i < result->getCount(); ++i)
			runOrders[i] = array[i].second;
		delete[] array;
	} else {
		runOrders = new size_t[1];
		runOrders[0] = 0;
	}

	return auto_ptr<LineLayout::Runs>(result);

#undef IS_GCPCLASS_RTL
#undef SET_RTL
#undef IS_RTL
#undef GET_INDEX
}

#undef FIRE_LAYOUT_EVENT
#undef PREPARE_DC
#undef BIDI_CALCULATOR_DEFAULT_POOL_SIZE

/* [EOF] */