// LineLayout.h
// (c) 2003-2006 exeal

#ifndef LINE_LAYOUT_H_
#define LINE_LAYOUT_H_
#include "Lexer.h"
#include <memory>


namespace Manah {
	namespace Windows {
		namespace GDI {
			class DC;
			class ClientDC;
		}
	}
}

namespace Ascension {

	class EditView;

	/// \eLXg̎
	/// @see TokenType
	enum EmphaticTextType {
		ETT_NORMAL = Token::COUNT,	///< ʏ̃eLXg
		ETT_SELECTION,				///< Ï (F̂ݗL)
		ETT_INACTIVE_SELECTION,		///< ANeBuÏ (F̂ݗL)
		ETT_INDICATOR_MARGIN,		///< CWP[^}[W
		ETT_LINENUMBER,				///< sԍ
		ETT_EMPHATIC_LINENUMBER,	///< sԍ
		ETT_MATCH_BRACKETS,			///< ʂ̈v
		ETT_END_OF_LINE,			///< s
		ETT_END_OF_FILE,			///< t@C̏I[
		ETT_LINK,					///< N (AĝݗL)
		ETT_MATCHTEXT,				///< veLXg
		ETT_RESTRICTION,			///< i[CÕANZXs\ȗ̈
		ETT_COUNT
	};

	/// gAC̎
	enum BorderType {
		BT_NONE,					///< 
		BT_UNDERLINE_SOLID,			///< ̉
		BT_UNDERLINE_BOLD,			///< ̉
		BT_UNDERLINE_DASHED,		///< j̉
		BT_UNDERLINE_BOLDDASHED,	///< j̉
		BT_UNDERLINE_DOTTED,		///< _̉
		BT_UNDERLINE_BOLDDOTTED,	///< _̉
		BT_UNDERLINE_WAVED,			///< g̉
		BT_BORDER_SOLID,			///< ̘g
		BT_BORDER_DASHED,			///< j̘g
		BT_BORDER_DOTTED,			///< _̘g
	};

	/// ܂Ԃ[h
	enum WrapMode {
		WPM_NONE,		///< ܂ԂȂ
		WPM_SPECIFIED,	///< w蕝Ő܂Ԃ
		WPM_WINDOW		///< EBhEŐ܂Ԃ
	};

	/// ̐FAȂ
	struct TextFoundation {
		COLORREF	fgColor;		///< OiF (-1 ɂƃeLXg̎ނɉăVXe肩I)
		COLORREF	bgColor;		///< wiF (-1 ɂƃeLXg̎ނɉăVXe肩I)
		COLORREF	borderColor;	///< g̐F (-1 ɂ fgColor Ɠ)
		bool		italic;			///< Α
		bool		bold;			///< 
		BorderType	border;			///< g

		/// RXgN^
		TextFoundation() {set(-1, -1);}
		/// 
		void set(COLORREF fgColor_ = -1, COLORREF bgColor_ = -1, COLORREF borderColor_ = -1,
				bool bItalic = false, bool bBold = false, BorderType borderType = BT_NONE) throw() {
			fgColor = fgColor_;
			bgColor = bgColor_;
			borderColor = borderColor_;
			italic = bItalic;
			bold = bBold;
			border = borderType;
		}
	};

	/// sԍ̕\`
	struct LineNumberLayout {
		enum BorderStyle {LNBS_NONE, LNBS_SOLID, LNBS_DASHED, LNBS_DASHED_ROUNDED, LNBS_DOTTED};
		bool		leftAlign;				///< 񂹂̏ꍇ trueBE񂹂̏ꍇ false
		bool		showLineNumbers;		///< sԍ\
		uchar		minimumDigits;			///< sԍ̍ŏ
		length_t	startLine;				///< sԍ̊Jnl
		bool		showIndicatorMargin;	///< CWP[^}[W\
		ushort		indicatorMarginWidth;	///< CWP[^}[W̕
		ushort		borderWidth;			///< ؂̑
		BorderStyle	borderStyle;			///< ؂̃X^C

		/// RXgN^
		LineNumberLayout() throw() : leftAlign(false), showLineNumbers(false), minimumDigits(4),
			startLine(1), showIndicatorMargin(false), indicatorMarginWidth(15), borderWidth(1), borderStyle(LNBS_SOLID) {}
	};

	/// CAEg̐ݒ
	struct LayoutSettings {
		length_t	tabWidth;	///< ^u (pP)B4
		ushort		lineSpan;	///< s̊Ԋu
		ushort		charSpan;	///< ̊Ԋu
		ushort		leadMargin;	///< O] (LTR ̏ꍇ͍]ARTL ̏ꍇ͉E])
		ushort		topMargin;	///< ]
		COLORREF	caretLineColor;			///< ݍsɕ\鉺̐F
		COLORREF	inactiveCaretLineColor;	///< ANeBuɌݍsɕ\鉺̐F
		LineNumberLayout	lineNumberLayout;	///< sԍ̕\@
		length_t	startChar;			///< ԍ̊Jnl (1)
		bool	closeBoldCharacters;	///< l߂ĕ\B̓It
		bool	performBidirection;		///< ʒuvZőoeLXglB true
		bool	rightAlign;				///< E񂹁B͍
		bool	rightToLeftReading;		///< E獶ɓǂށB͍E
		WrapMode	wrapMode;			///< ݂̐܂Ԃ[h (WrapMode `Q)
		length_t	wrapWidth;			///< w蕝Ő܂ԂƂ1s̕\ (ϕ*)
		struct {
			char_t		horizontalTab;		///< ^u (U+0009)B '^'
			char_t		generalWhiteSpace;	///< ʓIȋ󔒗ޕ (U+1680: Ogham Space Mark ȊO)B '_'
			char_t		ideographicSpace;	///< Sp (U+3000)B U+25A1
			char_t		unixEOL;			///< LF s (U+000A)B U+FFFFBU+FFFF Ƒgݍ݂̉Ot
			char_t		macintoshEOL;		///< CR s (U+000D)B U+FFFFBU+FFFF Ƒgݍ݂̍Ot
			char_t		windowsEOL;			///< CRLF s (<U+000D U+000A>)B U+FFFFBU+FFFF Ƒgݍ݂̉pOt
			char_t		ebcdicEOL;			///< NEL s (U+0085)B U+23CE
			char_t		lineSeparator;		///< LS s (U+2028)B U+21A9
			char_t		paragraphSeparator;	///< PS s (U+2029)B U+21E9
			string_t	endOfFile;			///< t@CI[B "[EOF]"
		} substitutionGlyphs;	///< ꕶ̑֕\ɎgOt

		/// RXgN^
		LayoutSettings() : tabWidth(4), lineSpan(0), charSpan(0),
				leadMargin(5), topMargin(1), caretLineColor(-1), inactiveCaretLineColor(-1), startChar(1),
				closeBoldCharacters(false), performBidirection(true), rightAlign(false), rightToLeftReading(false),
				wrapMode(WPM_NONE), wrapWidth(80) {
			substitutionGlyphs.horizontalTab = L'^';
			substitutionGlyphs.generalWhiteSpace = L'_';
			substitutionGlyphs.ideographicSpace = L'\x25A1';
			substitutionGlyphs.unixEOL =
			substitutionGlyphs.macintoshEOL = 
			substitutionGlyphs.windowsEOL = 0xFFFF;
			substitutionGlyphs.ebcdicEOL = L'\x23CE';
			substitutionGlyphs.lineSeparator = L'\x21A9';
			substitutionGlyphs.paragraphSeparator = L'\x21E9';
			substitutionGlyphs.endOfFile = L"[EOF]";
		}
	};


	/// ubN}[N̊Ǘ
	class Bookmarker {
	public:
		/// fXgN^
		virtual ~Bookmarker() {}
		/// ubN}[NSč폜
		virtual void clearAllBookmarks() = 0;
		/**
		 *	ws̎̃ubN}[Ns̍sԍԂ
		 *	@param line	̍s̎ȍ~̃ubN}[NsԂB񋓊Jnɂ -1 w肷
		 *	@return		̃ubN}[NsB@a line Ō̃ubN}[Nsł -1 Ԃ
		 *	@throw std::invalid_argument	@a line ubN}[NsłȂ΃X[
		 *	@throw std::out_of_range		@a line hLg͈̔͂OĂ΃X[
		 */
		virtual length_t getNextBookmark(length_t line) const = 0;
		/// wsubN}[NĂ邩Ԃ
		/// @throw std::out_of_range @a line sȂƂX[
		virtual bool isBookmarked(length_t line) const = 0;
		/// wsɃubN}[Nݒ肷
		/// @throw std::out_of_range @a line sȂƂX[
		virtual void setBookmark(length_t line, bool mark = true) = 0;
		/// ws̃ubN}[ÑgO
		/// @throw std::out_of_range @a line sȂƂX[
		virtual void toggleBookmark(length_t line) = 0;
	};


	/**
	 *	@brief es̃CAEgۑ
	 *
	 *	LineLayoutManager::getLine() 擾łA_s̃CAEgێB
	 *	O̍sƂ̊Ԃ̕sRǧpAg[ÑXgAẽLbgʒuA
	 *	ubN}[NsA܂Ԃɕ`悷̂ɕKvȕȂǂƂĎB
	 *
	 *	eȏ LineLayoutManager NXsB
	 *	s͂̏󋵂 ParseStage 񋓂Ɏ4iKB
	 *	̒iKɕĂ̂͌̂߂łB EditView
	 *	ANZXƂɂ͈ʒu܂ŊSɉ͍ς݂ł邱Ƃۏ؂B
	 *	NCAg̉͒iKlKv̂ LineLayoutManager::notifyAll
	 *	\bhĂяoƂłBႦ΃r[̃tHgωƂA
	 *	SẲ͂蒼Kv͖B̏ꍇALineLayout::PARSE_STAGE_FULL
	 *	w肵ă\bhĂяoΈʒu񂾂𖳌ɂ邱Ƃł
	 */
	class LineLayout : public Manah::SelfAssertable, public Manah::UseMemoryPool<LineLayout> {
		// J^
	public:
		/// ͒iK
		enum ParseStage {
			PARSE_STAGE_UNPARSED				= 0,	///< S͂ĂȂ
			PARSE_STAGE_MULTILINE_ANNOTATIONS	= 1,	///< O̍sւ̕sߌp܂ŉ͍ς
			PARSE_STAGE_TOKENS					= 2,	///< g[N܂ŉ͍ς
			PARSE_STAGE_FULL					= 3		///< ʒuƌꏇ܂ (܂Ԃ܂ <- ) ͍ς
		};

		/// 
		class Run : public Manah::UseMemoryPool<Run> {
		public:
			enum {LINE_WIDTH = 0xFFFFFFFF};
			/// RXgN^
			Run(length_t index, bool rtl) throw() : index_(index), width_(0x7FFFFFFF), rtl_(rtl) {}
			/// 擪ʒuԂ
			length_t getIndex() const throw() {return index_;}
			/// `敝Ԃ (LINE_WIDTH Ԃꂽꍇ͍sŜ̒ɓ)
			int getWidth() const throw() {return (width_ != 0x7FFFFFFF) ? width_ : LINE_WIDTH;}
			/// E獶̏ꍇ true AȄꍇ true Ԃ
			bool isRightToLeft() const throw() {return rtl_;}
		private:
			length_t	index_ : 32;	// TODO: 64rbgł͂̃R[hł͑ʖ
			ulong		width_ : 31;
			bool		rtl_ : 1;
			friend class LineLayoutManager;
		};

		/// ̔z
		class Runs {
		public:
			/// RXgN^
			Runs(std::size_t count, Run*const* array) throw() : count_(count), array_(array) {assert(count != 0 && array != 0);}
			/// fXgN^
			~Runs() {for(std::size_t i = 0; i < count_; ++i) delete array_[i]; delete[] array_;}
			/// wʒũԂ
			const Run& getAt(std::size_t i) const throw() {assert(i < count_); return *(array_[i]);}
			/// ̑Ԃ
			std::size_t getCount() const throw() {return count_;}
		private:
			std::size_t	count_;
			Run*const*	array_;
			friend class LineLayoutManager;
		};

		/// ܂Ԃʒu̔z
		struct WrapOffsets {
			std::size_t	count;	///< 
			length_t*	array;	///< z
			WrapOffsets() : count(0), array(0) {}
			~WrapOffsets() {delete[] array;}
		};


		// RXgN^
	private:
		/// RXgN^
		LineLayout::LineLayout() : parseStage_(PARSE_STAGE_UNPARSED), tokens_(0), 
				multilineAnnotationFromPrev_(Token::NULL_COOKIE), multilineAnnotationToNext_(Token::NULL_COOKIE),
				caretPositions_(0), runs_(0), wrapOffsets_(0), width_(0), bookmarked_(false) {}
		/// fXgN^
		LineLayout::~LineLayout() {
			deleteTokenList();
			delete[] caretPositions_;
			delete runs_;
			delete wrapOffsets_;
		}

		// \bh
	public:
		void				backParseStage(ParseStage stage);
		int					getCaretPosition(length_t index) const throw();
		Token::Cookie		getMultilineAnnotationStatus(bool toNextLine) const throw();
		const Runs&			getRuns() const;
		const Tokens&		getTokens() const throw();
		int					getWidth() const throw();
		const WrapOffsets*	getWrapPoints() const throw();
		bool				isBookmarked() const throw();
		void				setBookmark(bool mark = true) throw();
	private:
		void	deleteTokenList();

		// f[^o
	private:
		ParseStage		parseStage_;	// s̉͒iK
		const Tokens*	tokens_;		// g[ÑXg
		Token::Cookie	multilineAnnotationFromPrev_;	// O̕s߂IĂȂ΂̎
		Token::Cookie	multilineAnnotationToNext_;		// s߂̍sɑĂ΂̎
		const int*		caretPositions_;	// e̍[̈ʒu
		const Runs*		runs_;				// ̃Xg (1łꂪ LTR ̏ꍇ null)
		WrapOffsets*	wrapOffsets_;		// ܂Ԃʒu (܂ԂȂꍇ null)
		int				width_;				// ܂Ԃɕ`悷̂ɕKvȕ̕ (܂ԂȂꍇ̂ݗL)
		bool			bookmarked_;		// ubN}[Ns

		static const Tokens			NULL_TOKEN_LIST;
		static const Tokens			SIMPLE_TOKEN_LIST;
		static std::auto_ptr<Runs>	simpleRuns_;

		friend class LineLayoutManager;
		friend struct Manah::GapBuffer_DeletePointer<LineLayout*>;	// delete ł悤ɂ邽
	};


	/// LineLayoutManager ̃NCAgC^[tFCX
	class LayoutSetter : public Manah::SelfAssertable {
	public:
		/**
		 *	@brief ͂L/ɂ
		 *
		 *	͂𖳌ɂ邱ƂŊes̃g[NɊւ񂪍A
		 *	͂ɂ鎞ԂƏ啝ɉPł
		 *	@see LineLayoutManaher::isLexicalParsingEnabled
		 */
		virtual void enableLexicalParsing(bool enable) = 0;
		/// g[N̗L/
		/// @throw std::invalid_argument @a type sȂƂX[
		virtual void enableToken(int type, bool enable = true) = 0;
		/// CAEg̍XV𓀌
		virtual void freeze() = 0;
		/// ݎgpĂtHg (C^bNłȂ) 1`悷Ƃ̕ϕԂ
		virtual uint getAverageCharacterWidth() const = 0;
		/// CAEgݒԂ
		virtual const LayoutSettings& getSettings() const = 0;
		/// \̐ݒԂ
		/// @throw std::invalid_argument @a type sȂƂX[
		virtual TextFoundation getTokenFoundation(int type, Token::Cookie cookie) const = 0;
		/// [̕Ԃ
		virtual ushort getVerticalRulerWidth() const = 0;
		/// ͂L
		virtual bool isLexicalParsingEnabled() const = 0;
		/// g[N̋LԂ
		/// @throw std::invalid_argument @a type sȂƂX[
		virtual bool isTokenEnabled(int type) const = 0;
		/// ݒSď
		virtual void resetConfigurations() = 0;
		/// tHg̐ݒ
		virtual void setFont(const LOGFONTW& font) = 0;
		/// CAEg̐ݒ
		virtual void setSettings(const LayoutSettings& settings) = 0;
		/// \̐ݒ
		/// @throw std::invalid_argument @a type  @a cookie sȂƂX[
		virtual void setTokenFoundation(int type, Token::Cookie cookie, const TextFoundation& foundation) = 0;
		/// CAEgXV̓
		/// @throw std::logic_error ĂȂꍇX[
		virtual void unfreeze() = 0;
	};


	/**
	 *	@brief sCAEg̊Ǘ
	 *
	 *	EditView NX̃CAEgsPʂŊǗAEditView NXł
	 *	s̍폜A}AXV󂯂āACAEgXVĂB
	 *
	 *	̂߂ɂ̃NX̃\bh͕Kvȏ̑sȂB
	 *	Ⴆ΂sɕsRgJn񂪑}ꂽꍇAEditView
	 *	NX͂̍s̃CAEgXV邽߂ modifyLine
	 *	ĂяoA̍sւ̉e͖ (C̕Kvȍs͕Ԃ)B
	 *	êsXV邩ǂf̂ EditView NX̎dł
	 */
	class LineLayoutManager : public Manah::Noncopyable, virtual public LayoutSetter,
			virtual public Bookmarker, virtual public Lexer::IEventListener {
	public:
		/// CAEg}l[W̃CxgXi
		class IEventListener {
		public:
			/// fXgN^
			virtual ~IEventListener() {}
			/// ubN}[N̐ݒ/sꂽ
			virtual void onChangedBookmark(length_t line) = 0;
			/// CAEgύXꂽ
			virtual void onChangedLayout() = 0;
			/// ő啝s̍sɕύXꂽ
			virtual void onChangedMaximumWidthLine() = 0;
			/// eLXg̑ʒuύXꂽ
			virtual void onChangedTextAlignment() = 0;
			/// eLXg̕ύXꂽ
			virtual void onChangedTextDirection() = 0;
			/// [̕ύXꂽ
			virtual void onChangedVerticalRulerWidth() = 0;
			/// ubN}[NSč폜ꂽ
			virtual void onClearedAllBookmarks() = 0;
			/// foCXReLXgKvƂȂ (̃\bh1̃CxgXiɑ΂Ă̂݌Ăяo)
			virtual Manah::Windows::GDI::ClientDC onQueryDeviceContext() = 0;
		};

		/// R[h|Cg̑փOt񋟂
		class BidirectionalFormatterSubstitutionDriver {
		private:
			BidirectionalFormatterSubstitutionDriver();
			~BidirectionalFormatterSubstitutionDriver();
		public:
			HFONT	getFont() const throw();
			ushort	getGlyphIndex(HDC dc, char_t ch) const;
		private:
			void	update(int newHeight, bool bold, bool italic);
		private:
			enum Code {
				LRM, RLM, LRE, RLE, PDF, LRO, RLO,
				ISS, ASS, IAFS, AAFS, NADS, NODS, CODE_COUNT
			};
			HFONT	font_;
			ushort	glyphCache_[CODE_COUNT];
			HMODULE	gdi32Dll_;
			DWORD(WINAPI * getGlyphIndicesWPtr_)(HDC, const WCHAR*, int, LPWORD, DWORD);
			friend class LineLayoutManager;
		};

		// RXgN^
	public:
		LineLayoutManager(EditDoc& document);
		virtual ~LineLayoutManager();

		// \bh (BLayoutSetter C^[tFCX܂)
	public:
		void					addEventListener(IEventListener& eventListener);
		void					enableLexicalParsing(bool enable);
		void					enableToken(int type, bool enable = true);
		void					freeze() throw();
		uint					getAverageCharacterWidth() const throw();
		const BidirectionalFormatterSubstitutionDriver&
								getFontForBidirectionalFormatterSubstitution() const throw();
		HFONT					getFontForRenderingToken(int type, Token::Cookie cookie) const;
		Lexer&					getLexer() const throw();
		LineLayout&				getLine(length_t line) const;
		ushort					getLineHeight() const throw();
		LineLayout::ParseStage	getLineParseStage(length_t line) const;
		int						getLongestLineWidth() const throw();
		ulong					getNextTabStop(ulong x, bool toRight) const throw();
		HFONT					getRegularFont() const;
		const LayoutSettings&	getSettings() const {return settings_;}
		TextFoundation			getTokenFoundation(int type, Token::Cookie cookie) const;
		ushort					getVerticalRulerWidth() const throw();
		bool					isLexicalParsingEnabled() const throw();
		bool					isTokenEnabled(int type) const;
		static bool				isRTLSupported() throw();
		void					removeEventListener(IEventListener& eventListener);
		void					setFont(const LOGFONTW& font);
		void					setSettings(const LayoutSettings& settings);
		void					setTokenFoundation(int type, Token::Cookie cookie, const TextFoundation& foundation);
		void					unfreeze();
		void					updateSystemColors() throw();
		// \bh ()
	public:
		void		deleteAllLines();
		void		deleteLines(length_t start, length_t end);
		void		insertLines(length_t start, length_t end);
		void		invalidate(LineLayout::ParseStage stage);
		length_t	modifyLine(length_t line);
		void		parseLine(length_t line);
		void		reconstructAll();
		void		resetConfigurations();

	protected:
	//	static BidiClass	getBidiClass(ulong cp);
		void				parseCharacterPositions(length_t line);
		void				parseMultilineCommentContinue(length_t line);
		void				parseTokens(length_t line);
		void				updateLongestLine() throw();

		// Lexer::IEventListener \bh
	public:
		void	onLexerAddedIdentifiedToken(Token::Type type, Token::Cookie cookie);
		void	onLexerChanged();
		void	onLexerCleared();
		void	onLexerRemovedIdentifiedToken(Token::Type type, Token::Cookie cookie);

		// Bookmarker \bh
	public:
		void		clearAllBookmarks();
		length_t	getNextBookmark(length_t line) const;
		bool		isBookmarked(length_t line) const;
		void		setBookmark(length_t line, bool mark = true);
		void		toggleBookmark(length_t line);

	private:
		uint	getLineNumberMaxDigit() const;
		void	recalculateVerticalRulerWidth();

		// f[^o
	private:
/*		/// oeLXg
		enum BidiClass {
			BC_L, BC_LRE, BC_LRO, BC_R, BC_AL, BC_RLE, BC_RLO,
			BC_PDF, BC_EN, BC_ES, BC_ET, BC_AN, BC_CS, BC_NSM,
			BC_BN, BC_B, BC_S, BC_WS, BC_ON,
		};*/

		class SystemColors {
		public:
			SystemColors() {update();}
			COLORREF getColor(int entry) const throw() {assert(entry < COUNT); return colors_[entry];}
			void update() throw() {for(int i = 0; i < COUNT; ++i) colors_[i] = ::GetSysColor(i);}
		private:
			enum {COUNT = COLOR_MENUBAR + 1};
			COLORREF colors_[COUNT];
		} systemColors_;

		static class BidirectionalLayoutCalculator {
		public:
			BidirectionalLayoutCalculator() throw();
			~BidirectionalLayoutCalculator() throw();
			std::auto_ptr<LineLayout::Runs> calculate(Manah::Windows::GDI::DC& dc,
				const char_t* first, const char_t* last, bool rtl, std::size_t*& runOrders);
			bool isRTLSupported() const throw();
		private:
			HMODULE	gdi32Dll_;
			DWORD(WINAPI *setLayoutPtr_)(HDC, DWORD);
			std::ptrdiff_t poolSize_;
			char* classPool_;
			uint* orderPool_;
#ifndef LAYOUT_RTL
			enum {LAYOUT_RTL = 1};
#endif /* !LAYOUT_RTL */
			struct OrderComparer {
				typedef uint	GcpOrder;
				typedef ulong	Order;
				typedef std::pair<GcpOrder, Order>	OrderSet;
				bool operator()(const OrderSet& lhs, const OrderSet& rhs) {return lhs.first < rhs.first;}
			};
		} bidiCalculator_;

		typedef Manah::GapBuffer<LineLayout*, Manah::GapBuffer_DeletePointer<LineLayout*> > Lines;

		EditDoc&				document_;			// hLg
		std::auto_ptr<Lexer>	lexer_;				// ͊
		Lines					lines_;				// es̃CAEg
		LayoutSettings			settings_;			// X̐ݒ
		bool					lexingEnabled_;		// ͂ƕs߂L
		ulong					freezeCount_;		// JEg
		length_t				longestLine_;		// 1Ԓs (-1 ƕs)
		std::set<LineLayoutManager::IEventListener*>	eventListeners_;	// CxgXi

		HFONT	regularFont_;		// ̖WtHgBvZɂgp
		HFONT	boldFont_;			// `ɎgptHg
		HFONT	italicFont_;		// C^bN̕`ɎgptHg
		HFONT	boldItalicFont_;	// C^bN̕`ɎgptHg

		ushort	lineHeight_;			// s̍ (̍͂ꂩ settings_.lineSpan l)
		ushort	charWidth_;				// p () 
		ushort	verticalRulerWidth_;	// [̕

		typedef std::map<Token::Cookie, TextFoundation> CookedTokenMap;
		struct {
			bool enabled;	// L
			union {
				CookedTokenMap*	cookedFoundations;	// L[[hARg͂gB
													// NbL[lŊeg[NɃANZX
				TextFoundation*	foundation;			// ȊȌꍇ͒AC
			} body;
		} tokenFoundations_[ETT_COUNT];	// g[N\̐ݒ

		BidirectionalFormatterSubstitutionDriver bidiFmtSubst_;
	};


	/**
	 *	w肵ʒũ̕LbgʒuԂ (̃\bh͋E`FbNȂ)
	 *	@param index	ʒu
	 *	@return			Lbgʒu
	 */
	inline int LineLayout::getCaretPosition(length_t index) const throw() {
		assertValid();
		assert(caretPositions_ != 0);
		return caretPositions_[index];
	}

	/**
	 *	s߂̌pԂԂ
	 *	@param toNextLine	̂ւ̌p󋵂擾ꍇ trueB
	 *						O̍šp󋵂擾ꍇ false
	 *	@return				p
	 */
	inline Token::Cookie LineLayout::getMultilineAnnotationStatus(bool toNextLine) const throw() {
		return toNextLine ? multilineAnnotationToNext_ : multilineAnnotationFromPrev_;}

	/// g[ÑXgԂ
	inline const Tokens& LineLayout::getTokens() const throw() {return *tokens_;}

	/// ܂ԂȂꍇ̍s̒Ԃ
	inline int LineLayout::getWidth() const throw() {return width_;}

	/// ܂Ԃʒu̔zԂB܂ԂȂꍇ null Ԃ
	inline const LineLayout::WrapOffsets* LineLayout::getWrapPoints() const throw() {return wrapOffsets_;}

	/// ubN}[NsԂ
	inline bool	LineLayout::isBookmarked() const throw() {return bookmarked_;}

	/// ubN}[N̐ݒ
	inline void LineLayout::setBookmark(bool mark /* = true */) throw() {bookmarked_ = mark;}

	/// @see LayoutSettings::enabledToken
	inline void LineLayoutManager::enableToken(int type, bool enable /* = true */) {
		if(type < Token::FIRST || type >= ETT_COUNT)
			throw std::invalid_argument("Invalid token type.");
		else if(enable == tokenFoundations_[type].enabled)
			return;
		tokenFoundations_[type].enabled = enable;
		onLexerChanged();
	}

	/// JEg1₷
	inline void LineLayoutManager::freeze() throw() {assertValid(); ++freezeCount_;}

	/// ݎgpĂtHg (C^bNłȂ) 1`悷Ƃ̕ϕԂ
	inline uint LineLayoutManager::getAverageCharacterWidth() const throw() {assertValid(); return charWidth_ + settings_.charSpan;}

	/// R[h̑փOto͂hCoԂ
	inline const LineLayoutManager::BidirectionalFormatterSubstitutionDriver&
	LineLayoutManager::getFontForBidirectionalFormatterSubstitution() const throw() {return bidiFmtSubst_;}

	/**
	 *	w肵g[N`tHgԂ
	 *	@param type		g[N̎
	 *	@param cookie	g[ÑNbL[l
	 *	@return			tHg
	 */
	inline HFONT LineLayoutManager::getFontForRenderingToken(int type, Token::Cookie cookie) const {
		assertValid();
		const TextFoundation& tf = getTokenFoundation(type, cookie);
		if(isTokenEnabled(type) && tf.bold)
			return tf.italic ? boldItalicFont_ : boldFont_;
		else
			return (isTokenEnabled(type) && tf.italic) ? italicFont_ : regularFont_;
	}

	/// ͊Ԃ
	inline Lexer& LineLayoutManager::getLexer() const throw() {assertValid(); return *lexer_;}

	/**
	 *	w肵s̃CAEgԂ
	 *	@param line					s
	 *	@return						CAEg
	 *	@throw std::out_of_range	@a line sȂƂX[
	 */
	inline LineLayout& LineLayoutManager::getLine(length_t line) const {
		assertValid();
		if(line >= lines_.getSize())
			throw std::out_of_range("Specified line is not found.");
		LineLayout& layout = *lines_[line];
		if(layout.parseStage_ != LineLayout::PARSE_STAGE_FULL)	// łĂȂ
			const_cast<LineLayoutManager*>(this)->parseCharacterPositions(line);
		assert(layout.parseStage_ == LineLayout::PARSE_STAGE_FULL);
		return layout;
	}

	/// 1s̍Ԃ
	inline ushort LineLayoutManager::getLineHeight() const throw() {assertValid(); return lineHeight_;}

	/**
	 *	ws̉͂ǂ̒xIĂ邩Ԃ
	 *	@param line		_s
	 *	@return			̓x
	 *	@throw std::out_of_range	@a line sȂƂX[
	 */
	inline LineLayout::ParseStage LineLayoutManager::getLineParseStage(length_t line) const {
		assertValid();
		if(line >= lines_.getSize())
			throw std::out_of_range("Specified line is not found.");
		return lines_[line]->parseStage_;
	}

	/// łs̒Ԃ (͂̍s͌₩O)
	inline int LineLayoutManager::getLongestLineWidth() const throw() {
		assertValid(); return (longestLine_ != -1) ? lines_[longestLine_]->getWidth() : 0;}

	/**
	 *	̃^uʒuԂ
	 *	@param x		s̍[̈ʒu
	 *	@param toRight	Ẽ^uʒuvZꍇ trueB̃^uʒȕꍇ false
	 *	@return			^uʒu
	 */
	inline ulong LineLayoutManager::getNextTabStop(ulong x, bool toRight) const throw() {
		if(toRight)
			return x + settings_.tabWidth * getAverageCharacterWidth()
				- x % (settings_.tabWidth * getAverageCharacterWidth());
		else
			return x - x % (settings_.tabWidth * getAverageCharacterWidth());
	}

	/// ʏ̃eLXg̕`ɎgtHgԂ
	inline HFONT LineLayoutManager::getRegularFont() const {assertValid(); return getFontForRenderingToken(ETT_NORMAL, Token::NULL_COOKIE);}

	/// [̕Ԃ
	inline ushort LineLayoutManager::getVerticalRulerWidth() const throw() {assertValid(); return verticalRulerWidth_;}

	/// @see LayoutSettings::isLexicalParsingEnabled
	inline bool LineLayoutManager::isLexicalParsingEnabled() const throw() {assertValid(); return lexingEnabled_;}

	/// RTL CAEgT|[gĂ邩Ԃ
	inline bool LineLayoutManager::isRTLSupported() throw() {return bidiCalculator_.isRTLSupported();}

	/// @see CLayoutSettings::IsTokenEnabled
	inline bool LineLayoutManager::isTokenEnabled(int type) const {
		assertValid();
		if(type < Token::FIRST || type >= ETT_COUNT)
			throw std::invalid_argument("Invalid token type.");
		return tokenFoundations_[type].enabled;
	}

	/// VXeJ[̃LbVXV
	inline void LineLayoutManager::updateSystemColors() throw() {assertValid(); systemColors_.update();}

	/// tHgnhԂ
	inline HFONT LineLayoutManager::BidirectionalFormatterSubstitutionDriver::getFont() const throw() {return font_;}

	/**
	 *	̃OtԍԂ
	 *	@param dc	foCXReLXg
	 *	@param ch	
	 *	@return		OtԍBꍇ 0xFFFF
	 */
	inline ushort LineLayoutManager::BidirectionalFormatterSubstitutionDriver::getGlyphIndex(HDC dc, char_t ch) const {
		static const char_t	codeMap[] = {
			0x200E, 0x200F, 0x202A, 0x202B, 0x202C, 0x202D, 0x202E,
			0x206A, 0x206B, 0x206C, 0x206D, 0x206E, 0x206F
		};
#ifndef GGI_MARK_NONEXISTING_GLYPHS
		static const DWORD	GGI_MARK_NONEXISTING_GLYPHS = 0x0001;
#endif /* !GGI_MARK_NONEXISTING_GLYPHS */

		assert(font_ != 0);
		const char_t* const	p = std::lower_bound(codeMap, endof(codeMap), ch);
		if(*p != ch)
			return 0xFFFF;
		const Code code = static_cast<Code>(p - codeMap);
		if(glyphCache_[code] == 0xFFFF) {
			HFONT oldFont = static_cast<HFONT>(::SelectObject(dc, font_));
			if(getGlyphIndicesWPtr_ != 0)
				(*getGlyphIndicesWPtr_)(dc, &ch, 1, &const_cast<ushort*>(glyphCache_)[code], GGI_MARK_NONEXISTING_GLYPHS);
			else {
				AutoZeroLS<GCP_RESULTSW> gcpr;
				WCHAR glyph;
				gcpr.lpGlyphs = &glyph;
				gcpr.nGlyphs = 1;
				::GetCharacterPlacementW(dc, &ch, 1, 0, &gcpr, GCP_DISPLAYZWG);
				const_cast<ushort*>(glyphCache_)[code] = (glyph != 0) ? glyph : 0xFFFF;
			}
			::SelectObject(dc, oldFont);
		}
		return glyphCache_[code];
	}

	/// RTL T|[g邩Ԃ
	inline bool LineLayoutManager::BidirectionalLayoutCalculator::isRTLSupported() const throw() {return setLayoutPtr_ != 0;}

} // namespace Ascension

#endif /* LINE_LAYOUT_H_ */

/* [EOF] */