// StandardCommands.cpp
// (c) 2003-2006 exeal

/**
 *	@file StandardCommands.cpp
 *	Ascension::StandardCommands ̃R}hNX̎
 */

#include "StdAfx.h"
#include "EditView.h"
#include "EditPoint.h"
#include "../../Manah/Utility.hpp"
#include "../../Manah/WaitCursor.hpp"
using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Ascension::StandardCommands;
using namespace Manah;
using namespace Manah::Windows;
using namespace std;


#define ASSERT_IFISWINDOW()	assert(getTarget().isWindow())
#define ABORT_ISEARCH()										\
	if(getTarget().getIncrementalSearcher().isRunning())	\
		getTarget().getIncrementalSearcher().abort()
#define END_ISEARCH()										\
	if(getTarget().getIncrementalSearcher().isRunning())	\
		getTarget().getIncrementalSearcher().end()
#define CHECK_DOCUMENT_READONLY(retval)			\
	if(getTarget().getDocument().isReadOnly())	\
		return retval
#define CHECK_GUI_EDITABILITY(retval)		\
	if(!getTarget().checkGUIEditability())	\
		return retval
#define CLOSE_COMPLETION_WINDOW()	getTarget().closeCompletionWindow()
#define ABORT_MODES()			\
	CLOSE_COMPLETION_WINDOW();	\
	ABORT_ISEARCH()


/// ͕⊮EBhEԂ
inline CompletionWindow& EditorCommand::getCompletionWindow() const {
	return *view_->completionWindow_;
}

/**
 *	ubN}[NSĉBANeBu|CĝsɃubN}[Nݒ/
 *	@return	0
 */
ulong BookmarkCommand::execute() {
	ABORT_MODES();
	if(type_ == CLEAR_ALL)
		getTarget().getBookmarker().clearAllBookmarks();
	else if(type_ == TOGGLE_CURRENT_LINE)
		getTarget().getBookmarker().toggleBookmark(getTarget().getSelection().getActivePoint().getLineNumber());
	else
		assert(false);
	return 0;
}

/**
 *	IBCN^𖾎Iɒ~
 *	@return	0
 */
ulong CancelCommand::execute() {
	ASSERT_IFISWINDOW();
	ABORT_MODES();
	else if(!getTarget().getSelection().isEmpty())	// I
		getTarget().getSelection().moveTo(getTarget().getSelection().getActivePoint(), true);
	return 0;
}

/**
 *	LbgړBIg
 *	@retval 1	ނ MATCH_BRACKET ANEXT_BOOKMARK APREVIOUS_BOOKMARK ̂ꂩŁAړ悪Ȃꍇ
 *	@retval 0	ȊO
 */
ulong CaretMovementCommand::execute() {
	END_ISEARCH();

	if(getCompletionWindow().isWindowVisible()) {
		switch(type_) {
		case NEXT_LINE:		getCompletionWindow().sendMessage(WM_KEYDOWN, VK_DOWN);		return 0;
		case PREVIOUS_LINE:	getCompletionWindow().sendMessage(WM_KEYDOWN, VK_UP);		return 0;
		case NEXT_PAGE:		getCompletionWindow().sendMessage(WM_KEYDOWN, VK_NEXT);		return 0;
		case PREVIOUS_PAGE:	getCompletionWindow().sendMessage(WM_KEYDOWN, VK_PRIOR);	return 0;
		}
	}

	Selection& selection = getTarget().getSelection();

	if(!selection.isEmpty() && !extend_) {	// I邾
		if(type_ == NEXT_CHARACTER
				|| (type_ == RIGHT_CHARACTER && !getTarget().isTextDirectionRightToLeft())
				|| (type_ == LEFT_CHARACTER && getTarget().isTextDirectionRightToLeft())) {
			selection.moveTo(selection.getEndPoint(), true);
			return 0;
		} else if(type_ == PREVIOUS_CHARACTER
				|| (type_ == LEFT_CHARACTER && !getTarget().isTextDirectionRightToLeft())
				|| (type_ == RIGHT_CHARACTER && getTarget().isTextDirectionRightToLeft())) {
			selection.moveTo(selection.getStartPoint(), true);
			return 0;
		}
	}

	if(type_ == MATCH_BRACKET) {
		const EditPoint&	activePoint = selection.getActivePoint();
		CharPos				foundPos;

		if(getTarget().findMatchBracket(activePoint, foundPos, false)) {
			if(!extend_)
				selection.moveTo(foundPos, true);
			else if(foundPos > activePoint)
				selection.select(activePoint, CharPos(foundPos.line_, foundPos.char_ + 1), selection.isRectangle(), true);
			else
				selection.select(CharPos(activePoint.getLineNumber(),
					activePoint.getCharNumber() + 1), foundPos, selection.isRectangle(), true);
		} else if(!activePoint.isStartOfLine()
				&& getTarget().findMatchBracket(
					CharPos(activePoint.getLineNumber(), activePoint.getCharNumber() - 1), foundPos, false)) {
			if(!extend_)
				selection.moveTo(foundPos, true);
			else if(foundPos > CharPos(activePoint.getLineNumber(), activePoint.getCharNumber() - 1))
				selection.select(CharPos(activePoint.getLineNumber(), activePoint.getCharNumber() - 1),
					CharPos(foundPos.line_, foundPos.char_ + 1), selection.isRectangle(), true);
			else
				selection.select(activePoint, foundPos, selection.isRectangle(), true);
		} else {
			getTarget().beep();	// Ȃ
			return 1;
		}
	} else {
		Caret& caret = selection.getActivePoint();

		if(!extend_)
			caret.synchronizeAnchor();
		switch(type_) {
		case NEXT_CHARACTER:			caret.charNext(offset_);	break;
		case PREVIOUS_CHARACTER:		caret.charPrev(offset_);	break;
		case LEFT_CHARACTER:			caret.charLeft(offset_);	break;
		case RIGHT_CHARACTER:			caret.charRight(offset_);	break;
		case NEXT_WORD:					caret.wordNext(offset_);		break;
		case PREVIOUS_WORD:				caret.wordPrev(offset_);		break;
		case LEFT_WORD:					caret.wordLeft(offset_);		break;
		case RIGHT_WORD:				caret.wordRight(offset_);		break;
		case NEXT_WORDEND:				caret.wordEndNext(offset_);		break;
		case PREVIOUS_WORDEND:			caret.wordEndPrev(offset_);		break;
		case LEFT_WORDEND:				caret.wordEndLeft(offset_);		break;
		case RIGHT_WORDEND:				caret.wordEndRight(offset_);	break;
		case NEXT_LINE:					caret.lineDown(offset_);	break;
		case PREVIOUS_LINE:				caret.lineUp(offset_);		break;
		case NEXT_PAGE:					getTarget().sendMessage(WM_VSCROLL, SB_PAGEDOWN); caret.pageDown(offset_);	break;
		case PREVIOUS_PAGE:				getTarget().sendMessage(WM_VSCROLL, SB_PAGEUP); caret.pageUp(offset_);		break;
		case START_OF_LINE:				caret.moveToStartOfLine();	break;
		case END_OF_LINE:				caret.moveToEndOfLine();	break;
		case FIRST_CHAR_OF_LINE:		caret.moveToFirstCharOfLine();	break;
		case LAST_CHAR_OF_LINE:			caret.moveToLastCharOfLine();	break;
		case START_OR_FIRST_OF_LINE:	caret.isFirstCharOfLine() ? caret.moveToStartOfLine() : caret.moveToFirstCharOfLine();	break;
		case END_OR_LAST_OF_LINE:		caret.isLastCharOfLine() ? caret.moveToEndOfLine() : caret.moveToLastCharOfLine();		break;
		case START_OF_DOCUMENT:			caret.moveToStartOfDocument();	break;
		case END_OF_DOCUMENT:			caret.moveToEndOfDocument();	break;
		case NEXT_BOOKMARK:				return caret.moveToNextBookmark() ? 0 : 1;
		case PREVIOUS_BOOKMARK:			return caret.moveToPrevBookmark() ? 0 : 1;
		}
		caret.reveal(getTarget());
	}
	return 0;
}

/**
 *	Lbgʒu̕R[h|CgɁA邢̓R[h|Cg\𑊓镶ɕϊ
 *	@retval 0	ϊɐꍇ
 *	@retval 1	ϊɎsꍇ
 */
ulong CharacterCodePointConversionCommand::execute() {
	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);
	ABORT_MODES();

	EditView&			view = getTarget();
	const EditDoc&		document = view.getDocument();
	const EditPoint&	bottom = view.getSelection().getEndPoint();

	if(bottom.isStartOfLine()
			|| (document.isNarrowed() && bottom.getPosition() == document.getStartPoint())) {	// sȊOłȂ΂Ȃ
		view.beep();
		return 1;
	}

	Selection&			selection = view.getSelection();
	const char_t* const	line = document.getLine(bottom.getLineNumber()).data();
	CodePoint			cp;

	if(param_) {	//  -> R[h|Cg
		char_t buffer[7];

		if(bottom.getCharNumber() > 1
				&& UTF16Surrogates::isHighSurrogate(line[bottom.getCharNumber() - 2])
				&& UTF16Surrogates::isLowSurrogate(line[bottom.getCharNumber() - 1]))
			cp = UTF16Surrogates::decode(line + bottom.getCharNumber() - 2, 2);
		else
			cp = line[bottom.getCharNumber() - 1];
		swprintf(buffer, L"%lX", cp);
		view.freeze();
		selection.select(CharPos(bottom.getLineNumber(), bottom.getCharNumber() - ((cp > 0xFFFF) ? 2 : 1)), bottom, false, true);
		selection.replace(buffer, buffer + wcslen(buffer), false);
		view.unfreeze();
	} else {	// R[h|Cg -> 
		const length_t	column = bottom.getCharNumber();
		length_t		i = column - 1;
		char_t			buffer[7];

		if(toBoolean(iswxdigit(line[column - 1]))) {
			while(i != 0) {
				if(column - i == 7) {
					view.beep();
					return 1;
				} else if(!toBoolean(iswxdigit(line[i - 1])))
					break;
				--i;
			}
			wcsncpy(buffer, line + i, column - i);
			buffer[column - i] = 0;
			cp = wcstoul(buffer, 0, 16);
			if(cp < 0x110000) {
				buffer[1] = buffer[2] = 0;
				UTF16Surrogates::encode(cp, buffer);
				view.freeze();
				selection.select(CharPos(bottom.getLineNumber(), i), bottom, false, true);
				selection.replace(buffer, buffer + (cp < 0x10000 ? 1 : 2), false);
				view.unfreeze();
				return 0;
			}
		}
		view.beep();
		return 1;
	}
	return 0;
}

/**
 *	1͂BCN^̖͌ɕǉ
 *	@retval 1	CN^łȂA͂Ɏsꍇ
 *	@retval 0	ȊȌꍇ
 *	@see		EditView::inputCharacter, EditView::onChar, EditView::onUniChar
 */
ulong CharacterInputCommand::execute() {
	// CN^ -> ɒǉ
	if(getTarget().getIncrementalSearcher().isRunning()) {
		CLOSE_COMPLETION_WINDOW();
		if(param_ == 0x0009 || !toBoolean(iswcntrl(static_cast<wint_t>(param_))))
			getTarget().getIncrementalSearcher().addCharacter(param_);
		return 0;
	} else
		return getTarget().inputCharacter(param_) ? 1 : 0;
}

/**
 *	O/̍s̓ʒu͂̕
 *	@return	͂ɐꍇ0Asꍇ1
 */
ulong CharacterInputFromNextLineCommand::execute() {
	ABORT_ISEARCH();
	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);

	// issue: ̎̓i[CO𖳎Ă...

	const EditPoint&	caret = getTarget().getSelection().getActivePoint();
	const bool&			fromPrevious = !param_;	// Oɂ...

	if((caret.getLineNumber() == 0 && fromPrevious)
			|| (caret.getLineNumber() == getTarget().getDocument().getLineCount() - 1 && !fromPrevious)) {
		getTarget().beep();
		return 1;
	}

	// ҏW_ĈʒuvZ
	auto_ptr<VisualPoint> p(getTarget().getDocument().createEditPoint());
	p->moveTo(caret);
	if(fromPrevious)	p->lineUp();
	else				p->lineDown();

	const length_t	column = p->getCharNumber();
	const string_t&	line = getTarget().getDocument().getLine(caret.getLineNumber() + (fromPrevious ? -1 : 1));

	if(column >= line.length()) {
		getTarget().beep();
		return 1;
	}
	return CharacterInputCommand(getTarget(), UTF16Surrogates::decode(line.data() + column, line.length() - column)).execute();
}

/**
 *	Nbv{[h֘Ȃ
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong ClipboardCommand::execute() {
	if(type_ == CUT || type_ == PASTE) {
		ASSERT_IFISWINDOW();
		CHECK_DOCUMENT_READONLY(1);
		CHECK_GUI_EDITABILITY(1);
		CLOSE_COMPLETION_WINDOW();
		if(type_ == CUT)
			ABORT_ISEARCH();
	}
	if(type_ == COPY)
		getTarget().getSelection().copy(performClipboardRing_);
	else if(type_ == CUT)
		getTarget().getSelection().cut(performClipboardRing_);
	else if(type_ == PASTE)
		getTarget().getSelection().paste(performClipboardRing_);
	return 0;
}

/**
 *	O1AO1PAsŚACN^̌̍폜
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong DeletionCommand::execute() {
	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);
	if(type_ != NEXT_CHARACTER && type_ != PREVIOUS_CHARACTER)
		ABORT_ISEARCH();
	if(getCompletionWindow().isWindowVisible() && type_ != PREVIOUS_CHARACTER)
		CLOSE_COMPLETION_WINDOW();

	EditView&				view = getTarget();
	EditDoc&				document = view.getDocument();
	Selection&				selection = view.getSelection();
	IncrementalSearcher&	isearch = view.getIncrementalSearcher();

	if(isearch.isRunning()) {
		if(type_ == NEXT_CHARACTER)
			isearch.reset();
		else if(type_ == PREVIOUS_CHARACTER) {
			if(!isearch.canUndo())
				getTarget().beep();
			else
				isearch.undo();
		}
	} else if(type_ == NEXT_WORD || type_ == PREVIOUS_WORD) {
		const CharPos onePoint = (type_ == NEXT_WORD) ? selection.getStartPoint() : selection.getEndPoint();
		const CharPos anotherPoint =
			view.getBoundaryDetector().searchWordBoundary(
				(type_ == NEXT_WORD) ? selection.getEndPoint() : selection.getStartPoint(),
				type_ == NEXT_WORD, BoundaryDetector::START);
		if(anotherPoint != onePoint) {
			view.freeze();
			document.beginEditCollection();
			selection.moveTo(document.deleteText(onePoint, anotherPoint), true);
			document.endEditCollection();
			view.unfreeze();
		}
	} else if(!selection.isEmpty()) {	// I폜
		view.freeze();
		document.beginEditCollection();
		selection.erase();
		document.endEditCollection();
		view.unfreeze();
	} else if(type_ == NEXT_CHARACTER) {
		document.endEditCollection();
		selection.getActivePoint().synchronizeAnchor().erase(1);
	} else if(type_ == PREVIOUS_CHARACTER) {
		document.endEditCollection();
		selection.getActivePoint().synchronizeAnchor().erase(-1);
	} else if(type_ == WHOLE_LINE) {
		const length_t line = selection.getActivePoint().getLineNumber();

		document.endEditCollection();
		if(line != document.getLineCount() - 1)	// ŏIsłȂꍇ
			selection.getActivePoint().synchronizeAnchor().lineDown();
		document.deleteText(CharPos(line, 0), CharPos(line, -1));
	} else
		assert(false);
	return 0;
}

/**
 *	ɈvsSăubN}[NB邢͑SĒu
 *	@return	ubN}[NsA邢͒u񐔂Ԃ
 */
ulong FindAllCommand::execute() {
	ABORT_MODES();
    if(onlySelection_ && getTarget().getSelection().isEmpty())
		return 0;

	WaitCursor				wc;
	EditView&				view = getTarget();
	EditDoc&				document = view.getDocument();
	const DocumentSearcher	searcher(document, view.getTextSearcher(), view.getBoundaryDetector());

	ulong		count = 0;	// }[N񐔁Au
	TextRange	matched;	// }b`ʒu
	TextRange	scope(		// ͈
		onlySelection_ ? max<CharPos>(view.getSelection().getStartPoint(), document.getStartPoint()) : document.getStartPoint(),
		onlySelection_ ? min<CharPos>(view.getSelection().getEndPoint(), document.getEndPoint()) : document.getEndPoint());

	if(type_ == BOOKMARK) {
		while(lastResult_ = searcher.search(scope, true, matched)) {
			view.getBookmarker().setBookmark(matched.pos1_.line_);
			scope.pos1_.line_ = matched.pos1_.line_ + 1;
			scope.pos1_.char_ = 0;
			++count;
		}
	} else if(type_ == REPLACE) {
		view.freeze();
		document.beginEditCollection();

		auto_ptr<VisualPoint> anchorPointClone(document.createEditPoint());
		anchorPointClone->synchronizeWithDocumentUpdate(true);
		anchorPointClone->moveTo(view.getSelection().getAnchorPoint());
		auto_ptr<VisualPoint> activePointClone(document.createEditPoint());
		activePointClone->synchronizeWithDocumentUpdate(true);
		activePointClone->moveTo(view.getSelection().getActivePoint());

		string_t replacedString;
		while(lastResult_ = searcher.search(scope, true, matched)) {
			searcher.replace(matched, replacedString);
			document.deleteText(matched);
			scope.pos1_ = document.insertText(matched.getTop(), replacedString);
			++count;
		}
		document.endEditCollection();
		if(count != 0)
			view.getSelection().select(*anchorPointClone, *activePointClone, view.getSelection().isRectangle(), true);
		view.unfreeze();
	}
	return count;
}

/**
 *	Ɉv镔IB邢͑IuŒuĂ猟
 *	@return	vȂꍇR}h̎sɎsꍇ1AȊȌꍇ0
 */
ulong FindNextCommand::execute() {
	if(replace_) {
		CHECK_DOCUMENT_READONLY(1);
		CHECK_GUI_EDITABILITY(1);
	}
	END_ISEARCH();
	CLOSE_COMPLETION_WINDOW();

	WaitCursor				wc;
	EditView&				view = getTarget();
	Selection&				selection = view.getSelection();
	const DocumentSearcher	searcher(view.getDocument(), view.getTextSearcher(), view.getBoundaryDetector());

	// u
	if(replace_) {
		string_t replacedString;
		if(lastResult_ = searcher.replace(selection.getRange(), replacedString)) {
			if(forward_)
				selection.replace(replacedString);
			else {
				const length_t orgStartChar = selection.getStartPoint().getCharNumber();
				selection.replace(replacedString);
				selection.moveTo(CharPos(selection.getActivePoint().getLineNumber(), orgStartChar), true);
			}
#ifndef ASCENSION_NO_REGEX
		} else if(lastResult_.isFatalError()) {	// K\G[ -> ss\
			view.highlightMatchTexts(false);
			return 1;
#endif /* !ASCENSION_NO_REGEX */
		} else
			selection.moveTo(selection.getEndPoint(), true);
	}

	// 
	const TextRange scope(
		forward_ ? max<CharPos>(selection.getEndPoint(), view.getDocument().getStartPoint()) : view.getDocument().getStartPoint(),
		forward_ ? view.getDocument().getEndPoint() : min<CharPos>(selection.getStartPoint(), view.getDocument().getEndPoint()));
	TextRange matched;

	if(lastResult_ = searcher.search(scope, forward_, matched)) {	//  -> IԂɂ
		selection.select(matched, false, true);
		view.highlightMatchTexts();
		return 0;
	} else {	// Ȃ
		view.highlightMatchTexts(false);
		return 1;
	}
}

/**
 *	CN^JnB̃}b`ʒuփWv
 *	@return	0
 */
ulong IncrementalSearchCommand::execute() {
	CLOSE_COMPLETION_WINDOW();
	IncrementalSearcher& isearch = getTarget().getIncrementalSearcher();

	if(!isearch.isRunning())	// Jn
		isearch.start(getTarget(), type_, forward_, eventListener_);
	else {	// ̈vʒuփWv (̂ݗLBtype_ ͖)
		lastResult_ = isearch.jumpToNextMatch(forward_);
		if(!lastResult_)
			getTarget().beep();
	}
	return 0;
}

/**
 *	Cfg
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong IndentationCommand::execute() {
	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);
	END_ISEARCH();
	CLOSE_COMPLETION_WINDOW();

	EditView&	view = getTarget();
	Selection&	selection = view.getSelection();
	CharPos		anchorResult;

	view.setNextCharacterVariation(NCV_NONE);
	view.getDocument().beginEditCollection();
	view.freeze();
	if(tabIndent_)
		anchorResult = selection.getActivePoint().tabIndent(
			selection.getAnchorPoint(), selection.isRectangle(), level_ * (indent_ ? 1 : -1));
	else
		anchorResult = selection.getActivePoint().spaceIndent(
			selection.getAnchorPoint(), selection.isRectangle(), level_ * (indent_ ? 1 : -1));
	view.getDocument().endEditCollection();
	selection.select(anchorResult, selection.getActivePoint(), selection.isRectangle(), true);
	view.unfreeze();

	return 0;
}

/**
 *	IME A㏑A\tgL[{[h̊e[h̃gO
 *	@return	0
 */
ulong InputStatusToggleCommand::execute() {
	if(type_ == IME_STATUS) {
		assert(getTarget().isWindow());
		HIMC imc = ::ImmGetContext(getTarget());
		::ImmSetOpenStatus(imc, !toBoolean(::ImmGetOpenStatus(imc)));
		::ImmReleaseContext(getTarget(), imc);
	} else if(type_ == OVERTYPE_MODE) {
		getTarget().setOvertypeMode(!getTarget().isOvertypeMode());
		CLOSE_COMPLETION_WINDOW();
	} else if(type_ == SOFT_KEYBOARD) {
		assert(getTarget().isWindow());
		HIMC imc = ::ImmGetContext(getTarget());
		DWORD conversionMode, sentenceMode;
		::ImmGetConversionStatus(imc, &conversionMode, &sentenceMode);
		conversionMode = toBoolean(conversionMode & IME_CMODE_SOFTKBD) ?
			(conversionMode & ~IME_CMODE_SOFTKBD) : (conversionMode | IME_CMODE_SOFTKBD);
		::ImmSetConversionStatus(imc, conversionMode, sentenceMode);
		::ImmReleaseContext(getTarget(), imc);
	} else
		assert(false);
	return 0;
}

/**
 *	@brief	sBO̍ssB[hI
 *
 *	Zk`WJ\ȂƂ͓WJB
 *	CN^͌IB
 *	͕⊮͊m肷 (SɈv₪ꍇ͓͕⊮𒆎~ĉs)
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong LineBreakCommand::execute() {
	EditView&			view = getTarget();
	CompletionWindow&	completionWindow = getCompletionWindow();

	if(view.getIncrementalSearcher().isRunning()) {
		view.getIncrementalSearcher().end();
		return 0;
	} else if(completionWindow.isRunning()) {
		if(completionWindow.getCurSel() != LB_ERR) {	// SɈv₪Ε⊮
			completionWindow.complete();
			return 0;
		}
		completionWindow.abort();
	}

	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);

	Selection& selection = view.getSelection();

	if(param_) {
		if(selection.getStartPoint().getLineNumber() != 0)
			selection.moveTo(CharPos(selection.getStartPoint().getLineNumber() - 1, -1), false);
		else
			selection.moveTo(CharPos(0, 0), false);
	}

	view.freeze();
	view.getDocument().beginEditCollection();
	if(selection.isEmpty()) {
		view.expandPrecedingWordAsAbbreviation();
		view.getDocument().endEditCollection();
		selection.getActivePoint().synchronizeAnchor().newLine();
	} else {
		selection.erase();
		selection.getActivePoint().synchronizeAnchor().newLine();
	}
	selection.moveTo(selection.getAnchorPoint(), true);
	view.unfreeze();
	return 0;
}

/**
 *	ɓ͂镶ω
 *	@return	0
 */
ulong NextInputVariationCommand::execute() {
	if(!getTarget().getDocument().isReadOnly())
		getTarget().setNextCharacterVariation(param_);
	return 0;
}

/**
 *	⊮EBhEJ
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong OpenCompletionWindowCommand::execute() {
	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);
	ABORT_ISEARCH();
	getTarget().openCompletionWindow();
	return 0;
}

/**
 *	݂̑Iɑ΂ IME ĕϊsBIꍇ`Ȉꍇ͖
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong ReconversionCommand::execute() {
	END_ISEARCH();
	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);

	EditView&		view = getTarget();
	const string_t	selection = view.getSelection().getText();
	HIMC			imc = ::ImmGetContext(view);

	if(!toBoolean(::ImmGetOpenStatus(imc)))	// I ON ɂȂƖꍇ
		::ImmSetOpenStatus(imc, true);
	::ImmSetCompositionStringW(imc, SCS_SETSTR,
		const_cast<char_t*>(selection.data()), static_cast<DWORD>(sizeof(char_t) * selection.length()), 0, 0);
	// ϊ񂪒߂Đ؂l߂ĂȂ
	if(::ImmGetCompositionStringW(imc, GCS_COMPSTR, 0, 0) / sizeof(WCHAR) == selection.length())
		::ImmNotifyIME(imc, NI_OPENCANDIDATE, 0, 0);
	else
		view.beep();
	::ImmReleaseContext(view, imc);

	CLOSE_COMPLETION_WINDOW();
	return 0;
}

/**
 *	`IJnBIɂꍇ݂͌̑Ig
 *	@return	0
 */
ulong RowSelectionExtensionCommand::execute() {
	CLOSE_COMPLETION_WINDOW();
	END_ISEARCH();

	Selection& selection = getTarget().getSelection();
	static const int	commandMap[] = {
		NEXT_CHARACTER, CaretMovementCommand::NEXT_CHARACTER,
		PREVIOUS_CHARACTER, CaretMovementCommand::PREVIOUS_CHARACTER,
		LEFT_CHARACTER, CaretMovementCommand::LEFT_CHARACTER,
		RIGHT_CHARACTER, CaretMovementCommand::RIGHT_CHARACTER,
		NEXT_WORD, CaretMovementCommand::NEXT_WORD,
		PREVIOUS_WORD, CaretMovementCommand::PREVIOUS_WORD,
		LEFT_WORD, CaretMovementCommand::LEFT_WORD,
		RIGHT_WORD, CaretMovementCommand::RIGHT_WORD,
		NEXT_WORDEND, CaretMovementCommand::NEXT_WORDEND,
		PREVIOUS_WORDEND, CaretMovementCommand::PREVIOUS_WORDEND,
		LEFT_WORDEND, CaretMovementCommand::LEFT_WORDEND,
		RIGHT_WORDEND, CaretMovementCommand::RIGHT_WORDEND,
		NEXT_LINE, CaretMovementCommand::NEXT_LINE,
		PREVIOUS_LINE, CaretMovementCommand::PREVIOUS_LINE,
		START_OF_LINE, CaretMovementCommand::START_OF_LINE,
		END_OF_LINE, CaretMovementCommand::END_OF_LINE,
		FIRST_CHAR_OF_LINE, CaretMovementCommand::FIRST_CHAR_OF_LINE,
		LAST_CHAR_OF_LINE, CaretMovementCommand::LAST_CHAR_OF_LINE,
		START_OR_FIRST_OF_LINE, CaretMovementCommand::START_OR_FIRST_OF_LINE,
		END_OR_LAST_OF_LINE, CaretMovementCommand::END_OR_LAST_OF_LINE
	};

	if(selection.isEmpty() && !selection.isRectangle())
		selection.select(selection.getAnchorPoint(), selection.getActivePoint(), true, false);
	assert(type_ >= 0 && type_ < countof(commandMap));
	for(int i = 0; i < countof(commandMap); i += 2) {
		if(commandMap[i] == type_) {
			CaretMovementCommand(getTarget(), static_cast<CaretMovementCommand::Type>(commandMap[i + 1]), true).execute();
			break;
		}
	}
	return 0;
}

/**
 *	hLgSI/Lbgʒu̒PI
 *	@return	0
 */
ulong SelectionCreationCommand::execute() {
	END_ISEARCH();

	if(type_ == ALL)
		getTarget().getSelection().select(
			getTarget().getDocument().getStartPoint(),
			getTarget().getDocument().getEndPoint(), false, true);
	else if(type_ == CURRENT_WORD) {
		Selection&				selection = getTarget().getSelection();
		const EditPoint&		caret = selection.getAnchorPoint();
		const DocumentBoundaryDetector	boundary(getTarget().getLexer(), getTarget().getDocument());
		if(caret.isEndOfLine()) {
			if(caret.isStartOfLine())	// 0s
				selection.moveTo(caret, true);
			else	// s
				selection.select(boundary.searchWordBoundary(caret, false, BoundaryDetector::AROUND), caret, false, true);
		} else if(caret.isStartOfLine())	// s
			selection.select(caret, boundary.searchWordBoundary(caret, true, BoundaryDetector::AROUND), false, true);
		else
			selection.select(boundary.searchWordBoundary(
				CharPos(caret.getLineNumber(), caret.getCharNumber() + 1), false, BoundaryDetector::AROUND),
				boundary.searchWordBoundary(caret, true, BoundaryDetector::AROUND), false, true);
	} else
		assert(false);
	return 0;
}

/**
 *	^uƋ󔒂̕ϊ ()
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong TabifyCommand::execute() {
	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);
	ABORT_MODES();
	// TODO: 
	return 1;
}

/**
 *	LbgʒuɃeLXg͂BCN^̖͌ɕǉ
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong TextInputCommand::execute() {
	EditView& view = getTarget();

	// CN^ -> ɒǉ
	if(view.getIncrementalSearcher().isRunning()) {
		view.getIncrementalSearcher().addString(param_);
		return 0;
	}

	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);
	return view.insertText(param_, false) ? 1 : 0;
}

/**
 *	LbgO̕APAsAւ
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong TranspositionCommand::execute() {
	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);
	END_ISEARCH();
	CLOSE_COMPLETION_WINDOW();

	EditView&	view = getTarget();
	Selection&	selection = view.getSelection();

	view.setNextCharacterVariation(NCV_NONE);
	view.freeze();
	view.getDocument().beginEditCollection();

	VisualPoint&	caret = selection.getActivePoint();
	bool			succeeded;
	switch(type_) {
	case CHARACTERS:	succeeded = caret.transposeChars();			break;
	case WORDS:			succeeded = caret.transposeWords();			break;
	case LINES:			succeeded = caret.transposeLines();			break;
//	case SENTENCES:		succeeded = caret.transposeSentences();		break;
//	case PARAGRAPHS:	succeeded = caret.transposeParagraphs();	break;
	}
	selection.moveTo(selection.getActivePoint(), true);
	if(!succeeded)
		view.beep();
	view.getDocument().endEditCollection();
	view.unfreeze();

	return succeeded ? 0 : 1;
}

/**
 *	ɖ߂/蒼
 *	@retval 0	R}h̎s
 *	@retval 1	R}h̎ss
 */
ulong UndoCommand::execute() {
	CHECK_DOCUMENT_READONLY(1);
	CHECK_GUI_EDITABILITY(1);

	if(getTarget().getDocument().getUndoHistoryLength(!param_) == 0)
		return 1;

	WaitCursor wc;
	if(param_)	getTarget().getDocument().undo();
	else		getTarget().getDocument().redo();
	return 0;
}

#undef ASSERT_IFISWINDOW
#undef ABORT_ISEARCH
#undef END_ISEARCH
#undef CHECK_DOCUMENT_READONLY
#undef CHECK_GUI_EDITABILITY
#undef CLOSE_COMPLETION_WINDOW

/* [EOF] */