// TextSearcher.cpp
// (c) 2004-2006 exeal

/**
 *	@file TextSearcher.cpp
 *	eLXgIuWFNg̎
 *
 *	Ascension ł͐K\̎ Boost.Regex (http://www.boost.org/libs/regex/)A
 *	{꒼ڌ̎ C/Migemo (http://www.kaoriya.net/#CMigemo) gpB
 *	̊OCupӂłȂꍇ Config.h ŕKvȃV{ (@c ASCENSION_NO_*) `
 *
 *	<h3>K\ (Boost.Regex)</h3>
 *
 *	_ł͐K\CuƂ
 *	Boost.Regex gĂ邪Ap郉Cu͕ω\BA
 *	wb_ (TextSearcher.h) ɂ̓Cuւ̎QƂ͖AAscension ̃NCAgɂ
 *	Boost.Regex gĂ邱Ƃ͕ȂBBoost.Regex 瓊ꂽOS
 *	Ascension ŏăNCAgɂ͓]Ȃ
 *	(x҂߂ɗOł͂ȂG[R[h (SearchError) Ԃ)
 *
 *	<h3>{꒼ڌ (C/Migemo)</h3>
 *
 *	{꒼ڌ͐K\p\łȂΗpłȂ
 *
 *	<h3>płȂꍇ̃NCAg̑Ή</h3>
 *
 *	K\ɂĂ @c ASCENSION_NO_REGEX A{꒼ڌɂĂ @c ASCENSION_NO_MIGEMO
 *	`邱ƂŁAOCuւ̎QƂACupӂłȂꍇł
 *	Ascension rh邱ƂłBNCAǧ@\pł邩𒲂ׂɂ
 *	TextSearcher NX̐ÓI\bh TextSearcher::isRegexAvailable ATextSearcher::isMigemoAvailable
 *	gƂ悢B̌ʂ͈xm肷΃vZX̏I܂œlԂB
 *	AC/Migemo ɂĂ͎s DLL ǂݍނ߁ARpCɂ͗p\ǂłȂ
 *
 *	płȂꍇɌsƂ @c assert Ɏs邽߁A
 *	Ăяo͕Kȏ̃\bhgČ^Cvp\ׂȂ΂ȂȂ
 *	(O𓊂݌vł͂Ȃ)
 *
 *	<h3>m[g</h3>
 *
 *	ȉAAscension ̃eLXg̎ɂĐB
 *	Ascension ́AUnicode ́uړĨtH[fBOv(Search Term Folding) KpeLXgT|[gB
 *	Unicode tH[fBOɂĂ UAX #30: Character Foldings (http://www.unicode.org/reports/tr30/) 
 *
 *	tH[fBOKpꍇAɕGȃtH[fBOKvȏꍇ́A
 *	R[hGɂȂAsxƋԌɈeyڂBPȌKvȂ[Û߂ɁA
 *	KptH[fBO̕GɉăASYύX悤ɂB̕G3iKɕʂA
 *	<ol>
 *		<li>tH[fBOKvȂꍇ</li>
 *		<li>ϊŕ̒ωȂtH[fBOgȂꍇ</li>
 *		<li>ȊO</li>
 *	</ol>
 *	̏ŕGɂȂ
 *
 *	G̑2ł́AeLXgASYŕrƂɕPʂŃtH[fBOs
 *	(A UAX #30 ł͔F߂ĂȂ)B3ł͌OɃp^[A
 *	Ώە̗炩߃tH[fBOĂ悤ɂBRA3̕xԌ
 *
 *	ƂāAK\ł͑3̌IvV͖ƂB
 *	͐Kɑ΂ătH[fBOKpłȂł
 *
 *	܂AKvȂ߁AMigemo ɂ̓tH[fBO͈ؓKpȂ (啶͏ɋʂȂ)
 */

#include "StdAfx.h"
#include "TextSearcher.h"
#include "EditView.h"

#ifndef ASCENSION_NO_REGEX
#include "Lexer.h"
#include <boost/regex.hpp>
#ifdef _DEBUG
#	pragma comment(lib, "libboost_regex-vc71-sgd-1_33.lib")
#else
#	pragma comment(lib, "libboost_regex-vc71-s-1_33.lib")
#endif /* _DEBUG */
namespace {
	/// Boost.Regex ̃G[R[h Ascension ̂̂ɕϊ
	inline Ascension::SearchError::Code translateRegexError(boost::regex_constants::error_type code) {
		using namespace boost::regex_constants;
		using Ascension::SearchError;
		switch(code) {
		case error_collate:		return SearchError::BADPATTERN_INVALID_COLLATING_ELEMENT;
		case error_ctype:		return SearchError::BADPATTERN_INVALID_CHARACTER_CLASS_NAME;
		case error_escape:		return SearchError::BADPATTERN_INVALID_OR_TRAILING_ESCAPE;
		case error_backref:		return SearchError::BADPATTERN_BACK_REFERENCE_TO_NON_EXSISTANT;
		case error_brack:		return SearchError::BADPATTERN_INVALID_CHARACTER_SET;
		case error_paren:		return SearchError::BADPATTERN_MISMATCHED_PAREN;
		case error_brace:		return SearchError::BADPATTERN_MISMATCHED_BRACE;
		case error_badbrace:	return SearchError::BADPATTERN_INVALID_BRACE_CONTENTS;
		case error_range:		return SearchError::BADPATTERN_INVALID_CHARACTER_RANGE;
		case error_space:		return SearchError::BADPATTERN_OUT_OF_MEMORY;
		case error_badrepeat:	return SearchError::BADPATTERN_INVALID_REPEAT;
		case error_complexity:	return SearchError::BADPATTERN_TOO_COMPLEX;
		case error_stack:		return SearchError::BADPATTERN_OUT_OF_STACK_SPACE;
		case error_bad_pattern:	return SearchError::BADPATTERN_UNKNOWN_ERROR;
		default:				assert(false);
		}
		return static_cast<SearchError::Code>(-1);	// Ӗ
	}
}
#endif /* !ASCENSION_NO_REGEX */

using namespace Ascension;
using namespace std;

#ifndef ASCENSION_NO_REGEX
#	define MATCH_TAG			SearchError(SearchError::SUCCEEDED)
#	define NO_MATCH_TAG			SearchError(SearchError::NO_MATCH)
#	define MAKE_REGEX_ERROR(e)	SearchError(translateRegexError(e.code()), e.position())
#else
#	define MATCH_TAG			true
#	define NO_MATCH_TAG			false
#endif /* !ASCENSION_NO_REGEX */


// private helpers
/////////////////////////////////////////////////////////////////////////////

#ifndef ASCENSION_NO_MIGEMO
#include "migemo.h"
namespace {	// C/Migemo
	class Migemo {
	public:
		Migemo() : dll_(0), lastPatternCp932_(0), lastPattern_(0), migemoQuery_(0), migemoRelease_(0), migemoIsEnable_(0) {
		}
		~Migemo() {
			if(dll_ != 0) {
				releasePatterns();
				if(migemo_close_t migemo_close = reinterpret_cast<migemo_close_t>(::GetProcAddress(dll_, "migemo_close")))
					migemo_close(instance_);
				::FreeLibrary(dll_);
			}
		}
		const uchar* query(const uchar* s) {
			if(instance_ == 0)
				const_cast<Migemo*>(this)->open();
			assert(migemoQuery_ != 0 && migemoRelease_ != 0);
			if(lastPatternCp932_ != 0)
				migemoRelease_(instance_, lastPatternCp932_);
			return lastPatternCp932_ = migemoQuery_(instance_, const_cast<unsigned char*>(s));
		}
		const char_t* query(const char_t* first, const char_t* last, size_t& outputLength) {
			assert(first != 0 && last != 0 && first <= last);
			if(!toBoolean(::IsValidCodePage(932)))
				return 0;
			const int bufferLength = ::WideCharToMultiByte(932, 0, first, static_cast<int>(last - first), 0, 0, 0, 0);
			uchar* buffer = new uchar[bufferLength + 1];

			::WideCharToMultiByte(932, 0, first, static_cast<int>(last - first),
				reinterpret_cast<char*>(buffer), static_cast<int>(bufferLength), 0, 0);
			buffer[bufferLength] = 0;
			query(buffer);
			delete[] buffer;

			if(lastPatternCp932_ == 0)
				return 0;

			const size_t patternLength = strlen(reinterpret_cast<const char*>(lastPatternCp932_));

			outputLength = ::MultiByteToWideChar(932, MB_PRECOMPOSED,
								reinterpret_cast<const char*>(lastPatternCp932_), static_cast<int>(patternLength), 0, 0);
			delete[] lastPattern_;
			lastPattern_ = new char_t[outputLength];
			::MultiByteToWideChar(932, MB_PRECOMPOSED,
				reinterpret_cast<const char*>(lastPatternCp932_), static_cast<int>(patternLength),
				lastPattern_, static_cast<int>(outputLength));
			return lastPattern_;
		}
		const char_t* query(const string_t& s, size_t& outputLength) {
			return query(s.data(), s.data() + s.length(), outputLength);
		}
		void releasePatterns() {	// explicit release
			if(lastPatternCp932_ != 0) {
				migemoRelease_(instance_, lastPatternCp932_);
				lastPatternCp932_ = 0;
			}
			delete[] lastPattern_;
			lastPattern_ = 0;
		}
		bool isEnable() const {
			if(instance_ == 0) {
				if(!const_cast<Migemo*>(this)->open())
					return false;
			}
			if(migemoIsEnable_ == 0)
				return false;
			return toBoolean(migemoIsEnable_(instance_));
		}
	private:
		bool open() {
			WCHAR pathName[MAX_PATH + 12];

			wcscpy(pathName, Ascension::EditView::getMigemoPath(true));

			size_t pathLength = wcslen(pathName);

			if(pathLength == 0)
				return false;
			wcscpy(pathName + pathLength, (pathName[pathLength - 1] != L'\\') ? L"\\migemo.dll" : L"migemo.dll");
			if(dll_ = ::LoadLibraryW(pathName)) {
				if(migemo_open_t migemo_open = reinterpret_cast<migemo_open_t>(::GetProcAddress(dll_, "migemo_open"))) {
					instance_ = migemo_open(0);
					migemoQuery_ = reinterpret_cast<migemo_query_t>(::GetProcAddress(dll_, "migemo_query"));
					migemoRelease_ = reinterpret_cast<migemo_release_t>(::GetProcAddress(dll_, "migemo_release"));
					migemoIsEnable_ = reinterpret_cast<migemo_is_enable_t>(::GetProcAddress(dll_, "migemo_is_enable"));

					wcscpy(pathName, Ascension::EditView::getMigemoPath(false));
					pathLength = wcslen(pathName);
					if(pathLength == 0)
						return false;
					else if(pathName[pathLength - 1] != L'\\') {
						wcscpy(pathName + pathLength, L"\\");
						++pathLength;
					}

					char* dictionaryName;
					const int bufferSize = ::WideCharToMultiByte(CP_ACP, 0, pathName, static_cast<int>(pathLength + 1), 0, 0, 0, 0);

					dictionaryName = new char[bufferSize + 16];
					::WideCharToMultiByte(CP_ACP, 0,
						pathName, static_cast<int>(pathLength + 1), dictionaryName, static_cast<int>(bufferSize), 0, 0);

					migemo_load_t migemo_load = reinterpret_cast<migemo_load_t>(::GetProcAddress(dll_, "migemo_load"));

					strcpy(dictionaryName + bufferSize - 1, "migemo-dict");
					migemo_load(instance_, MIGEMO_DICTID_MIGEMO, dictionaryName);
					strcpy(dictionaryName + bufferSize - 1, "roma2hira.dat");
					migemo_load(instance_, MIGEMO_DICTID_ROMA2HIRA, dictionaryName);
					strcpy(dictionaryName + bufferSize - 1, "hira2kata.dat");
					migemo_load(instance_, MIGEMO_DICTID_HIRA2KATA, dictionaryName);
					strcpy(dictionaryName + bufferSize - 1, "han2zen.dat");
					migemo_load(instance_, MIGEMO_DICTID_HAN2ZEN, dictionaryName);
					delete[] dictionaryName;

					migemo_set_operator_t migemo_set_operator =
						reinterpret_cast<migemo_set_operator_t>(::GetProcAddress(dll_, "migemo_set_operator"));
					migemo_set_operator(instance_, MIGEMO_OPINDEX_OR, reinterpret_cast<uchar*>("\\|"));
					migemo_set_operator(instance_, MIGEMO_OPINDEX_NEST_IN, reinterpret_cast<uchar*>("\\("));
					migemo_set_operator(instance_, MIGEMO_OPINDEX_NEST_OUT, reinterpret_cast<uchar*>("\\)"));

					return true;
				}
			}
			return false;
		}
	private:
		typedef migemo*(*migemo_open_t)(char*);
		typedef void(*migemo_close_t)(migemo*);
		typedef unsigned char*(*migemo_query_t)(migemo*, unsigned char*);
		typedef void(*migemo_release_t)(migemo*, unsigned char*);
		typedef int(*migemo_load_t)(migemo*, int, char*);
		typedef int(*migemo_is_enable_t)(migemo*);
		typedef int(*migemo_set_operator_t)(migemo*, int, unsigned char*);

		HMODULE				dll_;
		migemo*				instance_;
		unsigned char*		lastPatternCp932_;
		wchar_t*			lastPattern_;
		migemo_query_t		migemoQuery_;
		migemo_release_t	migemoRelease_;
		migemo_is_enable_t	migemoIsEnable_;
	} migemoWrapper;
} // namespace @0
#endif /* !ASCENSION_NO_MIGEMO */

namespace {
	/// Ώە񑖍Ce[^
	class FoldedSearchTargetIterator : public iterator<bidirectional_iterator_tag, char_t> {
	public:
	private:
		const EditDoc& document_;
		length_t line_, pos_;
		string_t foldedContent_;
		vector<length_t> shortendPositions_;
	};
} // namespace @0

namespace {	// tH_̒`
	const CodePoint	SKIPPED = 0xFFFFFFFF;
	template<TextSearcher::CaseSensitivity> class CaseFolder {
		public:	static CodePoint fold(CodePoint cp);
	};
	template<int> class CharFolder {
		public:	static CodePoint fold(CodePoint cp);
	};

	const char_t smallFormsFoldingTable[] = {	// for Folder<FO_SMALL_FORMS>
		0x002C, 0x3001, 0x002E, 0x003B, 0x003A, 0x003F, 0x0021, 0x2014,
		0x0028, 0x0029, 0x007B, 0x007D, 0x3014, 0x3015, 0x0023, 0x0026,
		0x002A, 0x002B, 0x002D, 0x003C, 0x003E, 0x003D, 0x005C, 0x0024,
		0x0025, 0x0040,
	};

	template<> inline CodePoint CaseFolder<TextSearcher::CASE_SENSITIVE>::fold(CodePoint cp) {return cp;}
	template<> inline CodePoint CaseFolder<TextSearcher::CASE_FOLD_ASCII>::fold(CodePoint cp) {
		return (cp < 0x80) ? towlower(static_cast<wchar_t>(cp)) : cp;
	}
	template<> inline CodePoint CaseFolder<TextSearcher::CASE_FOLD_SIMPLE>::fold(CodePoint cp) {
		return CharacterFolder::foldCase(cp);
	}

	template<> inline CodePoint CharFolder<FoldingOptions::CANONICAL_DUPLICATES>::fold(CodePoint cp) {
		switch(cp) {
		case 0x0374:	return 0x02B9;	// Greek Numeral Sign -> Modifier Letter Prime
		case 0x037E:	return 0x003B;	// Greek Question Mark -> Semicolon
		case 0x0387:	return 0x00B7;	// Greek Ano Teleia -> Middle Dot
		case 0x1FBE:	return 0x03B9;	// Greek Prosgegrammeni -> Greek Small Letter Iota
		case 0x1FEF:	return 0x0060;	// Greek Varia -> Grave Accent
		case 0x1FFD:	return 0x00B4;	// Greek Oxia -> Acute Accent
		case 0x2000:	return 0x2002;	// En Quad -> En Space
		case 0x2001:	return 0x2003;	// Em Quad -> Em Space
		case 0x2126:	return 0x03A9;	// Ohm Sign -> Greek Capital Letter Omega
		case 0x212A:	return 0x004B;	// Kelvin Sign -> Latin Capital Letter K
		case 0x212B:	return 0x00C5;	// Angstrom Sign -> Latin Capital Letter A With Ring Above
		case 0x2329:	return 0x3008;	// Left-Pointing Angle Bracket -> Left Angle Bracket
		case 0x232A:	return 0x3009;	// Right-Pointing Angle Bracket -> Right Angle Bracket
		default:		return cp;
		}
	}
	template<> inline CodePoint CharFolder<FoldingOptions::DASHES>::fold(CodePoint cp) {
		return CharProperty::getGeneralCategory(cp) == CharProperty::GC_PUNCTUATION_DASH ? 0x002D : cp;
	}
	template<> inline CodePoint CharFolder<FoldingOptions::GREEK_LETTERFORMS>::fold(CodePoint cp) {
		switch(cp) {
		case 0x03D0:	return 0x03B2;	// Greek Beta Symbol -> Greek Small Letter Beta
		case 0x03D1:	return 0x03B8;	// Greek Theta Symbol -> Greek Small Letter Theta
		case 0x03D2:	return 0x03A5;	// Greek Upsilon With Hook Symbol -> Greek Capital Letter Upsilon
		case 0x03D5:	return 0x03C6;	// Greek Phi Symbol -> Greek Small Letter Phi
		case 0x03D6:	return 0x03C0;	// Greek Pi Symbol -> Greek Small Letter Pi
		case 0x03F0:	return 0x03BA;	// Greek Kappa Symbol -> Greek Small Letter Kappa
		case 0x03F1:	return 0x03C1;	// Greek Rho Symbol -> Greek Small Letter Rho
		case 0x03F2:	return 0x03C2;	// Greek Lunate Sigma Symbol -> Greek Small Letter Final Sigma
		case 0x03F4:	return 0x0398;	// Greek Capital Theta Symbol -> Greek Capital Letter Theta
		case 0x03F5:	return 0x03B5;	// Greek Lunate Epsilon Symbol -> Greek Small Letter Epsilon
		default:		return cp;
		}
	}
	template<> inline CodePoint CharFolder<FoldingOptions::HEBREW_ALTERNATES>::fold(CodePoint cp) {
		if(cp >= 0xFB20 && cp <= 0xFB28) {
			static const wchar_t hebrewAlternatives[] = {
				0x05E2, 0x05D0, 0x05D3, 0x05D4, 0x05DB, 0x05DC, 0x05DD, 0x05E8, 0x05EA
			};
			return hebrewAlternatives[cp - 0xFB20];
		}
		return cp;
	}
	template<> inline CodePoint CharFolder<FoldingOptions::OVERLINE>::fold(CodePoint cp) {
		return (cp >= 0xFE49 && cp <= 0xFE4C) ? 0x203E : cp;
	}
	template<> inline CodePoint CharFolder<FoldingOptions::NATIVE_DIGIT>::fold(CodePoint cp) {
		return CharacterFolder::foldDigit(cp);
	}
	template<> inline CodePoint CharFolder<FoldingOptions::NOBREAK>::fold(CodePoint cp) {
		switch(cp) {
		case 0x00A0:	return 0x0020;	// No-Break Space -> Space
		case 0x0F0C:	return 0x0F0D;	// Tibetan Mark Delimiter Tsheg Bstar -> Tibetan Mark Shad
		case 0x2007:	return 0x0020;	// Figure Space -> Space
		case 0x2011:	return 0x2010;	// Non-Breaking Hyphen -> Hyphen
		case 0x202F:	return 0x0020;	// Narrow No-Break Space -> Space
		default:		return cp;
		}
	}
	template<> inline CodePoint CharFolder<FoldingOptions::SPACE>::fold(CodePoint cp) {
		return (CharProperty::getGeneralCategory(cp) == CharProperty::GC_SEPARATOR_SPACE) ? 0x0020 : cp;
	}
	template<> inline CodePoint CharFolder<FoldingOptions::SMALL_FORMS>::fold(CodePoint cp) {
		return (cp >= 0xFE50 && cp <= 0xFE6B) ? smallFormsFoldingTable[cp - 0xFE50] : cp;
	}
	template<> inline CodePoint CharFolder<FoldingOptions::UNDERLINE>::fold(CodePoint cp) {
		return (cp == 0x2017 || (cp >= 0xFE4D && cp <= 0xFE4F)) ? 0x005E : cp;
	}

	template<> inline CodePoint CharFolder<FoldingOptions::KANA>::fold(CodePoint cp) {
		// Љɓ
		return ((cp >= 0x30A1 && cp <= 0x30F6) || cp == 0x30FD || cp == 0x30FE) ? cp - 0x0060 : cp;
	}
	template<> inline CodePoint CharFolder<FoldingOptions::LETTER_FORMS>::fold(CodePoint cp) {
		// based on LetterformFolding.txt obtained from UTR #30
		switch(cp) {
		case 0x017F:	return 0x0073;	// Latin Small Letter Long S -> Latin Small Letter S
		case 0x03D0:	return 0x03B2;	// Greek Beta Symbol -> Greek Small Letter Beta
		case 0x03D1:	return 0x03B8;	// Greek Theta Symbol -> Greek Small Letter Theta
		case 0x03D2:	return 0x03A5;	// Greek Upsilon With Hook Symbol -> Greek Capital Letter Upsilon
		case 0x03D5:	return 0x03C6;	// Greek Phi Symbol -> Greek Small Letter Phi
		case 0x03D6:	return 0x03C0;	// Greek Pi Symbol -> Greek Small Letter Pi
		case 0x03F0:	return 0x03BA;	// Greek Kappa Symbol -> Greek Small Letter Kappa
		case 0x03F1:	return 0x03C1;	// Greek Rho Symbol -> Greek Small Letter Rho
		case 0x03F2:	return 0x03C2;	// Greek Lunate Sigma Symbol -> Greek Small Letter Final Sigma
		case 0x03F4:	return 0x0398;	// Greek Capital Theta Symbol -> Greek Capital Letter Theta
		case 0x03F5:	return 0x03B5;	// Greek Lunate Epsilon Symbol -> Greek Small Letter Epsilon
		case 0x03F9:	return 0x03A3;	// Greek Capital Lunate Sigma Symbol -> Greek Capital Letter Sigma
		case 0x2107:	return 0x0190;	// Euler Constant -> Latin Capital Letter Open E
		case 0x2135:	return 0x05D0;	// Alef Symbol -> Hebrew Letter Alef
		case 0x2136:	return 0x05D1;	// Bet Symbol -> Hebrew Letter Bet
		case 0x2137:	return 0x05D2;	// Gimel Symbol -> Hebrew Letter Gimel
		case 0x2138:	return 0x05D3;	// Dalet Symbol -> Hebrew Letter Dalet
		default:		return cp;
		}
	}
	template<> inline CodePoint CharFolder<FoldingOptions::WIDTH>::fold(CodePoint cp) {
		static char_t buffer[2];
		if(cp >= 0x10000)
			return cp;
		if(::LCMapStringW(LOCALE_USER_DEFAULT, LCMAP_HALFWIDTH, reinterpret_cast<WCHAR*>(&cp), 1, buffer, 1) != 0)
			return buffer[0];
		return cp;
		//return toHalfWidth(ch);	// pJi͑ΏۊO
	}

	template<> inline CodePoint CharFolder<FoldingOptions::SKIP_CONTROLS>::fold(CodePoint cp) {
		const CharProperty::GeneralCategory	gc = CharProperty::getGeneralCategory(cp);
		return (gc == CharProperty::GC_OTHER_CONTROL || gc == CharProperty::GC_OTHER_FORMAT) ? SKIPPED : cp;
	}
	template<> inline CodePoint CharFolder<FoldingOptions::SKIP_DIACRITICS>::fold(CodePoint cp) {
		return CharProperty::hasBinaryProperty<CharProperty::BP_DIACRITIC>(cp) ? SKIPPED : cp;
	}
	template<> inline CodePoint CharFolder<FoldingOptions::SKIP_KASHIDA>::fold(CodePoint cp) {
		// does not consider <U+FE71: Arabic Tatweel With Fathatan Above> like IE6...
		return (cp == 0x0640) ? SKIPPED : cp;	// Arabic Tatweel
	}
	template<> inline CodePoint CharFolder<FoldingOptions::SKIP_PUNCTUATIONS>::fold(CodePoint cp) {
		return CharProperty::isPunctuation(cp) ? SKIPPED : cp;
	}
	template<> inline CodePoint CharFolder<FoldingOptions::SKIP_SYMBOLS>::fold(CodePoint cp) {
		return CharProperty::isSymbol(cp) ? SKIPPED : cp;
	}
//	template<> inline CodePoint CharFolder<FoldingOptions::SKIP_VOWELS>::fold(CodePoint cp) {}
	template<> inline CodePoint CharFolder<FoldingOptions::SKIP_WHITESPACES>::fold(CodePoint cp) {
		return CharProperty::hasBinaryProperty<CharProperty::BP_WHITE_SPACE>(cp) ? SKIPPED : cp;
	}
} // namespace @0

namespace Ascension {
namespace Private {
	/// BM ̎
	class BMSearcher {
		// RXgN^
	public:
		/**
		 *	RXgN^
		 *	@param charFolder	1̃tH[hBsvȏꍇ null
		 *	@param forward		Ȍꍇ true
		 *	@param first, last	 (󕶎s)BIuWFNg͂̃̕Rs[<strong>Ȃ</strong>
		 */
		BMSearcher(const TextSearcher* charFolder, bool forward, const char_t* first, const char_t* last)
				: charFolder_(charFolder), forward_(forward), patternFirst_(first), patternLast_(last) {
			assert(first != 0 && last != 0 && first < last);

			fill(lastOccurences_, endof(lastOccurences_), last - first);
			if(forward) {
				for(const char_t* p = first; p < last; ++p)
					lastOccurences_[fold(*p)] = last - p - 1;
			} else {
				for(const char_t* p = last - 1; ; --p) {
					lastOccurences_[fold(*p)] = p - first;
					if(p == first)
						break;
				}
			}
		}
		/**
		 *	s
		 *	@param first, last	ΏەB󕶎s
		 *	@return				vʒuւ̃|C^BȂꍇ null
		 */
		const char_t* search(const char_t* first, const char_t* last) const {
			assert(first != 0 && last != 0 && first < last);

			if(last - first < patternLast_ - patternFirst_)
				return 0;
			if(forward_) {
				for(const char_t* target = first + (patternLast_ - patternFirst_) - 1, *pattern; target < last;
						target += max<length_t>(lastOccurences_[fold(*target)], patternLast_ - pattern)) {
					for(pattern = patternLast_ - 1; fold(*target) == fold(*pattern); --target, --pattern) {
						if(pattern == patternFirst_)
							return target;
					}
				}
			} else {
				length_t skipLength;
				for(const char_t* target = last - (patternLast_ - patternFirst_), *pattern; ; target -= skipLength) {
					for(pattern = patternFirst_; fold(*target) == fold(*pattern); ++target, ++pattern) {
						if(pattern == patternLast_ - 1)
							return target - (patternLast_ - patternFirst_) + 1;
					}
					skipLength = max<length_t>(lastOccurences_[fold(*target)], pattern - patternFirst_ + 1);
					if(skipLength > static_cast<length_t>(target - first))
						break;
				}
			}
			return 0;
		}
	private:
		char_t fold(char_t ch) const {
			return (charFolder_ != 0) ? static_cast<char_t>(charFolder_->foldCharacter(ch)) : ch;
		}

		// f[^o
	private:
		const TextSearcher*	charFolder_;
		const bool			forward_;
		const char_t* const patternFirst_;
		const char_t* const	patternLast_;
		length_t			lastOccurences_[65536];
	};
} // namespace Private
} // namespace Ascension

#ifndef ASCENSION_NO_REGEX
namespace Ascension {
namespace Private {
	/// K\Ŏg̓ (Migemo ̂Ƃɂ͎gȂ)
	class AscensionRegexTraits : public boost::cpp_regex_traits<char_t> {
	private:
		enum {
			CLASS_POSIX_ALNUM = 1, CLASS_POSIX_BLANK, CLASS_POSIX_GRAPH, CLASS_POSIX_PRINT,
			CLASS_POSIX_PUNCT, CLASS_POSIX_WORD, CLASS_POSIX_XDIGIT,
			CLASS_GC_LETTER, CLASS_GC_MARK, CLASS_GC_NUMBER, CLASS_GC_SYMBOL, CLASS_GC_PUNCTUATION,
			CLASS_GC_SEPARATOR, CLASS_GC_OTHER, CLASS_GC_ANY, CLASS_GC_ASSIGNED, CLASS_GC_ASCII,
			CLASS_SCRIPT_KANA, CLASS_END
		};
		enum {
			GENERAL_CATEGORY_START = CLASS_END,
			CODE_BLOCK_START = GENERAL_CATEGORY_START + CharProperty::GC_COUNT,
			SCRIPT_START = CODE_BLOCK_START + CharProperty::CB_COUNT,
			BINARY_PROPERTY_START = SCRIPT_START + CharProperty::S_COUNT
		};
	public:
		typedef bitset<CLASS_END
			+ CharProperty::GC_COUNT
			+ CharProperty::CB_COUNT
			+ CharProperty::S_COUNT
			+ CharProperty::BP_COUNT> char_class_type;
	private:
		typedef boost::cpp_regex_traits<char_t>	BaseTraits;

		// \bh
	public:
		static char_t translate_nocase(char_t c) {return translate(c, true);}
		static char_t translate(char_t c, bool icase) {
			if(searcher_ != 0)	// GfB^̌IvVgꍇ
				return static_cast<char_t>(searcher_->foldCharacter(c));
			else if(icase)	// P[XtH[fBO
				return static_cast<char_t>(CharacterFolder::foldCase(c));
			else	// ȊO͂̂܂
				return c;
		}
		static char_t tolower(char_t c) {return static_cast<char_t>(CharacterFolder::foldCase(c));}
//		static char_t toupper(char_t c) {}
		char_class_type lookup_classname(const char_t* p1, const char_t* p2) const {
			if(classes_.empty())
				initializeClasses();

			const string_t tmp(p1, p2);
			char_class_type klass;
			ClassMap::const_iterator it = classes_.find(tmp.c_str());

			if(it != classes_.end())
				klass.set(it->second);
			return klass;
		}
		bool isctype(char_t c, const char_class_type& f) const {
			// POSIX vpeBAʕ
			if((f[CLASS_POSIX_ALNUM] && LegacyCharTypes::isalnum(c))
					|| (f[CLASS_POSIX_BLANK] && LegacyCharTypes::isblank(c))
					|| (f[CLASS_POSIX_GRAPH] && LegacyCharTypes::isgraph(c))
					|| (f[CLASS_POSIX_PRINT] && LegacyCharTypes::isprint(c))
					|| (f[CLASS_POSIX_PUNCT] && LegacyCharTypes::ispunct(c))
					|| (f[CLASS_POSIX_WORD] && LegacyCharTypes::isword(c))
					|| (f[CLASS_POSIX_XDIGIT] && LegacyCharTypes::isxdigit(c))
					|| (f[CLASS_GC_LETTER] && CharProperty::isLetter(c))
					|| (f[CLASS_GC_MARK] && CharProperty::isMark(c))
					|| (f[CLASS_GC_NUMBER] && CharProperty::isNumber(c))
					|| (f[CLASS_GC_SYMBOL] && CharProperty::isSymbol(c))
					|| (f[CLASS_GC_PUNCTUATION] && CharProperty::isPunctuation(c))
					|| (f[CLASS_GC_SEPARATOR] && CharProperty::isSeparator(c))
					|| (f[CLASS_GC_OTHER] && CharProperty::isOther(c))
					|| (f[CLASS_GC_ANY])
					|| (f[CLASS_GC_ASSIGNED] && CharProperty::getGeneralCategory(c) != CharProperty::GC_OTHER_NOT_ASSIGNED)
					|| (f[CLASS_GC_ASCII] && c < 0x0080))
				return true;

			// script=Hiragana_Or_Katakana
			else if(f[CLASS_SCRIPT_KANA]) {
				const CharProperty::Script script = CharProperty::getScript(c);
				if(script == CharProperty::S_HIRAGANA || script == CharProperty::S_KATAKANA)
					return true;
			}

			// ʕށAR[hubNAXNvg
			if(f[CharProperty::getGeneralCategory(c) + GENERAL_CATEGORY_START]
					|| f[CharProperty::getCodeBlock(c) + CODE_BLOCK_START]
					|| f[CharProperty::getScript(c) + SCRIPT_START])
				return true;

			// 2lvpeB
			for(size_t i = BINARY_PROPERTY_START; i < BINARY_PROPERTY_START + CharProperty::BP_COUNT; ++i) {
				if(f.test(i) && CharProperty::hasBinaryProperty(c, static_cast<CharProperty::BinaryProperty>(i - BINARY_PROPERTY_START)))
					return true;
			}
			return false;
		}

	private:
		static void initializeClasses() {
			// POSIX (based on UTS #18)
			classes_[L"alnum"] = CLASS_POSIX_ALNUM;
			classes_[L"alpha"] = BINARY_PROPERTY_START + CharProperty::BP_ALPHABETIC;
			classes_[L"blank"] = CLASS_POSIX_BLANK;
			classes_[L"cntrl"] = GENERAL_CATEGORY_START + CharProperty::GC_OTHER_CONTROL;
			classes_[L"d"] = GENERAL_CATEGORY_START + CharProperty::GC_NUMBER_DECIMAL_DIGIT;
			classes_[L"digit"] = GENERAL_CATEGORY_START + CharProperty::GC_NUMBER_DECIMAL_DIGIT;
			classes_[L"graph"] = CLASS_POSIX_GRAPH;
			classes_[L"l"] =
			classes_[L"lower"] = BINARY_PROPERTY_START + CharProperty::BP_LOWERCASE;
			classes_[L"print"] = CLASS_POSIX_PRINT;
			classes_[L"punct"] = CLASS_POSIX_PUNCT;
			classes_[L"s"] = BINARY_PROPERTY_START + CharProperty::BP_WHITE_SPACE;
			classes_[L"space"] = BINARY_PROPERTY_START + CharProperty::BP_WHITE_SPACE;
			classes_[L"u"] =
			classes_[L"upper"] = BINARY_PROPERTY_START + CharProperty::BP_UPPERCASE;
			classes_[L"w"] = CLASS_POSIX_WORD;
			classes_[L"word"] = CLASS_POSIX_WORD;
			classes_[L"xdigit"] = CLASS_POSIX_XDIGIT;

			// general category
#define ADD_GC(abbrev, long_name, klass)										\
	classes_[L##abbrev] = GENERAL_CATEGORY_START + CharProperty::GC_##klass;	\
	classes_[L##long_name] = GENERAL_CATEGORY_START + CharProperty::GC_##klass
			classes_[L"l&"] = classes_[L"letter"] = CLASS_GC_LETTER;
			ADD_GC("lu", "uppercaseletter", LETTER_UPPERCASE);
			ADD_GC("ll", "lowercaseletter", LETTER_LOWERCASE);
			ADD_GC("lt", "titlecaseletter", LETTER_TITLECASE);
			ADD_GC("lm", "modifierletter", LETTER_MODIFIER);
			ADD_GC("lo", "otherletter", LETTER_OTHER);
			classes_[L"m&"] = classes_[L"Mark"] = CLASS_GC_MARK;
			ADD_GC("mn", "nonspacingmark", MARK_NONSPACING);
			ADD_GC("mc", "spacingcombiningmark", MARK_SPACING_COMBINING);
			ADD_GC("me", "enclosingmark", MARK_ENCLOSING);
			classes_[L"n&"] = classes_[L"number"] = CLASS_GC_NUMBER;
			ADD_GC("nd", "decimaldigitnumber", NUMBER_DECIMAL_DIGIT);
			ADD_GC("nl", "letternumber", NUMBER_LETTER);
			ADD_GC("no", "othernumber", NUMBER_OTHER);
			classes_[L"s&"] = classes_[L"symbol"] = CLASS_GC_SYMBOL;
			ADD_GC("sm", "mathsymbol", SYMBOL_MATH);
			ADD_GC("sc", "currencysymbol", SYMBOL_CURRENCY);
			ADD_GC("sk", "modifiersymbol", SYMBOL_MODIFIER);
			ADD_GC("so", "othersymbol", SYMBOL_OTHER);
			classes_[L"p&"] = classes_[L"punctuation"] = CLASS_GC_PUNCTUATION;
			ADD_GC("pc", "connectorpunctuation", PUNCTUATION_CONNECTOR);
			ADD_GC("pd", "dashpunctuation", PUNCTUATION_DASH);
			ADD_GC("ps", "openpunctuation", PUNCTUATION_OPEN);
			ADD_GC("pe", "closepunctuation", PUNCTUATION_CLOSE);
			ADD_GC("pi", "initialpunctuation", PUNCTUATION_INITIAL_QUOTE);
			ADD_GC("pf", "finalpunctuation", PUNCTUATION_FINAL_QUOTE);
			ADD_GC("po", "otherpunctuation", PUNCTUATION_OTHER);
			classes_[L"z&"] = classes_[L"separator"] = CLASS_GC_SEPARATOR;
			ADD_GC("zs", "spaceseparator", SEPARATOR_SPACE);
			ADD_GC("zl", "lineseparator", SEPARATOR_LINE);
			ADD_GC("zp", "paragraphseparator", SEPARATOR_PARAGRAPH);
			classes_[L"c&"] = classes_[L"other"] = CLASS_GC_OTHER;
			ADD_GC("cc", "other", OTHER_CONTROL);
			ADD_GC("cf", "format", OTHER_FORMAT);
			ADD_GC("cs", "surrogate", OTHER_SURROGATE);
			ADD_GC("co", "privateuse", OTHER_PRIVATE_USE);
			ADD_GC("cn", "notassigned", OTHER_NOT_ASSIGNED);
			classes_[L"any"] = CLASS_GC_ANY;
			classes_[L"assigned"] = CLASS_GC_ASSIGNED;
			classes_[L"ascii"] = CLASS_GC_ASCII;
#undef ADD_GC

			// code block
#define ADD_BLK(name, klass)	\
	classes_[L##name] = CODE_BLOCK_START + CharProperty::CB_##klass
			ADD_BLK("basiclatin", BASIC_LATIN);
			ADD_BLK("latin1supplement", LATIN_1_SUPPLEMENT);
			ADD_BLK("latinextendeda", LATIN_EXTENDED_A);
			ADD_BLK("latinextendedb", LATIN_EXTENDED_B);
			ADD_BLK("ipaextensions", IPA_EXTENSIONS);
			ADD_BLK("spacingmodifierletters", SPACING_MODIFIER_LETTERS);
			ADD_BLK("combiningdiacriticalmarks", COMBINING_DIACRITICAL_MARKS);
			ADD_BLK("greekandcoptic", GREEK_AND_COPTIC);
			ADD_BLK("cyrillic", CYRILLIC);
			ADD_BLK("cyrillicsupplement", CYRILLIC_SUPPLEMENT);
			ADD_BLK("armenian", ARMENIAN);
			ADD_BLK("hebrew", HEBREW);
			ADD_BLK("arabic", ARABIC);
			ADD_BLK("syriac", SYRIAC);
			ADD_BLK("arabicsupplement", ARABIC_SUPPLEMENT);
			ADD_BLK("thaana", THAANA);
			ADD_BLK("devanagari", DEVANAGARI);
			ADD_BLK("bengali", BENGALI);
			ADD_BLK("gurmukhi", GURMUKHI);
			ADD_BLK("gujarati", GUJARATI);
			ADD_BLK("oriya", ORIYA);
			ADD_BLK("tamil", TAMIL);
			ADD_BLK("telugu", TELUGU);
			ADD_BLK("kannada", KANNADA);
			ADD_BLK("malayalam", MALAYALAM);
			ADD_BLK("sinhala", SINHALA);
			ADD_BLK("thai", THAI);
			ADD_BLK("lao", LAO);
			ADD_BLK("tibetan", TIBETAN);
			ADD_BLK("myanmar", MYANMAR);
			ADD_BLK("georgian", GEORGIAN);
			ADD_BLK("hanguljamo", HANGUL_JAMO);
			ADD_BLK("ethiopic", ETHIOPIC);
			ADD_BLK("ethiopicsupplement", ETHIOPIC_SUPPLEMENT);
			ADD_BLK("cherokee", CHEROKEE);
			ADD_BLK("unifiedcanadianaboriginalsyllabics", UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS);
			ADD_BLK("ogham", OGHAM);
			ADD_BLK("runic", RUNIC);
			ADD_BLK("tagalog", TAGALOG);
			ADD_BLK("hanunoo", HANUNOO);
			ADD_BLK("buhid", BUHID);
			ADD_BLK("tagbanwa", TAGBANWA);
			ADD_BLK("khmer", KHMER);
			ADD_BLK("mongolian", MONGOLIAN);
			ADD_BLK("limbu", LIMBU);
			ADD_BLK("taile", TAI_LE);
			ADD_BLK("newtailue", NEW_TAI_LUE);
			ADD_BLK("khmersymbols", KHMER_SYMBOLS);
			ADD_BLK("buginese", BUGINESE);
			ADD_BLK("phoneticextensions", PHONETIC_EXTENSIONS);
			ADD_BLK("phoneticextensionssupplement", PHONETIC_EXTENSIONS_SUPPLEMENT);
			ADD_BLK("combiningdiacriticalmarkssupplement", COMBINING_DIACRITICAL_MARKS_SUPPLEMENT);
			ADD_BLK("latinextendedadditional", LATIN_EXTENDED_ADDITIONAL);
			ADD_BLK("greekextended", GREEK_EXTENDED);
			ADD_BLK("generalpunctuation", GENERAL_PUNCTUATION);
			ADD_BLK("superscriptsandsubscripts", SUPERSCRIPTS_AND_SUBSCRIPTS);
			ADD_BLK("currencysymbols", CURRENCY_SYMBOLS);
			ADD_BLK("combiningdiacriticalmarksforsymbols", COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS);
			ADD_BLK("letterlikesymbols", LETTERLIKE_SYMBOLS);
			ADD_BLK("numberforms", NUMBER_FORMS);
			ADD_BLK("arrows", ARROWS);
			ADD_BLK("mathematicaloperators", MATHEMATICAL_OPERATORS);
			ADD_BLK("miscellaneoustechnical", MISCELLANEOUS_TECHNICAL);
			ADD_BLK("controlpictures", CONTROL_PICTURES);
			ADD_BLK("opticalcharacter Recognition", OPTICAL_CHARACTER_RECOGNITION);
			ADD_BLK("enclosedalphanumerics", ENCLOSED_ALPHANUMERICS);
			ADD_BLK("boxdrawing", BOX_DRAWING);
			ADD_BLK("blockelements", BLOCK_ELEMENTS);
			ADD_BLK("geometricshapes", GEOMETRIC_SHAPES);
			ADD_BLK("miscellaneoussymbols", MISCELLANEOUS_SYMBOLS);
			ADD_BLK("dingbats", DINGBATS);
			ADD_BLK("miscellaneousmathematicalsymbolsa", MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A);
			ADD_BLK("supplementalarrowsa", SUPPLEMENTAL_ARROWS_A);
			ADD_BLK("braillepatterns", BRAILLE_PATTERNS);
			ADD_BLK("supplementalarrowsb", SUPPLEMENTAL_ARROWS_B);
			ADD_BLK("miscellaneousmathematicalsymbolsb", MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B);
			ADD_BLK("supplementalmathematicaloperators", SUPPLEMENTAL_MATHEMATICAL_OPERATORS);
			ADD_BLK("miscellaneoussymbolsandarrows", MISCELLANEOUS_SYMBOLS_AND_ARROWS);
			ADD_BLK("glagolitic", GLAGOLITIC);
			ADD_BLK("coptic", COPTIC);
			ADD_BLK("georgiansupplement", GEORGIAN_SUPPLEMENT);
			ADD_BLK("tifinagh", TIFINAGH);
			ADD_BLK("ethiopicextended", ETHIOPIC_EXTENDED);
			ADD_BLK("supplementalpunctuation", SUPPLEMENTAL_PUNCTUATION);
			ADD_BLK("cjkradicalssupplement", CJK_RADICALS_SUPPLEMENT);
			ADD_BLK("kangxiradicals", KANGXI_RADICALS);
			ADD_BLK("ideographicdescriptioncharacters", IDEOGRAPHIC_DESCRIPTION_CHARACTERS);
			ADD_BLK("cjksymbolsandpunctuation", CJK_SYMBOLS_AND_PUNCTUATION);
			ADD_BLK("hiragana", HIRAGANA);
			ADD_BLK("katakana", KATAKANA);
			ADD_BLK("bopomofo", BOPOMOFO);
			ADD_BLK("hangulcompatibilityjamo", HANGUL_COMPATIBILITY_JAMO);
			ADD_BLK("kanbun", KANBUN);
			ADD_BLK("bopomofoextended", BOPOMOFO_EXTENDED);
			ADD_BLK("cjkstrokes", CJK_STROKES);
			ADD_BLK("katakanaphoneticextensions", KATAKANA_PHONETIC_EXTENSIONS);
			ADD_BLK("enclosedcjklettersandmonths", ENCLOSED_CJK_LETTERS_AND_MONTHS);
			ADD_BLK("cjkcompatibility", CJK_COMPATIBILITY);
			ADD_BLK("cjkunifiedideographsextensiona", CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
			ADD_BLK("yijinghexagramsymbols", YIJING_HEXAGRAM_SYMBOLS);
			ADD_BLK("cjkunifiedideographs", CJK_UNIFIED_IDEOGRAPHS);
			ADD_BLK("yisyllables", YI_SYLLABLES);
			ADD_BLK("yiradicals", YI_RADICALS);
			ADD_BLK("modifiertoneletters", MODIFIER_TONE_LETTERS);
			ADD_BLK("sylotinagri", SYLOTI_NAGRI);
			ADD_BLK("hangulsyllables", HANGUL_SYLLABLES);
			ADD_BLK("highsurrogates", HIGH_SURROGATES);
			ADD_BLK("highprivateusesurrogates", HIGH_PRIVATE_USE_SURROGATES);
			ADD_BLK("lowsurrogates", LOW_SURROGATES);
			ADD_BLK("privateusearea", PRIVATE_USE_AREA);
			ADD_BLK("cjkcompatibilityideographs", CJK_COMPATIBILITY_IDEOGRAPHS);
			ADD_BLK("alphabeticpresentationforms", ALPHABETIC_PRESENTATION_FORMS);
			ADD_BLK("arabicpresentationformsa", ARABIC_PRESENTATION_FORMS_A);
			ADD_BLK("variationselectors", VARIATION_SELECTORS);
			ADD_BLK("verticalforms", VERTICAL_FORMS);
			ADD_BLK("combininghalfmarks", COMBINING_HALF_MARKS);
			ADD_BLK("cjkcompatibilityforms", CJK_COMPATIBILITY_FORMS);
			ADD_BLK("smallformvariants", SMALL_FORM_VARIANTS);
			ADD_BLK("arabicpresentationformsb", ARABIC_PRESENTATION_FORMS_B);
			ADD_BLK("halfwidthandfullwidthforms", HALFWIDTH_AND_FULLWIDTH_FORMS);
			ADD_BLK("specials", SPECIALS);
			ADD_BLK("linearbsyllabary", LINEAR_B_SYLLABARY);
			ADD_BLK("linearbideograms", LINEAR_B_IDEOGRAMS);
			ADD_BLK("aegeannumbers", AEGEAN_NUMBERS);
			ADD_BLK("ancientgreeknumbers", ANCIENT_GREEK_NUMBERS);
			ADD_BLK("olditalic", OLD_ITALIC);
			ADD_BLK("gothic", GOTHIC);
			ADD_BLK("ugaritic", UGARITIC);
			ADD_BLK("oldpersian", OLD_PERSIAN);
			ADD_BLK("deseret", DESERET);
			ADD_BLK("shavian", SHAVIAN);
			ADD_BLK("osmanya", OSMANYA);
			ADD_BLK("cypriotsyllabary", CYPRIOT_SYLLABARY);
			ADD_BLK("kharoshthi", KHAROSHTHI);
			ADD_BLK("byzantinemusicalsymbols", BYZANTINE_MUSICAL_SYMBOLS);
			ADD_BLK("musicalsymbols", MUSICAL_SYMBOLS);
			ADD_BLK("ancientgreekmusicalnotation", ANCIENT_GREEK_MUSICAL_NOTATION);
			ADD_BLK("taixuanjingsymbols", TAI_XUAN_JING_SYMBOLS);
			ADD_BLK("mathematicalalphanumericsymbols", MATHEMATICAL_ALPHANUMERIC_SYMBOLS);
			ADD_BLK("cjkunifiedideographsextensionb", CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B);
			ADD_BLK("cjkcompatibilityideographssupplement", CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT);
			ADD_BLK("tags", TAGS);
			ADD_BLK("variationselectorssupplement", VARIATION_SELECTORS_SUPPLEMENT);
			ADD_BLK("supplementaryprivateuseareaa", SUPPLEMENTARY_PRIVATE_USE_AREA_A);
			ADD_BLK("supplementaryprivateuseareab", SUPPLEMENTARY_PRIVATE_USE_AREA_B);
#undef ADD_BLK

			// script
#define ADD_SC(abbrev, long_name, klass)							\
	classes_[L##abbrev] = SCRIPT_START + CharProperty::S_##klass;	\
	classes_[L##long_name] = SCRIPT_START + CharProperty::S_##klass
			ADD_SC("arab", "arabic", ARABIC);
			ADD_SC("armn", "armenian", ARMENIAN);
			ADD_SC("beng", "bengali", BENGALI);
			ADD_SC("bopo", "bopomofo", BOPOMOFO);
			ADD_SC("brai", "braille", BRAILLE);
			ADD_SC("bugi", "buginese", BUGINESE);
			ADD_SC("buhd", "buhid", BUHID);
			ADD_SC("cans", "canadianaboriginal", CANADIAN_ABORIGINAL);
			ADD_SC("cher", "cherokee", CHEROKEE);
			ADD_SC("copt", "coptic", COPTIC);
			ADD_SC("cprt", "cypriot", CYPRIOT);
			ADD_SC("cyrl", "cyrillic", CYRILLIC);
			ADD_SC("deva", "devanagari", DEVANAGARI);
			ADD_SC("dsrt", "deseret", DESERET);
			ADD_SC("ethi", "ethiopic", ETHIOPIC);
			ADD_SC("geor", "georgian", GEORGIAN);
			ADD_SC("glag", "glagolitic", GLAGOLITIC);
			ADD_SC("goth", "gothic", GOTHIC);
			ADD_SC("grek", "greek", GREEK);
			ADD_SC("gujr", "gujarati", GUJARATI);
			ADD_SC("guru", "gurmukhi", GURMUKHI);
			ADD_SC("hang", "hangul", HANGUL);
			ADD_SC("hani", "han", HAN);
			ADD_SC("hano", "hanunoo", HANUNOO);
			ADD_SC("hebr", "hebrew", HEBREW);
			ADD_SC("hira", "hiragana", HIRAGANA);
			classes_[L"hrkt"] = CLASS_SCRIPT_KANA;
			classes_[L"katakanaorhiragana"] = CLASS_SCRIPT_KANA;
			ADD_SC("ital", "olditalic", OLD_ITALIC);
			ADD_SC("kana", "katakana", KATAKANA);
			ADD_SC("khar", "kharoshthi", KHAROSHTHI);
			ADD_SC("khmr", "khmer", KHMER);
			ADD_SC("knda", "kannada", KANNADA);
			ADD_SC("laoo", "lao", LAO);
			ADD_SC("latn", "latin", LATIN);
			ADD_SC("limb", "limbu", LIMBU);
			ADD_SC("linb", "linearb", LINEAR_B);
			ADD_SC("mlym", "malayalam", MALAYALAM);
			ADD_SC("mong", "mongolian", MONGOLIAN);
			ADD_SC("mymr", "myanmar", MYANMAR);
			ADD_SC("ogam", "ogham", OGHAM);
			ADD_SC("orya", "oriya", ORIYA);
			ADD_SC("osma", "osmanya", OSMANYA);
			ADD_SC("qaai", "inherited", INHERITED);
			ADD_SC("runr", "runic", RUNIC);
			ADD_SC("shaw", "shavian", SHAVIAN);
			ADD_SC("sinh", "sinhala", SINHALA);
			ADD_SC("sylo", "sylotinagri", SYLOTI_NAGRI);
			ADD_SC("syrc", "syriac", SYRIAC);
			ADD_SC("tagb", "tagbanwa", TAGBANWA);
			ADD_SC("tale", "taile", TAI_LE);
			ADD_SC("talu", "newtailue", NEW_TAI_LUE);
			ADD_SC("taml", "tamil", TAMIL);
			ADD_SC("telu", "telugu", TELUGU);
			ADD_SC("tfng", "tifinagh", TIFINAGH);
			ADD_SC("tglg", "tagalog", TAGALOG);
			ADD_SC("thaa", "thaana", THAANA);
			ADD_SC("thai", "thai", THAI);
			ADD_SC("tibt", "tibetan", TIBETAN);
			ADD_SC("ugar", "ugaritic", UGARITIC);
			ADD_SC("xpeo", "oldpersian", OLD_PERSIAN);
			ADD_SC("yiii", "yi", YI);
			ADD_SC("zyyy", "common", COMMON);
#undef ADD_SC

			// binary property
#define ADD_BP(abbrev, long_name, klass)										\
	classes_[L##abbrev] = BINARY_PROPERTY_START + CharProperty::BP_##klass;	\
	classes_[L##long_name] = BINARY_PROPERTY_START + CharProperty::BP_##klass
			ADD_BP("ahex", "asciihexdigit", ASCII_HEX_DIGIT);
			classes_[L"alphabetic"] = BINARY_PROPERTY_START + CharProperty::BP_ALPHABETIC;
			ADD_BP("bidic", "bidicontrol", BIDI_CONTROL);
//			ADD_BP("bidim", "bidimirrored", BIDI_MIRRORED);
//			ADD_BP("ce", "compositionexclusion", COMPOSITION_EXCLUSION);
			ADD_BP("compex", "fillcompositionexclusion", FULL_COMPOSITION_EXCLUSION);
			classes_[L"dash"] = BINARY_PROPERTY_START + CharProperty::BP_DASH;
			ADD_BP("dep", "deprecated", DEPRECATED);
			ADD_BP("di", "defaultignorablecodepoint", DEFAULT_IGNORABLE_CODE_POINT);
			ADD_BP("dia", "diacritic", DIACRITIC);
			ADD_BP("ext", "extender", EXTENDER);
			ADD_BP("grbase", "graphemebase", GRAPHEME_BASE);
			ADD_BP("grext", "graphemeextend", GRAPHEME_EXTEND);
			ADD_BP("grlink", "graphemelink", GRAPHEME_LINK);
			ADD_BP("hex", "hexdigit", HEX_DIGIT);
			classes_[L"hyphen"] = BINARY_PROPERTY_START + CharProperty::BP_HYPHEN;
			ADD_BP("idc", "idcontinue", ID_CONTINUE);
			ADD_BP("ideo", "ideographic", IDEOGRAPHIC);
			ADD_BP("ids", "idstart", ID_START);
			ADD_BP("idsb", "idsbinaryoperator", IDS_BINARY_OPERATOR);
			ADD_BP("idst", "idstrinaryoperator", IDS_TRINARY_OPERATOR);
			ADD_BP("joinc", "joincontrol", JOIN_CONTROL);
			ADD_BP("loe", "logicalorderexception", LOGICAL_ORDER_EXCEPTION);
			classes_[L"lowercase"] = BINARY_PROPERTY_START + CharProperty::BP_LOWERCASE;
			classes_[L"math"] = BINARY_PROPERTY_START + CharProperty::BP_MATH;
			ADD_BP("nchar", "noncharactercodepoint", NONCHARACTER_CODE_POINT);
			ADD_BP("oalpha", "otheralphabetic", OTHER_ALPHABETIC);
			ADD_BP("odi", "otherdefaultignorablecodepoint", OTHER_DEFAULT_IGNORABLE_CODE_POINT);
			ADD_BP("ogrext", "othergraphemeextend", OTHER_GRAPHEME_EXTEND);
			ADD_BP("oidc", "otheridcontinue", OTHER_ID_CONTINUE);
			ADD_BP("oids", "otheridstart", OTHER_ID_START);
			ADD_BP("olower", "other_lowercase", OTHER_LOWERCASE);
			ADD_BP("omath", "othermath", OTHER_MATH);
			ADD_BP("oupper", "otheruppercase", OTHER_UPPERCASE);
			ADD_BP("patsyn", "patternsyntax", PATTERN_SYNTAX);
			ADD_BP("patws", "patternwhitespace", PATTERN_WHITE_SPACE);
			ADD_BP("qmark", "quotationmark", QUOTATION_MARK);
			classes_[L"radical"] = BINARY_PROPERTY_START + CharProperty::BP_RADICAL;
			ADD_BP("sd", "softdotted", SOFT_DOTTED);
			classes_[L"sterm"] = BINARY_PROPERTY_START + CharProperty::BP_STERM;
			ADD_BP("term", "terminalpunctuation", TERMINAL_PUNCTUATION);
			ADD_BP("uideo", "unifiedideograph", UNIFIED_IDEOGRAPH);
			classes_[L"uppercase"] = BINARY_PROPERTY_START + CharProperty::BP_UPPERCASE;
			ADD_BP("vs", "variationselector", VARIATION_SELECTOR);
			ADD_BP("wspace", "whitespace", WHITE_SPACE);
//			ADD_BP("xidc", "xidcontinue", XID_CONTINUE);
//			ADD_BP("xids", "xidstart", XID_START);
//			ADD_BP("xonfc", "expandsonnfc", EXPANDS_ON_NFC);
//			ADD_BP("xonfd", "expandsonnfd", EXPANDS_ON_NFD);
//			ADD_BP("xonfkc", "expandsonnfkc", EXPANDS_ON_NFKC);
//			ADD_BP("xonfkd", "expandsonnfkd", EXPANDS_ON_NFKD);
#undef ADD_BP
		}

		// f[^o
	public:
		static const Lexer* lexer_;
		static TextSearcher* searcher_;
	private:
		// UCD  Property and Property Value Matching ɊÂp^[}b`O
		// (http://www.unicode.org/Public/UNIDATA/UCD.html#Property_and_Property_Value_Matching)
		struct ClassNameComparer {
			bool operator ()(const char_t* p1, const char_t* p2) const {
				while(*p1 != 0 && *p2 != 0) {
					if(*p1 == L'_' || *p1 == L'-' || *p1 == L' ') {
						++p1; continue;
					} else if(*p2 == L'_' || *p2 == L'-' || *p2 == L' ') {
						++p2; continue;
					}
					const int c1 = towlower(*p1), c2 = towlower(*p2);
					if(c1 < c2)			return true;
					else if(c2 < c1)	return false;
					else				++p1, ++p2;
				}
				return (*p1 == 0) && (*p2 != 0);
			}
		};
	public:
		typedef map<const char_t*, BaseTraits::char_class_type, ClassNameComparer> ClassMap;
	private:
		static ClassMap classes_;
	};

	TextSearcher* AscensionRegexTraits::searcher_ = 0;
	const Lexer* AscensionRegexTraits::lexer_ = 0;
	AscensionRegexTraits::ClassMap AscensionRegexTraits::classes_;

//	typedef boost::basic_regex<char_t, AscensionRegexTraits> AscensionRegex;
} // namespace Private
} // namespace Ascension
#endif /* !ASCENSION_NO_REGEX */


// TextSearcher class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
TextSearcher::TextSearcher() : changedFromLast_(false), lastLiteralPattern_(0)
#ifndef ASCENSION_NO_REGEX
		, lastRegexPattern_(0), lastRegexMatchResults_(0)
#endif /* !ASCENSION_NO_REGEX */
#ifndef ASCENSION_NO_MIGEMO
		, lastMigemoPattern_(0)
#endif /* !ASCENSION_NO_MIGEMO */
{}

/// fXgN^
TextSearcher::~TextSearcher() {
	clearPatternCache();
}

///  (p^[) ̃LbVNA
void TextSearcher::clearPatternCache() {
	delete lastLiteralPattern_;
	lastLiteralPattern_ = 0;
#ifndef ASCENSION_NO_REGEXP
	delete lastRegexPattern_;
	lastRegexPattern_ = 0;
	delete lastRegexMatchResults_;
	lastRegexMatchResults_ = 0;
#endif /* !ASCENSION_NO_REGEXP */
#ifndef ASCENSION_NO_MIGEMO
	delete lastMigemoPattern_;
	lastMigemoPattern_ = 0;
#endif /* !ASCENSION_NO_MIGEMO */
}

#ifndef ASCENSION_NO_REGEX
/**
 *	񂩂琳Kp^[쐬
 *	@return	
 */
SearchError TextSearcher::compileRegexPattern() const throw() {
	if(options_.type == REGULAR_EXPRESSION) {
		if(lastRegexPattern_ != 0)
			return MATCH_TAG;
		assert(isRegexAvailable());
		try {
			const_cast<TextSearcher*>(this)->lastRegexPattern_
				= new Private::AscensionRegex(findWhat_, boost::regex_constants::perl);
		} catch(boost::regex_error& e) {
			return MAKE_REGEX_ERROR(e);
		}
		return MATCH_TAG;
	}
#ifndef ASCENSION_NO_MIGEMO
	else if(options_.type == MIGEMO) {
		if(lastMigemoPattern_ != 0)
			return MATCH_TAG;
		assert(isMigemoAvailable());
		size_t patternLength;
		const char_t* pattern = migemoWrapper.query(findWhat_, patternLength);

		if(pattern == 0)
			return SearchError(SearchError::MIGEMO_ERROR);
		try {
			// Migemo ŎgḰAAƍANXA/ʂȂ
			namespace brc = boost::regex_constants;
			const_cast<TextSearcher*>(this)->lastMigemoPattern_ 
				= new boost::basic_regex<char_t, boost::cpp_regex_traits<char_t> >(
					pattern, pattern + patternLength,
					brc::emacs | brc::icase | brc::no_char_classes | brc::nocollate | brc::nosubs| brc::perl);
		} catch(boost::bad_pattern& e) {
			migemoWrapper.releasePatterns();
			return MAKE_REGEX_ERROR(e);
		}
		return MATCH_TAG;
	}
#endif /* !ASCENSION_NO_MIGEMO */
	assert(false);	// ɂ͗Ȃ
	return NO_MATCH_TAG;	// Ӗ
}
#endif /* !ASCENSION_NO_REGEX */

/**
 *	ݐݒ肳Ă錟IvVɊÂāAPʂ̃tH[fBOs
 *	@param cp	ϊR[h|Cg
 *	@return		ϊꂽR[h|CgBSKIPPED Ԃꍇ͂̃R[h|Cg͖ł
 */
inline CodePoint TextSearcher::foldCharacter(CodePoint cp) const {
	assertValid();

	// łR[h|Cg
#define SKIP_CHAR(type)															\
	if(options_.foldings[FoldingOptions::SKIP_##type]							\
			&& CharFolder<FoldingOptions::SKIP_##type>::fold(cp) == SKIPPED)	\
		return SKIPPED
	SKIP_CHAR(PUNCTUATIONS);
	SKIP_CHAR(SYMBOLS);
	SKIP_CHAR(WHITESPACES);
	SKIP_CHAR(DIACRITICS);
//	SKIP_CHAR(VOWELS);
	SKIP_CHAR(KASHIDA);
	SKIP_CHAR(CONTROLS);
#undef SKIP_CHAR

	// 啶
	if(options_.caseSensitivity == CASE_SENSITIVE)			cp = CaseFolder<CASE_SENSITIVE>::fold(cp);
	else if(options_.caseSensitivity == CASE_FOLD_ASCII)	cp = CaseFolder<CASE_FOLD_ASCII>::fold(cp);
	else if(options_.caseSensitivity == CASE_FOLD_SIMPLE)	cp = CaseFolder<CASE_FOLD_SIMPLE>::fold(cp);
//	else if(options_.caseSensitivity == CASE_FOLD_FULL)		cp = CaseFolder<CASE_FOLD_FULL>::fld(cp);

	// R[h|CgƂ̕ϊ
#define FOLD_1_TO_1(type)	if(options_.foldings[FoldingOptions::type]) cp = CharFolder<FoldingOptions::type>::fold(cp)
//	FOLD_1_TO_N(ACCENT_REMOVAL);
	FOLD_1_TO_1(CANONICAL_DUPLICATES);
	FOLD_1_TO_1(DASHES);
	FOLD_1_TO_1(GREEK_LETTERFORMS);
	FOLD_1_TO_1(HEBREW_ALTERNATES);
//	FOLD_1_TO_N(JAMO);
//	FOLD_1_TO_1(MATH_SYMBOL);
	FOLD_1_TO_1(NATIVE_DIGIT);
	FOLD_1_TO_1(NOBREAK);
	FOLD_1_TO_1(OVERLINE);
//	FOLD_1_TO_1(POSITIONAL_FORMS);
	FOLD_1_TO_1(SMALL_FORMS);
	FOLD_1_TO_1(SPACE);
//	FOLD_1_TO_1(SPACING_ACCENTS);
//	FOLD_1_TO_1(SUBSCRIPT);
//	FOLD_1_TO_1(SYMBOL);
	FOLD_1_TO_1(UNDERLINE);
//	FOLD_1_TO_1(VERTICAL_FORMS);
//	FOLD_1_TO_N(DIACRITIC_REMOVAL);
//	FOLD_1_TO_N(HAN_RADICAL);
	FOLD_1_TO_1(KANA);
	FOLD_1_TO_1(LETTER_FORMS);
//	FOLD_1_TO_1(SIMPLIFIED_HAN);
//	FOLD_1_TO_1(SUPERSCRIPT);
//	FOLD_1_TO_1(SUZHOU_NUMERAL);
	FOLD_1_TO_1(WIDTH);
#undef FOLD_1_TO_1
	return cp;
}

/// Migemo gp\Ԃ
bool TextSearcher::isMigemoAvailable() {
#ifdef ASCENSION_NO_MIGEMO
	return false;
#else
	return isRegexAvailable() && migemoWrapper.isEnable() && toBoolean(::IsValidCodePage(932));
#endif /* ASCENSION_NO_MIGEMO */
}

template<> inline SearchResult
TextSearcher::doMatch<TextSearcher::LITERAL>(const MatchTarget& target, const BoundaryDetector&) const {
	if(findWhat_.empty()
			|| (!options_.isComplex() && target.last - target.first != findWhat_.length()))
		return NO_MATCH_TAG;
	else if(options_.isEmpty())
		return (wcsncmp(findWhat_.data(), target.first, findWhat_.length()) == 0) ? MATCH_TAG : NO_MATCH_TAG;
	else if(!options_.isComplex()) {
		const UTF16ToUTF32Iterator targetEnd(target.last);
		for(UTF16ToUTF32Iterator p(findWhat_.data()), t(target.first); t != targetEnd; ++p, ++t) {
			if(foldCharacter(*p) != foldCharacter(*t))
				return NO_MATCH_TAG;
		}
		return MATCH_TAG;
	} else {
		const UTF16ToUTF32Iterator patternEnd(findWhat_.data() + findWhat_.length()), targetEnd(target.last);
		for(UTF16ToUTF32Iterator p(findWhat_.data()), t(target.first); p != patternEnd && t != targetEnd; ++p, ++t) {
			CodePoint cp1 = foldCharacter(*p), cp2 = foldCharacter(*t);
			while(cp1 == SKIPPED) {
				if(++p == patternEnd)
					return (t == targetEnd) ? MATCH_TAG : NO_MATCH_TAG;
				cp1 = foldCharacter(*p);
			}
			while(cp2 == SKIPPED) {
				if(++t == targetEnd)
					return (p == patternEnd) ? MATCH_TAG : NO_MATCH_TAG;
				cp2 = foldCharacter(*t);
			}
			if(cp1 != cp2)
				return NO_MATCH_TAG;
		}
		return MATCH_TAG;
	}
}

#ifndef ASCENSION_NO_REGEX
template<> inline SearchResult
TextSearcher::doMatch<TextSearcher::REGULAR_EXPRESSION>(const MatchTarget& target, const BoundaryDetector& boundary) const {
	assert(isRegexAvailable());

	Private::AscensionRegexTraits::lexer_ = &boundary.getLexer();
	Private::AscensionRegexTraits::searcher_ = const_cast<TextSearcher*>(this);

	const SearchError result = compileRegexPattern();	// lastRegexPattern_ RpC
	if(!result)
		return result;
	if(lastRegexMatchResults_ == 0)
		const_cast<TextSearcher*>(this)->lastRegexMatchResults_ = new boost::match_results<const char_t*>;

	const boost::match_flag_type flags = static_cast<boost::match_flag_type>(
		boost::regex_constants::match_default
		| ((target.first == target.entireFirst) ? 0 : boost::regex_constants::match_not_bol)
		| ((target.last == target.entireLast) ? 0 : boost::regex_constants::match_not_eol));
	try {
		const bool matched = boost::regex_match(target.first, target.last, *lastRegexMatchResults_, *lastRegexPattern_, flags);
		return SearchError(matched ? SearchError::SUCCEEDED : SearchError::NO_MATCH);
	} catch(runtime_error&) {
		return SearchError(SearchError::RUNTIME_ERROR_FOR_COMPLEXITY);
	}
}
#endif /* !ASCENSION_NO_REGEX */

#ifndef ASCENSION_NO_MIGEMO
template<> inline SearchResult
TextSearcher::doMatch<TextSearcher::MIGEMO>(const MatchTarget& target, const BoundaryDetector& boundary) const {
	assert(isMigemoAvailable());

	const SearchError result = compileRegexPattern();	// lastMigemoPattern_ RpC
	if(!result)
		return result;
	const boost::match_flag_type flags = static_cast<boost::match_flag_type>(
		boost::regex_constants::match_default
		| ((target.first == target.entireFirst) ? 0 : boost::regex_constants::match_not_bol)
		| ((target.last == target.entireLast) ? 0 : boost::regex_constants::match_not_eol));
	try {
		const bool matched = boost::regex_match(target.first, target.last, *lastMigemoPattern_, flags);
		return SearchError(matched ? SearchError::SUCCEEDED : SearchError::NO_MATCH);
	} catch(runtime_error&) {
		return SearchError(SearchError::RUNTIME_ERROR_FOR_COMPLEXITY);
	}
}
#endif /* !ASCENSION_NO_MIGEMO */

/**
 *	}b`s
 *	@param target	}b`Ώە
 *	@param boundary	E`
 *	@return			
 */
SearchResult TextSearcher::match(const MatchTarget& target, const BoundaryDetector& boundary) const {
	assert(target.isNormalized());
	bool matched;
	switch(options_.type) {
	case LITERAL:				matched = doMatch<LITERAL>(target, boundary); break;
#ifndef ASCENSION_NO_REGEX
	case REGULAR_EXPRESSION:	matched = doMatch<REGULAR_EXPRESSION>(target, boundary); break;
#endif /* !ASCENSION_NO_REGEX */
//	case WILD_CARD:				matched = doMatch<WILD_CARD>(target, boundary); break;
#ifndef ASCENSION_NO_MIGEMO
	case MIGEMO:				matched = doMatch<MIGEMO>(target, boundary); break;
#endif /* !ASCENSION_NO_MIGEMO */
	default:					assert(false); return NO_MATCH_TAG;	// 蓾
	}
	if(!matched)
		return NO_MATCH_TAG;
	if(!options_.wholeWord
			|| (boundary.hasWordBoundaryAt(target.entireFirst, target.entireLast, target.first)
			&& boundary.hasWordBoundaryAt(target.entireFirst, target.entireLast, target.last)))
		return MATCH_TAG;
	return NO_MATCH_TAG;
}

template<> inline SearchResult TextSearcher::doReplace<TextSearcher::LITERAL>(
		const MatchTarget& target, string_t& replaced, const BoundaryDetector& boundary) const {
	const SearchResult result = doMatch<LITERAL>(target, boundary);
	if(!result)
		return result;
	replaced.assign(replaceWith_);
	return result;
}

#ifndef ASCENSION_NO_REGEX
template<> inline SearchResult TextSearcher::doReplace<TextSearcher::REGULAR_EXPRESSION>(
		const MatchTarget& target, string_t& replaced, const BoundaryDetector& boundary) const {
	assert(isRegexAvailable());
	const SearchError result = doMatch<REGULAR_EXPRESSION>(target, boundary);
	if(result.getCode() != SearchError::SUCCEEDED)
		return result;
	try {
		replaced.assign(lastRegexMatchResults_->format(replaceWith_, boost::regex_constants::format_perl));
		return SearchError(SearchError::SUCCEEDED);
	} catch(runtime_error&) {
		return SearchError(SearchError::RUNTIME_ERROR_FOR_COMPLEXITY);
	}
}
#endif /* !ASCENSION_NO_REGEX */

#ifndef ASCENSION_NO_MIGEMO
template<> inline SearchResult TextSearcher::doReplace<TextSearcher::MIGEMO>(
		const MatchTarget& target, string_t& replaced, const BoundaryDetector& boundary) const {
	const SearchResult result = doMatch<MIGEMO>(target, boundary);
	if(!result)
		return result;
	replaced.assign(replaceWith_);
	return result;
}
#endif /* !ASCENSION_NO_MIGEMO */

/**
 *	@brief us
 *
 *	̃\bh͒us킯ł͂ȂAuԂŁA
 *	ۂ̒u͌Ăяos
 *
 *	uΏۂ͂̕܂Ǎ݂Ƀ}b`邩`FbNB
 *	}b`Ȃꍇ͒u͎s (false Ԃ)
 *
 *	@param target	[in] uΏە
 *	@param replaced	[out] uBĂяo͌̕̕Œu
 *	@param boundary	[in] E`
 *	@return			
 */
SearchResult TextSearcher::replace(const MatchTarget& target, string_t& replaced, const BoundaryDetector& boundary) const {
	assert(target.isNormalized());
	switch(options_.type) {
	case LITERAL:				return doReplace<LITERAL>(target, replaced, boundary);
#ifndef ASCENSION_NO_REGEX
	case REGULAR_EXPRESSION:	return doReplace<REGULAR_EXPRESSION>(target, replaced, boundary);
#endif /* !ASCENSION_NO_REGEX */
//	case WILD_CARD:				return doReplace<WILD_CARD>(target, replaced, boundary);
#ifndef ASCENSION_NO_MIGEMO
	case MIGEMO:				return doReplace<MIGEMO>(target, replaced, boundary);
#endif /* !ASCENSION_NO_MIGEMO */
	default:					assert(false); return NO_MATCH_TAG;	// 蓾
	}
}

template<> SearchResult TextSearcher::doSearch<TextSearcher::LITERAL>(
		const SearchTarget& target, bool forward, MatchedRange& result, const BoundaryDetector& boundary) const {
	const bool			complex = options_.isComplex();
	const char_t* const	findWhatOrg = findWhat_.data();
	char_t* const		findWhatFolded = complex ? new char_t[findWhat_.length()] : 0;
	char_t* const		targetFolded = complex ? new char_t[target.last - target.first] : 0;
	length_t			i = 0;

	//  folding
	if(complex) {
		const UTF16ToUTF32Iterator end(findWhatOrg + findWhat_.length());
		for(UTF16ToUTF32Iterator it(findWhatOrg); it < end; ++it) {
			const CodePoint	cp = foldCharacter(*it);
			if(cp != SKIPPED) {
				if(UTF16Surrogates::encode(cp, findWhatFolded + i))
					i += 2;
				else
					++i;
			}
		}
	}
	const length_t patternLength = complex ? i : findWhat_.length();

	if(lastLiteralPattern_ == 0) {
		const char_t* const pattern = complex ? findWhatFolded : findWhatOrg;
		const_cast<TextSearcher*>(this)->lastLiteralPattern_ =
			new Private::BMSearcher((complex || options_.isEmpty()) ? 0 : this, forward, pattern, pattern + patternLength);
	}

	// Ώە folding
	list<length_t>	shortenedPositions;
	if(complex) {
		i = 0;
		for(const char_t* p = target.first; p < target.last; ++p) {
			const CodePoint cp = UTF16Surrogates::decode(p, target.last - p);
			const CodePoint folded = foldCharacter(cp);
			if(folded != SKIPPED) {
				if(UTF16Surrogates::encode(folded, targetFolded + i))
					i += 2;
				else
					++i;
			} else
				shortenedPositions.push_back(p - target.first);
			if(cp >= 0x10000)
				++p;
		}
	}
	const char_t* const	targetText = complex ? targetFolded : target.first;
	const length_t targetLength = complex ? i : target.last - target.first;

	if(targetLength == 0)
		result.first = result.last = 0;
	else {
		// 
		result.first = forward ? targetText : targetText + targetLength;
		do {
			if(forward)
				result.first = lastLiteralPattern_->search(result.first, targetText + targetLength);
			else
				result.first = lastLiteralPattern_->search(targetText, result.first);

			if(result.first == 0) {	// 1Ȃ
				result.last = 0;
				break;
			}
			result.last = result.first + patternLength;

			// vʒuA镶菜ÖʒuɃ}bv
			for(list<length_t>::const_iterator it = shortenedPositions.begin(); it != shortenedPositions.end(); ++it) {
				if(result.first >= targetText + *it)
					++result.first;
				if(result.last > targetText + *it)
					++result.last;
				else
					break;
			}
			const char_t* const	found = result.first;
			result.first = target.first + (result.first - targetText);
			result.last = target.first + (result.last - targetText);
			if(!options_.wholeWord
					|| (boundary.hasWordBoundaryAt(target.entireFirst, target.entireLast, result.first)
					&& boundary.hasWordBoundaryAt(target.entireFirst, target.entireLast, result.last)))
				break;
			result.first = found + (forward ? 1 : -1);	// PPʂł̌Ɏs蒼
		} while(true);
	}

	delete[] findWhatFolded;
	delete[] targetFolded;
	return (result.first != 0) ? MATCH_TAG : NO_MATCH_TAG;
}

#ifndef ASCENSION_NO_REGEX
template<> SearchResult TextSearcher::doSearch<TextSearcher::REGULAR_EXPRESSION>(
		const SearchTarget& target, bool forward, MatchedRange& result, const BoundaryDetector& boundary) const {
	assert(isRegexAvailable());

	using namespace Private;

	if(options_.type == REGULAR_EXPRESSION) {
		AscensionRegexTraits::lexer_ = &boundary.getLexer();
		AscensionRegexTraits::searcher_ = const_cast<TextSearcher*>(this);
	}

	// p^[̃RpC
	{
		const SearchError result = compileRegexPattern();
		if(result.getCode() != SearchError::SUCCEEDED)
			return result;
	}

	boost::match_flag_type flags =
		static_cast<boost::match_flag_type>(boost::regex_constants::match_default | boost::match_single_line);
	boost::match_results<const char_t*>	results;
	if(forward) {	// O
		result.first = target.first;	// Jnʒu
		flags = static_cast<boost::match_flag_type>((target.last != target.entireLast) ?
			flags | boost::regex_constants::match_not_eol : flags & ~boost::regex_constants::match_not_eol);
		do {
			flags = static_cast<boost::match_flag_type>((result.first != target.entireFirst) ?
				flags | boost::regex_constants::match_not_bol | boost::regex_constants::match_prev_avail
				: flags & ~(boost::regex_constants::match_not_bol | boost::regex_constants::match_prev_avail));

#ifndef ASCENSION_NO_MIGEMO
			if(options_.type == MIGEMO) {
				if(!boost::regex_search(result.first, target.entireLast, results, *lastMigemoPattern_, flags))
					return NO_MATCH_TAG;
			} else {
#endif /* !ASCENSION_NO_MIGEMO */
				try {
					if(!boost::regex_search(result.first, target.entireLast, results, *lastRegexPattern_, flags))
						return NO_MATCH_TAG;
				} catch(runtime_error&) {
					return SearchError(SearchError::RUNTIME_ERROR_FOR_COMPLEXITY);
				}
#ifndef ASCENSION_NO_MIGEMO
			}
#endif /* !ASCENSION_NO_MIGEMO */
			result.first += results.position();
			result.last = result.first + results.length();
			if(!options_.wholeWord	// PPʂŒTꍇ
					|| (boundary.hasWordBoundaryAt(target.entireFirst, target.entireLast, result.first)
					&& boundary.hasWordBoundaryAt(target.entireFirst, target.entireLast, result.last)))
				return MATCH_TAG;
			result.first = result.last;	// ̌Jnʒu
		} while(true);
	} else {	// 
		// }b`Ώې擪ł̂݃}b`悤ɂ
		flags = static_cast<boost::match_flag_type>(flags | boost::match_continuous);

		// ܂ōsɃ}b`Ώۂg債
		for(result.first = target.last - 1; result.first >= target.first; --result.first) {
			flags = static_cast<boost::match_flag_type>((result.first != target.entireFirst) ?
				flags | boost::regex_constants::match_not_bol | boost::regex_constants::match_prev_avail
				: flags & ~(boost::regex_constants::match_not_bol | boost::regex_constants::match_prev_avail));

#ifndef ASCENSION_NO_MIGEMO
			if(options_.type == MIGEMO) {
				if(!boost::regex_search(result.first, target.entireLast, results, *lastMigemoPattern_, flags))
					continue;
			} else {
#endif /* !ASCENSION_NO_MIGEMO */
				try {
					if(!boost::regex_search(result.first, target.entireLast, results, *lastRegexPattern_, flags))
						continue;
				} catch(runtime_error&) {
					return SearchError(SearchError::RUNTIME_ERROR_FOR_COMPLEXITY);
				}
#ifndef ASCENSION_NO_MIGEMO
			}
#endif /* !ASCENSION_NO_MIGEMO */

			assert(results.position() == 0);
			result.last = result.first + results.length();
			if(!options_.wholeWord	// PPʂŒTꍇ
					|| (boundary.hasWordBoundaryAt(target.entireFirst, target.entireLast, result.first)
					&& boundary.hasWordBoundaryAt(target.entireFirst, target.entireLast, result.last)))
				return MATCH_TAG;
		}
	}
	return NO_MATCH_TAG;
}
#endif /* !ASCENSION_NO_REGEX */

#ifndef ASCENSION_NO_MIGEMO
template<> inline SearchResult TextSearcher::doSearch<TextSearcher::MIGEMO>(
		const SearchTarget& target, bool forward, MatchedRange& result, const BoundaryDetector& boundary) const {
	return doSearch<REGULAR_EXPRESSION>(target, forward, result, boundary);
}
#endif /* !ASCENSION_NO_MIGEMO */

/**
 *	s
 *	@param target	ΏەB󕶎񂾂ƏɎsB
 *					̏ꍇA@c first oIʒuA@c last oJnʒu
 *	@param forward	Ȍꍇ true
 *	@param result	[out] ʒuƒ
 *	@param boundary	[in] PꋫE
 *	@return			
 */
SearchResult TextSearcher::search(const SearchTarget& target,
		bool forward, MatchedRange& result, const BoundaryDetector& boundary) const {
	assertValid();
	assert(target.isNormalized());

	if(target.first == target.last)
		return NO_MATCH_TAG;

	// 
#ifndef ASCENSION_NO_REGEX
	if(options_.type == REGULAR_EXPRESSION	// K\g
#ifndef ASCENSION_NO_MIGEMO
			|| (options_.type == MIGEMO && isMigemoAvailable())
#endif /* !ASCENSION_NO_MIGEMO */
	) {
		assert(isRegexAvailable());

		using namespace Private;

		AscensionRegexTraits::lexer_ = &boundary.getLexer();
		AscensionRegexTraits::searcher_ = const_cast<TextSearcher*>(this);

		const SearchError res = compileRegexPattern();
		if(res.getCode() != SearchError::SUCCEEDED)
			return res;
		return doSearch<REGULAR_EXPRESSION>(target, forward, result, boundary);
	} else
#endif  /* !ASCENSION_NO_REGEX */
		return doSearch<LITERAL>(target, forward, result, boundary);
}

/// IvV̐ݒ
void TextSearcher::setOptions(const Options& options) {
	assertValid();
#ifndef ASCENSION_NO_REGEX
	options_.unicodePropertyEnabled = options.unicodePropertyEnabled;
#endif /* !ASCENSION_NO_REGEX */
	if(options != options_) {
		options_ = options;
		changedFromLast_ = true;
		clearPatternCache();
		multilinePattern_ = 
			(options_.type == LITERAL && findWhat_.find(L'\n') != string_t::npos)
			|| (options_.type == REGULAR_EXPRESSION && findWhat_.find(L"\\n") != string_t::npos);
	}
}

/// u̐ݒ
void TextSearcher::setReplaceText(const string_t& text) {
	assertValid();
	replaceWith_ = text;
}

/// ̐ݒ
void TextSearcher::setSearchText(const string_t& text) {
	assertValid();
	if(text != findWhat_) {
		findWhat_ = text;
		changedFromLast_ = true;
		clearPatternCache();
		multilinePattern_ = 
			(options_.type == LITERAL && findWhat_.find(L'\n') != string_t::npos)
			|| (options_.type == REGULAR_EXPRESSION && findWhat_.find(L"\\n") != string_t::npos);
	}
}


// DocumentSearcher
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param document	ΏۃhLg
 *	@param searcher	IuWFNg
 *	@param boundary	PꋫE
 */
DocumentSearcher::DocumentSearcher(const EditDoc& document, const TextSearcher& searcher, const BoundaryDetector& boundary)
	: document_(document), searcher_(searcher), boundary_(boundary) {}

/**
 *	@param target	[in] }b`ΏۃeLXg
 *	@param result	[out] uʂ̃eLXg
 *	@return			}b`̐
 */
SearchResult DocumentSearcher::replace(const TextRange& target, string_t& result) const {
	assertValid();
	if(target.isEmpty())
		return NO_MATCH_TAG;

	const bool multiLineSel = target.getTop().line_ != target.getBottom().line_;
	SearchResult res = NO_MATCH_TAG;

	if(searcher_.isMultilinePattern() == multiLineSel) {
		TextSearcher::MatchTarget matchTarget;

		if(!multiLineSel) {	// }b`Ώۂ1sȓ
			const string_t& line = document_.getLine(target.pos1_.line_);
			matchTarget.entireFirst = line.data();
			matchTarget.entireLast = line.data() + line.length();
			matchTarget.first = line.data() + target.getTop().char_;
			matchTarget.last = line.data() + target.getBottom().char_;
			res = searcher_.replace(matchTarget, result, boundary_);
		} else {	// }b`Ώۂs
			TargetDuplicate* duplicatedTarget =
				new TargetDuplicate(document_, target.getTop().line_, target.getBottom().line_ - target.getTop().line_ + 1);
			matchTarget.entireFirst = duplicatedTarget->getBuffer();
			matchTarget.entireLast = matchTarget.entireFirst + duplicatedTarget->getLength();
			matchTarget.first = matchTarget.entireFirst + target.getTop().char_;
			matchTarget.last = matchTarget.entireLast - (document_.getLineLength(target.getBottom().line_) - target.getBottom().char_);
			res = searcher_.replace(matchTarget, result, boundary_);
			delete duplicatedTarget;
		}
	}
	return res;
}

/**
 *	@param target	[in] ͈
 *	@param forward	[in] Ȍꍇ true
 *	@param result	[out] }b`͈
 *	@retval true	p^[
 *	@retval false	p^[Ȃ (@a result ̓e͖Ӗ)
 */
SearchResult DocumentSearcher::search(const TextRange& target, bool forward, TextRange& result) const {
	assertValid();

	// s}b`̏ꍇ̓p^[̍s𐔂Ă -> Ώە͂̍spӂ
	length_t patternLineCount = 1;
	if(searcher_.isMultilinePattern()) {
		const string_t& pattern = searcher_.getSearchText();
		if(searcher_.getOptions().type == TextSearcher::LITERAL)
			patternLineCount = count(pattern.begin(), pattern.end(), L'\n');
		else {
			assert(searcher_.getOptions().type == TextSearcher::REGULAR_EXPRESSION);
			for(string_t::size_type i = 0; ; ++i, ++patternLineCount) {
				i = pattern.find(L"\\n", i);
				if(i == string_t::npos)
					break;
			}
		}
		assert(patternLineCount > 1);
	}

	const CharPos& begin = forward ? target.getTop() : target.getBottom();
	const CharPos& end = forward ? target.getBottom() : target.getTop();
	for(length_t i = begin.line_, column = begin.char_; ; i += forward ? 1 : -1) {
		TextSearcher::SearchTarget searchTarget;
		TargetDuplicate* duplicatedTarget = 0;

		// Ώە̏
		patternLineCount = min(Private::dif(i, end.line_) + 1, patternLineCount);
		if(patternLineCount == 1) {	// Ps}b`
			const string_t& line = document_.getLine(i);
			searchTarget.entireFirst = line.data();
			searchTarget.entireLast = line.data() + line.length();
		} else {	// s}b` -> obt@ʂɗpӂ
			duplicatedTarget = new TargetDuplicate(document_, forward ? i : i - patternLineCount + 1, patternLineCount);
			searchTarget.entireFirst = duplicatedTarget->getBuffer();
			searchTarget.entireLast = searchTarget.entireFirst + duplicatedTarget->getLength();
		}
		if(forward) {
			searchTarget.first = searchTarget.entireFirst + ((i == begin.line_) ? begin.char_ : 0);
			searchTarget.last = (i + patternLineCount - 1 < end.line_) ?
				searchTarget.entireLast : searchTarget.entireLast - (document_.getLineLength(end.line_) - end.char_);
		} else {
			searchTarget.first = searchTarget.entireFirst + ((i - patternLineCount + 1 > end.line_) ? 0 : end.char_);
			searchTarget.last = searchTarget.entireLast - ((i == begin.line_) ? document_.getLineLength(i) - begin.char_ : 0);
		}

		TextSearcher::MatchedRange matchedRange;
		const SearchResult res = searcher_.search(searchTarget, forward, matchedRange, boundary_);
		if(res) {	// 
			if(!searcher_.isMultilinePattern()) {
				result.pos1_ = CharPos(i, matchedRange.first - searchTarget.entireFirst);
				result.pos2_ = CharPos(i, matchedRange.last - searchTarget.entireFirst);
			} else {
				duplicatedTarget->getResult(matchedRange, result);
				delete duplicatedTarget;
			}
			return res;
		}
		delete duplicatedTarget;
#ifndef ASCENSION_NO_REGEX
		if(res.isFatalError())	// K\G[ -> ss\
			return res;
#endif /* !ASCENSION_NO_REGEX */
		else if(i == end.line_)	// Ȃ
			break;
	}
	return NO_MATCH_TAG;
}

/// RXgN^
DocumentSearcher::TargetDuplicate::TargetDuplicate(const EditDoc& document, length_t startLine, length_t lineCount)
		: lineCount_(lineCount), startLine_(startLine) {
	// obt@̒vZ
	length_ = lineCount_ - 1;
	for(length_t i = startLine_; i < startLine_ + lineCount_; ++i)
		length_ += document.getLineLength(i);
	buffer_ = new char_t[length_];

	// obt@\z (Ώۍs '\n' ŘA)
	char_t* p = buffer_;
	lineHeads_ = new char_t*[lineCount_];
	lineHeads_[0] = buffer_;
	for(length_t i = startLine_; ; ++i) {
		const string_t& s = document.getLine(i);
		wcsncpy(p, s.data(), s.length());
		if(i == startLine_ + lineCount_ - 1)
			break;
		p[s.length()] = L'\n';
		p += s.length() + 1;
		lineHeads_[i - startLine_ + 1] = p;	// s̈ʒuoƂ
	}
}

/// fXgN^
DocumentSearcher::TargetDuplicate::~TargetDuplicate() {
	delete[] buffer_;
	delete[] lineHeads_;
}

/// ւ̃|C^hLgʒuɕϊ
void DocumentSearcher::TargetDuplicate::getResult(const TextSearcher::MatchedRange& range, TextRange& result) const {
	for(result.pos2_.line_ = startLine_ + lineCount_ - 1; ; --result.pos2_.line_) {
		const char_t* const lineHead = lineHeads_[result.pos2_.line_ - startLine_];
		if(range.last >= lineHead) {
			result.pos2_.char_ = range.last - lineHead;
			break;
		}
	}
	for(result.pos1_.line_ = result.pos2_.line_; ; --result.pos1_.line_) {
		const char_t* const lineHead = lineHeads_[result.pos1_.line_ - startLine_];
		if(range.first >= lineHead) {
			result.pos1_.char_ = range.first - lineHead;
			break;
		}
	}
}


// IncrementalSearcher
/////////////////////////////////////////////////////////////////////////////

#define UPDATE_ISEARCH_AND_RETURN()						\
	const SearchResult res = update();					\
	if(eventListener_ != 0)								\
		eventListener_->onISearchPatternChanged(res);	\
	return res

/// ̒~
void IncrementalSearcher::abort() {
	assertValid();
	if(isRunning()) {
		if(eventListener_ != 0)
			eventListener_->onISearchAborted();
		view_->getSelection().select(firstStatus_->range, false, true);
		end();
	}
}

/**
 *	݂̖̌ɕǉ
 *	@param ch	ǉ镶
 *	@return		Č̐
 *	@throw IncrementalSearcher::NotRunningException	łȂꍇX[
 */
SearchResult IncrementalSearcher::addCharacter(char_t ch) {
	assertValid();
	if(!isRunning())
		throw NotRunningException();
	pattern_ += ch;
	operationHistory_.push(TYPE);
	UPDATE_ISEARCH_AND_RETURN();
}


/**
 *	݂̖̌ɕǉ
 *	@param cp	ǉ镶
 *	@return		Č̐
 *	@throw IncrementalSearcher::NotRunningException	łȂꍇX[
 */
SearchResult IncrementalSearcher::addCharacter(CodePoint cp) {
	assertValid();
	if(!isRunning())
		throw NotRunningException();
	if(cp < 0x010000)
		return addCharacter(static_cast<char_t>(cp));

	char_t surrogates[2];
	UTF16Surrogates::encode(cp, surrogates);
	return addString(surrogates, surrogates + 2);
}

/**
 *	݂̖̌ɕǉ
 *	@param first, last				ǉ镶
 *	@return							Č̐
 *	@throw IncrementalSearcher::NotRunningException	łȂꍇX[
 *	@throw std::invalid_argument					񂪋̂ƂX[
 */
SearchResult IncrementalSearcher::addString(const char_t* first, const char_t* last) {
	assertValid();
	assert(first != 0 && last != 0 && first <= last);
	if(!isRunning())
		throw NotRunningException();
	else if(first == last)
		throw invalid_argument("Added string is empty.");
	pattern_.append(first, last);
	for(const char_t* p = first; p < last; ++p)
		operationHistory_.push(TYPE);
	UPDATE_ISEARCH_AND_RETURN();
}

/// ̏I
void IncrementalSearcher::end() {
	assertValid();
	while(!statusHistory_.empty())
		statusHistory_.pop();
	if(eventListener_ != 0)
		eventListener_->onISearchCompleted();
	view_ = 0;
	eventListener_ = 0;
	firstStatus_ = 0;
	lastPattern_ = pattern_;
	pattern_.erase();
}

/**
 *	̃}b`ʒuֈړ
 *	@param forward	V
 *	@return			
 *	@throw IncrementalSearcher::NotRunningException	łȂꍇX[
 */
SearchResult IncrementalSearcher::jumpToNextMatch(bool forward) {
	assertValid();
	if(!isRunning())
		throw NotRunningException();

	if(pattern_.empty()) {
		statusHistory_.top().forward = forward;
		if(!lastPattern_.empty())
			return addString(lastPattern_);	// OĨp^[Ō
		else {
			const SearchResult result = MATCH_TAG;
			if(eventListener_ != 0)
				eventListener_->onISearchPatternChanged(result);
			return result;
		}
	} else if(!matched_
			&& !operationHistory_.empty()
			&& operationHistory_.top() == JUMP
			&& statusHistory_.top().forward == forward)
		return NO_MATCH_TAG;	// }b`ĂȂԂŃWv悤Ƃ
	else {
		const Status status = {TextRange(
			view_->getSelection().getStartPoint(), view_->getSelection().getEndPoint()), forward};
		statusHistory_.push(status);
		operationHistory_.push(JUMP);
		UPDATE_ISEARCH_AND_RETURN();
	}
}

/// ̏Ԃɖ߂
/// @throw CIncrementalSearcher::NotRunningException	łȂꍇX[
void IncrementalSearcher::reset() {
	if(statusHistory_.empty())
		throw NotRunningException();

	while(!operationHistory_.empty())
		operationHistory_.pop();
	while(statusHistory_.size() > 1)
		statusHistory_.pop();
	pattern_.erase();
	view_->getSelection().select(statusHistory_.top().range, false, true);
	if(eventListener_ != 0)
		eventListener_->onISearchPatternChanged(MATCH_TAG);
}

/**
 *	̊Jn
 *	@param view				Ώۃr[
 *	@param type				^Cv
 *	@param forward			̌
 *	@param eventListener	CxgXi (null ł悢)
 */
void IncrementalSearcher::start(EditView& view, TextSearcher::Type type, bool forward, IEventListener* eventListener /* = 0 */) {
	assertValid();
	if(isRunning())
		end();

	const Status status = {TextRange(view.getSelection().getStartPoint(), view.getSelection().getEndPoint()), forward};

	view_ = &view;
	type_ = type;
	statusHistory_.push(status);
	firstStatus_ = &statusHistory_.top();
	if(eventListener_ = eventListener) {
		eventListener_->onISearchStarted();
		eventListener_->onISearchPatternChanged(MATCH_TAG);
	}
}

/**
 *	1̑ȌԂɖ߂
 *	@return	
 *	@throw IncrementalSearcher::NotRunningException			łȂꍇX[
 *	@throw IncrementalSearcher::EmptyUndoBufferException	AhDłȂꍇɌĂяoƃX[
 */
SearchResult IncrementalSearcher::undo() {
	assertValid();
	if(!isRunning())
		throw NotRunningException();
	else if(!canUndo())
		throw EmptyUndoBufferException();

	const Operation lastOperation = operationHistory_.top();

	operationHistory_.pop();
	if(lastOperation == TYPE) {	// ̓͂ɖ߂ -> ̖
		if(pattern_.length() > 1
				&& UTF16Surrogates::isHighSurrogate(pattern_[pattern_.length() - 2])
				&& UTF16Surrogates::isLowSurrogate(pattern_[pattern_.length() - 1]))
			pattern_.erase(pattern_.length() - 2);
		else
			pattern_.erase(pattern_.length() - 1);
		UPDATE_ISEARCH_AND_RETURN();
	} else if(lastOperation == JUMP) {	// ̃}b`ʒuւ̃Wvɖ߂ -> 1ȌԂɖ߂
		const Status lastStatus = statusHistory_.top();

		view_->getSelection().select(lastStatus.range, false, true);
		statusHistory_.pop();
		if(!matched_) {	// Wvɖ߂ƕK}b`ԂɂȂ
			matched_ = true;
			if(eventListener_ != 0)
				eventListener_->onISearchPatternChanged(MATCH_TAG);
		}
		return MATCH_TAG;
	} else
		return SearchResult();	// 蓾
}

/// ݂̏ԂŌ蒼
SearchResult IncrementalSearcher::update() {
	assertValid();
	assert(!statusHistory_.empty());

	if(pattern_.empty()) {
		view_->getSelection().select(firstStatus_->range, false, true);
		matched_ = true;
		return MATCH_TAG;
	}

	const EditDoc&				document = view_->getDocument();
	TextSearcher&				searcher = view_->getTextSearcher();
	TextSearcher::Options		options = searcher.getOptions();
	const TextSearcher::Type	originalType = options.type;
	const DocumentSearcher		dsearch(document, searcher, view_->getBoundaryDetector());
	const Status&				status = statusHistory_.top();

	options.type = type_;
	searcher.setOptions(options);
	searcher.setSearchText(pattern_);

	TextRange matched;
	const TextRange scope(
		status.forward ? status.range.pos2_ : document.getStartPoint(),
		status.forward ? document.getEndPoint() : status.range.pos1_);
	const SearchResult result = dsearch.search(scope, status.forward, matched);

	if(matched_ = result)
		view_->getSelection().select(matched, false, true);

	// ꎞIɕύXIvVɖ߂
	options.type = originalType;
	searcher.setOptions(options);

	return result;
}

#undef UPDATE_ISEARCH_AND_RETURN


// BoundaryDetector
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param lexer NX^鎚͊
 */
BoundaryDetector::BoundaryDetector(const Lexer& lexer) throw() : lexer_(lexer) {
}

/**
 *	@brief 2̃R[h|CgXNvgǂԂ
 *
 *	̃\bh2̃R[h|CgAt@xbgł邱ƂOƂĂA
 *	`FbN͈؍sȂ
 *
 *	X ASCII ͑S Latin XNvgƂĈ
 *
 *	@param cp1, cp2	ׂR[h|Cg (ʒuɒ)
 *	@return			XNvg̏ꍇ true
 */
bool BoundaryDetector::areSameScriptType(CodePoint cp1, CodePoint cp2) {
	const CharProperty::Script s1 = CharProperty::getScript(cp1);
	const CharProperty::Script s2 = CharProperty::getScript(cp2);

	if(s1 == s2
			|| s1 == CharProperty::S_COMMON || s2 == CharProperty::S_COMMON
			|| s1 == CharProperty::S_INHERITED || s2 == CharProperty::S_INHERITED)
		return true;

	// {̑艼?
	// ЉAEłΒPꋫEł͂Ȃ
	else if(PRIMARYLANGID(::GetUserDefaultLangID()) == LANG_JAPANESE
			&& s2 == CharProperty::S_HIRAGANA
			&& (s1 == CharProperty::S_KATAKANA || s1 == CharProperty::S_HAN))
		return true;

	// <> + '['
	else if(s1 == CharProperty::S_HIRAGANA && cp2 == 0x30FC)
		return true;

	return false;
}

/**
 *	PꋫEɎgNXԂ
 *	@param cp	ׂR[h|Cg
 *	@return		PꋫENX
 */
BoundaryDetector::WBClass BoundaryDetector::getWordBoundaryClass(CodePoint cp) const {
	using BoundaryDetector::WBClass;

	const LANGID langID = PRIMARYLANGID(::GetUserDefaultLangID());
	const CharProperty::GeneralCategory	gc = CharProperty::getGeneralCategory(cp);

	if(cp == 0x05F3		// Hebrew Punctuation Geresh
			|| lexer_.isIdentifierStartCodePoint(cp))
		return A_LETTER;
	else if(gc == CharProperty::GC_SEPARATOR_SPACE || cp == L'\t')
		return SPACE;
	else if(cp == 0x002E		// Full Stop
			|| (cp == 0x003A	// Colon (for Swedish)
			&& langID == LANG_SWEDISH))
		return MID_NUM_LET;
	else if(cp == 0x0027		// Apostrophe
			|| cp == 0x00B7		// Middle Dot
			|| cp == 0x05F4		// Hebrew Punctuation Gershayim
			|| cp == 0x2019		// Right Single Quotation Mark
			|| cp == 0x2027		// Hyphenation Point
			|| (cp == 0x0022	// Quotation Mark (for legacy Hebrew)
			&& langID == LANG_HEBREW))
		return MID_LETTER;
	else if(cp == 0x2024		// One Dot Leader
			|| cp == 0x2025		// Two Dot Leader
			|| cp == 0x2026)	// Horizontal Ellipsis
		return MID_NUM;
	else if(gc == CharProperty::GC_OTHER_FORMAT)
		return FORMAT;
	else if(Lexer::isDigit(cp))	// Mathematical digits
		return NUMERIC;
	else
		return OTHER;
}

/**
 *	񂪎wʒuɒPꋫEǂׂ
 *	@param first, last	ׂ镶
 *	@param at			ׂʒu
 *	@return				@a at PꋫȄꍇ true
 */
bool BoundaryDetector::hasWordBoundaryAt(const char_t* first, const char_t* last, const char_t* at) const {
	assertValid();
	assert(first != 0 && last != 0 && at != 0 && first <= last);

	if(at == first || at == last)
		return true;	// (1, 2)
	else if(at < first || at > last)
		return false;	// [

	CodePoint nextCp = UTF16Surrogates::decode(at, last - at);

	if(isGraphemeExtend(nextCp))
		return false;	// (3)

	const WBClass nextClass = getWordBoundaryClass(nextCp);

	if(nextClass == FORMAT)
		return false;	// (4)
	if(nextClass == A_LETTER || nextClass == MID_LETTER
			|| nextClass == MID_NUM_LET || nextClass == MID_NUM || nextClass == NUMERIC) {
		const char_t* prev = at;	// at != first
		CodePoint prevCp;

		while(true) {	// (3)
			if(prev == first) {
				prevCp = 0x0041;	// 芸...
				break;
			} else if(prev - first > 2
					&& UTF16Surrogates::isHighSurrogate(prev[-2])
					&& UTF16Surrogates::isLowSurrogate(prev[-1]))
				prevCp = UTF16Surrogates::decode(prev - 2, 2);
			else
				prevCp = prev[-1];
			prev -= (prevCp > 0xFFFF) ? 2 : 1;
			if(!isGraphemeExtend(prevCp))
				break;
		}
		const WBClass prevClass = getWordBoundaryClass(prevCp);

		if(nextClass == A_LETTER && prevClass == A_LETTER)	// (5+, !13)
			return !areSameScriptType(prevCp, nextCp);
		else if((nextClass == A_LETTER || nextClass == NUMERIC)
				&& (prevClass == A_LETTER || prevClass == NUMERIC))	// (8, 9, 10)
			return false;
		else if((prevClass == A_LETTER && (nextClass == MID_LETTER || nextClass == MID_NUM_LET))
				|| (prevClass == NUMERIC && (nextClass == MID_NUM || nextClass == MID_NUM_LET))) {	// (6, 12)?
			const char_t* nextNext = at + ((nextCp > 0xFFFF) ? 2 : 1);
			CodePoint nextNextCp;

			while(true) {
				if(nextNext == last)
					return true;
				nextNextCp = UTF16Surrogates::decode(nextNext, last - nextNext);
				if(!isGraphemeExtend(nextNextCp))
					break;
			}
			return prevClass == getWordBoundaryClass(nextNextCp);
		} else if(((prevClass == MID_LETTER || prevClass == MID_NUM_LET) && nextClass == A_LETTER)
				|| ((prevClass == MID_NUM || prevClass == MID_NUM_LET) && nextClass == NUMERIC)) {	// (7, 11)?
			const char_t* prevPrev = prev;
			CodePoint prevPrevCp;

			if(prevPrev == first)
				return true;

			while(true) {
				if(prevPrev == first) {
					prevPrevCp = 0x0041;
					break;
				} else if(prevPrev == first + 1)
					prevPrevCp = *first;
				else if(UTF16Surrogates::isHighSurrogate(prevPrev[-2])
						&& UTF16Surrogates::isLowSurrogate(prevPrev[-1]))
					prevPrevCp = UTF16Surrogates::decode(prevPrev - 2, 2);
				else
					prevPrevCp = prevPrev[-1];
				if(!isGraphemeExtend(prevPrevCp))
					break;
				prevPrev -= (prevPrevCp > 0xFFFF) ? 2 : 1;
			}
			return nextClass == getWordBoundaryClass(prevPrevCp);
		}
	}
	return true;
}

/**
 *	NX^̍ŏ̕ɂȂ邩𒲂ׂ (A
 *	ʃTQ[g͒ÕR[h|CgɈˑ邽߂̃\bhłׂ͒Ȃ)
 *	@param cp	ׂR[h|Cg
 *	@return		@a cp NX̐擪̕ɂȂꍇ true
 */
bool BoundaryDetector::isGraphemeExtend(CodePoint cp) {
	// Grapheme_Extend = Me + Mn + Other_Grapheme_Extend
	// NOTE: ȉ͂̃̕\bhł͔łȂA
	// Lbg󂯎ȂقǂȂB
	//   U+17B4: Khmer Vowel Inherent Aq
	//   U+17B5: Khmer Vowel Inherent Aa
	// 2 Unicode 4.1 Ŕ񐄏ƂȂĂ
	//
	// NOTE: ȉ2͔Oɕ (̕ Character Decomposition Mapping  <compat>)A
	// ŏIIȔɂ͐擪̃R[h|CggB
	//	U+0E33: Thai Character Sara Am (=> U+0E4D U+0E32)
	//	U+0EB3: Lao Vowel Sign Am (=> U+0ECD U+0EB2)
	if(cp == 0x0E33)		cp = 0x0E4D;
	else if(cp == 0x0EB3)	cp = 0x0ECD;
	const CharProperty::GeneralCategory	gc = CharProperty::getGeneralCategory(cp);
	return gc == CharProperty::GC_MARK_ENCLOSING
		|| gc == CharProperty::GC_MARK_NONSPACING
		|| gc == CharProperty::GC_MARK_SPACING_COMBINING	// Lbĝ߂̊g
		|| CharProperty::hasBinaryProperty<CharProperty::BP_OTHER_GRAPHEME_EXTEND>(cp);
}

/**
 *	NX^̐擪̕
 *	@param first, last	Ώۂ̕
 *	@param forward		Ȍꍇ true
 *	@return				ʒu (@a pos Ɠł\)
 */
const char_t* BoundaryDetector::searchGraphemeBase(const char_t* first, const char_t* last, bool forward) const {
	assertValid();
	assert(first != 0 && last != 0 && first <= last);

	if(first == last)
		return first;
	else if(forward) {
		const UTF16ToUTF32Iterator end(last);
		for(UTF16ToUTF32Iterator it(++UTF16ToUTF32Iterator(first)); it < end; ++it) {
			if(!isGraphemeExtend(*it))
				return it.tell();
		}
		return last;
	} else {
		const UTF16ToUTF32Iterator end(first);
		for(UTF16ToUTF32Iterator it(--UTF16ToUTF32Iterator(last)); it > end; --it) {
			if(!isGraphemeExtend(*it))
				return it.tell();
		}
		return first;
	}
}

/**
 *	iE
 *	@param first, last	Ώۂ̕
 *	@param start		Jnʒu
 *	@param forward		Ȍꍇ true
 *	@param part			iÊǂ̕邩
 *	@return				ʒu
 */
const char_t* BoundaryDetector::searchParagraphBoundary(
		const char_t* first, const char_t* last, const char_t* start, bool forward, SearchPart part) const {
	assertValid();
	return first;	// 
}

/**
 *	ߋE
 *	@param first, last	Ώۂ̕
 *	@param start		Jnʒu
 *	@param forward		Ȍꍇ true
 *	@param part			ߋÊǂ̕邩
 *	@return				ʒu
 */
const char_t* BoundaryDetector::searchSentenceBoundary(
		const char_t* first, const char_t* last, const char_t* start, bool forward, SearchPart part) const {
	assertValid();
	return first;	// 
}

/**
 *	@brief PꋫE
 *
 *	Ascension ɂPꋫE̒`͂܂m肵ĂȂB
 *	݂̎ BoundarySearcher::isGraphemeBase Ɠ
 *	uUAX #29: Text BoundariesvqgɂĂ邪ÃKChCSɖĂ킯ł͂Ȃ
 *	({ɓɂȂĂ)
 *	@param first, last	Ώۂ̕
 *	@param start		Jnʒu
 *	@param forward		Ȍꍇ true
 *	@param part			PꋫÊǂ̕邩
 *	@return				ʒu
 */
const char_t* BoundaryDetector::searchWordBoundary(
		const char_t* first, const char_t* last, const char_t* start, bool forward, SearchPart part) const {
	assertValid();
	assert(first != 0 && last != 0 && first <= last && start >= first && start <= last);

	// .::.
	// ȉ̃Rg̊ʕt̐ UAX #29 Ɍ鋫EK̂́B
	// !(n) ͋K̗pȂƂA(n)+ ͓YKɓƎ߂{Ƃ\B
	// (0)  Ascension ̒ǉKŁAʂP̐擪AI[AP\ɐꍇɓKpB

	if(first == last /*|| (first >= last - 1 && forward)*/)	// eot (2)
		return first;

	const char_t* p = start;
	WBClass prevClass = UNCALCULATED, nextClass = UNCALCULATED;	// ׂʒȗOA
	CodePoint cp, nextCp = -1, prevCp = -1;

	if(forward) {
		WBClass nextNextClass = UNCALCULATED;	// ׂʒu2
		while(p < last) {
			if(nextCp != -1) {
				cp = nextCp;
				nextCp = -1;
			} else
				cp = UTF16Surrogates::decode(p, last - p);
			if(p == start || (p == first && last != first)) {
				prevClass = getWordBoundaryClass(cp);
				p += (cp > 0xFFFF) ? 2 : 1;
				prevCp = cp;
				continue;
			}
			if(nextClass == UNCALCULATED)
				nextClass = getWordBoundaryClass(cp);

			// Lbg󂯎ȂR[h|Cg͖ (3)
			// Cf R[h|Cg͖ (4)
			if(nextClass == FORMAT || !isGraphemeExtend(cp)) {
				if(prevClass == A_LETTER && nextClass == A_LETTER) {	// (5+, !13)
					if(!areSameScriptType(prevCp, cp))
						return p;
					p += (cp > 0xFFFF) ? 2 : 1;
				} else if((prevClass == A_LETTER || prevClass == NUMERIC)
						&& (nextClass == A_LETTER || nextClass == NUMERIC))	// (8, 9, 10)
					p += (cp > 0xFFFF) ? 2 : 1;
				else if((prevClass == A_LETTER && (nextClass == MID_LETTER /*|| nextClass == MID_NUM_LET*/))	// (6, 7)?
						|| (prevClass == NUMERIC && (nextClass == MID_NUM || nextClass == MID_NUM_LET))) {	// (11, 12)?
					const char_t* const next = p + ((cp > 0xFFFF) ? 2 : 1);

					if(next >= last)
						return p;	// (14)
					nextCp = UTF16Surrogates::decode(next, last - next);
					nextNextClass = getWordBoundaryClass(nextCp);
					if(prevClass != nextNextClass) {	// (14)
						if(!toBoolean(part & ALPHA_NUMERIC)
								|| lexer_.isIdentifierContinueCodePoint(cp)
								|| lexer_.isIdentifierContinueCodePoint(nextCp))
							return p;
					}
					p = next;	// (6, 7, 11, 12)
					nextClass = nextNextClass;
					nextNextClass = UNCALCULATED;
					prevCp = cp;
					cp = nextCp;
					nextCp = -1;
				} else if(((prevClass == MID_LETTER /*|| prevClass == MID_NUM_LET*/) && nextClass == A_LETTER)	// (6)?
						|| ((prevClass == MID_NUM || prevClass == MID_NUM_LET) && nextClass == NUMERIC)) {	// (11)?
					const char_t* prevPrev = p - ((prevCp > 0xFFFF) ? 2 : 1);

					if(prevPrev == first)
						return p;	// (14)
					prevPrev -= (prevPrev > first + 1
							&& UTF16Surrogates::isHighSurrogate(prevPrev[-2])
							&& UTF16Surrogates::isLowSurrogate(prevPrev[-1])) ? 2 : 1;
					const WBClass prevPrevClass = getWordBoundaryClass(UTF16Surrogates::decode(prevPrev, 2));
					if(nextClass != prevPrevClass) {	// (14)
						if(!toBoolean(part & ALPHA_NUMERIC)
								|| lexer_.isIdentifierContinueCodePoint(cp)
								|| lexer_.isIdentifierContinueCodePoint(nextCp))
							return p;
					}
				} else if((!toBoolean(part & END) && nextClass == SPACE)	// (0)
						|| (!toBoolean(part & START) && prevClass == SPACE))	// (0)
					p += (cp > 0xFFFF) ? 2 : 1;
				else if(toBoolean(part & ALPHA_NUMERIC)	// (0)
						&& (!toBoolean(part & START) || !lexer_.isIdentifierContinueCodePoint(cp))
						&& (!toBoolean(part & END) || !lexer_.isIdentifierContinueCodePoint(prevCp)))
					p += (cp > 0xFFFF) ? 2 : 1;
				else
					return p;	// (14)
			} else {
				p += (cp > 0xFFFF) ? 2 : 1;
				nextClass = prevClass;
				cp = prevCp;
			}

			prevClass = nextClass;
			nextClass = nextNextClass;
			nextNextClass = UNCALCULATED;
			prevCp = cp;
		}
		return p;	// (2)
	} else {
		WBClass prevPrevClass = UNCALCULATED;	// ׂʒu2
		while(p > first) {
			bool escapedFromSurrogates = false;
			if(nextCp != -1) {
				cp = nextCp;	// ɂ͗ȂC
				nextCp = -1;
			} else if(p > first + 1
					&& UTF16Surrogates::isLowSurrogate(p[-1])
					&& UTF16Surrogates::isHighSurrogate(p[-2]))
				cp = UTF16Surrogates::decode(p - 2, last - p + 2);
			else {
				cp = UTF16Surrogates::decode(p - 1, last - p + 1);
				if(cp > 0xFFFF) {
					--p;
					escapedFromSurrogates = true;
				}
			}
			if(p == start
					|| (p == last && last != first)
					|| escapedFromSurrogates) {
				nextClass = getWordBoundaryClass(cp);
				p -= (cp > 0xFFFF) ? 2 : 1;
				prevCp = cp;
				continue;
			}
			if(prevClass == UNCALCULATED)
				prevClass = getWordBoundaryClass(cp);

			// Lbg󂯎ȂR[h|Cg͖ (3)
			// Cf R[h|Cg͖ (4)
			if(prevClass == FORMAT || !isGraphemeExtend(cp)) {
				if(prevClass == A_LETTER && nextClass == A_LETTER) {	// (5+, !13)
					if(!areSameScriptType(cp, prevCp))
						return p;
					p -= (cp > 0xFFFF) ? 2 : 1;
				} else if((prevClass== A_LETTER || prevClass == NUMERIC)	// (8, 9, 10)
						&& (nextClass == A_LETTER || nextClass == NUMERIC))
					p -= (cp > 0xFFFF) ? 2 : 1;
				else if((nextClass == A_LETTER && (prevClass == MID_LETTER /*|| prevClass == MID_NUM_LET*/))	// (6, 7)?
						|| (nextClass == NUMERIC && (prevClass == MID_NUM || prevClass == MID_NUM_LET))) {	// (11, 12)?
					const char_t*  next = p - ((cp > 0xFFFF) ? 2 : 1);

					if(next == first)
						return p;	// (14)
					next -= (next > first + 1
						&& UTF16Surrogates::isHighSurrogate(next[-2])
						&& UTF16Surrogates::isLowSurrogate(next[-1])) ? 2 : 1;
					nextCp = UTF16Surrogates::decode(next, last - next);
					prevPrevClass = getWordBoundaryClass(nextCp);
					if(prevClass != prevPrevClass) {
						if(!toBoolean(part & ALPHA_NUMERIC)
								|| lexer_.isIdentifierContinueCodePoint(cp)
								|| lexer_.isIdentifierContinueCodePoint(nextCp))
							return p;	// (14)
					}
					p = next;	// (6, 7, 11, 12)
					prevClass = prevPrevClass;
					prevPrevClass = UNCALCULATED;
					prevCp = cp;
					cp = nextCp;
					nextCp = -1;
				} else if((prevClass == A_LETTER && (nextClass == MID_LETTER/*|| nextClass == MID_NUM_LET*/))	// (7)?
						|| (prevClass == NUMERIC && (nextClass == MID_NUM || nextClass == MID_NUM_LET))) {	// (12)?
					const char_t* const nextNext = p + ((prevCp > 0xFFFF) ? 2 : 1);

					if(nextNext >= last)
						return p;	// (14)
					const CodePoint prevPrevCp = 
						UTF16Surrogates::decode(nextNext, last - nextNext);
					const WBClass nextNextClass = getWordBoundaryClass(prevPrevCp);
					if(prevClass != nextNextClass) {	// (14)
						if(!toBoolean(part & ALPHA_NUMERIC)
								|| lexer_.isIdentifierContinueCodePoint(cp)
								|| lexer_.isIdentifierContinueCodePoint(prevCp))
							return p;
					}
				} else if((!toBoolean(part & END) && nextClass == SPACE)	// (0)
						|| (!toBoolean(part & START) && prevClass == SPACE))	// (0)
					p -= (cp > 0xFFFF) ? 2 : 1;
				else if(toBoolean(part & ALPHA_NUMERIC)	// (0)
						&& (!toBoolean(part & START) || !lexer_.isIdentifierContinueCodePoint(prevCp))
						&& (!toBoolean(part & END) || !lexer_.isIdentifierContinueCodePoint(cp)))
					p -= (cp > 0xFFFF) ? 2 : 1;
				else
					return p;
			} else {
				p -= (cp > 0xFFFF) ? 2 : 1;
				prevClass = nextClass;
				cp = prevCp;
			}

			nextClass = prevClass;
			prevClass = prevPrevClass;
			prevPrevClass = UNCALCULATED;
			prevCp = cp;
		}
		return p;	// (2)
	}
}


// DocumentBoundaryDetector
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param document ΏۃhLg
 */
DocumentBoundaryDetector::DocumentBoundaryDetector(const Lexer& lexer, const EditDoc& document) throw()
		: BoundaryDetector(lexer), document_(document) {
}

/**
 *	NX^̐擪̕
 *	@param pos		Jnʒu
 *	@param forward	O (hLg̏I[) ̏ꍇ true
 *	@return			ʒu (@a pos Ɠł\)
 *	@throw std::invalid_argument	@a pos sȈʒuł΃X[
 */
CharPos	DocumentBoundaryDetector::searchGraphemeBase(const CharPos& pos, bool forward) const {
	assertValid();

	if(pos.char_ == 0 && !forward) {	// sނꍇ
		if(pos.line_ == 0)	// hLg̐擪łΈړȂ
			return pos;
		return CharPos(pos.line_ - 1, document_.getLineLength(pos.line_ - 1));	// 1O̍sɖ߂
	}

	const length_t lineCount = document_.getLineCount();
	const string_t& line = document_.getLine(pos.line_);

	if(pos.line_ >= lineCount || pos.char_ > line.length())
		throw invalid_argument("Invalid position.");
	else if(pos.char_ == line.length() && pos.line_ < lineCount - 1 && forward)	// s -> ̍s
		return CharPos(pos.line_ + 1, 0);

	const char_t* p = line.data();
	return forward ?
		CharPos(pos.line_, BoundaryDetector::searchGraphemeBase(p + pos.char_, p + line.length(), true) - p)
		: CharPos(pos.line_, BoundaryDetector::searchGraphemeBase(p, p + pos.char_, false) - p);
}

/**
 *	iE
 *	@param pos		Jnʒu
 *	@param forward	O (hLg̏I[) ̏ꍇ true
 *	@param part		iÊǂ̕邩
 *	@return			ʒu
 */
CharPos	DocumentBoundaryDetector::searchParagraphBoundary(const CharPos& pos, bool forward, SearchPart part) const {
	return pos;
}

/**
 *	ߋE
 *	@param pos		Jnʒu
 *	@param forward	O (hLg̏I[) ̏ꍇ true
 *	@param part		ߋÊǂ̕邩
 *	@return			ʒu
 */
CharPos	DocumentBoundaryDetector::searchSentenceBoundary(const CharPos& pos, bool forward, SearchPart part) const {
	return pos;
}

/**
 *	@brief PꋫE
 *
 *	ʒu͌JnʒuƂ͈قȂʒuɂȂ
 *	(hLg̐擪ȀꍇȊO)
 *
 *	PꋫE̊TO͒PPʂ̈ړR}h (CaretMovementCommand)
 *	_uNbNɂJ[\ʒu̒PIȂǂɎgp *
 *	@param pos		Jnʒu
 *	@param forward	O (hLg̏I[) ̏ꍇ true
 *	@param part		PꋫÊǂ̕邩
 *	@return			ʒu
 */
CharPos	DocumentBoundaryDetector::searchWordBoundary(const CharPos& pos, bool forward, SearchPart part) const {
	assertValid();

	const bool restrictionEffective = document_.isNarrowed() && toBoolean(part & RESTRICTION_EFFECTIVE);
	const CharPos top = document_.getStartPoint();
	const CharPos bottom = document_.getEndPoint();
	CharPos foundPos = pos;

	if(restrictionEffective) {	// i[CO̐̈ -> Ȃ
		if(pos < top
				|| pos > bottom
				|| (!forward && pos == top)
				|| (forward && pos == bottom))
			return pos;
	}

	if(pos.char_ == 0 && !forward) {	// sO̍sɖ߂낤ƂĂ
		if(pos.line_ == 0 || toBoolean(part & ONLY_CURRENT_LINE))
			return pos;
		foundPos.char_ = document_.getLineLength(--foundPos.line_);
		if(!toBoolean(part & START))
			return foundPos;
	} else if(forward	// s玟̍sɐiƂĂ
			&& pos.char_ == document_.getLineLength(pos.line_)) {
		if(pos.line_ == document_.getLineCount() - 1 || toBoolean(part & ONLY_CURRENT_LINE))
			return pos;
		++foundPos.line_;
		const char_t* const p = document_.getLine(foundPos.line_).data();
		const length_t lineLength =
			(restrictionEffective && foundPos.line_ == bottom.line_) ?
			bottom.char_ : document_.getLineLength(foundPos.line_);
		foundPos.char_ = getLexer().eatWhiteSpaces(p, p + lineLength, true) - p;
		if(toBoolean(part & START)) {
			if(toBoolean(part & ALPHA_NUMERIC) && foundPos.char_ < lineLength) {
				const CodePoint cp = UTF16Surrogates::decode(
					document_.getLine(foundPos.line_).data() + foundPos.char_ , lineLength - foundPos.char_);
				if(getLexer().isIdentifierContinueCodePoint(cp))
					return foundPos;
			} else
				return foundPos;
		}
	}

	const string_t& line = document_.getLine(foundPos.line_);

	// ׂs̐擪ʒuƏI[ʒuBi[COɂsŜ苷ȂĂ
	return CharPos(foundPos.line_, BoundaryDetector::searchWordBoundary(
		line.data() + ((restrictionEffective && foundPos.line_ == top.line_) ? top.char_ : 0),
		line.data() + ((restrictionEffective && foundPos.line_ == bottom.line_) ? bottom.char_ : line.length()),
		line.data() + foundPos.char_, forward, part) - line.data());
}

#undef MATCH_TAG
#undef NO_MATCH_TAG
#undef MAKE_REGEX_ERROR

/* [EOF] */