// UnicodeUtils.cpp
// (c) 2005 exeal

#include "StdAfx.h"
#include "UnicodeUtils.h"
using namespace Ascension;

#include "code-table\UnicodeProperties_Table"

bool CharProperty::hasBinaryProperty(CodePoint cp, BinaryProperty property) {
	switch(property) {
	case BP_ALPHABETIC:							return hasBinaryProperty<BP_ALPHABETIC>(cp);
	case BP_ASCII_HEX_DIGIT:					return hasBinaryProperty<BP_ASCII_HEX_DIGIT>(cp);
	case BP_BIDI_CONTROL:						return hasBinaryProperty<BP_BIDI_CONTROL>(cp);
//	case BP_BIDI_MIRRORED:						return hasBinaryProperty<BP_BIDI_MIRRORED>(cp);
//	case BP_COMPOSITION_EXCLUSION:				return hasBinaryProperty<BP_COMPOSITION_EXCLUSION>(cp);
	case BP_DASH:								return hasBinaryProperty<BP_DASH>(cp);
	case BP_DEFAULT_IGNORABLE_CODE_POINT:		return hasBinaryProperty<BP_DEFAULT_IGNORABLE_CODE_POINT>(cp);
	case BP_DEPRECATED:							return hasBinaryProperty<BP_DEPRECATED>(cp);
	case BP_DIACRITIC:							return hasBinaryProperty<BP_DIACRITIC>(cp);
//	case BP_EXPANDS_ON_NFC:						return hasBinaryProperty<BP_EXPANDS_ON_NFC>(cp);
//	case BP_EXPANDS_ON_NFD:						return hasBinaryProperty<BP_EXPANDS_ON_NFD>(cp);
//	case BP_EXPANDS_ON_NFKC:					return hasBinaryProperty<BP_EXPANDS_ON_NFKC>(cp);
//	case BP_EXPANDS_ON_NFKD:					return hasBinaryProperty<BP_EXPANDS_ON_NFKD>(cp);
	case BP_EXTENDER:							return hasBinaryProperty<BP_EXTENDER>(cp);
//	case BP_FULL_COMPOSITION_EXCLUSION:			return hasBinaryProperty<BP_FULL_COMPOSITION_EXCLUSION>(cp);
	case BP_GRAPHEME_BASE:						return hasBinaryProperty<BP_GRAPHEME_BASE>(cp);
	case BP_GRAPHEME_EXTEND:					return hasBinaryProperty<BP_GRAPHEME_EXTEND>(cp);
	case BP_GRAPHEME_LINK:						return hasBinaryProperty<BP_GRAPHEME_LINK>(cp);
	case BP_HEX_DIGIT:							return hasBinaryProperty<BP_HEX_DIGIT>(cp);
	case BP_HYPHEN:								return hasBinaryProperty<BP_HYPHEN>(cp);
//	case BP_ID_CONTINUE:						return hasBinaryProperty<BP_ID_CONTINUE>(cp);
//	case BP_ID_START:							return hasBinaryProperty<BP_ID_START>(cp);
	case BP_IDEOGRAPHIC:						return hasBinaryProperty<BP_IDEOGRAPHIC>(cp);
	case BP_IDS_BINARY_OPERATOR:				return hasBinaryProperty<BP_IDS_BINARY_OPERATOR>(cp);
	case BP_IDS_TRINARY_OPERATOR:				return hasBinaryProperty<BP_IDS_TRINARY_OPERATOR>(cp);
	case BP_JOIN_CONTROL:						return hasBinaryProperty<BP_JOIN_CONTROL>(cp);
	case BP_LOGICAL_ORDER_EXCEPTION:			return hasBinaryProperty<BP_LOGICAL_ORDER_EXCEPTION>(cp);
	case BP_LOWERCASE:							return hasBinaryProperty<BP_LOWERCASE>(cp);
	case BP_MATH:								return hasBinaryProperty<BP_MATH>(cp);
	case BP_NONCHARACTER_CODE_POINT:			return hasBinaryProperty<BP_NONCHARACTER_CODE_POINT>(cp);
	case BP_OTHER_ALPHABETIC:					return hasBinaryProperty<BP_OTHER_ALPHABETIC>(cp);
	case BP_OTHER_DEFAULT_IGNORABLE_CODE_POINT:	return hasBinaryProperty<BP_OTHER_DEFAULT_IGNORABLE_CODE_POINT>(cp);
	case BP_OTHER_GRAPHEME_EXTEND:				return hasBinaryProperty<BP_OTHER_GRAPHEME_EXTEND>(cp);
	case BP_OTHER_ID_CONTINUE:					return hasBinaryProperty<BP_OTHER_ID_CONTINUE>(cp);
	case BP_OTHER_ID_START:						return hasBinaryProperty<BP_OTHER_ID_START>(cp);
	case BP_OTHER_LOWERCASE:					return hasBinaryProperty<BP_OTHER_LOWERCASE>(cp);
	case BP_OTHER_MATH:							return hasBinaryProperty<BP_OTHER_MATH>(cp);
	case BP_OTHER_UPPERCASE:					return hasBinaryProperty<BP_OTHER_UPPERCASE>(cp);
	case BP_PATTERN_SYNTAX:						return hasBinaryProperty<BP_PATTERN_SYNTAX>(cp);
	case BP_PATTERN_WHITE_SPACE:				return hasBinaryProperty<BP_PATTERN_WHITE_SPACE>(cp);
	case BP_QUOTATION_MARK:						return hasBinaryProperty<BP_QUOTATION_MARK>(cp);
	case BP_RADICAL:							return hasBinaryProperty<BP_RADICAL>(cp);
	case BP_SOFT_DOTTED:						return hasBinaryProperty<BP_SOFT_DOTTED>(cp);
	case BP_STERM:								return hasBinaryProperty<BP_STERM>(cp);
	case BP_TERMINAL_PUNCTUATION:				return hasBinaryProperty<BP_TERMINAL_PUNCTUATION>(cp);
	case BP_UNIFIED_IDEOGRAPH:					return hasBinaryProperty<BP_UNIFIED_IDEOGRAPH>(cp);
	case BP_UPPERCASE:							return hasBinaryProperty<BP_UPPERCASE>(cp);
	case BP_VARIATION_SELECTOR:					return hasBinaryProperty<BP_VARIATION_SELECTOR>(cp);
	case BP_WHITE_SPACE:						return hasBinaryProperty<BP_WHITE_SPACE>(cp);
//	case BP_XID_CONTINUE:						return hasBinaryProperty<BP_XID_CONTINUE>(cp);
//	case BP_XID_START:							return hasBinaryProperty<BP_XID_START>(cp);
	default:									return false;
	}
}


/* [EOF] */