#!/usr/local/bin/perl

# gc.pl (c) 2003-2005 exeal
# UnicodeData.txt から指定した一般分類に属する
# コードポイントのカンマ区切りのリスト (8つごとに改行が入る) を生成する。
# 引数は1つか2つ:
#
#   gc.pl <category>
#
# "category" は以下の中から選択するか、有効な一般分類名 (2文字):
#
#   mark -- Mn, Mc, Me
#   numeric -- Nd, Nl, No
#   space -- Zs
#   format -- Cf
#   id_continue -- Mn, Mc, Nd, Pc
#   punctuation -- Pc, Pd, Ps, Pe, Pi, Pf, Po
#   symbol -- Sm, Sc, Sk, So
#   control -- Cc, Cf
#
# 出力先は標準出力。

use strict;
use integer;

# show usage and abort
sub usage($) {
	die("\n" . shift() . "\nUsage: gc.pl <category>\n\n");
}

my $fileName = 'UnicodeData.txt';
my $pattern;

usage("Bad parameter number.") if($#ARGV != 0);
if($ARGV[0] eq 'mark') {
	$pattern = '(Mn)|(Mc)|(Me)';
} elsif($ARGV[0] eq 'numeric') {
	$pattern = '(Nd)|(Nl)|(No)';
} elsif($ARGV[0] eq 'space') {
	$pattern = 'Zs';
} elsif($ARGV[0] eq 'format') {
	$pattern = 'Cf';
} elsif($ARGV[0] eq 'id_continue') {
	$pattern = '(Mn)|(Mc)|(Nd)|(Pc)';
} elsif($ARGV[0] eq 'punctuation') {
	$pattern = '(Pc)|(Pd)|(Ps)|(Pe)|(Pi)|(Pf)|(Po)';
} elsif($ARGV[0] eq 'symbol') {
	$pattern = '(Sm)|(Sc)|(Sk)|(So)';
} elsif($ARGV[0] eq 'control') {
	$pattern = '(Cc)|(Cf)';
} else {
	$pattern = $ARGV[0];
}

my $matchCount = 0;

while(<STDIN>) {
	next unless(/^([\dA-Fa-f]+?)\;.+?\;(\w\w)/);
	my $cp = $1;
	if($2 =~ m/$pattern/) {
		print(($matchCount++ % 8 == 0) ? "\n" : " ");
		print("0x$cp,");
	}
}

# print "\n$matchCount characters output.\n\n";

__END__