#!/usr/local/bin/perl

use strict;
use integer;

my $prefix = shift @ARGV;
my $lastValue = '';
my $lastBegin = -1;
my $lastEnd = -1;

die 'usage: scripts.pl <prefix>' if($prefix eq '');

while(<STDIN>) {
	next unless(/^([\S]+?)\s*\;\s(\w+)/);
	my $value = $2;
	my ($begin, $end);
	if($1 =~ /(\w+)\.\.(\w+)/) {	# range
		$begin = $1;
		$end = $2;
	} else {	# single
		$begin = $end = $1;
	}
	if(hex($begin) != $lastEnd + 1 or $value ne $lastValue) {	# not continued
		printf "{0x%06X,0x%06X,%s%s},\n", $lastBegin, $lastEnd, $prefix, uc($lastValue) if($lastValue ne '');
		$lastBegin = hex $begin;
		$lastEnd = hex $end;
		$lastValue = $value;
	} else {
		$lastEnd = hex $end;
	}
}

__END__