// BookmarkDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "BookmarkDlg.h"
#include "CommandManager.h"
#include "../Manah/CommonControls.hpp"

using Alpha::BookmarkDlg;
using Alpha::AlphaApp;
using Alpha::AlphaDoc;
using namespace Manah::Windows::Controls;
using namespace Ascension;
using namespace std;


/// RXgN^
BookmarkDlg::BookmarkDlg(AlphaApp& app) : app_(app) {
}

/**
 *	w肵ʒu̍ڏ𓾂
 *	@param index	ڂ̈ʒu
 *	@param buffer	[out] obt@
 *	@param line		[out] sԍ (0x[X)
 */
void BookmarkDlg::getItemInfo(int index, AlphaDoc*& buffer, length_t& line) const {
	assertValid();

	wchar_t location[300];
	wchar_t* delimiter = 0;

	assert(index < bookmarksList_.getItemCount());
	bookmarksList_.getItemText(index, 1, location, 300);
	buffer = reinterpret_cast<AlphaDoc*>(bookmarksList_.getItemData(index));

	delimiter = wcsrchr(location, L'(');
	assert(delimiter != 0);
	line = wcstoul(delimiter + 1, 0, 10);
	--line;
}

/// [폜] {^̏
void BookmarkDlg::onBtnDelete() {
	const int sel = bookmarksList_.getSelectionMark();

	if(sel == -1)	// I
		return;

	AlphaDoc* buffer;
	length_t line;

	getItemInfo(sel, buffer, line);
	if(bufferIndices_.find(buffer) == bufferIndices_.end())
		return;

	buffer->getView(0).getBookmarker().setBookmark(line, false);
	bookmarksList_.deleteItem(sel);
	if(bookmarksList_.getItemCount() != 0) {
		bookmarksList_.setItemState(0, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
	} else {
		::EnableWindow(getDlgItem(IDOK), false);
		::EnableWindow(getDlgItem(IDC_BTN_DELETE), false);
	}
}

/// ubN}[NXg̍XV
void BookmarkDlg::updateList() {
	const BufferList& buffers = app_.getBufferList();
	list<length_t> lines;
	char_t location[300];
	int item = 0;

	bufferIndices_.clear();
	bookmarksList_.deleteAllItems();

	if(isDlgButtonChecked(IDC_CHK_SHOWALLFILES) == BST_CHECKED) {	// SẴhLgꍇ
		for(size_t i = 0; i < buffers.getCount(); ++i) {
			const AlphaDoc& buffer = buffers.getAt(i);
			const AlphaView& view = buffers.getActiveView();
			const length_t lineOffset = view.getLayoutSetter().getSettings().lineNumberLayout.startLine;
			const length_t topLine = buffer.getStartPoint().line_;
			const length_t bottomLine = buffer.getEndPoint().line_;
			length_t line = -1;

			while((line = view.getBookmarker().getNextBookmark(line)) != -1) {
				if(line >= topLine && line <= bottomLine) {
					string_t s = buffer.getLine(line).substr(0, 100);

					++item;
					replace_if(s.begin(), s.end(), bind2nd(equal_to<wchar_t>(), L'\t'), L' ');
					item = bookmarksList_.insertItem(item, s.c_str());
					swprintf(location, L"%s(%lu)", buffer.getFileName(), line + lineOffset);
					bookmarksList_.setItemText(item, 1, location);
					bookmarksList_.setItemData(item, static_cast<DWORD>(reinterpret_cast<DWORD_PTR>(&buffer)));
					bufferIndices_[const_cast<AlphaDoc*>(&buffer)] = i;
				}
			}
		}
	} else {
		// ANeBuȃhLgΏۂɂꍇ
		const AlphaView& activeView = app_.getBufferList().getActiveView();
		const AlphaDoc& activeBuffer = activeView.getDocument();
		const length_t lineOffset = activeView.getLayoutSetter().getSettings().lineNumberLayout.startLine;
		const length_t topLine = activeBuffer.getStartPoint().line_;
		const length_t bottomLine = activeBuffer.getEndPoint().line_;
		length_t line = -1;

		while((line = activeView.getBookmarker().getNextBookmark(line)) != -1) {
			if(line >= topLine && line <= bottomLine) {
				string_t s = activeBuffer.getLine(line).substr(0, 100);

				++item;
				replace_if(s.begin(), s.end(), bind2nd(equal_to<wchar_t>(), L'\t'), L' ');
				item = bookmarksList_.insertItem(item, s.c_str());
				swprintf(location, L"%s(%lu)", activeBuffer.getFileName(), line + lineOffset);
				bookmarksList_.setItemText(item, 1, location);
				bookmarksList_.setItemData(item, static_cast<DWORD>(reinterpret_cast<DWORD_PTR>(&activeBuffer)));
			}
		}
		bufferIndices_[const_cast<AlphaDoc*>(&activeBuffer)] = app_.getBufferList().getActiveIndex();
	}

	if(bookmarksList_.getItemCount() != 0) {
		bookmarksList_.setItemState(0, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
		::EnableWindow(getDlgItem(IDOK), true);
		::EnableWindow(getDlgItem(IDC_BTN_DELETE), true);
	} else {
		::EnableWindow(getDlgItem(IDOK), false);
		::EnableWindow(getDlgItem(IDC_BTN_DELETE), false);
	}
}

/// @see Dialog::onClose
void BookmarkDlg::onClose() {
	app_.writeIntegerProfile(L"Search", L"BookmarkDialog.autoClose",
		(isDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED) ? 1 : 0);
	app_.writeIntegerProfile(L"Search", L"BookmarkDialog.allBuffers",
		(isDlgButtonChecked(IDC_CHK_SHOWALLFILES) == BST_CHECKED) ? 1 : 0);
	Dialog::onClose();
}

/// @see Dialog::onCommand
bool BookmarkDlg::onCommand(WORD id, WORD notifyCode, HWND control) {
	switch(id) {
	case IDC_BTN_ADD:	// [ǉ]
		app_.getBufferList().getActiveView().getBookmarker().setBookmark(
			app_.getBufferList().getActiveView().getSelection().getActivePoint().getLineNumber(), true);
		updateList();
		break;
	case IDC_BTN_DELETE:	// [폜]
		onBtnDelete();
		break;
	case IDC_BTN_UPDATE:	// [XV]
	case IDC_CHK_SHOWALLFILES:	// [JĂSẴhLg\]
		updateList();
		break;
	}
	return Dialog::onCommand(id, notifyCode, control);
}

/// @see Dialog::onInitDialog
bool BookmarkDlg::onInitDialog(HWND focusWindow, LPARAM initParam) {
	Dialog::onInitDialog(focusWindow, initParam);

	modifyStyleEx(0, WS_EX_LAYERED);
	setLayeredWindowAttributes(0, 220, LWA_ALPHA);

	bookmarksList_.modifyStyleEx(WS_EX_NOPARENTNOTIFY, 0);
	bookmarksList_.setExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);
	bookmarksList_.insertColumn(0, app_.loadString(MSG_LINE).c_str(), LVCFMT_LEFT, 279, -1);
	bookmarksList_.insertColumn(1, app_.loadString(MSG_POSITION).c_str(), LVCFMT_LEFT, 100, -1);
	updateList();

	if(app_.readIntegerProfile(L"Search", L"BookmarkDialog.autoClose", 0) == 1)
		checkDlgButton(IDC_CHK_AUTOCLOSE, BST_CHECKED);
	if(app_.readIntegerProfile(L"Search", L"BookmarkDialog.allBuffers", 0) == 1)
		checkDlgButton(IDC_CHK_SHOWALLFILES, BST_CHECKED);

	return true;
}

/// @see Dialog::onNotify
bool BookmarkDlg::onNotify(int id, LPNMHDR nmhdr) {
	if(id== IDC_LIST_BOOKMARKS && nmhdr->code == NM_DBLCLK) {
		onOK();
		return true;
	}
	return Dialog::onNotify(id, nmhdr);
}

/// @see Dialog::OnOK
void BookmarkDlg::onOK() {
	// ꎞ}N`͎słȂ
	if(app_.getCommandManager().getTemporaryMacro().getState() == TemporaryMacro::DEFINING) {
		app_.messageBox(MSG_PROHIBITED_FOR_MACRO_DEFINING, MB_ICONEXCLAMATION);
		return;
	}

	const int sel = bookmarksList_.getSelectionMark();

	if(sel == -1)	// I
		return;

	AlphaDoc* buffer;
	length_t line;

	getItemInfo(sel, buffer, line);
	if(bufferIndices_.find(buffer) == bufferIndices_.end())
		return;

	app_.getBufferList().getActiveView().getSelection().moveTo(CharPos(line, 0), true);
	app_.getBufferList().setActive(bufferIndices_[buffer]);
	getParent().setActiveWindow();

	if(isDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [Iɕ]
		Dialog::onOK();
}

/* [EOF] */