// BookmarkDlg.h
// (c) 2003-2005 exeal

#ifndef BOOKMARK_DLG_H_
#define BOOKMARK_DLG_H_
#include "resource.h"
#include "Ascension\AscensionCommon.h"
#include "../Manah/Dialog.hpp"
#include <map>


namespace Alpha {
	class AlphaApp;
	class AlphaDoc;

	///	[ubN}[N] _CAO
	class BookmarkDlg : public Manah::Windows::Controls::Layered<
			Manah::Windows::Controls::FixedIDDialog<IDD_DLG_BOOKMARKS> > {
		// RXgN^
	public:
		BookmarkDlg(AlphaApp& app);

		// \bh
	public:
		void	updateList();
	private:
		void	getItemInfo(int index, AlphaDoc*& buffer, Ascension::length_t& line) const;
		void	onBtnDelete();

		// bZ[Wnh
	protected:
		void	onClose();											// WM_CLOSE
		bool	onCommand(WORD id, WORD notifyCode, HWND control);	// WM_COMMAND
		bool	onInitDialog(HWND focusWindow, LPARAM initParam);	// WM_INITDIALOG
		bool	onNotify(int id, LPNMHDR nmhdr);					// WM_NOTIFY
		void	onOK();												// IDOK

		// f[^o
	private:
		AlphaApp& app_;
		std::map<AlphaDoc*, std::size_t> bufferIndices_;	// obt@ -> obt@ԍ
		Manah::Windows::Controls::ListCtrl bookmarksList_;

		BEGIN_CONTROL_BINDING()
			BIND_CONTROL(IDC_LIST_BOOKMARKS, bookmarksList_)
		END_CONTROL_BINDING()
	};
}

#endif /* BOOKMARK_DLG_H_ */

/* [EOF] */