// BufferList.cpp
// (c) 2004-2006 exeal

#include "StdAfx.h"
#include "Alpha.h"
#include "AlphaDoc.h"
#include "Ambient.h"	// Ambient::EditorPane
#include "CodePagesDlg.h"
#include "ConfirmUnsavedDocumentDlg.h"
#include "MRUManager.h"
#include "NewFileFormatDlg.h"
#include "../Manah/WaitCursor.hpp"
#include "../Armaiti/ComBasic.hpp"
#include <commdlg.h>	// OPENFILENAME
#include <shlwapi.h>	// PathXxxx, StrXxxx
#include <shobjidl.h>	// IShellLink
#include <shlguid.h>	// CLSID_ShellLink
#include <dlgs.h>

using namespace Alpha;
using namespace std;
using namespace Ascension;
using namespace Encodings;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Windows::Controls;
using Armaiti::ComPtr;


namespace {
	struct TextFileFormat {
		CodePage encoding;
		Ascension::LineBreak lineBreak;
	};
	class FileIOCallback : virtual public EditDoc::IFileIOListener {
	public:
		FileIOCallback(AlphaApp& app, bool forLoading, const WCHAR* fileName, CodePage encoding) throw()
				: app_(app), forLoading_(forLoading), fileName_(fileName),
				encoding_(encoding), retryWithOtherCodePage_(false) {}
		bool doesUserWantToChangeCodePage() const throw() {
			return retryWithOtherCodePage_;
		}
		bool onFoundUnconvertableCharacter() {
			const int answer = app_.messageBox(forLoading_ ?
				MSG_UNCONVERTABLE_NATIVE_CHAR : MSG_UNCONVERTABLE_UCS_CHAR, MB_YESNOCANCEL | MB_ICONEXCLAMATION,
				MARGS % fileName_ % AlphaApp::getInstance().getCodePageName(encoding_)->c_str());
			if(answer == IDYES)
				retryWithOtherCodePage_ = true;
			return answer == IDNO;
		}
		EditDoc::IFileIOProgressListener* queryProgressCallback() {return 0;}
	private:
		AlphaApp& app_;
		const bool forLoading_;
		const WCHAR* const fileName_;
		const CodePage encoding_;
		bool retryWithOtherCodePage_;
	};
} // namespace @0


// EditorPane class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
EditorPane::EditorPane(AlphaView* initialView /* = 0 */) : visibleView_(initialView), lastVisibleView_(0), automation_(0) {
	if(initialView != 0)
		addView(*initialView);
}

/// Rs[RXgN^
EditorPane::EditorPane(const EditorPane& rhs) : automation_(0) {
	for(set<AlphaView*>::const_iterator it = rhs.views_.begin(); it != rhs.views_.end(); ++it) {
		AlphaView* view = new AlphaView(*(*it));
		view->detach();	// <-- dv
		const bool succeeded = view->create((*it)->getParent(), DefaultWindowRect(),
			WS_CHILD | WS_CLIPCHILDREN | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_CLIENTEDGE);
		assert(succeeded);
		views_.insert(view);
		if(*it == rhs.visibleView_)
			visibleView_ = view;
		if(*it == rhs.lastVisibleView_)
			lastVisibleView_ = view;
	}
}

/// fXgN^
EditorPane::~EditorPane() {
	removeAll();
	if(automation_ != 0) {
		reinterpret_cast<Ambient::EditorPane*>(automation_)->dispose();
		automation_->Release();
	}
}

/// r[ǉ
void EditorPane::addView(AlphaView& view) {
	views_.insert(&view);
	if(views_.size() == 1)
		showBuffer(view.getDocument());
}


/// IEditorPane I[g[VIuWFNgԂ
HRESULT EditorPane::getAutomation(IEditorPane*& object) const {
	EditorPane& self = *const_cast<EditorPane*>(this);
	if(self.automation_ == 0) {
		if(self.automation_ = new Ambient::EditorPane(AlphaApp::getInstance().getBufferList().getEditorWindow(), self))
			self.automation_->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(object = self.automation_)->AddRef();
	return S_OK;
}

/// SẴr[폜
void EditorPane::removeAll() {
	for(set<AlphaView*>::iterator it = views_.begin(); it != views_.end(); ++it)
		(*it)->getDocument().removeAndReleaseView(**it);
	views_.clear();
	visibleView_ = lastVisibleView_ = 0;
}

/// w肵obt@̃r[폜
void EditorPane::removeBuffer(const AlphaDoc& buffer) {
	for(set<AlphaView*>::iterator it = views_.begin(); it != views_.end(); ++it) {
		if(&(*it)->getDocument() == &buffer) {
			AlphaView& removing = **it;

			views_.erase(it);
			if(&removing == visibleView_) {
				visibleView_ = 0;
				if(&removing == lastVisibleView_)
					lastVisibleView_ = 0;
				if(views_.size() == 1 || lastVisibleView_ == 0)
					showBuffer((*views_.begin())->getDocument());
				else if(!views_.empty()) {
					showBuffer(lastVisibleView_->getDocument());
					lastVisibleView_ = 0;
				}
			}
			removing.getDocument().removeAndReleaseView(removing);
			return;
		}
	}
}

/**
 *	w肵obt@̃r[\
 *	@param buffer					\obt@
 *	@throw std::invalid_argument	@a buffer ݂ȂꍇX[
 */
void EditorPane::showBuffer(const AlphaDoc& buffer) {
	if(visibleView_ != 0 && &visibleView_->getDocument() == &buffer)
		return;
	for(set<AlphaView*>::iterator it = views_.begin(); it != views_.end(); ++it) {
		if(&(*it)->getDocument() == &buffer) {
			const bool hadFocus = visibleView_ == 0 || visibleView_->hasFocus();
			lastVisibleView_ = visibleView_;
			visibleView_ = *it;
			AlphaApp::getInstance().getBufferList().getEditorWindow().adjustPanes();
			visibleView_->showWindow(SW_SHOW);
			if(lastVisibleView_ != 0)
				lastVisibleView_->showWindow(SW_HIDE);
			if(hadFocus)
				visibleView_->setFocus();
			return;
		}
	}
	throw invalid_argument("Specified buffer is not contained in the pane.");
}


// BufferList class implementation
/////////////////////////////////////////////////////////////////////////////

const wstring BufferList::READ_ONLY_SIGNATURE_;

/**
 *	RXgN^
 *	@param app		AvP[V
 */
BufferList::BufferList(AlphaApp& app) : app_(app), automation_(0) {
	// GfB^EBhE̍쐬
	// (WS_CLIPCHILDREN tƕEBhẼTCYύXgsɂȂ...)
	editorWindow_.create(app_.getMainWindow(),
			DefaultWindowRect(), WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE, 0, *(new EditorPane));
	assert(editorWindow_.isWindow());

	// ENbNj[̍쐬
	updateContextMenu();

	if(READ_ONLY_SIGNATURE_.empty())
		const_cast<wstring&>(READ_ONLY_SIGNATURE_).assign(app_.loadString(MSG_READONLY_TITLE));
}

/// fXgN^
BufferList::~BufferList() {
	for(EditorWindow::Iterator it = editorWindow_.enumeratePanes(); !it.isEnd(); it.next())
		it.get().removeAll();
	for(size_t i = 0; i < buffers_.size(); ++i)
		delete buffers_[i];
	if(automation_ != 0)
		automation_->Release();
	if(icons_.isImageList()) {
		const int c = icons_.getImageCount();
		for(int i = 0; i < c; ++i)
			::DestroyIcon(icons_.getIcon(i, ILD_NORMAL));
		icons_.destroy();
	}
}

/**
 *	̐VKobt@J
 *	@param cp		R[hy[WBȗƊ̃R[hy[W
 *	@param bt		sR[hBȗƊ̉sR[h
 *	@param docType	Kp^CvBȗƊ̕^Cv
 */
void BufferList::addNew(CodePage cp /* = CPEX_AUTODETECT_USERLANG */,
		Ascension::LineBreak lineBreak /* = LB_AUTO */, const wstring& docType /* = L"" */) {
/*	if(::GetCurrentThreadId() != app_.getMainWindow().getWindowThreadID()) {
		// EBhE̍쐬CXbhɈϏ
		struct X : virtual public ICallable {
			X(BufferList& buffers, CodePage cp, Ascension::LineBreak lineBreak, const wstring& docType)
				: buffers_(buffer), cp_(cp), bt_(lineBreak), doctype_(docType) {}
			void call() {buffers_.addNew(cp_, bt_, doctype_);}
			BufferList&					buffers_;
			const CodePage				cp_;
			const Ascension::LineBreak	bt_;
			const wstring				doctype_;
		} x(*this, cp, lineBreak, docType);
		app_.getMainWindow().sendMessage(MYWM_CALLOVERTHREAD, 0, reinterpret_cast<LPARAM>(static_cast<ICallable*>(&x)));
		return;
	}
*/
	AlphaDoc* const buffer = new AlphaDoc();

	if(cp != CPEX_AUTODETECT_USERLANG)
		buffer->setCodePage(cp);
	if(lineBreak != LB_AUTO)
		buffer->setLineBreak(lineBreak);
	buffers_.push_back(buffer);

	// ݂̃yC̐r[쐬
	AlphaView* originalView = 0;
	for(EditorWindow::Iterator it = editorWindow_.enumeratePanes(); !it.isEnd(); it.next()) {
		AlphaView* view = (originalView == 0) ? new AlphaView(*buffer) : new AlphaView(*originalView);
		view->create(editorWindow_, DefaultWindowRect(),
			WS_CHILD | WS_CLIPCHILDREN | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_CLIENTEDGE);
		assert(view->isWindow());
		if(originalView == 0)
			originalView = view;
		it.get().addView(*view);
	}

	// tHg̐ݒ
	AlphaView& view = buffer->getView(0);
	LOGFONTW lf;
	app_.getTextEditorFont(lf);
	view.addEventListener(app_);
	buffer->addStatusListener(*this);
	buffer->setBasicListener(this);
	buffer->setFileNameListener(this);
	view.getLayoutSetter().setFont(lf);

	// obt@o[Ƀ{^ǉ
	AutoZero<TBBUTTON> button;
	button.idCommand = CMD_VIEW_BUFFERLIST_START + bufferBar_.getButtonCount();
	button.iBitmap = static_cast<int>(buffers_.size() - 1);
	button.fsState = TBSTATE_ENABLED;
	button.fsStyle = BTNS_AUTOSIZE | BTNS_BUTTON | BTNS_GROUP | BTNS_NOPREFIX;
	button.iString = reinterpret_cast<INT_PTR>(buffer->getFileName());
	bufferBar_.insertButton(bufferBar_.getButtonCount(), button);

	resetResources();
	setActive(*buffer);
	app_.applyDocumentType(*buffer, docType);
}

/// [w肵ĐVK] _CAOJAobt@VK쐬
void BufferList::addNewDialog() {
	NewFileFormatDlg dlg;

	dlg.codePage_ = app_.readIntegerProfile(L"File", L"defaultCodePage", ::GetACP());
	if(dlg.codePage_ == CP_ACP)
		dlg.codePage_ = ::GetACP();
	dlg.lineBreak_ = static_cast<Ascension::LineBreak>(app_.readIntegerProfile(L"file", L"defaultBreakType", LB_AUTO));
	if(dlg.lineBreak_ == LB_AUTO)
		dlg.lineBreak_ = LB_CRLF;
	dlg.documentType_ = 0;
	dlg.documentTypes_.clear();

	for(size_t i = 0; i < documentTypes_.getCount(); ++i)
		dlg.documentTypes_.push_back(documentTypes_.getAt(i).name);

	if(dlg.doModal(app_.getMainWindow()) != IDOK)
		return;
	addNew(dlg.codePage_, dlg.lineBreak_, documentTypes_.getAt(dlg.documentType_).name);
}

/**
 *	obt@
 *	@param index				obt@̃CfNX
 *	@param queryUser			ۑ̃obt@̏ꍇA[UɊmF邩
 *	@return						obt@ۂɕꍇ true
 *	@throw std::out_of_range	@a index sȂƂX[
 */
bool BufferList::close(size_t index, bool queryUser) {
	AlphaDoc& buffer = getAt(index);

	if(queryUser && buffer.isModified()) {
		setActive(buffer);	// Ώۂ̃obt@[UɌ悤ɂ
		const int answer = app_.messageBox(MSG_FILE_IS_DIRTY, MB_YESNOCANCEL | MB_ICONEXCLAMATION, MARGS % buffer.getFileName());
		if(answer == IDCANCEL)
			return false;
		else if(answer == IDYES && !save(index, true))
			return false;
	}

	if(buffers_.size() > 1) {
		bufferBar_.deleteButton(static_cast<int>(buffers_.size() - 1));
		for(EditorWindow::Iterator it = editorWindow_.enumeratePanes(); !it.isEnd(); it.next())
			it.get().removeBuffer(buffer);
		buffers_.erase(buffers_.begin() + index);
		delete &buffer;

		for(size_t i = index ; i < buffers_.size(); ++i)
			bufferBar_.setButtonText(static_cast<int>(CMD_VIEW_BUFFERLIST_START + i), getDisplayName(*buffers_[i]).c_str());
		resetResources();
		recalculateBufferBarSize();
	} else	// Ō1̏ꍇ
		buffer.resetContent();
	return true;
}

/**
 *	SāA͔ANeBuȑSẴobt@
 *	@param queryUser	ۑ̃obt@ꍇA[Uɖ₢킹ꍇ true
 *	@param exceptActive	ANeBuȃobt@cꍇ true
 *	@return				1[UɋۂȂ true
 */
bool BufferList::closeAll(bool queryUser, bool exceptActive /* = false */) {
	const size_t active = getActiveIndex();

	app_.getMainWindow().lockWindowUpdate();

	// ɕۑ̕Kv̖obt@S
	for(size_t i = buffers_.size(); i != 0; --i) {
		if(i - 1 == active && exceptActive)
			continue;
		if(!buffers_[i - 1]->isModified())
			close(i - 1, false);
	}

	app_.getMainWindow().unlockWindowUpdate();

	// ۑ̃obt@ΏI
	if(buffers_.size() == 1) {
		if(exceptActive || !buffers_[0]->isModified())
			return true;
	}

	// ۑ̃obt@1Ȃʏ̊mF_CAOoďI
	if(buffers_.size() - (exceptActive ? 1 : 0) == 1) {
		const size_t dirty = !exceptActive ? 0 : ((active == 0) ? 1 : 0);

		if(buffers_[dirty]->isModified()) {
			if(exceptActive)
				setActive(dirty);
			return close(getActiveIndex(), queryUser);
		}
	}

	// ̃obt@ۑ邩ǂmF_CAOo
	ConfirmUnsavedDocumentDlg dlg;
	for(size_t i = 0; i < buffers_.size(); ++i) {
		if(exceptActive && i == active)
			continue;
		DirtyFile df;
		df.index = static_cast<uint>(i);
		df.fileName = buffers_[i]->getFileName();
		df.save = true;
		dlg.files_.push_back(df);
	}
	if(IDOK != dlg.doModal(app_.getMainWindow()))
		return false;

	// ۑ
	for(vector<DirtyFile>::reverse_iterator it = dlg.files_.rbegin(); it != dlg.files_.rend(); ++it) {
		if(it->save) {
			if(!save(it->index, true))
				return false;
		}
		if(!close(it->index, false))
			return false;
	}

	return true;
}

/**
 *	obt@o[ () 쐬
 *	@param rebar	obt@o[悹郌o[
 *	@return			
 */
bool BufferList::createBar(Rebar& rebar) {
	if(bufferBarPager_.isWindow()) {
		rebar.deleteBand(rebar.idToIndex(IDC_BUFFERBARPAGER));
		bufferBar_.destroyWindow();
		bufferBarPager_.destroyWindow();
	}

	// obt@o[ƃy[W쐬
	if(!bufferBarPager_.create(rebar, DefaultWindowRect(), 0, IDC_BUFFERBARPAGER,
			WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE | CCS_NORESIZE | PGS_HORZ))
		return false;
	if(!bufferBar_.create(bufferBarPager_, DefaultWindowRect(), 0, IDC_BUFFERBAR,
			WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE
			| CCS_NODIVIDER | CCS_NOPARENTALIGN | CCS_NORESIZE | CCS_TOP
			| TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_REGISTERDROP | TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT, WS_EX_TOOLWINDOW)) {
		bufferBarPager_.destroyWindow();
		return false;
	}
	HWND toolTips = bufferBar_.getToolTips();
	bufferBar_.setButtonStructSize();
	::SetWindowLongPtrW(toolTips, GWL_STYLE, ::GetWindowLongPtrW(toolTips, GWL_STYLE) | TTS_NOPREFIX);
	bufferBarPager_.setChild(bufferBar_);

	// o[ɏ悹
	AutoZeroCB<REBARBANDINFOW> rbbi;
	const wstring caption = app_.loadString(MSG_BUFFERBAR_CAPTION);
	rbbi.fMask = RBBIM_CHILD | RBBIM_CHILDSIZE | RBBIM_ID | RBBIM_STYLE | RBBIM_TEXT;
	rbbi.fStyle = RBBS_BREAK | RBBS_GRIPPERALWAYS;
	rbbi.cxMinChild = 0;
	rbbi.cyMinChild = 22;
	rbbi.wID = IDC_BUFFERBAR;
	rbbi.lpText = const_cast<wchar_t*>(caption.c_str());
	rbbi.hwndChild = bufferBarPager_;
	if(!rebar.insertBand(rebar.getBandCount(), rbbi)) {
		bufferBar_.destroyWindow();
		bufferBarPager_.destroyWindow();
		return false;
	}
	return true;
}

/// w肵obt@̃CfNXԂBȂꍇ -1
size_t BufferList::find(const AlphaDoc& buffer) const {
	for(size_t i = 0; i < buffers_.size(); ++i) {
		if(buffers_[i] == &buffer)
			return i;
	}
	return -1;
}

/// IActiveBufferListener::onActiveBufferChanged ̃gK
void BufferList::fireChangedActiveBuffer() {
	const size_t activeBuffer = getActiveIndex();
	const AlphaView& activeView = getActiveView();

	bufferBar_.checkButton(static_cast<int>(activeBuffer) + CMD_VIEW_BUFFERLIST_START);
	for(EditorWindow::Iterator it = editorWindow_.enumeratePanes(); !it.isEnd(); it.next()) {
		if(it.get().getCount() > 0 && &it.get().getVisibleView() == &activeView) {
			editorWindow_.setDefaultActivePane(it.get());
			break;
		}
	}

	// ANeBuȃobt@̃{^BĂXN[
	if(bufferBarPager_.isWindowVisible()) {
		const int pagerPos = bufferBarPager_.getPos();
		RECT buttonRect, pagerRect;
		bufferBar_.getItemRect(static_cast<int>(activeBuffer), buttonRect);
		bufferBarPager_.getClientRect(pagerRect);
		if(buttonRect.left < pagerPos)
			bufferBarPager_.setPos(buttonRect.left);
		else if(buttonRect.right > pagerPos + pagerRect.right)
			bufferBarPager_.setPos(buttonRect.right - pagerRect.right);
	}
	app_.onChangedActiveBuffer();
}

/// I[g[VłԂ
HRESULT BufferList::getAutomation(IBuffers*& buffers) const throw() {
	BufferList& self = *const_cast<BufferList*>(this);
	buffers = 0;
	if(automation_ == 0) {
		if(self.automation_ = new Ambient::Buffers(self))
			self.automation_->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(buffers = self.automation_)->AddRef();
	return S_OK;
}

/**
 *	ۃhLg AlphaDoc ɕϊ
 *	@document						ϊhLg
 *	@throw std::invalid_argument	@a document XgɊ܂܂ĂȂ΃X[
 *	@see							BufferList::find
 */
AlphaDoc& BufferList::getConcreteDocument(Document<DocumentUpdate>& document) const {
	for(size_t i = 0; i < buffers_.size(); ++i) {
		if(buffers_[i] == &document)
			return *buffers_[i];
	}
	throw invalid_argument("Specified document is not in the list.");
}

/**
 *	^Cgo[obt@o[ɕ\obt@̖OԂ
 *	@param buffer obt@
 */
wstring BufferList::getDisplayName(const AlphaDoc& buffer) {
	const std::wstring str = buffer.getFileName();
	if(buffer.isModified())
		return buffer.isReadOnly() ? str + L" * " + READ_ONLY_SIGNATURE_ : str + L" *";
	else
		return buffer.isReadOnly() ? str + L" " + READ_ONLY_SIGNATURE_ : str;
}

/// obt@o[瑗Ă WM_NOTIFY 
LRESULT BufferList::handleBufferBarNotification(NMTOOLBAR& nmhdr) {
	if(nmhdr.hdr.code == NM_RCLICK) {	// ENbN
		const NMMOUSE& mouse = *reinterpret_cast<NMMOUSE*>(&nmhdr.hdr);
		if(mouse.dwItemSpec != -1) {
			POINT pt = mouse.pt;
			bufferBar_.clientToScreen(pt);
			setActive(mouse.dwItemSpec - CMD_VIEW_BUFFERLIST_START);
			contextMenu_.trackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN | TPM_LEFTBUTTON,
				pt.x, pt.y, AlphaApp::getInstance().getMainWindow());
			return true;
		}
	}

	else if(nmhdr.hdr.code == TTN_GETDISPINFOW) {	// c[`bv
		assert(nmhdr.hdr.idFrom >= CMD_VIEW_BUFFERLIST_START && nmhdr.hdr.idFrom < CMD_VIEW_BUFFERLIST_END);
		static wchar_t tipText[500];
		NMTTDISPINFOW& nmttdi = *reinterpret_cast<NMTTDISPINFOW*>(&nmhdr.hdr);

//		nmttdi->hinst = getHandle();
		const AlphaDoc& buffer = getAt(nmttdi.hdr.idFrom - CMD_VIEW_BUFFERLIST_START);
		wcscpy(tipText, (buffer.getPathName() != 0) ? buffer.getPathName() : buffer.getFileName());
		nmttdi.lpszText = tipText;
		return true;
	}

	else if(nmhdr.hdr.code == TBN_ENDDRAG && bufferBar_.getButtonCount() > 1) {
		TBINSERTMARK mark;
		bufferBar_.getInsertMark(mark);
		if(mark.iButton != -1) {
			// {^ړ
			move(bufferBar_.commandToIndex(nmhdr.iItem),
				toBoolean(mark.dwFlags & TBIMHT_AFTER) ? mark.iButton + 1 : mark.iButton);
			// }}[N
			mark.dwFlags = 0;
			mark.iButton = -1;
			bufferBar_.setInsertMark(mark);
		}
	}

	// hbO -> ANeBuȃobt@؂ւ
	else if(nmhdr.hdr.code == TBN_GETOBJECT) {
		NMOBJECTNOTIFY& n = *reinterpret_cast<NMOBJECTNOTIFY*>(&nmhdr.hdr);
		setActive(bufferBar_.commandToIndex(n.iItem));	// n.iItem  ID
		n.pObject = 0;
		n.hResult = E_NOINTERFACE;
		return 0;
	}

	else if(nmhdr.hdr.code == TBN_HOTITEMCHANGE
			&& bufferBar_.getButtonCount() > 1 && bufferBar_.getSafeHwnd() == ::GetCapture()) {
		NMTBHOTITEM& hotItem = *reinterpret_cast<NMTBHOTITEM*>(&nmhdr.hdr);
		if(toBoolean(hotItem.dwFlags & HICF_MOUSE)) {	// {^hbO
			TBINSERTMARK mark;
			if(!toBoolean(hotItem.dwFlags & HICF_LEAVING)) {
				// }}[Nړ
				mark.dwFlags = 0;
				mark.iButton = bufferBar_.commandToIndex(hotItem.idNew);
			} else {
				mark.dwFlags = TBIMHT_AFTER;
				mark.iButton = bufferBar_.getButtonCount() - 1;
			}
			bufferBar_.setInsertMark(mark);
		}
	}

	return false;
}

/// obt@o[̃y[W瑗Ă WM_NOTIFY 
LRESULT BufferList::handleBufferBarPagerNotification(NMHDR& nmhdr) {
	if(nmhdr.code == PGN_CALCSIZE) {	// y[WTCY̌vZ
		LPNMPGCALCSIZE p = reinterpret_cast<LPNMPGCALCSIZE>(&nmhdr);
		if(p->dwFlag == PGF_CALCWIDTH) {
			SIZE size;
			bufferBar_.getMaxSize(size);
			p->iWidth = size.cx;
		} else if(p->dwFlag == PGF_CALCHEIGHT) {
			SIZE size;
			bufferBar_.getMaxSize(size);
			p->iHeight = size.cy;
		}
		return true;
	}

	else if(nmhdr.code == PGN_SCROLL) {	// y[W̃XN[ʂ̐ݒ
		NMPGSCROLL* p = reinterpret_cast<NMPGSCROLL*>(&nmhdr);
		p->iScroll = 20;
		if(toBoolean(p->fwKeys & PGK_SHIFT))	// t
			p->iScroll *= -1;
		if(toBoolean(p->fwKeys & PGK_CONTROL))	// {
			p->iScroll *= 2;
		return true;
	}

	return false;
}

/**
 *	t@CJۑ肷̂ɎsƂ̏
 *	@param fileName		̃t@C (̃obt@ANeBuɂȂĂȂ΂ȂȂ)
 *	@param forLoading	Ăяot@CJƂƂ true
 *	@param result		G[e
 *	@return				ʓIɃG[łꍇ false
 */
bool BufferList::handleFileIOError(const WCHAR* fileName, bool forLoading, EditDoc::FileIOResult result) {
	assert(fileName != 0);
	if(result == EditDoc::FIR_OK)
		return true;
	else if(result == EditDoc::FIR_ABORTED_FOR_UNCONVERTABLE) {
		if(forLoading)
			close(getActiveIndex(), false);
		return false;
	} else {
		DWORD messageID;
		bool succeeded = true;
		switch(result) {
		case EditDoc::FIR_LOCK_DENIED:					messageID = MSG_FAILED_TO_LOCK_FILE;			break;
		case EditDoc::FIR_READ_READONLY:				messageID = MSG_OPENED_AS_READONLY;				break;
		case EditDoc::FIR_READ_USED_BY_OTHER_PROCESS:	messageID = MSG_FILE_IS_USED_BY_OTHER_PROCESS;	break;
		default:
			succeeded = false;
			switch(result) {
			case EditDoc::FIR_ACCESS_DENIED:			messageID = MSG_FILE_ACCESS_DENIED;				break;
			case EditDoc::FIR_INVALID_CODEPAGE:			messageID = MSG_ILLEGAL_CODEPAGE;				break;
			case EditDoc::FIR_OUT_OF_MEMORY:			messageID = MSG_OUT_OF_MEMORY;					break;
			case EditDoc::FIR_UNKNOWN_ERROR:			messageID = MSG_UNKNOWN_ERROR;					break;
			case EditDoc::FIR_READ_HUGE_FILE:			messageID = MSG_TOO_LARGE_FILE;					break;
			case EditDoc::FIR_READ_NOT_EXIST:			messageID = MSG_FILE_NOT_FOUND;					break;
			case EditDoc::FIR_WRITE_FULL_DISK:			messageID = MSG_FAILED_TO_WRITE_FOR_FULLDISK;	break;
			case EditDoc::FIR_WRITE_READONLY:			messageID = MSG_FAILED_TO_WRITE_FOR_READONLY;	break;
			}
		}
		app_.messageBox(messageID, succeeded ? MB_ICONEXCLAMATION : MB_ICONHAND, MARGS % fileName);
		if(!succeeded)
			close(getActiveIndex(), false);
		return succeeded;
	}
}

/**
 *	obt@Xgňړ
 *	@param from					ړobt@̔ԍ
 *	@param to					ړ
 *	@throw std::out_of_range	@a from sȂƂX[
 */
void BufferList::move(size_t from, size_t to) {
	if(from >= buffers_.size() || to > buffers_.size())
		throw out_of_range("Specified index is out of range.");
	else if(from == to)
		return;

	// Xgňړ
	AlphaDoc* buffer = buffers_[from];
	buffers_.erase(buffers_.begin() + from);
	buffers_.insert((from < to) ? buffers_.begin() + to - 1 : buffers_.begin() + to, buffer);

	// obt@o[̃{^ёւ
	const int end = min(static_cast<int>(max(from, to)), bufferBar_.getButtonCount() - 1);
	for(int i = static_cast<int>(min(from, to)); i <= end; ++i)
		bufferBar_.setButtonText(CMD_VIEW_BUFFERLIST_START + i, getDisplayName(*buffers_[i]).c_str());
	setActive(*buffer);
	resetResources();
}

/// @see Document::IListener::onChangedViewList
void BufferList::onChangedViewList(Document<Ascension::DocumentUpdate>& document) {
}

/// @see Document::IListener::onChangedModification
void BufferList::onChangedModification(Document<Ascension::DocumentUpdate>& document) {
	const AlphaDoc& buffer = getConcreteDocument(document);
	bufferBar_.setButtonText(static_cast<int>(CMD_VIEW_BUFFERLIST_START + find(buffer)), getDisplayName(buffer).c_str());
	recalculateBufferBarSize();
	if(&buffer == &getActive())
		app_.onChangedActiveBufferProperty();
}

/// @see FileBoundDocument::IListener::onChangedFileName
void BufferList::onChangedFileName(FileBoundDocument<DocumentUpdate>& document) {
	AlphaDoc& buffer = getConcreteDocument(document);
	app_.applyDocumentType(buffer);
	resetResources();
	bufferBar_.setButtonText(static_cast<int>(CMD_VIEW_BUFFERLIST_START + find(buffer)), getDisplayName(buffer).c_str());
	bufferBarPager_.recalcSize();
	if(&buffer == &getActive())
		app_.onChangedActiveBufferProperty();
}

/// @see EditDoc::IStatusListener::onDocumentChangedAccessibleRegion
void BufferList::onDocumentChangedAccessibleRegion(EditDoc& document) {
	if(&getConcreteDocument(document) == &getActive())
		app_.onChangedActiveBufferProperty();
}

/// @see EditDoc::IStatusListener::onDocumentChangedFormat
void BufferList::onDocumentChangedFormat(EditDoc& document) {
	if(&getConcreteDocument(document) == &getActive())
		app_.onChangedActiveBufferProperty();
}

/// @see EditDoc::IStatusListener::onDocumentChangedReadOnlyState
void BufferList::onDocumentChangedReadOnlyState(EditDoc& document) {
	const AlphaDoc& buffer = getConcreteDocument(document);
	bufferBar_.setButtonText(static_cast<int>(CMD_VIEW_BUFFERLIST_START + find(buffer)), getDisplayName(buffer).c_str());
	recalculateBufferBarSize();
	if(&buffer == &getActive())
		app_.onChangedActiveBufferProperty();
}

/// @see EditDoc::IStatusListener::onDocumentOverwrittenByOtherProcess
void BufferList::onDocumentOverwrittenByOtherProcess(EditDoc& document) {
	const AlphaDoc& buffer = getConcreteDocument(document);
	setActive(buffer);
	if(IDYES == app_.messageBox(MSG_FILE_HAS_BEEN_MODIFIED_BY_OTHER, MB_YESNO | MB_ICONQUESTION, MARGS % buffer.getPathName()))
		reopen(find(buffer), false);
}

/**
 *	@brief eLXgt@CJ
 *
 *	t@CeLXgGfB^ŐVr[ɊJÃr[ANeBuɂB
 *	܂Agqɉĕ^CvKpB̃\bh̓t@CI[v
 *	ʂ_CAO\邱Ƃ
 *	@param fileName		t@C
 *	@param cp			t@C̃R[hy[WBȗƎ
 *	@param docType		Kp镶^CvBȗ󕶎̏ꍇ͊gq画
 *	@param asReadOnly	ǂݎpƂĊJ
 *	@param addToMRU		Jt@Cŋߎgt@Cɒǉ邩
 *	@return				ۂȂ
 */
BufferList::OpenResult BufferList::open(const basic_string<WCHAR>& fileName,
		CodePage cp /* = CPEX_AUTOSELECT */, bool asReadOnly /* = false */, bool addToMRU /* = true */) {
	WCHAR resolvedName[MAX_PATH];

	// V[gJbg̉
	const WCHAR* extension = ::PathFindExtensionW(fileName.c_str());
	if(wcslen(extension) != 0 && (
			(::StrCmpIW(extension + 1, L"lnk") == 0)
			/*|| (::StrCmpIW(extension + 1, L"url") == 0)*/)) {
		ComPtr<IShellLink> shellLink;
		ComPtr<IPersistFile> file;
		HRESULT hr;

		try {
			if(FAILED(hr = shellLink.createInstance(CLSID_ShellLink)))
				throw hr;
			if(FAILED(hr = shellLink->QueryInterface(IID_IPersistFile, reinterpret_cast<void**>(&file))))
				throw hr;
			if(FAILED(hr = file->Load(fileName.c_str(), STGM_READ)))
				throw hr;
			if(FAILED(hr = shellLink->Resolve(0, SLR_ANY_MATCH | SLR_NO_UI)))
				throw hr;
			if(FAILED(hr = shellLink->GetPath(resolvedName, MAX_PATH, 0, 0)))
				throw hr;
		} catch(HRESULT /*hr_*/) {
			app_.messageBox(MSG_FAILED_TO_RESOLVE_SHORTCUT, MB_ICONHAND, MARGS % fileName);
			return OPENRESULT_FAILED;
		}
	} else
		wcscpy(resolvedName, fileName.c_str());

	// (eLXgGfB^) ɊJĂ邩ׂ
	for(size_t i = 0; i < buffers_.size(); ++i) {
		AlphaDoc& buffer = *buffers_[i];
		if(buffer.getPathName() != 0 && ::StrCmpIW(buffer.getPathName(), resolvedName) == 0) {	// ł͕sS
			setActive(buffer);
			return OPENRESULT_SUCCEEDED;
		}
	}

	AlphaDoc* buffer = &getActive();
	EditDoc::FileOpenMode mode;

	// bNȂ
	if(asReadOnly)
		mode = EditDoc::FOM_AS_READONLY;
	else {
		switch(app_.readIntegerProfile(L"File", L"shareMode", 0)) {
		case 0:	mode = EditDoc::FOM_DENY_NONE;	break;
		case 1:	mode = EditDoc::FOM_DENY_WRITE;	break;
		case 2:	mode = EditDoc::FOM_DENY_READ;	break;
		}
	}

	if(buffer->isModified() || buffer->getPathName() != 0) {	// VReiŊJ
		addNew(cp);
		buffer = &getActive();
	}

	if(!EncoderFactory::getInstance().isCodePageForAutoDetection(cp)) {
		try {
			buffer->setCodePage(cp);
		} catch(invalid_argument& /* e */) {
			if(IDNO == app_.messageBox(MSG_ILLEGAL_CODEPAGE, MB_YESNO | MB_ICONEXCLAMATION))
				return OPENRESULT_USERCANCELED;
			cp = ::GetACP();
			buffer->setCodePage(cp);
		}
	}

	const wstring s = app_.loadString(MSG_LOADING_FILE, MARGS % resolvedName);
	EditDoc::FileIOResult result;
	do {
		Windows::WaitCursor wc;
		FileIOCallback callback(app_, true, resolvedName, cp);

		app_.setStatusText(s.c_str());
		app_.getMainWindow().lockWindowUpdate();

		// ł̂Ńt@CJ
		result = buffer->load(resolvedName, mode, cp, &callback);
		app_.setStatusText(0);
		app_.getMainWindow().unlockWindowUpdate();

		// [UR[hy[W̕ύXvĂ
		if(callback.doesUserWantToChangeCodePage()) {
			assert(result == EditDoc::FIR_ABORTED_FOR_UNCONVERTABLE);
			CodePagesDlg dlg(true);
			dlg.codePage_ = cp;
			if(dlg.doModal(app_.getMainWindow()) == IDOK) {
				cp = dlg.codePage_;
				continue;	// R[hy[WςčĒ
			}
		}
		break;
	} while(true);

	app_.getMainWindow().showWindow(app_.getMainWindow().isWindowVisible() ? SW_SHOW : SW_RESTORE);

	if(handleFileIOError(resolvedName, true, result)) {
		if(addToMRU)
			app_.getMRUManager().add(buffer->getPathName(), buffer->getCodePage());
		return OPENRESULT_SUCCEEDED;
	}
	return (result != EditDoc::FIR_ABORTED_FOR_UNCONVERTABLE) ? OPENRESULT_FAILED : OPENRESULT_USERCANCELED;
}

/**
 *	[J] _CAO\ăt@CJ
 *	@param initialDirectory	_CAOōŏɕ\tH_B
							null ƃANeBuȃobt@̃fBNgB
							ANeBuȃobt@t@CɌѕtĂȂ΃VXȅ
 *	@return					ۂȂ
 */
BufferList::OpenResult BufferList::openDialog(const WCHAR* initialDirectory /* = 0 */) {
	wstring filterSource = app_.readStringProfile(L"File", L"filter", app_.loadString(MSG_DEFAULT_OPEN_FILE_FILTER).c_str());
	wchar_t* filter = new wchar_t[filterSource.length() + 2];
	WCHAR fileName[MAX_PATH + 1] = L"";
	wstring errorMessage;

	// tB^𐮌`
	replace_if(filterSource.begin(), filterSource.end(), bind2nd(equal_to<wchar_t>(), L':'), L'\0');
	filterSource.copy(filter, filterSource.length());
	filter[filterSource.length()] = L'\0';
	filter[filterSource.length() + 1] = L'\0';

	AutoZero<OSVERSIONINFOW> osVersion;
	osVersion.dwOSVersionInfoSize = sizeof(OSVERSIONINFOW);
	::GetVersionEx(&osVersion);

	WCHAR* activeBufferDir = 0;
	if(initialDirectory == 0 && getActive().getPathName() != 0) {
		activeBufferDir = new WCHAR[MAX_PATH];
		wcscpy(activeBufferDir, getActive().getPathName());
		*::PathFindFileNameW(activeBufferDir) = 0;
		if(activeBufferDir[0] == 0) {
			delete[] activeBufferDir;
			activeBufferDir = 0;
		}
	}

	TextFileFormat format = {CPEX_AUTODETECT_USERLANG, LB_AUTO};
	AutoZeroLS<OPENFILENAMEW> newOfn;
	AutoZeroLS<OPENFILENAME_NT4W> oldOfn;
	OPENFILENAMEW& ofn = (osVersion.dwMajorVersion > 4) ? newOfn : *reinterpret_cast<OPENFILENAMEW*>(&oldOfn);
	ofn.hwndOwner = app_.getMainWindow().getSafeHwnd();
	ofn.hInstance = ::GetModuleHandle(0);
	ofn.lpstrFilter = filter;
	ofn.lpstrFile = fileName;
	ofn.lpstrInitialDir = (initialDirectory != 0) ? initialDirectory : activeBufferDir;
	ofn.nFilterIndex = app_.readIntegerProfile(L"File", L"activeFilter", 0);
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_ALLOWMULTISELECT | OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
		| OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST/* | OFN_SHOWHELP*/;
	ofn.lCustData = reinterpret_cast<LPARAM>(&format);
	ofn.lpfnHook = openFileNameHookProc;
	ofn.lpTemplateName = MAKEINTRESOURCE(IDD_DLG_OPENFILE);

	const bool succeeded = toBoolean(::GetOpenFileNameW(&ofn));
	delete[] filter;
	delete[] activeBufferDir;
	app_.writeIntegerProfile(L"File", L"activeFilter", ofn.nFilterIndex);	// ŌɎgtB^ۑ

	if(succeeded) {
		const wstring directory = ofn.lpstrFile;

		if(directory.length() > ofn.nFileOffset)	// Jt@C1
			return open(directory, format.encoding, toBoolean(ofn.Flags & OFN_READONLY));	// pOfn->lpstrFile ͊St@C
		else {	// ̃t@CJꍇ
			wchar_t* fileNames = ofn.lpstrFile + ofn.nFileOffset;
			bool failedOnce = false;

			while(*fileNames != 0) {
				const size_t len = wcslen(fileNames);
				if(open(directory + L"\\" + wstring(fileNames, len),
						format.encoding, toBoolean(ofn.Flags & OFN_READONLY)) != OPENRESULT_SUCCEEDED)
					failedOnce = true;
				fileNames += len + 1;
			}
			return failedOnce ? OPENRESULT_FAILED : OPENRESULT_SUCCEEDED;
		}
	} else
		return OPENRESULT_FAILED;
}

/// GetOpenFileNameW AGetSaveFileNameW ̂߂̃tbNvVW
UINT_PTR CALLBACK BufferList::openFileNameHookProc(HWND window, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_COMMAND:
		// [R[hy[W] ύXꂽ
		if(LOWORD(wParam) == IDC_COMBO_CHARCODE && HIWORD(wParam) == CBN_SELCHANGE) {
			ComboBox breakCodeCombobox(::GetDlgItem(window, IDC_COMBO_BREAKCODE));
			if(!breakCodeCombobox.isWindow())
				break;
			ComboBox codePageCombobox(::GetDlgItem(window, IDC_COMBO_CHARCODE));

			const wstring unchange = AlphaApp::getInstance().loadString(MSG_UNCHANGE_BREAK_TYPE);
			const CodePage cp = codePageCombobox.getItemData(codePageCombobox.getCurSel());
			const int breakCode = (breakCodeCombobox.getCount() != 0) ? breakCodeCombobox.getCurSel() : 0;

			if(cp == CPEX_UNICODE_UTF5 || cp == CP_UTF7 || cp == CP_UTF8
					|| cp == CPEX_UNICODE_UTF16LE || cp == CPEX_UNICODE_UTF16BE
					|| cp == CPEX_UNICODE_UTF32LE || cp == CPEX_UNICODE_UTF32BE) {
				if(breakCodeCombobox.getCount() != 7) {
					breakCodeCombobox.resetContent();
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(unchange.c_str()), LB_AUTO);
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(IDS_BREAK_CRLF), LB_CRLF);
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(IDS_BREAK_LF), LB_LF);
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(IDS_BREAK_CR), LB_CR);
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(IDS_BREAK_NEL), LB_NEL);
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(IDS_BREAK_LS), LB_LS);
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(IDS_BREAK_PS), LB_PS);
					breakCodeCombobox.setCurSel(breakCode);
				}
			} else {
				if(breakCodeCombobox.getCount() != 4) {
					breakCodeCombobox.resetContent();
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(unchange.c_str()), LB_AUTO);
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(IDS_BREAK_CRLF), LB_CRLF);
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(IDS_BREAK_LF), LB_LF);
					breakCodeCombobox.setItemData(breakCodeCombobox.addString(IDS_BREAK_CR), LB_CR);
					breakCodeCombobox.setCurSel((breakCode < 4) ? breakCode : 0);
				}
			}
		}
		break;
	case WM_INITDIALOG: {
		OPENFILENAMEW& ofn = *reinterpret_cast<OPENFILENAMEW*>(lParam);
		HWND dialog = ::GetParent(window);
		ComboBox codePageCombobox(::GetDlgItem(window, IDC_COMBO_CHARCODE));
		Static codePageLabel(::GetDlgItem(window, IDC_STATIC_1));
		ComboBox breakCodeCombobox(::GetDlgItem(window, IDC_COMBO_BREAKCODE));
		Static breakCodeLabel(::GetDlgItem(window, IDC_STATIC_2));

		// _CAOev[g̃Rg[̈ʒu킹
		POINT pt;
		RECT rect;
		::GetWindowRect(window, &rect);
		pt.x = rect.left;
		pt.y = rect.top;

		// x
		::GetWindowRect(::GetDlgItem(dialog, stc2), &rect);
		long x = rect.left;
		codePageLabel.getWindowRect(rect);
		codePageLabel.setWindowPos(0, x - pt.x, rect.top - pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
		if(breakCodeLabel.isWindow()) {
			breakCodeLabel.getWindowRect(rect);
			breakCodeLabel.setWindowPos(0, x - pt.x, rect.top - pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
		}

		// R{{bNX
		::GetWindowRect(::GetDlgItem(dialog, cmb1), &rect);
		x = rect.left;
		codePageCombobox.getWindowRect(rect);
		codePageCombobox.setWindowPos(0, x - pt.x, rect.top - pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
		if(breakCodeCombobox.isWindow()) {
			breakCodeCombobox.getWindowRect(rect);
			breakCodeCombobox.setWindowPos(0, x - pt.x, rect.top - pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
		}

		const EncoderFactory& encoders = EncoderFactory::getInstance();
		set<CodePage> codePages;
		encoders.enumCodePages(codePages);
		for(set<CodePage>::const_iterator it = codePages.begin(); it != codePages.end(); ++it) {
			if(breakCodeCombobox.isWindow()
					&& (encoders.isCodePageForAutoDetection(*it) || encoders.isCodePageForAutoDetection(*it)))
				continue;
			else if(const wstring* name = AlphaApp::getInstance().getCodePageName(*it))
				codePageCombobox.setItemData(codePageCombobox.addString(name->c_str()), *it);
		}

		const UINT c = codePageCombobox.getCount();
		codePageCombobox.setCurSel(0);
		for(UINT i = 0; i < c; ++i) {
			if(reinterpret_cast<TextFileFormat*>(ofn.lCustData)->encoding == codePageCombobox.getItemData(i)) {
				codePageCombobox.setCurSel(i);
				break;
			}
		}

		if(breakCodeCombobox.isWindow()) {
			switch(reinterpret_cast<TextFileFormat*>(ofn.lCustData)->lineBreak) {
			case LB_AUTO:	breakCodeCombobox.setCurSel(0);	break;
			case LB_CRLF:	breakCodeCombobox.setCurSel(1);	break;
			case LB_LF:		breakCodeCombobox.setCurSel(2);	break;
			case LB_CR:		breakCodeCombobox.setCurSel(3);	break;
			case LB_NEL:	breakCodeCombobox.setCurSel(4);	break;
			case LB_LS:		breakCodeCombobox.setCurSel(5);	break;
			case LB_PS:		breakCodeCombobox.setCurSel(6);	break;
			}
			::SendMessageW(window, WM_COMMAND, MAKEWPARAM(IDC_COMBO_CHARCODE, CBN_SELCHANGE), 0);
		}
	}
		break;
	case WM_NOTIFY: {
		OFNOTIFYW& ofn = *reinterpret_cast<OFNOTIFYW*>(lParam);
		if(ofn.hdr.code == CDN_FILEOK) {	// [J]/[ۑ]
			ComboBox codePageCombobox(::GetDlgItem(window, IDC_COMBO_CHARCODE));
			ComboBox breakCodeCombobox(::GetDlgItem(window, IDC_COMBO_BREAKCODE));
			Button readOnlyCheckbox(::GetDlgItem(::GetParent(window), chx1));
			TextFileFormat& format = *reinterpret_cast<TextFileFormat*>(ofn.lpOFN->lCustData);

			format.encoding = codePageCombobox.getItemData(codePageCombobox.getCurSel());
			if(breakCodeCombobox.isWindow()) {
				switch(breakCodeCombobox.getCurSel()) {
				case 0:	format.lineBreak = LB_AUTO;	break;
				case 1:	format.lineBreak = LB_CRLF;	break;
				case 2:	format.lineBreak = LB_LF;	break;
				case 3:	format.lineBreak = LB_CR;	break;
				case 4:	format.lineBreak = LB_NEL;	break;
				case 5:	format.lineBreak = LB_LS;	break;
				case 6:	format.lineBreak = LB_PS;	break;
				}
			}
			if(readOnlyCheckbox.isWindow()) {
				// t@C̏ꍇA`FbN{bNX̏Ԃ
				// (Ӑ}IȂ)
				if(readOnlyCheckbox.getCheck() == BST_CHECKED)
					ofn.lpOFN->Flags |= OFN_READONLY;
				else
					ofn.lpOFN->Flags &= ~OFN_READONLY;
			}
		}
	}
		break;
	}

	return 0L;
}

/**
 *	[t@C] _CAO\ăt@Cs
 *	@param command e
 */
void BufferList::operateActive(FileOperation command) {
	AlphaDoc& buffer = getActive();
	EditDoc::FileOperationResult result = EditDoc::FOR_OK;

	if(buffer.getPathName() == 0)
		return;
	else if(command != FILEOPERATION_DELETE) {
		FileOperationDlg dlg(command, buffer.getPathName());
		if(dlg.doModal(app_.getMainWindow()) == IDOK) {
			switch(command) {
			case FILEOPERATION_COPY:
				result = buffer.copyFile(dlg.filePath.c_str());
				break;
			case FILEOPERATION_MOVE:
			case FILEOPERATION_RENAME:
				result = buffer.moveFile(dlg.filePath.c_str());
				break;
			}
		}
	} else {
		result = buffer.deleteFile();
		if(result == EditDoc::FOR_OK)
			close(getActiveIndex(), false);
	}

	// G[bZ[W̐
	switch(result) {
	case EditDoc::FOR_OK:
	case EditDoc::FOR_ABORTED:
		return;
	case EditDoc::FOR_ALREADY_EXISTS:
		app_.messageBox(MSG_FAILED_TO_OPERATE_FILE, MB_ICONEXCLAMATION);
		break;
	case EditDoc::FOR_REOPENED_AS_READONLY:
		app_.messageBox(MSG_REOPENED_AS_READONLY, MB_ICONEXCLAMATION);
		break;
	case EditDoc::FOR_CANNOT_REOPEN:
		// ...
		break;
	case EditDoc::FOR_UNKNOWN_ERROR:
		// ...
//		::FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, 0, ::GetLastError(),
//			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), wszError + wcslen(wszError), 200, 0);
		break;
	}
}

/// obt@o[̒𒲐
void BufferList::recalculateBufferBarSize() {
	bufferBarPager_.recalcSize();

	// obt@o[̗z̍ČvZ
	if(bufferBar_.isWindowVisible()) {
		AutoZero<REBARBANDINFOW> rbbi;
		Rebar rebar(bufferBarPager_.getParent());
		RECT rect;
		rbbi.fMask = RBBIM_IDEALSIZE;
		bufferBar_.getItemRect(bufferBar_.getButtonCount() - 1, rect);
		rbbi.cxIdeal = rect.right;
		rebar.setBandInfo(rebar.idToIndex(IDC_BUFFERBAR), rbbi);
	}
}

/**
 *	obt@J
 *	@param index				obt@̃CfNX
 *	@param changeCodePage		R[hy[WύX邩
 *	@return						ۂȂ
 *	@throw std::out_of_range	@a index sȂƂX[
 */
BufferList::OpenResult BufferList::reopen(size_t index, bool changeCodePage) {
	AlphaDoc& buffer = getAt(index);

	// t@C݂邩?
	if(buffer.getPathName() == 0)
		return OPENRESULT_FAILED;

	// [ULZ
	else if(buffer.isModified() && IDNO == app_.messageBox(MSG_ASK_REOPEN_IN_DIRTY, MB_YESNO | MB_ICONQUESTION))
		return OPENRESULT_USERCANCELED;

	// R[hy[WύXꍇ̓_CAOo
	CodePage cp = buffer.getCodePage();
	if(changeCodePage) {
		CodePagesDlg dlg(true);
		dlg.codePage_ = cp;
		if(dlg.doModal(app_.getMainWindow()) != IDOK)
			return OPENRESULT_USERCANCELED;
		cp = dlg.codePage_;
	}

	EditDoc::FileIOResult result;
	do {
		FileIOCallback callback(app_, true, buffer.getPathName(), cp);

		result = buffer.load(buffer.getPathName(), buffer.getShareMode(), cp, &callback);
		if(callback.doesUserWantToChangeCodePage()) {
			assert(result == EditDoc::FIR_ABORTED_FOR_UNCONVERTABLE);
			CodePagesDlg dlg(true);
			dlg.codePage_ = cp;
			if(dlg.doModal(app_.getMainWindow()) != IDOK)
				return OPENRESULT_USERCANCELED;
			cp = dlg.codePage_;
			continue;
		}
		break;
	} while(true);

	if(handleFileIOError(buffer.getPathName(), true, result)) {
		app_.getMRUManager().add(buffer.getPathName(), buffer.getCodePage());
		return OPENRESULT_SUCCEEDED;
	} else
		return (result != EditDoc::FIR_ABORTED_FOR_UNCONVERTABLE) ? OPENRESULT_FAILED : OPENRESULT_USERCANCELED;
}

/// obt@̃XgɊÂăC[WXg () 쐬Aj[č\
void BufferList::resetResources() {
	if(icons_.isImageList()) {
		const int c = icons_.getImageCount();
		for(int i = 0; i < c; ++i)
			::DestroyIcon(icons_.getIcon(i, ILD_NORMAL));
		icons_.destroy();
	}
	if(buffers_.empty())
		return;
	icons_.create(::GetSystemMetrics(SM_CXSMICON),
		::GetSystemMetrics(SM_CYSMICON), ILC_COLOR32 | ILC_MASK, 0, static_cast<int>(buffers_.size()));
	while(listMenu_.getItemCount() != 0)
		listMenu_.deleteMenuItem<Menu::BY_POSITION>(0);

	SHFILEINFOW sfi;
	for(size_t i = 0; i < buffers_.size(); ++i) {
		::SHGetFileInfoW(
			(buffers_[i]->getPathName() != 0) ? buffers_[i]->getPathName() : L"",
			0, &sfi, sizeof(SHFILEINFOW), SHGFI_ICON | SHGFI_SMALLICON);
		icons_.add(sfi.hIcon);
		listMenu_.appendMenuItem(static_cast<UINT>(i) + CMD_VIEW_BUFFERLIST_START, 0U);
	}
	bufferBar_.setImageList(icons_);
	if(bufferBar_.isWindowVisible())
		bufferBar_.invalidateRect(0);
}

/**
 *	obt@㏑ۑ
 *	@param index		obt@̃CfNX
 *	@param overwrite	㏑ۑꍇ trueBfalse w肵㏑łȂꍇ̓_CAO\
 *	@param addToMRU		t@Cŋߎgt@Cɒǉ邩Bt@C݂Ȃꍇ▼OύXꍇ̂ݗL
 *	@return				 (ۑKvꍇ true)
 *	@throw std::out_of_range	@a index sȂƂX[
 */
bool BufferList::save(size_t index, bool overwrite /* = true */, bool addToMRU /* = true */) {
	AlphaDoc& buffer = getAt(index);

	// ۑ̕Kv邩?
	if(overwrite && buffer.getPathName() != 0 && !buffer.isModified())
		return true;

	WCHAR fileName[MAX_PATH + 1];
	TextFileFormat format = {buffer.getCodePage(), LB_AUTO};
	bool newName = false;

	// ʖŕۑ or t@C݂Ȃ
	if(!overwrite || buffer.getPathName() == 0 || !toBoolean(::PathFileExistsW(buffer.getPathName()))) {
		AutoZero<OSVERSIONINFOW> osVersion;
		const wstring filterSource = app_.loadString(MSG_SAVE_FILE_FILTER);
		wchar_t* filter = new wchar_t[filterSource.length() + 6];

		osVersion.dwOSVersionInfoSize = sizeof(OSVERSIONINFOW);
		::GetVersionEx(&osVersion);
		filterSource.copy(filter, filterSource.length());
		wcsncpy(filter + filterSource.length(), L"\0*.*\0\0", 6);
		wcscpy(fileName, (buffer.getPathName() != 0) ? buffer.getPathName() : L"");

		AutoZeroLS<OPENFILENAMEW> newOfn;
		AutoZeroLS<OPENFILENAME_NT4W> oldOfn;
		OPENFILENAMEW& ofn = (osVersion.dwMajorVersion > 4) ? newOfn : *reinterpret_cast<OPENFILENAMEW*>(&oldOfn);
		ofn.hwndOwner = app_.getMainWindow().getSafeHwnd();
		ofn.hInstance = ::GetModuleHandle(0);
		ofn.lpstrFilter = filter;
		ofn.lpstrFile = fileName;
		ofn.nMaxFile = MAX_PATH;
		ofn.Flags = OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
			| OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT /* | OFN_SHOWHELP*/;
		ofn.lCustData = reinterpret_cast<LPARAM>(&format);
		ofn.lpfnHook = openFileNameHookProc;
		ofn.lpTemplateName = MAKEINTRESOURCE(IDD_DLG_SAVEFILE);

		bool succeeded = toBoolean(::GetSaveFileNameW(&ofn));
//		DWORD n = ::CommDlgExtendedError();
		delete[] filter;
		if(!succeeded)
			return false;
		newName = true;
	} else
		wcscpy(fileName, buffer.getPathName());

	const bool writeBOM =
		(format.encoding == CP_UTF8 && toBoolean(app_.readIntegerProfile(L"File", L"writeBOMAsUTF8", 0)))
		|| (format.encoding == CPEX_UNICODE_UTF16LE && toBoolean(app_.readIntegerProfile(L"File", L"writeBOMAsUTF16LE", 1)))
		|| (format.encoding == CPEX_UNICODE_UTF16BE && toBoolean(app_.readIntegerProfile(L"File", L"writeBOMAsUTF16BE", 1)))
		|| (format.encoding == CPEX_UNICODE_UTF32LE && toBoolean(app_.readIntegerProfile(L"File", L"writeBOMAsUTF32LE", 1)))
		|| (format.encoding == CPEX_UNICODE_UTF32BE && toBoolean(app_.readIntegerProfile(L"File", L"writeBOMAsUTF32BE", 1)));
	EditDoc::FileIOResult result;

	do {
		FileIOCallback callback(app_, false, fileName, format.encoding);

		result = buffer.save(fileName, writeBOM ? EditDoc::SDO_WRITE_BOM : 0, format.lineBreak, format.encoding, &callback);
		if(callback.doesUserWantToChangeCodePage()) {
			CodePagesDlg dlg(false);
			assert(result == EditDoc::FIR_ABORTED_FOR_UNCONVERTABLE);
			dlg.codePage_ = format.encoding;
			if(dlg.doModal(app_.getMainWindow()) == IDOK) {
				format.encoding = dlg.codePage_;
				continue;
			}
		}
		break;
	} while(true);

	if(addToMRU && newName)
		app_.getMRUManager().add(fileName, format.encoding);

	return true;
}

/**
 *	obt@Sĕۑ
 *	@param addToMRU t@Cŋߎgt@Cɒǉ邩Bt@C݂Ȃꍇ▼OύXꍇ̂ݗL
 *	@return	rŒfȂ true
 */
bool BufferList::saveAll(bool addToMRU /* = true */) {
	for(size_t i = 0; i < buffers_.size(); ++i) {
		if(!save(i, true, addToMRU))
			return false;
	}
	return true;
}

/**
 *	ANeBuȃyCŃobt@ANeBuɂ
 *	@param index				obt@
 *	@throw std::out_of_range	@a index sȂƂX[
 */
void BufferList::setActive(size_t index) {
	editorWindow_.getActivePane().showBuffer(getAt(index));
	fireChangedActiveBuffer();
}

/**
 *	ANeBuȃyCŃobt@ANeBuɂ
 *	@param buffer					obt@
 *	@throw std::invalid_argument	@a buffer sȂƂX[
 */
void BufferList::setActive(const AlphaDoc& buffer) {
	editorWindow_.getActivePane().showBuffer(buffer);
	fireChangedActiveBuffer();
}

/// ReLXgj[蒼
void BufferList::updateContextMenu() {
	while(contextMenu_.getItemCount() > 0)
		contextMenu_.deleteMenuItem<Controls::Menu::BY_POSITION>(0);
	contextMenu_ << Controls::Menu::OwnerDrawnItem(CMD_FILE_CLOSE)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_CLOSEOTHERS)
//		<< sep << Controls::Menu::OwnerDrawnItem(CMD_FILE_PROPERTY)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_OPERATE);
	Controls::Menu* subMenu = new Controls::Menu;
	*subMenu << Controls::Menu::OwnerDrawnItem(CMD_FILE_RENAME)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_COPY) << Controls::Menu::OwnerDrawnItem(CMD_FILE_MOVE)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_DELETE);
	contextMenu_.setChildPopup<Controls::Menu::BY_COMMAND>(CMD_FILE_OPERATE, *subMenu);
	contextMenu_.setDefaultMenuItem<Controls::Menu::BY_COMMAND>(CMD_FILE_CLOSE);
}


// DocumentTypeManager class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
DocumentTypeManager::DocumentTypeManager() {
	DocumentType type;
	type.fileSpec[0] = 0;
	type.name = L"default";
	type.hidden = false;
	documentTypes_.push_back(type);
}

/**
 *	^Cv̒ǉ
 *	@param type						o^镶^Cv
 *	@throw std::invalid_argument	@a type sȂƂX[
 */
void DocumentTypeManager::add(const DocumentType& type) {
	if(type.name.empty())
		throw invalid_argument("Document type name can not be empty.");
	else if(type.fileSpec[0] == 0)
		throw invalid_argument("File name specification can not be empty.");
	documentTypes_.push_back(type);
}

/**
 *	w肵O̕^Cv̔ԍԂ
 *	@param name	^Cv
 *	@return		ԍBȂꍇ0
 */
size_t DocumentTypeManager::find(const wstring& name) const {
	for(size_t i = 1; i < documentTypes_.size(); ++i) {
		if(documentTypes_[i].name == name)
			return i;
	}
	return 0;
}

/**
 *	wʒu̕^CvԂ
 *	@param index	ʒu
 *	@return			^Cv
 */
const DocumentType& DocumentTypeManager::getAt(size_t index) const {
	try {
		return documentTypes_[index];
	} catch(...) {
		throw out_of_range("Specified index is invalid.");
	}
}

/**
 *	gqɓK镶^CvԂ
 *	@param fileName	t@C
 *	@return			^CvBK镶^CvȂꍇ0Ԗ () Ԃ
 */
const DocumentType& DocumentTypeManager::getByFileName(const wstring& fileName) const {
	if(fileName.empty())
		return documentTypes_[0];
	for(size_t i = 1; i < documentTypes_.size(); ++i) {
		if(toBoolean(::PathMatchSpecW(fileName.c_str(), documentTypes_[i].fileSpec)))
			return documentTypes_[i];
	}
	return documentTypes_[0];
}

/// o^Ă镶Sč폜
void DocumentTypeManager::removeAll() {
	documentTypes_.clear();
	DocumentTypeManager();
}

/* [EOF] */