// CodePagesDlg.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "CodePagesDlg.h"
#include "Alpha.h"
#include "../Manah/StandardControls.hpp"
using Alpha::CodePagesDlg;
using namespace Ascension::Encodings;
using namespace std;


/// @see Dialog::onCommand
bool CodePagesDlg::onCommand(WORD id, WORD notifyCode, HWND control) {
	if(id == IDC_LIST_CODEPAGES && notifyCode == LBN_DBLCLK) {
		onOK();
		return true;
	}
	return Dialog::onCommand(id, notifyCode, control);
}

/// @see Dialog::onInitDialog
bool CodePagesDlg::onInitDialog(HWND focusWindow, LPARAM initParam) {
	Dialog::onInitDialog(focusWindow, initParam);

	const EncoderFactory& encoders = EncoderFactory::getInstance();
	set<CodePage> codePages;

	encoders.enumCodePages(codePages);
	for(set<CodePage>::const_iterator it = codePages.begin(); it != codePages.end(); ++it) {
		if(!forReading_ && (encoders.isCodePageForAutoDetection(*it) || encoders.isCodePageForReadOnly(*it)))
			continue;
		else if(const wstring* name = AlphaApp::getInstance().getCodePageName(*it))
			codepageList_.setItemData(codepageList_.addString(((codePage_ == *it) ? *name + L" *" : *name).c_str()), *it);
	}
	const int c = codepageList_.getCount();
	for(int i = 0; i < c; ++i) {
		if(codePage_ == codepageList_.getItemData(i)) {
			codepageList_.setCurSel(i);
			break;
		}
	}

	return true;
}

/// @see Dialog::onOK
void CodePagesDlg::onOK() {
	codePage_ = static_cast<CodePage>(codepageList_.getItemData(codepageList_.getCurSel()));
	Dialog::onOK();
}

/* [EOF] */