// CommandManager.h
// (c) 2004-2005 exeal

#ifndef COMMAND_MANAGER_H_
#define COMMAND_MANAGER_H_

#include "Alpha.h"
#include "TemporaryMacro.h"
#include "AlphaScriptHost.h"
#include "AlphaInterfaces.h"
#include "../Manah/File.hpp"
#include "../Manah/CommonControls.hpp"
#include <map>
#define _COM_NO_STANDARD_GUIDS_
#include "msxml3.tlh"	// for MSXML2::ISAXAttributes


namespace Alpha {
	class AlphaApp;

	/// Alpha ̑SR}hǗ
	class CommandManager {
		// RXgN^
	public:
		CommandManager(AlphaApp& app);
		~CommandManager();

		// 
	public:
		enum IconState {ICONSTATE_NORMAL, ICONSTATE_DISABLED, ICONSTATE_HOT};

		// \bh
	public:
		bool					createImageList(const std::wstring& directory);
		bool					executeCommand(CommandID id, bool userContext);
		std::wstring			getCaption(CommandID id) const;
		std::wstring			getDescription(CommandID id) const;
		std::size_t				getIconIndex(CommandID id) const throw();
		const Manah::Windows::Controls::ImageList&
								getImageList(IconState state) const throw();
		CommandID				getLastCommand() const throw();
		std::wstring			getName(CommandID id) const;
		const TemporaryMacro&	getTemporaryMacro() const throw();
		bool					isChecked(CommandID id) const;
		bool					isEnabled(CommandID id, bool userContext) const;
		bool					isRecordable(CommandID id) const;

		// f[^o
	private:
		AlphaApp&							app_;
		TemporaryMacro						temporaryMacro_;
		Manah::Windows::Controls::ImageList	icons_[3];
		std::map<CommandID, std::size_t>	iconIndices_;
		CommandID							lastCommandID_;
		static const COLORREF				ICON_MASK_COLOR = RGB(0xFF, 0x00, 0xFF);
	};

	/// Alpha ̃R}h
	class Command : Manah::Noncopyable {
	public:
		/// fXgN^
		virtual ~Command() {}
	public:
		/// R}hs
		virtual bool execute() = 0;
		/// gݍ݃R}h̎ʎqԂ
		/// @throw std::logic_error	g݃R}hłȂꍇX[
		virtual CommandID getID() const = 0;
		/// gݍ݃R}h𒲂ׂ
		virtual bool isBuiltIn() const = 0;
	};

	/// L[蓖ĉ\R}h
	class KeyAssignableCommand : virtual public Command {
	public:
		/// fXgN^
		virtual ~KeyAssignableCommand() {}
	public:
		/// 
		virtual  void copy(KeyAssignableCommand*& p) const = 0;
	};

	/// iL\R}h
	class SerializableCommand : virtual public Command {
	public:
		/// fXgN^
		virtual ~SerializableCommand() {}
	public:
		/// 
		virtual void copy(SerializableCommand*& p) const = 0;
		/// XML ɕۑꍇ̃eLXgЂԂ
		virtual void getXMLOutput(std::wostringstream& os) const = 0;
	};

	/// gݍ݃R}h
	class BuiltInCommand : virtual public KeyAssignableCommand, virtual public SerializableCommand {
	public:
		explicit BuiltInCommand(CommandID id) : id_(id) {}
	public:
		void copy(KeyAssignableCommand*& p) const {p = new BuiltInCommand(id_);}
		void copy(SerializableCommand*& p) const {p = new BuiltInCommand(id_);}
		bool execute() {return AlphaApp::getInstance().commandManager_->executeCommand(id_, true);}
		CommandID getID() const {return id_;}
		void getXMLOutput(std::wostringstream& os) const {os << L"<built-in-command identifier=\"" << id_ << L"\" />\n";}
		bool isBuiltIn() const {return true;}
		static BuiltInCommand* parseXMLInput(
				const wchar_t* elementName, std::size_t elementNameLength, MSXML2::ISAXAttributes& attributes) {
			if(elementNameLength == 16 && std::wcsncmp(elementName, L"built-in-command", elementNameLength) == 0) {
				wchar_t* p;
				int cch;
				if(SUCCEEDED(attributes.getValueFromQName(
						reinterpret_cast<ushort*>(L"identifier"), 10, reinterpret_cast<ushort**>(&p), &cch)))
					return new BuiltInCommand(static_cast<CommandID>(std::wcstoul(p, 0, 10)));
			}
			return 0;
		}
	private:
		CommandID id_;
	};

	/// XNvgR}h
	class ScriptletCommand : virtual public KeyAssignableCommand {
	public:
		explicit ScriptletCommand(IDispatch& function) : function_(function) {function.AddRef();}
		~ScriptletCommand() {function_.Release();}
	public:
		void copy(KeyAssignableCommand*& p) const {p = new ScriptletCommand(function_);}
		bool execute() {return SUCCEEDED(AlphaScriptHost::callFunction(function_));}
		CommandID getID() const {throw std::logic_error("This command is not built-in.");}
		bool isBuiltIn() const {return false;}
	private:
		IDispatch& function_;
	};

	/// ̓R}h
	class CharacterInputCommand : virtual public SerializableCommand {
	public:
		explicit CharacterInputCommand(Ascension::CodePoint cp) : cp_(cp) {}
	public:
		void copy(SerializableCommand*& p) const {p = new CharacterInputCommand(cp_);}
		bool execute() {return AlphaApp::getInstance().getBufferList().getActiveView().inputCharacter(cp_);}
		CommandID getID() const {throw std::logic_error("This command is not built-in.");}
		void getXMLOutput(std::wostringstream& os) const {os << L"<char-input-command code-point=\"" << cp_ << L"\" />\n";}
		bool isBuiltIn() const {return false;}
		static CharacterInputCommand* parseXMLInput(
				const wchar_t* elementName, std::size_t elementNameLength, MSXML2::ISAXAttributes& attributes) {
			if(elementNameLength == 18 && std::wcsncmp(elementName, L"char-input-command", elementNameLength) == 0) {
				wchar_t* p;
				int cch;
				if(SUCCEEDED(attributes.getValueFromQName(
						reinterpret_cast<ushort*>(L"code-point"), 10, reinterpret_cast<ushort**>(&p), &cch)))
					return new CharacterInputCommand(std::wcstoul(p, 0, 10));
			}
			return 0;
		}
	private:
		Ascension::CodePoint cp_;
	};

	/// eLXg̓R}h
	class TextInputCommand : virtual public SerializableCommand {
	public:
		TextInputCommand(const Ascension::string_t& text, bool asRectangle) : text_(text), asRectangle_(asRectangle) {}
		explicit TextInputCommand(bool asRectangle) : asRectangle_(asRectangle) {}
	public:
		void copy(SerializableCommand*& p) const {p = new TextInputCommand(text_, asRectangle_);}
		bool execute() {
			return AlphaApp::getInstance().getBufferList().getActiveView().insertText(
				text_.data(), text_.data() + text_.length(), asRectangle_);}
		CommandID getID() const {throw std::logic_error("This command is not built-in.");}
		void getXMLOutput(std::wostringstream& os) const {
			os << L"<text-input-command";
			if(asRectangle_)
				os << L" rectangle=\"true\" ";
			os << L"><![CDATA[" << text_ << L"]]></text-input-command>\n";
		}
		bool isBuiltIn() const {return false;}
		static TextInputCommand* parseXMLInput(
				const wchar_t* elementName, std::size_t elementNameLength, MSXML2::ISAXAttributes& attributes) {
			if(elementNameLength == 18 && std::wcsncmp(elementName, L"text-input-command", elementNameLength) == 0) {
				wchar_t* p;
				int cch;
				if(SUCCEEDED(attributes.getValueFromQName(
						reinterpret_cast<ushort*>(L"rectangle"), 8, reinterpret_cast<ushort**>(&p), &cch))
						&& cch == 4 && std::wcsncmp(p, L"true", cch) == 0)
					return new TextInputCommand(true);
				else
					return new TextInputCommand(false);
			}
			return 0;
		}
		void setText(const Ascension::string_t& text) {text_.assign(text);}
	private:
		Ascension::string_t	text_;
		bool				asRectangle_;
	};

	/**
	 *	R}hɑΉACR̃C[WXg̈ʒuԂ
	 *	@param id	R}h ID
	 *	@return		CfbNXBACRꍇ -1
	 */
	inline std::size_t CommandManager::getIconIndex(CommandID id) const throw() {
		std::map<CommandID, std::size_t>::const_iterator it;
		return (iconIndices_.end() == (it = iconIndices_.find(id))) ? -1 : it->second;
	}

	/**
	 *	C[WXgԂ
	 *	@param state	ACȐ
	 *	@return			C[WXg
	 */
	inline const Manah::Windows::Controls::ImageList& CommandManager::getImageList(CommandManager::IconState state) const throw() {return icons_[state];}

	/// L[{[h}NIuWFNgԂ
	inline const TemporaryMacro& CommandManager::getTemporaryMacro() const throw() {return temporaryMacro_;}

	/// ŌɎsR}h̎ʒlԂ
	inline CommandID CommandManager::getLastCommand() const throw() {return lastCommandID_;}
} // namespace Alpha

#endif /* _COMMAND_MANAGER_H_ */

/* [EOF] */