// EventHandlerScript.cpp
// (c) 2004-2006 exeal

#include "StdAfx.h"
#include "EventHandlerScript.h"
#include "Ambient.h"
#include "AlphaScriptHost.h"
#include "Ascension\Encodings\Encoder.h"
#include "../Armaiti/ComBasic.hpp"
#include <shlwapi.h>	// PathFindFileName
using namespace Ascension::Encodings;
using namespace Alpha;
using namespace Armaiti;
using namespace std;


/**
 *	RXgN^
 *	@param window	XNvgzXg̃EBhE
 *	@param app		AvP[V
 */
EventHandlerScript::EventHandlerScript(HWND window, AlphaApp& app) : window_(window), scriptHost_(0), app_(app) {
	assert(toBoolean(::IsWindow(window)));
}

/// fXgN^
EventHandlerScript::~EventHandlerScript() {
	if(scriptHost_ != 0) {
		scriptHost_->releaseTopLevelObjects();
		scriptHost_->closeEngine();
		scriptHost_->Release();
	}
}

/**
 *	CxgnhĂяo
 *	@param handlerName	nh
 *	@param params		
 *	@return				IDispatch::Invoke Ɠ
 */
HRESULT EventHandlerScript::invoke(const OLECHAR* handlerName, DISPPARAMS& params) {
	if(handlerName == 0)
		return E_INVALIDARG;
	if(scriptHost_ == 0)
		return E_UNEXPECTED;

//	// ݂̃XbhXNvgGW쐬XbhŖ
//	// GUI XbhɈϏ
//	if(::GetCurrentThreadId() != ::GetWindowThreadProcessId(window_, 0)) {
//		pair<const OLECHAR*, DISPPARAMS*> invocation;
//		invocation.first = handlerName;
//		invocation.second = &params;
//		::SendMessageW(window_, MYWM_EVENTHANDLER, 0, reinterpret_cast<LPARAM>(&invocation));
//		return S_OK;
//	}

	HRESULT hr;
	ComPtr<IActiveScript> scriptEngine;
	ComPtr<IDispatch> handler;
	DISPID dispid;
	unsigned int argErr;

	scriptHost_->getScriptEngine(*&scriptEngine);
	if(FAILED(hr = scriptEngine->GetScriptDispatch(0, &handler)))
		return hr;
	if(FAILED(hr = handler->GetIDsOfNames(IID_NULL, const_cast<OLECHAR**>(&handlerName), 1, LOCALE_USER_DEFAULT, &dispid)))
		return hr;
	hr = handler->Invoke(dispid, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, 0, 0, &argErr);

	return hr;
}

/**
 *	XNvgt@Cǂݍ݁A͂
 *	@param fileName	t@C (ChJ[hLBŏɃ}b`t@Cǂݍ܂)
 *	@return			
 */
bool EventHandlerScript::loadScript(const WCHAR* fileName) {
	assert(fileName != 0);
	
	// t@CT
	WIN32_FIND_DATAW wfd;
	wchar_t filePath[MAX_PATH];
	HANDLE find = ::FindFirstFileW(fileName, &wfd);
	if(find == INVALID_HANDLE_VALUE)
		return false;
	::FindClose(find);
	wcscpy(filePath, fileName);
	wcscpy(::PathFindFileNameW(filePath), wfd.cFileName);

	wchar_t* source = 0;
	if(wfd.nFileSizeLow != 0) {
		// XNvgǂݍ
		HANDLE file = ::CreateFileW(filePath, GENERIC_READ,
			FILE_SHARE_READ | FILE_SHARE_WRITE, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
		if(file == INVALID_HANDLE_VALUE)
			return false;
		uchar* const buffer = static_cast<uchar*>(::HeapAlloc(::GetProcessHeap(), HEAP_NO_SERIALIZE, wfd.nFileSizeLow));
		if(buffer == 0) {
			::CloseHandle(file);
			return false;
		}
		DWORD readBytes = 0;
		if(wfd.nFileSizeLow != 0)
			::ReadFile(file, buffer, wfd.nFileSizeLow, &readBytes, 0);
		::CloseHandle(file);
		if(readBytes == 0) {
			::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, buffer);
			return false;
		}

		// UTF-8  UTF-16 ɕϊ
		auto_ptr<Encoder> encoder(EncoderFactory::getInstance().createEncoder(CP_UTF8));
		source = static_cast<wchar_t*>(::HeapAlloc(::GetProcessHeap(), HEAP_NO_SERIALIZE, sizeof(wchar_t) * (readBytes + 1)));
		const size_t len = encoder->toUnicode(source, readBytes, buffer, readBytes);
		source[len] = 0;
		::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, buffer);
	}

	// XNvgGWN
	CLSID clsid;
	app_.getScriptLanguageByFileName(wfd.cFileName, clsid);
	if(clsid == CLSID_NULL)
		AlphaScriptHost::findScriptEngine(wfd.cFileName, clsid);
	if(clsid == CLSID_NULL) {	// gq猾GWłȂ
								// (Ƀ}b`t@Cgقǂ)
		::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, source);
		return false;
	}
	ComPtr<IActiveScript> scriptEngine;
	HRESULT hr = scriptEngine.createInstance(clsid, 0, CLSCTX_INPROC);
	if(FAILED(hr)) {
		::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, source);
		return false;
	}

	// p[T̎擾
	ComPtr<IActiveScriptParse> parser;
	scriptHost_ = new AlphaScriptHost(window_, *scriptEngine);
	scriptHost_->AddRef();
	scriptHost_->setSecurityLevel(true, SSSL_ALLOW);
	scriptHost_->setSecurityLevel(false, SSSL_ALLOW);
	scriptHost_->setScriptFileName(filePath);
	hr = scriptEngine->SetScriptSite(scriptHost_);	// ̃\bhĂяoXbhzXgXbh
//	hr = scriptEngine->SetScriptState(SCRIPTSTATE_INITIALIZED);
	hr = scriptEngine->QueryInterface(IID_IActiveScriptParse, reinterpret_cast<void**>(&parser));

	// gbvxIuWFNg̗p
	ComPtr<Ambient::Application> app;
	app_.getAutomation(*&app);
	scriptHost_->addTopLevelObject(OLESTR("Ambient"), *app, SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
//	scriptHost_->addTopLevelObject(OLESTR("Alpha"), *app, SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
	scriptHost_->addTopLevelObject(OLESTR("WScript"), *(new Ambient::ScriptHost(*scriptHost_)), SCRIPTITEM_ISVISIBLE);
//	scriptHost_->addTopLevelObject(OLESTR("WSH"), *(new Ambient::ScriptHost(scriptHost_)), SCRIPTITEM_ISVISIBLE);

	ITypeLib* ambientTLB;
	if(SUCCEEDED(::LoadTypeLib(Ambient::AmbientTypeLibPath::getPath(), &ambientTLB))) {
		scriptHost_->loadConstants(*ambientTLB);
		ambientTLB->Release();
	}

	// 
	if(SUCCEEDED(hr)) {
		AutoZero<EXCEPINFO> exception;
		hr = parser->InitNew();
		hr = parser->ParseScriptText((source != 0) ? source : OLESTR(""), 0, 0, 0, 0, 0, SCRIPTTEXT_ISVISIBLE, 0, &exception);
	}
	::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, source);
	scriptEngine->SetScriptState(SCRIPTSTATE_CONNECTED);

	if(SUCCEEDED(hr))
		return true;
	else {
		scriptEngine->Close();
		scriptHost_->Release();
		scriptHost_ = 0;
		return false;
	}
}

/* [EOF] */