// ExecuteCommandDlg.h
// (c) 2003-2005 exeal

#ifndef EXECUTE_COMMAND_DLG_H_
#define EXECUTE_COMMAND_DLG_H_
#include "resource.h"
#include "../Manah/Dialog.hpp"
#include "../Manah/StandardControls.hpp"
#include <queue>


namespace Alpha {
	class AlphaApp;

	///	[R}h̎s] _CAO
	class ExecuteCommandDlg : public Manah::Windows::Controls::FixedIDDialog<IDD_DLG_EXECUTECOMMAND> {
		// RXgN^
	public:
		ExecuteCommandDlg(AlphaApp& app, HFONT ioFont);

		// bZ[Wnh
	protected:
		void	onClose();											// WM_CLOSE
		bool	onCommand(WORD id, WORD notifyCode, HWND control);	// WM_COMMAND
		bool	onInitDialog(HWND focusWindow, LPARAM initParam);	// WM_INITDIALOG
		void	onCancel();											// IDCANCEL
		void	onOK();												// IDOK

	private:
		enum ControlState {WAIT_FOR_NEW_COMMAND, EXECUTING, INPUT_IDLE};
		void	appendInput(const char* first, const char* last);
		void	appendOutput(const char* first, const char* last);
		bool	execute(const std::wstring& commandLine, bool consoleProgram);
		bool	rescueUser();
		void	switchControls(ControlState state);

		// f[^o
	private:
		AlphaApp&				app_;
		HFONT					ioFont_;
		std::wstring			cmdLine_;
		std::queue<std::string>	inputQueue_;
		bool					executing_;	// R}hs
		bool					interrupted_;

		Manah::Windows::Controls::ComboBox	commandCombobox_;
		Manah::Windows::Controls::Edit		outputTextbox_;
		Manah::Windows::Controls::Edit		inputTextbox_;
		BEGIN_CONTROL_BINDING()
			BIND_CONTROL(IDC_COMBO_COMMAND, commandCombobox_)
			BIND_CONTROL(IDC_EDIT_OUTPUT, outputTextbox_)
			BIND_CONTROL(IDC_EDIT_INPUT, inputTextbox_)
		END_CONTROL_BINDING()
	};
}

#endif /* _EXECUTE_COMMAND_DLG_H_ */

/* [EOF] */