// FileOperationDlg.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "Alpha.h"
#include "FileOperationDlg.h"
#include <shlobj.h>		// SHBrowseForFolder
#include <shlwapi.h>	// PathAppend
using Alpha::AlphaApp;
using Alpha::FileOperationDlg;
using Alpha::FileOperation;
using namespace std;


/// RXgN^
FileOperationDlg::FileOperationDlg(FileOperation command,
		const basic_string<WCHAR>& fileName) : command_(command), filePath(fileName) {
}

/// @see Dialog::onCommand
bool FileOperationDlg::onCommand(WORD id, WORD notifyCode, HWND control) {
	if(notifyCode == EN_CHANGE) {
		::EnableWindow(getDlgItem(IDOK),
			fileNameTextbox_.getWindowTextLength() != 0 && destPathTextbox_.getWindowTextLength() != 0);
		return true;
	} else if(id == IDC_BTN_BROWSE) {
		wchar_t path[MAX_PATH];
		const wstring caption = AlphaApp::getInstance().loadString(MSG_SELECT_DIRECTORY);
		BROWSEINFOW bi = {getHandle(), 0, path, caption.c_str(), BIF_RETURNONLYFSDIRS, 0, 0L, 0};

		if(LPITEMIDLIST ids = ::SHBrowseForFolderW(&bi)) {
			::SHGetPathFromIDListW(ids, path);
			destPathTextbox_.setWindowText(path);
		}
		return true;
	}
	return Dialog::onCommand(id, notifyCode, control);
}

/// @see Dialog::onInitDialog
bool FileOperationDlg::onInitDialog(HWND focusWindow, LPARAM initParam) {
	Dialog::onInitDialog(focusWindow, initParam);

	const AlphaApp& app = AlphaApp::getInstance();
	wostringstream title;
	wstring::size_type i = filePath.rfind(L'\\');

	fileNameTextbox_.setWindowText(filePath.substr(i + 1).c_str());
	destPathTextbox_.setWindowText(filePath.substr(0, i).c_str());

	switch(command_) {
	case CMD_FILE_RENAME:
		::EnableWindow(getDlgItem(IDC_BTN_BROWSE), false);
		title << app.loadString(MSG_RENAME_FILE);
		break;
	case CMD_FILE_COPY:	title << app.loadString(MSG_COPY_FILE);	break;
	case CMD_FILE_MOVE:	title << app.loadString(MSG_MOVE_FILE);	break;
	}
	title << L" - " << app.loadString(MSG_FILE_OPERATION);
	setWindowText(title.str().c_str());

	return true;
}

/// @see Dialog::onOK
void FileOperationDlg::onOK() {
	WCHAR path[MAX_PATH + 1];

	destPathTextbox_.getWindowText(path, MAX_PATH);

	::PathAppendW(path, fileNameTextbox_.getWindowText().c_str());
	filePath.assign(path);

	Dialog::onOK();
}

/* [EOF] */