// FindDlg.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "FindDlg.h"
#include "Alpha.h"
#include <algorithm>	// std::find
#include "../Manah/StandardControls.hpp"
using Alpha::AlphaApp;
using Alpha::FindDlg;
using namespace Ascension;
using namespace std;
using Manah::Windows::Controls::Menu;


/**
 *	RXgN^
 *	@param app	AvP[V
 */
FindDlg::FindDlg(const AlphaApp& app) : app_(app), optionMenu_(app.loadMenu(IDR_MENU_SEARCHOPTION)) {
	updateHistoryOnNextActivation_[0] = updateHistoryOnNextActivation_[1] = false;
}

/**
 *	ɕǉ
 *	@param text		ǉ镶
 *	@param replace	ûƂ^
 */
void FindDlg::addToHistory(const string_t& text, bool replace) {
	assertValid();

	list<string_t>& target = replace ? replaceWiths_ : findWhats_;
	list<string_t>::iterator it = find(target.begin(), target.end(), text);

	if(it != target.end())
		target.erase(it);
	target.push_front(text);

	if(isWindowVisible()) {
		updateHistory(replace);
		if(replace)
			replaceWithCombobox_.setCurSel(0);
		else
			findWhatCombobox_.setCurSel(0);
	} else
		updateHistoryOnNextActivation_[replace ? 1 : 0] = true;
}

/**
 *	폜
 *	@param replace	ûƂ^
 */
void FindDlg::clearHistory(bool replace) {
	assertValid();
	(replace ? replaceWiths_ : findWhats_).clear();
	if(isWindowVisible())
		updateHistory(replace);
	else
		updateHistoryOnNextActivation_[replace ? 1 : 0] = true;
}

/// Ԃ
string_t FindDlg::getFindText() const {
	assertValidAsWindow();
	return findWhatCombobox_.getWindowText();
}

/// 擾
void FindDlg::getHistory(list<string_t>& findWhats, list<string_t>& replaceWiths) const {
	assertValid();
	findWhats = findWhats_;
	replaceWiths = replaceWiths_;
}

/// uԂ
Ascension::string_t FindDlg::getReplaceText() const {
	assertValidAsWindow();
	return replaceWithCombobox_.getWindowText();
}

/// ݒ
void FindDlg::setHistory(const list<string_t>& findWhats, const list<string_t>& replaceWiths) {
	assertValid();

	// d`FbNȂRs[ (sort -> unique_copy ł)
	findWhats_.clear();
	for(list<string_t>::const_iterator it = findWhats.begin(); it != findWhats.end(); ++it) {
		if(findWhats_.end() == find(findWhats_.begin(), findWhats_.end(), *it))
			findWhats_.push_back(*it);
	}
	replaceWiths_.clear();
	for(list<string_t>::const_iterator it = replaceWiths.begin(); it != replaceWiths.end(); ++it) {
		if(replaceWiths_.end() == find(replaceWiths_.begin(), replaceWiths_.end(), *it))
			replaceWiths_.push_back(*it);
	}

	if(isWindowVisible()) {
		updateHistory(false);
		updateHistory(true);
	} else
		updateHistoryOnNextActivation_[0] = updateHistoryOnNextActivation_[1] = true;
}

/**	
 *	XgR{{bNXɔf
 *	@param	replace	ûƂ^
 */
void FindDlg::updateHistory(bool replace) {
	assertValidAsWindow();

	const list<string_t>& history = replace ? replaceWiths_ : findWhats_;
	Manah::Windows::Controls::ComboBox& combobox = replace ? replaceWithCombobox_ : findWhatCombobox_;
	const int sel = combobox.getCurSel();
	wchar_t* const active = (sel == CB_ERR) ? new wchar_t[combobox.getWindowTextLength() + 1] : 0;

	if(sel == CB_ERR)
		combobox.getWindowText(active, combobox.getWindowTextLength() + 1);
	combobox.resetContent();
	for(list<string_t>::const_iterator it = history.begin(); it != history.end(); ++it)
		combobox.addString(it->c_str());
	if(sel == CB_ERR) {
		combobox.setWindowText(active);
		delete[] active;
	} else
		combobox.setCurSel(sel);
}

/// ̍XV
void FindDlg::updateOptions() {
	assertValidAsWindow();

	AlphaView& activeView = app_.getBufferList().getActiveView();
	TextSearcher::Options options = activeView.getTextSearcher().getOptions();

//	if(isDlgButtonChecked(IDC_CHK_ONLYIDENTIFIERS) == BST_CHECKED)
//		options.generalOptions |= SO_ONLY_IDENTIFIERS;
	options.wholeWord = isDlgButtonChecked(IDC_CHK_WHOLEWORD) == BST_CHECKED;
	switch(searchTypeCombobox_.getCurSel()) {
	case 0:	options.type = TextSearcher::LITERAL;				break;
	case 1:	options.type = TextSearcher::REGULAR_EXPRESSION;	break;
	case 2:	options.type = TextSearcher::MIGEMO;				break;
	}
	switch(caseSensitivityCombobox_.getCurSel()) {
	case 0:	options.caseSensitivity = TextSearcher::CASE_SENSITIVE;		break;
	case 1:	options.caseSensitivity = TextSearcher::CASE_FOLD_ASCII;	break;
	case 2:	options.caseSensitivity = TextSearcher::CASE_FOLD_SIMPLE;	break;
	case 3:	options.caseSensitivity = TextSearcher::CASE_FOLD_FULL;		break;
	}

#define CHECK_OPTION(id, option)	\
	options.foldings[FoldingOptions::option] = toBoolean(menu.getMenuItemState<Menu::BY_COMMAND>(id) & MFS_CHECKED)
	{
		Menu menu = optionMenu_.getSubMenu(0).getSubMenu(0);
		CHECK_OPTION(IDC_CHK_IGNOREPUNCTUATIONS, SKIP_PUNCTUATIONS);
		CHECK_OPTION(IDC_CHK_IGNORESYMBOLS, SKIP_SYMBOLS);
		CHECK_OPTION(IDC_CHK_IGNOREWHITESPACES, SKIP_WHITESPACES);
		CHECK_OPTION(IDC_CHK_IGNOREDIACRITICS, SKIP_DIACRITICS);
		CHECK_OPTION(IDC_CHK_IGNOREVOWELS, SKIP_VOWELS);
		CHECK_OPTION(IDC_CHK_IGNOREKASHIDA, SKIP_KASHIDA);
		CHECK_OPTION(IDC_CHK_IGNORECONTROLS, SKIP_CONTROLS);
	}{
		Menu menu = optionMenu_.getSubMenu(0).getSubMenu(1);
		CHECK_OPTION(IDC_CHK_ACCENTREMOVAL, ACCENT_REMOVAL);
		CHECK_OPTION(IDC_CHK_CANONICALDUPLICATESFOLDING, CANONICAL_DUPLICATES);
		CHECK_OPTION(IDC_CHK_DASHESFOLDING, DASHES);
		CHECK_OPTION(IDC_CHK_GREEKLETTERFORMSFOLDING, GREEK_LETTERFORMS);
		CHECK_OPTION(IDC_CHK_HEBREWALTERNATESFOLDING, HEBREW_ALTERNATES);
		CHECK_OPTION(IDC_CHK_JAMOFOLDING, JAMO);
		CHECK_OPTION(IDC_CHK_MATHSYMBOLFOLDING, MATH_SYMBOL);
		CHECK_OPTION(IDC_CHK_NATIVEDIGITFOLDING, NATIVE_DIGIT);
		CHECK_OPTION(IDC_CHK_NOBREAKFOLDING, NOBREAK);
		CHECK_OPTION(IDC_CHK_OVERLINEFOLDING, OVERLINE);
		CHECK_OPTION(IDC_CHK_POSITIONALFORMSFOLDING, POSITIONAL_FORMS);
		CHECK_OPTION(IDC_CHK_SMALLFORMSFOLDING, SMALL_FORMS);
		CHECK_OPTION(IDC_CHK_SPACEFOLDING, SPACE);
		CHECK_OPTION(IDC_CHK_SPACINGACCENTS, SPACING_ACCENTS);
		CHECK_OPTION(IDC_CHK_SUBSCRIPTFOLDING, SUBSCRIPT);
		CHECK_OPTION(IDC_CHK_SYMBOLFOLDING, SYMBOL);
		CHECK_OPTION(IDC_CHK_UNDERLINEFOLDING, UNDERLINE);
		CHECK_OPTION(IDC_CHK_VERTICALFORMSFOLDING, VERTICAL_FORMS);
		CHECK_OPTION(IDC_CHK_DIACRITICREMOVAL, DIACRITIC_REMOVAL);
		CHECK_OPTION(IDC_CHK_HANRADICALFOLDING, HAN_RADICAL);
		CHECK_OPTION(IDC_CHK_KANAFOLDING, KANA);
		CHECK_OPTION(IDC_CHK_LETTERFORMSFOLDING, LETTER_FORMS);
		CHECK_OPTION(IDC_CHK_SIMPLIFIEDHANFOLDING, SIMPLIFIED_HAN);
		CHECK_OPTION(IDC_CHK_SUPERSCRIPTFOLDING, SUPERSCRIPT);
		CHECK_OPTION(IDC_CHK_SUZHOUNUMERALFOLDING, SUZHOU_NUMERAL);
		CHECK_OPTION(IDC_CHK_WIDTHFOLDING, WIDTH);
	}{
		Menu menu = optionMenu_.getSubMenu(0).getSubMenu(2);
		CHECK_OPTION(IDC_CHK_CIRCLEDSYMBOLSEXPANSION, EXPAND_CIRCLED_SYMBOLS);
		CHECK_OPTION(IDC_CHK_DOTTED, EXPAND_DOTTED);
		CHECK_OPTION(IDC_CHK_ELLIPSISEXPANSION, EXPAND_ELLIPSIS);
		CHECK_OPTION(IDC_CHK_FRACTIONEXPANSION, EXPAND_FRACTION);
		CHECK_OPTION(IDC_CHK_INTEGRALEXPANSION, EXPAND_INTEGRAL);
		CHECK_OPTION(IDC_CHK_LIGATUREEXPANSIONMISC, EXPAND_LIGATURE);
		CHECK_OPTION(IDC_CHK_PARENTHESIZED, EXPAND_PARENTHESIZED);
		CHECK_OPTION(IDC_CHK_PRIMESEXPANSION, EXPAND_PRIMES);
		CHECK_OPTION(IDC_CHK_ROMANNUMERALS, EXPAND_ROMAN_NUMERALS);
		CHECK_OPTION(IDC_CHK_SQUARED, EXPAND_SQUARED);
		CHECK_OPTION(IDC_CHK_SQUAREDUNMARKED, EXPAND_SQUARED_UNMARKED);
		CHECK_OPTION(IDC_CHK_DIGRAPHS, EXPAND_DIGRAPH);
		CHECK_OPTION(IDC_CHK_OTHERMULTIGRAPHS, EXPAND_OTHER_MULTIGRAPHS);
	}
#undef CHECK_OPTION
	activeView.getTextSearcher().setOptions(options);
}

/// @see Dialog::onActivate
void FindDlg::onActivate(UINT state, HWND previousWindow, bool minimize) {
	if(state == WA_INACTIVE)
		updateOptions();
	else {
		const AlphaView& activeView = app_.getBufferList().getActiveView();
		const bool hasFindText = findWhatCombobox_.getWindowTextLength() != 0;
		const bool hasSelection = !activeView.getSelection().isEmpty();
		const bool readOnly = activeView.getDocument().isReadOnly();
		const bool onlySelection = isDlgButtonChecked(IDC_RADIO_SELECTION) == BST_CHECKED;
		const TextSearcher::Options& options = activeView.getTextSearcher().getOptions();

		if(updateHistoryOnNextActivation_[0]) {
			updateHistory(false);
			updateHistoryOnNextActivation_[0] = false;
		}
		if(updateHistoryOnNextActivation_[1]) {
			updateHistory(true);
			updateHistoryOnNextActivation_[1] = false;
		}

		if(!hasSelection)
			checkRadioButton(IDC_RADIO_SELECTION, IDC_RADIO_WHOLEFILE, IDC_RADIO_WHOLEFILE);
		::EnableWindow(getDlgItem(CMD_SEARCH_FINDNEXT), hasFindText && !onlySelection);
		::EnableWindow(getDlgItem(CMD_SEARCH_FINDPREV), hasFindText && !onlySelection);
		::EnableWindow(getDlgItem(CMD_SEARCH_BOOKMARKALL), hasFindText);
		::EnableWindow(getDlgItem(CMD_SEARCH_REPLACEANDNEXT), hasFindText && !onlySelection && !readOnly);
		::EnableWindow(getDlgItem(CMD_SEARCH_REPLACEALL), hasFindText && !readOnly);
		::EnableWindow(getDlgItem(IDC_RADIO_SELECTION), hasSelection);
		checkDlg2StateButton(IDC_CHK_WHOLEWORD, options.wholeWord);

		if(options.type == TextSearcher::LITERAL)
			searchTypeCombobox_.setCurSel(0);
		else if(options.type == TextSearcher::REGULAR_EXPRESSION)
			searchTypeCombobox_.setCurSel(1);
		else if(options.type == TextSearcher::MIGEMO)
			searchTypeCombobox_.setCurSel(2);

		if(options.caseSensitivity == TextSearcher::CASE_FOLD_ASCII)
			caseSensitivityCombobox_.setCurSel(1);
		else if(options.caseSensitivity == TextSearcher::CASE_FOLD_SIMPLE)
			caseSensitivityCombobox_.setCurSel(2);
		else if(options.caseSensitivity == TextSearcher::CASE_FOLD_FULL)
			caseSensitivityCombobox_.setCurSel(3);
		else
			caseSensitivityCombobox_.setCurSel(0);

#define CHECK_IGNORANCE_OPTION(id, option)	\
	ignoranceMenu.checkMenuItem<Menu::BY_COMMAND>(id, options.foldings[FoldingOptions::option])
#define CHECK_FOLDING_OPTION(id, option)	\
	foldingMenu.checkMenuItem<Menu::BY_COMMAND>(id, options.foldings[FoldingOptions::option])
#define CHECK_PROVISIONAL_FOLDING_OPTION(id, option)	\
	foldingMenu.checkMenuItem<Menu::BY_COMMAND>(id, options.foldings[FoldingOptions::option])
#define CHECK_EXPANSION_OPTION(id, option)	\
	expansionMenu.checkMenuItem<Menu::BY_COMMAND>(id, options.foldings[FoldingOptions::option])
		Menu ignoranceMenu = optionMenu_.getSubMenu(0).getSubMenu(0);
		Menu foldingMenu = optionMenu_.getSubMenu(0).getSubMenu(1);
		Menu expansionMenu = optionMenu_.getSubMenu(0).getSubMenu(2);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREPUNCTUATIONS, SKIP_PUNCTUATIONS);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNORESYMBOLS, SKIP_SYMBOLS);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREWHITESPACES, SKIP_WHITESPACES);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREDIACRITICS, SKIP_DIACRITICS);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREVOWELS, SKIP_VOWELS);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREKASHIDA, SKIP_KASHIDA);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNORECONTROLS, SKIP_CONTROLS);
		CHECK_FOLDING_OPTION(IDC_CHK_ACCENTREMOVAL, ACCENT_REMOVAL);
		CHECK_FOLDING_OPTION(IDC_CHK_CANONICALDUPLICATESFOLDING, CANONICAL_DUPLICATES);
		CHECK_FOLDING_OPTION(IDC_CHK_DASHESFOLDING, DASHES);
		CHECK_FOLDING_OPTION(IDC_CHK_GREEKLETTERFORMSFOLDING, GREEK_LETTERFORMS);
		CHECK_FOLDING_OPTION(IDC_CHK_HEBREWALTERNATESFOLDING, HEBREW_ALTERNATES);
		CHECK_FOLDING_OPTION(IDC_CHK_JAMOFOLDING, JAMO);
		CHECK_FOLDING_OPTION(IDC_CHK_MATHSYMBOLFOLDING, MATH_SYMBOL);
		CHECK_FOLDING_OPTION(IDC_CHK_NATIVEDIGITFOLDING, NATIVE_DIGIT);
		CHECK_FOLDING_OPTION(IDC_CHK_NOBREAKFOLDING, NOBREAK);
		CHECK_FOLDING_OPTION(IDC_CHK_OVERLINEFOLDING, OVERLINE);
		CHECK_FOLDING_OPTION(IDC_CHK_POSITIONALFORMSFOLDING, POSITIONAL_FORMS);
		CHECK_FOLDING_OPTION(IDC_CHK_SMALLFORMSFOLDING, SMALL_FORMS);
		CHECK_FOLDING_OPTION(IDC_CHK_SPACEFOLDING, SPACE);
		CHECK_FOLDING_OPTION(IDC_CHK_SPACINGACCENTS, SPACING_ACCENTS);
		CHECK_FOLDING_OPTION(IDC_CHK_SUBSCRIPTFOLDING, SUBSCRIPT);
		CHECK_FOLDING_OPTION(IDC_CHK_SYMBOLFOLDING, SYMBOL);
		CHECK_FOLDING_OPTION(IDC_CHK_UNDERLINEFOLDING, UNDERLINE);
		CHECK_FOLDING_OPTION(IDC_CHK_VERTICALFORMSFOLDING, VERTICAL_FORMS);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_DIACRITICREMOVAL, DIACRITIC_REMOVAL);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_HANRADICALFOLDING, HAN_RADICAL);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_KANAFOLDING, KANA);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_LETTERFORMSFOLDING, LETTER_FORMS);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_SIMPLIFIEDHANFOLDING, SIMPLIFIED_HAN);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_SUPERSCRIPTFOLDING, SUPERSCRIPT);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_SUZHOUNUMERALFOLDING, SUZHOU_NUMERAL);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_WIDTHFOLDING, WIDTH);
		CHECK_EXPANSION_OPTION(IDC_CHK_CIRCLEDSYMBOLSEXPANSION, EXPAND_CIRCLED_SYMBOLS);
		CHECK_EXPANSION_OPTION(IDC_CHK_DOTTED, EXPAND_DOTTED);
		CHECK_EXPANSION_OPTION(IDC_CHK_ELLIPSISEXPANSION, EXPAND_ELLIPSIS);
		CHECK_EXPANSION_OPTION(IDC_CHK_FRACTIONEXPANSION, EXPAND_FRACTION);
		CHECK_EXPANSION_OPTION(IDC_CHK_INTEGRALEXPANSION, EXPAND_INTEGRAL);
		CHECK_EXPANSION_OPTION(IDC_CHK_LIGATUREEXPANSIONMISC, EXPAND_LIGATURE);
		CHECK_EXPANSION_OPTION(IDC_CHK_PARENTHESIZED, EXPAND_PARENTHESIZED);
		CHECK_EXPANSION_OPTION(IDC_CHK_PRIMESEXPANSION, EXPAND_PRIMES);
		CHECK_EXPANSION_OPTION(IDC_CHK_ROMANNUMERALS, EXPAND_ROMAN_NUMERALS);
		CHECK_EXPANSION_OPTION(IDC_CHK_SQUARED, EXPAND_SQUARED);
		CHECK_EXPANSION_OPTION(IDC_CHK_SQUAREDUNMARKED, EXPAND_SQUARED_UNMARKED);
		CHECK_EXPANSION_OPTION(IDC_CHK_DIGRAPHS, EXPAND_DIGRAPH);
		CHECK_EXPANSION_OPTION(IDC_CHK_OTHERMULTIGRAPHS, EXPAND_OTHER_MULTIGRAPHS);
#undef CHECK_IGNORANCE_OPTION
#undef CHECK_FOLDING_OPTION
#undef CHECK_PROVISIONAL_FOLDING_OPTION
#undef CHECK_EXPANSION_OPTION
	}
}

/// @see CDialog::OnCancel
void FindDlg::onCancel() {
	onClose();
}

/// @see CDialog::OnClose
void FindDlg::onClose() {
	showWindow(SW_HIDE);
//	Dialog::onClose();
}

/// @see Dialog::onCommand
bool FindDlg::onCommand(WORD id, WORD notifyCode, HWND control) {
	bool enableCommandsAsOnlySelection = true;

	switch(id) {
	case CMD_SEARCH_FINDNEXT:		// []
	case CMD_SEARCH_FINDPREV:		// [O]
	case CMD_SEARCH_BOOKMARKALL:	// [ׂă}[N]
	case CMD_SEARCH_REPLACEALL:		// [ׂĒu]
	case CMD_SEARCH_REPLACEANDNEXT:	// [u]
		getParent().sendMessage(WM_COMMAND, MAKEWPARAM(id, notifyCode), reinterpret_cast<LPARAM>(control));
		return true;
	case IDC_COMBO_FINDWHAT:	// [镶]
		if(notifyCode != CBN_EDITCHANGE && notifyCode != CBN_SELCHANGE)
			break;
		if(notifyCode == CBN_EDITCHANGE)
			enableCommandsAsOnlySelection = ::GetWindowTextLength(getDlgItem(IDC_COMBO_FINDWHAT)) != 0;
		::EnableWindow(getDlgItem(CMD_SEARCH_BOOKMARKALL), enableCommandsAsOnlySelection);
		::EnableWindow(getDlgItem(CMD_SEARCH_REPLACEALL),
			enableCommandsAsOnlySelection && !app_.getBufferList().getActive().isReadOnly());
		/* fall-through */
	case IDC_RADIO_WHOLEFILE:	// [t@CS]
	case IDC_RADIO_SELECTION:	// [I͈]
		if(isDlgButtonChecked(IDC_RADIO_SELECTION))
			enableCommandsAsOnlySelection = false;
		::EnableWindow(getDlgItem(CMD_SEARCH_FINDNEXT), enableCommandsAsOnlySelection);
		::EnableWindow(getDlgItem(CMD_SEARCH_FINDPREV), enableCommandsAsOnlySelection);
		::EnableWindow(getDlgItem(CMD_SEARCH_REPLACEANDNEXT),
			enableCommandsAsOnlySelection && !app_.getBufferList().getActive().isReadOnly());
		break;
	case IDC_BTN_BROWSE: {	// [gIvV]
			RECT rect;
			::GetWindowRect(getDlgItem(IDC_BTN_BROWSE), &rect);
			optionMenu_.getSubMenu(0).trackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, rect.left, rect.bottom, *this);
		}
		break;
	default:
		if(id >= IDC_CHK_IGNOREPUNCTUATIONS && id <= IDC_CHK_IGNORECONTROLS) {
			Menu menu = optionMenu_.getSubMenu(0).getSubMenu(0);
			menu.checkMenuItem<Menu::BY_COMMAND>(id, !toBoolean(menu.getMenuItemState<Menu::BY_COMMAND>(id) & MFS_CHECKED));
		} else if(id >= IDC_CHK_ACCENTREMOVAL && id <= IDC_CHK_VERTICALFORMSFOLDING) {
			Menu menu = optionMenu_.getSubMenu(0).getSubMenu(1);
			menu.checkMenuItem<Menu::BY_COMMAND>(id, !toBoolean(menu.getMenuItemState<Menu::BY_COMMAND>(id) & MFS_CHECKED));
		} else if(id >= IDC_CHK_CIRCLEDSYMBOLSEXPANSION && id <= IDC_CHK_OTHERMULTIGRAPHS) {
			Menu menu = optionMenu_.getSubMenu(0).getSubMenu(2);
			menu.checkMenuItem<Menu::BY_COMMAND>(id, !toBoolean(menu.getMenuItemState<Menu::BY_COMMAND>(id) & MFS_CHECKED));
		} else if(id >= IDC_CHK_DIACRITICREMOVAL && id <= IDC_CHK_WIDTHFOLDING) {
			Menu menu = optionMenu_.getSubMenu(0).getSubMenu(1);
			menu.checkMenuItem<Menu::BY_COMMAND>(id, !toBoolean(menu.getMenuItemState<Menu::BY_COMMAND>(id) & MFS_CHECKED));
		}
		break;
	}
	return Dialog::onCommand(id, notifyCode, control);
}

/// @see Dialog::onInitDialog
bool FindDlg::onInitDialog(HWND focusWindow, LPARAM initParam) {
	Dialog::onInitDialog(focusWindow, initParam);

	modifyStyleEx(0, WS_EX_LAYERED);
	setLayeredWindowAttributes(0, 220, LWA_ALPHA);

	searchTypeCombobox_.addString(app_.loadString(MSG_LITERAL_SEARCH).c_str());
	searchTypeCombobox_.addString(app_.loadString(MSG_REGEXP_SEARCH).c_str());
//	searchTypeCombobox_.addString(app_.loadString(MSG_WILDCARD_SEARCH).c_str());
	searchTypeCombobox_.addString(app_.loadString(MSG_MIGEMO_SEARCH).c_str());

	caseSensitivityCombobox_.addString(app_.loadString(MSG_MATCH_CASE).c_str());
	caseSensitivityCombobox_.addString(app_.loadString(MSG_IGNORE_ASCII_CASE).c_str());
	caseSensitivityCombobox_.addString(app_.loadString(MSG_CASEFOLDING_SIMPLE).c_str());
//	caseSensitivityCombobox_.addString(app_.loadString(MSG_CASEFOLDING_FULL).c_str());
	checkRadioButton(IDC_RADIO_SELECTION, IDC_RADIO_WHOLEFILE, IDC_RADIO_WHOLEFILE);

	onCommand(IDC_COMBO_FINDWHAT, CBN_EDITCHANGE, getDlgItem(IDC_COMBO_FINDWHAT));

	return true;
}

/* [EOF] */