// FindDlg.h
// (c) 2003-2006 exeal

#ifndef FIND_DLG_H_
#define FIND_DLG_H_
#include "resource.h"
#include "../Manah/Dialog.hpp"
#include "../Manah/StandardControls.hpp"
#include "../Manah/Menu.hpp"
#include "Ascension\TextSearcher.h"
#include <list>


namespace Alpha {
	class AlphaApp;
	class AlphaView;

	/// [ƒu] _CAO
	class FindDlg : public Manah::Windows::Controls::Layered<
			Manah::Windows::Controls::FixedIDDialog<IDD_DLG_SEARCH> > {
		// RXgN^
	public:
		FindDlg(const AlphaApp& app);

		// \bh
	public:
		void				addToHistory(const Ascension::string_t& text, bool replace);
		void				clearHistory(bool replace);
		Ascension::string_t	getFindText() const;
		void				getHistory(
								std::list<Ascension::string_t>& findWhats,
								std::list<Ascension::string_t>& replaceWiths) const;
		Ascension::string_t	getReplaceText() const;
		void				setHistory(
								const std::list<Ascension::string_t>& findWhats,
								const std::list<Ascension::string_t>& replaceWiths);
		void				updateOptions();
	protected:
		void	updateHistory(bool replace);

		// bZ[Wnh
	protected:
		void	onActivate(UINT state, HWND previousWindow, bool minimized);	// WM_ACTIVATE
		void	onCancel();														// IDCANCEL
		void	onClose();														// WM_CLOSE
		bool	onCommand(WORD id, WORD notifyCode, HWND control);				// WM_COMMAND
		bool	onInitDialog(HWND focusWindow, LPARAM initParam);				// WM_INITDIALOG

		//f[^o
	private:
		const AlphaApp&					app_;
		std::list<Ascension::string_t>	findWhats_;
		std::list<Ascension::string_t>	replaceWiths_;
		bool							updateHistoryOnNextActivation_[2];
		Manah::Windows::Controls::Menu	optionMenu_;

		// Rg[
		Manah::Windows::Controls::ComboBox	findWhatCombobox_;
		Manah::Windows::Controls::ComboBox	replaceWithCombobox_;
		Manah::Windows::Controls::ComboBox	searchTypeCombobox_;
		Manah::Windows::Controls::ComboBox	caseSensitivityCombobox_;
		BEGIN_CONTROL_BINDING()
			BIND_CONTROL(IDC_COMBO_FINDWHAT, findWhatCombobox_)
			BIND_CONTROL(IDC_COMBO_REPLACEWITH, replaceWithCombobox_)
			BIND_CONTROL(IDC_COMBO_SEARCHTYPE, searchTypeCombobox_)
			BIND_CONTROL(IDC_COMBO_CASEFOLDING, caseSensitivityCombobox_)
		END_CONTROL_BINDING()
	};

} // namespace Alpha

#endif /* FIND_DLG_H_ */

/* [EOF] */