// GotoLineDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "GotoLineDlg.h"
#include "CommandManager.h"

using Alpha::GotoLineDlg;
using Alpha::AlphaApp;
using namespace Ascension;
using namespace std;


/// RXgN^
GotoLineDlg::GotoLineDlg(AlphaApp& app) : app_(app) {
}

/// @see Dialog::onInitDialog
bool GotoLineDlg::onInitDialog(HWND focusWindow, LPARAM initParam) {
	Dialog::onInitDialog(focusWindow, initParam);

	const AlphaDoc& buffer = app_.getBufferList().getActive();
	const length_t lineOffset = app_.getBufferList().getActiveView().getLayoutSetter().getSettings().lineNumberLayout.startLine;
	const wstring s = app_.loadString(MSG_LINE_NUMBER_RANGE, MARGS
								% (buffer.getStartPoint().line_ + lineOffset)
								% (buffer.getEndPoint().line_ + lineOffset));

	setDlgItemText(IDC_STATIC_1, s.c_str());
	lineNumberSpin_.setRange(
		static_cast<int>(buffer.getStartPoint().line_ + lineOffset),
		static_cast<int>(buffer.getEndPoint().line_ + lineOffset));
	lineNumberSpin_.setPos(static_cast<int>(
		app_.getBufferList().getActiveView().getSelection().getActivePoint().getLineNumber() + lineOffset));
	lineNumberSpin_.invalidateRect(0);

	checkRadioButton(IDC_RADIO_LOGICALLINE,
		IDC_RADIO_PHYSICALLINE, /*lineUnit_ ?*/ IDC_RADIO_LOGICALLINE /*: IDC_RADIO_PHYSICALLINE*/);
	checkDlgButton(IDC_CHK_SAVESELECTION,
		app_.readIntegerProfile(L"Search", L"GotoLineDialog.extendSelection", 0) == 1 ? BST_CHECKED : BST_UNCHECKED);

	return true;
}

/// @see Dialog::onOK()
void GotoLineDlg::onOK() {
	// ꎞ}N`͎słȂ
	if(app_.getCommandManager().getTemporaryMacro().getState() == TemporaryMacro::DEFINING) {
		AlphaApp::getInstance().messageBox(MSG_PROHIBITED_FOR_MACRO_DEFINING, MB_ICONEXCLAMATION);
		return;
	}

	Alpha::AlphaView& activeView = app_.getBufferList().getActiveView();
	length_t line = lineNumberSpin_.getPos();

	// s_sɕϊ
	line -= activeView.getLayoutSetter().getSettings().lineNumberLayout.startLine;
	if(isDlgButtonChecked(IDC_RADIO_PHYSICALLINE) == BST_CHECKED)
		line = activeView.logicalCharFromDisplayChar(CharPos(line, 0)).line_;

	// ړ
	if(isDlgButtonChecked(IDC_CHK_SAVESELECTION) == BST_CHECKED) {
		activeView.getSelection().getActivePoint().moveTo(CharPos(line, 0));
		app_.writeIntegerProfile(L"Search", L"GotoLineDialog.extendSelection", 1);
	} else {
		activeView.getSelection().moveTo(CharPos(line, 0), true);
		app_.writeIntegerProfile(L"Search", L"GotoLineDialog.extendSelection", 0);
	}
	Dialog::onOK();
}

/* [EOF] */