// MRUManager.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "MRUManager.h"
#include "Alpha.h"
using namespace Alpha;
using namespace std;
using Manah::Windows::Controls::Menu;
using Ascension::Encodings::CodePage;


/// RXgN^
MRUManager::MRUManager(size_t limit, int startID, bool ownerDrawMenu /* = false */)
		: limitCount_(limit), startID_(startID), ownerDraw_(ownerDrawMenu) {
	updateMenu();
}

/**
 *	ڂǉBɓ̂΂擪ɏo
 *	@param fileName	Vǉt@CpX
 *	@param cp		R[hy[W
 */
void MRUManager::add(const basic_string<WCHAR>& fileName, CodePage cp) {
	list<MRU>::iterator it = fileNames_.begin();
	wchar_t* lowerName = new wchar_t[fileName.length() + 1];
	wchar_t buffer[MAX_PATH];

	// ̂邩T (啶ʂȂBۂ͂ŏ\ł͂Ȃ)
	wcscpy(lowerName, fileName.c_str());
	::CharLowerW(lowerName);
	while(it != fileNames_.end()) {
		wcscpy(buffer, it->fileName.c_str());
		::CharLowerW(buffer);
		if(wcscmp(buffer, lowerName) == 0) {	//  -> 擪ɏo
			MRU item = *it;
			item.codePage = cp;
			fileNames_.erase(it);
			fileNames_.push_front(item);
			delete[] lowerName;
			updateMenu();
			return;
		}
		++it;
	}
	delete[] lowerName;

	// 擪ɒǉBl𒴂ꍇ͈ԌÂ̂폜
	MRU item = {fileName, cp};
	fileNames_.push_front(item);
	if(fileNames_.size() > limitCount_)
		fileNames_.resize(limitCount_);
	updateMenu();
}

/// w肵ʒũt@CpXԂ
const MRU& MRUManager::getFileInfoAt(size_t index) const {
	if(index >= fileNames_.size())
		throw out_of_range("First argument is out of range!");
	list<MRU>::const_iterator it = fileNames_.begin();
	for(size_t i = 0; i < index; ++i)
		++it;
	return *it;
}

/// ڂ̍폜
void MRUManager::remove(size_t index) {
	if(index >= fileNames_.size())
		throw out_of_range("First argument is out of range!");
	list<MRU>::iterator it = fileNames_.begin();
	for(size_t i = 0; i < index; ++i)
		++it;
	fileNames_.erase(it);
	updateMenu();
}

/// ڐ̏l̐ݒ
void MRUManager::setLimit(size_t newLimit) {
	if(newLimit < 4)
		newLimit = 4;
	else if(newLimit > 16)
		newLimit = 16;
	limitCount_ = newLimit;

	// ӂꂽ폜
	if(fileNames_.size() > newLimit) {
		fileNames_.resize(newLimit);
		for(size_t i = fileNames_.size() - 1; i > newLimit; --i)
			popupMenu_.removeMenuItem<Menu::BY_POSITION>(static_cast<UINT>(i));
	}
}

/// @c fileNames_ 烁j[č\
void MRUManager::updateMenu() {
	size_t item = 0;
	list<MRU>::const_iterator it = fileNames_.begin();
	wchar_t caption[MAX_PATH + 100];

	while(popupMenu_.getItemCount() > 0)
		popupMenu_.deleteMenuItem<Menu::BY_POSITION>(0);
	if(fileNames_.empty()) {	// ̏ꍇ
		const wstring s = AlphaApp::getInstance().loadString(MSG_EMPTY_MENU);
		popupMenu_.appendMenuItem(0, s.c_str(), MFS_GRAYED);
		return;
	}
	while(it != fileNames_.end()) {
		swprintf(caption, L"&%x  %s", item, it->fileName.c_str());
		if(ownerDraw_)
			popupMenu_.appendMenuItem(static_cast<UINT>(startID_ + item), 0U);
		else
			popupMenu_.appendMenuItem(static_cast<UINT>(startID_ + item), caption);
		++it;
		++item;
	}
}

/* [EOF] */