// MRUManager.h
// (c) 2003-2006 exeal

#ifndef MRU_MANAGER_H_
#define MRU_MANAGER_H_

#include <list>
#include "../Manah/Menu.hpp"
#include "Ascension\Encodings\Encoder.h"


namespace Alpha {
	/// ŋߎgt@C̏
	struct MRU {
		std::basic_string<WCHAR>		fileName;	///< t@C
		Ascension::Encodings::CodePage	codePage;	///< R[hy[W
	};

	/// ŋߎgt@C̊Ǘ
	class MRUManager : public Manah::Noncopyable {
	public:
		// RXgN^
		MRUManager(std::size_t limit, int startID, bool ownerDrawMenu = false);

		// \bh
		void		add(const std::basic_string<WCHAR>& fileName, Ascension::Encodings::CodePage cp);
		void		clear();
		std::size_t	getCount() const throw();
		const MRU&	getFileInfoAt(std::size_t index) const;
		const Manah::Windows::Controls::Menu&
					getPopupMenu() const throw();
		void		remove(std::size_t index);
		void		setLimit(std::size_t newLimit);
	private:
		void	updateMenu();

		// f[^o
	private:
		const int						startID_;		// j[ ID ̐擪̒l
		std::list<MRU>					fileNames_;		// tpX̃Xg
		Manah::Windows::Controls::Menu	popupMenu_;		// |bvAbvj[
		std::size_t						limitCount_;	// ڐ̏ (4ȏ16ȉ)
		bool							ownerDraw_;		// j[I[i[h[ɂ邩
	};


	/// ڂSč폜
	inline void MRUManager::clear() {fileNames_.clear(); updateMenu();}

	/// Xg̍ڐԂ
	inline size_t MRUManager::getCount() const throw() {return fileNames_.size();}

	/// |bvAbvj[Ԃ
	inline const Manah::Windows::Controls::Menu& MRUManager::getPopupMenu() const throw() {return popupMenu_;}

}

#endif /* MRU_MANAGER_H_ */

/* [EOF] */