// NewFileFormatDlg.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "NewFileFormatDlg.h"
#include "Alpha.h"
#include "../Manah/StandardControls.hpp"
using Alpha::NewFileFormatDlg;
using Manah::Windows::Controls::ComboBox;
using namespace Ascension::Encodings;
using namespace std;


/// @see Dialog::onCommand
bool NewFileFormatDlg::onCommand(WORD id, WORD notifyCode, HWND control) {
	if(id != IDC_COMBO_CHARCODE || notifyCode != CBN_SELCHANGE)
		return Dialog::onCommand(id, notifyCode, control);

	const CodePage cp = static_cast<CodePage>(codePageCombobox_.getItemData(codePageCombobox_.getCurSel()));

	if(cp == CPEX_UNICODE_UTF5 || cp == CP_UTF7 || cp == CP_UTF8
			|| cp == CPEX_UNICODE_UTF16LE || cp == CPEX_UNICODE_UTF16BE
			|| cp == CPEX_UNICODE_UTF32LE || cp == CPEX_UNICODE_UTF32BE) {
		if(lineBreakCombobox_.getCount() != 6) {
			const int org = (lineBreakCombobox_.getCount() != 0) ? lineBreakCombobox_.getCurSel() : 0;

			lineBreakCombobox_.resetContent();
			lineBreakCombobox_.setItemData(lineBreakCombobox_.addString(
				(lineBreak_ == Ascension::LB_CRLF) ? IDS_BREAK_CRLF L" *" : IDS_BREAK_CRLF), Ascension::LB_CRLF);
			lineBreakCombobox_.setItemData(lineBreakCombobox_.addString(
				(lineBreak_ == Ascension::LB_LF) ? IDS_BREAK_LF L" *" : IDS_BREAK_LF), Ascension::LB_LF);
			lineBreakCombobox_.setItemData(lineBreakCombobox_.addString(
				(lineBreak_ == Ascension::LB_CR) ? IDS_BREAK_CR L" *" : IDS_BREAK_CR), Ascension::LB_CR);
			lineBreakCombobox_.setItemData(lineBreakCombobox_.addString(
				(lineBreak_ == Ascension::LB_NEL) ? IDS_BREAK_NEL L" *" : IDS_BREAK_NEL), Ascension::LB_NEL);
			lineBreakCombobox_.setItemData(lineBreakCombobox_.addString(
				(lineBreak_ == Ascension::LB_LS) ? IDS_BREAK_LS L" *" : IDS_BREAK_LS), Ascension::LB_LS);
			lineBreakCombobox_.setItemData(lineBreakCombobox_.addString(
				(lineBreak_ == Ascension::LB_PS) ? IDS_BREAK_PS L" *" : IDS_BREAK_PS), Ascension::LB_PS);
			lineBreakCombobox_.setCurSel(org);
		}
	} else {
		if(lineBreakCombobox_.getCount() != 3) {
			const int org = (lineBreakCombobox_.getCount() != 0) ? lineBreakCombobox_.getCurSel() : 0;

			lineBreakCombobox_.resetContent();
			lineBreakCombobox_.setItemData(lineBreakCombobox_.addString(
				(lineBreak_ == Ascension::LB_CRLF) ? IDS_BREAK_CRLF L" *" : IDS_BREAK_CRLF), Ascension::LB_CRLF);
			lineBreakCombobox_.setItemData(lineBreakCombobox_.addString(
				(lineBreak_ == Ascension::LB_LF) ? IDS_BREAK_LF L" *" : IDS_BREAK_LF), Ascension::LB_LF);
			lineBreakCombobox_.setItemData(lineBreakCombobox_.addString(
				(lineBreak_ == Ascension::LB_CR) ? IDS_BREAK_CR L" *" : IDS_BREAK_CR), Ascension::LB_CR);
			lineBreakCombobox_.setCurSel((org < lineBreakCombobox_.getCount()) ? org : 0);
		}
	}
	return true;
}

/// @see Dialog::onInitDialog
bool NewFileFormatDlg::onInitDialog(HWND focusWindow, LPARAM initParam) {
	Dialog::onInitDialog(focusWindow, initParam);

	set<CodePage> codePages;

	// [R[hy[W]
	EncoderFactory::getInstance().enumCodePages(codePages);
	for(set<CodePage>::const_iterator it = codePages.begin(); it != codePages.end(); ++it) {
		if(EncoderFactory::getInstance().isCodePageForAutoDetection(*it))
			continue;
		if(const wstring* name = AlphaApp::getInstance().getCodePageName(*it)) {
			const int i = codePageCombobox_.addString((*it == codePage_) ? (*name + L" *").c_str() : name->c_str());
			codePageCombobox_.setItemData(i, *it);
			if(*it == codePage_)
				codePageCombobox_.setCurSel(i);
		}
	}

	// [sR[h]
	onCommand(IDC_COMBO_CHARCODE, CBN_SELCHANGE, 0);
	for(int i = 0; i < 6; ++i) {
		if(lineBreak_ == static_cast<Ascension::LineBreak>(lineBreakCombobox_.getItemData(i))) {
			lineBreakCombobox_.setCurSel(i);
			break;
		}
	}

	// [^Cv]
	for(list<wstring>::const_iterator it = documentTypes_.begin(); it != documentTypes_.end(); ++it)
		documentTypeCombobox_.addString(it->c_str());
	documentTypeCombobox_.setCurSel(static_cast<int>(documentType_));

	return true;
}

/// @see Dialog::onOK
void NewFileFormatDlg::onOK() {
	codePage_ = static_cast<CodePage>(codePageCombobox_.getItemData(codePageCombobox_.getCurSel()));
	lineBreak_ = static_cast<Ascension::LineBreak>(lineBreakCombobox_.getItemData(lineBreakCombobox_.getCurSel()));
	documentType_ = documentTypeCombobox_.getCurSel();

	Dialog::onOK();
}

/* [EOF] */