// ScriptMacroManager.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "ScriptMacroManager.h"
#include "Alpha.h"				// AlphaApp
#include "AlphaScriptHost.h"	// AlphaScriptHost
#include "Ambient.h"			// Application
#include "SelectLanguageDlg.h"
#include "Ascension/Encodings/Encoder.h"
#include <shlwapi.h>	// PathFileExists
//#include <winable.h>	// BlockInput
using namespace Alpha;
using namespace Manah;
using namespace Armaiti;
using namespace Ascension::Encodings;
using namespace std;
using namespace MSXML2;


// XNvg}N̎s GUI Ƃ͕ʂ̃XbhōsĂA
// Alpha ̃VOXbhɂ蓯XbhŎs邱ƂɂȂB
// ȉ̓}`Xbh̃:
// - [U̓͂}邽߂Ɉȉ InputBlocker g
// - XNvgXbh STA ɓׂ
// - XNvgXbh猾I_CAOoƂƃfbhbN
// - XNvgGWƃp[T̂̂̓Ap[goO (HaskellScript ƃoO)

namespace {
#if 0	// }`XbhȂȂ̂ňȉ͕sv
//	struct InputBlocker {
//		InputBlocker() {::BlockInput(true);}
//		~InputBlocker() {::BlockInput(false);}
//	};
	class InputBlocker {
	public:
		InputBlocker(AlphaApp& app) : app_(app) {
			const BufferList& buffers = app_.getBufferList();
			for(size_t i = 0; i < buffers.getCount(); ++i) {
				const AlphaDoc& buffer = buffers.getAt(i);
				for(size_t j = 0; j < buffer.getCount(); ++j)
					buffer.getView(j).enableWindow(false);
			}
		}
		~InputBlocker() {
			const BufferList& buffers = app_.getBufferList();
			for(size_t i = 0; i < buffers.getCount(); ++i) {
				const AlphaDoc& buffer = buffers.getAt(i);
				for(size_t j = 0; j < buffer.getCount(); ++j)
					buffer.getView(j).enableWindow(true);
			}
		}
	private:
		AlphaApp& app_;
	};
#endif // 0
} // namespace @0


// Alpha ł wchar_t gݍ݌^ƂĎgĂ邪AƂ
// MSXML SAX C^[tFCX͕|C^Ƃ unsigned short* gB
// ̂߃LXgKvɂȂ
#define WC2US(__pwsz)	reinterpret_cast<unsigned short*>(__pwsz)
#define US2WC(__pus)	reinterpret_cast<wchar_t*>(__pus)


// ScriptMacroManager class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
ScriptMacroManager::ScriptMacroManager(AlphaApp& app) : app_(app), macros_(0), count_(0) {
	saxHandler_.this_ = this;
}

/// fXgN^
ScriptMacroManager::~ScriptMacroManager() {
	if(macros_ != 0) {
		for(size_t i = 0; i < count_; ++i)
			delete macros_[i];
		delete[] macros_;
	}
}

/**
 *	}Ns
 *	@param i							}N̔ԍ
 *	@param args							XNvgɓn
 *	@throw std::out_of_range			@a i ȂƂX[
 *	@throw ScriptOpenFailureException	XNvgt@CJȂꍇX[
 *	@throw InvalidLanguageException		ꖼȂꍇX[
 */
void ScriptMacroManager::execute(size_t i, const vector<wstring>& args) {
	using namespace Manah::Windows::IO;

	if(i >= count_)
		throw out_of_range("Invalid index.");

	// \bhB菇:
	// XNvgt@C̃[h -> XNvgGW̗p ->  -> s

	// XNvgt@C̃[h
	const MacroInfo& macro = *macros_[i];
	WCHAR fileName[MAX_PATH];
	File<true> scriptFile;

	wcscpy(fileName, fileName_.c_str());
	WCHAR* title = wcsrchr(fileName, L'\\');
	wcscpy(title + 1, macro.scriptFile.c_str());
	if(!toBoolean(::PathFileExistsW(fileName)))
		throw ScriptOpenFailureException(fileName);
	if(!scriptFile.open(fileName, FileBase::READ_ONLY, FileBase::DENY_NONE))
		throw ScriptOpenFailureException(fileName);

	auto_ptr<Encoder> encoder = EncoderFactory::getInstance().createEncoder(CP_UTF8);	// XNvg UTF-8

	if(scriptFile.getLength() > numeric_limits<ulong>::max()) {	// t@C傫
		scriptFile.close();
		throw ScriptOpenFailureException(fileName);
	}

	DWORD fileSize = static_cast<DWORD>(scriptFile.getLength());
	uchar* const buffer = static_cast<uchar*>(::HeapAlloc(::GetProcessHeap(), HEAP_NO_SERIALIZE, fileSize));
	scriptFile.read(buffer, fileSize, &fileSize);
	scriptFile.close();
	wchar_t* const source =
		static_cast<wchar_t*>(::HeapAlloc(::GetProcessHeap(), HEAP_NO_SERIALIZE, sizeof(wchar_t) * (fileSize + 1)));

	fileSize = static_cast<DWORD>(encoder->toUnicode(source, fileSize, buffer, fileSize));
	source[fileSize] = 0;
	::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, buffer);

	// XNvgGW̗p
	CLSID engineClsid;
	if(macro.language.empty()) {	// ꖼw肳ĂȂ -> gq猈肷
		app_.getScriptLanguageByFileName(macro.scriptFile.c_str(), engineClsid);
		if(engineClsid == IID_NULL)	// ʖڂȏꍇzXgɐuĂ݂
			AlphaScriptHost::findScriptEngine(macro.scriptFile.c_str(), engineClsid);
		if(engineClsid == IID_NULL) {	// łȂꍇ̓[Uɐu
			SelectLanguageDlg dlg;
			if(IDOK != dlg.doModal(0)) {	// [U[߂
				::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, source);
				return;
			}
			const wstring& languageName = dlg.getSelectedLanguage();
			if(FAILED(::CLSIDFromProgID(languageName.c_str(), &engineClsid))) {
				::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, source);
				throw InvalidLanguageException(languageName);
			}
		}
	} else {	// ꖼ CLSID 肷
		if(FAILED(::CLSIDFromProgID(macro.language.c_str(), &engineClsid))) {
			::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, source);
			throw InvalidLanguageException(macro.language);
		}
	}

	ComPtr<IActiveScript> scriptEngine;
	if(FAILED(scriptEngine.createInstance(engineClsid, 0, CLSCTX_INPROC))) {
		::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, source);
		OLECHAR* s;
		::StringFromCLSID(engineClsid, &s);
		InvalidLanguageException e(s);
		::CoTaskMemFree(s);
		throw e;
	}

	// XNvgzXg̏
	ComPtr<AlphaScriptHost> scriptHost;
	ComPtr<Ambient::ScriptHost> atxScriptHost;
	scriptHost = new AlphaScriptHost(app_.getMainWindow(), *scriptEngine);
	atxScriptHost = new Ambient::ScriptHost(*scriptHost);
	scriptHost->setScriptFileName(fileName);
	scriptHost->setSecurityLevel(true,
		static_cast<ScriptSiteSecurityLevel>(app_.readIntegerProfile(L"Script", L"securityLevelForSafeObject", 0)));
	scriptHost->setSecurityLevel(false,
		static_cast<ScriptSiteSecurityLevel>(app_.readIntegerProfile(L"Script", L"securityLevelForUnsafeObject", 1)));
	HRESULT hr = scriptEngine->SetScriptSite(scriptHost);

	// p[T̏
	ComPtr<IActiveScriptParse> scriptParser;
	scriptEngine->QueryInterface(IID_IActiveScriptParse, reinterpret_cast<void**>(&scriptParser));
	hr = scriptEngine->SetScriptState(SCRIPTSTATE_INITIALIZED);
	hr = scriptParser->InitNew();

	// gbvxIuWFNg̓
	ComPtr<Ambient::Application> application;
	const DWORD itemTraits = SCRIPTITEM_ISPERSISTENT | SCRIPTITEM_ISVISIBLE;
	app_.getAutomation(*&application);
	scriptHost->addTopLevelObject(OLESTR("Ambient"), *application, itemTraits | SCRIPTITEM_GLOBALMEMBERS);
	scriptHost->addTopLevelObject(OLESTR("WScript"), *atxScriptHost, itemTraits);
	scriptHost->addTopLevelObject(OLESTR("WSH"), *atxScriptHost, itemTraits);

	// 񋓁A萔̓
	ITypeLib* ambientTLB;
	if(SUCCEEDED(::LoadTypeLib(Ambient::AmbientTypeLibPath::getPath(), &ambientTLB))) {
		scriptHost->loadConstants(*ambientTLB);
		ambientTLB->Release();	// ƍ폜
	}

	// XNvg̎s
	AutoZero<EXCEPINFO> exception;
	hr = scriptParser->ParseScriptText(source, 0, 0, 0, 0UL, 0UL, 0/*SCRIPTTEXT_ISPERSISTENT | SCRIPTTEXT_ISVISIBLE*/, 0, &exception);
	::HeapFree(::GetProcessHeap(), HEAP_NO_SERIALIZE, source);
	if(SUCCEEDED(hr)) {
		ComPtr<IDispatch> topLevel;
		hr = scriptEngine->SetScriptState(SCRIPTSTATE_STARTED);
		hr = scriptEngine->SetScriptState(SCRIPTSTATE_CONNECTED);
		if(SUCCEEDED(scriptEngine->GetScriptDispatch(0, &topLevel))) {	// main ֐Ăяo
			DISPID dispid;
			OLECHAR* procedureName = OLESTR("main");

			hr = topLevel->GetIDsOfNames(IID_NULL, &procedureName, 1, LOCALE_USER_DEFAULT, &dispid);
			if(SUCCEEDED(hr)) {
				DISPPARAMS params;
				VARIANT result;
				VARIANTARG arguments;
				UINT argErr;

				::VariantInit(&result);
				::VariantInit(&arguments);
				arguments.vt = VT_DISPATCH;
				arguments.pdispVal = new Ambient::Arguments(args);
				arguments.pdispVal->AddRef();
				params.cArgs = 1;
				params.cNamedArgs = 0;
				params.rgdispidNamedArgs = 0;
				params.rgvarg = &arguments;
				hr = topLevel->Invoke(dispid, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, &result, &exception, &argErr);
				arguments.pdispVal->Release();
				::VariantChangeType(&result, &result, 0, VT_I4);
//				result = result.lVal;
				::VariantClear(&result);
			}
		}
	}

	// n
	scriptEngine->Close();
	scriptHost->releaseTopLevelObjects();
}

/**
 *	t@C}N[h
 *	@param fileName					XNvgt@C
 *	@return							
 *	@throw XMLParseFailureException	XML ̉͂ɎsꍇX[
 */
bool ScriptMacroManager::load(const WCHAR* fileName) {
	assert(fileName != 0);

	if(macros_ != 0) {
		for(size_t i = 0; i < count_; ++i)
			delete macros_[i];
		delete[] macros_;
		macros_ = 0;
	}
	fileName_ = fileName;

	ComPtr<ISAXXMLReader> xmlReader;
	HRESULT hr = xmlReader.createInstance(__uuidof(SAXXMLReader));
	if(SUCCEEDED(hr)) {
		xmlReader->putContentHandler(&saxHandler_);
		xmlReader->putErrorHandler(&saxHandler_);
		hr = xmlReader->parseURL(WC2US(const_cast<wchar_t*>(fileName)));
		if(FAILED(hr))
			return false;
	} else
		throw XMLParseFailureException();
	return true;
}


// ScriptMacroManager::SAXReadHandler class implementation
/////////////////////////////////////////////////////////////////////////////

/// @see ISAXContentHandler::characters
STDMETHODIMP ScriptMacroManager::SAXReadHandler::characters(unsigned short* pwchChars, int cchChars) {
	if(readingPhase_ == DESCRIPTION)	// <description>
		works_.begin()->description.append(US2WC(pwchChars), cchChars);
	return S_OK;
}

/// @see ISAXContentHandler::endDocument
STDMETHODIMP ScriptMacroManager::SAXReadHandler::endDocument() {
	assert(this_->macros_ == 0);
	this_->count_ = works_.size();
	if(works_.empty())
		return S_OK;

	this_->macros_ = new MacroInfo*[this_->count_];

	MacroInfo** macro = this_->macros_;
	for(list<MacroInfo>::reverse_iterator it = works_.rbegin(); it != works_.rend(); ++it, ++macro)
		*macro = new MacroInfo(*it);
	works_.clear();
	return S_OK;
}

/// @see ISAXContentHandler::endElement
STDMETHODIMP ScriptMacroManager::SAXReadHandler::endElement(unsigned short* pwchNamespaceUri,
		int cchNamespaceUri, unsigned short* pwchLocalName, int cchLocalName, unsigned short* pwchQName, int cchQName) {
	if(wcsncmp(US2WC(pwchLocalName), L"description", cchLocalName) == 0
			|| wcsncmp(US2WC(pwchLocalName), L"script", cchLocalName) == 0)
		readingPhase_ = MACRO;
	return S_OK;
}

/// @see ISAXContentHandler::endPrefixMapping
STDMETHODIMP ScriptMacroManager::SAXReadHandler::endPrefixMapping(unsigned short* pwchPrefix, int cchPrefix) {
	return S_OK;
}

/// @see ISAXErrorHandler::error
STDMETHODIMP ScriptMacroManager::SAXReadHandler::error(
		ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode) {
	wostringstream ss;
	int	line, column;
	pLocator->getLineNumber(&line);
	pLocator->getColumnNumber(&column);
	ss << L"[" << line << L", " << column << L"] " << pwchErrorMessage;
	this_->app_.getMainWindow().messageBox(L"Alpha", ss.str().c_str(), MB_ICONEXCLAMATION);
	return S_OK;
}

/// @see ISAXErrorHandler::fatalError
STDMETHODIMP ScriptMacroManager::SAXReadHandler::fatalError(
		ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode) {
	return error(pLocator, pwchErrorMessage, hrErrorCode);
}

/// @see ISAXErrorHandler::ignorableWarning
STDMETHODIMP ScriptMacroManager::SAXReadHandler::ignorableWarning(
		ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode) {
	return S_OK;
}

/// @see ISAXContentHandler::ignorableWhitespace
STDMETHODIMP ScriptMacroManager::SAXReadHandler::ignorableWhitespace(unsigned short* pwchChars, int cchChars) {
	return S_OK;
}

/// @see ISAXContentHandler::processingInstruction
STDMETHODIMP ScriptMacroManager::SAXReadHandler::processingInstruction(
		unsigned short* pwchTarget, int cchTarget, unsigned short* pwchData, int cchData) {
	return S_OK;
}

/// @see ISAXContentHandler::putDocumentLocator
STDMETHODIMP ScriptMacroManager::SAXReadHandler::putDocumentLocator(ISAXLocator* pLocator) {
	return S_OK;
}

/// @see ISAXContentHandler::skippedEntity
STDMETHODIMP ScriptMacroManager::SAXReadHandler::skippedEntity(unsigned short* pwchName, int cchName) {
	return S_OK;
}

/// @see ISAXContentHandler::startDocument
STDMETHODIMP ScriptMacroManager::SAXReadHandler::startDocument() {
	return S_OK;
}

/// @see ISAXContentHandler::startElement
STDMETHODIMP ScriptMacroManager::SAXReadHandler::startElement(
		unsigned short* pwchNamespaceUri, int cchNamespaceUri,
		unsigned short* pwchLocalName, int cchLocalName,
		unsigned short* pwchQName, int cchQName, ISAXAttributes* pAttributes) {
	wchar_t* value = 0;
	int valueLength;
		
	if(wcsncmp(US2WC(pwchLocalName), L"macro", cchLocalName) == 0) {	// macro vf name 擾
		readingPhase_ = MACRO;
		MacroInfo macro;
		if(SUCCEEDED(pAttributes->getValueFromName(WC2US(L""), 0,
				WC2US(L"name"), 4, reinterpret_cast<unsigned short**>(&value), &valueLength)))
			macro.name.assign(value, valueLength);
		works_.push_front(macro);
	} else if(wcsncmp(US2WC(pwchLocalName), L"script", cchLocalName) == 0) {	// script vf language Asrc 擾
		readingPhase_ = SCRIPT;
		if(SUCCEEDED(pAttributes->getValueFromName(WC2US(L""), 0,
				WC2US(L"language"), 8, reinterpret_cast<unsigned short**>(&value), &valueLength)))
			works_.begin()->language.assign(value, valueLength);
		if(SUCCEEDED(pAttributes->getValueFromName(WC2US(L""), 0,
				WC2US(L"src"), 3, reinterpret_cast<unsigned short**>(&value), &valueLength))) {
			wchar_t* path = new wchar_t[valueLength + 1];

			replace_copy_if(value, value + valueLength, path, bind2nd(equal_to<wchar_t>(), L'/'), L'\\');
			works_.begin()->scriptFile.assign(path, valueLength);
			delete[] path;
		}
	} else if(wcsncmp(US2WC(pwchLocalName), L"description", cchLocalName) == 0)
		readingPhase_ = DESCRIPTION;
	return S_OK;
}

/// @see ISAXContentHandler::startPrefixMapping
STDMETHODIMP ScriptMacroManager::SAXReadHandler::startPrefixMapping(
		unsigned short* pwchPrefix, int cchPrefix, unsigned short* pwchUri, int cchUri) {
	return S_OK;
}

#undef WC2US
#undef US2WC

/* [EOF] */