// ScriptMacroManager.h
// (c) 2003-2006 exeal

#ifndef SCRIPT_MACRO_MANAGER_H_
#define SCRIPT_MACRO_MANAGER_H_

#include <vector>
#include <list>
#include "Ascension\Encodings\Encoder.h"
#include "../Armaiti/UnknownImpl.hpp"
#define _COM_NO_STANDARD_GUIDS_
#include "msxml3.tlh"

interface IActiveScript;


namespace Alpha {

	class AlphaApp;

	/// XNvg}N̊Ǘ
	class ScriptMacroManager {
		// oNX
	public:
		/// XNvgt@CJȂƂO
		class ScriptOpenFailureException : public std::runtime_error {
		public:
			ScriptOpenFailureException(const std::basic_string<WCHAR>& fileName) :
				std::runtime_error("Specified script file is not found."), fileName_(fileName) {}
			const std::basic_string<WCHAR> fileName_;
		};
		/// XNvǧꖼȂƂO
		class InvalidLanguageException : public std::runtime_error {
		public:
			InvalidLanguageException(const std::wstring& language) :
				std::runtime_error("Specified language is invalid or not supported"), language_(language) {}
			const std::wstring language_;
		};
		/// XML ̉͂ɎsƂO
		class XMLParseFailureException : public std::runtime_error {
		public:
			XMLParseFailureException() : std::runtime_error("Failed to load SAX parser.") {}
		};

		// RXgN^
	public:
		ScriptMacroManager(AlphaApp& app);
		~ScriptMacroManager();

		// \bh
	public:
		void				execute(size_t index, const std::vector<std::wstring>& args = std::vector<std::wstring>());
		std::size_t			getCount() const throw();
		const std::wstring&	getDescription(std::size_t index) const;
		const std::wstring&	getName(std::size_t index) const;
		bool				load(const WCHAR* fileName);

		// f[^o
	private:
		AlphaApp& app_;
		std::basic_string<WCHAR> fileName_;

		struct MacroInfo {
			std::wstring					name;
			std::wstring					description;
			std::wstring					scriptFile;
			std::basic_string<WCHAR>		language;
			Ascension::Encodings::CodePage	codePage;
		};
		MacroInfo** macros_;
		std::size_t count_;

		// NX
	private:
		class SAXReadHandler : virtual public MSXML2::ISAXContentHandler, virtual public MSXML2::ISAXErrorHandler {
			// \bh
		public:
			// IUnknown C^[tFCX
			IMPLEMENT_UNKNOWN_NO_REF_COUNT()
			STDMETHODIMP	QueryInterface(REFIID riid, void** ppvObject) {
				VERIFY_POINTER(ppvObject);
				if(riid == IID_IUnknown || riid == __uuidof(ISAXContentHandler))
					*ppvObject = static_cast<ISAXContentHandler*>(this);
				else if(riid == __uuidof(ISAXErrorHandler))
					*ppvObject = static_cast<ISAXErrorHandler*>(this);
				else
					return (*ppvObject = 0), E_NOINTERFACE;
				reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();
				return S_OK;
			}
	//		BEGIN_INTERFACE_TABLE()
	//			IMPLEMENTS_LEFTMOST_INTERFACE(ISAXContentHandler)
	//			IMPLEMENTS_INTERFACE(ISAXErrorHandler)
	//		END_INTERFACE_TABLE()

			// ISAXContentHandler C^[tFCX
			STDMETHODIMP	putDocumentLocator(MSXML2::ISAXLocator* pLocator);
			STDMETHODIMP	startDocument();
			STDMETHODIMP	endDocument();
			STDMETHODIMP	startPrefixMapping(unsigned short* pwchPrefix,
								int cchPrefix, unsigned short* pwchUri, int cchUri);
			STDMETHODIMP	endPrefixMapping(unsigned short* pwchPrefix, int cchPrefix);
			STDMETHODIMP	startElement(unsigned short* pwchNamespaceUri, int cchNamespaceUri,
								unsigned short* pwchLocalName, int cchLocalName,
								unsigned short* pwchQName, int cchQName, MSXML2::ISAXAttributes* pAttributes);
			STDMETHODIMP	endElement(unsigned short* pwchNamespaceUri, int cchNamespaceUri,
								unsigned short* pwchLocalName, int cchLocalName,
								unsigned short* pwchQName, int cchQName);
			STDMETHODIMP	characters(unsigned short* pwchChars, int cchChars);
			STDMETHODIMP	ignorableWhitespace(unsigned short* pwchChars, int cchChars);
			STDMETHODIMP	processingInstruction (unsigned short* pwchTarget, int cchTarget,
								unsigned short* pwchData, int cchData);
			STDMETHODIMP	skippedEntity(unsigned short* pwchName, int cchName);

			// ISAXErrorHandler C^[tFCX
			STDMETHODIMP	error(MSXML2::ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode);
			STDMETHODIMP	fatalError(MSXML2::ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode);
			STDMETHODIMP	ignorableWarning(MSXML2::ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode);

			// f[^o
		public:
			enum {MACRO, DESCRIPTION, SCRIPT} readingPhase_;
			std::list<MacroInfo> works_;
			ScriptMacroManager* this_;
		} saxHandler_;

		friend class SAXReadHandler;
	};

/// }ŇԂ
inline std::size_t ScriptMacroManager::getCount() const throw() {return count_;}

/**
 *	}N̐Ԃ
 *	@param index				}N̔ԍ
 *	@throw std::out_of_range	<var>index</var> ȂƂX[
 */
inline const std::wstring& ScriptMacroManager::getDescription(std::size_t index) const {
	if(index >= count_)
		throw std::out_of_range("Specified plugin not found.");
	return macros_[index]->description;
}

/**
 *	}N̖OԂ
 *	@param index				}N̔ԍ
 *	@throw std::out_of_range	<var>index</var> ȂƂX[
 */
inline const std::wstring& ScriptMacroManager::getName(std::size_t index) const {
	if(index >= count_)
		throw std::out_of_range("Specified plugin not found.");
	return macros_[index]->name;
}

} /* namespace Alpha */

#endif /* _SCRIPT_MACRO_MANAGER_H_ */

/* [EOF] */