// ScriptManager.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "ScriptManager.h"
#include "Ascension\Encodings\Encoder.h"
#include "../Armaiti/ComBasic.hpp"
using Alpha::CScriptManager;
using namespace Ascension::Encodings;
using namespace std;
using Armaiti::CComPtr;


///	fXgN^
CScriptManager::~CScriptManager() {
	for(ScriptEngines::iterator it = m_scriptEngines.begin(); it != m_scriptEngines.end(); ++it) {
		it->pEngine->Close();
		it->pEngine->Release();
	}
}

/**
 *	XNvg猾GW肵A CLSID Ԃ
 *	@param pwszFileName	XNvg
 *	@param clsid		[out] GW CLSIDBɎsꍇ CLSID_NULL
 */
void CScriptManager::_FindScriptEngine(const wchar_t* pwszFileName, CLSID& clsid) {
	assert(pwszFileName != 0);
	clsid = CLSID_NULL;

	wchar_t*	pwszExt = ::PathFindExtensionW(pwszFileName);
	HKEY		hKey;
	wchar_t		wszFileType[100], wszProgId[100], wszScriptEngine[100];
	DWORD		cbData;
	long		err;

	if(*pwszExt == 0)
		return;
	if(ERROR_SUCCESS != ::RegOpenKeyExW(HKEY_CLASSES_ROOT, pwszExt, 0, KEY_READ, &hKey))
		return;
	cbData = sizeof(wszFileType);
	err = ::RegQueryValueExW(hKey, 0, 0, 0, reinterpret_cast<BYTE*>(wszFileType), &cbData);
	::RegCloseKey(hKey);
	if(err != ERROR_SUCCESS)
		return;

	wcscpy(wszScriptEngine, wszFileType);
	wcscat(wszScriptEngine, L"\\ScriptEngine");
	err = ::RegOpenKeyExW(HKEY_CLASSES_ROOT, wszScriptEngine, 0, KEY_READ, &hKey);
	cbData = sizeof(wszProgId);
	if(err == ERROR_SUCCESS) {
		err = ::RegQueryValueExW(hKey, 0, 0, 0, reinterpret_cast<BYTE*>(wszProgId), &cbData);
		::RegCloseKey(hKey);
	} else {
		::RegCloseKey(hKey);
		// L[ "ScriptFile" tčĒ (PerlScript Ƃ)
		wcscpy(wszScriptEngine, wszFileType);
		wcscat(wszScriptEngine, L"ScriptFile\\ScriptEngine");
		if(ERROR_SUCCESS != ::RegOpenKeyExW(HKEY_CLASSES_ROOT, wszScriptEngine, 0, KEY_READ, &hKey))
			return;
		err = ::RegQueryValueExW(hKey, 0, 0, 0, reinterpret_cast<BYTE*>(wszProgId), &cbData);
		::RegCloseKey(hKey);
		if(err != ERROR_SUCCESS)
			return;
	}
	::CLSIDFromProgID(wszProgId, &clsid);
}

/**
 *	ǗĂGWw肵ÕvpeB
 *	@param pwszName	O
 *	@param ppObject	[out] vpeBBȂꍇ null
 *	@return			ꍇ true
 */
bool CScriptManager::GetNamedObject(const wchar_t* pwszName, IDispatch** ppObject) const {
	assert(pwszName != 0);
	assert(ppObject != 0);
	*ppObject = 0;

	for(ScriptEngines::const_iterator it = m_scriptEngines.begin(); it != m_scriptEngines.end(); ++it) {
		if(SUCCEEDED(it->pEngine->GetScriptDispatch(pwszName, ppObject)))
			return true;
	}
	return false;
}

/**
 *	XNvg[h
 *	@param pwszFilePath	XNvgt@C̃pX
 *	@return				
 */
bool CScriptManager::LoadScript(const wchar_t* pwszFilePath) {
	assert(pwszFilePath != 0);

	CLSID	clsidEngine;

	_FindScriptEngine(pwszFilePath, clsidEngine);
	if(clsidEngine == CLSID_NULL)
		return false;

	// t@Cǂݍ
	HANDLE		hFile;
	HGLOBAL		hGlobal = 0;
	uchar*		psz = 0;
	wchar_t*	pwszSource = 0;
	DWORD		dwRead = 0;

	// XNvgǂݍ
	hFile = ::CreateFileW(pwszFilePath, GENERIC_READ,
		FILE_SHARE_READ | FILE_SHARE_WRITE, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
	if(hFile == INVALID_HANDLE_VALUE)
		return false;
	const DWORD	dwFileSize = ::GetFileSize(hFile, 0);
	hGlobal = ::GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
	psz = static_cast<uchar*>(::GlobalLock(hGlobal));
	if(dwFileSize != 0)
		::ReadFile(hFile, psz, dwFileSize, &dwRead, 0);
	::CloseHandle(hFile);
	if(dwRead == 0) {
		::GlobalUnlock(hGlobal);
		::GlobalFree(hGlobal);
		return false;
	}

	// UTF-8  UTF-16 ɕϊ
	if(dwRead != 0) {
		CEncoder*	pEncoder = CEncoderFactory::GetInstance().CreateEncoder(CP_UTF8);
		pwszSource = new wchar_t[dwRead + 1];
		const size_t	cch = pEncoder->ConvertToUnicode(pwszSource, dwRead, psz, dwRead);
		pwszSource[cch] = 0;
		delete pEncoder;
	} else {
		pwszSource = new wchar_t[1];
		pwszSource[0] = 0;
	}
	::GlobalUnlock(hGlobal);
	::GlobalFree(hGlobal);

	const bool	bSucceeded = ParseScriptText(pwszSource, clsidEngine);
	delete[] pwszSource;

	return bSucceeded;
}

/**
 *	XNvgeLXgw肵ŉ͂
 *	@param pwszSource	\[XR[h (UTF-16)
 *	@param clsidEngine	GW CLSID
 */
bool CScriptManager::ParseScriptText(const wchar_t* pwszSource, const CLSID& clsidEngine) {
	assert(pwszSource);

	IActiveScript*	pScriptEngine = 0;	// アQ
	for(ScriptEngines::const_iterator it = m_scriptEngines.begin(); it != m_scriptEngines.end(); ++it) {
		if(it->clsid == clsidEngine)
			pScriptEngine = it->pEngine;
	}

	if(pScriptEngine != 0) {	// ̃GWɑĂꍇ
		CComPtr<IActiveScript>	pParser;

		if(FAILED(pScriptEngine->QueryInterface(IID_IActiveScriptParse, reinterpret_cast<void**>(&pParser))))
			return false;
	} else {	// VGWpӂ
	}

	return true;
}

/* [EOF] */