// TemporaryMacro.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "TemporaryMacro.h"
#include "CommandManager.h"
#include "../Manah/File.hpp"
#include "../Manah/Dialog.hpp"
#include "../Armaiti/UnknownImpl.hpp"
#include <shlwapi.h>	// PathXxxx

using namespace Alpha;
using namespace std;
using namespace Manah::Windows::IO;

namespace {
	using namespace Manah::Windows::Controls;

	// ꎞ}NL^ XML t@Cǂݍ (tmp-macro/temporary-macro.xsd )
	class TemporaryMacroFileReader : virtual public MSXML2::ISAXContentHandler, virtual public MSXML2::ISAXErrorHandler {
	public:
		// RXgN^
		TemporaryMacroFileReader(TemporaryMacro& macro) : macro_(macro), textInputTag_(0) {}
		~TemporaryMacroFileReader() {delete textInputTag_;}

		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_NO_REF_COUNT()
		STDMETHODIMP QueryInterface(REFIID riid, void** ppvObject) {
			VERIFY_POINTER(ppvObject);
			if(riid == IID_IUnknown || riid == __uuidof(ISAXContentHandler))
				*ppvObject = static_cast<ISAXContentHandler*>(this);
			else if(riid == __uuidof(ISAXErrorHandler))
				*ppvObject = static_cast<ISAXErrorHandler*>(this);
			else
				return (*ppvObject = 0), E_NOINTERFACE;
			reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();
			return S_OK;
		}

		// ISAXContentHandler C^[tFCX
		STDMETHODIMP putDocumentLocator(MSXML2::ISAXLocator* pLocator) {return S_OK;}
		STDMETHODIMP startDocument() {macro_.startDefinition(); return S_OK;}
		STDMETHODIMP endDocument() {macro_.endDefinition(); return S_OK;}
		STDMETHODIMP startPrefixMapping(unsigned short* pwchPrefix, int cchPrefix, unsigned short* pwchUri, int cchUri) {return S_OK;}
		STDMETHODIMP endPrefixMapping(unsigned short* pwchPrefix, int cchPrefix) {return S_OK;}
		STDMETHODIMP startElement(unsigned short* pwchNamespaceUri, int cchNamespaceUri,
				unsigned short* pwchLocalName, int cchLocalName,
				unsigned short* pwchQName, int cchQName, MSXML2::ISAXAttributes* pAttributes) {
			SerializableCommand* command =
				BuiltInCommand::parseXMLInput(reinterpret_cast<wchar_t*>(pwchQName), cchQName, *pAttributes);
			if(command == 0)
				command = CharacterInputCommand::parseXMLInput(reinterpret_cast<wchar_t*>(pwchQName), cchQName, *pAttributes);
			if(command != 0) {
				macro_.pushCommand(*command);
				delete command;
			} else if(TextInputCommand* p =
					TextInputCommand::parseXMLInput(reinterpret_cast<wchar_t*>(pwchQName), cchQName, *pAttributes)) {
				if(textInputTag_ == 0) {
					textInputTag_ = new TextInputTag;
					textInputTag_->command = p;
				}
			} else if(cchLocalName == 12 && wcsncmp(reinterpret_cast<wchar_t*>(pwchLocalName), L"query-prompt", cchLocalName) == 0)
				macro_.insertUserQuery();
			return S_OK;
		}
		STDMETHODIMP endElement(unsigned short* pwchNamespaceUri, int cchNamespaceUri,
				unsigned short* pwchLocalName, int cchLocalName, unsigned short* pwchQName, int cchQName) {
			if(textInputTag_ != 0 && cchQName == 18
					&& wcsncmp(reinterpret_cast<wchar_t*>(pwchQName), L"text-input-command", cchQName) == 0) {
				textInputTag_->command->setText(textInputTag_->text.str());
				macro_.pushCommand(*textInputTag_->command);
				delete textInputTag_->command;
				delete textInputTag_;
				textInputTag_ = 0;
			}
			return S_OK;
		}
		STDMETHODIMP characters(unsigned short* pwchChars, int cchChars) {
			if(textInputTag_ != 0)
				textInputTag_->text.write(reinterpret_cast<wchar_t*>(pwchChars), cchChars);
			return S_OK;
		}
		STDMETHODIMP ignorableWhitespace(unsigned short* pwchChars, int cchChars) {return S_OK;}
		STDMETHODIMP processingInstruction (unsigned short* pwchTarget, int cchTarget, unsigned short* pwchData, int cchData) {return S_OK;}
		STDMETHODIMP skippedEntity(unsigned short* pwchName, int cchName) {return S_OK;}

		// ISAXErrorHandler C^[tFCX
		STDMETHODIMP error(MSXML2::ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode) {
			macro_.cancelDefinition();

			int line, column;
			pLocator->getLineNumber(&line);
			pLocator->getColumnNumber(&column);
			AlphaApp::getInstance().messageBox(MSG_FAILED_TO_LOAD_TEMPORARY_MACRO, MB_ICONEXCLAMATION | MB_OK,
				MARGS % macro_.getFileName() % line % column % reinterpret_cast<wchar_t*>(pwchErrorMessage));
			return S_OK;
		}
		STDMETHODIMP fatalError(MSXML2::ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode) {
			return error(pLocator, pwchErrorMessage, hrErrorCode);
		}
		STDMETHODIMP ignorableWarning(MSXML2::ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode) {return S_OK;}

	private:
		TemporaryMacro& macro_;
		struct TextInputTag {
			TextInputCommand* command;
			Ascension::ostringstream_t text;
		} * textInputTag_;
	};

	// ꎞ}ÑfBNg̃t@CXg{bNXR{{bNXɋlߍ
	void fillTemporaryMacroList(HWND control, bool listBox) {
		WIN32_FIND_DATAW wfd;
		wchar_t path[MAX_PATH];

		::GetModuleFileNameW(0, path, MAX_PATH);
		wcscpy(::PathFindFileNameW(path), L"tmp-macros\\*.xml");
		HANDLE find = ::FindFirstFileW(path, &wfd);

		if(find != INVALID_HANDLE_VALUE) {
			wchar_t name[MAX_PATH];
			do {
				if(wfd.dwFileAttributes != FILE_ATTRIBUTE_DIRECTORY) {
					wcscpy(name, ::PathFindFileNameW(wfd.cFileName));
					*::PathFindExtensionW(name) = 0;
					::SendMessage(control, listBox ? LB_ADDSTRING : CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(name));
				}
			} while(toBoolean(::FindNextFile(find, &wfd)));
		}
		::FindClose(find);
	}

	// [ꎞ}N̓ǂݍ] _CAO
	class LoadTemporaryMacroDlg : public FixedIDDialog<IDD_DLG_LOADTEMPMACRO> {
	public:
		const wchar_t* getFileName() const {return fileName_;}
	protected:
		bool onCommand(WORD id, WORD notifyCode, HWND control) {
			if(id == IDC_LIST_MACROS && notifyCode == LBN_DBLCLK
					&& sendDlgItemMessage(IDC_LIST_MACROS, LB_GETCURSEL, 0, 0L) != LB_ERR)
				sendMessage(WM_COMMAND, MAKEWPARAM(IDOK, 0), 0);
			return Dialog::onCommand(id, notifyCode, control);
		}
		bool onInitDialog(HWND focusWindow, LPARAM initParam) {
			Dialog::onInitDialog(focusWindow, initParam);
			ListBox macros(getDlgItem(IDC_LIST_MACROS));
			fillTemporaryMacroList(macros, true);
			if(macros.getCount() == 0) {
				::EnableWindow(getDlgItem(IDOK), false);
				::EnableWindow(getDlgItem(IDC_BTN_EXECUTE), false);
			} else
				macros.setCurSel(0);
			return true;
		}
		void onOK() {
			ListBox macros(getDlgItem(IDC_LIST_MACROS));
			const int i = macros.getCurSel();

			if(i != LB_ERR) {
				::GetModuleFileName(0, fileName_, MAX_PATH);
				wchar_t* p = ::PathFindFileNameW(fileName_);
				wcscpy(p, L"tmp-macros\\");
				macros.getText(i, p + 11);
				wcscat(p + 11, L".xml");
			}
			Dialog::onOK();
		}
	private:
		wchar_t	fileName_[MAX_PATH];
	};

	// [ꎞ}N̕ۑ] _CAO
	class SaveTemporaryMacroDlg : public FixedIDDialog<IDD_DLG_SAVETEMPMACRO> {
	public:
		const wchar_t* getFileName() const {return fileName_;}
	protected:
		bool onCommand(WORD id, WORD notifyCode, HWND control) {
			if(id == IDC_COMBO_MACROS) {
				if(notifyCode == CBN_SELCHANGE)
					::EnableWindow(getDlgItem(IDOK), sendDlgItemMessage(IDC_COMBO_MACROS, CB_GETCURSEL, 0, 0L) != CB_ERR);
				else if(notifyCode == CBN_EDITCHANGE)
					::EnableWindow(getDlgItem(IDOK), ::GetWindowTextLength(getDlgItem(IDC_COMBO_MACROS)) != 0);
				else if(notifyCode == CBN_DBLCLK && sendDlgItemMessage(IDC_COMBO_MACROS, CB_GETCURSEL, 0, 0L) != CB_ERR)
					sendMessage(WM_COMMAND, MAKEWPARAM(IDOK, 0), 0);
			}
			return Dialog::onCommand(id, notifyCode, control);
		}
		bool onInitDialog(HWND focusWindow, LPARAM initParam) {
			Dialog::onInitDialog(focusWindow, initParam);
			fillTemporaryMacroList(ComboBox(getDlgItem(IDC_COMBO_MACROS)), false);
			return true;
		}
		void onOK() {
			::GetModuleFileName(0, fileName_, MAX_PATH);
			wchar_t* p = ::PathFindFileNameW(fileName_);
			wcscpy(p, L"tmp-macros\\");
			getDlgItemText(IDC_COMBO_MACROS, p + 11, MAX_PATH);
			wcscat(p + 11, L".xml");
			Dialog::onOK();
		}
	private:
		wchar_t	fileName_[MAX_PATH];
	};
} // namespace `anonymous'


/// L^Ă}NsA̖ɒǉL^Jn
/// @throw std::logic_error	sAL^ł΃X[
void TemporaryMacro::appendDefinition() {
	assertValid();
	execute();
	assert(definingDefinition_.commands.empty());

	SerializableCommand* command;
	for(CommandList::const_iterator it = definition_.commands.begin(); it != definition_.commands.end(); ++it) {
		(*it)->copy(command);
		definingDefinition_.commands.push_back(command);
	}
	definingDefinition_.queryPoints = definition_.queryPoints;
	startDefinition();
}

/// L^ς݁A`̃R}hXgNA
void TemporaryMacro::clearCommandList(bool definingCommands) {
	assertValid();
	CommandList& commands = definingCommands ? definingDefinition_.commands : definition_.commands;
	for(CommandList::iterator it = commands.begin(); it != commands.end(); ++it)
		delete *it;
	commands.clear();
	(definingCommands ? definingDefinition_.queryPoints : definition_.queryPoints).clear();
}

/**
 *	s
 *	@param repeatCount				JԂ
 *	@throw std::logic_error			sAL^ł΃X[
 *	@throw std::invalid_argument	JԂ񐔂 0 ̂ƂX[
 */
void TemporaryMacro::execute(ulong repeatCount /* = 1 */) {
	assertValid();
	if(repeatCount == 0)
		throw invalid_argument("Invalid repeat count.");
	else if(isDefining() || isDefining())
		throw logic_error("Player is not ready to run macro.");

	state_ = EXECUTING;
	for(ulong i = 0; i < repeatCount; ++i) {
		CommandList::iterator			command = definition_.commands.begin();
		QueryPointList::const_iterator	queryPoint = definition_.queryPoints.begin();
		for(size_t i = 0; command != definition_.commands.end(); ++i, ++command) {
			// NG
			if(queryPoint != definition_.queryPoints.end() && *queryPoint == i) {
				++queryPoint;
				const int answer =
					AlphaApp::getInstance().messageBox(MSG_TEMPORARY_MACRO_QUERY, MB_YESNOCANCEL | MB_ICONQUESTION);
				if(answer == IDNO)	// [] -> cXLbvĎ̃[v
					break;
				else if(answer == IDCANCEL) {	// [LZ] -> ~
					state_ = NEUTRAL;
					return;
				}
			}
			if(!(*command)->execute()) {
				if(errorHandlingPolicy_ == QUERY_USER);
				else if(errorHandlingPolicy_ == ABORT)	// ~
					break;
			}
		}
	}
	state_ = NEUTRAL;
}

/// L^̈ꎞ}Nɓ͑҂Ԃ}
/// @throw std::logic_error	L^łȂ΃X[
void TemporaryMacro::insertUserQuery() {
	assertValid();
	if(state_ != DEFINING)
		throw logic_error("Temporary macro is not in defining.");
	if(definingDefinition_.queryPoints.empty()
			|| definingDefinition_.queryPoints.back() != definingDefinition_.commands.size())
		definingDefinition_.queryPoints.push_back(definingDefinition_.commands.size());
}

/**
 *	ꎞ}Nt@Cǂݍ
 *	@param fileName			t@C
 *	@return					
 *	@throw std::logic_error	sAL^ł΃X[
 */
bool TemporaryMacro::load(const basic_string<WCHAR>& fileName) {
	assertValid();
	if(isDefining() || isExecuting())
		throw logic_error("Not ready to load.");

	Armaiti::ComPtr<MSXML2::ISAXXMLReader> reader;
	TemporaryMacroFileReader handler(*this);
	HRESULT hr = reader.createInstance(__uuidof(MSXML2::SAXXMLReader));
	const basic_string<WCHAR> oldFileName = fileName;

	if(FAILED(hr))
		return false;
	hr = reader->putContentHandler(&handler);
	hr = reader->putErrorHandler(&handler);
	fileName_ = fileName;
	if(FAILED(hr = reader->parseURL(reinterpret_cast<ushort*>(const_cast<wchar_t*>(fileName.c_str()))))) {
		fileName_.assign(oldFileName);
		return false;
	}
	fileName_.assign(fileName);
	return true;
}

/// R}h1L^
/// @throw std::logic_error	L^łȂ΃X[
void TemporaryMacro::pushCommand(SerializableCommand& command) {
	assertValid();
	if(state_ != DEFINING)
		throw std::logic_error("Temporary macro is not defining.");
	SerializableCommand* newCommand;
	command.copy(newCommand);
	definingDefinition_.commands.push_back(newCommand);
}

/**
 *	ꎞ}Nt@Cɕۑ
 *	@param fileName			t@C
 *	@return					
 *	@throw std::logic_error	sAL^ł΃X[
 */
bool TemporaryMacro::save(const basic_string<WCHAR>& fileName) {
	assertValid();
	if(isDefining() || isExecuting())
		throw logic_error("Not ready to save.");

	wchar_t* directory = new wchar_t[fileName.length() + 1];
	wcscpy(directory, fileName.c_str());
	*::PathFindFileNameW(directory) = 0;
	if(!toBoolean(::PathFileExistsW(directory)))
		::CreateDirectoryW(directory, 0);
	delete[] directory;

	CommandList::iterator			command = definition_.commands.begin();
	QueryPointList::const_iterator	queryPoint = definition_.queryPoints.begin();
	wostringstream					output;
	output << L"<?xml version=\"1.0\" ?>\n<temporary-macro>\n";
	for(size_t i = 0; command != definition_.commands.end(); ++i, ++command) {
		// NG
		if(queryPoint != definition_.queryPoints.end() && *queryPoint == i) {
			++queryPoint;
			output << L"\t<query-prompt-command />\n";
		}
		output << L"\t";
		(*command)->getXMLOutput(output);
	}
	output << L"</temporary-macro>\n";

	using namespace Ascension::Encodings;
	auto_ptr<Encoder> encoder(EncoderFactory::getInstance().createEncoder(CP_UTF8));
	if(encoder.get() == 0)
		return false;

	File<true> file(fileName.c_str(), FileBase::WRITE_ONLY, FileBase::DENY_WRITE, FileBase::CREATE);
	if(!file.isOpened())
		return false;

	const wstring xml = output.str();
	const size_t bufferSize = xml.length() * encoder->getMaxNativeCharLength();
	HGLOBAL data = ::GlobalAlloc(GHND, bufferSize);
	uchar* buffer = static_cast<uchar*>(::GlobalLock(data));

//	file.write(UTF8_BOM, countof(UTF8_BOM));
	file.write(buffer, static_cast<DWORD>(encoder->fromUnicode(buffer, bufferSize, xml.data(), xml.length())));
	file.close();
	::GlobalUnlock(data);
	::GlobalFree(data);
	fileName_.assign(fileName);
	return true;
}

/// ꎞ}Nǂݍނ߂̃_CAO\
void TemporaryMacro::showLoadDialog() {
	LoadTemporaryMacroDlg dlg;
	if(dlg.doModal(AlphaApp::getInstance().getMainWindow()) == IDOK)
		load(dlg.getFileName());
}

/// ꎞ}Nۑ邽߂̃_CAO\
void TemporaryMacro::showSaveDialog() {
	SaveTemporaryMacroDlg dlg;
	if(dlg.doModal(AlphaApp::getInstance().getMainWindow()) == IDOK)
		save(dlg.getFileName());
}

/* [EOF] */