// TemporaryMacro.h
// (c) 2003-2005 exeal

#ifndef TEMPORARY_MACRO_H_
#define TEMPORARY_MACRO_H_

#include "../Manah/Object.hpp"
#include <list>


namespace Alpha {
	class CommandManager;
	class SerializableCommand;

	/// ꎞ}N (L[{[h}N) ̊Ǘ
	class TemporaryMacro : public Manah::SelfAssertable, public Manah::Noncopyable {
	public:
		/// 
		enum State {
			NEUTRAL,		///< 
			EXECUTING,		///< s
			DEFINING,		///< L^
			QUERYING_USER,	///< sʒu~ ([Ủ҂)
			PAUSING			///< L^ꎞ~
		};

		/// sɃG[ꍇ̏
		enum ErrorHandlingPolicy {
			IGNORE_AND_CONTINUE,	///< đs
			QUERY_USER,				///< [Uɖ₢킹
			ABORT					///< ~
		};

		// RXgN^
	public:
		TemporaryMacro() throw();

		// \bh
	public:
		void	appendDefinition();
		void	cancelDefinition();
		void	endDefinition();
		void	execute(ulong repeatCount = 1);
		void	insertUserQuery();
		void	pauseDefinition();
		void	pushCommand(SerializableCommand& command);
		void	restartDefinition();
		void	startDefinition();

		ErrorHandlingPolicy	getErrorHandlingPolicy() const throw();
		void				setErrorHandlingPolicy(ErrorHandlingPolicy policy) throw();
		const std::basic_string<WCHAR>&
							getFileName() const throw();
		State				getState() const throw();
		bool				isDefining() const throw();
		bool				isEmpty() const throw();
		bool				isExecuting() const throw();

		bool	load(const std::basic_string<WCHAR>& fileName);
		bool	save(const std::basic_string<WCHAR>& fileName);

		void	showLoadDialog();
		void	showSaveDialog();

	private:
		void	clearCommandList(bool definingCommands);

		// f[^o
	private:
		typedef std::list<SerializableCommand*>	CommandList;
		typedef std::list<std::size_t>			QueryPointList;
		struct Definition {
			CommandList commands;
			QueryPointList queryPoints;
		};
		State				state_;					// ꎞ}N̏
		Definition			definingDefinition_;	// L^̒`
		Definition			definition_;			// L^`
		ErrorHandlingPolicy	errorHandlingPolicy_;
		std::basic_string<WCHAR>	fileName_;	// ֘AtĂt@C
	};


	// inline implementation
	////////////////////////////////////////////////////////////////////////////

	/// RXgN^
	inline TemporaryMacro::TemporaryMacro() throw() : state_(NEUTRAL), errorHandlingPolicy_(IGNORE_AND_CONTINUE) {}

	/// L^𒆎~
	/// @throw std::logic_error	L^łȂ΃X[
	inline void TemporaryMacro::cancelDefinition() {
		assertValid();
		if(!isDefining())
			throw std::logic_error("Temporary macro is not in recording.");
		clearCommandList(true);
		state_ = NEUTRAL;
	}

	/// L^I
	/// @throw std::logic_error	L^łȂ΃X[
	inline void TemporaryMacro::endDefinition() {
		assertValid();
		if(definingDefinition_.commands.empty()) {	// L^ĂȂΒ~
			cancelDefinition();
			return;
		}
		if(!isDefining())
			throw std::logic_error("Temporary macro is not defining.");
		definition_ = definingDefinition_;
		definingDefinition_.commands.clear();
		definingDefinition_.queryPoints.clear();
		state_ = NEUTRAL;
		fileName_.erase();;
	}

	/// G[|V[Ԃ
	inline TemporaryMacro::ErrorHandlingPolicy TemporaryMacro::getErrorHandlingPolicy() const throw() {assertValid(); return errorHandlingPolicy_;}

	/// L^eɊ֘AtĂt@CԂBt@Cꍇ͋󕶎
	inline const std::basic_string<WCHAR>& TemporaryMacro::getFileName() const throw() {assertValid(); return fileName_;}

	/// ԂԂ
	inline TemporaryMacro::State TemporaryMacro::getState() const {assertValid(); return state_;}

	/// L^ł邩Ԃ
	inline bool TemporaryMacro::isDefining() const throw() {assertValid(); return state_ == DEFINING || state_ == PAUSING;}

	/// L^e󂩂Ԃ
	inline bool TemporaryMacro::isEmpty() const throw() {assertValid(); return definition_.commands.empty();}

	/// sł邩Ԃ
	inline bool TemporaryMacro::isExecuting() const throw() {assertValid(); return state_ == EXECUTING || state_ == QUERYING_USER;}

	/// L^̈ꎞf
	/// @throw std::logic_error	L^łȂ΃X[
	inline void TemporaryMacro::pauseDefinition() {
		assertValid();
		if(state_ != DEFINING)
			throw std::logic_error("Temporary macro is not defining.");
		state_ = PAUSING;
	}

	/// L^ꎞfԂ畜A
	/// @throw std::logic_error	L^ꎞ~A͑҂ԂłȂ΃X[
	inline void TemporaryMacro::restartDefinition() {
		assertValid();
		if(state_ != PAUSING)
			throw std::logic_error("Temporary macro is not pausing definition.");
		state_ = DEFINING;
	}

	/// G[|V[̐ݒ
	inline void TemporaryMacro::setErrorHandlingPolicy(ErrorHandlingPolicy policy) throw() {assertValid(); errorHandlingPolicy_ = policy;}

	/// L^Jn
	/// @throw std::logic_error	sAL^ł΃X[
	inline void TemporaryMacro::startDefinition() {
		assertValid();
		if(isDefining() || isExecuting())
			throw std::logic_error("Recorder is not ready to start recording.");
		state_ = DEFINING;
	}

} // namespace Ascension

#endif /* _KEYBOARD_MACRO_H_ */

/* [EOF] */