// ComBasic.h
// (c) 2002-2006 exeal

#ifndef COM_BASIC_H_
#define COM_BASIC_H_

#include <objbase.h>
#include <objsafe.h>
#include <cassert>
#include <stdexcept>


namespace Armaiti {

// }NƂ
/////////////////////////////////////////////////////////////////////////////

#define RETURN_IF_FAILED(hr)	\
	if(FAILED(hr))				\
		return (hr)

#define VERIFY_POINTER(p)	\
	if((p) == 0)			\
		return E_POINTER

#define SAFE_BSTR(bstr)	\
	((bstr != 0) ? (bstr) : OLESTR(""))

#ifndef toBoolean
#define toBoolean(b)	((b) != 0)
#endif

#define toVariantBoolean(b)	\
	(((b) != 0) ? VARIANT_TRUE : VARIANT_FALSE)

#define isEmptyBSTR(bstr)	\
	(bstr == 0 || *bstr == 0)



/// ComPtr::operator-> Ԃ AddRef ARelease Ăяo֎~vLV
template<class T> class ComPtrProxy : public T {
	// \bh
private:
	STDMETHOD_(ULONG, AddRef)() = 0;
	STDMETHOD_(ULONG, Release)() = 0;
//
//	// Zq
//private:
//	void	operator delete(void*);
};

/// Öق̌^ϊF߂|V[
struct AllowConversion {};

/// Öق̌^ϊF߂Ȃ|V[
struct DisallowConversion {};

/// AhXZqĂяoƂɕێĂ|C^ Release |V[
struct ReleasePreviousPointer {enum {release = true};};

/// AhXZqĂяoƂɊɃ|C^ĂȂ assert |V[
struct AssertPointerIsNull {enum {release = false};};

/**
 *	COM X}[g|C^
 *	@param T				C^[tFCX^
 *	@param AddressingPolicy	łɃ|C^ێĂƂ̃AhXZq̋B
 *							AhXZq̐Q
 *	@param ConversionPolicy	Öق̌^ϊs
 */
template<class T,
	class AddressingPolicy = ReleasePreviousPointer,
	class ConversionPolicy = AllowConversion>
class ComPtr {
	// RXgN^
public:
	///	RXgN^
	explicit ComPtr(T* p = 0) : pointee_(p) {if(pointee_ != 0) pointee_->AddRef();}
	///	Rs[RXgN^
	ComPtr(const ComPtr<T>& rhs) : pointee_(rhs.pointee_) {if(pointee_ != 0) pointee_->AddRef();}
	///	fXgN^
	virtual ~ComPtr() {if(pointee_ != 0) pointee_->Release();}

	// Zq
public:
	/**
	 *	@brief	AhXZq
	 *	̉Zq̌ʂ͗Ⴆ CreateObject(&p);
	 *	Ȃǂ̂悤ɏo͈ƂĂ̂ݎgp邱ƂOƂĂB
	 *	ZqĂяoɃIuWFNg null łȂꍇ̋
	 *	AddressingPolicy ɂ
	 */
	T** operator &() {
		if(pointee_ != 0) {
			if(AddressingPolicy::release)
				pointee_->Release();
			else
				assert(false);
		}
		return &pointee_;
	}
	///	oANZXZq
	ComPtrProxy<T>* operator ->() const {assert(pointee_ != 0); return static_cast<ComPtrProxy<T>*>(pointee_);}
//	T& operator *() const {assert(pointee_ != 0); return *pointee_;}
	/**
	 *	@brief	Zq
	 *	<var>p</var>  null ł悢
	 */
	ComPtr<T>& operator =(T* p) {
		if(pointee_ != p) {
			if(pointee_ != 0)
				pointee_->Release();
			pointee_ = p;
			if(pointee_ != 0)
				pointee_->AddRef();
		}
		return *this;
	}
	/// Zq
	template<class I> ComPtr<T>& operator =(const ComPtr<I>& rhs) {
		if(this != &rhs) {
			if(pointee_ != 0)
				pointee_->Release();
			pointee_ = rhs.pointee_;
			pointee_->AddRef();
		}
		return *this;
	}
	/// Zq
	bool operator ==(const T* p) const throw() {return pointee_ == p;}
	/// sZq
	bool operator !=(const T* p) const throw() {return pointee_ != p;}
	/// ̃|C^^ւ̃LXg
	operator T*() const;

	// \bh
public:
	/// ::CoCreateInstance ɂIuWFNg
	HRESULT createInstance(REFCLSID rclsid, IUnknown* unkOuter = 0, DWORD clsContext = CLSCTX_ALL, REFIID riid = __uuidof(T)) {
		assert(pointee_ == 0); return ::CoCreateInstance(rclsid, unkOuter, clsContext, riid, reinterpret_cast<void**>(&pointee_));}
	/// <var>p</var> ƓIuWFNgǂԂ
	bool isEqualObject(IUnknown* p) const {
		if(pointee_ == 0 && p == 0)
			return true;
		else if(pointee_ == 0 || p == 0)
			return false;

		IUnknown*	p1 = 0;
		IUnknown*	p2 = 0;
		bool		b;

		pointee_->QueryInterface(IID_IUnknown, reinterpret_cast<void**>(p1));
		p->QueryInterface(IID_IUnknown, reinterpret_cast<void**>(p2));
		b = p1 == p2;
		p1->Release();
		p2->Release();

		return b;
	}
	/**
	 *	@see		IUnknown::QueryInterface
	 *	@param pp	[out] LXg
	 */
	template<class I>
	HRESULT queryInterface(I** pp) const {
		assert(pointee_ != 0);
		if(pp == 0)
			return E_POINTER;
		return pointee_->QueryInterface(__uuidof(I), reinterpret_cast<void**>(pp));
	}
	/**
	 *	̃|C^ւ̖IȃANZX
	 *	@param p	X}[g|C^
	 *	@return		̃|C^
	 */
	static T* getRowPointer(const ComPtr<T>& p) throw() {return p.pointee_;}

	// f[^o
private:
	T* pointee_;
};

template<class T, class AddressingPolicy, typename AllowConversion>
inline ComPtr<T, AddressingPolicy, AllowConversion>::operator T*() const throw() {return pointee_;}


/**
 *	@brief	IErrorInfo  C++ OƂĈ߂̃bpNX
 *	o: Essential COM (Don Box)
 */
class ComException {
	// RXgN^
public:
	/**
	 *	RXgN^
	 *	@param scode		SCODE
	 *	@param riid			IID
	 *	@param source		̗O𓊂NX
	 *	@param description	O̐Bnull ̏ꍇ <var>hr</var> 擾
	 *	@param helpFile		wvt@C̃pX
	 *	@param helpContext	wvgsbN̔ԍ
	 */
	ComException(HRESULT scode, REFIID riid,
			const OLECHAR* source, const OLECHAR* description = 0, const OLECHAR* helpFile = 0, DWORD helpContext = 0) {
		ICreateErrorInfo* pcei = 0;

		assert(FAILED(scode));

		HRESULT hr = ::CreateErrorInfo(&pcei);
		assert(SUCCEEDED(hr));

		hr = pcei->SetGUID(riid);
		assert(SUCCEEDED(hr));
		if(source != 0) {
			hr = pcei->SetSource(const_cast<OLECHAR*>(source));
			assert(SUCCEEDED(hr));
		}
		if(description != 0) {
			hr = pcei->SetDescription(const_cast<OLECHAR*>(description));
			assert(SUCCEEDED(hr));
		} else {
			BSTR bstrDescription = 0;
			ComException::getDescriptionOfSCode(scode, bstrDescription);
			hr = pcei->SetDescription(bstrDescription);
			::SysFreeString(bstrDescription);
			assert(SUCCEEDED(hr));
		}
		if(helpFile != 0) {
			hr = pcei->SetHelpFile(const_cast<OLECHAR*>(helpFile));
			assert(SUCCEEDED(hr));
		}
		hr = pcei->SetHelpContext(helpContext);
		assert(SUCCEEDED(hr));

		hr_ = scode;
		hr = pcei->QueryInterface(IID_IErrorInfo, reinterpret_cast<void**>(&errorInfo_));
		assert(SUCCEEDED(hr));
		pcei->Release();
	}
	/// fXgN^
	virtual ~ComException() {if(errorInfo_ != 0) errorInfo_->Release();}

	// \bh
public:
	/// G[ IErrorInfo Ԃ
	void getErrorInfo(IErrorInfo*& errorInfo) const {errorInfo = errorInfo_; errorInfo->AddRef();}
	/// G[ HRESULT Ԃ
	HRESULT getSCode() const throw() {return hr_;}
	/// OIuWFNg_XbhOƂē
	void throwLogicalThreadError() {::SetErrorInfo(0, errorInfo_);}
	/**
	 *	HRESULT ɑΉG[bZ[WԂ
	 *	@param hr			[in] HRESULT
	 *	@param description	[out] G[bZ[W
	 *	@param languageId	[in]  ID
	 */
	static void getDescriptionOfSCode(HRESULT hr, BSTR& description, DWORD languageId = MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT)) {
		void* buffer = 0;
		FormatMessageW(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			0, hr, languageId, reinterpret_cast<wchar_t*>(&buffer), 0, 0);
		description = ::SysAllocString(reinterpret_cast<OLECHAR*>(buffer));
		::LocalFree(buffer);
	}

	// f[^o
private:
	HRESULT hr_;
	IErrorInfo* errorInfo_;

};


/**
 *	NeBJZNVœsBATL ƂقƂǓ
 *	@param auto	CX^X̐AjɎIɃNeBJZNVAj󂷂邩
 */
template<bool automatic = true>
class ComCriticalSection {
public:
	/// RXgN^
	ComCriticalSection() {if(automatic) if(FAILED(doInit())) throw std::runtime_error("Failed to initialize critical section!");}
	/// fXgN^
	~ComCriticalSection() {if(automatic) doTerm();}
	/// bN
	void lock() {::EnterCriticalSection(&cs_);}
	/// bN
	void unlock() {::LeaveCriticalSection(&cs_);}
	/// CX^X
	HRESULT init();
	/// CX^X̌㏈
	void term();

private:
	ComCriticalSection(ComCriticalSection&);
	ComCriticalSection& operator =(ComCriticalSection&);
	HRESULT doInit() {
		__try {
			::InitializeCriticalSection(&cs_);
		} __except(EXCEPTION_EXECUTE_HANDLER) {
			return (STATUS_NO_MEMORY == ::GetExceptionCode()) ? E_OUTOFMEMORY : E_FAIL;
		}
		return S_OK;
	}
	void doTerm() {::DeleteCriticalSection(&cs_);}
private:
	CRITICAL_SECTION cs_;
};

template<> inline HRESULT ComCriticalSection<false>::init() {return doInit();}

template<> inline void ComCriticalSection<false>::term() {doTerm();}


/// ISupportErrorInfo ̕WIȎ
template<const IID* iid> class ISupportErrorInfoImpl : virtual public ISupportErrorInfo {
	STDMETHODIMP InterfaceSupportsErrorInfo(REFIID riid) {return (riid == *iid) ? S_OK : S_FALSE;}
};


/**
 *	@brief	IObjectSafety ̒PȎ
 *
 *	̎͒P̃C^[tFCXT|[gȂ
 *	@param supportedSafety	T|[gIvV
 */
template<DWORD supportedSafety> class IObjectSafetyImpl : virtual public IObjectSafety {
public:
	IObjectSafetyImpl(DWORD enabledOptions = 0) : enabledSafety_(enabledOptions & supportedSafety) {}
	virtual ~IObjectSafetyImpl() {}
public:
	STDMETHODIMP GetInterfaceSafetyOptions(REFIID riid, DWORD* pdwSupportedOptions, DWORD* pdwEnabledOptions) {
		VERIFY_POINTER(pdwSupportedOptions);
		VERIFY_POINTER(pdwEnabledOptions);

		IUnknown* p;
		if(SUCCEEDED(QueryInterface(riid, reinterpret_cast<void**>(&p)))) {
			p->Release();
			*pdwSupportedOptions = supportedSafety;
			*pdwEnabledOptions = enabledSafety_;
			return S_OK;
		} else {
			*pdwSupportedOptions = *pdwEnabledOptions = 0;
			return E_NOINTERFACE;
		}
	}
	STDMETHODIMP SetInterfaceSafetyOptions(REFIID riid, DWORD dwOptionSetMask, DWORD dwEnabledOptions) {
		IUnknown* p;

		if(FAILED(QueryInterface(riid, reinterpret_cast<void**>(&p))))
			return E_NOINTERFACE;
		p->Release();
		if(toBoolean(dwOptionSetMask & ~supportedSafety))
			return E_FAIL;
		enabledSafety_ = (enabledSafety_ & ~dwOptionSetMask) | (dwOptionSetMask & dwEnabledOptions);
		return S_OK;
	}
protected:
	DWORD enabledSafety_;
};

} // namespace Armaiti

#endif /* COM_BASIC_H_ */

/* [EOF] */