// DispatchImpl.hpp
// (c) 2002-2006 exeal

#ifndef DISPATCH_IMPL_HPP_
#define DISPATCH_IMPL_HPP_

#include "ComBasic.hpp"


namespace Armaiti {
namespace OLE {

// IProvideClassInfo2Impl class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	IProvideClassInfo2 ̊{IȎ
 *	@param clsid		CLSID
 *	@param iid			IID
 *	@param libid		LIBID
 *	@param majorVersion	W[o[W
 *	@param minorVersion	}Ci[o[W
 */
template<const CLSID* clsid, const IID* iid, const GUID* libid, WORD majorVersion = 1, WORD minorVersion = 0>
class IProvideClassInfo2Impl : virtual public IProvideClassInfo2 {
	// RXgN^
public:
	/// RXgN^
	IProvideClassInfo2Impl() : typeInfo_(0) {
		ComPtr<ITypeLib> typeLib;
		HRESULT hr = ::LoadRegTypeLib(*libid, majorVersion, minorVersion, 0, &typeLib);
		assert(SUCCEEDED(hr));
		typeLib->GetTypeInfoOfGuid(*iid, &typeInfo_);
		assert(SUCCEEDED(hr));
	}
	/// fXgN^
	virtual ~IProvideClassInfo2Impl() {
		if(typeInfo_ != 0)
			typeInfo_->Release();
	}

	// \bh
public:
	///	@see IProvideClassInfo::GetClassInfo
	STDMETHOD(GetClassInfo)(ITypeInfo** ppTypeInfo) {
		if(ppTypeInfo == 0)
			return E_POINTER;
		*ppTypeInfo = typeInfo_;
		(*ppTypeInfo)->AddRef();
		return S_OK;
	}

	///	@see IProvideClassInfo2::GetGUID
	STDMETHOD(GetGUID)(DWORD dwGuidKind, GUID* pGUID) {
		if(pGUID == 0)
			return E_POINTER;
		if(dwGuidKind == GUIDKIND_DEFAULT_SOURCE_DISP_IID && clsid != 0) {
			*pGUID = iid;
			return S_OK;
		}
		*pGUID = 0;
		return E_INVALIDARG;
	}

	// f[^o
private:
	ITypeInfo* typeInfo_;
};


// IDispatchImpl NX̂߂2̃|V[NX
/////////////////////////////////////////////////////////////////////////////

/**
 *	LIBID ^CvCu[h
 *	@param libid		^CvCu LIBID
 *	@param iid			IID
 *	@param majorVersion	W[o[W
 *	@param minorVersion	}Ci[o[W
 */
template<const GUID* libid, const IID* iid, WORD majorVersion = 1, WORD minorVersion = 0> class RegTypeLibTypeInfoHolder {
public:
	/// RXgN^
	RegTypeLibTypeInfoHolder() {
		ComPtr<ITypeLib> typeLib;
		assert(libid != 0 && iid != 0);
		HRESULT hr = ::LoadRegTypeLib(*libid, majorVersion, minorVersion, 0, &typeLib);
		assert(SUCCEEDED(hr));
		hr = typeLib->GetTypeInfoOfGuid(*iid, &typeInfo_);
		assert(SUCCEEDED(hr));
	}
	/// fXgN^
	virtual ~RegTypeLibTypeInfoHolder() {
		if(typeInfo_ != 0)
			typeInfo_->Release();
	}
	/// ITypeInfo CX^XԂ
	ITypeInfo* getTypeInfo() const throw() {return typeInfo_;}
private:
	ITypeInfo* typeInfo_;
};

/**
 *	ڃpXw肵ă^CvCu[h
 *	@param TypeLibPath	^CvCũpX񋟂NX
 *	@param iid			IID
 */
template<class TypeLibPath, const IID* iid> class PathTypeLibTypeInfoHolder {
public:
	/// RXgN^
	PathTypeLibTypeInfoHolder() {
		ComPtr<ITypeLib> typeLib;
		HRESULT hr = ::LoadTypeLib(TypeLibPath::getPath(), &typeLib);
		assert(SUCCEEDED(hr));
		hr = typeLib->GetTypeInfoOfGuid(*iid, &typeInfo_);
		assert(SUCCEEDED(hr));
	}
	/// fXgN^
	virtual ~PathTypeLibTypeInfoHolder() {
		if(typeInfo_ != 0)
			typeInfo_->Release();
	}
	/// ITypeInfo CX^XԂ
	ITypeInfo* getTypeInfo() const throw() {return typeInfo_;}
private:
	ITypeInfo* typeInfo_;
};


// IDispatchImpl class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	IDispatch ̕WIȎ
 *	@param DI				IDispatch ƂC^[tFCX
 *	@param TypeInfoHolder	ITypeInfo 񋟂NX
 */
template<class DI, class TypeInfoHolder>
class IDispatchImpl : virtual public DI {
	// \bh
public:
	/// @see IDispatch::GetIDsOfNames
	STDMETHOD(GetIDsOfNames)(REFIID riid,
			OLECHAR** rgszNames, unsigned int cNames, LCID lcid, DISPID* rgDispId) {
		assert(riid == IID_NULL);
		return ::DispGetIDsOfNames(typeInfoHolder_.getTypeInfo(), rgszNames, cNames, rgDispId);
	}

	/// @see IDispatch::GetTypeInfo
	STDMETHOD(GetTypeInfo)(unsigned int iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo) {
		VERIFY_POINTER(ppTypeInfo);
		if(iTypeInfo != 0)
			return DISP_E_BADINDEX;
		(*ppTypeInfo = typeInfoHolder_.getTypeInfo())->AddRef();
		return S_OK;
	}

	/// @see IDispatch::GetTypeInfoCount
	STDMETHOD(GetTypeInfoCount)(unsigned int* pctInfo) {
		VERIFY_POINTER(pctInfo);
		*pctInfo = 1;
		return S_OK;
	}

	/// @see IDispatch::Invoke
	STDMETHOD(Invoke)(DISPID dispidMember, REFIID riid, LCID, WORD wFlags,
			DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
		if(riid != IID_NULL)
			return DISP_E_UNKNOWNINTERFACE;
		return ::DispInvoke(static_cast<DI*>(this),
				typeInfoHolder_.getTypeInfo(), dispidMember, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
	}

	// f[^o
private:
	TypeInfoHolder typeInfoHolder_;
};

} // namespace OLE
} // namespace Armaiti

#endif /* DISPATCH_IMPL_HPP_ */

/* [EOF] */