// OleTypeWrapper.hpp
// (c) 2002-2006 exeal

#ifndef OLE_TYPE_WRAPPER_HPP_
#define OLE_TYPE_WRAPPER_HPP_

#include "ComBasic.hpp"


namespace Armaiti {
namespace OLE {

// ComBSTR class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// BSTR ̃bp (! ̃NX͐ BSTR ւ̕ϊZq)
/// @see	comutil.h  _bstr_t NX
class ComBSTR {
	// RXgN^
public:
	///	RXgN^
	/// OLE 񂩂珉B
	explicit ComBSTR(const OLECHAR* p = 0) : bstr_(::SysAllocString(p)) {}
	///	RXgN^B
	///	ANSI 񂩂珉
	explicit ComBSTR(const char* p) {
		if(p != 0) {
			int len = ::MultiByteToWideChar(CP_ACP, 0, p, -1, 0, 0);
			wchar_t* buffer = new wchar_t[len + 1];
			::MultiByteToWideChar(CP_ACP, 0, p, -1, buffer, len);
			bstr_ = ::SysAllocString(buffer);
			delete[] buffer;
		} else
			bstr_ = 0;
	}
	///	RXgN^B
	///	ɕϊ\ VARIANT 珉
	explicit ComBSTR(const VARIANT& value) {
		if(value.vt == VT_BSTR)
			bstr_ = ::SysAllocString(value.bstrVal);
		else {
			VARIANT clone;
			::VariantChangeType(&clone, const_cast<VARIANT*>(&value), 0, VT_BSTR);
			bstr_ = ::SysAllocString(clone.bstrVal);
			::SysFreeString(clone.bstrVal);
		}
	}
	/// Rs[RXgN^
	explicit ComBSTR(const ComBSTR& rhs) : bstr_(::SysAllocString(rhs.bstr_)) {}
	/// fXgN^
	~ComBSTR() {if(bstr_ != 0) ::SysFreeString(bstr_);}

	// Zq
public:
	/// Zq
	ComBSTR& operator =(const OLECHAR* p) {assign(p); return *this;}
	/// Öق̕ϊZq
	operator BSTR() throw() {return bstr_;}

	// \bh
public:
	/// 
	void assign(const OLECHAR* p) {assert(p != 0); if(!::SysReAllocString(&bstr_, p)) throw std::bad_alloc("SysReAllocString failed.");}
	/// BSTR Ԃ
	const BSTR getBSTR() const throw() {return bstr_;}
	/// 󕶎񂩂ǂԂ
	bool isEmpty() const throw() {return getLength() == 0;}
	/// ̒Ԃ
	UINT getLength() const throw() {return ::SysStringLen(bstr_);}
	/// ̃oCgԂ
	UINT getByteLength() const throw() {return ::SysStringByteLen(bstr_);}

	// f[^o
private:
	BSTR bstr_;
};

/// ComBSTR ̓Zq
inline bool operator ==(const ComBSTR& lhs, const OLECHAR* rhs) throw() {return std::wcscmp(SAFE_BSTR(lhs.getBSTR()), rhs) == 0;}

/// ComBSTR ̓Zq
inline bool operator ==(const OLECHAR* lhs, const ComBSTR& rhs) throw() {return rhs == lhs;}

/// ComBSTR ̔񓙉Zq
inline bool operator !=(const ComBSTR& lhs, const OLECHAR* rhs) throw() {return !(lhs == rhs);}

/// ComBSTR ̔񓙉Zq
inline bool operator !=(const OLECHAR* lhs, const ComBSTR& rhs) throw() {return !(rhs == lhs);}


// ComVariant class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// VARTYPE  C++ ̌^ɕϊ
template<VARTYPE type> struct VarType2CppType;

/// C++ ̌^ VARTYPE ɕϊ
template<class type> struct CppType2VarType;

/// ٕ
template<VARTYPE type> struct VarTypeDescriminator {
	typedef typename VarType2CppType<type>::result CppType;
	typedef CppType(VARIANT::*MemberType);
	static MemberType member;
	static CppType& value(VARIANT& var);
};
template<VARTYPE type> typename VarTypeDescriminator<type>::MemberType VarTypeDescriminator<type>::member = 0;

#define MAP_TYPE_V2C(var_type, cpp_type)	\
	template<> struct VarType2CppType<var_type> {typedef cpp_type result;};
#define MAP_TYPE(var_type, cpp_type)	\
	MAP_TYPE_V2C(var_type, cpp_type)	\
	template<> struct CppType2VarType<cpp_type> {enum{result = var_type};};
#define DESCRIMINATE_TYPE(var_type, member_name)				\
	template<> inline VarTypeDescriminator<var_type>::CppType&	\
	VarTypeDescriminator<var_type>::value(VARIANT& var) {return (member = &VARIANT::member_name), var.*member;}
#define VARTYPE_TABLE_V2C(var_type, cpp_type, member_name)	\
	MAP_TYPE_V2C(var_type, cpp_type)						\
	DESCRIMINATE_TYPE(var_type, member_name)
#define VARTYPE_TABLE(var_type, cpp_type, member_name)	\
	MAP_TYPE(var_type, cpp_type)						\
	DESCRIMINATE_TYPE(var_type, member_name)

// S`ƃG[ɂȂ
VARTYPE_TABLE(VT_I8, LONGLONG, llVal)
VARTYPE_TABLE(VT_I4, LONG, lVal)	// conflicts with VT_ERROR/SCODE
VARTYPE_TABLE(VT_UI1, BYTE, bVal)
VARTYPE_TABLE_V2C(VT_I2, SHORT, iVal)	// conflicts with VT_BOOL/VARIANT_BOOL
VARTYPE_TABLE(VT_R4, FLOAT, fltVal)
VARTYPE_TABLE(VT_R8, DOUBLE, dblVal)	// conflicts with VT_DATE/DATE
VARTYPE_TABLE(VT_BOOL, VARIANT_BOOL, boolVal)	// conflicts with VT_I2/SHORT
VARTYPE_TABLE_V2C(VT_ERROR, SCODE, scode)	// conflicts with VT_I4/LONG
VARTYPE_TABLE(VT_CY, CY, cyVal)
VARTYPE_TABLE_V2C(VT_DATE, DATE, date)	// conflicts with VT_R8/DOUBLE
VARTYPE_TABLE(VT_BSTR, BSTR, bstrVal)
VARTYPE_TABLE(VT_UNKNOWN, IUnknown*, punkVal)
VARTYPE_TABLE(VT_DISPATCH, IDispatch*, pdispVal)
VARTYPE_TABLE(VT_ARRAY, SAFEARRAY*, parray)
VARTYPE_TABLE(VT_BYREF, VOID*, byref)
VARTYPE_TABLE(VT_I1, CHAR, cVal)
VARTYPE_TABLE(VT_UI2, USHORT, uiVal)
VARTYPE_TABLE(VT_UI4, ULONG, ulVal)
VARTYPE_TABLE(VT_UI8, ULONGLONG, ullVal)
VARTYPE_TABLE(VT_INT, INT, intVal)
VARTYPE_TABLE(VT_UINT, UINT, uintVal)
MAP_TYPE(VT_VARIANT, VARIANT)
template<> inline VarTypeDescriminator<VT_VARIANT>::CppType&
VarTypeDescriminator<VT_VARIANT>::value(VARIANT& var) {return var;}

#undef MAP_TYPE
#undef DESCRIMINATE_TYPE
#undef VARTYPE_TABLE

/// VARIANT AVARIANTARG ̃bp (! ̃NX͐ VARIANT ւ̕ϊZq)
/// @see	comutil.h  _variant_t NX
class ComVariant : public tagVARIANT {
	// RXgN^
public:
	ComVariant() {::VariantInit(this);}
	ComVariant(const ComVariant& rhs) {vt = VT_EMPTY; copy(rhs);}
	explicit ComVariant(const tagVARIANT& value) {vt = VT_EMPTY; copy(value);}
	template<class T>
	explicit ComVariant(const T&) {vt = CppType2VarType<T>::result; *VarTypeDescriminator<CppType2VarType<T>::result>(*this) = value;}
	ComVariant(const OLECHAR* value) {vt = VT_EMPTY; *this = value;}
	ComVariant(const BSTR value) {vt = VT_EMPTY; *this = value;}
	ComVariant(bool value) {vt = VT_BOOL; boolVal = toVariantBoolean(value);}
	ComVariant(const IDispatch& value) {
		vt = VT_DISPATCH;
		pdispVal = const_cast<IDispatch*>(&value);
		if(pdispVal != 0)
			pdispVal->AddRef();
	}
	ComVariant(const IUnknown& value) {
		vt = VT_UNKNOWN;
		punkVal = const_cast<IUnknown*>(&value);
		if(punkVal != 0)
			punkVal->AddRef();
	}
	virtual ~ComVariant() {clear();}

	// \bh
public:
	///	A^b`
	HRESULT attach(const VARIANT& var) {
		const HRESULT hr = clear();
		if(SUCCEEDED(hr)) {
			std::memcpy(this, &var, sizeof(VARIANT));
			vt = VT_EMPTY;
		}
		return hr;
	}
	///	^ύX
	HRESULT changeType(VARTYPE type, const VARIANT* src = 0) {
		return ::VariantChangeType(this, (src == 0) ? this : const_cast<VARIANT*>(src), 0, type);}
	///	
	HRESULT clear() {return ::VariantClear(this);}
	///	Rs[
	HRESULT copy(const VARIANT& src) {
		HRESULT hr = ::VariantCopy(this, const_cast<VARIANT*>(&src));
		if(FAILED(hr))
			vt = VT_ERROR, scode = hr;
		return hr;
	}
	///	f^b`
	HRESULT detach(VARIANT& var) {
		const HRESULT hr = ::VariantClear(&var);
		if(SUCCEEDED(hr)) {
			std::memcpy(&var, this, sizeof(VARIANT));
			vt = VT_EMPTY;
		}
		return hr;
	}
//	HRESULT readFromStream(IStream& stream) {return E_NOTIMPL;}
//	HRESULT writeToStream(IStream& stream) {return E_NOTIMPL;}

	// Zq
public:
	ComVariant& operator =(const ComVariant& rhs) {copy(rhs); return *this;}
	ComVariant& operator =(const tagVARIANT& rhs) {copy(rhs); return *this;}
	ComVariant& operator =(const OLECHAR* rhs) {
		clear();
		vt = VT_BSTR;
		bstrVal = ::SysAllocString(rhs);
		if(bstrVal == 0 && rhs != 0)
			vt = VT_ERROR, scode = E_OUTOFMEMORY;
		return *this;
	}
	ComVariant& operator =(const BSTR rhs) {
		clear();
		vt = VT_BSTR;
		bstrVal = ::SysAllocString(rhs);
		if(bstrVal == 0 && rhs != 0)
			vt = VT_ERROR, scode = E_OUTOFMEMORY;
		return *this;
	}
	ComVariant& operator =(bool rhs) {
		if(vt != VT_BOOL)
			clear(), vt = VT_BOOL;
		boolVal = toVariantBoolean(rhs);
		return *this;
	}
	template<class T> ComVariant& operator =(const T& rhs) {
		if(vt != CppType2VarType<T>::result)
			clear(), vt = CppType2VarType<T>::result;
		VarTypeDescriminator<CppType2VarType<T>::result>::value(*this) = rhs;
		return *this;
	}
	ComVariant& operator =(const IDispatch& rhs) {
		clear(), vt = VT_DISPATCH;
		pdispVal = const_cast<IDispatch*>(&rhs);
		if(pdispVal != 0)
			pdispVal->AddRef();
		return *this;
	}
	ComVariant& operator =(const IUnknown& rhs) {
		clear(), vt = VT_UNKNOWN;
		punkVal = const_cast<IUnknown*>(&rhs);
		if(punkVal != 0)
			punkVal->AddRef();
		return *this;
	}
	template<class T> operator T() const {
		if(vt == CppType2VarType<T>::result)
			return VarTypeDescriminator<CppType2VarType<T>::result>::value(*this);
		VARIANT temp;
		::VariantInit(&temp);
		::VariantChangeType(&temp, const_cast<ComVariant*>(this), 0, CppType2VarType<T>::result);
		return VarTypeDescriminator<CppType2VarType<T>::result>::value(temp);
	}
};

} // namespace OLE
} // namespace Armaiti

#endif /* OLE_TYPE_WRAPPER_HPP_ */

/* [EOF] */