// UnknownImpl.hpp
// (c) 2002-2006 exeal

#ifndef UNKNOWN_IMPL_HPP_
#define UNKNOWN_IMPL_HPP_

#include "ComBasic.hpp"

/**
 *	@file UnknownImpl.hpp
 *	IUnknown 3̃\bh}N`
 */


namespace Armaiti {

template<bool multiThreaded>
class ReferenceCounter {
public:
	ReferenceCounter() throw() : count_(0) {}
	long get() const throw() {return count_;}
	long increment();
	long decrement();
private:
	long count_;
};

template<> inline long ReferenceCounter<true>::decrement() {return ::InterlockedDecrement(&count_);}
template<> inline long ReferenceCounter<true>::increment() {return ::InterlockedIncrement(&count_);}
template<> inline long ReferenceCounter<false>::decrement() {return --count_;}
template<> inline long ReferenceCounter<false>::increment() {return ++count_;}

/// QƃJEggȂ (q[vIuWFNg)
#define IMPLEMENT_UNKNOWN_NO_REF_COUNT()		\
	STDMETHODIMP_(ULONG) AddRef() {return 2;}	\
	STDMETHODIMP_(ULONG) Release() {return 1;}

/// QƃJEg̑XbhZ[tłȂ
#define IMPLEMENT_UNKNOWN_SINGLE_THREADED()	\
private:									\
	Armaiti::ReferenceCounter<false> rc_;	\
public:										\
	STDMETHODIMP_(ULONG) AddRef() {			\
		return rc_.increment();				\
	}										\
	STDMETHODIMP_(ULONG) Release() {		\
		if(rc_.decrement() == 0) {			\
			delete this;					\
			return 0;						\
		}									\
		return rc_.get();					\
	}

/// QƃJEg̑XbhZ[tȎ
#define IMPLEMENT_UNKNOWN_MULTI_THREADED()	\
private:									\
	Armaiti::ReferenceCounter<true>	rc_;	\
public:										\
	STDMETHODIMP_(ULONG) AddRef() {			\
		return rc_.increment();				\
	}										\
	STDMETHODIMP_(ULONG) Release() {		\
		if(rc_.decrement() == 0) {			\
			delete this;					\
			return 0;						\
		}									\
		return rc_.get();					\
	}

#define BEGIN_INTERFACE_TABLE()								\
	STDMETHODIMP QueryInterface(REFIID riid, void** ppv) {	\
		VERIFY_POINTER(ppv);

#define IMPLEMENTS_LEFTMOST_INTERFACE(InterfaceName)			\
		if(riid == IID_##InterfaceName || riid == IID_IUnknown)	\
			*ppv = static_cast<InterfaceName*>(this);

#define IMPLEMENTS_INTERFACE(InterfaceName)		\
		else if(riid == IID_##InterfaceName)	\
			*ppv= static_cast<InterfaceName*>(this);

#define END_INTERFACE_TABLE()							\
		else											\
			return (*ppv = 0), E_NOINTERFACE;			\
		reinterpret_cast<IUnknown*>(*ppv)->AddRef();	\
		return S_OK;									\
	}

} // namespace Armaiti

#endif /* UNKNOWN_IMPL_HPP_ */

/* [EOF] */