// Timer.hpp
// (c) 2003-2006 exeal

#ifndef TIMER_H_
#define TIMER_H_
#include "Object.hpp"

namespace Manah {
namespace Windows {

class Timer {
	// RXgN^
public:
	Timer(const TCHAR* name = 0) : name_((name != 0) ? new TCHAR[STD_::_tcslen(name) + 1] : 0) {
		if(name_ != 0)
			STD_::_tcscpy(name_, name);
		reset();
	}
	~Timer() throw() {
		Manah::Windows::DumpContext dc;
		if(name_ != 0)
			dc << name_;
		else
			dc << _T("(anonymous)");
		dc << _T(" : ") << read() << _T("ms\n");
		delete[] name_;
	}

	// \bh
public:
	DWORD read() const throw() {return ::GetTickCount() - count_;}
	void reset() throw() {count_ = ::GetTickCount();}

	// f[^o
private:
	TCHAR* name_;	// timer's name
	DWORD count_;
};

} /* namespace Windows */
} /* namespace Manah */

#endif	/* TIMER_HPP_ */

/* [EOF] */