// Alpha.h
// (c) 2003-2005 exeal

#ifndef _ALPHA_H_
#define _ALPHA_H_
#include "resource.h"
#include "BufferList.h"
#include "AlphaView.h"
//#include "Ambient.h"
//#include "OutputWnd.h"
//#include "OutlineParserDlg.h"
#include "KeyboardMap.h"
#include "ScriptMacroManager.h"
//#include "AlphaApplicationDebugger.h"
#include "../Manah/WinApp.h"
#include "../Manah/Menu.h"
#include "../Manah/Rebar.h"
#include "../Manah/Toolbar.h"
#include "../Manah/StatusBar.h"
#include "../Manah/Splitter.h"
#include <map>
#include <sstream>


// Literals
/////////////////////////////////////////////////////////////////////////////

#define IDS_DEFAULTSTATUSTEXT	L""
#define IDS_KEYMACROFILENAME	L"keymacro"
#define IDS_EVENTSCRIPTFILENAME	L"events.*"
#define IDS_MACRO_DIRECTORY_NAME			L"macros\\"
#define IDS_KEYBOARDSCHEME_DIRECTORY_NAME	L"keyboardSchemes\\"
#define IDS_ICON_DIRECTORY_NAME				L"icons\\"
#define IDS_BREAK_CR	L"CR (Macintosh)"
#define IDS_BREAK_LF	L"LF (Unix)"
#define IDS_BREAK_CRLF	L"CR+LF (Windows)"
#define IDS_BREAK_NEL	L"NEL (U+0085)"
#define IDS_BREAK_LS	L"LS (U+2028)"
#define IDS_BREAK_PS	L"PS (U+2029)"

// INI sections
#define INI_SECTION_SCRIPTENGINES	L"ScriptEngines"

// Timer ID
#define ID_TIMER_QUERYCOMMAND	1	// c[o[ACe̗L
#define ID_TIMER_MOUSEMOVE		2	// J[\~1bɔ (qg\ȂǂɎgp)

// message ID
#define MYWM_EVENTHANDLER	WM_APP + 1	// CXbhCxgnhXNvgĂяo
										// wParam => unused
										// lParam => std::pair<const OLECHAR*, DISPPARAMS*>*
										// lParam->first => Cxgnh
										// lParam->second => 
#define MYWM_ENDSCRIPTMACRO	WM_APP + 2	// }NXNvgIɑĂ
										// wParam, lParam => unused
#define MYWM_CALLOVERTHREAD	WM_APP + 3	// Cӂ̊֐Ăяo
										// wParam => unused
										// lParam => ߂lȂ̖֐


namespace Alpha {

class IAlphaContainer {};
typedef Manah::Windows::Controls::CSplitterRoot<IAlphaContainer>	Containers;

class _ICallable {
public:
	virtual ~_ICallable() {}
	virtual void Call() = 0;
};


// O錾
class CScriptManager;
class CEventHandlerScript;
class CCommandManager;
class CBuiltInCommand;
class CMRUManager;
class CFindDlg;
class CGotoLineDlg;
class CBookmarkDlg;
/*class CDebugBreakPointsDlg;
class CDebugCallStackDlg;
class CDebugImmediateDlg;
class CDebugRunningDocumentsDlg;
class CDebugThreadsDlg;
class CDebugVariablesDlg;*/

namespace Ambient {
	class CApplication;
	class CBuffers;
}


/// CAlphaApp::OpenFile ACAlphaApp::ReopenFile ̌
enum OpenFileResult {
	OPENFILERESULT_SUCCEEDED,		///< 
	OPENFILERESULT_FAILED,			///< s
	OPENFILERESULT_USERCANCELED,	///< [ULZ
};

///	s̑BCEditView::SetLineParam Ŏg
enum LineAttribute {
	LINEATTR_NONE					= 0x00,	///< ɂȂ
	LINEATTR_BREAKPOINT_ENABLED		= 0x01,	///< Lȃu[N|Cg
	LINEATTR_BREAKPOINT_DISABLED	= 0x02,	///< ȃu[N|Cg
	LINEATTR_BREAKPOINT_MASK		= 0x03,	///< SetLineParam p}XN
};

/// Xe[^Xo[̃yCBCAlphaApp::_UpdateStatusBar Ŏgp
typedef ushort	StatusBarPane;
const StatusBarPane
	SBP_MESSAGE			= 0x0001,	///< bZ[W
	SBP_POSITION		= 0x0002,	///< GfB^̃Lbgʒu
	SBP_DOCUMENTTYPE	= 0x0004,	///< ^Cv
	SBP_ENCODING		= 0x0008,	///< GR[fBO
	SBP_KEYBOARDMACRO	= 0x0010,	///< L[{[h}N (ACR)
	SBP_DEBUGMODE		= 0x0020,	///< fobO[h (ACR)
	SBP_OVERTYPEMODE	= 0x0040,	///< ㏑/}[h (Œ蕝)
	SBP_NARROWING		= 0x0080,	///< i[CO (ACR)
	SBP_DUMMY			= 0x0100,
	SBP_ALL				= 0xFFFF;	///< S


class CEditorWindow;	// O錾

/// eLXgGfB^̃yC
class CEditorPane : virtual public Manah::Windows::Controls::CAbstractPane {
	// RXgN^
public:
	CEditorPane(CAlphaView* pInitialView = 0);
	CEditorPane(const CEditorPane& rhs);
	~CEditorPane();
private:
	operator =(const CEditorPane& rhs);

	// \bh
public:
	// 
	HRESULT GetAutomation(IEditorPane** pp) const;
	/// r[̑Ԃ
	std::size_t GetCount() const {return m_views.size();}
	/// @see	CAbstractPane::GetWindow
	HWND GetWindow() const {return (m_pVisibleView != 0) ? m_pVisibleView->GetSafeHwnd() : 0;}
	/// \Ăr[ɑΉobt@Ԃ
	CAlphaDoc& GetVisibleBuffer() const {assert(m_pVisibleView != 0); return m_pVisibleView->GetDocument();}
	/// \Ăr[Ԃ
	CAlphaView& GetVisibleView() const {assert(m_pVisibleView != 0); return *m_pVisibleView;}

	// 
	void	AddView(CAlphaView& view);
	void	RemoveAll();
	void	RemoveBuffer(const CAlphaDoc& buffer);
	void	ShowBuffer(const CAlphaDoc& buffer);

	// f[^o
private:
	std::set<CAlphaView*>	m_views;
	CAlphaView*				m_pVisibleView;
	CAlphaView*				m_pLastVisibleView;
	IEditorPane*			m_pAutomation;
};


typedef Manah::Windows::Controls::CSplitterRoot<CEditorPane>	EditorWindow;


class CActiveViewListener {
public:
	virtual void OnActiveViewChanged(const CAlphaView& activeView) = 0;
};


/// Alpha ̃AvP[VNX
class CAlphaApp :
		public Manah::Windows::CWinApp,
		public Ascension::CEditViewEventAdapter,
		virtual public Ascension::IEditDocEventListener,
		virtual public Ascension::CClipboardRing::IEventListener,
		virtual public Ascension::CIncrementalSearcher::IEventListener,
		virtual public CActiveViewListener/*,
		virtual public IAlphaApplicationDebuggerEventListener*/ {
	friend class CAlphaApplication;
	friend class CCommandManager;
	friend class CBuiltInCommand;
	friend class CAlphaView;

	// RXgN^
public:
	CAlphaApp();
	virtual ~CAlphaApp();

	// \bh
public:
	void					CallFunctionOnGuiThread(_ICallable& func);
	CAlphaView&				GetActiveView() const;
	HRESULT					GetAutomation(
								Alpha::Ambient::CApplication** ppApplication,
								Alpha::Ambient::CBuffers** ppBuffers) const;
	static const wchar_t*	GetCodePageName(Ascension::Encodings::CodePage cp);
	const CCommandManager&	GetCommandManager() const;
	EditorWindow&			GetEditorPane() const;
	CKeyboardMap&			GetKeyboardMap() const;
	static CAlphaApp&		GetInstance();
	void					GetScriptLanguageByFileName(const wchar_t* pwszFileName, CLSID& clsid) const;
	CScriptManager&			GetScriptManager() const;
	bool					InitApplication(HINSTANCE hInstance);
	bool					InitInstance(int nCmdShow);
	void					LoadKeyBinds(const std::wstring& strSchemeName);
	int						MessageBox(DWORD wID, UINT nType,
								Manah::Windows::CMessageArguments& args = Manah::Windows::CMessageArguments());
	void					ParseCommandLine(const std::vector<std::wstring>& args);
	void					SetFont(const LOGFONTW& lf);

	// obt@
	void				ApplyDocumentType(std::size_t iBuffer,
							const std::wstring& strTypeName = L"") throw(std::out_of_range);
	bool				CloseBuffer(std::size_t iBuffer, bool bQueryUser) throw(std::out_of_range);
	bool				CloseAllBuffers(bool bQueryUser, bool bExceptActive = false);
	CAlphaDoc&			GetActiveBuffer() const;
	std::size_t			GetActiveBufferIndex() const;
	CBufferList&		GetBufferList() const;
	static std::wstring	GetBufferName(const CAlphaDoc& buffer);
	void				NewBuffer(Ascension::Encodings::CodePage cp = Ascension::Encodings::CPEX_AUTODETECT_USERLANG,
							Ascension::LineBreak lineBreak = Ascension::LB_AUTO, const std::wstring& strDocType = L"");
	void				NewBufferWithFormat();
	OpenFileResult		OpenFile();
	OpenFileResult		OpenFile(const std::wstring& strPathName,
							Ascension::Encodings::CodePage cp = Ascension::Encodings::CPEX_AUTODETECT_USERLANG,
							bool bAsReadOnly = false, bool bAddToMRU = true);
	void				OperateActiveFile(UINT id);
	OpenFileResult		ReopenFile(std::size_t iBuffer, bool bChangeCodePage) throw(std::out_of_range);
	bool				SaveAllBuffers();
	bool				SaveBuffer(std::size_t iBuffer) throw(std::out_of_range);
	bool				SaveBufferWithName(std::size_t iBuffer) throw(std::out_of_range);
	void				SetActiveBuffer(CAlphaDoc& buffer, std::size_t iPane = -1) throw(std::out_of_range);
	void				SetActiveBuffer(std::size_t iBuffer, std::size_t iPane = -1) throw(std::out_of_range);

	// 
	void	ReplaceAll();
	void	ReplaceAndSearchNext();
	void	SearchAndBookmarkAll();
	void	SearchNext(bool bForward, bool bMessageOnFailure);
	void	ShowSearchDialog();

	// IEditViewEventListener C^[tFCX
	void	OnChangedAbbreviationExpansionReadyState(bool bReady, const Ascension::string_t& strAbbrev);
	void	OnInvokeUriLink(const Ascension::char_t* pwszUri);
	void	OnMatchBracketFoundOutOfView(const Ascension::CCharPos& pos);
	void	OnMoveCaret(const Ascension::CCharPos& pos);
	void	OnMoveCursor(const POINT& pt);

	// IEditDocEventListener C^[tFCX
	void	OnDocumentLoaded();
	void	OnDocumentModified();
	void	OnDocumentOverwrittenByOtherProcess(Ascension::CEditDoc& document);

	// CClipboardRing::IEventListener C^[tFCX
	void	OnClipboardRingChanged();
	void	OnClipboardRingDeniedAdding();

	// CIncrementalSearcher::IEventLisetner C^[tFCX
	void	OnISearchAborted();
	void	OnISearchCompleted();
	void	OnISearchPatternChanged(const Ascension::SearchResult& result);
	void	OnISearchStarted();

	// CActiveViewListener C^[tFCX
	void	OnActiveViewChanged(const CAlphaView& activeView);
/*
	// IAlphaApplicationDebuggerEventListener C^[tFCX
	void	OnDebugStart();
	void	OnDebugEnd();
	void	OnDebugStopAtBreakPoint(unsigned long iLine);
	void	OnDebugStopByError(unsigned long iLine);
	void	OnDebugStepTo(unsigned long iLine);
	void	OnDebugIllegalStatus(DebugStatus ds);
*/
private:
	void			_ChangeFont();
	const wchar_t*	_GetMenuLabel(CommandId id) const;
	void			_GetProfileList(const wchar_t* pwszSectionName, const wchar_t* pwszKeyName,
						std::list<std::wstring>& items, const wchar_t* pwszDefault = 0);
	void			_GetProfileSet(const wchar_t* pwszSectionName, const wchar_t* pwszKeyName,
						std::set<std::wstring>& items, const wchar_t* pwszDefault = 0);
	bool			_HandleFileIoError(bool bLoad, Ascension::CEditDoc::FileIoResult result);
	bool			_HandleKeyDown(VirtualKey key, KeyModifier modifiers);
	void			_LoadINISettings();
	void			_ReloadScriptMacros();
	void			_ResetBufferBarIcons();
	void			_SaveINISettings();
	void			_SetupMenus();
	void			_SetupToolbar();
	void			_UpdateStatusBar(StatusBarPane panes);
	void			_UpdateTitleBar();
protected:
	LRESULT	DispatchEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	bool	PreTranslateMessage(const MSG& msg);

	// bZ[Wnh
protected:
	void	OnToolExecute();
	void	OnToolExecuteCommand();
	void	OnToolDebugStart();
	void	OnToolDebugInsertBreakPoint();
	void	OnToolDebugBreakPoints();
	void	OnToolDebugCallStack();
	void	OnToolDebugImmediate();
	void	OnToolDebugVariables();
	void	OnToolDebugThreads();

protected:
	bool	OnClose();																		// WM_CLOSE
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);							// WM_COMMAND
	void	OnCopyData(HWND hWnd, PCOPYDATASTRUCT pcds);									// WM_COPYDATA
	void	OnDestroy();																	// WM_DESTROY
	void	OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem);							// WM_DRAWITEM
	void	OnDropFiles(HDROP hDrop);														// WM_DROPFILES
	void	OnEnterMenuLoop(bool bIsTrackPopup);											// WM_ENTERMENULOOP
	void	OnExitMenuLoop(bool bIsTrackPopup);												// WM_EXITMENULOOP
	void	OnInitMenu(HMENU hMenu);														// WM_INITMENU
	void	OnInitMenuPopup(HMENU hMenu, UINT nIndex, bool bSysMenu);						// WM_INITMENUPOPUP
	void	OnMeasureItem(UINT idCtrl, LPMEASUREITEMSTRUCT lpMI);							// WM_MEASUREITEM
	LRESULT	OnMenuChar(wchar_t ch, UINT nFlags, Manah::Windows::Controls::CMenu* pMenu);	// WM_MENUCHAR
	void	OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu);						// WM_MENUSELECT
	void	OnMouseMove(UINT nFlags, POINT pt);												// WM_MOUSEMOVE
	bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);											// WM_NOTIFY
	bool	OnSetCursor(HWND hWnd, UINT nHitTest, UINT message);							// WM_SETCURSOR
	void	OnSettingChange(UINT nFlags, const wchar_t* pwszSection);						// WM_SETTINGCHANGE
	void	OnSize(UINT nType, int cx, int cy);												// WM_SIZE
	void	OnTimer(UINT nIDTimer);															// WM_TIMER

protected:
	void	OnRebarChevronPushed(LPNMREBARCHEVRON lpNMRebarChevron);	// RBN_CHEVRONPUSHED

	// hLgAr[̕ύXĎ
protected:
	static void OnUpdateDocument();

protected:
	/* EBhEvVW */
	static LRESULT CALLBACK AppWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	// f[^o
protected:
	/* CX^X */
	static CAlphaApp*	m_pInstance;	// 1̃CX^X

private:
	/* EBhE */
	EditorWindow							m_editorWindow;		// GfB^EBhE
	Manah::Windows::Controls::CMenu*		m_pMenu;			// Cj[
	Manah::Windows::Controls::CMenu*		m_pFileOpeMenu;		// [t@C] |bvAbvj[
	Manah::Windows::Controls::CMenu*		m_pNewDocTypeMenu;	// VKhLg^Cv|bvAbvj[
	Manah::Windows::Controls::CMenu*		m_pAppDocTypeMenu;	// KphLg^Cv|bvAbvj[
	Manah::Windows::Controls::CMenu*		m_pBufferBarMenu;	// obt@o[̃|bvAbvj[
	Manah::Windows::Controls::CRebar		m_rebar;			// o[
	Manah::Windows::Controls::CToolbar		m_toolbar;			// Wc[o[
	Manah::Windows::Controls::CToolbar		m_bufferBar;		// obt@o[
	Manah::Windows::Controls::CStatusBar	m_statusBar;		// Xe[^Xo[
//	COutputWnd								m_wndOutput;		// [o] EBhE
	CFindDlg*								m_pdlgSearch;		// [ƒu]_CAO
	CGotoLineDlg*							m_pdlgGotoLine;		// [wsֈړ]_CAO
	CBookmarkDlg*							m_pdlgBookmark;		// [ubN}[N]_CAO
//	COutlineParserDlg						m_dlgOutline;		// [AEgC]_CAO
	int										m_nOutputWndHeight;	// o̓EBhE̍
	bool									m_bSizingOutputWnd;	// o̓EBhE̍ύX

	/* GDI IuWFNg */
	HFONT	m_hCommonFont;		// GfB^̃tHg
	HFONT	m_hStatusFont;		// Xe[^Xo[̃tHg
	HICON	m_hNarrowingIcon;

	/* @\ƃR}h */
	CScriptManager*				m_pScriptManager;
	CEventHandlerScript*		m_pEventHandlerScript;	// events.* s錾GW
//	CAlphaApplicationDebugger*	m_pActiveDebugger;		// ANeBuȃfobK
//	CAlphaEditController*		m_pDebuggingEditor;		// fobÕGfB^
	CCommandManager*			m_pCommandManager;		// R}h̊Ǘ
	CKeyboardMap				m_keyboardMap;			// gp̃L[{[h}bv
	CMRUManager*				m_pMRUManager;			// MRU Xg̊Ǘ
	CBufferList					m_buffers;				// obt@Xg̊Ǘ
	CScriptMacroManager*		m_pScriptMacroManager;	// XNvg}N̊Ǘ
	VirtualKey					m_2Stroke1stKey;		// ͒2Xg[NV[PX1Xg[Nڂ̃L[
	KeyModifier					m_2Stroke1stModifiers;	// ͒2Xg[NV[PX1Xg[Nڂ̏CL[
	std::wstring				m_strReadOnlySignature;	// ǂݎpobt@\

	/* fobO_CAO */
/*	CDebugBreakPointsDlg*		m_pdlgDebugBreakPoints;			// [u[N|Cg] _CAO
	CDebugCallStackDlg*			m_pdlgDebugCallStack;			// [Ăяo] _CAO
	CDebugImmediateDlg*			m_pdlgDebugImmediate;			// [C~fBGCg] _CAO
	CDebugRunningDocumentsDlg*	m_pdlgDebugRunningDocuments;	// [s̃hLg] _CAO
	CDebugThreadsDlg*			m_pdlgDebugThreads;				// [Xbh] _CAO
	CDebugVariablesDlg*			m_pdlgDebugVariables;			// [ϐ] _CAO
*/
	/* I[g[VpC^[tFCX */
	Alpha::Ambient::CApplication*	m_pApplication;
	Alpha::Ambient::CBuffers*		m_pBuffers;

	/* IvV */
	bool	m_bUseShortKeyNames;				// Z`̃L[̖Og
	bool	m_bShowMessageBoxOnFind;			// ŃbZ[W{bNX\
	bool	m_bInitializeFindTextFromEditor;	// [ƒu] _CAOJƂ
												// eLXgGfB^珉
};


/// GUI XbhŔCӂ̊֐Ăяo
inline void CAlphaApp::CallFunctionOnGuiThread(_ICallable& function) {
	m_pMainWindow->SendMessage(MYWM_CALLOVERTHREAD, 0, reinterpret_cast<LPARAM>(&function));
}

/// ANeBuȃobt@Ԃ
inline CAlphaDoc& CAlphaApp::GetActiveBuffer() const {
	return m_editorWindow.GetActivePane().GetVisibleBuffer();
}

/// ANeBuȃobt@̃CfNXԂ
inline std::size_t CAlphaApp::GetActiveBufferIndex() const {
	CAlphaDoc*	pDocument = &GetActiveBuffer();
	for(std::size_t i = 0; i < m_buffers.GetCount(); ++i) {
		if(&m_buffers.GetAt(i) == pDocument)
			return i;
	}
	assert(false);
	return -1;	// Ӗ
}

/// ANeBuȃGfB^̃r[Ԃ
inline CAlphaView& CAlphaApp::GetActiveView() const {
	return GetEditorPane().GetActivePane().GetVisibleView();
}

/// obt@o[^Cgo[Ɏgobt@̖OԂ
inline std::wstring CAlphaApp::GetBufferName(const CAlphaDoc& buffer) {
	const std::wstring	str = buffer.GetFileName();
	if(buffer.IsModified())
		return buffer.IsReadOnly() ? str + L" * " + GetInstance().m_strReadOnlySignature : str + L" *";
	else
		return buffer.IsReadOnly() ? str + L" " + GetInstance().m_strReadOnlySignature : str;
}

///	obt@XgԂ
inline CBufferList& CAlphaApp::GetBufferList() const {
	return const_cast<CAlphaApp*>(this)->m_buffers;
}

///	R}hǗIuWFNgԂ
inline const CCommandManager& CAlphaApp::GetCommandManager() const {
	AssertValid();
	return *m_pCommandManager;
}

/// GfB^yCԂ
inline EditorWindow& CAlphaApp::GetEditorPane() const {
	AssertValid();
	return const_cast<CAlphaApp*>(this)->m_editorWindow;
}

///	B̃AvP[VIuWFNgԂ
inline CAlphaApp& CAlphaApp::GetInstance() {
	assert(CAlphaApp::m_pInstance != 0);
	return *CAlphaApp::m_pInstance;
}

///	L[蓖ăIuWFNgԂ
inline CKeyboardMap& CAlphaApp::GetKeyboardMap() const {
	AssertValid();
	return const_cast<CAlphaApp*>(this)->m_keyboardMap;
}

/**
 *	INI 當񃊃Xgǂݍ
 *	@param pwszSectionName	ZNV
 *	@param pwszKeyName		L[
 *	@param items			[out] Xg
 *	@param pwszDefault		[in] ݒ肪ȂƂɎgp镶
 */
inline void CAlphaApp::_GetProfileList(const wchar_t* pwszSectionName,
		const wchar_t* pwszKeyName, std::list<std::wstring>& items, const wchar_t* pwszDefault /* = 0 */) {
	const std::wstring	strList = GetProfileString(pwszSectionName, pwszKeyName, pwszDefault);
	std::wstring		strItem;

	items.clear();
	if(strList.empty())
		return;
	std::wistringstream	ss(strList);
	while(ss >> strItem)
		items.push_back(strItem);
}


/**
 *	INI 當̏Wǂݍ
 *	@param pwszSectionName	ZNV
 *	@param pwszKeyName		L[
 *	@param items			[out] W
 *	@param pwszDefault		[in] ݒ肪ȂƂɎgp镶
 */
inline void	CAlphaApp::_GetProfileSet(const wchar_t* pwszSectionName,
		const wchar_t* pwszKeyName, std::set<std::wstring>& items, const wchar_t* pwszDefault /* = 0 */) {
	std::wstring	strList = GetProfileString(pwszSectionName, pwszKeyName, pwszDefault);
	std::wstring	strItem;

	items.clear();
	if(strList.empty())
		return;
	std::wistringstream	ss(strList);
	while(ss >> strItem)
		items.insert(strItem);
}

} /* namespace Alpha */

#endif /* _ALPHA_H_ */

/* [EOF] */