// AlphaView.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "AlphaView.h"
#include "Alpha.h"
#include "Ambient.h"
#include "resource.h"
using Alpha::CAlphaView;
using Alpha::CAlphaDoc;
using namespace Ascension;


// CAlphaView class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CAlphaView::CAlphaView(CAlphaDoc& document, Alpha::CActiveViewListener& app) :
		CEditView(document), m_app(app),
		m_pAutomationTextEditor(0), m_pAutomationTextSelection(0), m_pAutomationLexer(0), m_pAutomationPrefs(0) {
}

/// Rs[RXgN^
CAlphaView::CAlphaView(const CAlphaView& rhs) : CEditView(rhs), m_app(rhs.m_app),
		m_pAutomationTextEditor(0), m_pAutomationTextSelection(0), m_pAutomationLexer(0), m_pAutomationPrefs(0) {
}

/// fXgN^
CAlphaView::~CAlphaView() {
	if(m_pAutomationTextEditor != 0) {
		m_pAutomationTextEditor->Dispose();
		m_pAutomationTextEditor->Release();
	}
	if(m_pAutomationTextSelection != 0) {
		m_pAutomationTextSelection->Dispose();
		m_pAutomationTextSelection->Release();
	}
	if(m_pAutomationLexer != 0) {
		m_pAutomationLexer->Dispose();
		m_pAutomationLexer->Release();
	}
	if(m_pAutomationPrefs != 0) {
		m_pAutomationPrefs->Dispose();
		m_pAutomationPrefs->Release();
	}
}

/// ITextEditor I[g[VIuWFNgԂ
HRESULT CAlphaView::GetAutomation(ITextEditor** pp) const {
	VERIFY_POINTER(pp);
	CAlphaView*	pThis = const_cast<CAlphaView*>(this);
	if(pThis->m_pAutomationTextEditor == 0) {
		if(pThis->m_pAutomationTextEditor = new Ambient::CTextEditor(CAlphaApp::GetInstance(), *pThis))
			pThis->m_pAutomationTextEditor->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(*pp = m_pAutomationTextEditor)->AddRef();
	return S_OK;
}

/// ITextSelection I[g[VIuWFNgԂ
HRESULT CAlphaView::GetAutomation(ITextSelection** pp) const {
	VERIFY_POINTER(pp);
	CAlphaView*	pThis = const_cast<CAlphaView*>(this);
	if(pThis->m_pAutomationTextSelection == 0) {
		if(pThis->m_pAutomationTextSelection = new Ambient::CTextSelection(*pThis))
			pThis->m_pAutomationTextSelection->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(*pp = pThis->m_pAutomationTextSelection)->AddRef();
	return S_OK;
}

/// ILexer I[g[VIuWFNgԂ
HRESULT CAlphaView::GetAutomation(ILexer** pp) const {
	VERIFY_POINTER(pp);
	CAlphaView*	pThis = const_cast<CAlphaView*>(this);
	if(pThis->m_pAutomationLexer == 0) {
		if(pThis->m_pAutomationLexer = new Ambient::CLexer(pThis->GetLexer()))
			pThis->m_pAutomationLexer->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(*pp = pThis->m_pAutomationLexer)->AddRef();
	return S_OK;
}

/// IEditorPreferences I[g[VIuWFNgԂ
HRESULT CAlphaView::GetAutomation(IEditorPreferences** pp) const {
	VERIFY_POINTER(pp);
	CAlphaView*	pThis = const_cast<CAlphaView*>(this);
	if(pThis->m_pAutomationPrefs == 0) {
		if(pThis->m_pAutomationPrefs = new Ambient::CEditorPreferences(*pThis))
			pThis->m_pAutomationPrefs->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(*pp = pThis->m_pAutomationPrefs)->AddRef();
	return S_OK;
}

///	݈ʒu\Ԃ
const wchar_t* CAlphaView::GetCurrentPositionString() const {
	AssertValid();

	static wchar_t	wszFormat[100] = {0};

	if(wszFormat[0] == 0)
		::LoadStringW(::GetModuleHandle(0), MSG_CARET_POSITION, wszFormat, _countof(wszFormat));

	static wchar_t			wsz[100];
	AutoZeroCB<SCROLLINFO>	si;

	GetScrollInfo(SB_VERT, si, SIF_POS | SIF_RANGE);
	swprintf(wsz, wszFormat,
		GetSelection().GetActivePoint().GetLineNumber()
			+ GetLayoutSettings().GetSettings().lineNumberLayout.iStartLine,
		ColumnFromChar(GetSelection().GetActivePoint()) + GetLayoutSettings().GetSettings().iStartChar,
		GetSelection().GetActivePoint().GetCharNumber() + GetLayoutSettings().GetSettings().iStartChar);
	return wsz;
}

///	@see	CEditView::GetDocument
CAlphaDoc& CAlphaView::GetDocument() const {
	AssertValid();
	return reinterpret_cast<CAlphaDoc&>(CEditView::GetDocument());
}

/// @see	CEditView::InputCharacter
bool CAlphaView::InputCharacter(CodePoint cp) {
	AssertValid();
	if(CEditView::InputCharacter(cp)) {
		return true;
	}
	return false;
}

/// @see	CEditView::InsertText
bool CAlphaView::InsertText(const string_t& text, bool bAsRectangle) {
	AssertValid();
	if(CEditView::InsertText(text, bAsRectangle)) {
		return true;
	}
	return false;
}

/// @see	CEditView::QueryInvokableLinkMessage
string_t CAlphaView::QueryInvokableLinkMessage(const string_t& strUri) {
	return CAlphaApp::GetInstance().LoadString(MSG_INVOKABLE_LINK_POPUP, __MARGS__ % strUri);
}

/// @see	CEditView::QueryLineColors
void CAlphaView::QueryLineColors(length_t iLine, COLORREF& fgColor, COLORREF& bgColor) {
	AssertValid();
	bgColor = GetBookmarker().IsBookmarked(iLine) ? RGB(0xF0, 0xF6, 0xFF) : -1;
}

///	@see	CWindow::OnKeyDown
bool CAlphaView::OnKeyDown(UINT nChar, UINT nFlags) {
	return true;
}

/// @see	CWindow::OnSetFocus
void CAlphaView::OnSetFocus(HWND hwndOld) {
	m_app.OnActiveViewChanged(*this);
	CEditView::OnSetFocus(hwndOld);
}

/* [EOF] */