// Ambient.h
// (c) 2003-2005 exeal

#ifndef _AMBIENT_H_
#define _AMBIENT_H_

#include "AmbientIdl.h"	// generated from AmbientIdl.idl
#include "Alpha.h"
#include "KeyboardMap.h"
#include "../Armaiti/DispatchImpl.h"
//#include <dispex.h>

#pragma warning(disable : 4250)	// u2 ȏ̃oOĂ܂B...v

#ifndef __dispex_h__
DEFINE_GUID(IID_IObjectIdentity, 0xCA04B7E6, 0x0D21, 0x11D1, 0x8C, 0xC5, 0x00, 0xC0, 0x4F, 0xC2, 0xB0, 0x85);
interface IObjectIdentity : public IUnknown {	// IID is CA04B7E6-0D21-11d1-8CC5-00C04FC2B085
public:
	virtual HRESULT STDMETHODCALLTYPE IsEqualObject(/* [in] */ IUnknown* punk) = 0;
};
#endif /* !__dispex_h__ */

interface IActiveScript;


namespace Ascension {
	class CClipboardRing;
}

namespace Alpha {

class CAlphaApp;
class CAlphaDoc;
class CAlphaView;
class CAlphaScriptHost;
class CEnumImpl;


namespace Ambient {
	class CEditorPane;

	/// ^CvCũpXێ
	class CAmbientTypeLibPath {
	public:
		static const OLECHAR*	GetPath() {
			return OLESTR("Alpha.tlb");
		}
	};

#define AmbientObjectBase(Interface)													\
	public Armaiti::OLE::IDispatchImpl<Interface,										\
		Armaiti::OLE::CPathTypeLibTypeInfoHolder<CAmbientTypeLibPath, &IID_##Interface>	\
	>,																					\
	public Armaiti::IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>

	/// bpIuWFNg̎IɎǗł
	template<class Implementation>
	class CDisposable {
	public:
		CDisposable() : m_bDisposed(false) {}
	protected:
		bool IsDisposed() const {return m_bDisposed;}
	private:
		void Dispose() {m_bDisposed = true;}
	private:
		bool m_bDisposed;
		friend Implementation;
	};

#define AmbientObjectBaseSupportError(Interface)	\
	AmbientObjectBase(Interface),					\
	public Armaiti::ISupportErrorInfoImpl<&IID_##Interface>

#define AmbientObjectBaseSupportIdentity(Interface)	\
	AmbientObjectBase(Interface), virtual public IObjectIdentity


	/// IApplication ̎
	class CApplication : AmbientObjectBaseSupportError(IApplication)/*,
			public Armaiti::IProvideClassInfo2Impl<&CLSID_Application, &IID_IApplication, &LIBID_Alpha>*/ {
		friend class CAlphaDoc;
		friend class CAlphaView;
		friend class CAlphaApp;

		// RXgN^
	private:
		CApplication(CAlphaApp& app, const std::vector<std::wstring>* pArguments = 0);
	public:
		~CApplication();

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IApplication)
//			IMPLEMENTS_INTERFACE(IDispatchEx)
			IMPLEMENTS_INTERFACE(IDispatch)
			IMPLEMENTS_INTERFACE(ISupportErrorInfo)
//			IMPLEMENTS_INTERFACE(IProvideClassInfo2)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IApplication C^[tFCX
		STDMETHODIMP	get_Abbreviations(IAbbreviations** ppAbbreviations);
		STDMETHODIMP	get_Active(VARIANT_BOOL* pbActive);
		STDMETHODIMP	put_Active(VARIANT_BOOL bActive);
		STDMETHODIMP	get_ActiveBuffer(IBuffer** ppActiveBuffer);
		STDMETHODIMP	get_Buffers(IBuffers** ppBuffers);
		STDMETHODIMP	get_Configurations(IConfigurations** ppConfigurations);
		STDMETHODIMP	get_CurrentDirectory(BSTR* pbstrDirectory);
		STDMETHODIMP	put_CurrentDirectory(BSTR bstrDirectory);
		STDMETHODIMP	get_EditorPanes(IEditorPanes** ppPanes);
//		STDMETHODIMP	get_Debugger(IDebugger** ppDebugger);
		STDMETHODIMP	get_FullName(BSTR* pbstrFullName);
		STDMETHODIMP	get_Height(long* pnHeight);
		STDMETHODIMP	put_Height(long nHeight);
		STDMETHODIMP	get_Interactive(VARIANT_BOOL* pbInteractive);
		STDMETHODIMP	put_Interactive(VARIANT_BOOL bInteractive);
		STDMETHODIMP	get_Left(long* pnLeft);
		STDMETHODIMP	put_Left(long nLeft);
		STDMETHODIMP	get_KeyboardScheme(IKeyboardScheme** ppKeyboardScheme);
		STDMETHODIMP	get_Name(BSTR* pbstrName);
		STDMETHODIMP	get_Top(long* pnTop);
		STDMETHODIMP	put_Top(long nTop);
		STDMETHODIMP	get_Version(BSTR* pbstrVersion);
		STDMETHODIMP	get_Visible(VARIANT_BOOL* pbVisible);
		STDMETHODIMP	put_Visible(VARIANT_BOOL bVisible);
		STDMETHODIMP	get_Width(long* pnWidth);
		STDMETHODIMP	put_Width(long nWidth);
		STDMETHODIMP	get_WindowState(WindowState* pWindowState);
		STDMETHODIMP	put_WindowState(WindowState windowState);
		STDMETHODIMP	ClearOutput();
		STDMETHODIMP	GetCommandById(long nCommandId, ICommand** ppCommand);
		STDMETHODIMP	Quit(short nErrorCode = 0);
		STDMETHODIMP	WriteToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate);
		STDMETHODIMP	WriteLineToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate);

	private:
		void	_CallHook(DISPID idHook, const DISPPARAMS* pArguments);

		// f[^o
	private:
		CAlphaApp&	m_app;
	};


	/// IBuffers ̎
	class CBuffers : AmbientObjectBase(IBuffers) {
		// RXgN^
	public:
		CBuffers(CAlphaApp& app);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IBuffers)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IDocuments C^[tFCX
		STDMETHODIMP	get__NewEnum(IUnknown** ppEnum);
		STDMETHODIMP	get_Count(long* pnCount);
		STDMETHODIMP	AddNew(IBuffer** ppNewBuffer);
		STDMETHODIMP	CloseAll();
		STDMETHODIMP	Item(long index, IBuffer** ppBuffer);
		STDMETHODIMP	Open(BSTR bstrPathName, FileShareMode fileShareMode,
							long nCodePage, VARIANT_BOOL bAddToMRU, IBuffer** ppNewBuffer);
		STDMETHODIMP	SaveAll();

		// f[^o
	private:
		CAlphaApp&	m_app;
	};


	/// IBuffer ̎
	class CBuffer : AmbientObjectBase(IBuffer), public CDisposable<CAlphaDoc> {
		// RXgN^
	public:
		CBuffer(CAlphaApp& app, CAlphaDoc& document);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IBuffer)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IBuffer C^[tFCX
		STDMETHODIMP	get_Active(VARIANT_BOOL* pbActive);
		STDMETHODIMP	get_CodePage(long* pnCodePage);
		STDMETHODIMP	put_CodePage(long nCodePage);
		STDMETHODIMP	get_Editor(ITextEditor** ppEditor);
		STDMETHODIMP	get_EndPoint(ITextPoint** ppEndPoint);
		STDMETHODIMP	get_FileName(BSTR* pbstrFileName);
		STDMETHODIMP	get_FilePath(BSTR* pbstrFilePath);
		STDMETHODIMP	get_Line(long iLine, BSTR* pbstrLine);
		STDMETHODIMP	get_LineBreak(LineBreak* pLineBreak);
		STDMETHODIMP	put_LineBreak(LineBreak lineBreak);
		STDMETHODIMP	get_LineCount(long* pcLines);
		STDMETHODIMP	get_Modified(VARIANT_BOOL* pbModified);
		STDMETHODIMP	put_Modified(VARIANT_BOOL bModified);
		STDMETHODIMP	get_ReadOnly(VARIANT_BOOL* pbReadOnly);
		STDMETHODIMP	put_ReadOnly(VARIANT_BOOL bReadOnly);
		STDMETHODIMP	get_StartPoint(ITextPoint** ppStartPoint);
		STDMETHODIMP	Activate();
		STDMETHODIMP	Close();
		STDMETHODIMP	IsNarrowed(VARIANT_BOOL* pbNarrowed);
		STDMETHODIMP	Narrow(long iStartLine, long iStartChar, long iEndLine, long iEndChar);
		STDMETHODIMP	Save(BSTR bstrFileName, LineBreak lineBreak = Auto, long nCodePage = 0);
		STDMETHODIMP	Widen();

	private:
		std::size_t	_FindBuffer() const;

		// f[^o
	private:
		friend class CEditorPane;
		CAlphaApp&	m_app;
		CAlphaDoc&	m_buffer;
	};


	/// IEditorPanes ̎
	class CEditorPanes : AmbientObjectBase(IEditorPanes) {
		// RXgN^
	public:
		CEditorPanes(EditorWindow& impl);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEditorPanes)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IEditorPanes C^[tFCX
		STDMETHODIMP	get__NewEnum(IUnknown** ppEnum);
		STDMETHODIMP	get_ActivePane(IEditorPane** ppActivePane);
		STDMETHODIMP	get_Count(long* pnCount);
		STDMETHODIMP	ActivateNext();
		STDMETHODIMP	ActivatePrev();
		STDMETHODIMP	Item(long index, IEditorPane** ppPane);
		STDMETHODIMP	UnsplitAll();

		// f[^o
	private:
		EditorWindow&	m_impl;
	};


	/// IEditorPane ̎
	class CEditorPane : AmbientObjectBase(IEditorPane), public CDisposable<Alpha::CEditorPane> {
		// RXgN^
	private:
		CEditorPane(EditorWindow& parent, Alpha::CEditorPane& pane);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEditorPane)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IEditorPane C^[tFCX
		STDMETHODIMP	get_Active(VARIANT_BOOL* pbActive);
		STDMETHODIMP	get_Buffer(IBuffer** ppBuffer);
		STDMETHODIMP	put_Buffer(IBuffer* pBuffer);
		STDMETHODIMP	get_Editor(ITextEditor** ppEditor);
		STDMETHODIMP	get_Height(long* pnHeight);
		STDMETHODIMP	put_Height(long nHeight);
		STDMETHODIMP	get_Width(long* pnWidth);
		STDMETHODIMP	put_Width(long nWidth);
		STDMETHODIMP	Activate();
		STDMETHODIMP	Close();
		STDMETHODIMP	Split(VARIANT_BOOL bNs);

		// f[^o
	private:
		friend class Alpha::CEditorPane;
		EditorWindow&		m_parent;
		Alpha::CEditorPane&	m_pane;
	};


	/// ITextEditor ̎
	class CTextEditor : AmbientObjectBase(ITextEditor), public CDisposable<CAlphaView> {
		// RXgN^
	private:
		CTextEditor(CAlphaApp& app, CAlphaView& view);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ITextEditor)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// ITextEditor C^[tFCX
		STDMETHODIMP	get_Buffer(IBuffer** ppBuffer);
		STDMETHODIMP	get_ClipboardRing(IClipboardRing** ppClipboardRing);
		STDMETHODIMP	get_CollectingEdit(VARIANT_BOOL* pbCollecting);
		STDMETHODIMP	get_Lexer(ILexer** ppLexer);
		STDMETHODIMP	get_OvertypeMode(VARIANT_BOOL* pbOvertypeMode);
		STDMETHODIMP	put_OvertypeMode(VARIANT_BOOL bOvertypeMode);
		STDMETHODIMP	get_Preferences(IEditorPreferences** ppPreferences);
		STDMETHODIMP	get_Selection(ITextSelection** ppSelection);
		STDMETHODIMP	BackSpace();
		STDMETHODIMP	BeginEditCollection();
		STDMETHODIMP	BookmarkAll(BSTR bstrPattern, ISearchOptions* pOptions = 0, long* pnCount = 0);
		STDMETHODIMP	ClearAllBookmarks();
		STDMETHODIMP	ClearUndoBuffer();
		STDMETHODIMP	CreateEditPoint(ITextPoint* pTextPoint, IEditPoint** ppEditPoint);
		STDMETHODIMP	CreateSearchOptions(ISearchOptions** ppOptions);
		STDMETHODIMP	Delete();
		STDMETHODIMP	EndEditCollection();
		STDMETHODIMP	FindNext(BSTR bstrPattern, ISearchOptions* pOptions = 0, VARIANT_BOOL* pbFound = 0);
		STDMETHODIMP	FindPrev(BSTR bstrPattern, ISearchOptions* pOptions = 0, VARIANT_BOOL* pbFound = 0);
		STDMETHODIMP	Freeze();
		STDMETHODIMP	InputChar(VARIANT ch, VARIANT_BOOL* pbSucceeded);
		STDMETHODIMP	NewLine();
		STDMETHODIMP	Paste();
		STDMETHODIMP	PasteFromClipboardRing();
		STDMETHODIMP	Redo();
		STDMETHODIMP	ReplaceAll(BSTR bstrFindWhat,
							BSTR bstrReplaceWith = 0, ISearchOptions* pOptions = 0, long* pnCount = 0);
		STDMETHODIMP	ReplaceAndNext(BSTR bstrFindWhat,
							BSTR bstrReplaceWith = 0, ISearchOptions* pOptions = 0, VARIANT_BOOL* pbFound = 0);
		STDMETHODIMP	ReplaceAndPrev(BSTR bstrFindWhat,
							BSTR bstrReplaceWith = 0, ISearchOptions* pOptions = 0, VARIANT_BOOL* pbFound = 0);
		STDMETHODIMP	Undo();
		STDMETHODIMP	Unfreeze();

		// f[^o
	private:
		friend class CAlphaView;
		CAlphaApp&	m_app;
		CAlphaView&	m_view;
	};


	/// ITextSelection ̎
	class CTextSelection : AmbientObjectBase(ITextSelection), public CDisposable<CAlphaView> {
		// RXgN^
	public:
		CTextSelection(CAlphaView& view);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ITextSelection)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// ITextSelection C^[tFCX
		STDMETHODIMP	get_ActiveEndGreater(VARIANT_BOOL* pbActiveEndGreater);
		STDMETHODIMP	get_ActivePoint(ITextPoint** ppActivePoint);
		STDMETHODIMP	get_AnchorPoint(ITextPoint** ppAnchorPoint);
		STDMETHODIMP	get_BottomPoint(ITextPoint** ppBottomPoint);
		STDMETHODIMP	get_Empty(VARIANT_BOOL* pbEmpty);
		STDMETHODIMP	get_Text(BSTR* pbstrText);
		STDMETHODIMP	get_TextRanges(ITextRanges** ppTextRanges);
		STDMETHODIMP	get_TopPoint(ITextPoint** ppTopPoint);
		STDMETHODIMP	Cancel();
		STDMETHODIMP	CharNext(VARIANT_BOOL bExtend = VARIANT_FALSE, long cch = 1);
		STDMETHODIMP	CharPrev(VARIANT_BOOL bExtend = VARIANT_FALSE, long cch = 1);
		STDMETHODIMP	Convert(ConvertType ct);
		STDMETHODIMP	Copy(VARIANT_BOOL bAlsoSendToClipboardRing = VARIANT_TRUE);
		STDMETHODIMP	Cut(VARIANT_BOOL bAlsoSendToClipboardRing = VARIANT_TRUE);
		STDMETHODIMP	Indent();
		STDMETHODIMP	LineDown(VARIANT_BOOL bExtend = VARIANT_FALSE, long cLines = 1);
		STDMETHODIMP	LineUp(VARIANT_BOOL bExtend = VARIANT_FALSE, long cLines = 1);
		STDMETHODIMP	MoveTo(long iLine, long iChar, VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	MoveToEndOfDocument(VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	MoveToEndOfLine(VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	MoveToFirstCharOfLine(VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	MoveToLastCharOfLine(VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	MoveToMatchBracket(VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	MoveToNextBookmark(VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	MoveToPreviousBookmark(VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	MoveToStartOfDocument(VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	MoveToStartOfLine(VARIANT_BOOL bToFirstText = VARIANT_FALSE, VARIANT_BOOL bExtend = VARIANT_FALSE);
		STDMETHODIMP	PageDown(VARIANT_BOOL bExtend = VARIANT_FALSE, long cPages = 1);
		STDMETHODIMP	PageUp(VARIANT_BOOL bExtend = VARIANT_FALSE, long cPages = 1);
		STDMETHODIMP	Paste();
		STDMETHODIMP	PasteFromClipboardRing();
		STDMETHODIMP	Replace(BSTR bstrText);
		STDMETHODIMP	SelectAll();
		STDMETHODIMP	SelectLine(long iLine);
		STDMETHODIMP	SetBookmark(VARIANT_BOOL bSet = VARIANT_TRUE);
		STDMETHODIMP	SwapAnchor();
		STDMETHODIMP	Tabify();
		STDMETHODIMP	Unindent();
		STDMETHODIMP	Untabify();
		STDMETHODIMP	WordEndNext(VARIANT_BOOL bExtend = VARIANT_FALSE, long cWords = 1);
		STDMETHODIMP	WordEndPrev(VARIANT_BOOL bExtend = VARIANT_FALSE, long cWords = 1);
		STDMETHODIMP	WordNext(VARIANT_BOOL bExtend = VARIANT_FALSE, long cWords = 1);
		STDMETHODIMP	WordPrev(VARIANT_BOOL bExtend = VARIANT_FALSE, long cWords = 1);

		// f[^o
	private:
		friend class CAlphaView;
		CAlphaView&	m_view;
	};


	/// ITextPoint  IEditPoint ̎
	class CTextPoint : AmbientObjectBaseSupportIdentity(IEditPoint) {
		// RXgN^
	public:
		CTextPoint(Ascension::CVisualPoint& pos, bool bIsEditPoint);
		virtual ~CTextPoint();

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEditPoint)
			IMPLEMENTS_INTERFACE(ITextPoint)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IObjectIdentity C^[tFCX
		STDMETHODIMP	IsEqualObject(IUnknown* punk);

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// ITextPoint C^[tFCX
		STDMETHODIMP	get_AbsoluteCharOffset(long* pnAbsoluteCharOffset);
		STDMETHODIMP	get_AtEndOfDocument(VARIANT_BOOL* pbAtEndOfDocument);
		STDMETHODIMP	get_AtEndOfLine(VARIANT_BOOL* pbAtEndOfLine);
		STDMETHODIMP	get_AtFirstCharOfLine(VARIANT_BOOL* pbAtFirstCharOfLine);
		STDMETHODIMP	get_AtLastCharOfLine(VARIANT_BOOL* pbAtLastCharOfLine);
		STDMETHODIMP	get_AtStartOfDocument(VARIANT_BOOL* pbAtStartOfDocument);
		STDMETHODIMP	get_AtStartOfLine(VARIANT_BOOL* pbAtStartOfLine);
		STDMETHODIMP	get_Char(long* pnChar);
		STDMETHODIMP	get_Column(long* pnColumn);
		STDMETHODIMP	get_Line(long* pnLine);
		STDMETHODIMP	get_LineLength(long* pnLineLength);
		STDMETHODIMP	Center(VARIANT other, VARIANT_BOOL* pbInEditorRect);
		STDMETHODIMP	CreateEditPoint(IEditPoint** ppEditPoint);
		STDMETHODIMP	EqualTo(ITextPoint* pTextPoint, VARIANT_BOOL* pbEqual);
		STDMETHODIMP	GreaterThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbGreater);
		STDMETHODIMP	LessThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbLess);
		STDMETHODIMP	Reveal(VARIANT other, VARIANT_BOOL* pbInEditorRect);

		// IEditPoint C^[tFCX
		STDMETHODIMP	get_CharCountConvention(CharCountConvention* pConvention);
		STDMETHODIMP	put_CharCountConvention(CharCountConvention convention);
		STDMETHODIMP	get_RestrictionExclusive(VARIANT_BOOL* pbExclusive);
		STDMETHODIMP	put_RestrictionExclusive(VARIANT_BOOL pExclusive);
		STDMETHODIMP	CharNext(long cch = 1);
		STDMETHODIMP	CharPrev(long cch = 1);
		STDMETHODIMP	Convert(ConvertType ct, VARIANT other);
		STDMETHODIMP	Copy(VARIANT other);
		STDMETHODIMP	Cut(VARIANT other);
		STDMETHODIMP	Delete(VARIANT other);
		STDMETHODIMP	DestructiveInsert(BSTR bstrText);
		STDMETHODIMP	GetText(VARIANT other, BSTR* pbstrText);
		STDMETHODIMP	Indent(VARIANT other, short nLevel = 1);
		STDMETHODIMP	Insert(BSTR bstrText);
		STDMETHODIMP	LineDown(long cLines = 1);
		STDMETHODIMP	LineUp(long cLines = 1);
		STDMETHODIMP	MoveTo(long iLine, long iChar);
		STDMETHODIMP	MoveToAbsoluteOffset(long nOffset);
		STDMETHODIMP	MoveToEndOfDocument();
		STDMETHODIMP	MoveToEndOfLine();
		STDMETHODIMP	MoveToFirstCharOfLine();
		STDMETHODIMP	MoveToLastCharOfLine();
		STDMETHODIMP	MoveToNextBookmark();
		STDMETHODIMP	MoveToPreviousBookmark();
		STDMETHODIMP	MoveToStartOfDocument();
		STDMETHODIMP	MoveToStartOfLine();
		STDMETHODIMP	NewLine();
		STDMETHODIMP	PageDown(long cPages = 1);
		STDMETHODIMP	PageUp(long cPages = 1);
		STDMETHODIMP	Paste(VARIANT other);
		STDMETHODIMP	Replace(BSTR bstrText, VARIANT other);
		STDMETHODIMP	SetBookmark(VARIANT_BOOL bSet = VARIANT_TRUE);
		STDMETHODIMP	TransposeChars();
		STDMETHODIMP	TransposeLines();
		STDMETHODIMP	TransposeParagraphs();
		STDMETHODIMP	TransposeWords();
		STDMETHODIMP	Unindent(VARIANT other, short nLevel = 1);
		STDMETHODIMP	WordEndNext(long cWords = 1);
		STDMETHODIMP	WordEndPrev(long cWords = 1);
		STDMETHODIMP	WordNext(long cWords = 1);
		STDMETHODIMP	WordPrev(long cWords = 1);

		// f[^o
	private:
		Ascension::CVisualPoint&	m_pos;
		const bool					m_bIsEditPoint;
	};


	/// ITextRange ̎
	class CTextRange : AmbientObjectBaseSupportIdentity(ITextRange) {
		// RXgN^
	public:
		CTextRange(Ascension::CEditPoint& pos1, Ascension::CEditPoint& pos2);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ITextRange)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IObjectIdentity C^[tFCX
		STDMETHODIMP	IsEqualObject(IUnknown* punk);

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// ITextRange C^[tFCX
		STDMETHODIMP	get_EndPoint(ITextPoint** ppEndPoint);
		STDMETHODIMP	get_StartPoint(ITextPoint **ppStartPoint);

		// f[^o
	private:
		Ascension::CEditPoint&	m_pos1;
		Ascension::CEditPoint&	m_pos2;
	};


	/// ILexer ̎
	class CLexer : AmbientObjectBase(ILexer), public CDisposable<CAlphaView> {
		// RXgN^
	public:
		CLexer(Ascension::CLexer& impl);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ILexer)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// ILexer C^[tFCX
		STDMETHODIMP	get_BackSolidusEscapeEnabled(VARIANT_BOOL* pbEnabled);
		STDMETHODIMP	put_BackSolidusEscapeEnabled(VARIANT_BOOL bEnabled);
		STDMETHODIMP	get_CaseSensitive(VARIANT_BOOL* pbCaseSensitive);
		STDMETHODIMP	put_CaseSensitive(VARIANT_BOOL bCaseSensitive);
		STDMETHODIMP	get_Freezed(VARIANT_BOOL* pbFreeze);
		STDMETHODIMP	put_Freezed(VARIANT_BOOL bFreeze);
		STDMETHODIMP	get_NumberFormat(NumberFormat* pNumberFormat);
		STDMETHODIMP	put_NumberFormat(NumberFormat numberFormat);
		STDMETHODIMP	get_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL* pbEnabled);
		STDMETHODIMP	put_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL bEnabled);
		STDMETHODIMP	get_UnicodeAlphabetsEnabled(VARIANT_BOOL* pbEnabled);
		STDMETHODIMP	put_UnicodeAlphabetsEnabled(VARIANT_BOOL bEnabled);
		STDMETHODIMP	get_UnicodeWhiteSpacesEnabled(VARIANT_BOOL* pbEnabled);
		STDMETHODIMP	put_UnicodeWhiteSpacesEnabled(VARIANT_BOOL bEnabled);
		STDMETHODIMP	AddKeywords(BSTR bstrKeywords, long* pnIdentifier);
		STDMETHODIMP	AddMultilineAnnotation(BSTR bstrStartDelimiter,
							BSTR bstrEndDelimiter, AnnotationConstraint constraint, long* pnIdentifier);
		STDMETHODIMP	AddSinglelineAnnotation(BSTR bstrStartDelimiter,
							BSTR bstrEndDelimiter, AnnotationConstraint constraint, long* pnIdentifier);
		STDMETHODIMP	RemoveAll();
		STDMETHODIMP	RemoveIdentifiedToken(long nIdentified);
		STDMETHODIMP	SetAdditionalAlphabets(BSTR bstrAlphabets);
		STDMETHODIMP	SetBrackets(BSTR bstrOpeners);
		STDMETHODIMP	SetOperators(BSTR bstrOperators);

		// f[^o
	private:
		friend class CAlphaView;
		Ascension::CLexer&	m_impl;
	};


	/// IEditorPreferences ̎
	class CEditorPreferences : AmbientObjectBase(IEditorPreferences), public CDisposable<CAlphaView> {
		// RXgN^
	public:
		CEditorPreferences(Ascension::CEditView& view);

		// \bh
	public:
		// IUnknown \bh
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEditorPreferences)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch \bh
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IEditorPreferences \bh
		STDMETHODIMP	get_CharSpan(short* pnCharSpan);
		STDMETHODIMP	put_CharSpan(short nCharSpan);
		STDMETHODIMP	get_CheckInputSequence(BSTR bstrLanguage, VARIANT_BOOL* pbCheck);
		STDMETHODIMP	put_CheckInputSequence(BSTR bstrLanguage, VARIANT_BOOL bCheck);
		STDMETHODIMP	get_CloseBoldChars(VARIANT_BOOL* pbCloseBoldChars);
		STDMETHODIMP	put_CloseBoldChars(VARIANT_BOOL bCloseBoldChars);
		STDMETHODIMP	get_EndOfFileLabel(BSTR* pbstrEndOfFileLabel);
		STDMETHODIMP	put_EndOfFileLabel(BSTR bstrEndOfFileLabel);
		STDMETHODIMP	get_GeneralWhiteSpaceSubstitutionChar(long* pcp);
		STDMETHODIMP	put_GeneralWhiteSpaceSubstitutionChar(long cp);
		STDMETHODIMP	get_HorizontalTabSubstitutionChar(long* pcp);
		STDMETHODIMP	put_HorizontalTabSubstitutionChar(long cp);
		STDMETHODIMP	get_IdeographicSpaceSubstitutionChar(long* pcp);
		STDMETHODIMP	put_IdeographicSpaceSubstitutionChar(long cp);
		STDMETHODIMP	get_LeadMargin(short* pnLeadMargin);
		STDMETHODIMP	put_LeadMargin(short nLeadMargin);
		STDMETHODIMP	get_LexicalParsingEnabled(VARIANT_BOOL* pbEnabled);
		STDMETHODIMP	put_LexicalParsingEnabled(VARIANT_BOOL bEnabled);
		STDMETHODIMP	get_LineBreakSubstitutionChar(::LineBreak lineBreak, long* pcp);
		STDMETHODIMP	put_LineBreakSubstitutionChar(::LineBreak lineBreak, long cp);
		STDMETHODIMP	get_LineNumberBorderStyle(BorderType* pStyle);
		STDMETHODIMP	put_LineNumberBorderStyle(BorderType style);
		STDMETHODIMP	get_LineNumberBorderWidth(short* pnWidth);
		STDMETHODIMP	put_LineNumberBorderWidth(short nWidth);
		STDMETHODIMP	get_LineSpan(short* pnLineSpan);
		STDMETHODIMP	put_LineSpan(short nLineSpan);
		STDMETHODIMP	get_MatchBracketScanLines(long* pcLines);
		STDMETHODIMP	put_MatchBracketScanLines(long cLines);
		STDMETHODIMP	get_PerformBidirection(VARIANT_BOOL* pbPerform);
		STDMETHODIMP	put_PerformBidirection(VARIANT_BOOL bPerform);
		STDMETHODIMP	get_ResetDirectionByTokens(VARIANT_BOOL* pbResetDirByTokens);
		STDMETHODIMP	put_ResetDirectionByTokens(VARIANT_BOOL bResetDirByTokens);
		STDMETHODIMP	get_RightToLeftReading(VARIANT_BOOL* pbRightToLeft);
		STDMETHODIMP	put_RightToLeftReading(VARIANT_BOOL bRightToLeft);
		STDMETHODIMP	get_SelectEndOfLine(VARIANT_BOOL* pbSelectEndOfLine);
		STDMETHODIMP	put_SelectEndOfLine(VARIANT_BOOL bSelectEndOfLine);
		STDMETHODIMP	get_ShowBidirectionalFormatters(VARIANT_BOOL* pbShow);
		STDMETHODIMP	put_ShowBidirectionalFormatters(VARIANT_BOOL bShow);
		STDMETHODIMP	get_ShowCurrentUnderline(VARIANT_BOOL* pbShow);
		STDMETHODIMP	put_ShowCurrentUnderline(VARIANT_BOOL bShow);
		STDMETHODIMP	get_ShowEndOfFile(VARIANT_BOOL* pbShow);
		STDMETHODIMP	put_ShowEndOfFile(VARIANT_BOOL bShow);
		STDMETHODIMP	get_ShowEndOfLine(VARIANT_BOOL* pbShow);
		STDMETHODIMP	put_ShowEndOfLine(VARIANT_BOOL bShow);
		STDMETHODIMP	get_ShowHandOnLink(VARIANT_BOOL* pbShow);
		STDMETHODIMP	put_ShowHandOnLink(VARIANT_BOOL bShow);
		STDMETHODIMP	get_ShowHintOnLink(VARIANT_BOOL* pbShow);
		STDMETHODIMP	put_ShowHintOnLink(VARIANT_BOOL bShow);
		STDMETHODIMP	get_ShowIndicatorMargin(VARIANT_BOOL* pbShow);
		STDMETHODIMP	put_ShowIndicatorMargin(VARIANT_BOOL bShow);
		STDMETHODIMP	get_ShowLineNumber(VARIANT_BOOL* pbShow);
		STDMETHODIMP	put_ShowLineNumber(VARIANT_BOOL bShow);
		STDMETHODIMP	get_ShowWhiteSpaceAlternative(VARIANT_BOOL* pbShow);
		STDMETHODIMP	put_ShowWhiteSpaceAlternative(VARIANT_BOOL bShow);
		STDMETHODIMP	get_StartCharNumber(long* pnStartCharNumber);
		STDMETHODIMP	put_StartCharNumber(long nStartCharNumber);
		STDMETHODIMP	get_StartLineNumber(long* pnStartLineNumber);
		STDMETHODIMP	put_StartLineNumber(long nStartLineNumber);
		STDMETHODIMP	get_TabWidth(short* pnTabWidth);
		STDMETHODIMP	put_TabWidth(short nTabWidth);
		STDMETHODIMP	get_ThinCaret(VARIANT_BOOL* pbThinCaret);
		STDMETHODIMP	put_ThinCaret(VARIANT_BOOL bThinCaret);
		STDMETHODIMP	get_TokenDecoration(BSTR bstrTokenTypeName, ITokenDecoration** ppTokenDecoration);
		STDMETHODIMP	get_TopMargin(short* pnTopMargin);
		STDMETHODIMP	put_TopMargin(short nTopMargin);
		STDMETHODIMP	get_UseEditorFontForCompletion(VARIANT_BOOL* pbUse);
		STDMETHODIMP	put_UseEditorFontForCompletion(VARIANT_BOOL bUse);
		STDMETHODIMP	get_WrapMode(WrapMode* pWrapMode);
		STDMETHODIMP	put_WrapMode(WrapMode wrapMode);
		STDMETHODIMP	get_WrapWidth(short* pnWrapWidth);
		STDMETHODIMP	put_WrapWidth(short nWrapWidth);
		STDMETHODIMP	Reset();

		// f[^o
	private:
		friend class CAlphaView;
		Ascension::CEditView&	m_view;
	};


	/// ITokenDecoration ̎
	class CTokenDecoration : AmbientObjectBase(ITokenDecoration) {
		// RXgN^
	public:
		CTokenDecoration(Ascension::CEditView& view, int nTokenType, Ascension::TokenCookie nTokenCookie = Ascension::NullCookie);

		// \bh
	public:
		// IUnknown \bh
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ITokenDecoration)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch \bh
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// ITokenDecoration \bh
		STDMETHODIMP	get_Color(long* pnColor);
		STDMETHODIMP	put_Color(long nColor);
		STDMETHODIMP	get_BackgroundColor(long* pnColor);
		STDMETHODIMP	put_BackgroundColor(long nColor);
		STDMETHODIMP	get_BoldFont(VARIANT_BOOL* pbBold);
		STDMETHODIMP	put_BoldFont(VARIANT_BOOL bBold);
		STDMETHODIMP	get_ItalicFont(VARIANT_BOOL* pbItalic);
		STDMETHODIMP	put_ItalicFont(VARIANT_BOOL bItalic);
		STDMETHODIMP	get_BorderStyle(BorderType* pBorderType);
		STDMETHODIMP	put_BorderStyle(BorderType borderType);
		STDMETHODIMP	get_BorderColor(long* pnColor);
		STDMETHODIMP	put_BorderColor(long nColor);

		// f[^o
	private:
		Ascension::CEditView&	m_view;
		int						m_nTokenType;
		Ascension::TokenCookie	m_nTokenCookie;
	};


	/// ISearchOptions ̎
	class CSearchOptions : AmbientObjectBase(ISearchOptions) {
		// \bh
	public:
		// IUnknown \bh
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ISearchOptions)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch \bh
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// ITextSearcher \bh
		STDMETHODIMP	get_CaseSensitivity(CaseFoldingType* pCaseFoldingType);
		STDMETHODIMP	put_CaseSensitivity(CaseFoldingType caseFoldingType);
		STDMETHODIMP	get_CharacterSkipOption(CharacterSkipType* pOptions);
		STDMETHODIMP	put_CharacterSkipOption(CharacterSkipType options);
		STDMETHODIMP	get_FoldingOption(FoldingType* pOptions);
		STDMETHODIMP	put_FoldingOption(FoldingType options);
		STDMETHODIMP	get_MultigraphExpansionOption(MultigraphExpansionType* pOptions);
		STDMETHODIMP	put_MultigraphExpansionOption(MultigraphExpansionType options);
		STDMETHODIMP	get_OnlyIdentifiers(VARIANT_BOOL* pbOnlyIdentifiers);
		STDMETHODIMP	put_OnlyIdentifiers(VARIANT_BOOL bOnlyIdentifiers);
		STDMETHODIMP	get_SearchType(SearchType* pType);
		STDMETHODIMP	put_SearchType(SearchType type);
		STDMETHODIMP	get_WholeWord(VARIANT_BOOL* pbWholeWord);
		STDMETHODIMP	put_WholeWord(VARIANT_BOOL bWholeWord);
		STDMETHODIMP	BookmarkAll(long* pcFound);
		STDMETHODIMP	FindNext(VARIANT_BOOL* pbFound);
		STDMETHODIMP	FindPrev(VARIANT_BOOL* pbFound);
		STDMETHODIMP	ReplaceAll(long* pcReplaced);
		STDMETHODIMP	ReplaceAndNext(VARIANT_BOOL* pbFound);
		STDMETHODIMP	ReplaceAndPrev(VARIANT_BOOL* pbFound);

		// f[^o
	private:
		Ascension::TSearchOptions	m_options;
	};


	/// IConfigurations ̎
	class CConfigurations : AmbientObjectBase(IConfigurations) {
		// RXgN^
	public:
		CConfigurations(CAlphaApp& app);

		// \bh
	public:
		// IUnknown \bh
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IConfigurations)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch \bh
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IConfigurations \bh
		STDMETHODIMP	get__NewEnum(IUnknown** ppEnum);
		STDMETHODIMP	get_KeyboardSchemes(BSTR bstrScopeName, IKeyboardScheme** ppKeyboardScheme);
		STDMETHODIMP	get_Property(BSTR bstrName, BSTR* pbstrValue);
		STDMETHODIMP	put_Property(BSTR bstrName, BSTR bstrValue);
		STDMETHODIMP	AddDocumentType(BSTR bstrName, BSTR bstrFileSpec,
							BSTR bstrCommand = 0, VARIANT_BOOL bPrivate = VARIANT_FALSE);
		STDMETHODIMP	Apply();
		STDMETHODIMP	RemoveAllDocumentTypes();

		// f[^o
	private:
		CAlphaApp&								m_app;
		std::map<std::wstring, std::wstring>	m_modifiedProperties;	// ύXꂽvpeB
	};


	/// IKeyboardScheme ̎
	class CKeyboardScheme : AmbientObjectBase(IKeyboardScheme) {
		friend class CConfigurations;

		// RXgN^
	public:
		CKeyboardScheme(CKeyboardMap& impl);

		// \bh
	public:
		// IUnknown \bh
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IKeyboardScheme)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch \bh
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IKeyboardScheme \bh
		STDMETHODIMP	get_Name(BSTR* pbstrName);
		STDMETHODIMP	Assign(BSTR bstrKeyCombination, VARIANT command, VARIANT_BOOL* pbOverridden);
		STDMETHODIMP	Load(BSTR bstrSchemeName);
		STDMETHODIMP	Save(BSTR bstrSchemeName);
		STDMETHODIMP	Unassign(BSTR bstrKeyCombination);

	private:
		static bool	_ParseKeyCombinationString(const BSTR bstr,
						TKeyCombination& firstKeys, TKeyCombination& secondKeys);

		// f[^o
	private:
		CKeyboardMap&								m_impl;
		std::wstring								m_strSchemeName;
		static std::map<std::wstring, VirtualKey>	m_keyValues;
	};


	/// ICommand ̎
	class CCommand : AmbientObjectBaseSupportIdentity(ICommand) {
		// RXgN^
	public:
		CCommand(CAlphaApp& app, CommandId id);

		// IUnknown \bh
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(ICommand)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IObjectIdentity C^[tFCX
		STDMETHODIMP	IsEqualObject(IUnknown* punk);

		// IDispatch \bh
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// ICommand \bh
		STDMETHODIMP	get_Checked(VARIANT_BOOL* pbChecked);
		STDMETHODIMP	get_Description(BSTR* pbstrDescription);
		STDMETHODIMP	get_Enabled(VARIANT_BOOL* pbEnabled);
		STDMETHODIMP	get_Id(long* pnId);
		STDMETHODIMP	get_KeyCombination(BSTR* pbstrKeys);
		STDMETHODIMP	get_Name(BSTR* pbstrName);
		STDMETHODIMP	Execute();

		// f[^o
	private:
		CAlphaApp&		m_app;
		const CommandId	m_id;
	};


	/// IClipboardRing ̎
	class CClipboardRing : AmbientObjectBaseSupportIdentity(IClipboardRing) {
		// RXgN^
	public:
		CClipboardRing(Ascension::CClipboardRing& impl);

		// IUnknown \bh
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IClipboardRing)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IObjectIdentity C^[tFCX
		STDMETHODIMP	IsEqualObject(IUnknown* punk);

		// IDispatch \bh
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IClipboardRing \bh
		STDMETHODIMP	get_Count(short* pnCount);
		STDMETHODIMP	get_Text(short nIndex, BSTR* pbstrText);
		STDMETHODIMP	Add(BSTR bstrText);
		STDMETHODIMP	Delete(short nIndex);
		STDMETHODIMP	DeleteAll();
		STDMETHODIMP	LimitCount(short nLimit);

		// f[^o
	private:
		Ascension::CClipboardRing&	m_impl;
	};


	/// IAbbreviations ̎
	class CAbbreviations : AmbientObjectBaseSupportIdentity(IAbbreviations) {
		// RXgN^
	public:
		CAbbreviations() :
				Armaiti::IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>(INTERFACESAFE_FOR_UNTRUSTED_CALLER) {
		}

		// \bh
	public:
		// IUnknown \bh
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IAbbreviations)
			IMPLEMENTS_INTERFACE(IObjectIdentity)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IObjectIdentity C^[tFCX
		STDMETHODIMP	IsEqualObject(IUnknown* punk);

		// IDispatch \bh
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IAbbreviations \bh
		STDMETHODIMP	get__NewEnum(IUnknown** ppEnum);
		STDMETHODIMP	Expand(BSTR bstrAbbrev, BSTR* pbstrExpanded);
		STDMETHODIMP	Register(BSTR bstrAbbrev, BSTR bstrExpanded);
		STDMETHODIMP	Revoke(BSTR bstrAbbrev);
		STDMETHODIMP	RevokeAll();
	};


	/// IScriptHost ̎
	class CScriptHost : AmbientObjectBaseSupportError(IScriptHost) {
		// RXgN^
	public:
		CScriptHost(CAlphaScriptHost* pImpl);
		virtual ~CScriptHost();

		// \bh
	protected:
		DWORD	VerifyCreationObject(CLSID& clsid);
		DWORD	VerifyRunningObject(IUnknown* pUnk, CLSID& clsid);

	public:
		// IUnknown \bh
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IScriptHost)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch \bh
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IScriptHost \bh
		STDMETHODIMP	ConnectObject(IDispatch* pObject, BSTR bstrPrefix);
		STDMETHODIMP	CreateObject(BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject);
		STDMETHODIMP	DisconnectObject(IDispatch* pObject);
		STDMETHODIMP	Echo(SAFEARRAY/*<VARIANT>*/* pArguments);
		STDMETHODIMP	get_Arguments(IArguments** ppArguments);
		STDMETHODIMP	get_BuildVersion(short* pnBuildVersion);
		STDMETHODIMP	get_FullName(BSTR* pbstrFullName);
		STDMETHODIMP	get_Interactive(VARIANT_BOOL* pbInteractive);
		STDMETHODIMP	get_Name(BSTR* pbstrName);
		STDMETHODIMP	get_Path(BSTR* pbstrPath);
		STDMETHODIMP	get_ScriptFullName(BSTR* pbstrScriptFullName);
		STDMETHODIMP	get_ScriptName(BSTR* pbstrScriptName);
		STDMETHODIMP	get_StdErr(IDispatch** ppStdErr);
		STDMETHODIMP	get_StdIn(IDispatch** ppStdIn);
		STDMETHODIMP	get_StdOut(IDispatch** ppStdOut);
		STDMETHODIMP	get_Timeout(long* pnTimeout);
		STDMETHODIMP	get_Version(BSTR* pbstrVersion);
		STDMETHODIMP	put_Interactive(VARIANT_BOOL bInteractive);
		STDMETHODIMP	GetObject(BSTR bstrPathName, BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject);
		STDMETHODIMP	LoadConstants(IDispatch* pObject);
		STDMETHODIMP	Sleep(long nMilliseconds);
		STDMETHODIMP	Quit(short nExitCode = 0);

		// f[^o
	private:
		CAlphaScriptHost*	m_pImpl;
	};


	/// IArguments ̎
	class CArguments : AmbientObjectBase(IArguments) {
		// RXgN^
	public:
		CArguments(const std::vector<std::wstring>& args);

		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IArguments)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// IArguments C^[tFCX
		STDMETHODIMP	get__NewEnum(IUnknown** ppEnum);
		STDMETHODIMP	get_Item(long nIndex, BSTR* pbstrArg);
		STDMETHODIMP	get_Length(long* pcArgs);
		STDMETHODIMP	get_Named(IDispatch** ppNamed);
		STDMETHODIMP	get_Unnamed(IDispatch** ppUnnamed);
		STDMETHODIMP	Count(long* pcArgs);
		STDMETHODIMP	ShowUsage();

		// f[^o
	private:
		std::vector<std::wstring>	m_arguments;
	};


	/// INamedArguments ̎
	class CNamedArguments : AmbientObjectBase(INamedArguments) {
		// RXgN^
	public:
		CNamedArguments(const std::map<std::wstring, std::wstring>& namedArguments);

	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(INamedArguments)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// INamedArguments C^[tFCX
		STDMETHODIMP	get__NewEnum(IUnknown** ppEnum);
		STDMETHODIMP	get_Item(BSTR bstrName, BSTR *pbstrArgument);
		STDMETHODIMP	get_Length(long *pnLength);
		STDMETHODIMP	Count(long *pnCount);
		STDMETHODIMP	Exists(BSTR bstrName, VARIANT_BOOL* pbExists);
		STDMETHODIMP	_NewEnum(IUnknown** ppOut);

		// f[^o
	private:
		std::map<std::wstring, std::wstring>	m_namedArguments;
	};


	/// IUnnamedArguments ̎
	class CUnnamedArguments : AmbientObjectBase(IUnnamedArguments) {
		// RXgN^
	public:
		CUnnamedArguments(const std::vector<std::wstring>& unnamedArguments);

	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_MULTI_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IUnnamedArguments)
			IMPLEMENTS_INTERFACE(IDispatch)
		END_INTERFACE_TABLE()

		// IDispatch C^[tFCX
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// INamedArguments C^[tFCX
		STDMETHODIMP	get__NewEnum(IUnknown** ppEnum);
		STDMETHODIMP	get_Item(long iArgument, BSTR *pbstrArgument);
		STDMETHODIMP	get_Length(long *pnLength);
		STDMETHODIMP	Count(long *pnCount);
		STDMETHODIMP	_NewEnum(IUnknown** ppOut);

		// f[^o
	private:
		std::vector<std::wstring>	m_unnamedArguments;
	};

} /* namespace Ambient */
} /* namespace Alpha */

#pragma warning(default : 4250)
#endif /* _AMBIENT_H_ */

/* [EOF] */